/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright (c) 2014-2018 Broadcom Limited
 * All rights reserved.
 *
 * DO NOT MODIFY!!! This file is automatically generated.
 */

#ifndef _HSI_STRUCT_DEF_DPDK_H_
#define _HSI_STRUCT_DEF_DPDK_H_

/* This is the HWRM command header. */
/* hwrm_cmd_hdr (size:128b/16B) */
struct hwrm_cmd_hdr {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* This is the HWRM response header. */
/* hwrm_resp_hdr (size:64b/8B) */
struct hwrm_resp_hdr {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
} __attribute__((packed));

/*
 * TLV encapsulated message. Use the TLV type field of the
 * TLV to determine the type of message encapsulated.
 */
#define CMD_DISCR_TLV_ENCAP UINT32_C(0x8000)
#define CMD_DISCR_LAST     CMD_DISCR_TLV_ENCAP


/* HWRM request message */
#define TLV_TYPE_HWRM_REQUEST                    UINT32_C(0x1)
/* HWRM response message */
#define TLV_TYPE_HWRM_RESPONSE                   UINT32_C(0x2)
/* RoCE slow path command */
#define TLV_TYPE_ROCE_SP_COMMAND                 UINT32_C(0x3)
/* Engine CKV - The device's serial number. */
#define TLV_TYPE_ENGINE_CKV_DEVICE_SERIAL_NUMBER UINT32_C(0x8001)
/* Engine CKV - Per-function random nonce data. */
#define TLV_TYPE_ENGINE_CKV_NONCE                UINT32_C(0x8002)
/* Engine CKV - Initialization vector. */
#define TLV_TYPE_ENGINE_CKV_IV                   UINT32_C(0x8003)
/* Engine CKV - Authentication tag. */
#define TLV_TYPE_ENGINE_CKV_AUTH_TAG             UINT32_C(0x8004)
/* Engine CKV - The encrypted data. */
#define TLV_TYPE_ENGINE_CKV_CIPHERTEXT           UINT32_C(0x8005)
/* Engine CKV - Supported algorithms. */
#define TLV_TYPE_ENGINE_CKV_ALGORITHMS           UINT32_C(0x8006)
/* Engine CKV - The EC curve name and ECC public key information. */
#define TLV_TYPE_ENGINE_CKV_ECC_PUBLIC_KEY       UINT32_C(0x8007)
/* Engine CKV - The ECDSA signature. */
#define TLV_TYPE_ENGINE_CKV_ECDSA_SIGNATURE      UINT32_C(0x8008)
#define TLV_TYPE_LAST \
	TLV_TYPE_ENGINE_CKV_ECDSA_SIGNATURE


/* tlv (size:64b/8B) */
struct tlv {
	/*
	 * The command discriminator is used to differentiate between various
	 * types of HWRM messages. This includes legacy HWRM and RoCE slowpath
	 * command messages as well as newer TLV encapsulated HWRM commands.
	 *
	 * For TLV encapsulated messages this field must be 0x8000.
	 */
	uint16_t	cmd_discr;
	uint8_t	reserved_8b;
	uint8_t	flags;
	/*
	 * Indicates the presence of additional TLV encapsulated data
	 * follows this TLV.
	 */
	#define TLV_FLAGS_MORE         UINT32_C(0x1)
	/* Last TLV in a sequence of TLVs. */
	#define TLV_FLAGS_MORE_LAST      UINT32_C(0x0)
	/* More TLVs follow this TLV. */
	#define TLV_FLAGS_MORE_NOT_LAST  UINT32_C(0x1)
	/*
	 * When an HWRM receiver detects a TLV type that it does not
	 * support with the TLV required flag set, the receiver must
	 * reject the HWRM message with an error code indicating an
	 * unsupported TLV type.
	 */
	#define TLV_FLAGS_REQUIRED     UINT32_C(0x2)
	/* No */
	#define TLV_FLAGS_REQUIRED_NO    (UINT32_C(0x0) << 1)
	/* Yes */
	#define TLV_FLAGS_REQUIRED_YES   (UINT32_C(0x1) << 1)
	#define TLV_FLAGS_REQUIRED_LAST TLV_FLAGS_REQUIRED_YES
	/*
	 * This field defines the TLV type value which is divided into
	 * two ranges to differentiate between global and local TLV types.
	 * Global TLV types must be unique across all defined TLV types.
	 * Local TLV types are valid only for extensions to a given
	 * HWRM message and may be repeated across different HWRM message
	 * types. There is a direct correlation of each HWRM message type
	 * to a single global TLV type value.
	 *
	 * Global TLV range: `0 - (63k-1)`
	 *
	 * Local TLV range: `63k - (64k-1)`
	 */
	uint16_t	tlv_type;
	/*
	 * Length of the message data encapsulated by this TLV in bytes.
	 * This length does not include the size of the TLV header itself
	 * and it must be an integer multiple of 8B.
	 */
	uint16_t	length;
} __attribute__((packed));

/* Input */
/* input (size:128b/16B) */
struct input {
	/*
	 * This value indicates what type of request this is.  The format
	 * for the rest of the command is determined by this field.
	 */
	uint16_t	req_type;
	/*
	 * This value indicates the what completion ring the request will
	 * be optionally completed on.  If the value is -1, then no
	 * CR completion will be generated.  Any other value must be a
	 * valid CR ring_id value for this function.
	 */
	uint16_t	cmpl_ring;
	/* This value indicates the command sequence number. */
	uint16_t	seq_id;
	/*
	 * Target ID of this command.
	 *
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * This is the host address where the response will be written
	 * when the request is complete.  This area must be 16B aligned
	 * and must be cleared to zero before the request is made.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* Output */
/* output (size:64b/8B) */
struct output {
	/*
	 * Pass/Fail or error type
	 *
	 * Note: receiver to verify the in parameters, and fail the call
	 * with an error when appropriate
	 */
	uint16_t	error_code;
	/* This field returns the type of original request. */
	uint16_t	req_type;
	/* This field provides original sequence number of the command. */
	uint16_t	seq_id;
	/*
	 * This field is the length of the response in bytes.  The
	 * last byte of the response is a valid flag that will read
	 * as '1' when the command has been completely written to
	 * memory.
	 */
	uint16_t	resp_len;
} __attribute__((packed));

/* Short Command Structure */
/* hwrm_short_input (size:128b/16B) */
struct hwrm_short_input {
	/*
	 * This field indicates the type of request in the request buffer.
	 * The format for the rest of the command (request) is determined
	 * by this field.
	 */
	uint16_t	req_type;
	/*
	 * This field indicates a signature that is used to identify short
	 * form of the command listed here. This field shall be set to
	 * 17185 (0x4321).
	 */
	uint16_t	signature;
	/* Signature indicating this is a short form of HWRM command */
	#define HWRM_SHORT_INPUT_SIGNATURE_SHORT_CMD UINT32_C(0x4321)
	#define HWRM_SHORT_INPUT_SIGNATURE_LAST \
		HWRM_SHORT_INPUT_SIGNATURE_SHORT_CMD
	/* Reserved for future use. */
	uint16_t	unused_0;
	/* This value indicates the length of the request. */
	uint16_t	size;
	/*
	 * This is the host address where the request was written.
	 * This area must be 16B aligned.
	 */
	uint64_t	req_addr;
} __attribute__((packed));

/*
 * Command numbering
 * # NOTE - definitions already in hwrm_req_type, in hwrm_types.yaml
 * #        So only structure definition is provided here.
 */
/* cmd_nums (size:64b/8B) */
struct cmd_nums {
	/*
	 * This version of the specification defines the commands listed in
	 * the table below. The following are general implementation
	 * requirements for these commands:
	 *
	 * # All commands listed below that are marked neither
	 * reserved nor experimental shall be implemented by the HWRM.
	 * # A HWRM client compliant to this specification should not use
	 * commands outside of the list below.
	 * # A HWRM client compliant to this specification should not use
	 * command numbers marked reserved below.
	 * # A command marked experimental below may not be implemented
	 * by the HWRM.
	 * # A command marked experimental may change in the
	 * future version of the HWRM specification.
	 * # A command not listed below may be implemented by the HWRM.
	 * The behavior of commands that are not listed below is outside
	 * the scope of this specification.
	 */
	uint16_t	req_type;
	#define HWRM_VER_GET                              UINT32_C(0x0)
	#define HWRM_FUNC_BUF_UNRGTR                      UINT32_C(0xe)
	#define HWRM_FUNC_VF_CFG                          UINT32_C(0xf)
	/* Reserved for future use. */
	#define HWRM_RESERVED1                            UINT32_C(0x10)
	#define HWRM_FUNC_RESET                           UINT32_C(0x11)
	#define HWRM_FUNC_GETFID                          UINT32_C(0x12)
	#define HWRM_FUNC_VF_ALLOC                        UINT32_C(0x13)
	#define HWRM_FUNC_VF_FREE                         UINT32_C(0x14)
	#define HWRM_FUNC_QCAPS                           UINT32_C(0x15)
	#define HWRM_FUNC_QCFG                            UINT32_C(0x16)
	#define HWRM_FUNC_CFG                             UINT32_C(0x17)
	#define HWRM_FUNC_QSTATS                          UINT32_C(0x18)
	#define HWRM_FUNC_CLR_STATS                       UINT32_C(0x19)
	#define HWRM_FUNC_DRV_UNRGTR                      UINT32_C(0x1a)
	#define HWRM_FUNC_VF_RESC_FREE                    UINT32_C(0x1b)
	#define HWRM_FUNC_VF_VNIC_IDS_QUERY               UINT32_C(0x1c)
	#define HWRM_FUNC_DRV_RGTR                        UINT32_C(0x1d)
	#define HWRM_FUNC_DRV_QVER                        UINT32_C(0x1e)
	#define HWRM_FUNC_BUF_RGTR                        UINT32_C(0x1f)
	#define HWRM_PORT_PHY_CFG                         UINT32_C(0x20)
	#define HWRM_PORT_MAC_CFG                         UINT32_C(0x21)
	/* Experimental */
	#define HWRM_PORT_TS_QUERY                        UINT32_C(0x22)
	#define HWRM_PORT_QSTATS                          UINT32_C(0x23)
	#define HWRM_PORT_LPBK_QSTATS                     UINT32_C(0x24)
	/* Experimental */
	#define HWRM_PORT_CLR_STATS                       UINT32_C(0x25)
	/* Experimental */
	#define HWRM_PORT_LPBK_CLR_STATS                  UINT32_C(0x26)
	#define HWRM_PORT_PHY_QCFG                        UINT32_C(0x27)
	#define HWRM_PORT_MAC_QCFG                        UINT32_C(0x28)
	/* Experimental */
	#define HWRM_PORT_MAC_PTP_QCFG                    UINT32_C(0x29)
	#define HWRM_PORT_PHY_QCAPS                       UINT32_C(0x2a)
	#define HWRM_PORT_PHY_I2C_WRITE                   UINT32_C(0x2b)
	#define HWRM_PORT_PHY_I2C_READ                    UINT32_C(0x2c)
	#define HWRM_PORT_LED_CFG                         UINT32_C(0x2d)
	#define HWRM_PORT_LED_QCFG                        UINT32_C(0x2e)
	#define HWRM_PORT_LED_QCAPS                       UINT32_C(0x2f)
	#define HWRM_QUEUE_QPORTCFG                       UINT32_C(0x30)
	#define HWRM_QUEUE_QCFG                           UINT32_C(0x31)
	#define HWRM_QUEUE_CFG                            UINT32_C(0x32)
	#define HWRM_FUNC_VLAN_CFG                        UINT32_C(0x33)
	#define HWRM_FUNC_VLAN_QCFG                       UINT32_C(0x34)
	#define HWRM_QUEUE_PFCENABLE_QCFG                 UINT32_C(0x35)
	#define HWRM_QUEUE_PFCENABLE_CFG                  UINT32_C(0x36)
	#define HWRM_QUEUE_PRI2COS_QCFG                   UINT32_C(0x37)
	#define HWRM_QUEUE_PRI2COS_CFG                    UINT32_C(0x38)
	#define HWRM_QUEUE_COS2BW_QCFG                    UINT32_C(0x39)
	#define HWRM_QUEUE_COS2BW_CFG                     UINT32_C(0x3a)
	/* Experimental */
	#define HWRM_QUEUE_DSCP_QCAPS                     UINT32_C(0x3b)
	/* Experimental */
	#define HWRM_QUEUE_DSCP2PRI_QCFG                  UINT32_C(0x3c)
	/* Experimental */
	#define HWRM_QUEUE_DSCP2PRI_CFG                   UINT32_C(0x3d)
	#define HWRM_VNIC_ALLOC                           UINT32_C(0x40)
	#define HWRM_VNIC_FREE                            UINT32_C(0x41)
	#define HWRM_VNIC_CFG                             UINT32_C(0x42)
	#define HWRM_VNIC_QCFG                            UINT32_C(0x43)
	#define HWRM_VNIC_TPA_CFG                         UINT32_C(0x44)
	/* Experimental */
	#define HWRM_VNIC_TPA_QCFG                        UINT32_C(0x45)
	#define HWRM_VNIC_RSS_CFG                         UINT32_C(0x46)
	#define HWRM_VNIC_RSS_QCFG                        UINT32_C(0x47)
	#define HWRM_VNIC_PLCMODES_CFG                    UINT32_C(0x48)
	#define HWRM_VNIC_PLCMODES_QCFG                   UINT32_C(0x49)
	#define HWRM_VNIC_QCAPS                           UINT32_C(0x4a)
	#define HWRM_RING_ALLOC                           UINT32_C(0x50)
	#define HWRM_RING_FREE                            UINT32_C(0x51)
	#define HWRM_RING_CMPL_RING_QAGGINT_PARAMS        UINT32_C(0x52)
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS     UINT32_C(0x53)
	#define HWRM_RING_RESET                           UINT32_C(0x5e)
	#define HWRM_RING_GRP_ALLOC                       UINT32_C(0x60)
	#define HWRM_RING_GRP_FREE                        UINT32_C(0x61)
	/* Reserved for future use. */
	#define HWRM_RESERVED5                            UINT32_C(0x64)
	/* Reserved for future use. */
	#define HWRM_RESERVED6                            UINT32_C(0x65)
	#define HWRM_VNIC_RSS_COS_LB_CTX_ALLOC            UINT32_C(0x70)
	#define HWRM_VNIC_RSS_COS_LB_CTX_FREE             UINT32_C(0x71)
	#define HWRM_CFA_L2_FILTER_ALLOC                  UINT32_C(0x90)
	#define HWRM_CFA_L2_FILTER_FREE                   UINT32_C(0x91)
	#define HWRM_CFA_L2_FILTER_CFG                    UINT32_C(0x92)
	#define HWRM_CFA_L2_SET_RX_MASK                   UINT32_C(0x93)
	#define HWRM_CFA_VLAN_ANTISPOOF_CFG               UINT32_C(0x94)
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC              UINT32_C(0x95)
	#define HWRM_CFA_TUNNEL_FILTER_FREE               UINT32_C(0x96)
	/* Experimental */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC               UINT32_C(0x97)
	/* Experimental */
	#define HWRM_CFA_ENCAP_RECORD_FREE                UINT32_C(0x98)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC              UINT32_C(0x99)
	#define HWRM_CFA_NTUPLE_FILTER_FREE               UINT32_C(0x9a)
	#define HWRM_CFA_NTUPLE_FILTER_CFG                UINT32_C(0x9b)
	/* Experimental */
	#define HWRM_CFA_EM_FLOW_ALLOC                    UINT32_C(0x9c)
	/* Experimental */
	#define HWRM_CFA_EM_FLOW_FREE                     UINT32_C(0x9d)
	/* Experimental */
	#define HWRM_CFA_EM_FLOW_CFG                      UINT32_C(0x9e)
	#define HWRM_TUNNEL_DST_PORT_QUERY                UINT32_C(0xa0)
	#define HWRM_TUNNEL_DST_PORT_ALLOC                UINT32_C(0xa1)
	#define HWRM_TUNNEL_DST_PORT_FREE                 UINT32_C(0xa2)
	#define HWRM_STAT_CTX_ALLOC                       UINT32_C(0xb0)
	#define HWRM_STAT_CTX_FREE                        UINT32_C(0xb1)
	#define HWRM_STAT_CTX_QUERY                       UINT32_C(0xb2)
	#define HWRM_STAT_CTX_CLR_STATS                   UINT32_C(0xb3)
	#define HWRM_PORT_QSTATS_EXT                      UINT32_C(0xb4)
	#define HWRM_FW_RESET                             UINT32_C(0xc0)
	#define HWRM_FW_QSTATUS                           UINT32_C(0xc1)
	/* Experimental */
	#define HWRM_FW_SET_TIME                          UINT32_C(0xc8)
	/* Experimental */
	#define HWRM_FW_GET_TIME                          UINT32_C(0xc9)
	/* Experimental */
	#define HWRM_FW_SET_STRUCTURED_DATA               UINT32_C(0xca)
	/* Experimental */
	#define HWRM_FW_GET_STRUCTURED_DATA               UINT32_C(0xcb)
	/* Experimental */
	#define HWRM_FW_IPC_MAILBOX                       UINT32_C(0xcc)
	#define HWRM_EXEC_FWD_RESP                        UINT32_C(0xd0)
	#define HWRM_REJECT_FWD_RESP                      UINT32_C(0xd1)
	#define HWRM_FWD_RESP                             UINT32_C(0xd2)
	#define HWRM_FWD_ASYNC_EVENT_CMPL                 UINT32_C(0xd3)
	#define HWRM_OEM_CMD                              UINT32_C(0xd4)
	#define HWRM_TEMP_MONITOR_QUERY                   UINT32_C(0xe0)
	#define HWRM_WOL_FILTER_ALLOC                     UINT32_C(0xf0)
	#define HWRM_WOL_FILTER_FREE                      UINT32_C(0xf1)
	#define HWRM_WOL_FILTER_QCFG                      UINT32_C(0xf2)
	#define HWRM_WOL_REASON_QCFG                      UINT32_C(0xf3)
	/* Experimental */
	#define HWRM_CFA_METER_PROFILE_ALLOC              UINT32_C(0xf5)
	/* Experimental */
	#define HWRM_CFA_METER_PROFILE_FREE               UINT32_C(0xf6)
	/* Experimental */
	#define HWRM_CFA_METER_PROFILE_CFG                UINT32_C(0xf7)
	/* Experimental */
	#define HWRM_CFA_METER_INSTANCE_ALLOC             UINT32_C(0xf8)
	/* Experimental */
	#define HWRM_CFA_METER_INSTANCE_FREE              UINT32_C(0xf9)
	/* Experimental */
	#define HWRM_CFA_VFR_ALLOC                        UINT32_C(0xfd)
	/* Experimental */
	#define HWRM_CFA_VFR_FREE                         UINT32_C(0xfe)
	/* Experimental */
	#define HWRM_CFA_VF_PAIR_ALLOC                    UINT32_C(0x100)
	/* Experimental */
	#define HWRM_CFA_VF_PAIR_FREE                     UINT32_C(0x101)
	/* Experimental */
	#define HWRM_CFA_VF_PAIR_INFO                     UINT32_C(0x102)
	/* Experimental */
	#define HWRM_CFA_FLOW_ALLOC                       UINT32_C(0x103)
	/* Experimental */
	#define HWRM_CFA_FLOW_FREE                        UINT32_C(0x104)
	/* Experimental */
	#define HWRM_CFA_FLOW_FLUSH                       UINT32_C(0x105)
	/* Experimental */
	#define HWRM_CFA_FLOW_STATS                       UINT32_C(0x106)
	/* Experimental */
	#define HWRM_CFA_FLOW_INFO                        UINT32_C(0x107)
	/* Experimental */
	#define HWRM_CFA_DECAP_FILTER_ALLOC               UINT32_C(0x108)
	/* Experimental */
	#define HWRM_CFA_DECAP_FILTER_FREE                UINT32_C(0x109)
	#define HWRM_CFA_VLAN_ANTISPOOF_QCFG              UINT32_C(0x10a)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC       UINT32_C(0x10b)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE        UINT32_C(0x10c)
	/* Experimental */
	#define HWRM_CFA_PAIR_ALLOC                       UINT32_C(0x10d)
	/* Experimental */
	#define HWRM_CFA_PAIR_FREE                        UINT32_C(0x10e)
	/* Experimental */
	#define HWRM_CFA_PAIR_INFO                        UINT32_C(0x10f)
	/* Experimental */
	#define HWRM_FW_IPC_MSG                           UINT32_C(0x110)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO        UINT32_C(0x111)
	/* Engine CKV - Ping the device and SRT firmware to get the public key. */
	#define HWRM_ENGINE_CKV_HELLO                     UINT32_C(0x12d)
	/* Engine CKV - Get the current allocation status of keys provisioned in the key vault. */
	#define HWRM_ENGINE_CKV_STATUS                    UINT32_C(0x12e)
	/* Engine CKV - Add a new CKEK used to encrypt keys. */
	#define HWRM_ENGINE_CKV_CKEK_ADD                  UINT32_C(0x12f)
	/* Engine CKV - Delete a previously added CKEK. */
	#define HWRM_ENGINE_CKV_CKEK_DELETE               UINT32_C(0x130)
	/* Engine CKV - Add a new key to the key vault. */
	#define HWRM_ENGINE_CKV_KEY_ADD                   UINT32_C(0x131)
	/* Engine CKV - Delete a key from the key vault. */
	#define HWRM_ENGINE_CKV_KEY_DELETE                UINT32_C(0x132)
	/* Engine CKV - Delete all keys from the key vault. */
	#define HWRM_ENGINE_CKV_FLUSH                     UINT32_C(0x133)
	/* Engine CKV - Get random data. */
	#define HWRM_ENGINE_CKV_RNG_GET                   UINT32_C(0x134)
	/* Engine CKV - Generate and encrypt a new AES key. */
	#define HWRM_ENGINE_CKV_KEY_GEN                   UINT32_C(0x135)
	/* Engine - Query the available queue groups configuration. */
	#define HWRM_ENGINE_QG_CONFIG_QUERY               UINT32_C(0x13c)
	/* Engine - Query the queue groups assigned to a function. */
	#define HWRM_ENGINE_QG_QUERY                      UINT32_C(0x13d)
	/* Engine - Query the available queue group meter profile configuration. */
	#define HWRM_ENGINE_QG_METER_PROFILE_CONFIG_QUERY UINT32_C(0x13e)
	/* Engine - Query the configuration of a queue group meter profile. */
	#define HWRM_ENGINE_QG_METER_PROFILE_QUERY        UINT32_C(0x13f)
	/* Engine - Allocate a queue group meter profile. */
	#define HWRM_ENGINE_QG_METER_PROFILE_ALLOC        UINT32_C(0x140)
	/* Engine - Free a queue group meter profile. */
	#define HWRM_ENGINE_QG_METER_PROFILE_FREE         UINT32_C(0x141)
	/* Engine - Query the meters assigned to a queue group. */
	#define HWRM_ENGINE_QG_METER_QUERY                UINT32_C(0x142)
	/* Engine - Bind a queue group meter profile to a queue group. */
	#define HWRM_ENGINE_QG_METER_BIND                 UINT32_C(0x143)
	/* Engine - Unbind a queue group meter profile from a queue group. */
	#define HWRM_ENGINE_QG_METER_UNBIND               UINT32_C(0x144)
	/* Engine - Bind a queue group to a function. */
	#define HWRM_ENGINE_QG_FUNC_BIND                  UINT32_C(0x145)
	/* Engine - Query the scheduling group configuration. */
	#define HWRM_ENGINE_SG_CONFIG_QUERY               UINT32_C(0x146)
	/* Engine - Query the queue groups assigned to a scheduling group. */
	#define HWRM_ENGINE_SG_QUERY                      UINT32_C(0x147)
	/* Engine - Query the configuration of a scheduling group's meter profiles. */
	#define HWRM_ENGINE_SG_METER_QUERY                UINT32_C(0x148)
	/* Engine - Configure a scheduling group's meter profiles. */
	#define HWRM_ENGINE_SG_METER_CONFIG               UINT32_C(0x149)
	/* Engine - Bind a queue group to a scheduling group. */
	#define HWRM_ENGINE_SG_QG_BIND                    UINT32_C(0x14a)
	/* Engine - Unbind a queue group from its scheduling group. */
	#define HWRM_ENGINE_QG_SG_UNBIND                  UINT32_C(0x14b)
	/* Engine - Query the Engine configuration. */
	#define HWRM_ENGINE_CONFIG_QUERY                  UINT32_C(0x154)
	/* Engine - Configure the statistics accumulator for an Engine. */
	#define HWRM_ENGINE_STATS_CONFIG                  UINT32_C(0x155)
	/* Engine - Clear the statistics accumulator for an Engine. */
	#define HWRM_ENGINE_STATS_CLEAR                   UINT32_C(0x156)
	/* Engine - Query the statistics accumulator for an Engine. */
	#define HWRM_ENGINE_STATS_QUERY                   UINT32_C(0x157)
	/* Engine - Allocate an Engine RQ. */
	#define HWRM_ENGINE_RQ_ALLOC                      UINT32_C(0x15e)
	/* Engine - Free an Engine RQ. */
	#define HWRM_ENGINE_RQ_FREE                       UINT32_C(0x15f)
	/* Engine - Allocate an Engine CQ. */
	#define HWRM_ENGINE_CQ_ALLOC                      UINT32_C(0x160)
	/* Engine - Free an Engine CQ. */
	#define HWRM_ENGINE_CQ_FREE                       UINT32_C(0x161)
	/* Engine - Allocate an NQ. */
	#define HWRM_ENGINE_NQ_ALLOC                      UINT32_C(0x162)
	/* Engine - Free an NQ. */
	#define HWRM_ENGINE_NQ_FREE                       UINT32_C(0x163)
	/* Engine - Set the on-die RQE credit update location. */
	#define HWRM_ENGINE_ON_DIE_RQE_CREDITS            UINT32_C(0x164)
	/* Experimental */
	#define HWRM_FUNC_RESOURCE_QCAPS                  UINT32_C(0x190)
	/* Experimental */
	#define HWRM_FUNC_VF_RESOURCE_CFG                 UINT32_C(0x191)
	/* Experimental */
	#define HWRM_FUNC_BACKING_STORE_QCAPS             UINT32_C(0x192)
	/* Experimental */
	#define HWRM_FUNC_BACKING_STORE_CFG               UINT32_C(0x193)
	/* Experimental */
	#define HWRM_FUNC_BACKING_STORE_QCFG              UINT32_C(0x194)
	/* Experimental */
	#define HWRM_SELFTEST_QLIST                       UINT32_C(0x200)
	/* Experimental */
	#define HWRM_SELFTEST_EXEC                        UINT32_C(0x201)
	/* Experimental */
	#define HWRM_SELFTEST_IRQ                         UINT32_C(0x202)
	/* Experimental */
	#define HWRM_SELFTEST_RETRIEVE_SERDES_DATA        UINT32_C(0x203)
	/* Experimental */
	#define HWRM_PCIE_QSTATS                          UINT32_C(0x204)
	/* Experimental */
	#define HWRM_DBG_READ_DIRECT                      UINT32_C(0xff10)
	/* Experimental */
	#define HWRM_DBG_READ_INDIRECT                    UINT32_C(0xff11)
	/* Experimental */
	#define HWRM_DBG_WRITE_DIRECT                     UINT32_C(0xff12)
	/* Experimental */
	#define HWRM_DBG_WRITE_INDIRECT                   UINT32_C(0xff13)
	#define HWRM_DBG_DUMP                             UINT32_C(0xff14)
	/* Experimental */
	#define HWRM_DBG_ERASE_NVM                        UINT32_C(0xff15)
	/* Experimental */
	#define HWRM_DBG_CFG                              UINT32_C(0xff16)
	/* Experimental */
	#define HWRM_DBG_COREDUMP_LIST                    UINT32_C(0xff17)
	/* Experimental */
	#define HWRM_DBG_COREDUMP_INITIATE                UINT32_C(0xff18)
	/* Experimental */
	#define HWRM_DBG_COREDUMP_RETRIEVE                UINT32_C(0xff19)
	/*  */
	#define HWRM_DBG_I2C_CMD                          UINT32_C(0xff1b)
	/* Experimental */
	#define HWRM_NVM_FACTORY_DEFAULTS                 UINT32_C(0xffee)
	#define HWRM_NVM_VALIDATE_OPTION                  UINT32_C(0xffef)
	#define HWRM_NVM_FLUSH                            UINT32_C(0xfff0)
	#define HWRM_NVM_GET_VARIABLE                     UINT32_C(0xfff1)
	#define HWRM_NVM_SET_VARIABLE                     UINT32_C(0xfff2)
	#define HWRM_NVM_INSTALL_UPDATE                   UINT32_C(0xfff3)
	#define HWRM_NVM_MODIFY                           UINT32_C(0xfff4)
	#define HWRM_NVM_VERIFY_UPDATE                    UINT32_C(0xfff5)
	#define HWRM_NVM_GET_DEV_INFO                     UINT32_C(0xfff6)
	#define HWRM_NVM_ERASE_DIR_ENTRY                  UINT32_C(0xfff7)
	#define HWRM_NVM_MOD_DIR_ENTRY                    UINT32_C(0xfff8)
	#define HWRM_NVM_FIND_DIR_ENTRY                   UINT32_C(0xfff9)
	#define HWRM_NVM_GET_DIR_ENTRIES                  UINT32_C(0xfffa)
	#define HWRM_NVM_GET_DIR_INFO                     UINT32_C(0xfffb)
	#define HWRM_NVM_RAW_DUMP                         UINT32_C(0xfffc)
	#define HWRM_NVM_READ                             UINT32_C(0xfffd)
	#define HWRM_NVM_WRITE                            UINT32_C(0xfffe)
	#define HWRM_NVM_RAW_WRITE_BLK                    UINT32_C(0xffff)
	#define HWRM_LAST                                HWRM_NVM_RAW_WRITE_BLK
	uint16_t	unused_0[3];
} __attribute__((packed));

/* Return Codes */
/* ret_codes (size:64b/8B) */
struct ret_codes {
	uint16_t	error_code;
	/* Request was successfully executed by the HWRM. */
	#define HWRM_ERR_CODE_SUCCESS                UINT32_C(0x0)
	/* The HWRM failed to execute the request. */
	#define HWRM_ERR_CODE_FAIL                   UINT32_C(0x1)
	/*
	 * The request contains invalid argument(s) or input
	 * parameters.
	 */
	#define HWRM_ERR_CODE_INVALID_PARAMS         UINT32_C(0x2)
	/*
	 * The requester is not allowed to access the requested
	 * resource. This error code shall be provided in a
	 * response to a request to query or modify an existing
	 * resource that is not accessible by the requester.
	 */
	#define HWRM_ERR_CODE_RESOURCE_ACCESS_DENIED UINT32_C(0x3)
	/*
	 * The HWRM is unable to allocate the requested resource.
	 * This code only applies to requests for HWRM resource
	 * allocations.
	 */
	#define HWRM_ERR_CODE_RESOURCE_ALLOC_ERROR   UINT32_C(0x4)
	/*
	 * Invalid combination of flags is specified in the
	 * request.
	 */
	#define HWRM_ERR_CODE_INVALID_FLAGS          UINT32_C(0x5)
	/*
	 * Invalid combination of enables fields is specified in
	 * the request.
	 */
	#define HWRM_ERR_CODE_INVALID_ENABLES        UINT32_C(0x6)
	/*
	 * Request contains a required TLV that is not supported by
	 * the installed version of firmware.
	 */
	#define HWRM_ERR_CODE_UNSUPPORTED_TLV        UINT32_C(0x7)
	/*
	 * No firmware buffer available to accept the request. Driver
	 * should retry the request.
	 */
	#define HWRM_ERR_CODE_NO_BUFFER              UINT32_C(0x8)
	/*
	 * Generic HWRM execution error that represents an
	 * internal error.
	 */
	#define HWRM_ERR_CODE_HWRM_ERROR             UINT32_C(0xf)
	/* Unknown error */
	#define HWRM_ERR_CODE_UNKNOWN_ERR            UINT32_C(0xfffe)
	/* Unsupported or invalid command */
	#define HWRM_ERR_CODE_CMD_NOT_SUPPORTED      UINT32_C(0xffff)
	#define HWRM_ERR_CODE_LAST \
		HWRM_ERR_CODE_CMD_NOT_SUPPORTED
	uint16_t	unused_0[3];
} __attribute__((packed));

/* Output */
/* hwrm_err_output (size:128b/16B) */
struct hwrm_err_output {
	/*
	 * Pass/Fail or error type
	 *
	 * Note: receiver to verify the in parameters, and fail the call
	 * with an error when appropriate
	 */
	uint16_t	error_code;
	/* This field returns the type of original request. */
	uint16_t	req_type;
	/* This field provides original sequence number of the command. */
	uint16_t	seq_id;
	/*
	 * This field is the length of the response in bytes.  The
	 * last byte of the response is a valid flag that will read
	 * as '1' when the command has been completely written to
	 * memory.
	 */
	uint16_t	resp_len;
	/* debug info for this error response. */
	uint32_t	opaque_0;
	/* debug info for this error response. */
	uint16_t	opaque_1;
	/*
	 * In the case of an error response, command specific error
	 * code is returned in this field.
	 */
	uint8_t	cmd_err;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));
/*
 * Following is the signature for HWRM message field that indicates not
 * applicable (All F's). Need to cast it the size of the field if needed.
 */
#define HWRM_NA_SIGNATURE ((uint32_t)(-1))
/* hwrm_func_buf_rgtr */
#define HWRM_MAX_REQ_LEN 128
/* hwrm_selftest_qlist */
#define HWRM_MAX_RESP_LEN 280
/* 7 bit indirection table index. */
#define HW_HASH_INDEX_SIZE 0x80
#define HW_HASH_KEY_SIZE 40
/* valid key for HWRM response */
#define HWRM_RESP_VALID_KEY 1
#define HWRM_VERSION_MAJOR 1
#define HWRM_VERSION_MINOR 9
#define HWRM_VERSION_UPDATE 2
/* non-zero means beta version */
#define HWRM_VERSION_RSVD 6
#define HWRM_VERSION_STR "1.9.2.6"

/****************
 * hwrm_ver_get *
 ****************/


/* hwrm_ver_get_input (size:192b/24B) */
struct hwrm_ver_get_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the driver HWRM implementation.
	 * The interface major version is intended to change only when
	 * non backward compatible changes are made to the HWRM
	 * interface specification.
	 */
	uint8_t	hwrm_intf_maj;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the driver HWRM implementation.
	 * A change in interface minor version is used to reflect
	 * significant backward compatible modification to HWRM
	 * interface specification.
	 * This can be due to addition or removal of functionality.
	 * HWRM interface specifications with the same major version
	 * but different minor versions are compatible.
	 */
	uint8_t	hwrm_intf_min;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the driver HWRM implementation.
	 * The interface update version is used to reflect minor
	 * changes or bug fixes to a released HWRM interface
	 * specification.
	 */
	uint8_t	hwrm_intf_upd;
	uint8_t	unused_0[5];
} __attribute__((packed));

/* hwrm_ver_get_output (size:1408b/176B) */
struct hwrm_ver_get_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * The interface major version is intended to change only when
	 * non backward compatible changes are made to the HWRM
	 * interface specification.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 1 in this field.
	 */
	uint8_t	hwrm_intf_maj_8b;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * A change in interface minor version is used to reflect
	 * significant backward compatible modification to HWRM
	 * interface specification.
	 * This can be due to addition or removal of functionality.
	 * HWRM interface specifications with the same major version
	 * but different minor versions are compatible.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 2 in this field.
	 */
	uint8_t	hwrm_intf_min_8b;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * The interface update version is used to reflect minor
	 * changes or bug fixes to a released HWRM interface
	 * specification.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 2 in this field.
	 */
	uint8_t	hwrm_intf_upd_8b;
	uint8_t	hwrm_intf_rsvd_8b;
	/*
	 * This field represents the major version of HWRM firmware.
	 * A change in firmware major version represents a major
	 * firmware release.
	 */
	uint8_t	hwrm_fw_maj_8b;
	/*
	 * This field represents the minor version of HWRM firmware.
	 * A change in firmware minor version represents significant
	 * firmware functionality changes.
	 */
	uint8_t	hwrm_fw_min_8b;
	/*
	 * This field represents the build version of HWRM firmware.
	 * A change in firmware build version represents bug fixes
	 * to a released firmware.
	 */
	uint8_t	hwrm_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version of the
	 * HWRM firmware.
	 */
	uint8_t	hwrm_fw_rsvd_8b;
	/*
	 * This field represents the major version of mgmt firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t	mgmt_fw_maj_8b;
	/*
	 * This field represents the minor version of mgmt firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint8_t	mgmt_fw_min_8b;
	/*
	 * This field represents the build version of mgmt firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t	mgmt_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint8_t	mgmt_fw_rsvd_8b;
	/*
	 * This field represents the major version of network
	 * control firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t	netctrl_fw_maj_8b;
	/*
	 * This field represents the minor version of network
	 * control firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint8_t	netctrl_fw_min_8b;
	/*
	 * This field represents the build version of network
	 * control firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t	netctrl_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint8_t	netctrl_fw_rsvd_8b;
	/*
	 * This field is used to indicate device's capabilities and
	 * configurations.
	 */
	uint32_t	dev_caps_cfg;
	/*
	 * If set to 1, then secure firmware update behavior
	 * is supported.
	 * If set to 0, then secure firmware update behavior is
	 * not supported.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SECURE_FW_UPD_SUPPORTED \
		UINT32_C(0x1)
	/*
	 * If set to 1, then firmware based DCBX agent is supported.
	 * If set to 0, then firmware based DCBX agent capability
	 * is not supported on this device.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_FW_DCBX_AGENT_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, then HWRM short command format is supported.
	 * If set to 0, then HWRM short command format is not supported.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SHORT_CMD_SUPPORTED \
		UINT32_C(0x4)
	/*
	 * If set to 1, then HWRM short command format is required.
	 * If set to 0, then HWRM short command format is not required.
	 */
	#define HWRM_VER_GET_OUTPUT_DEV_CAPS_CFG_SHORT_CMD_REQUIRED \
		UINT32_C(0x8)
	/*
	 * This field represents the major version of RoCE firmware.
	 * A change in major version represents a major release.
	 */
	uint8_t	roce_fw_maj_8b;
	/*
	 * This field represents the minor version of RoCE firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint8_t	roce_fw_min_8b;
	/*
	 * This field represents the build version of RoCE firmware.
	 * A change in update version represents bug fixes.
	 */
	uint8_t	roce_fw_bld_8b;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint8_t	roce_fw_rsvd_8b;
	/*
	 * This field represents the name of HWRM FW (ASCII chars
	 * with NULL at the end).
	 */
	char	hwrm_fw_name[16];
	/*
	 * This field represents the name of mgmt FW (ASCII chars
	 * with NULL at the end).
	 */
	char	mgmt_fw_name[16];
	/*
	 * This field represents the name of network control
	 * firmware (ASCII chars with NULL at the end).
	 */
	char	netctrl_fw_name[16];
	/*
	 * This field is reserved for future use.
	 * The responder should set it to 0.
	 * The requester should ignore this field.
	 */
	uint8_t	reserved2[16];
	/*
	 * This field represents the name of RoCE FW (ASCII chars
	 * with NULL at the end).
	 */
	char	roce_fw_name[16];
	/* This field returns the chip number. */
	uint16_t	chip_num;
	/* This field returns the revision of chip. */
	uint8_t	chip_rev;
	/* This field returns the chip metal number. */
	uint8_t	chip_metal;
	/* This field returns the bond id of the chip. */
	uint8_t	chip_bond_id;
	/* This value indicates the type of platform used for chip implementation. */
	uint8_t	chip_platform_type;
	/* ASIC */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_ASIC      UINT32_C(0x0)
	/* FPGA platform of the chip. */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_FPGA      UINT32_C(0x1)
	/* Palladium platform of the chip. */
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_PALLADIUM UINT32_C(0x2)
	#define HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_LAST \
		HWRM_VER_GET_OUTPUT_CHIP_PLATFORM_TYPE_PALLADIUM
	/*
	 * This field returns the maximum value of request window that
	 * is supported by the HWRM. The request window is mapped
	 * into device address space using MMIO.
	 */
	uint16_t	max_req_win_len;
	/*
	 * This field returns the maximum value of response buffer in
	 * bytes.
	 */
	uint16_t	max_resp_len;
	/*
	 * This field returns the default request timeout value in
	 * milliseconds.
	 */
	uint16_t	def_req_timeout;
	/*
	 * This field will indicate if any subsystems is not fully
	 * initialized.
	 */
	uint8_t	flags;
	/*
	 * If set to 1, device is not ready.
	 * If set to 0, device is ready to accept all HWRM commands.
	 */
	#define HWRM_VER_GET_OUTPUT_FLAGS_DEV_NOT_RDY       UINT32_C(0x1)
	/*
	 * If set to 1, external version present.
	 * If set to 0, external version not present.
	 */
	#define HWRM_VER_GET_OUTPUT_FLAGS_EXT_VER_AVAIL     UINT32_C(0x2)
	uint8_t	unused_0[2];
	/*
	 * For backward compatibility this field must be set to 1.
	 * Older drivers might look for this field to be 1 before
	 * processing the message.
	 */
	uint8_t	always_1;
	/*
	 * This field represents the major version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * The interface major version is intended to change only when
	 * non backward compatible changes are made to the HWRM
	 * interface specification. A HWRM implementation that is
	 * compliant with this specification shall provide value of 1
	 * in this field.
	 */
	uint16_t	hwrm_intf_major;
	/*
	 * This field represents the minor version of HWRM interface
	 * specification supported by the HWRM implementation.
	 * A change in interface minor version is used to reflect
	 * significant backward compatible modification to HWRM
	 * interface specification. This can be due to addition or
	 * removal of functionality. HWRM interface specifications
	 * with the same major version but different minor versions are
	 * compatible. A HWRM implementation that is compliant with
	 * this specification shall provide value of 2 in this field.
	 */
	uint16_t	hwrm_intf_minor;
	/*
	 * This field represents the update version of HWRM interface
	 * specification supported by the HWRM implementation. The
	 * interface update version is used to reflect minor changes or
	 * bug fixes to a released HWRM interface specification.
	 * A HWRM implementation that is compliant with this
	 * specification shall provide value of 2 in this field.
	 */
	uint16_t	hwrm_intf_build;
	/*
	 * This field represents the patch version of HWRM interface
	 * specification supported by the HWRM implementation.
	 */
	uint16_t	hwrm_intf_patch;
	/*
	 * This field represents the major version of HWRM firmware.
	 * A change in firmware major version represents a major
	 * firmware release.
	 */
	uint16_t	hwrm_fw_major;
	/*
	 * This field represents the minor version of HWRM firmware.
	 * A change in firmware minor version represents significant
	 * firmware functionality changes.
	 */
	uint16_t	hwrm_fw_minor;
	/*
	 * This field represents the build version of HWRM firmware.
	 * A change in firmware build version represents bug fixes to
	 * a released firmware.
	 */
	uint16_t	hwrm_fw_build;
	/*
	 * This field is a reserved field.
	 * This field can be used to represent firmware branches or customer
	 * specific releases tied to a specific (major,minor,update) version
	 * of the HWRM firmware.
	 */
	uint16_t	hwrm_fw_patch;
	/*
	 * This field represents the major version of mgmt firmware.
	 * A change in major version represents a major release.
	 */
	uint16_t	mgmt_fw_major;
	/*
	 * This field represents the minor version of HWRM firmware.
	 * A change in firmware minor version represents significant
	 * firmware functionality changes.
	 */
	uint16_t	mgmt_fw_minor;
	/*
	 * This field represents the build version of mgmt firmware.
	 * A change in update version represents bug fixes.
	 */
	uint16_t	mgmt_fw_build;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version.
	 */
	uint16_t	mgmt_fw_patch;
	/*
	 * This field represents the major version of network control
	 * firmware. A change in major version represents
	 * a major release.
	 */
	uint16_t	netctrl_fw_major;
	/*
	 * This field represents the minor version of network control
	 * firmware. A change in minor version represents significant
	 * functionality changes.
	 */
	uint16_t	netctrl_fw_minor;
	/*
	 * This field represents the build version of network control
	 * firmware. A change in update version represents bug fixes.
	 */
	uint16_t	netctrl_fw_build;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint16_t	netctrl_fw_patch;
	/*
	 * This field represents the major version of RoCE firmware.
	 * A change in major version represents a major release.
	 */
	uint16_t	roce_fw_major;
	/*
	 * This field represents the minor version of RoCE firmware.
	 * A change in minor version represents significant
	 * functionality changes.
	 */
	uint16_t	roce_fw_minor;
	/*
	 * This field represents the build version of RoCE firmware.
	 * A change in update version represents bug fixes.
	 */
	uint16_t	roce_fw_build;
	/*
	 * This field is a reserved field. This field can be used to
	 * represent firmware branches or customer specific releases
	 * tied to a specific (major,minor,update) version
	 */
	uint16_t	roce_fw_patch;
	/*
	 * This field returns the maximum extended request length acceptable
	 * by the device which allows requests greater than mailbox size when
	 * used with the short cmd request format.
	 */
	uint16_t	max_ext_req_len;
	uint8_t	unused_1[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* bd_base (size:64b/8B) */
struct bd_base {
	uint8_t	type;
	/* This value identifies the type of buffer descriptor. */
	#define BD_BASE_TYPE_MASK       UINT32_C(0x3f)
	#define BD_BASE_TYPE_SFT        0
	/*
	 * Indicates that this BD is 16B long and is used for
	 * normal L2 packet transmission.
	 */
	#define BD_BASE_TYPE_TX_BD_SHORT  UINT32_C(0x0)
	/*
	 * Indicates that this BD is 1BB long and is an empty
	 * TX BD.  Not valid for use by the driver.
	 */
	#define BD_BASE_TYPE_TX_BD_EMPTY  UINT32_C(0x1)
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * (ie. empty) buffer descriptor.
	 */
	#define BD_BASE_TYPE_RX_PROD_PKT  UINT32_C(0x4)
	/*
	 * Indicates that this BD is 16B long and is an RX
	 * Producer Buffer BD.
	 */
	#define BD_BASE_TYPE_RX_PROD_BFR  UINT32_C(0x5)
	/*
	 * Indicates that this BD is 16B long and is an
	 * RX Producer Assembly Buffer Descriptor.
	 */
	#define BD_BASE_TYPE_RX_PROD_AGG  UINT32_C(0x6)
	/*
	 * Indicates that this BD is 32B long and is used for
	 * normal L2 packet transmission.
	 */
	#define BD_BASE_TYPE_TX_BD_LONG   UINT32_C(0x10)
	#define BD_BASE_TYPE_LAST        BD_BASE_TYPE_TX_BD_LONG
	uint8_t	unused_1[7];
} __attribute__((packed));

/* tx_bd_short (size:128b/16B) */
struct tx_bd_short {
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define TX_BD_SHORT_TYPE_MASK            UINT32_C(0x3f)
	#define TX_BD_SHORT_TYPE_SFT             0
	/*
	 * Indicates that this BD is 16B long and is used for
	 * normal L2 packet transmission.
	 */
	#define TX_BD_SHORT_TYPE_TX_BD_SHORT       UINT32_C(0x0)
	#define TX_BD_SHORT_TYPE_LAST             TX_BD_SHORT_TYPE_TX_BD_SHORT
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_MASK           UINT32_C(0xffc0)
	#define TX_BD_SHORT_FLAGS_SFT            6
	/*
	 * If set to 1, the packet ends with the data in the buffer
	 * pointed to by this descriptor.  This flag must be
	 * valid on every BD.
	 */
	#define TX_BD_SHORT_FLAGS_PACKET_END      UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for
	 * this transmit packet unless there is an error in it's
	 * processing.
	 * If this bit
	 * is set to 0, then the packet will be completed normally.
	 *
	 * This bit must be valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_NO_CMPL         UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed
	 * in the ring by this packet.
	 * A value of 1 indicates that this BD is the only BD (and that
	 * the it is a short BD).  A value
	 * of 3 indicates either 3 short BDs or 1 long BD and one short
	 * BD in the packet.  A value of 0 indicates
	 * that there are 32 BD locations in the packet (the maximum).
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_BD_CNT_MASK     UINT32_C(0x1f00)
	#define TX_BD_SHORT_FLAGS_BD_CNT_SFT      8
	/*
	 * This value is a hint for the length of the entire packet.
	 * It is used by the chip to optimize internal processing.
	 *
	 * The packet will be dropped if the hint is too short.
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_LHINT_MASK      UINT32_C(0x6000)
	#define TX_BD_SHORT_FLAGS_LHINT_SFT       13
	/* indicates packet length < 512B */
	#define TX_BD_SHORT_FLAGS_LHINT_LT512       (UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
	#define TX_BD_SHORT_FLAGS_LHINT_LT1K        (UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
	#define TX_BD_SHORT_FLAGS_LHINT_LT2K        (UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
	#define TX_BD_SHORT_FLAGS_LHINT_GTE2K       (UINT32_C(0x3) << 13)
	#define TX_BD_SHORT_FLAGS_LHINT_LAST \
		TX_BD_SHORT_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer
	 * Index after the buffer associated with this descriptor has
	 * been transferred via DMA to NIC memory from host memory. An
	 * interrupt may or may not be generated according to the state
	 * of the interrupt avoidance mechanisms. If this bit
	 * is set to 0, then the Consumer Index is only updated as soon
	 * as one of the host interrupt coalescing conditions has been met.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_SHORT_FLAGS_COAL_NOW        UINT32_C(0x8000)
	/*
	 * This is the length of the host physical buffer this BD describes
	 * in bytes.
	 *
	 * This field must be valid on all BDs of a packet.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD.
	 *
	 * This field must be valid on the first BD of a packet.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address for the portion of the packet
	 * described by this TX BD.
	 *
	 * This value must be valid on all BDs of a packet.
	 */
	uint64_t	address;
} __attribute__((packed));

/* tx_bd_long (size:128b/16B) */
struct tx_bd_long {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/*
	 * This value indicates the type of buffer descriptor.
	 * packet.
	 */
	#define TX_BD_LONG_TYPE_MASK            UINT32_C(0x3f)
	#define TX_BD_LONG_TYPE_SFT             0
	/*
	 * Indicates that this BD is 32B long and is used for
	 * normal L2 packet transmission.
	 */
	#define TX_BD_LONG_TYPE_TX_BD_LONG        UINT32_C(0x10)
	#define TX_BD_LONG_TYPE_LAST             TX_BD_LONG_TYPE_TX_BD_LONG
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Only the packet_end bit must be valid for the remaining BDs
	 * of a packet.
	 */
	#define TX_BD_LONG_FLAGS_MASK           UINT32_C(0xffc0)
	#define TX_BD_LONG_FLAGS_SFT            6
	/*
	 * If set to 1, the packet ends with the data in the buffer
	 * pointed to by this descriptor.  This flag must be
	 * valid on every BD.
	 */
	#define TX_BD_LONG_FLAGS_PACKET_END      UINT32_C(0x40)
	/*
	 * If set to 1, the device will not generate a completion for
	 * this transmit packet unless there is an error in it's
	 * processing.
	 * If this bit
	 * is set to 0, then the packet will be completed normally.
	 *
	 * This bit must be valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_NO_CMPL         UINT32_C(0x80)
	/*
	 * This value indicates how many 16B BD locations are consumed
	 * in the ring by this packet.
	 * A value of 1 indicates that this BD is the only BD (and that
	 * the it is a short BD).  A value
	 * of 3 indicates either 3 short BDs or 1 long BD and one short
	 * BD in the packet.  A value of 0 indicates
	 * that there are 32 BD locations in the packet (the maximum).
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_BD_CNT_MASK     UINT32_C(0x1f00)
	#define TX_BD_LONG_FLAGS_BD_CNT_SFT      8
	/*
	 * This value is a hint for the length of the entire packet.
	 * It is used by the chip to optimize internal processing.
	 *
	 * The packet will be dropped if the hint is too short.
	 *
	 * This field is valid only on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_LHINT_MASK      UINT32_C(0x6000)
	#define TX_BD_LONG_FLAGS_LHINT_SFT       13
	/* indicates packet length < 512B */
	#define TX_BD_LONG_FLAGS_LHINT_LT512       (UINT32_C(0x0) << 13)
	/* indicates 512 <= packet length < 1KB */
	#define TX_BD_LONG_FLAGS_LHINT_LT1K        (UINT32_C(0x1) << 13)
	/* indicates 1KB <= packet length < 2KB */
	#define TX_BD_LONG_FLAGS_LHINT_LT2K        (UINT32_C(0x2) << 13)
	/* indicates packet length >= 2KB */
	#define TX_BD_LONG_FLAGS_LHINT_GTE2K       (UINT32_C(0x3) << 13)
	#define TX_BD_LONG_FLAGS_LHINT_LAST       TX_BD_LONG_FLAGS_LHINT_GTE2K
	/*
	 * If set to 1, the device immediately updates the Send Consumer
	 * Index after the buffer associated with this descriptor has
	 * been transferred via DMA to NIC memory from host memory. An
	 * interrupt may or may not be generated according to the state
	 * of the interrupt avoidance mechanisms. If this bit
	 * is set to 0, then the Consumer Index is only updated as soon
	 * as one of the host interrupt coalescing conditions has been met.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_FLAGS_COAL_NOW        UINT32_C(0x8000)
	/*
	 * This is the length of the host physical buffer this BD describes
	 * in bytes.
	 *
	 * This field must be valid on all BDs of a packet.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with the
	 * transmit BD.
	 *
	 * This field must be valid on the first BD of a packet.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address for the portion of the packet
	 * described by this TX BD.
	 *
	 * This value must be valid on all BDs of a packet.
	 */
	uint64_t	address;
} __attribute__((packed));

/* tx_bd_long_hi (size:128b/16B) */
struct tx_bd_long_hi {
	/*
	 * All bits in this field must be valid on the first BD of a packet.
	 * Their value on other BDs of the packet will be ignored.
	 */
	uint16_t	lflags;
	/*
	 * If set to 1, the controller replaces the TCP/UPD checksum
	 * fields of normal TCP/UPD checksum, or the inner TCP/UDP
	 * checksum field of the encapsulated TCP/UDP packets with the
	 * hardware calculated TCP/UDP checksum for the packet associated
	 * with this descriptor. The flag is ignored if the LSO flag is set.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_TCP_UDP_CHKSUM     UINT32_C(0x1)
	/*
	 * If set to 1,  the controller replaces the IP checksum of the
	 * normal packets, or the inner IP checksum of the encapsulated
	 * packets with the hardware calculated IP checksum for the
	 * packet associated with this descriptor.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_IP_CHKSUM          UINT32_C(0x2)
	/*
	 * If set to 1, the controller will not append an Ethernet CRC
	 * to the end of the frame.
	 *
	 * This bit must be valid on the first BD of a packet.
	 *
	 * Packet must be 64B or longer when this flag is set.  It is not
	 * useful to use this bit with any form of TX offload such as
	 * CSO or LSO.  The intent is that the packet from the host already
	 * has a valid Ethernet CRC on the packet.
	 */
	#define TX_BD_LONG_LFLAGS_NOCRC              UINT32_C(0x4)
	/*
	 * If set to 1, the device will record the time at which the packet
	 * was actually transmitted at the TX MAC.
	 *
	 * This bit must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_LFLAGS_STAMP              UINT32_C(0x8)
	/*
	 * If set to 1, The controller replaces the tunnel IP checksum
	 * field with hardware calculated IP checksum for the IP header
	 * of the packet associated with this descriptor.
	 *
	 * For outer UDP checksum, global outer UDP checksum TE_NIC register
	 * needs to be enabled. If the global outer UDP checksum TE_NIC register
	 * bit is set, outer UDP checksum will be calculated for the following
	 * cases:
	 * 1. Packets with tcp_udp_chksum flag set to offload checksum for inner
	 * packet AND the inner packet is TCP/UDP. If the inner packet is ICMP for
	 * example (non-TCP/UDP), even if the tcp_udp_chksum is set, the outer UDP
	 * checksum will not be calculated.
	 * 2. Packets with lso flag set which implies inner TCP checksum calculation
	 * as part of LSO operation.
	 */
	#define TX_BD_LONG_LFLAGS_T_IP_CHKSUM        UINT32_C(0x10)
	/*
	 * If set to 1,  the device will treat this packet with LSO(Large
	 * Send Offload) processing for both normal or encapsulated
	 * packets, which is a form of TCP segmentation.  When this bit
	 * is 1, the hdr_size and mss fields must be valid. The driver
	 * doesn't need to set t_ip_chksum, ip_chksum, and tcp_udp_chksum
	 * flags since the controller will replace the appropriate
	 * checksum fields for segmented packets.
	 *
	 * When this bit is 1, the hdr_size and mss fields must be valid.
	 */
	#define TX_BD_LONG_LFLAGS_LSO                UINT32_C(0x20)
	/*
	 * If set to zero when LSO is '1', then the IPID will be treated
	 * as a 16b number and will be wrapped if it exceeds a value of
	 * 0xffff.
	 *
	 * If set to one when LSO is '1', then the IPID will be treated
	 * as a 15b number and will be wrapped if it exceeds a value 0f
	 * 0x7fff.
	 */
	#define TX_BD_LONG_LFLAGS_IPID_FMT           UINT32_C(0x40)
	/*
	 * If set to zero when LSO is '1', then the IPID of the tunnel
	 * IP header will not be modified during LSO operations.
	 *
	 * If set to one when LSO is '1', then the IPID of the tunnel
	 * IP header will be incremented for each subsequent segment of an
	 * LSO operation.
	 *
	 * The flag is ignored if the LSO packet is a normal (non-tunneled)
	 * TCP packet.
	 */
	#define TX_BD_LONG_LFLAGS_T_IPID             UINT32_C(0x80)
	/*
	 * If set to '1', then the RoCE ICRC will be appended to the
	 * packet.  Packet must be a valid RoCE format packet.
	 */
	#define TX_BD_LONG_LFLAGS_ROCE_CRC           UINT32_C(0x100)
	/*
	 * If set to '1', then the FCoE CRC will be appended to the
	 * packet.  Packet must be a valid FCoE format packet.
	 */
	#define TX_BD_LONG_LFLAGS_FCOE_CRC           UINT32_C(0x200)
	uint16_t	hdr_size;
	/*
	 * When LSO is '1', this field must contain the offset of the
	 * TCP payload from the beginning of the packet in as
	 * 16b words. In case of encapsulated/tunneling packet, this  field
	 * contains the offset of the inner TCP payload from beginning of the
	 * packet as 16-bit words.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_HDR_SIZE_MASK UINT32_C(0x1ff)
	#define TX_BD_LONG_HDR_SIZE_SFT 0
	uint32_t	mss;
	/*
	 * This is the MSS value that will be used to do the LSO processing.
	 * The value is the length in bytes of the TCP payload for each
	 * segment generated by the LSO operation.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_MSS_MASK UINT32_C(0x7fff)
	#define TX_BD_LONG_MSS_SFT 0
	uint16_t	unused2;
	/*
	 * This value selects a CFA action to perform on the packet.
	 * Set this value to zero if no CFA action is desired.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	uint16_t	cfa_action;
	/*
	 * This value is action meta-data that defines CFA edit operations
	 * that are done in addition to any action editing.
	 */
	uint32_t	cfa_meta;
	/* When key=1, This is the VLAN tag VID value. */
	#define TX_BD_LONG_CFA_META_VLAN_VID_MASK     UINT32_C(0xfff)
	#define TX_BD_LONG_CFA_META_VLAN_VID_SFT      0
	/* When key=1, This is the VLAN tag DE value. */
	#define TX_BD_LONG_CFA_META_VLAN_DE           UINT32_C(0x1000)
	/* When key=1, This is the VLAN tag PRI value. */
	#define TX_BD_LONG_CFA_META_VLAN_PRI_MASK     UINT32_C(0xe000)
	#define TX_BD_LONG_CFA_META_VLAN_PRI_SFT      13
	/* When key=1, This is the VLAN tag TPID select value. */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_MASK    UINT32_C(0x70000)
	#define TX_BD_LONG_CFA_META_VLAN_TPID_SFT     16
	/* 0x88a8 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID88A8  (UINT32_C(0x0) << 16)
	/* 0x8100 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID8100  (UINT32_C(0x1) << 16)
	/* 0x9100 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9100  (UINT32_C(0x2) << 16)
	/* 0x9200 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9200  (UINT32_C(0x3) << 16)
	/* 0x9300 */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPID9300  (UINT32_C(0x4) << 16)
	/* Value programmed in CFA VLANTPID register. */
	#define TX_BD_LONG_CFA_META_VLAN_TPID_TPIDCFG   (UINT32_C(0x5) << 16)
	#define TX_BD_LONG_CFA_META_VLAN_TPID_LAST \
		TX_BD_LONG_CFA_META_VLAN_TPID_TPIDCFG
	/* When key=1, This is the VLAN tag TPID select value. */
	#define TX_BD_LONG_CFA_META_VLAN_RESERVED_MASK UINT32_C(0xff80000)
	#define TX_BD_LONG_CFA_META_VLAN_RESERVED_SFT 19
	/*
	 * This field identifies the type of edit to be performed
	 * on the packet.
	 *
	 * This value must be valid on the first BD of a packet.
	 */
	#define TX_BD_LONG_CFA_META_KEY_MASK          UINT32_C(0xf0000000)
	#define TX_BD_LONG_CFA_META_KEY_SFT           28
	/* No editing */
	#define TX_BD_LONG_CFA_META_KEY_NONE            (UINT32_C(0x0) << 28)
	/*
	 * - meta[17:16] - TPID select value (0 = 0x8100).
	 * - meta[15:12] - PRI/DE value.
	 * - meta[11:0] - VID value.
	 */
	#define TX_BD_LONG_CFA_META_KEY_VLAN_TAG        (UINT32_C(0x1) << 28)
	#define TX_BD_LONG_CFA_META_KEY_LAST \
		TX_BD_LONG_CFA_META_KEY_VLAN_TAG
} __attribute__((packed));

/* tx_bd_empty (size:128b/16B) */
struct tx_bd_empty {
	/* This value identifies the type of buffer descriptor. */
	uint8_t	type;
	#define TX_BD_EMPTY_TYPE_MASK       UINT32_C(0x3f)
	#define TX_BD_EMPTY_TYPE_SFT        0
	/*
	 * Indicates that this BD is 1BB long and is an empty
	 * TX BD.  Not valid for use by the driver.
	 */
	#define TX_BD_EMPTY_TYPE_TX_BD_EMPTY  UINT32_C(0x1)
	#define TX_BD_EMPTY_TYPE_LAST        TX_BD_EMPTY_TYPE_TX_BD_EMPTY
	uint8_t	unused_1[3];
	uint8_t	unused_2;
	uint8_t	unused_3[3];
	uint8_t	unused_4[8];
} __attribute__((packed));

/* rx_prod_pkt_bd (size:128b/16B) */
struct rx_prod_pkt_bd {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_PKT_BD_TYPE_MASK         UINT32_C(0x3f)
	#define RX_PROD_PKT_BD_TYPE_SFT          0
	/*
	 * Indicates that this BD is 16B long and is an RX Producer
	 * (ie. empty) buffer descriptor.
	 */
	#define RX_PROD_PKT_BD_TYPE_RX_PROD_PKT    UINT32_C(0x4)
	#define RX_PROD_PKT_BD_TYPE_LAST \
		RX_PROD_PKT_BD_TYPE_RX_PROD_PKT
	#define RX_PROD_PKT_BD_FLAGS_MASK        UINT32_C(0xffc0)
	#define RX_PROD_PKT_BD_FLAGS_SFT         6
	/*
	 * If set to 1, the packet will be placed at the address plus
	 * 2B.  The 2 Bytes of padding will be written as zero.
	 */
	#define RX_PROD_PKT_BD_FLAGS_SOP_PAD      UINT32_C(0x40)
	/*
	 * If set to 1, the packet write will be padded out to the
	 * nearest cache-line with zero value padding.
	 */
	#define RX_PROD_PKT_BD_FLAGS_EOP_PAD      UINT32_C(0x80)
	/*
	 * This value is the number of additional buffers in the ring that
	 * describe the buffer space to be consumed for the this packet.
	 * If the value is zero, then the packet must fit within the
	 * space described by this BD.  If this value is 1 or more, it
	 * indicates how many additional "buffer" BDs are in the ring
	 * immediately following this BD to be used for the same
	 * network packet.
	 *
	 * Even if the packet to be placed does not need all the
	 * additional buffers, they will be consumed anyway.
	 */
	#define RX_PROD_PKT_BD_FLAGS_BUFFERS_MASK UINT32_C(0x300)
	#define RX_PROD_PKT_BD_FLAGS_BUFFERS_SFT  8
	/*
	 * This is the length in Bytes of the host physical buffer where
	 * data for the packet may be placed in host memory.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * receive buffer set.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address where data for the packet may
	 * by placed in host memory.
	 */
	uint64_t	address;
} __attribute__((packed));

/* rx_prod_bfr_bd (size:128b/16B) */
struct rx_prod_bfr_bd {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_BFR_BD_TYPE_MASK       UINT32_C(0x3f)
	#define RX_PROD_BFR_BD_TYPE_SFT        0
	/*
	 * Indicates that this BD is 16B long and is an RX
	 * Producer Buffer BD.
	 */
	#define RX_PROD_BFR_BD_TYPE_RX_PROD_BFR  UINT32_C(0x5)
	#define RX_PROD_BFR_BD_TYPE_LAST        RX_PROD_BFR_BD_TYPE_RX_PROD_BFR
	#define RX_PROD_BFR_BD_FLAGS_MASK      UINT32_C(0xffc0)
	#define RX_PROD_BFR_BD_FLAGS_SFT       6
	/*
	 * This is the length in Bytes of the host physical buffer where
	 * data for the packet may be placed in host memory.
	 */
	uint16_t	len;
	/* This field is not used. */
	uint32_t	opaque;
	/*
	 * This is the host physical address where data for the packet may
	 * by placed in host memory.
	 */
	uint64_t	address;
} __attribute__((packed));

/* rx_prod_agg_bd (size:128b/16B) */
struct rx_prod_agg_bd {
	/* This value identifies the type of buffer descriptor. */
	uint16_t	flags_type;
	/* This value identifies the type of buffer descriptor. */
	#define RX_PROD_AGG_BD_TYPE_MASK         UINT32_C(0x3f)
	#define RX_PROD_AGG_BD_TYPE_SFT          0
	/*
	 * Indicates that this BD is 16B long and is an
	 * RX Producer Assembly Buffer Descriptor.
	 */
	#define RX_PROD_AGG_BD_TYPE_RX_PROD_AGG    UINT32_C(0x6)
	#define RX_PROD_AGG_BD_TYPE_LAST \
		RX_PROD_AGG_BD_TYPE_RX_PROD_AGG
	#define RX_PROD_AGG_BD_FLAGS_MASK        UINT32_C(0xffc0)
	#define RX_PROD_AGG_BD_FLAGS_SFT         6
	/*
	 * If set to 1, the packet write will be padded out to the
	 * nearest cache-line with zero value padding.
	 */
	#define RX_PROD_AGG_BD_FLAGS_EOP_PAD      UINT32_C(0x40)
	/*
	 * This is the length in Bytes of the host physical buffer where
	 * data for the packet may be placed in host memory.
	 */
	uint16_t	len;
	/*
	 * The opaque data field is pass through to the completion and can be
	 * used for any data that the driver wants to associate with this
	 * receive assembly buffer.
	 */
	uint32_t	opaque;
	/*
	 * This is the host physical address where data for the packet may
	 * by placed in host memory.
	 */
	uint64_t	address;
} __attribute__((packed));

/* cmpl_base (size:128b/16B) */
struct cmpl_base {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define CMPL_BASE_TYPE_MASK            UINT32_C(0x3f)
	#define CMPL_BASE_TYPE_SFT             0
	/*
	 * TX L2 completion:
	 *  Completion of TX packet.  Length = 16B
	 */
	#define CMPL_BASE_TYPE_TX_L2             UINT32_C(0x0)
	/*
	 * RX L2 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 */
	#define CMPL_BASE_TYPE_RX_L2             UINT32_C(0x11)
	/*
	 * RX Aggregation Buffer completion :
	 * Completion of an L2 aggregation buffer in support of
	 * TPA, HDS, or Jumbo packet completion.  Length = 16B
	 */
	#define CMPL_BASE_TYPE_RX_AGG            UINT32_C(0x12)
	/*
	 * RX L2 TPA Start Completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 */
	#define CMPL_BASE_TYPE_RX_TPA_START      UINT32_C(0x13)
	/*
	 * RX L2 TPA End Completion:
	 * Completion at the end of a TPA operation.
	 * Length = 32B
	 */
	#define CMPL_BASE_TYPE_RX_TPA_END        UINT32_C(0x15)
	/*
	 * Statistics Ejection Completion:
	 * Completion of statistics data ejection buffer.
	 * Length = 16B
	 */
	#define CMPL_BASE_TYPE_STAT_EJECT        UINT32_C(0x1a)
	/*
	 * HWRM Command Completion:
	 * Completion of an HWRM command.
	 */
	#define CMPL_BASE_TYPE_HWRM_DONE         UINT32_C(0x20)
	/* Forwarded HWRM Request */
	#define CMPL_BASE_TYPE_HWRM_FWD_REQ      UINT32_C(0x22)
	/* Forwarded HWRM Response */
	#define CMPL_BASE_TYPE_HWRM_FWD_RESP     UINT32_C(0x24)
	/* HWRM Asynchronous Event Information */
	#define CMPL_BASE_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
	/* CQ Notification */
	#define CMPL_BASE_TYPE_CQ_NOTIFICATION   UINT32_C(0x30)
	/* SRQ Threshold Event */
	#define CMPL_BASE_TYPE_SRQ_EVENT         UINT32_C(0x32)
	/* DBQ Threshold Event */
	#define CMPL_BASE_TYPE_DBQ_EVENT         UINT32_C(0x34)
	/* QP Async Notification */
	#define CMPL_BASE_TYPE_QP_EVENT          UINT32_C(0x38)
	/* Function Async Notification */
	#define CMPL_BASE_TYPE_FUNC_EVENT        UINT32_C(0x3a)
	#define CMPL_BASE_TYPE_LAST             CMPL_BASE_TYPE_FUNC_EVENT
	/* info1 is 16 b */
	uint16_t	info1;
	/* info2 is 32 b */
	uint32_t	info2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	uint32_t	info3_v;
	#define CMPL_BASE_V         UINT32_C(0x1)
	#define CMPL_BASE_INFO3_MASK UINT32_C(0xfffffffe)
	#define CMPL_BASE_INFO3_SFT 1
	/* info4 is 32 b */
	uint32_t	info4;
} __attribute__((packed));

/* tx_cmpl (size:128b/16B) */
struct tx_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define TX_CMPL_TYPE_MASK       UINT32_C(0x3f)
	#define TX_CMPL_TYPE_SFT        0
	/*
	 * TX L2 completion:
	 *  Completion of TX packet.  Length = 16B
	 */
	#define TX_CMPL_TYPE_TX_L2        UINT32_C(0x0)
	#define TX_CMPL_TYPE_LAST        TX_CMPL_TYPE_TX_L2
	#define TX_CMPL_FLAGS_MASK      UINT32_C(0xffc0)
	#define TX_CMPL_FLAGS_SFT       6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type.  Type of error is indicated in
	 * error_flags.
	 */
	#define TX_CMPL_FLAGS_ERROR      UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet completed
	 * was transmitted using the push acceleration data provided
	 * by the driver.  When this bit is '0', it indicates that the
	 * packet had not push acceleration data written or was executed
	 * as a normal packet even though push data was provided.
	 */
	#define TX_CMPL_FLAGS_PUSH       UINT32_C(0x80)
	/* unused1 is 16 b */
	uint16_t	unused_0;
	/*
	 * This is a copy of the opaque field from the first TX BD of this
	 * transmitted packet.
	 */
	uint32_t	opaque;
	uint16_t	errors_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define TX_CMPL_V                              UINT32_C(0x1)
	#define TX_CMPL_ERRORS_MASK                    UINT32_C(0xfffe)
	#define TX_CMPL_ERRORS_SFT                     1
	/*
	 * This error indicates that there was some sort of problem
	 * with the BDs for the packet.
	 */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_MASK        UINT32_C(0xe)
	#define TX_CMPL_ERRORS_BUFFER_ERROR_SFT         1
	/* No error */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_NO_ERROR      (UINT32_C(0x0) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
	#define TX_CMPL_ERRORS_BUFFER_ERROR_BAD_FMT       (UINT32_C(0x2) << 1)
	#define TX_CMPL_ERRORS_BUFFER_ERROR_LAST \
		TX_CMPL_ERRORS_BUFFER_ERROR_BAD_FMT
	/*
	 * When this bit is '1', it indicates that the length of
	 * the packet was zero.  No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_ZERO_LENGTH_PKT          UINT32_C(0x10)
	/*
	 * When this bit is '1', it indicates that the packet
	 * was longer than the programmed limit in TDI. No
	 * packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_EXCESSIVE_BD_LENGTH      UINT32_C(0x20)
	/*
	 * When this bit is '1', it indicates that one or more of the
	 * BDs associated with this packet generated a PCI error.
	 * This probably means the address was not valid.
	 */
	#define TX_CMPL_ERRORS_DMA_ERROR                UINT32_C(0x40)
	/*
	 * When this bit is '1', it indicates that the packet was longer
	 * than indicated by the hint.  No packet was transmitted.
	 */
	#define TX_CMPL_ERRORS_HINT_TOO_SHORT           UINT32_C(0x80)
	/*
	 * When this bit is '1', it indicates that the packet was
	 * dropped due to Poison TLP error on one or more of the
	 * TLPs in the PXP completion.
	 */
	#define TX_CMPL_ERRORS_POISON_TLP_ERROR         UINT32_C(0x100)
	/* unused2 is 16 b */
	uint16_t	unused_1;
	/* unused3 is 32 b */
	uint32_t	unused_2;
} __attribute__((packed));

/* rx_pkt_cmpl (size:128b/16B) */
struct rx_pkt_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define RX_PKT_CMPL_TYPE_MASK                   UINT32_C(0x3f)
	#define RX_PKT_CMPL_TYPE_SFT                    0
	/*
	 * RX L2 completion:
	 * Completion of and L2 RX packet. Length = 32B
	 */
	#define RX_PKT_CMPL_TYPE_RX_L2                    UINT32_C(0x11)
	#define RX_PKT_CMPL_TYPE_LAST                    RX_PKT_CMPL_TYPE_RX_L2
	#define RX_PKT_CMPL_FLAGS_MASK                  UINT32_C(0xffc0)
	#define RX_PKT_CMPL_FLAGS_SFT                   6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type.  Type of error is indicated in
	 * error_flags.
	 */
	#define RX_PKT_CMPL_FLAGS_ERROR                  UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_MASK         UINT32_C(0x380)
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_SFT          7
	/*
	 * Normal:
	 * Packet was placed using normal algorithm.
	 */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_NORMAL         (UINT32_C(0x0) << 7)
	/*
	 * Jumbo:
	 * Packet was placed using jumbo algorithm.
	 */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_JUMBO          (UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_HDS            (UINT32_C(0x2) << 7)
	#define RX_PKT_CMPL_FLAGS_PLACEMENT_LAST \
		RX_PKT_CMPL_FLAGS_PLACEMENT_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_PKT_CMPL_FLAGS_RSS_VALID              UINT32_C(0x400)
	/* unused is 1 b */
	#define RX_PKT_CMPL_FLAGS_UNUSED                 UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_MASK             UINT32_C(0xf000)
	#define RX_PKT_CMPL_FLAGS_ITYPE_SFT              12
	/*
	 * Not Known:
	 * Indicates that the packet type was not known.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_NOT_KNOWN \
		(UINT32_C(0x0) << 12)
	/*
	 * IP Packet:
	 * Indicates that the packet was an IP packet, but further
	 * classification was not possible.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_IP \
		(UINT32_C(0x1) << 12)
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 * This indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_TCP \
		(UINT32_C(0x2) << 12)
	/*
	 * UDP Packet:
	 * Indicates that the packet was IP and UDP.
	 * This indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_UDP \
		(UINT32_C(0x3) << 12)
	/*
	 * FCoE Packet:
	 * Indicates that the packet was recognized as a FCoE.
	 * This also indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_FCOE \
		(UINT32_C(0x4) << 12)
	/*
	 * RoCE Packet:
	 * Indicates that the packet was recognized as a RoCE.
	 * This also indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_ROCE \
		(UINT32_C(0x5) << 12)
	/*
	 * ICMP Packet:
	 * Indicates that the packet was recognized as ICMP.
	 * This indicates that the payload_offset field is valid.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_ICMP \
		(UINT32_C(0x7) << 12)
	/*
	 * PtP packet wo/timestamp:
	 * Indicates that the packet was recognized as a PtP
	 * packet.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_PTP_WO_TIMESTAMP \
		(UINT32_C(0x8) << 12)
	/*
	 * PtP packet w/timestamp:
	 * Indicates that the packet was recognized as a PtP
	 * packet and that a timestamp was taken for the packet.
	 */
	#define RX_PKT_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP \
		(UINT32_C(0x9) << 12)
	#define RX_PKT_CMPL_FLAGS_ITYPE_LAST \
		RX_PKT_CMPL_FLAGS_ITYPE_PTP_W_TIMESTAMP
	/*
	 * This is the length of the data for the packet stored in the
	 * buffer(s) identified by the opaque value.  This includes
	 * the packet BD and any associated buffer BDs.  This does not include
	 * the the length of any data places in aggregation BDs.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	uint8_t	agg_bufs_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_PKT_CMPL_V1           UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided for the packet in the RX ring.
	 */
	#define RX_PKT_CMPL_AGG_BUFS_MASK UINT32_C(0x3e)
	#define RX_PKT_CMPL_AGG_BUFS_SFT 1
	/* unused1 is 2 b */
	#define RX_PKT_CMPL_UNUSED1_MASK UINT32_C(0xc0)
	#define RX_PKT_CMPL_UNUSED1_SFT  6
	/*
	 * This is the RSS hash type for the packet.  The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 *
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * * 0: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 1: The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 2: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 *
	 * Note that 4-tuples values listed above are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * This value indicates the offset in bytes from the beginning of the packet
	 * where the inner payload starts.  This value is valid for TCP, UDP,
	 * FCoE, and RoCE packets.
	 *
	 * A value of zero indicates that header is 256B into the packet.
	 */
	uint8_t	payload_offset;
	/* unused2 is 8 b */
	uint8_t	unused1;
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/* rx_pkt_cmpl_hi (size:128b/16B) */
struct rx_pkt_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the
	 * inner packet and that the ip_cs_error field indicates if there
	 * was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_IP_CS_CALC       UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was
	 * calculated for the inner packet and that the l4_cs_error field
	 * indicates if there was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_L4_CS_CALC       UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the
	 * tunnel header and that the t_ip_cs_error field indicates if there
	 * was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_T_IP_CS_CALC     UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was
	 * calculated for the tunnel packet and that the t_l4_cs_error field
	 * indicates if there was an error.
	 */
	#define RX_PKT_CMPL_FLAGS2_T_L4_CS_CALC     UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_MASK UINT32_C(0xf0)
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_SFT  4
	/* No metadata informtaion.  Value is zero. */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_NONE   (UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value.
	 * - metadata[11:0] contains the vlan VID value.
	 * - metadata[12] contains the vlan DE value.
	 * - metadata[15:13] contains the vlan PRI value.
	 * - metadata[31:16] contains the vlan TPID value.
	 */
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_VLAN   (UINT32_C(0x1) << 4)
	#define RX_PKT_CMPL_FLAGS2_META_FORMAT_LAST \
		RX_PKT_CMPL_FLAGS2_META_FORMAT_VLAN
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4.  A value of '1' indicates IPv6.
	 * This value is only valid if itype indicates a packet
	 * with an IP header.
	 */
	#define RX_PKT_CMPL_FLAGS2_IP_TYPE          UINT32_C(0x100)
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint32_t	metadata;
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_PKT_CMPL_METADATA_VID_MASK UINT32_C(0xfff)
	#define RX_PKT_CMPL_METADATA_VID_SFT  0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_PKT_CMPL_METADATA_DE       UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_PKT_CMPL_METADATA_PRI_MASK UINT32_C(0xe000)
	#define RX_PKT_CMPL_METADATA_PRI_SFT  13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define RX_PKT_CMPL_METADATA_TPID_MASK UINT32_C(0xffff0000)
	#define RX_PKT_CMPL_METADATA_TPID_SFT 16
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_PKT_CMPL_V2 \
		UINT32_C(0x1)
	#define RX_PKT_CMPL_ERRORS_MASK \
		UINT32_C(0xfffe)
	#define RX_PKT_CMPL_ERRORS_SFT                               1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed.  The packet should be treated as
	 * invalid.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_MASK \
		UINT32_C(0xe)
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_SFT                   1
	/* No buffer error */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_NO_BUFFER \
		(UINT32_C(0x0) << 1)
	/*
	 * Did Not Fit:
	 * Packet did not fit into packet buffer provided.
	 * For regular placement, this means the packet did not fit
	 * in the buffer provided.  For HDS and jumbo placement, this
	 * means that the packet could not be placed into 7 physical
	 * buffers or less.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_DID_NOT_FIT \
		(UINT32_C(0x1) << 1)
	/*
	 * Not On Chip:
	 * All BDs needed for the packet were not on-chip when
	 * the packet arrived.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP \
		(UINT32_C(0x2) << 1)
	/*
	 * Bad Format:
	 * BDs were not formatted correctly.
	 */
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT \
		(UINT32_C(0x3) << 1)
	#define RX_PKT_CMPL_ERRORS_BUFFER_ERROR_LAST \
		RX_PKT_CMPL_ERRORS_BUFFER_ERROR_BAD_FORMAT
	/*
	 * This indicates that there was an error in the IP header
	 * checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_IP_CS_ERROR \
		UINT32_C(0x10)
	/*
	 * This indicates that there was an error in the TCP, UDP
	 * or ICMP checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_L4_CS_ERROR \
		UINT32_C(0x20)
	/*
	 * This indicates that there was an error in the tunnel
	 * IP header checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_T_IP_CS_ERROR \
		UINT32_C(0x40)
	/*
	 * This indicates that there was an error in the tunnel
	 * UDP checksum.
	 */
	#define RX_PKT_CMPL_ERRORS_T_L4_CS_ERROR \
		UINT32_C(0x80)
	/*
	 * This indicates that there was a CRC error on either an FCoE
	 * or RoCE packet.  The itype indicates the packet type.
	 */
	#define RX_PKT_CMPL_ERRORS_CRC_ERROR \
		UINT32_C(0x100)
	/*
	 * This indicates that there was an error in the tunnel
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_MASK \
		UINT32_C(0xe00)
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_SFT                    9
	/*
	 * No additional error occurred on the tunnel portion
	 * of the packet of the packet does not have a tunnel.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_NO_ERROR \
		(UINT32_C(0x0) << 9)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6
	 * in the tunnel header.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_VERSION \
		(UINT32_C(0x1) << 9)
	/*
	 * Indicates that header length is out of range in the
	 * tunnel header. Valid for
	 * IPv4.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_HDR_LEN \
		(UINT32_C(0x2) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the PPPoE header length for a tunnel PPPoE
	 * packet.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_TUNNEL_TOTAL_ERROR \
		(UINT32_C(0x3) << 9)
	/*
	 * Indicates that physical packet is shorter than that claimed
	 * by the tunnel l3 header length. Valid for IPv4, or IPv6
	 * tunnel packet packets.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_IP_TOTAL_ERROR \
		(UINT32_C(0x4) << 9)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the tunnel UDP header length for a tunnel
	 * UDP packet that is not fragmented.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_UDP_TOTAL_ERROR \
		(UINT32_C(0x5) << 9)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0) in the tunnel header. Valid
	 * for IPv4, and IPv6.
	 */
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL \
		(UINT32_C(0x6) << 9)
	#define RX_PKT_CMPL_ERRORS_T_PKT_ERROR_LAST \
		RX_PKT_CMPL_ERRORS_T_PKT_ERROR_T_L3_BAD_TTL
	/*
	 * This indicates that there was an error in the inner
	 * portion of the packet when this
	 * field is non-zero.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_MASK \
		UINT32_C(0xf000)
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_SFT                      12
	/*
	 * No additional error occurred on the tunnel portion
	 * of the packet of the packet does not have a tunnel.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_NO_ERROR \
		(UINT32_C(0x0) << 12)
	/*
	 * Indicates that IP header version does not match
	 * expectation from L2 Ethertype for IPv4 and IPv6 or that
	 * option other than VFT was parsed on
	 * FCoE packet.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_VERSION \
		(UINT32_C(0x1) << 12)
	/*
	 * indicates that header length is out of range. Valid for
	 * IPv4 and RoCE
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_HDR_LEN \
		(UINT32_C(0x2) << 12)
	/*
	 * indicates that the IPv4 TTL or IPv6 hop limit check
	 * have failed (e.g. TTL = 0). Valid for IPv4, and IPv6
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L3_BAD_TTL \
		(UINT32_C(0x3) << 12)
	/*
	 * Indicates that physical packet is shorter than that
	 * claimed by the l3 header length. Valid for IPv4,
	 * IPv6 packet or RoCE packets.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_IP_TOTAL_ERROR \
		(UINT32_C(0x4) << 12)
	/*
	 * Indicates that the physical packet is shorter than that
	 * claimed by the UDP header length for a UDP packet that is
	 * not fragmented.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_UDP_TOTAL_ERROR \
		(UINT32_C(0x5) << 12)
	/*
	 * Indicates that TCP header length > IP payload. Valid for
	 * TCP packets only.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN \
		(UINT32_C(0x6) << 12)
	/* Indicates that TCP header length < 5. Valid for TCP. */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_HDR_LEN_TOO_SMALL \
		(UINT32_C(0x7) << 12)
	/*
	 * Indicates that TCP option headers result in a TCP header
	 * size that does not match data offset in TCP header. Valid
	 * for TCP.
	 */
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN \
		(UINT32_C(0x8) << 12)
	#define RX_PKT_CMPL_ERRORS_PKT_ERROR_LAST \
		RX_PKT_CMPL_ERRORS_PKT_ERROR_L4_BAD_OPT_LEN
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint16_t	cfa_code;
	uint32_t	reorder;
	/*
	 * This value holds the reordering sequence number for the packet.
	 * If the reordering sequence is not valid, then this value is zero.
	 * The reordering domain for the packet is in the bottom 8 to 10b of
	 * the rss_hash value.  The bottom 20b of this value contain the
	 * ordering domain value for the packet.
	 */
	#define RX_PKT_CMPL_REORDER_MASK UINT32_C(0xffffff)
	#define RX_PKT_CMPL_REORDER_SFT 0
} __attribute__((packed));

/* rx_tpa_start_cmpl (size:128b/16B) */
struct rx_tpa_start_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_START_CMPL_TYPE_MASK                UINT32_C(0x3f)
	#define RX_TPA_START_CMPL_TYPE_SFT                 0
	/*
	 * RX L2 TPA Start Completion:
	 * Completion at the beginning of a TPA operation.
	 * Length = 32B
	 */
	#define RX_TPA_START_CMPL_TYPE_RX_TPA_START          UINT32_C(0x13)
	#define RX_TPA_START_CMPL_TYPE_LAST \
		RX_TPA_START_CMPL_TYPE_RX_TPA_START
	#define RX_TPA_START_CMPL_FLAGS_MASK               UINT32_C(0xffc0)
	#define RX_TPA_START_CMPL_FLAGS_SFT                6
	/* This bit will always be '0' for TPA start completions. */
	#define RX_TPA_START_CMPL_FLAGS_ERROR               UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_MASK      UINT32_C(0x380)
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_SFT       7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm.  This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers.  Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_JUMBO \
		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_HDS \
		(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_JUMBO \
		(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_HDS \
		(UINT32_C(0x6) << 7)
	#define RX_TPA_START_CMPL_FLAGS_PLACEMENT_LAST \
		RX_TPA_START_CMPL_FLAGS_PLACEMENT_GRO_HDS
	/* This bit is '1' if the RSS field in this completion is valid. */
	#define RX_TPA_START_CMPL_FLAGS_RSS_VALID           UINT32_C(0x400)
	/* unused is 1 b */
	#define RX_TPA_START_CMPL_FLAGS_UNUSED              UINT32_C(0x800)
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 */
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_MASK          UINT32_C(0xf000)
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_SFT           12
	/*
	 * TCP Packet:
	 * Indicates that the packet was IP and TCP.
	 */
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_TCP \
		(UINT32_C(0x2) << 12)
	#define RX_TPA_START_CMPL_FLAGS_ITYPE_LAST \
		RX_TPA_START_CMPL_FLAGS_ITYPE_TCP
	/*
	 * This value indicates the amount of packet data written to the
	 * buffer the opaque field in this completion corresponds to.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	uint8_t	v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_TPA_START_CMPL_V1 UINT32_C(0x1)
	#define RX_TPA_START_CMPL_LAST RX_TPA_START_CMPL_V1
	/*
	 * This is the RSS hash type for the packet.  The value is packed
	 * {tuple_extrac_op[1:0],rss_profile_id[4:0],tuple_extrac_op[2]}.
	 *
	 * The value of tuple_extrac_op provides the information about
	 * what fields the hash was computed on.
	 * * 0: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of inner
	 * IP and TCP or UDP headers. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 1: The RSS hash was computed over source IP address and destination
	 * IP address of inner IP header. Note: For non-tunneled packets,
	 * the packet headers are considered inner packet headers for the RSS
	 * hash computation purpose.
	 * * 2: The RSS hash was computed over source IP address,
	 * destination IP address, source port, and destination port of
	 * IP and TCP or UDP headers of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 * * 3: The RSS hash was computed over source IP address and
	 * destination IP address of IP header of outer tunnel headers.
	 * Note: For non-tunneled packets, this value is not applicable.
	 *
	 * Note that 4-tuples values listed above are applicable
	 * for layer 4 protocols supported and enabled for RSS in the hardware,
	 * HWRM firmware, and drivers. For example, if RSS hash is supported and
	 * enabled for TCP traffic only, then the values of tuple_extract_op
	 * corresponding to 4-tuples are only valid for TCP traffic.
	 */
	uint8_t	rss_hash_type;
	/*
	 * This is the aggregation ID that the completion is associated
	 * with.  Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	uint16_t	agg_id;
	/* unused2 is 9 b */
	#define RX_TPA_START_CMPL_UNUSED2_MASK UINT32_C(0x1ff)
	#define RX_TPA_START_CMPL_UNUSED2_SFT 0
	/*
	 * This is the aggregation ID that the completion is associated
	 * with.  Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	#define RX_TPA_START_CMPL_AGG_ID_MASK UINT32_C(0xfe00)
	#define RX_TPA_START_CMPL_AGG_ID_SFT  9
	/*
	 * This value is the RSS hash value calculated for the packet
	 * based on the mode bits and key value in the VNIC.
	 */
	uint32_t	rss_hash;
} __attribute__((packed));

/* rx_tpa_start_cmpl_hi (size:128b/16B) */
struct rx_tpa_start_cmpl_hi {
	uint32_t	flags2;
	/*
	 * This indicates that the ip checksum was calculated for the
	 * inner packet and that the sum passed for all segments
	 * included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_IP_CS_CALC       UINT32_C(0x1)
	/*
	 * This indicates that the TCP, UDP or ICMP checksum was
	 * calculated for the inner packet and that the sum passed
	 * for all segments included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_L4_CS_CALC       UINT32_C(0x2)
	/*
	 * This indicates that the ip checksum was calculated for the
	 * tunnel header and that the sum passed for all segments
	 * included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_T_IP_CS_CALC     UINT32_C(0x4)
	/*
	 * This indicates that the UDP checksum was
	 * calculated for the tunnel packet and that the sum passed for
	 * all segments included in the aggregation.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_T_L4_CS_CALC     UINT32_C(0x8)
	/* This value indicates what format the metadata field is. */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_MASK UINT32_C(0xf0)
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_SFT  4
	/* No metadata informtaion.  Value is zero. */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_NONE \
		(UINT32_C(0x0) << 4)
	/*
	 * The metadata field contains the VLAN tag and TPID value.
	 * - metadata[11:0] contains the vlan VID value.
	 * - metadata[12] contains the vlan DE value.
	 * - metadata[15:13] contains the vlan PRI value.
	 * - metadata[31:16] contains the vlan TPID value.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_VLAN \
		(UINT32_C(0x1) << 4)
	#define RX_TPA_START_CMPL_FLAGS2_META_FORMAT_LAST \
		RX_TPA_START_CMPL_FLAGS2_META_FORMAT_VLAN
	/*
	 * This field indicates the IP type for the inner-most IP header.
	 * A value of '0' indicates IPv4.  A value of '1' indicates IPv6.
	 */
	#define RX_TPA_START_CMPL_FLAGS2_IP_TYPE          UINT32_C(0x100)
	/*
	 * This is data from the CFA block as indicated by the meta_format
	 * field.
	 */
	uint32_t	metadata;
	/* When meta_format=1, this value is the VLAN VID. */
	#define RX_TPA_START_CMPL_METADATA_VID_MASK UINT32_C(0xfff)
	#define RX_TPA_START_CMPL_METADATA_VID_SFT  0
	/* When meta_format=1, this value is the VLAN DE. */
	#define RX_TPA_START_CMPL_METADATA_DE       UINT32_C(0x1000)
	/* When meta_format=1, this value is the VLAN PRI. */
	#define RX_TPA_START_CMPL_METADATA_PRI_MASK UINT32_C(0xe000)
	#define RX_TPA_START_CMPL_METADATA_PRI_SFT  13
	/* When meta_format=1, this value is the VLAN TPID. */
	#define RX_TPA_START_CMPL_METADATA_TPID_MASK UINT32_C(0xffff0000)
	#define RX_TPA_START_CMPL_METADATA_TPID_SFT 16
	uint16_t	v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_TPA_START_CMPL_V2     UINT32_C(0x1)
	/*
	 * This field identifies the CFA action rule that was used for this
	 * packet.
	 */
	uint16_t	cfa_code;
	/*
	 * This is the size in bytes of the inner most L4 header.
	 * This can be subtracted from the payload_offset to determine
	 * the start of the inner most L4 header.
	 */
	uint32_t	inner_l4_size_inner_l3_offset_inner_l2_offset_outer_l3_offset;
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the outer L3 header.  If there is no outer L3 header, then this
	 * value is zero.
	 */
	#define RX_TPA_START_CMPL_OUTER_L3_OFFSET_MASK UINT32_C(0x1ff)
	#define RX_TPA_START_CMPL_OUTER_L3_OFFSET_SFT 0
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the inner most L2 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L2_OFFSET_MASK UINT32_C(0x3fe00)
	#define RX_TPA_START_CMPL_INNER_L2_OFFSET_SFT 9
	/*
	 * This is the offset from the beginning of the packet in bytes for
	 * the inner most L3 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L3_OFFSET_MASK UINT32_C(0x7fc0000)
	#define RX_TPA_START_CMPL_INNER_L3_OFFSET_SFT 18
	/*
	 * This is the size in bytes of the inner most L4 header.
	 * This can be subtracted from the payload_offset to determine
	 * the start of the inner most L4 header.
	 */
	#define RX_TPA_START_CMPL_INNER_L4_SIZE_MASK  UINT32_C(0xf8000000)
	#define RX_TPA_START_CMPL_INNER_L4_SIZE_SFT   27
} __attribute__((packed));

/* rx_tpa_end_cmpl (size:128b/16B) */
struct rx_tpa_end_cmpl {
	uint16_t	flags_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define RX_TPA_END_CMPL_TYPE_MASK                UINT32_C(0x3f)
	#define RX_TPA_END_CMPL_TYPE_SFT                 0
	/*
	 * RX L2 TPA End Completion:
	 * Completion at the end of a TPA operation.
	 * Length = 32B
	 */
	#define RX_TPA_END_CMPL_TYPE_RX_TPA_END            UINT32_C(0x15)
	#define RX_TPA_END_CMPL_TYPE_LAST \
		RX_TPA_END_CMPL_TYPE_RX_TPA_END
	#define RX_TPA_END_CMPL_FLAGS_MASK               UINT32_C(0xffc0)
	#define RX_TPA_END_CMPL_FLAGS_SFT                6
	/*
	 * When this bit is '1', it indicates a packet that has an
	 * error of some type.  Type of error is indicated in
	 * error_flags.
	 */
	#define RX_TPA_END_CMPL_FLAGS_ERROR               UINT32_C(0x40)
	/* This field indicates how the packet was placed in the buffer. */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_MASK      UINT32_C(0x380)
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_SFT       7
	/*
	 * Jumbo:
	 * TPA Packet was placed using jumbo algorithm.  This means
	 * that the first buffer will be filled with data before
	 * moving to aggregation buffers.  Each aggregation buffer
	 * will be filled before moving to the next aggregation
	 * buffer.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_JUMBO \
		(UINT32_C(0x1) << 7)
	/*
	 * Header/Data Separation:
	 * Packet was placed using Header/Data separation algorithm.
	 * The separation location is indicated by the itype field.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_HDS \
		(UINT32_C(0x2) << 7)
	/*
	 * GRO/Jumbo:
	 * Packet will be placed using GRO/Jumbo where the first
	 * packet is filled with data. Subsequent packets will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_JUMBO \
		(UINT32_C(0x5) << 7)
	/*
	 * GRO/Header-Data Separation:
	 * Packet will be placed using GRO/HDS where the header
	 * is in the first packet.
	 * Payload of each packet will be
	 * placed such that any one packet does not span two
	 * aggregation buffers unless it starts at the beginning of
	 * an aggregation buffer.
	 */
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_HDS \
		(UINT32_C(0x6) << 7)
	#define RX_TPA_END_CMPL_FLAGS_PLACEMENT_LAST \
		RX_TPA_END_CMPL_FLAGS_PLACEMENT_GRO_HDS
	/* unused is 2 b */
	#define RX_TPA_END_CMPL_FLAGS_UNUSED_MASK         UINT32_C(0xc00)
	#define RX_TPA_END_CMPL_FLAGS_UNUSED_SFT          10
	/*
	 * This value indicates what the inner packet determined for the
	 * packet was.
	 *  - 2 TCP Packet
	 *      Indicates that the packet was IP and TCP.  This indicates
	 *      that the ip_cs field is valid and that the tcp_udp_cs
	 *      field is valid and contains the TCP checksum.
	 *      This also indicates that the payload_offset field is valid.
	 */
	#define RX_TPA_END_CMPL_FLAGS_ITYPE_MASK          UINT32_C(0xf000)
	#define RX_TPA_END_CMPL_FLAGS_ITYPE_SFT           12
	/*
	 * This value is zero for TPA End completions.
	 * There is no data in the buffer that corresponds to the opaque
	 * value in this completion.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this completion
	 * corresponds to.
	 */
	uint32_t	opaque;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	uint8_t	agg_bufs_v1;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_TPA_END_CMPL_V1           UINT32_C(0x1)
	/*
	 * This value is the number of aggregation buffers that follow this
	 * entry in the completion ring that are a part of this aggregation
	 * packet.
	 * If the value is zero, then the packet is completely contained
	 * in the buffer space provided in the aggregation start completion.
	 */
	#define RX_TPA_END_CMPL_AGG_BUFS_MASK UINT32_C(0x7e)
	#define RX_TPA_END_CMPL_AGG_BUFS_SFT 1
	/* This value is the number of segments in the TPA operation. */
	uint8_t	tpa_segs;
	/*
	 * This value indicates the offset in bytes from the beginning of the packet
	 * where the inner payload starts.  This value is valid for TCP, UDP,
	 * FCoE, and RoCE packets.
	 *
	 * A value of zero indicates an offset of 256 bytes.
	 */
	uint8_t	payload_offset;
	uint8_t	agg_id;
	/* unused2 is 1 b */
	#define RX_TPA_END_CMPL_UNUSED2     UINT32_C(0x1)
	/*
	 * This is the aggregation ID that the completion is associated
	 * with.  Use this number to correlate the TPA start completion
	 * with the TPA end completion.
	 */
	#define RX_TPA_END_CMPL_AGG_ID_MASK UINT32_C(0xfe)
	#define RX_TPA_END_CMPL_AGG_ID_SFT  1
	/*
	 * For non-GRO packets, this value is the
	 * timestamp delta between earliest and latest timestamp values for
	 * TPA packet. If packets were not time stamped, then delta will be
	 * zero.
	 *
	 * For GRO packets, this field is zero except for the following
	 * sub-fields.
	 * - tsdelta[31]
	 *     Timestamp present indication.  When '0', no Timestamp
	 *     option is in the packet.  When '1', then a Timestamp
	 *     option is present in the packet.
	 */
	uint32_t	tsdelta;
} __attribute__((packed));

/* rx_tpa_end_cmpl_hi (size:128b/16B) */
struct rx_tpa_end_cmpl_hi {
	/*
	 * This value is the number of duplicate ACKs that have been
	 * received as part of the TPA operation.
	 */
	uint32_t	tpa_dup_acks;
	/*
	 * This value is the number of duplicate ACKs that have been
	 * received as part of the TPA operation.
	 */
	#define RX_TPA_END_CMPL_TPA_DUP_ACKS_MASK UINT32_C(0xf)
	#define RX_TPA_END_CMPL_TPA_DUP_ACKS_SFT 0
	/*
	 * This value is the valid when TPA completion is active.  It
	 * indicates the length of the longest segment of the TPA operation
	 * for LRO mode and the length of the first segment in GRO mode.
	 *
	 * This value may be used by GRO software to re-construct the original
	 * packet stream from the TPA packet.  This is the length of all
	 * but the last segment for GRO.  In LRO mode this value may be used
	 * to indicate MSS size to the stack.
	 */
	uint16_t	tpa_seg_len;
	/* unused4 is 16 b */
	uint16_t	unused3;
	uint16_t	errors_v2;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_TPA_END_CMPL_V2                             UINT32_C(0x1)
	#define RX_TPA_END_CMPL_ERRORS_MASK                    UINT32_C(0xfffe)
	#define RX_TPA_END_CMPL_ERRORS_SFT                     1
	/*
	 * This error indicates that there was some sort of problem with
	 * the BDs for the packet that was found after part of the
	 * packet was already placed.  The packet should be treated as
	 * invalid.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_MASK        UINT32_C(0xe)
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_SFT         1
	/*
	 * This error occurs when there is a fatal HW problem in
	 * the chip only.  It indicates that there were not
	 * BDs on chip but that there was adequate reservation.
	 * provided by the TPA block.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_NOT_ON_CHIP \
		(UINT32_C(0x2) << 1)
	/*
	 * This error occurs when TPA block was not configured to
	 * reserve adequate BDs for TPA operations on this RX
	 * ring.  All data for the TPA operation was not placed.
	 *
	 * This error can also be generated when the number of
	 * segments is not programmed correctly in TPA and the
	 * 33 total aggregation buffers allowed for the TPA
	 * operation has been exceeded.
	 */
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR \
		(UINT32_C(0x4) << 1)
	#define RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_LAST \
		RX_TPA_END_CMPL_ERRORS_BUFFER_ERROR_RSV_ERROR
	/* unused5 is 16 b */
	uint16_t	unused_4;
	/*
	 * This is the opaque value that was completed for the TPA start
	 * completion that corresponds to this TPA end completion.
	 */
	uint32_t	start_opaque;
} __attribute__((packed));

/* rx_abuf_cmpl (size:128b/16B) */
struct rx_abuf_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define RX_ABUF_CMPL_TYPE_MASK  UINT32_C(0x3f)
	#define RX_ABUF_CMPL_TYPE_SFT   0
	/*
	 * RX Aggregation Buffer completion :
	 * Completion of an L2 aggregation buffer in support of
	 * TPA, HDS, or Jumbo packet completion.  Length = 16B
	 */
	#define RX_ABUF_CMPL_TYPE_RX_AGG  UINT32_C(0x12)
	#define RX_ABUF_CMPL_TYPE_LAST   RX_ABUF_CMPL_TYPE_RX_AGG
	/*
	 * This is the length of the data for the packet stored in this
	 * aggregation buffer identified by the opaque value.  This does not
	 * include the length of any
	 * data placed in other aggregation BDs or in the packet or buffer
	 * BDs.   This length does not include any space added due to
	 * hdr_offset register during HDS placement mode.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this aggregation
	 * buffer corresponds to.
	 */
	uint32_t	opaque;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define RX_ABUF_CMPL_V     UINT32_C(0x1)
	/* unused3 is 32 b */
	uint32_t	unused_2;
} __attribute__((packed));

/* eject_cmpl (size:128b/16B) */
struct eject_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define EJECT_CMPL_TYPE_MASK      UINT32_C(0x3f)
	#define EJECT_CMPL_TYPE_SFT       0
	/*
	 * Statistics Ejection Completion:
	 * Completion of statistics data ejection buffer.
	 * Length = 16B
	 */
	#define EJECT_CMPL_TYPE_STAT_EJECT  UINT32_C(0x1a)
	#define EJECT_CMPL_TYPE_LAST       EJECT_CMPL_TYPE_STAT_EJECT
	/*
	 * This is the length of the statistics data stored in this
	 * buffer.
	 */
	uint16_t	len;
	/*
	 * This is a copy of the opaque field from the RX BD this ejection
	 * buffer corresponds to.
	 */
	uint32_t	opaque;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define EJECT_CMPL_V     UINT32_C(0x1)
	/* unused3 is 32 b */
	uint32_t	unused_2;
} __attribute__((packed));

/* hwrm_cmpl (size:128b/16B) */
struct hwrm_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_CMPL_TYPE_MASK     UINT32_C(0x3f)
	#define HWRM_CMPL_TYPE_SFT      0
	/*
	 * HWRM Command Completion:
	 * Completion of an HWRM command.
	 */
	#define HWRM_CMPL_TYPE_HWRM_DONE  UINT32_C(0x20)
	#define HWRM_CMPL_TYPE_LAST      HWRM_CMPL_TYPE_HWRM_DONE
	/* This is the sequence_id of the HWRM command that has completed. */
	uint16_t	sequence_id;
	/* unused2 is 32 b */
	uint32_t	unused_1;
	uint32_t	v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_CMPL_V     UINT32_C(0x1)
	/* unused4 is 32 b */
	uint32_t	unused_3;
} __attribute__((packed));

/* hwrm_fwd_req_cmpl (size:128b/16B) */
struct hwrm_fwd_req_cmpl {
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	uint16_t	req_len_type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_FWD_REQ_CMPL_TYPE_MASK        UINT32_C(0x3f)
	#define HWRM_FWD_REQ_CMPL_TYPE_SFT         0
	/* Forwarded HWRM Request */
	#define HWRM_FWD_REQ_CMPL_TYPE_HWRM_FWD_REQ  UINT32_C(0x22)
	#define HWRM_FWD_REQ_CMPL_TYPE_LAST \
		HWRM_FWD_REQ_CMPL_TYPE_HWRM_FWD_REQ
	/* Length of forwarded request in bytes. */
	#define HWRM_FWD_REQ_CMPL_REQ_LEN_MASK     UINT32_C(0xffc0)
	#define HWRM_FWD_REQ_CMPL_REQ_LEN_SFT      6
	/*
	 * Source ID of this request.
	 * Typically used in forwarding requests and responses.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	source_id;
	/* unused1 is 32 b */
	uint32_t	unused0;
	/* Address of forwarded request. */
	uint32_t	req_buf_addr_v[2];
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_FWD_REQ_CMPL_V                UINT32_C(0x1)
	/* Address of forwarded request. */
	#define HWRM_FWD_REQ_CMPL_REQ_BUF_ADDR_MASK UINT32_C(0xfffffffe)
	#define HWRM_FWD_REQ_CMPL_REQ_BUF_ADDR_SFT 1
} __attribute__((packed));

/* hwrm_fwd_resp_cmpl (size:128b/16B) */
struct hwrm_fwd_resp_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_FWD_RESP_CMPL_TYPE_MASK         UINT32_C(0x3f)
	#define HWRM_FWD_RESP_CMPL_TYPE_SFT          0
	/* Forwarded HWRM Response */
	#define HWRM_FWD_RESP_CMPL_TYPE_HWRM_FWD_RESP  UINT32_C(0x24)
	#define HWRM_FWD_RESP_CMPL_TYPE_LAST \
		HWRM_FWD_RESP_CMPL_TYPE_HWRM_FWD_RESP
	/*
	 * Source ID of this response.
	 * Typically used in forwarding requests and responses.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	source_id;
	/* Length of forwarded response in bytes. */
	uint16_t	resp_len;
	/* unused2 is 16 b */
	uint16_t	unused_1;
	/* Address of forwarded request. */
	uint32_t	resp_buf_addr_v[2];
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_FWD_RESP_CMPL_V                 UINT32_C(0x1)
	/* Address of forwarded request. */
	#define HWRM_FWD_RESP_CMPL_RESP_BUF_ADDR_MASK UINT32_C(0xfffffffe)
	#define HWRM_FWD_RESP_CMPL_RESP_BUF_ADDR_SFT 1
} __attribute__((packed));

/* hwrm_async_event_cmpl (size:128b/16B) */
struct hwrm_async_event_cmpl {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_MASK            UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_HWRM_ASYNC_EVENT  UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link status changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_STATUS_CHANGE \
		UINT32_C(0x0)
	/* Link MTU changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_MTU_CHANGE \
		UINT32_C(0x1)
	/* Link speed changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CHANGE \
		UINT32_C(0x2)
	/* DCB Configuration changed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_DCB_CONFIG_CHANGE \
		UINT32_C(0x3)
	/* Port connection not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PORT_CONN_NOT_ALLOWED \
		UINT32_C(0x4)
	/* Link speed configuration was not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED \
		UINT32_C(0x5)
	/* Link speed configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LINK_SPEED_CFG_CHANGE \
		UINT32_C(0x6)
	/* Port PHY configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PORT_PHY_CFG_CHANGE \
		UINT32_C(0x7)
	/* Function driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_DRVR_UNLOAD \
		UINT32_C(0x10)
	/* Function driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_DRVR_LOAD \
		UINT32_C(0x11)
	/* Function FLR related processing has completed */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_FUNC_FLR_PROC_CMPLT \
		UINT32_C(0x12)
	/* PF driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_DRVR_UNLOAD \
		UINT32_C(0x20)
	/* PF driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_DRVR_LOAD \
		UINT32_C(0x21)
	/* VF Function Level Reset (FLR) */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_FLR \
		UINT32_C(0x30)
	/* VF MAC Address Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_MAC_ADDR_CHANGE \
		UINT32_C(0x31)
	/* PF-VF communication channel status change. */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_PF_VF_COMM_STATUS_CHANGE \
		UINT32_C(0x32)
	/* VF Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_VF_CFG_CHANGE \
		UINT32_C(0x33)
	/* LLFC/PFC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LLFC_PFC_CHANGE \
		UINT32_C(0x34)
	/* HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HWRM_ERROR \
		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_EVENT_ID_HWRM_ERROR
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_status_change (size:128b/16B) */
struct hwrm_async_event_cmpl_link_status_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link status changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LINK_STATUS_CHANGE \
		UINT32_C(0x0)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_ID_LINK_STATUS_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates link status change */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE \
		UINT32_C(0x1)
	/*
	 * If this bit set to 0, then it indicates that the link
	 * was up and it went down.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_DOWN \
		UINT32_C(0x0)
	/*
	 * If this bit is set to 1, then it indicates that the link
	 * was down and it went up.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_UP \
		UINT32_C(0x1)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_LINK_CHANGE_UP
	/* Indicates the physical port this link status change occur */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_MASK \
		UINT32_C(0xe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_SFT \
		1
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff0)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_STATUS_CHANGE_EVENT_DATA1_PORT_ID_SFT \
		4
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_mtu_change (size:128b/16B) */
struct hwrm_async_event_cmpl_link_mtu_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link MTU changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LINK_MTU_CHANGE \
		UINT32_C(0x1)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_ID_LINK_MTU_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* The new MTU of the link in bytes. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_DATA1_NEW_MTU_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_MTU_CHANGE_EVENT_DATA1_NEW_MTU_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_speed_change (size:128b/16B) */
struct hwrm_async_event_cmpl_link_speed_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link speed changed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LINK_SPEED_CHANGE \
		UINT32_C(0x2)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_ID_LINK_SPEED_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * When this bit is '1', the link was forced to the
	 * force_link_speed value.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_FORCE \
		UINT32_C(0x1)
	/* The new link speed in 100 Mbps units. */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_MASK \
		UINT32_C(0xfffe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_SFT \
		1
	/* 100Mb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100MB \
		(UINT32_C(0x1) << 1)
	/* 1Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_1GB \
		(UINT32_C(0xa) << 1)
	/* 2Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_2GB \
		(UINT32_C(0x14) << 1)
	/* 25Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_2_5GB \
		(UINT32_C(0x19) << 1)
	/* 10Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_10GB \
		(UINT32_C(0x64) << 1)
	/* 20Mb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_20GB \
		(UINT32_C(0xc8) << 1)
	/* 25Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_25GB \
		(UINT32_C(0xfa) << 1)
	/* 40Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_40GB \
		(UINT32_C(0x190) << 1)
	/* 50Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_50GB \
		(UINT32_C(0x1f4) << 1)
	/* 100Gb link speed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100GB \
		(UINT32_C(0x3e8) << 1)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_NEW_LINK_SPEED_100MBPS_100GB
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff0000)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CHANGE_EVENT_DATA1_PORT_ID_SFT \
		16
} __attribute__((packed));

/* hwrm_async_event_cmpl_dcb_config_change (size:128b/16B) */
struct hwrm_async_event_cmpl_dcb_config_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* DCB Configuration changed */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_DCB_CONFIG_CHANGE \
		UINT32_C(0x3)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_ID_DCB_CONFIG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	/* ETS configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_ETS \
		UINT32_C(0x1)
	/* PFC configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_PFC \
		UINT32_C(0x2)
	/* APP configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA2_APP \
		UINT32_C(0x4)
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_PORT_ID_SFT \
		0
	/* Priority recommended for RoCE traffic */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_MASK \
		UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_SFT \
		16
	/* none is 255 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_NONE \
		(UINT32_C(0xff) << 16)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_LAST \
		HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_ROCE_PRIORITY_NONE
	/* Priority recommended for L2 traffic */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_MASK \
		UINT32_C(0xff000000)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_SFT \
		24
	/* none is 255 */
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_NONE \
		(UINT32_C(0xff) << 24)
	#define HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_LAST \
		HWRM_ASYNC_EVENT_CMPL_DCB_CONFIG_CHANGE_EVENT_DATA1_RECOMMEND_L2_PRIORITY_NONE
} __attribute__((packed));

/* hwrm_async_event_cmpl_port_conn_not_allowed (size:128b/16B) */
struct hwrm_async_event_cmpl_port_conn_not_allowed {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_SFT \
		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Port connection not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_PORT_CONN_NOT_ALLOWED \
		UINT32_C(0x4)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_ID_PORT_CONN_NOT_ALLOWED
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_PORT_ID_SFT \
		0
	/*
	 * This value indicates the current port level enforcement policy
	 * for the optics module when there is an optical module mismatch
	 * and port is not connected.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_MASK \
		UINT32_C(0xff0000)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_SFT \
		16
	/* No enforcement */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_NONE \
		(UINT32_C(0x0) << 16)
	/* Disable Transmit side Laser. */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_DISABLETX \
		(UINT32_C(0x1) << 16)
	/* Raise a warning message. */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_WARNINGMSG \
		(UINT32_C(0x2) << 16)
	/* Power down the module. */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_PWRDOWN \
		(UINT32_C(0x3) << 16)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_LAST \
		HWRM_ASYNC_EVENT_CMPL_PORT_CONN_NOT_ALLOWED_EVENT_DATA1_ENFORCEMENT_POLICY_PWRDOWN
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_speed_cfg_not_allowed (size:128b/16B) */
struct hwrm_async_event_cmpl_link_speed_cfg_not_allowed {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_SFT \
		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link speed configuration was not allowed */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED \
		UINT32_C(0x5)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_ID_LINK_SPEED_CFG_NOT_ALLOWED
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_NOT_ALLOWED_EVENT_DATA1_PORT_ID_SFT \
		0
} __attribute__((packed));

/* hwrm_async_event_cmpl_link_speed_cfg_change (size:128b/16B) */
struct hwrm_async_event_cmpl_link_speed_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_SFT \
		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Link speed configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LINK_SPEED_CFG_CHANGE \
		UINT32_C(0x6)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_ID_LINK_SPEED_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT \
		0
	/*
	 * If set to 1, it indicates that the supported link speeds
	 * configuration on the port has changed.
	 * If set to 0, then there is no change in supported link speeds
	 * configuration.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_SUPPORTED_LINK_SPEEDS_CHANGE \
		UINT32_C(0x10000)
	/*
	 * If set to 1, it indicates that the link speed configuration
	 * on the port has become illegal or invalid.
	 * If set to 0, then the link speed configuration on the port is
	 * legal or valid.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LINK_SPEED_CFG_CHANGE_EVENT_DATA1_ILLEGAL_LINK_SPEED_CFG \
		UINT32_C(0x20000)
} __attribute__((packed));

/* hwrm_async_event_cmpl_port_phy_cfg_change (size:128b/16B) */
struct hwrm_async_event_cmpl_port_phy_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_SFT \
		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Port PHY configuration change */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_PORT_PHY_CFG_CHANGE \
		UINT32_C(0x7)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_ID_PORT_PHY_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PORT_ID_SFT \
		0
	/*
	 * If set to 1, it indicates that the FEC
	 * configuration on the port has changed.
	 * If set to 0, then there is no change in FEC configuration.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_FEC_CFG_CHANGE \
		UINT32_C(0x10000)
	/*
	 * If set to 1, it indicates that the EEE configuration
	 * on the port has changed.
	 * If set to 0, then there is no change in EEE configuration
	 * on the port.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_EEE_CFG_CHANGE \
		UINT32_C(0x20000)
	/*
	 * If set to 1, it indicates that the pause configuration
	 * on the PHY has changed.
	 * If set to 0, then there is no change in the pause
	 * configuration on the PHY.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PORT_PHY_CFG_CHANGE_EVENT_DATA1_PAUSE_CFG_CHANGE \
		UINT32_C(0x40000)
} __attribute__((packed));

/* hwrm_async_event_cmpl_func_drvr_unload (size:128b/16B) */
struct hwrm_async_event_cmpl_func_drvr_unload {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Function driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_FUNC_DRVR_UNLOAD \
		UINT32_C(0x10)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_ID_FUNC_DRVR_UNLOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_SFT \
		0
} __attribute__((packed));

/* hwrm_async_event_cmpl_func_drvr_load (size:128b/16B) */
struct hwrm_async_event_cmpl_func_drvr_load {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Function driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_FUNC_DRVR_LOAD \
		UINT32_C(0x11)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_ID_FUNC_DRVR_LOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_DATA1_FUNC_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_DRVR_LOAD_EVENT_DATA1_FUNC_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_func_flr_proc_cmplt (size:128b/16B) */
struct hwrm_async_event_cmpl_func_flr_proc_cmplt {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_SFT \
		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* Function FLR related processing has completed */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_FUNC_FLR_PROC_CMPLT \
		UINT32_C(0x12)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_ID_FUNC_FLR_PROC_CMPLT
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Function ID */
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_DATA1_FUNC_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_FUNC_FLR_PROC_CMPLT_EVENT_DATA1_FUNC_ID_SFT \
		0
} __attribute__((packed));

/* hwrm_async_event_cmpl_pf_drvr_unload (size:128b/16B) */
struct hwrm_async_event_cmpl_pf_drvr_unload {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PF driver unloaded */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_PF_DRVR_UNLOAD \
		UINT32_C(0x20)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_ID_PF_DRVR_UNLOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PF ID */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_FUNC_ID_SFT 0
	/* Indicates the physical port this pf belongs to */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_PORT_MASK \
		UINT32_C(0x70000)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_UNLOAD_EVENT_DATA1_PORT_SFT    16
} __attribute__((packed));

/* hwrm_async_event_cmpl_pf_drvr_load (size:128b/16B) */
struct hwrm_async_event_cmpl_pf_drvr_load {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PF driver loaded */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_PF_DRVR_LOAD \
		UINT32_C(0x21)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_ID_PF_DRVR_LOAD
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* PF ID */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_FUNC_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_FUNC_ID_SFT 0
	/* Indicates the physical port this pf belongs to */
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_PORT_MASK \
		UINT32_C(0x70000)
	#define HWRM_ASYNC_EVENT_CMPL_PF_DRVR_LOAD_EVENT_DATA1_PORT_SFT    16
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_flr (size:128b/16B) */
struct hwrm_async_event_cmpl_vf_flr {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_VF_FLR_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* VF Function Level Reset (FLR) */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_VF_FLR UINT32_C(0x30)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_ID_VF_FLR
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* VF ID */
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_VF_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_FLR_EVENT_DATA1_VF_ID_SFT 0
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_mac_addr_change (size:128b/16B) */
struct hwrm_async_event_cmpl_vf_mac_addr_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* VF MAC Address Change */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_VF_MAC_ADDR_CHANGE \
		UINT32_C(0x31)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_ID_VF_MAC_ADDR_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* VF ID */
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_DATA1_VF_ID_MASK \
		UINT32_C(0xffff)
	#define HWRM_ASYNC_EVENT_CMPL_VF_MAC_ADDR_CHANGE_EVENT_DATA1_VF_ID_SFT \
		0
} __attribute__((packed));

/* hwrm_async_event_cmpl_pf_vf_comm_status_change (size:128b/16B) */
struct hwrm_async_event_cmpl_pf_vf_comm_status_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_SFT \
		0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* PF-VF communication channel status change. */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_PF_VF_COMM_STATUS_CHANGE \
		UINT32_C(0x32)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_ID_PF_VF_COMM_STATUS_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_V \
		UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/*
	 * If this bit is set to 1, then it indicates that the PF-VF
	 * communication was lost and it is established.
	 * If this bit set to 0, then it indicates that the PF-VF
	 * communication was established and it is lost.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_PF_VF_COMM_STATUS_CHANGE_EVENT_DATA1_COMM_ESTABLISHED \
		UINT32_C(0x1)
} __attribute__((packed));

/* hwrm_async_event_cmpl_vf_cfg_change (size:128b/16B) */
struct hwrm_async_event_cmpl_vf_cfg_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* VF Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_VF_CFG_CHANGE \
		UINT32_C(0x33)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_ID_VF_CFG_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/*
	 * Each flag provided in this field indicates a specific VF
	 * configuration change. At least one of these flags shall be set to 1
	 * when an asynchronous event completion of this type is provided
	 * by the HWRM.
	 */
	uint32_t	event_data1;
	/*
	 * If this bit is set to 1, then the value of MTU
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_MTU_CHANGE \
		UINT32_C(0x1)
	/*
	 * If this bit is set to 1, then the value of MRU
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_MRU_CHANGE \
		UINT32_C(0x2)
	/*
	 * If this bit is set to 1, then the value of default MAC
	 * address was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_DFLT_MAC_ADDR_CHANGE \
		UINT32_C(0x4)
	/*
	 * If this bit is set to 1, then the value of default VLAN
	 * was changed on this VF.
	 * If set to 0, then this bit should be ignored.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_VF_CFG_CHANGE_EVENT_DATA1_DFLT_VLAN_CHANGE \
		UINT32_C(0x8)
} __attribute__((packed));

/* hwrm_async_event_cmpl_llfc_pfc_change (size:128b/16B) */
struct hwrm_async_event_cmpl_llfc_pfc_change {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_TYPE_HWRM_ASYNC_EVENT
	/* unused1 is 10 b */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_UNUSED1_MASK \
		UINT32_C(0xffc0)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_UNUSED1_SFT          6
	/* Identifiers of events. */
	uint16_t	event_id;
	/* LLFC/PFC Configuration Change */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LLFC_PFC_CHANGE \
		UINT32_C(0x34)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_ID_LLFC_PFC_CHANGE
	/* Event specific data */
	uint32_t	event_data2;
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_OPAQUE_MASK \
		UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Indicates llfc pfc status change */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_MASK \
		UINT32_C(0x3)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_SFT \
		0
	/*
	 * If this field set to 1, then it indicates that llfc is
	 * enabled.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_LLFC \
		UINT32_C(0x1)
	/*
	 * If this field is set to 2, then it indicates that pfc
	 * is enabled.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_PFC \
		UINT32_C(0x2)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_LAST \
		HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_LLFC_PFC_PFC
	/* Indicates the physical port this llfc pfc change occur */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_MASK \
		UINT32_C(0x1c)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_SFT \
		2
	/* PORT ID */
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_ID_MASK \
		UINT32_C(0x1fffe0)
	#define HWRM_ASYNC_EVENT_CMPL_LLFC_PFC_CHANGE_EVENT_DATA1_PORT_ID_SFT \
		5
} __attribute__((packed));

/* hwrm_async_event_cmpl_hwrm_error (size:128b/16B) */
struct hwrm_async_event_cmpl_hwrm_error {
	uint16_t	type;
	/*
	 * This field indicates the exact type of the completion.
	 * By convention, the LSB identifies the length of the
	 * record in 16B units.  Even values indicate 16B
	 * records.  Odd values indicate 32B
	 * records.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_MASK \
		UINT32_C(0x3f)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_SFT             0
	/* HWRM Asynchronous Event Information */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_HWRM_ASYNC_EVENT \
		UINT32_C(0x2e)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_LAST \
		HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_TYPE_HWRM_ASYNC_EVENT
	/* Identifiers of events. */
	uint16_t	event_id;
	/* HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_HWRM_ERROR \
		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_LAST \
		HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_ID_HWRM_ERROR
	/* Event specific data */
	uint32_t	event_data2;
	/* Severity of HWRM Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_MASK \
		UINT32_C(0xff)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_SFT     0
	/* Warning */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_WARNING \
		UINT32_C(0x0)
	/* Non-fatal Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_NONFATAL \
		UINT32_C(0x1)
	/* Fatal Error */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_FATAL \
		UINT32_C(0x2)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_LAST \
		HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA2_SEVERITY_FATAL
	uint8_t	opaque_v;
	/*
	 * This value is written by the NIC such that it will be different
	 * for each pass through the completion queue.   The even passes
	 * will write 1.  The odd passes will write 0.
	 */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_V          UINT32_C(0x1)
	/* opaque is 7 b */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_OPAQUE_MASK UINT32_C(0xfe)
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_OPAQUE_SFT 1
	/* 8-lsb timestamp from POR (100-msec resolution) */
	uint8_t	timestamp_lo;
	/* 16-lsb timestamp from POR (100-msec resolution) */
	uint16_t	timestamp_hi;
	/* Event specific data */
	uint32_t	event_data1;
	/* Time stamp for error event */
	#define HWRM_ASYNC_EVENT_CMPL_HWRM_ERROR_EVENT_DATA1_TIMESTAMP \
		UINT32_C(0x1)
} __attribute__((packed));

/*******************
 * hwrm_func_reset *
 *******************/


/* hwrm_func_reset_input (size:192b/24B) */
struct hwrm_func_reset_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id_valid field to be
	 * configured.
	 */
	#define HWRM_FUNC_RESET_INPUT_ENABLES_VF_ID_VALID     UINT32_C(0x1)
	/*
	 * The ID of the VF that this PF is trying to reset.
	 * Only the parent PF shall be allowed to reset a child VF.
	 *
	 * A parent PF driver shall use this field only when a specific child VF
	 * is requested to be reset.
	 */
	uint16_t	vf_id;
	/* This value indicates the level of a function reset. */
	uint8_t	func_reset_level;
	/*
	 * Reset the caller function and its children VFs (if any). If no
	 * children functions exist, then reset the caller function only.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETALL \
		UINT32_C(0x0)
	/* Reset the caller function only */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETME \
		UINT32_C(0x1)
	/*
	 * Reset all children VFs of the caller function driver if the
	 * caller is a PF driver.
	 * It is an error to specify this level by a VF driver.
	 * It is an error to specify this level by a PF driver with
	 * no children VFs.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETCHILDREN \
		UINT32_C(0x2)
	/*
	 * Reset a specific VF of the caller function driver if the caller
	 * is the parent PF driver.
	 * It is an error to specify this level by a VF driver.
	 * It is an error to specify this level by a PF driver that is not
	 * the parent of the VF that is being requested to reset.
	 */
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETVF \
		UINT32_C(0x3)
	#define HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_LAST \
		HWRM_FUNC_RESET_INPUT_FUNC_RESET_LEVEL_RESETVF
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_func_reset_output (size:128b/16B) */
struct hwrm_func_reset_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_func_getfid *
 ********************/


/* hwrm_func_getfid_input (size:192b/24B) */
struct hwrm_func_getfid_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the pci_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_GETFID_INPUT_ENABLES_PCI_ID     UINT32_C(0x1)
	/*
	 * This value is the PCI ID of the queried function.
	 * If ARI is enabled, then it is
	 * Bus Number (8b):Function Number(8b). Otherwise, it is
	 * Bus Number (8b):Device Number (5b):Function Number(3b).
	 */
	uint16_t	pci_id;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_func_getfid_output (size:128b/16B) */
struct hwrm_func_getfid_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * FID value.  This value is used to identify operations on the PCI
	 * bus as belonging to a particular PCI function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_vf_alloc *
 **********************/


/* hwrm_func_vf_alloc_input (size:192b/24B) */
struct hwrm_func_vf_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the first_vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_ALLOC_INPUT_ENABLES_FIRST_VF_ID     UINT32_C(0x1)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	first_vf_id;
	/* The number of virtual functions requested. */
	uint16_t	num_vfs;
} __attribute__((packed));

/* hwrm_func_vf_alloc_output (size:128b/16B) */
struct hwrm_func_vf_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The ID of the first VF allocated. */
	uint16_t	first_vf_id;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_func_vf_free *
 *********************/


/* hwrm_func_vf_free_input (size:192b/24B) */
struct hwrm_func_vf_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the first_vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_FREE_INPUT_ENABLES_FIRST_VF_ID     UINT32_C(0x1)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	first_vf_id;
	/*
	 * The number of virtual functions requested.
	 * 0xFFFF - Cleanup all children of this PF.
	 */
	uint16_t	num_vfs;
} __attribute__((packed));

/* hwrm_func_vf_free_output (size:128b/16B) */
struct hwrm_func_vf_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_func_vf_cfg *
 ********************/


/* hwrm_func_vf_cfg_input (size:448b/56B) */
struct hwrm_func_vf_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the mtu field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_MTU \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the guest_vlan field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_GUEST_VLAN \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the async_event_cr field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_ASYNC_EVENT_CR \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the dflt_mac_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_DFLT_MAC_ADDR \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the num_rsscos_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_RSSCOS_CTXS \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the num_cmpl_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_CMPL_RINGS \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the num_tx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_TX_RINGS \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the num_rx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_RX_RINGS \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the num_l2_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_L2_CTXS \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the num_vnics field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_VNICS \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the num_stat_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_STAT_CTXS \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the num_hw_ring_grps field to be
	 * configured.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_ENABLES_NUM_HW_RING_GRPS \
		UINT32_C(0x800)
	/*
	 * The maximum transmission unit requested on the function.
	 * The HWRM should make sure that the mtu of
	 * the function does not exceed the mtu of the physical
	 * port that this function is associated with.
	 *
	 * In addition to requesting mtu per function, it is
	 * possible to configure mtu per transmit ring.
	 * By default, the mtu of each transmit ring associated
	 * with a function is equal to the mtu of the function.
	 * The HWRM should make sure that the mtu of each transmit
	 * ring that is assigned to a function has a valid mtu.
	 */
	uint16_t	mtu;
	/*
	 * The guest VLAN for the function being configured.
	 * This field's format is same as 802.1Q Tag's
	 * Tag Control Information (TCI) format that includes both
	 * Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t	guest_vlan;
	/*
	 * ID of the target completion ring for receiving asynchronous
	 * event completions. If this field is not valid, then the
	 * HWRM shall use the default completion ring of the function
	 * that is being configured as the target completion ring for
	 * providing any asynchronous event completions for that
	 * function.
	 * If this field is valid, then the HWRM shall use the
	 * completion ring identified by this ID as the target
	 * completion ring for providing any asynchronous event
	 * completions for the function that is being configured.
	 */
	uint16_t	async_event_cr;
	/*
	 * This value is the current MAC address requested by the VF
	 * driver to be configured on this VF. A value of
	 * 00-00-00-00-00-00 indicates no MAC address configuration
	 * is requested by the VF driver.
	 * The parent PF driver may reject or overwrite this
	 * MAC address.
	 */
	uint8_t	dflt_mac_addr[6];
	uint32_t	flags;
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of TX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_TX_ASSETS_TEST \
		UINT32_C(0x1)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_RX_ASSETS_TEST \
		UINT32_C(0x2)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of CMPL rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_CMPL_ASSETS_TEST \
		UINT32_C(0x4)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RSS ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_RSSCOS_CTX_ASSETS_TEST \
		UINT32_C(0x8)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of ring groups) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_RING_GRP_ASSETS_TEST \
		UINT32_C(0x10)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of stat ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_STAT_CTX_ASSETS_TEST \
		UINT32_C(0x20)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of VNICs) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_VNIC_ASSETS_TEST \
		UINT32_C(0x40)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of L2 ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_VF_CFG_INPUT_FLAGS_L2_CTX_ASSETS_TEST \
		UINT32_C(0x80)
	/* The number of RSS/COS contexts requested for the VF. */
	uint16_t	num_rsscos_ctxs;
	/* The number of completion rings requested for the VF. */
	uint16_t	num_cmpl_rings;
	/* The number of transmit rings requested for the VF. */
	uint16_t	num_tx_rings;
	/* The number of receive rings requested for the VF. */
	uint16_t	num_rx_rings;
	/* The number of L2 contexts requested for the VF. */
	uint16_t	num_l2_ctxs;
	/* The number of vnics requested for the VF. */
	uint16_t	num_vnics;
	/* The number of statistic contexts requested for the VF. */
	uint16_t	num_stat_ctxs;
	/* The number of HW ring groups requested for the VF. */
	uint16_t	num_hw_ring_grps;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_vf_cfg_output (size:128b/16B) */
struct hwrm_func_vf_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_func_qcaps *
 *******************/


/* hwrm_func_qcaps_input (size:192b/24B) */
struct hwrm_func_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_qcaps_output (size:640b/80B) */
struct hwrm_func_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * FID value.  This value is used to identify operations on the PCI
	 * bus as belonging to a particular PCI function.
	 */
	uint16_t	fid;
	/*
	 * Port ID of port that this function is associated with.
	 * Valid only for the PF.
	 * 0xFF... (All Fs) if this function is not associated with
	 * any port.
	 * 0xFF... (All Fs) if this function is called from a VF.
	 */
	uint16_t	port_id;
	uint32_t	flags;
	/* If 1, then Push mode is supported on this function. */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PUSH_MODE_SUPPORTED \
		UINT32_C(0x1)
	/*
	 * If 1, then the global MSI-X auto-masking is enabled for the
	 * device.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GLOBAL_MSIX_AUTOMASKING \
		UINT32_C(0x2)
	/*
	 * If 1, then the Precision Time Protocol (PTP) processing
	 * is supported on this function.
	 * The HWRM should enable PTP on only a single Physical
	 * Function (PF) per port.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PTP_SUPPORTED \
		UINT32_C(0x4)
	/*
	 * If 1, then RDMA over Converged Ethernet (RoCE) v1
	 * is supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ROCE_V1_SUPPORTED \
		UINT32_C(0x8)
	/*
	 * If 1, then RDMA over Converged Ethernet (RoCE) v2
	 * is supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_ROCE_V2_SUPPORTED \
		UINT32_C(0x10)
	/*
	 * If 1, then control and configuration of WoL magic packet
	 * are supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WOL_MAGICPKT_SUPPORTED \
		UINT32_C(0x20)
	/*
	 * If 1, then control and configuration of bitmap pattern
	 * packet are supported on this function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_WOL_BMP_SUPPORTED \
		UINT32_C(0x40)
	/*
	 * If set to 1, then the control and configuration of rate limit
	 * of an allocated TX ring on the queried function is supported.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_TX_RING_RL_SUPPORTED \
		UINT32_C(0x80)
	/*
	 * If 1, then control and configuration of minimum and
	 * maximum bandwidths are supported on the queried function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_TX_BW_CFG_SUPPORTED \
		UINT32_C(0x100)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to set the rate limits
	 * on the TX rings of its children VFs.
	 * If this query is for a PF and this flag is set to 0, then
	 * the PF does not have the capability to set the rate limits
	 * on the TX rings of its children VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VF_TX_RING_RL_SUPPORTED \
		UINT32_C(0x200)
	/*
	 * If the query is for a VF, then this flag shall be ignored.
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to set the minimum and/or
	 * maximum bandwidths for its children VFs.
	 * If this query is for a PF and this flag is set to 0, then
	 * the PF does not have the capability to set the minimum or
	 * maximum bandwidths for its children VFs.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_VF_BW_CFG_SUPPORTED \
		UINT32_C(0x400)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then standard TX ring mode is supported
	 * on the queried function.
	 * If set to 0, then standard TX ring mode is not available
	 * on the queried function.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_STD_TX_RING_MODE_SUPPORTED \
		UINT32_C(0x800)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect GENEVE tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GENEVE_TUN_FLAGS_SUPPORTED \
		UINT32_C(0x1000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect NVGRE tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_NVGRE_TUN_FLAGS_SUPPORTED \
		UINT32_C(0x2000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect GRE tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_GRE_TUN_FLAGS_SUPPORTED \
		UINT32_C(0x4000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to detect MPLS tunnel
	 * flags.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_MPLS_TUN_FLAGS_SUPPORTED \
		UINT32_C(0x8000)
	/*
	 * If the query is for a VF, then this flag shall be ignored,
	 * If this query is for a PF and this flag is set to 1,
	 * then the PF has the capability to support pcie stats.
	 */
	#define HWRM_FUNC_QCAPS_OUTPUT_FLAGS_PCIE_STATS_SUPPORTED \
		UINT32_C(0x10000)
	/*
	 * This value is current MAC address configured for this
	 * function. A value of 00-00-00-00-00-00 indicates no
	 * MAC address is currently configured.
	 */
	uint8_t	mac_address[6];
	/*
	 * The maximum number of RSS/COS contexts that can be
	 * allocated to the function.
	 */
	uint16_t	max_rsscos_ctx;
	/*
	 * The maximum number of completion rings that can be
	 * allocated to the function.
	 */
	uint16_t	max_cmpl_rings;
	/*
	 * The maximum number of transmit rings that can be
	 * allocated to the function.
	 */
	uint16_t	max_tx_rings;
	/*
	 * The maximum number of receive rings that can be
	 * allocated to the function.
	 */
	uint16_t	max_rx_rings;
	/*
	 * The maximum number of L2 contexts that can be
	 * allocated to the function.
	 */
	uint16_t	max_l2_ctxs;
	/*
	 * The maximum number of VNICs that can be
	 * allocated to the function.
	 */
	uint16_t	max_vnics;
	/*
	 * The identifier for the first VF enabled on a PF. This
	 * is valid only on the PF with SR-IOV enabled.
	 * 0xFF... (All Fs) if this command is called on a PF with
	 * SR-IOV disabled or on a VF.
	 */
	uint16_t	first_vf_id;
	/*
	 * The maximum number of VFs that can be
	 * allocated to the function. This is valid only on the
	 * PF with SR-IOV enabled. 0xFF... (All Fs) if this
	 * command is called on a PF with SR-IOV disabled or
	 * on a VF.
	 */
	uint16_t	max_vfs;
	/*
	 * The maximum number of statistic contexts that can be
	 * allocated to the function.
	 */
	uint16_t	max_stat_ctx;
	/*
	 * The maximum number of Encapsulation records that can be
	 * offloaded by this function.
	 */
	uint32_t	max_encap_records;
	/*
	 * The maximum number of decapsulation records that can
	 * be offloaded by this function.
	 */
	uint32_t	max_decap_records;
	/*
	 * The maximum number of Exact Match (EM) flows that can be
	 * offloaded by this function on the TX side.
	 */
	uint32_t	max_tx_em_flows;
	/*
	 * The maximum number of Wildcard Match (WM) flows that can
	 * be offloaded by this function on the TX side.
	 */
	uint32_t	max_tx_wm_flows;
	/*
	 * The maximum number of Exact Match (EM) flows that can be
	 * offloaded by this function on the RX side.
	 */
	uint32_t	max_rx_em_flows;
	/*
	 * The maximum number of Wildcard Match (WM) flows that can
	 * be offloaded by this function on the RX side.
	 */
	uint32_t	max_rx_wm_flows;
	/*
	 * The maximum number of multicast filters that can
	 * be supported by this function on the RX side.
	 */
	uint32_t	max_mcast_filters;
	/*
	 * The maximum value of flow_id that can be supported
	 * in completion records.
	 */
	uint32_t	max_flow_id;
	/*
	 * The maximum number of HW ring groups that can be
	 * supported on this function.
	 */
	uint32_t	max_hw_ring_grps;
	/*
	 * The maximum number of strict priority transmit rings
	 * that can be allocated to the function.
	 * This number indicates the maximum number of TX rings
	 * that can be assigned strict priorities out of the
	 * maximum number of TX rings that can be allocated
	 * (max_tx_rings) to the function.
	 */
	uint16_t	max_sp_tx_rings;
	uint8_t	unused_0;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_func_qcfg *
 ******************/


/* hwrm_func_qcfg_input (size:192b/24B) */
struct hwrm_func_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_qcfg_output (size:640b/80B) */
struct hwrm_func_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * FID value.  This value is used to identify operations on the PCI
	 * bus as belonging to a particular PCI function.
	 */
	uint16_t	fid;
	/*
	 * Port ID of port that this function is associated with.
	 * 0xFF... (All Fs) if this function is not associated with
	 * any port.
	 */
	uint16_t	port_id;
	/*
	 * This value is the current VLAN setting for this
	 * function. The value of 0 for this field indicates
	 * no priority tagging or VLAN is used.
	 * This field's format is same as 802.1Q Tag's
	 * Tag Control Information (TCI) format that includes both
	 * Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t	vlan;
	uint16_t	flags;
	/*
	 * If 1, then magic packet based Out-Of-Box WoL is enabled on
	 * the port associated with this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_OOB_WOL_MAGICPKT_ENABLED \
		UINT32_C(0x1)
	/*
	 * If 1, then bitmap pattern based Out-Of-Box WoL packet is enabled
	 * on the port associated with this function.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_OOB_WOL_BMP_ENABLED \
		UINT32_C(0x2)
	/*
	 * If set to 1, then FW based DCBX agent is enabled and running on
	 * the port associated with this function.
	 * If set to 0, then DCBX agent is not running in the firmware.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FW_DCBX_AGENT_ENABLED \
		UINT32_C(0x4)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then standard TX ring mode is enabled
	 * on the queried function.
	 * If set to 0, then the standard TX ring mode is disabled
	 * on the queried function. In this extended TX ring resource
	 * mode, the minimum and maximum bandwidth settings are not
	 * supported to allow the allocation of TX rings to span multiple
	 * scheduler nodes.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_STD_TX_RING_MODE_ENABLED \
		UINT32_C(0x8)
	/*
	 * If set to 1 then FW based LLDP agent is enabled and running on
	 * the port associated with this function.
	 * If set to 0 then the LLDP agent is not running in the firmware.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_FW_LLDP_AGENT_ENABLED \
		UINT32_C(0x10)
	/*
	 * If set to 1, then multi-host mode is active for this function.
	 * If set to 0, then multi-host mode is inactive for this function
	 * or not applicable for this device.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_FLAGS_MULTI_HOST \
		UINT32_C(0x20)
	/*
	 * This value is current MAC address configured for this
	 * function. A value of 00-00-00-00-00-00 indicates no
	 * MAC address is currently configured.
	 */
	uint8_t	mac_address[6];
	/*
	 * This value is current PCI ID of this
	 * function. If ARI is enabled, then it is
	 * Bus Number (8b):Function Number(8b). Otherwise, it is
	 * Bus Number (8b):Device Number (4b):Function Number(4b).
	 * If multi-host mode is active, the 4 lsb will indicate
	 * the PF index for this function.
	 */
	uint16_t	pci_id;
	/*
	 * The number of RSS/COS contexts currently
	 * allocated to the function.
	 */
	uint16_t	alloc_rsscos_ctx;
	/*
	 * The number of completion rings currently allocated to
	 * the function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	alloc_cmpl_rings;
	/*
	 * The number of transmit rings currently allocated to
	 * the function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	alloc_tx_rings;
	/*
	 * The number of receive rings currently allocated to
	 * the function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	alloc_rx_rings;
	/* The allocated number of L2 contexts to the function. */
	uint16_t	alloc_l2_ctx;
	/* The allocated number of vnics to the function. */
	uint16_t	alloc_vnics;
	/*
	 * The maximum transmission unit of the function.
	 * For rings allocated on this function, this default
	 * value is used if ring MTU is not specified.
	 */
	uint16_t	mtu;
	/*
	 * The maximum receive unit of the function.
	 * For vnics allocated on this function, this default
	 * value is used if vnic MRU is not specified.
	 */
	uint16_t	mru;
	/* The statistics context assigned to a function. */
	uint16_t	stat_ctx_id;
	/*
	 * The HWRM shall return Unknown value for this field
	 * when this command is used to query VF's configuration.
	 */
	uint8_t	port_partition_type;
	/* Single physical function */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_SPF     UINT32_C(0x0)
	/* Multiple physical functions */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_MPFS    UINT32_C(0x1)
	/* Network Partitioning 1.0 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_0 UINT32_C(0x2)
	/* Network Partitioning 1.5 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR1_5 UINT32_C(0x3)
	/* Network Partitioning 2.0 */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_NPAR2_0 UINT32_C(0x4)
	/* Unknown */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_LAST \
		HWRM_FUNC_QCFG_OUTPUT_PORT_PARTITION_TYPE_UNKNOWN
	/*
	 * This field will indicate number of physical functions on this port_partition.
	 * HWRM shall return unavail (i.e. value of 0) for this field
	 * when this command is used to query VF's configuration or
	 * from older firmware that doesn't support this field.
	 */
	uint8_t	port_pf_cnt;
	/* number of PFs is not available */
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_UNAVAIL UINT32_C(0x0)
	#define HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_LAST \
		HWRM_FUNC_QCFG_OUTPUT_PORT_PF_CNT_UNAVAIL
	/*
	 * The default VNIC ID assigned to a function that is
	 * being queried.
	 */
	uint16_t	dflt_vnic_id;
	uint16_t	max_mtu_configured;
	/*
	 * Minimum BW allocated for this function.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for the scheduler inside the device.
	 * A value of 0 indicates the minimum bandwidth is not
	 * configured.
	 */
	uint32_t	min_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_SFT              0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_LAST \
		HWRM_FUNC_QCFG_OUTPUT_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_SFT         29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_FUNC_QCFG_OUTPUT_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated for this function.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for the scheduler inside the device.
	 * A value of 0 indicates that the maximum bandwidth is not
	 * configured.
	 */
	uint32_t	max_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_SFT              0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_LAST \
		HWRM_FUNC_QCFG_OUTPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_SFT         29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_FUNC_QCFG_OUTPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	/*
	 * This value indicates the Edge virtual bridge mode for the
	 * domain that this function belongs to.
	 */
	uint8_t	evb_mode;
	/* No Edge Virtual Bridging (EVB) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_NO_EVB UINT32_C(0x0)
	/* Virtual Ethernet Bridge (VEB) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEB    UINT32_C(0x1)
	/* Virtual Ethernet Port Aggregator (VEPA) */
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEPA   UINT32_C(0x2)
	#define HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_LAST \
		HWRM_FUNC_QCFG_OUTPUT_EVB_MODE_VEPA
	uint8_t	options;
	/*
	 * This value indicates the PCIE device cache line size.
	 * The cache line size allows the DMA writes to terminate and
	 * start at the cache boundary.
	 */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_MASK \
		UINT32_C(0x3)
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SFT     0
	/* Cache Line Size 64 bytes */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SIZE_64 \
		UINT32_C(0x0)
	/* Cache Line Size 128 bytes */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SIZE_128 \
		UINT32_C(0x1)
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_LAST \
		HWRM_FUNC_QCFG_OUTPUT_OPTIONS_CACHE_LINESIZE_SIZE_128
	/* Reserved for future. */
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_RSVD_MASK \
		UINT32_C(0xfc)
	#define HWRM_FUNC_QCFG_OUTPUT_OPTIONS_RSVD_SFT               2
	/*
	 * The number of VFs that are allocated to the function.
	 * This is valid only on the PF with SR-IOV enabled.
	 * 0xFF... (All Fs) if this command is called on a PF with
	 * SR-IOV disabled or on a VF.
	 */
	uint16_t	alloc_vfs;
	/*
	 * The number of allocated multicast filters for this
	 * function on the RX side.
	 */
	uint32_t	alloc_mcast_filters;
	/*
	 * The number of allocated HW ring groups for this
	 * function.
	 */
	uint32_t	alloc_hw_ring_grps;
	/*
	 * The number of strict priority transmit rings out of
	 * currently allocated TX rings to the function
	 * (alloc_tx_rings).
	 */
	uint16_t	alloc_sp_tx_rings;
	/*
	 * The number of statistics contexts
	 * currently reserved for the function.
	 */
	uint16_t	alloc_stat_ctx;
	/*
	 * This field specifies how many NQs are reserved for the PF.
	 * Remaining NQs that belong to the PF are available for VFs.
	 * Once a PF has created VFs, it cannot change how many NQs are
	 * reserved for itself (since the NQs must be contiguous in HW).
	 */
	uint16_t	alloc_msix;
	uint8_t	unused_2[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_func_vlan_qcfg *
 ***********************/


/* hwrm_func_vlan_qcfg_input (size:192b/24B) */
struct hwrm_func_vlan_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being
	 * configured.
	 * If set to 0xFF... (All Fs), then the configuration is
	 * for the requesting function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_vlan_qcfg_output (size:320b/40B) */
struct hwrm_func_vlan_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
	/* S-TAG VLAN identifier configured for the function. */
	uint16_t	stag_vid;
	/* S-TAG PCP value configured for the function. */
	uint8_t	stag_pcp;
	uint8_t	unused_1;
	/*
	 * S-TAG TPID value configured for the function. This field is specified in
	 * network byte order.
	 */
	uint16_t	stag_tpid;
	/* C-TAG VLAN identifier configured for the function. */
	uint16_t	ctag_vid;
	/* C-TAG PCP value configured for the function. */
	uint8_t	ctag_pcp;
	uint8_t	unused_2;
	/*
	 * C-TAG TPID value configured for the function. This field is specified in
	 * network byte order.
	 */
	uint16_t	ctag_tpid;
	/* Future use. */
	uint32_t	rsvd2;
	/* Future use. */
	uint32_t	rsvd3;
	uint32_t	unused_3;
} __attribute__((packed));

/**********************
 * hwrm_func_vlan_cfg *
 **********************/


/* hwrm_func_vlan_cfg_input (size:384b/48B) */
struct hwrm_func_vlan_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being
	 * configured.
	 * If set to 0xFF... (All Fs), then the configuration is
	 * for the requesting function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[2];
	uint32_t	enables;
	/*
	 * This bit must be '1' for the stag_vid field to be
	 * configured.
	 */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_STAG_VID      UINT32_C(0x1)
	/*
	 * This bit must be '1' for the ctag_vid field to be
	 * configured.
	 */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_CTAG_VID      UINT32_C(0x2)
	/*
	 * This bit must be '1' for the stag_pcp field to be
	 * configured.
	 */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_STAG_PCP      UINT32_C(0x4)
	/*
	 * This bit must be '1' for the ctag_pcp field to be
	 * configured.
	 */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_CTAG_PCP      UINT32_C(0x8)
	/*
	 * This bit must be '1' for the stag_tpid field to be
	 * configured.
	 */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_STAG_TPID     UINT32_C(0x10)
	/*
	 * This bit must be '1' for the ctag_tpid field to be
	 * configured.
	 */
	#define HWRM_FUNC_VLAN_CFG_INPUT_ENABLES_CTAG_TPID     UINT32_C(0x20)
	/* S-TAG VLAN identifier configured for the function. */
	uint16_t	stag_vid;
	/* S-TAG PCP value configured for the function. */
	uint8_t	stag_pcp;
	uint8_t	unused_1;
	/*
	 * S-TAG TPID value configured for the function. This field is specified in
	 * network byte order.
	 */
	uint16_t	stag_tpid;
	/* C-TAG VLAN identifier configured for the function. */
	uint16_t	ctag_vid;
	/* C-TAG PCP value configured for the function. */
	uint8_t	ctag_pcp;
	uint8_t	unused_2;
	/*
	 * C-TAG TPID value configured for the function. This field is specified in
	 * network byte order.
	 */
	uint16_t	ctag_tpid;
	/* Future use. */
	uint32_t	rsvd1;
	/* Future use. */
	uint32_t	rsvd2;
	uint8_t	unused_3[4];
} __attribute__((packed));

/* hwrm_func_vlan_cfg_output (size:128b/16B) */
struct hwrm_func_vlan_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************
 * hwrm_func_cfg *
 *****************/


/* hwrm_func_cfg_input (size:704b/88B) */
struct hwrm_func_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being
	 * configured.
	 * If set to 0xFF... (All Fs), then the the configuration is
	 * for the requesting function.
	 */
	uint16_t	fid;
	/*
	 * This field specifies how many NQs will be reserved for the PF.
	 * Remaining NQs that belong to the PF become available for VFs.
	 * Once a PF has created VFs, it cannot change how many NQs are
	 * reserved for itself (since the NQs must be contiguous in HW).
	 */
	uint16_t	num_msix;
	uint32_t	flags;
	/*
	 * When this bit is '1', the function is disabled with
	 * source MAC address check.
	 * This is an anti-spoofing check. If this flag is set,
	 * then the function shall be configured to disallow
	 * transmission of frames with the source MAC address that
	 * is configured for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_SRC_MAC_ADDR_CHECK_DISABLE \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is enabled with
	 * source MAC address check.
	 * This is an anti-spoofing check. If this flag is set,
	 * then the function shall be configured to allow
	 * transmission of frames with the source MAC address that
	 * is configured for this function.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_SRC_MAC_ADDR_CHECK_ENABLE \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSVD_MASK \
		UINT32_C(0x1fc)
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSVD_SFT                       2
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then standard TX ring mode is requested to be
	 * enabled on the function being configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STD_TX_RING_MODE_ENABLE \
		UINT32_C(0x200)
	/*
	 * Standard TX Ring mode is used for the allocation of TX ring
	 * and underlying scheduling resources that allow bandwidth
	 * reservation and limit settings on the queried function.
	 * If set to 1, then the standard TX ring mode is requested to
	 * be disabled on the function being configured. In this extended
	 * TX ring resource mode, the minimum and maximum bandwidth settings
	 * are not supported to allow the allocation of TX rings to
	 * span multiple scheduler nodes.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STD_TX_RING_MODE_DISABLE \
		UINT32_C(0x400)
	/*
	 * If this bit is set, virtual mac address configured
	 * in this command will be persistent over warm boot.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_VIRT_MAC_PERSIST \
		UINT32_C(0x800)
	/*
	 * This bit only applies to the VF. If this bit is set, the statistic
	 * context counters will not be cleared when the statistic context is freed
	 * or a function reset is called on VF. This bit will be cleared when the PF
	 * is unloaded or a function reset is called on the PF.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_NO_AUTOCLEAR_STATISTIC \
		UINT32_C(0x1000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of TX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_TX_ASSETS_TEST \
		UINT32_C(0x2000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RX rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RX_ASSETS_TEST \
		UINT32_C(0x4000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of CMPL rings) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_CMPL_ASSETS_TEST \
		UINT32_C(0x8000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of RSS ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RSSCOS_CTX_ASSETS_TEST \
		UINT32_C(0x10000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of ring groups) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_RING_GRP_ASSETS_TEST \
		UINT32_C(0x20000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of stat ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_STAT_CTX_ASSETS_TEST \
		UINT32_C(0x40000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of VNICs) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_VNIC_ASSETS_TEST \
		UINT32_C(0x80000)
	/*
	 * This bit requests that the firmware test to see if all the assets
	 * requested in this command (i.e. number of L2 ctx) are available.
	 * The firmware will return an error if the requested assets are
	 * not available. The firwmare will NOT reserve the assets if they
	 * are available.
	 */
	#define HWRM_FUNC_CFG_INPUT_FLAGS_L2_CTX_ASSETS_TEST \
		UINT32_C(0x100000)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the mtu field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MTU \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the mru field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MRU \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the num_rsscos_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_RSSCOS_CTXS \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the num_cmpl_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_CMPL_RINGS \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the num_tx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_TX_RINGS \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the num_rx_rings field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_RX_RINGS \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the num_l2_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_L2_CTXS \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the num_vnics field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_VNICS \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the num_stat_ctxs field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_STAT_CTXS \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the dflt_mac_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_MAC_ADDR \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the dflt_vlan field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_VLAN \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the dflt_ip_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_DFLT_IP_ADDR \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the min_bw field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MIN_BW \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the max_bw field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_MAX_BW \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the async_event_cr field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ASYNC_EVENT_CR \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the vlan_antispoof_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_VLAN_ANTISPOOF_MODE \
		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the allowed_vlan_pris field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_ALLOWED_VLAN_PRIS \
		UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the evb_mode field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_EVB_MODE \
		UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the num_mcast_filters field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_MCAST_FILTERS \
		UINT32_C(0x40000)
	/*
	 * This bit must be '1' for the num_hw_ring_grps field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_HW_RING_GRPS \
		UINT32_C(0x80000)
	/*
	 * This bit must be '1' for the cache_linesize field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_CACHE_LINESIZE \
		UINT32_C(0x100000)
	/*
	 * This bit must be '1' for the num_msix field to be
	 * configured.
	 */
	#define HWRM_FUNC_CFG_INPUT_ENABLES_NUM_MSIX \
		UINT32_C(0x200000)
	/*
	 * The maximum transmission unit of the function.
	 * The HWRM should make sure that the mtu of
	 * the function does not exceed the mtu of the physical
	 * port that this function is associated with.
	 *
	 * In addition to configuring mtu per function, it is
	 * possible to configure mtu per transmit ring.
	 * By default, the mtu of each transmit ring associated
	 * with a function is equal to the mtu of the function.
	 * The HWRM should make sure that the mtu of each transmit
	 * ring that is assigned to a function has a valid mtu.
	 */
	uint16_t	mtu;
	/*
	 * The maximum receive unit of the function.
	 * The HWRM should make sure that the mru of
	 * the function does not exceed the mru of the physical
	 * port that this function is associated with.
	 *
	 * In addition to configuring mru per function, it is
	 * possible to configure mru per vnic.
	 * By default, the mru of each vnic associated
	 * with a function is equal to the mru of the function.
	 * The HWRM should make sure that the mru of each vnic
	 * that is assigned to a function has a valid mru.
	 */
	uint16_t	mru;
	/*
	 * The number of RSS/COS contexts requested for the
	 * function.
	 */
	uint16_t	num_rsscos_ctxs;
	/*
	 * The number of completion rings requested for the
	 * function. This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	num_cmpl_rings;
	/*
	 * The number of transmit rings requested for the function.
	 * This does not include the rings allocated to any
	 * children functions if any.
	 */
	uint16_t	num_tx_rings;
	/*
	 * The number of receive rings requested for the function.
	 * This does not include the rings allocated
	 * to any children functions if any.
	 */
	uint16_t	num_rx_rings;
	/* The requested number of L2 contexts for the function. */
	uint16_t	num_l2_ctxs;
	/* The requested number of vnics for the function. */
	uint16_t	num_vnics;
	/* The requested number of statistic contexts for the function. */
	uint16_t	num_stat_ctxs;
	/*
	 * The number of HW ring groups that should
	 * be reserved for this function.
	 */
	uint16_t	num_hw_ring_grps;
	/* The default MAC address for the function being configured. */
	uint8_t	dflt_mac_addr[6];
	/*
	 * The default VLAN for the function being configured.
	 * This field's format is same as 802.1Q Tag's
	 * Tag Control Information (TCI) format that includes both
	 * Priority Code Point (PCP) and VLAN Identifier (VID).
	 */
	uint16_t	dflt_vlan;
	/*
	 * The default IP address for the function being configured.
	 * This address is only used in enabling source property check.
	 */
	uint32_t	dflt_ip_addr[4];
	/*
	 * Minimum BW allocated for this function.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for the scheduler inside the device.
	 */
	uint32_t	min_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_SFT              0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_LAST \
		HWRM_FUNC_CFG_INPUT_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_SFT         29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_FUNC_CFG_INPUT_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated for this function.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for the scheduler inside the device.
	 */
	uint32_t	max_bw;
	/* The bandwidth value. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_SFT              0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_LAST \
		HWRM_FUNC_CFG_INPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_SFT         29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_FUNC_CFG_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	/*
	 * ID of the target completion ring for receiving asynchronous
	 * event completions. If this field is not valid, then the
	 * HWRM shall use the default completion ring of the function
	 * that is being configured as the target completion ring for
	 * providing any asynchronous event completions for that
	 * function.
	 * If this field is valid, then the HWRM shall use the
	 * completion ring identified by this ID as the target
	 * completion ring for providing any asynchronous event
	 * completions for the function that is being configured.
	 */
	uint16_t	async_event_cr;
	/* VLAN Anti-spoofing mode. */
	uint8_t	vlan_antispoof_mode;
	/* No VLAN anti-spoofing checks are enabled */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_NOCHECK \
		UINT32_C(0x0)
	/* Validate VLAN against the configured VLAN(s) */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_VALIDATE_VLAN \
		UINT32_C(0x1)
	/* Insert VLAN if it does not exist, otherwise discard */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_IF_VLANDNE \
		UINT32_C(0x2)
	/* Insert VLAN if it does not exist, override VLAN if it exists */
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_OR_OVERRIDE_VLAN \
		UINT32_C(0x3)
	#define HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_LAST \
		HWRM_FUNC_CFG_INPUT_VLAN_ANTISPOOF_MODE_INSERT_OR_OVERRIDE_VLAN
	/*
	 * This bit field defines VLAN PRIs that are allowed on
	 * this function.
	 * If nth bit is set, then VLAN PRI n is allowed on this
	 * function.
	 */
	uint8_t	allowed_vlan_pris;
	/*
	 * The HWRM shall allow a PF driver to change EVB mode for the
	 * partition it belongs to.
	 * The HWRM shall not allow a VF driver to change the EVB mode.
	 * The HWRM shall take into account the switching of EVB mode
	 * from one to another and reconfigure hardware resources as
	 * appropriately.
	 * The switching from VEB to VEPA mode requires
	 * the disabling of the loopback traffic. Additionally,
	 * source knock outs are handled differently in VEB and VEPA
	 * modes.
	 */
	uint8_t	evb_mode;
	/* No Edge Virtual Bridging (EVB) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_NO_EVB UINT32_C(0x0)
	/* Virtual Ethernet Bridge (VEB) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_VEB    UINT32_C(0x1)
	/* Virtual Ethernet Port Aggregator (VEPA) */
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_VEPA   UINT32_C(0x2)
	#define HWRM_FUNC_CFG_INPUT_EVB_MODE_LAST \
		HWRM_FUNC_CFG_INPUT_EVB_MODE_VEPA
	uint8_t	options;
	/*
	 * This value indicates the PCIE device cache line size.
	 * The cache line size allows the DMA writes to terminate and
	 * start at the cache boundary.
	 */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_MASK \
		UINT32_C(0x3)
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SFT     0
	/* Cache Line Size 64 bytes */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SIZE_64 \
		UINT32_C(0x0)
	/* Cache Line Size 128 bytes */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SIZE_128 \
		UINT32_C(0x1)
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_LAST \
		HWRM_FUNC_CFG_INPUT_OPTIONS_CACHE_LINESIZE_SIZE_128
	/* Reserved for future. */
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_RSVD_MASK \
		UINT32_C(0xfc)
	#define HWRM_FUNC_CFG_INPUT_OPTIONS_RSVD_SFT               2
	/*
	 * The number of multicast filters that should
	 * be reserved for this function on the RX side.
	 */
	uint16_t	num_mcast_filters;
} __attribute__((packed));

/* hwrm_func_cfg_output (size:128b/16B) */
struct hwrm_func_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_func_qstats *
 ********************/


/* hwrm_func_qstats_input (size:192b/24B) */
struct hwrm_func_qstats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_qstats_output (size:1408b/176B) */
struct hwrm_func_qstats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of transmitted unicast packets on the function. */
	uint64_t	tx_ucast_pkts;
	/* Number of transmitted multicast packets on the function. */
	uint64_t	tx_mcast_pkts;
	/* Number of transmitted broadcast packets on the function. */
	uint64_t	tx_bcast_pkts;
	/*
	 * Number of transmitted packets that were discarded due to
	 * internal NIC resource problems.  For transmit, this
	 * can only happen if TMP is configured to allow dropping
	 * in HOL blocking conditions, which is not a normal
	 * configuration.
	 */
	uint64_t	tx_discard_pkts;
	/*
	 * Number of dropped packets on transmit path on the function.
	 * These are packets that have been marked for drop by
	 * the TE CFA block or are packets that exceeded the
	 * transmit MTU limit for the function.
	 */
	uint64_t	tx_drop_pkts;
	/* Number of transmitted bytes for unicast traffic on the function. */
	uint64_t	tx_ucast_bytes;
	/* Number of transmitted bytes for multicast traffic on the function. */
	uint64_t	tx_mcast_bytes;
	/* Number of transmitted bytes for broadcast traffic on the function. */
	uint64_t	tx_bcast_bytes;
	/* Number of received unicast packets on the function. */
	uint64_t	rx_ucast_pkts;
	/* Number of received multicast packets on the function. */
	uint64_t	rx_mcast_pkts;
	/* Number of received broadcast packets on the function. */
	uint64_t	rx_bcast_pkts;
	/*
	 * Number of received packets that were discarded on the function
	 * due to resource limitations.  This can happen for 3 reasons.
	 * # The BD used for the packet has a bad format.
	 * # There were no BDs available in the ring for the packet.
	 * # There were no BDs available on-chip for the packet.
	 */
	uint64_t	rx_discard_pkts;
	/*
	 * Number of dropped packets on received path on the function.
	 * These are packets that have been marked for drop by the
	 * RE CFA.
	 */
	uint64_t	rx_drop_pkts;
	/* Number of received bytes for unicast traffic on the function. */
	uint64_t	rx_ucast_bytes;
	/* Number of received bytes for multicast traffic on the function. */
	uint64_t	rx_mcast_bytes;
	/* Number of received bytes for broadcast traffic on the function. */
	uint64_t	rx_bcast_bytes;
	/* Number of aggregated unicast packets on the function. */
	uint64_t	rx_agg_pkts;
	/* Number of aggregated unicast bytes on the function. */
	uint64_t	rx_agg_bytes;
	/* Number of aggregation events on the function. */
	uint64_t	rx_agg_events;
	/* Number of aborted aggregations on the function. */
	uint64_t	rx_agg_aborts;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_func_clr_stats *
 ***********************/


/* hwrm_func_clr_stats_input (size:192b/24B) */
struct hwrm_func_clr_stats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_clr_stats_output (size:128b/16B) */
struct hwrm_func_clr_stats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_func_vf_resc_free *
 **************************/


/* hwrm_func_vf_resc_free_input (size:192b/24B) */
struct hwrm_func_vf_resc_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_vf_resc_free_output (size:128b/16B) */
struct hwrm_func_vf_resc_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************************
 * hwrm_func_vf_vnic_ids_query *
 *******************************/


/* hwrm_func_vf_vnic_ids_query_input (size:256b/32B) */
struct hwrm_func_vf_vnic_ids_query_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	uint8_t	unused_0[2];
	/* Max number of vnic ids in vnic id table */
	uint32_t	max_vnic_id_cnt;
	/* This is the address for VF VNIC ID table */
	uint64_t	vnic_id_tbl_addr;
} __attribute__((packed));

/* hwrm_func_vf_vnic_ids_query_output (size:128b/16B) */
struct hwrm_func_vf_vnic_ids_query_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Actual number of vnic ids
	 *
	 * Each VNIC ID is written as a 32-bit number.
	 */
	uint32_t	vnic_id_cnt;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_drv_rgtr *
 **********************/


/* hwrm_func_drv_rgtr_input (size:896b/112B) */
struct hwrm_func_drv_rgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the function driver is requesting
	 * all requests from its children VF drivers to be
	 * forwarded to itself.
	 * This flag can only be set by the PF driver.
	 * If a VF driver sets this flag, it should be ignored
	 * by the HWRM.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FWD_ALL_MODE       UINT32_C(0x1)
	/*
	 * When this bit is '1', the function is requesting none of
	 * the requests from its children VF drivers to be
	 * forwarded to itself.
	 * This flag can only be set by the PF driver.
	 * If a VF driver sets this flag, it should be ignored
	 * by the HWRM.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_FWD_NONE_MODE      UINT32_C(0x2)
	/*
	 * When this bit is '1', then ver_maj_8b, ver_min_8b, ver_upd_8b
	 * fields shall be ignored and ver_maj, ver_min, ver_upd
	 * and ver_patch shall be used for the driver version information.
	 * When this bit is '0', then ver_maj_8b, ver_min_8b, ver_upd_8b
	 * fields shall be used for the driver version information and
	 * ver_maj, ver_min, ver_upd and ver_patch shall be ignored.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_FLAGS_16BIT_VER_MODE     UINT32_C(0x4)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the os_type field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_OS_TYPE \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the ver field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_VER \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the timestamp field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_TIMESTAMP \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the vf_req_fwd field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_VF_REQ_FWD \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the async_event_fwd field to be
	 * configured.
	 */
	#define HWRM_FUNC_DRV_RGTR_INPUT_ENABLES_ASYNC_EVENT_FWD \
		UINT32_C(0x10)
	/* This value indicates the type of OS.  The values are based on CIM_OperatingSystem.mof file as published by the DMTF. */
	uint16_t	os_type;
	/* Unknown */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UNKNOWN   UINT32_C(0x0)
	/* Other OS not listed below. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_OTHER     UINT32_C(0x1)
	/* MSDOS OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_MSDOS     UINT32_C(0xe)
	/* Windows OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WINDOWS   UINT32_C(0x12)
	/* Solaris OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_SOLARIS   UINT32_C(0x1d)
	/* Linux OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_LINUX     UINT32_C(0x24)
	/* FreeBSD OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_FREEBSD   UINT32_C(0x2a)
	/* VMware ESXi OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_ESXI      UINT32_C(0x68)
	/* Microsoft Windows 8 64-bit OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WIN864    UINT32_C(0x73)
	/* Microsoft Windows Server 2012 R2 OS. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_WIN2012R2 UINT32_C(0x74)
	/* UEFI driver. */
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UEFI      UINT32_C(0x8000)
	#define HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_LAST \
		HWRM_FUNC_DRV_RGTR_INPUT_OS_TYPE_UEFI
	/* This is the 8bit major version of the driver. */
	uint8_t	ver_maj_8b;
	/* This is the 8bit minor version of the driver. */
	uint8_t	ver_min_8b;
	/* This is the 8bit update version of the driver. */
	uint8_t	ver_upd_8b;
	uint8_t	unused_0[3];
	/*
	 * This is a 32-bit timestamp provided by the driver for
	 * keep alive.
	 * The timestamp is in multiples of 1ms.
	 */
	uint32_t	timestamp;
	uint8_t	unused_1[4];
	/*
	 * This is a 256-bit bit mask provided by the PF driver for
	 * letting the HWRM know what commands issued by the VF driver
	 * to the HWRM should be forwarded to the PF driver.
	 * Nth bit refers to the Nth req_type.
	 *
	 * Setting Nth bit to 1 indicates that requests from the
	 * VF driver with req_type equal to N shall be forwarded to
	 * the parent PF driver.
	 *
	 * This field is not valid for the VF driver.
	 */
	uint32_t	vf_req_fwd[8];
	/*
	 * This is a 256-bit bit mask provided by the function driver
	 * (PF or VF driver) to indicate the list of asynchronous event
	 * completions to be forwarded.
	 *
	 * Nth bit refers to the Nth event_id.
	 *
	 * Setting Nth bit to 1 by the function driver shall result in
	 * the HWRM forwarding asynchronous event completion with
	 * event_id equal to N.
	 *
	 * If all bits are set to 0 (value of 0), then the HWRM shall
	 * not forward any asynchronous event completion to this
	 * function driver.
	 */
	uint32_t	async_event_fwd[8];
	/* This is the 16bit major version of the driver. */
	uint16_t	ver_maj;
	/* This is the 16bit minor version of the driver. */
	uint16_t	ver_min;
	/* This is the 16bit update version of the driver. */
	uint16_t	ver_upd;
	/* This is the 16bit patch version of the driver. */
	uint16_t	ver_patch;
} __attribute__((packed));

/* hwrm_func_drv_rgtr_output (size:128b/16B) */
struct hwrm_func_drv_rgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_func_drv_unrgtr *
 ************************/


/* hwrm_func_drv_unrgtr_input (size:192b/24B) */
struct hwrm_func_drv_unrgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the function driver is notifying
	 * the HWRM to prepare for the shutdown.
	 */
	#define HWRM_FUNC_DRV_UNRGTR_INPUT_FLAGS_PREPARE_FOR_SHUTDOWN \
		UINT32_C(0x1)
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_drv_unrgtr_output (size:128b/16B) */
struct hwrm_func_drv_unrgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_buf_rgtr *
 **********************/


/* hwrm_func_buf_rgtr_input (size:1024b/128B) */
struct hwrm_func_buf_rgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_BUF_RGTR_INPUT_ENABLES_VF_ID            UINT32_C(0x1)
	/*
	 * This bit must be '1' for the err_buf_addr field to be
	 * configured.
	 */
	#define HWRM_FUNC_BUF_RGTR_INPUT_ENABLES_ERR_BUF_ADDR     UINT32_C(0x2)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	/*
	 * This field represents the number of pages used for request
	 * buffer(s).
	 */
	uint16_t	req_buf_num_pages;
	/*
	 * This field represents the page size used for request
	 * buffer(s).
	 */
	uint16_t	req_buf_page_size;
	/* 16 bytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_16B UINT32_C(0x4)
	/* 4 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_4K  UINT32_C(0xc)
	/* 8 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_8K  UINT32_C(0xd)
	/* 64 Kbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_64K UINT32_C(0x10)
	/* 2 Mbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_2M  UINT32_C(0x15)
	/* 4 Mbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_4M  UINT32_C(0x16)
	/* 1 Gbytes */
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_1G  UINT32_C(0x1e)
	#define HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_LAST \
		HWRM_FUNC_BUF_RGTR_INPUT_REQ_BUF_PAGE_SIZE_1G
	/* The length of the request buffer per VF in bytes. */
	uint16_t	req_buf_len;
	/* The length of the response buffer in bytes. */
	uint16_t	resp_buf_len;
	uint8_t	unused_0[2];
	/* This field represents the page address of page #0. */
	uint64_t	req_buf_page_addr0;
	/* This field represents the page address of page #1. */
	uint64_t	req_buf_page_addr1;
	/* This field represents the page address of page #2. */
	uint64_t	req_buf_page_addr2;
	/* This field represents the page address of page #3. */
	uint64_t	req_buf_page_addr3;
	/* This field represents the page address of page #4. */
	uint64_t	req_buf_page_addr4;
	/* This field represents the page address of page #5. */
	uint64_t	req_buf_page_addr5;
	/* This field represents the page address of page #6. */
	uint64_t	req_buf_page_addr6;
	/* This field represents the page address of page #7. */
	uint64_t	req_buf_page_addr7;
	/* This field represents the page address of page #8. */
	uint64_t	req_buf_page_addr8;
	/* This field represents the page address of page #9. */
	uint64_t	req_buf_page_addr9;
	/*
	 * This field is used to receive the error reporting from
	 * the chipset. Only applicable for PFs.
	 */
	uint64_t	error_buf_addr;
	/*
	 * This field is used to receive the response forwarded by the
	 * HWRM.
	 */
	uint64_t	resp_buf_addr;
} __attribute__((packed));

/* hwrm_func_buf_rgtr_output (size:128b/16B) */
struct hwrm_func_buf_rgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_func_buf_unrgtr *
 ************************/


/* hwrm_func_buf_unrgtr_input (size:192b/24B) */
struct hwrm_func_buf_unrgtr_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id field to be
	 * configured.
	 */
	#define HWRM_FUNC_BUF_UNRGTR_INPUT_ENABLES_VF_ID     UINT32_C(0x1)
	/*
	 * This value is used to identify a Virtual Function (VF).
	 * The scope of VF ID is local within a PF.
	 */
	uint16_t	vf_id;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_func_buf_unrgtr_output (size:128b/16B) */
struct hwrm_func_buf_unrgtr_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_func_drv_qver *
 **********************/


/* hwrm_func_drv_qver_input (size:192b/24B) */
struct hwrm_func_drv_qver_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Reserved for future use. */
	uint32_t	reserved;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_func_drv_qver_output (size:192b/24B) */
struct hwrm_func_drv_qver_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value indicates the type of OS.  The values are based on CIM_OperatingSystem.mof file as published by the DMTF. */
	uint16_t	os_type;
	/* Unknown */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UNKNOWN   UINT32_C(0x0)
	/* Other OS not listed below. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_OTHER     UINT32_C(0x1)
	/* MSDOS OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_MSDOS     UINT32_C(0xe)
	/* Windows OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WINDOWS   UINT32_C(0x12)
	/* Solaris OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_SOLARIS   UINT32_C(0x1d)
	/* Linux OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_LINUX     UINT32_C(0x24)
	/* FreeBSD OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_FREEBSD   UINT32_C(0x2a)
	/* VMware ESXi OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_ESXI      UINT32_C(0x68)
	/* Microsoft Windows 8 64-bit OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WIN864    UINT32_C(0x73)
	/* Microsoft Windows Server 2012 R2 OS. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_WIN2012R2 UINT32_C(0x74)
	/* UEFI driver. */
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UEFI      UINT32_C(0x8000)
	#define HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_LAST \
		HWRM_FUNC_DRV_QVER_OUTPUT_OS_TYPE_UEFI
	/* This is the 8bit major version of the driver. */
	uint8_t	ver_maj_8b;
	/* This is the 8bit minor version of the driver. */
	uint8_t	ver_min_8b;
	/* This is the 8bit update version of the driver. */
	uint8_t	ver_upd_8b;
	uint8_t	unused_0[2];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
	/* This is the 16bit major version of the driver. */
	uint16_t	ver_maj;
	/* This is the 16bit minor version of the driver. */
	uint16_t	ver_min;
	/* This is the 16bit update version of the driver. */
	uint16_t	ver_upd;
	/* This is the 16bit patch version of the driver. */
	uint16_t	ver_patch;
} __attribute__((packed));

/****************************
 * hwrm_func_resource_qcaps *
 ****************************/


/* hwrm_func_resource_qcaps_input (size:192b/24B) */
struct hwrm_func_resource_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * 0xFF... (All Fs) if the query is for the requesting
	 * function.
	 */
	uint16_t	fid;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_func_resource_qcaps_output (size:448b/56B) */
struct hwrm_func_resource_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Maximum guaranteed number of VFs supported by PF. Not applicable for VFs. */
	uint16_t	max_vfs;
	/* Maximum guaranteed number of MSI-X vectors supported by function */
	uint16_t	max_msix;
	/* Hint of strategy to be used by PF driver to reserve resources for its VF */
	uint16_t	vf_reservation_strategy;
	/* The PF driver should evenly divide its remaining resources among all VFs. */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MAXIMAL \
		UINT32_C(0x0)
	/* The PF driver should only reserve minimal resources for each VF. */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MINIMAL \
		UINT32_C(0x1)
	/*
	 * The PF driver should not reserve any resources for each VF until the
	 * the VF interface is brought up.
	 */
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MINIMAL_STATIC \
		UINT32_C(0x2)
	#define HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_LAST \
		HWRM_FUNC_RESOURCE_QCAPS_OUTPUT_VF_RESERVATION_STRATEGY_MINIMAL_STATIC
	/* Minimum guaranteed number of RSS/COS contexts */
	uint16_t	min_rsscos_ctx;
	/* Maximum non-guaranteed number of RSS/COS contexts */
	uint16_t	max_rsscos_ctx;
	/* Minimum guaranteed number of completion rings */
	uint16_t	min_cmpl_rings;
	/* Maximum non-guaranteed number of completion rings */
	uint16_t	max_cmpl_rings;
	/* Minimum guaranteed number of transmit rings */
	uint16_t	min_tx_rings;
	/* Maximum non-guaranteed number of transmit rings */
	uint16_t	max_tx_rings;
	/* Minimum guaranteed number of receive rings */
	uint16_t	min_rx_rings;
	/* Maximum non-guaranteed number of receive rings */
	uint16_t	max_rx_rings;
	/* Minimum guaranteed number of L2 contexts */
	uint16_t	min_l2_ctxs;
	/* Maximum non-guaranteed number of L2 contexts */
	uint16_t	max_l2_ctxs;
	/* Minimum guaranteed number of VNICs */
	uint16_t	min_vnics;
	/* Maximum non-guaranteed number of VNICs */
	uint16_t	max_vnics;
	/* Minimum guaranteed number of statistic contexts */
	uint16_t	min_stat_ctx;
	/* Maximum non-guaranteed number of statistic contexts */
	uint16_t	max_stat_ctx;
	/* Minimum guaranteed number of ring groups */
	uint16_t	min_hw_ring_grps;
	/* Maximum non-guaranteed number of ring groups */
	uint16_t	max_hw_ring_grps;
	/*
	 * Maximum number of inputs into the transmit scheduler for this function.
	 * The number of TX rings assigned to the function cannot exceed this value.
	 */
	uint16_t	max_tx_scheduler_inputs;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************
 * hwrm_func_vf_resource_cfg *
 *****************************/


/* hwrm_func_vf_resource_cfg_input (size:448b/56B) */
struct hwrm_func_vf_resource_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* VF ID that is being configured by PF */
	uint16_t	vf_id;
	/* Maximum guaranteed number of MSI-X vectors for the function */
	uint16_t	max_msix;
	/* Minimum guaranteed number of RSS/COS contexts */
	uint16_t	min_rsscos_ctx;
	/* Maximum non-guaranteed number of RSS/COS contexts */
	uint16_t	max_rsscos_ctx;
	/* Minimum guaranteed number of completion rings */
	uint16_t	min_cmpl_rings;
	/* Maximum non-guaranteed number of completion rings */
	uint16_t	max_cmpl_rings;
	/* Minimum guaranteed number of transmit rings */
	uint16_t	min_tx_rings;
	/* Maximum non-guaranteed number of transmit rings */
	uint16_t	max_tx_rings;
	/* Minimum guaranteed number of receive rings */
	uint16_t	min_rx_rings;
	/* Maximum non-guaranteed number of receive rings */
	uint16_t	max_rx_rings;
	/* Minimum guaranteed number of L2 contexts */
	uint16_t	min_l2_ctxs;
	/* Maximum non-guaranteed number of L2 contexts */
	uint16_t	max_l2_ctxs;
	/* Minimum guaranteed number of VNICs */
	uint16_t	min_vnics;
	/* Maximum non-guaranteed number of VNICs */
	uint16_t	max_vnics;
	/* Minimum guaranteed number of statistic contexts */
	uint16_t	min_stat_ctx;
	/* Maximum non-guaranteed number of statistic contexts */
	uint16_t	max_stat_ctx;
	/* Minimum guaranteed number of ring groups */
	uint16_t	min_hw_ring_grps;
	/* Maximum non-guaranteed number of ring groups */
	uint16_t	max_hw_ring_grps;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_func_vf_resource_cfg_output (size:256b/32B) */
struct hwrm_func_vf_resource_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Reserved number of RSS/COS contexts */
	uint16_t	reserved_rsscos_ctx;
	/* Reserved number of completion rings */
	uint16_t	reserved_cmpl_rings;
	/* Reserved number of transmit rings */
	uint16_t	reserved_tx_rings;
	/* Reserved number of receive rings */
	uint16_t	reserved_rx_rings;
	/* Reserved number of L2 contexts */
	uint16_t	reserved_l2_ctxs;
	/* Reserved number of VNICs */
	uint16_t	reserved_vnics;
	/* Reserved number of statistic contexts */
	uint16_t	reserved_stat_ctx;
	/* Reserved number of ring groups */
	uint16_t	reserved_hw_ring_grps;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************************
 * hwrm_func_backing_store_qcaps *
 *********************************/


/* hwrm_func_backing_store_qcaps_input (size:128b/16B) */
struct hwrm_func_backing_store_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_func_backing_store_qcaps_output (size:512b/64B) */
struct hwrm_func_backing_store_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Maximum number of QP context entries supported for this function. */
	uint32_t	qp_max_entries;
	/*
	 * Minimum number of QP context entries that are needed to be reserved
	 * for QP1 for the PF and its VFs. PF drivers must allocate at least
	 * this many QP context entries, even if RoCE will not be used.
	 */
	uint16_t	qp_min_qp1_entries;
	/* Maximum number of QP context entries that can be used for L2. */
	uint16_t	qp_max_l2_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	qp_entry_size;
	/* Maximum number of SRQ context entries that can be used for L2. */
	uint16_t	srq_max_l2_entries;
	/* Maximum number of SRQ context entries supported for this function. */
	uint32_t	srq_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	srq_entry_size;
	/* Maximum number of CQ context entries that can be used for L2. */
	uint16_t	cq_max_l2_entries;
	/* Maximum number of CQ context entries supported for this function. */
	uint32_t	cq_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	cq_entry_size;
	/* Maximum number of VNIC context entries supported for this function. */
	uint16_t	vnic_max_vnic_entries;
	/* Maximum number of Ring table context entries supported for this function. */
	uint16_t	vnic_max_ring_table_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	vnic_entry_size;
	/* Maximum number of statistic context entries supported for this function. */
	uint32_t	stat_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	stat_entry_size;
	/* Maximum number of TQM context entries supported per ring. */
	uint16_t	tqm_max_entries_per_ring;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	tqm_entry_size;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	mrav_entry_size;
	/* Maximum number of MR/AV context entries supported for this function. */
	uint32_t	mrav_max_entries;
	/* Maximum number of Timer context entries supported for this function. */
	uint32_t	tim_max_entries;
	/* Number of bytes that must be allocated for each context entry. */
	uint16_t	tim_entry_size;
	uint8_t	unused_0;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************************
 * hwrm_func_backing_store_cfg *
 *******************************/


/* hwrm_func_backing_store_cfg_input (size:2048b/256B) */
struct hwrm_func_backing_store_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When set, the firmware only uses on-chip resources and does not
	 * expect any backing store to be provided by the host driver. This
	 * mode provides minimal L2 functionality (e.g. limited L2 resources,
	 * no RoCE).
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_FLAGS_PREBOOT_MODE \
		UINT32_C(0x1)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the qp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_QP \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the srq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_SRQ \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the cq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_CQ \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the vnic fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_VNIC \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the stat fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_STAT \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the tqm_sp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_SP \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the tqm_ring0 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING0 \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tqm_ring1 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING1 \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the tqm_ring2 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING2 \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the tqm_ring3 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING3 \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the tqm_ring4 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING4 \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the tqm_ring5 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING5 \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the tqm_ring6 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING6 \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the tqm_ring7 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TQM_RING7 \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the mrav fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_MRAV \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the tim fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_ENABLES_TIM \
		UINT32_C(0x8000)
	/* QPC page size and level. */
	uint8_t	qpc_pg_size_qpc_lvl;
	/* QPC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_LVL_LVL_2
	/* QPC page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_QPC_PG_SIZE_PG_1G
	/* SRQ page size and level. */
	uint8_t	srq_pg_size_srq_lvl;
	/* SRQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_LVL_LVL_2
	/* SRQ page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_SRQ_PG_SIZE_PG_1G
	/* CQ page size and level. */
	uint8_t	cq_pg_size_cq_lvl;
	/* CQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_LVL_LVL_2
	/* CQ page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_CQ_PG_SIZE_PG_1G
	/* VNIC page size and level. */
	uint8_t	vnic_pg_size_vnic_lvl;
	/* VNIC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_LVL_LVL_2
	/* VNIC page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_VNIC_PG_SIZE_PG_1G
	/* Stat page size and level. */
	uint8_t	stat_pg_size_stat_lvl;
	/* Stat PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_LVL_LVL_2
	/* Stat page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_STAT_PG_SIZE_PG_1G
	/* TQM slow path page size and level. */
	uint8_t	tqm_sp_pg_size_tqm_sp_lvl;
	/* TQM slow path PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_LVL_LVL_2
	/* TQM slow path page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_SP_PG_SIZE_PG_1G
	/* TQM ring 0 page size and level. */
	uint8_t	tqm_ring0_pg_size_tqm_ring0_lvl;
	/* TQM ring 0 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_LVL_LVL_2
	/* TQM ring 0 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING0_PG_SIZE_PG_1G
	/* TQM ring 1 page size and level. */
	uint8_t	tqm_ring1_pg_size_tqm_ring1_lvl;
	/* TQM ring 1 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_LVL_LVL_2
	/* TQM ring 1 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING1_PG_SIZE_PG_1G
	/* TQM ring 2 page size and level. */
	uint8_t	tqm_ring2_pg_size_tqm_ring2_lvl;
	/* TQM ring 2 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_LVL_LVL_2
	/* TQM ring 2 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING2_PG_SIZE_PG_1G
	/* TQM ring 3 page size and level. */
	uint8_t	tqm_ring3_pg_size_tqm_ring3_lvl;
	/* TQM ring 3 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_LVL_LVL_2
	/* TQM ring 3 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING3_PG_SIZE_PG_1G
	/* TQM ring 4 page size and level. */
	uint8_t	tqm_ring4_pg_size_tqm_ring4_lvl;
	/* TQM ring 4 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_LVL_LVL_2
	/* TQM ring 4 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING4_PG_SIZE_PG_1G
	/* TQM ring 5 page size and level. */
	uint8_t	tqm_ring5_pg_size_tqm_ring5_lvl;
	/* TQM ring 5 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_LVL_LVL_2
	/* TQM ring 5 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING5_PG_SIZE_PG_1G
	/* TQM ring 6 page size and level. */
	uint8_t	tqm_ring6_pg_size_tqm_ring6_lvl;
	/* TQM ring 6 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_LVL_LVL_2
	/* TQM ring 6 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING6_PG_SIZE_PG_1G
	/* TQM ring 7 page size and level. */
	uint8_t	tqm_ring7_pg_size_tqm_ring7_lvl;
	/* TQM ring 7 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_LVL_LVL_2
	/* TQM ring 7 page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TQM_RING7_PG_SIZE_PG_1G
	/* MR/AV page size and level. */
	uint8_t	mrav_pg_size_mrav_lvl;
	/* MR/AV PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_LVL_LVL_2
	/* MR/AV page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_MRAV_PG_SIZE_PG_1G
	/* Timer page size and level. */
	uint8_t	tim_pg_size_tim_lvl;
	/* Timer PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_LVL_LVL_2
	/* Timer page size. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_CFG_INPUT_TIM_PG_SIZE_PG_1G
	/* QP page directory. */
	uint64_t	qpc_page_dir;
	/* SRQ page directory. */
	uint64_t	srq_page_dir;
	/* CQ page directory. */
	uint64_t	cq_page_dir;
	/* VNIC page directory. */
	uint64_t	vnic_page_dir;
	/* Stat page directory. */
	uint64_t	stat_page_dir;
	/* TQM slowpath page directory. */
	uint64_t	tqm_sp_page_dir;
	/* TQM ring 0 page directory. */
	uint64_t	tqm_ring0_page_dir;
	/* TQM ring 1 page directory. */
	uint64_t	tqm_ring1_page_dir;
	/* TQM ring 2 page directory. */
	uint64_t	tqm_ring2_page_dir;
	/* TQM ring 3 page directory. */
	uint64_t	tqm_ring3_page_dir;
	/* TQM ring 4 page directory. */
	uint64_t	tqm_ring4_page_dir;
	/* TQM ring 5 page directory. */
	uint64_t	tqm_ring5_page_dir;
	/* TQM ring 6 page directory. */
	uint64_t	tqm_ring6_page_dir;
	/* TQM ring 7 page directory. */
	uint64_t	tqm_ring7_page_dir;
	/* MR/AV page directory. */
	uint64_t	mrav_page_dir;
	/* Timer page directory. */
	uint64_t	tim_page_dir;
	/* Number of QPs. */
	uint32_t	qp_num_entries;
	/* Number of SRQs. */
	uint32_t	srq_num_entries;
	/* Number of CQs. */
	uint32_t	cq_num_entries;
	/* Number of Stats. */
	uint32_t	stat_num_entries;
	/* Number of TQM slowpath entries. */
	uint32_t	tqm_sp_num_entries;
	/* Number of TQM ring 0 entries. */
	uint32_t	tqm_ring0_num_entries;
	/* Number of TQM ring 1 entries. */
	uint32_t	tqm_ring1_num_entries;
	/* Number of TQM ring 2 entries. */
	uint32_t	tqm_ring2_num_entries;
	/* Number of TQM ring 3 entries. */
	uint32_t	tqm_ring3_num_entries;
	/* Number of TQM ring 4 entries. */
	uint32_t	tqm_ring4_num_entries;
	/* Number of TQM ring 5 entries. */
	uint32_t	tqm_ring5_num_entries;
	/* Number of TQM ring 6 entries. */
	uint32_t	tqm_ring6_num_entries;
	/* Number of TQM ring 7 entries. */
	uint32_t	tqm_ring7_num_entries;
	/* Number of MR/AV entries. */
	uint32_t	mrav_num_entries;
	/* Number of Timer entries. */
	uint32_t	tim_num_entries;
	/* Number of entries to reserve for QP1 */
	uint16_t	qp_num_qp1_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	qp_num_l2_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	qp_entry_size;
	/* Number of entries to reserve for L2 */
	uint16_t	srq_num_l2_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	srq_entry_size;
	/* Number of entries to reserve for L2 */
	uint16_t	cq_num_l2_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	cq_entry_size;
	/* Number of entries to reserve for VNIC entries */
	uint16_t	vnic_num_vnic_entries;
	/* Number of entries to reserve for Ring table entries */
	uint16_t	vnic_num_ring_table_entries;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	vnic_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	stat_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	tqm_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	mrav_entry_size;
	/* Number of bytes that have been allocated for each context entry. */
	uint16_t	tim_entry_size;
} __attribute__((packed));

/* hwrm_func_backing_store_cfg_output (size:128b/16B) */
struct hwrm_func_backing_store_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_func_backing_store_qcfg *
 ********************************/


/* hwrm_func_backing_store_qcfg_input (size:128b/16B) */
struct hwrm_func_backing_store_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_func_backing_store_qcfg_output (size:1920b/240B) */
struct hwrm_func_backing_store_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/*
	 * When set, the firmware only uses on-chip resources and does not
	 * expect any backing store to be provided by the host driver. This
	 * mode provides minimal L2 functionality (e.g. limited L2 resources,
	 * no RoCE).
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_FLAGS_PREBOOT_MODE \
		UINT32_C(0x1)
	uint8_t	unused_0[4];
	/*
	 * This bit must be '1' for the qp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_QP \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the srq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_SRQ \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the cq fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_CQ \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the vnic fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_VNIC \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the stat fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_STAT \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the tqm_sp fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_SP \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the tqm_ring0 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING0 \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tqm_ring1 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING1 \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the tqm_ring2 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING2 \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the tqm_ring3 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING3 \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the tqm_ring4 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING4 \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the tqm_ring5 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING5 \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the tqm_ring6 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING6 \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the tqm_ring7 fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TQM_RING7 \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the mrav fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_MRAV \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the tim fields to be
	 * configured.
	 */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_UNUSED_0_TIM \
		UINT32_C(0x8000)
	/* QPC page size and level. */
	uint8_t	qpc_pg_size_qpc_lvl;
	/* QPC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_LVL_LVL_2
	/* QPC page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_QPC_PG_SIZE_PG_1G
	/* SRQ page size and level. */
	uint8_t	srq_pg_size_srq_lvl;
	/* SRQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_LVL_LVL_2
	/* SRQ page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_SRQ_PG_SIZE_PG_1G
	/* CQ page size and level. */
	uint8_t	cq_pg_size_cq_lvl;
	/* CQ PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_LVL_LVL_2
	/* CQ page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_CQ_PG_SIZE_PG_1G
	/* VNIC page size and level. */
	uint8_t	vnic_pg_size_vnic_lvl;
	/* VNIC PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_LVL_LVL_2
	/* VNIC page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_VNIC_PG_SIZE_PG_1G
	/* Stat page size and level. */
	uint8_t	stat_pg_size_stat_lvl;
	/* Stat PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_LVL_LVL_2
	/* Stat page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_STAT_PG_SIZE_PG_1G
	/* TQM slow path page size and level. */
	uint8_t	tqm_sp_pg_size_tqm_sp_lvl;
	/* TQM slow path PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_LVL_LVL_2
	/* TQM slow path page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_SP_PG_SIZE_PG_1G
	/* TQM ring 0 page size and level. */
	uint8_t	tqm_ring0_pg_size_tqm_ring0_lvl;
	/* TQM ring 0 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_LVL_LVL_2
	/* TQM ring 0 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING0_PG_SIZE_PG_1G
	/* TQM ring 1 page size and level. */
	uint8_t	tqm_ring1_pg_size_tqm_ring1_lvl;
	/* TQM ring 1 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_LVL_LVL_2
	/* TQM ring 1 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING1_PG_SIZE_PG_1G
	/* TQM ring 2 page size and level. */
	uint8_t	tqm_ring2_pg_size_tqm_ring2_lvl;
	/* TQM ring 2 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_LVL_LVL_2
	/* TQM ring 2 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING2_PG_SIZE_PG_1G
	/* TQM ring 3 page size and level. */
	uint8_t	tqm_ring3_pg_size_tqm_ring3_lvl;
	/* TQM ring 3 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_LVL_LVL_2
	/* TQM ring 3 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING3_PG_SIZE_PG_1G
	/* TQM ring 4 page size and level. */
	uint8_t	tqm_ring4_pg_size_tqm_ring4_lvl;
	/* TQM ring 4 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_LVL_LVL_2
	/* TQM ring 4 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING4_PG_SIZE_PG_1G
	/* TQM ring 5 page size and level. */
	uint8_t	tqm_ring5_pg_size_tqm_ring5_lvl;
	/* TQM ring 5 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_LVL_LVL_2
	/* TQM ring 5 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING5_PG_SIZE_PG_1G
	/* TQM ring 6 page size and level. */
	uint8_t	tqm_ring6_pg_size_tqm_ring6_lvl;
	/* TQM ring 6 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_LVL_LVL_2
	/* TQM ring 6 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING6_PG_SIZE_PG_1G
	/* TQM ring 7 page size and level. */
	uint8_t	tqm_ring7_pg_size_tqm_ring7_lvl;
	/* TQM ring 7 PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_LVL_LVL_2
	/* TQM ring 7 page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TQM_RING7_PG_SIZE_PG_1G
	/* MR/AV page size and level. */
	uint8_t	mrav_pg_size_mrav_lvl;
	/* MR/AV PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_LVL_LVL_2
	/* MR/AV page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_MRAV_PG_SIZE_PG_1G
	/* Timer page size and level. */
	uint8_t	tim_pg_size_tim_lvl;
	/* Timer PBL indirect levels. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_MASK \
		UINT32_C(0xf)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_SFT       0
	/* PBL pointer is physical start address. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_0 \
		UINT32_C(0x0)
	/* PBL pointer points to PTE table. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_1 \
		UINT32_C(0x1)
	/* PBL pointer points to PDE table with each entry pointing to PTE tables. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_2 \
		UINT32_C(0x2)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_LVL_LVL_2
	/* Timer page size. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_MASK \
		UINT32_C(0xf0)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_SFT   4
	/* 4KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_4K \
		(UINT32_C(0x0) << 4)
	/* 8KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_8K \
		(UINT32_C(0x1) << 4)
	/* 64KB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_64K \
		(UINT32_C(0x2) << 4)
	/* 2MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_2M \
		(UINT32_C(0x3) << 4)
	/* 8MB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_8M \
		(UINT32_C(0x4) << 4)
	/* 1GB. */
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_1G \
		(UINT32_C(0x5) << 4)
	#define HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_LAST \
		HWRM_FUNC_BACKING_STORE_QCFG_OUTPUT_TIM_PG_SIZE_PG_1G
	/* QP page directory. */
	uint64_t	qpc_page_dir;
	/* SRQ page directory. */
	uint64_t	srq_page_dir;
	/* CQ page directory. */
	uint64_t	cq_page_dir;
	/* VNIC page directory. */
	uint64_t	vnic_page_dir;
	/* Stat page directory. */
	uint64_t	stat_page_dir;
	/* TQM slowpath page directory. */
	uint64_t	tqm_sp_page_dir;
	/* TQM ring 0 page directory. */
	uint64_t	tqm_ring0_page_dir;
	/* TQM ring 1 page directory. */
	uint64_t	tqm_ring1_page_dir;
	/* TQM ring 2 page directory. */
	uint64_t	tqm_ring2_page_dir;
	/* TQM ring 3 page directory. */
	uint64_t	tqm_ring3_page_dir;
	/* TQM ring 4 page directory. */
	uint64_t	tqm_ring4_page_dir;
	/* TQM ring 5 page directory. */
	uint64_t	tqm_ring5_page_dir;
	/* TQM ring 6 page directory. */
	uint64_t	tqm_ring6_page_dir;
	/* TQM ring 7 page directory. */
	uint64_t	tqm_ring7_page_dir;
	/* MR/AV page directory. */
	uint64_t	mrav_page_dir;
	/* Timer page directory. */
	uint64_t	tim_page_dir;
	/* Number of entries to reserve for QP1 */
	uint16_t	qp_num_qp1_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	qp_num_l2_entries;
	/* Number of QPs. */
	uint32_t	qp_num_entries;
	/* Number of SRQs. */
	uint32_t	srq_num_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	srq_num_l2_entries;
	/* Number of entries to reserve for L2 */
	uint16_t	cq_num_l2_entries;
	/* Number of CQs. */
	uint32_t	cq_num_entries;
	/* Number of entries to reserve for VNIC entries */
	uint16_t	vnic_num_vnic_entries;
	/* Number of entries to reserve for Ring table entries */
	uint16_t	vnic_num_ring_table_entries;
	/* Number of Stats. */
	uint32_t	stat_num_entries;
	/* Number of TQM slowpath entries. */
	uint32_t	tqm_sp_num_entries;
	/* Number of TQM ring 0 entries. */
	uint32_t	tqm_ring0_num_entries;
	/* Number of TQM ring 1 entries. */
	uint32_t	tqm_ring1_num_entries;
	/* Number of TQM ring 2 entries. */
	uint32_t	tqm_ring2_num_entries;
	/* Number of TQM ring 3 entries. */
	uint32_t	tqm_ring3_num_entries;
	/* Number of TQM ring 4 entries. */
	uint32_t	tqm_ring4_num_entries;
	/* Number of TQM ring 5 entries. */
	uint32_t	tqm_ring5_num_entries;
	/* Number of TQM ring 6 entries. */
	uint32_t	tqm_ring6_num_entries;
	/* Number of TQM ring 7 entries. */
	uint32_t	tqm_ring7_num_entries;
	/* Number of MR/AV entries. */
	uint32_t	mrav_num_entries;
	/* Number of Timer entries. */
	uint32_t	tim_num_entries;
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_port_phy_cfg *
 *********************/


/* hwrm_port_phy_cfg_input (size:448b/56B) */
struct hwrm_port_phy_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is set to '1', the PHY for the port shall
	 * be reset.
	 *
	 * # If this bit is set to 1, then the HWRM shall reset the
	 * PHY after applying PHY configuration changes specified
	 * in this command.
	 * # In order to guarantee that PHY configuration changes
	 * specified in this command take effect, the HWRM
	 * client should set this flag to 1.
	 * # If this bit is not set to 1, then the HWRM may reset
	 * the PHY depending on the current PHY configuration and
	 * settings specified in this command.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_RESET_PHY \
		UINT32_C(0x1)
	/* deprecated bit.  Do not use!!! */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_DEPRECATED \
		UINT32_C(0x2)
	/*
	 * When this bit is set to '1', the link shall be forced to
	 * the force_link_speed value.
	 *
	 * When this bit is set to '1', the HWRM client should
	 * not enable any of the auto negotiation related
	 * fields represented by auto_XXX fields in this command.
	 * When this bit is set to '1' and the HWRM client has
	 * enabled a auto_XXX field in this command, then the
	 * HWRM shall ignore the enabled auto_XXX field.
	 *
	 * When this bit is set to zero, the link
	 * shall be allowed to autoneg.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FORCE \
		UINT32_C(0x4)
	/*
	 * When this bit is set to '1', the auto-negotiation process
	 * shall be restarted on the link.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_RESTART_AUTONEG \
		UINT32_C(0x8)
	/*
	 * When this bit is set to '1', Energy Efficient Ethernet
	 * (EEE) is requested to be enabled on this link.
	 * If EEE is not supported on this port, then this flag
	 * shall be ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_ENABLE \
		UINT32_C(0x10)
	/*
	 * When this bit is set to '1', Energy Efficient Ethernet
	 * (EEE) is requested to be disabled on this link.
	 * If EEE is not supported on this port, then this flag
	 * shall be ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_DISABLE \
		UINT32_C(0x20)
	/*
	 * When this bit is set to '1' and EEE is enabled on this
	 * link, then TX LPI is requested to be enabled on the link.
	 * If EEE is not supported on this port, then this flag
	 * shall be ignored by the HWRM.
	 * If EEE is disabled on this port, then this flag shall be
	 * ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_TX_LPI_ENABLE \
		UINT32_C(0x40)
	/*
	 * When this bit is set to '1' and EEE is enabled on this
	 * link, then TX LPI is requested to be disabled on the link.
	 * If EEE is not supported on this port, then this flag
	 * shall be ignored by the HWRM.
	 * If EEE is disabled on this port, then this flag shall be
	 * ignored by the HWRM.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_EEE_TX_LPI_DISABLE \
		UINT32_C(0x80)
	/*
	 * When set to 1, then the HWRM shall enable FEC autonegotitation
	 * on this port if supported.
	 * When set to 0, then this flag shall be ignored.
	 * If FEC autonegotiation is not supported, then the HWRM shall ignore this
	 * flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_AUTONEG_ENABLE \
		UINT32_C(0x100)
	/*
	 * When set to 1, then the HWRM shall disable FEC autonegotiation
	 * on this port if supported.
	 * When set to 0, then this flag shall be ignored.
	 * If FEC autonegotiation is not supported, then the HWRM shall ignore this
	 * flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_AUTONEG_DISABLE \
		UINT32_C(0x200)
	/*
	 * When set to 1, then the HWRM shall enable FEC CLAUSE 74 (Fire Code)
	 * on this port if supported.
	 * When set to 0, then this flag shall be ignored.
	 * If FEC CLAUSE 74 is not supported, then the HWRM shall ignore this
	 * flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE74_ENABLE \
		UINT32_C(0x400)
	/*
	 * When set to 1, then the HWRM shall disable FEC CLAUSE 74 (Fire Code)
	 * on this port if supported.
	 * When set to 0, then this flag shall be ignored.
	 * If FEC CLAUSE 74 is not supported, then the HWRM shall ignore this
	 * flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE74_DISABLE \
		UINT32_C(0x800)
	/*
	 * When set to 1, then the HWRM shall enable FEC CLAUSE 91 (Reed Solomon)
	 * on this port if supported.
	 * When set to 0, then this flag shall be ignored.
	 * If FEC CLAUSE 91 is not supported, then the HWRM shall ignore this
	 * flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE91_ENABLE \
		UINT32_C(0x1000)
	/*
	 * When set to 1, then the HWRM shall disable FEC CLAUSE 91 (Reed Solomon)
	 * on this port if supported.
	 * When set to 0, then this flag shall be ignored.
	 * If FEC CLAUSE 91 is not supported, then the HWRM shall ignore this
	 * flag.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FEC_CLAUSE91_DISABLE \
		UINT32_C(0x2000)
	/*
	 * When this bit is set to '1', the link shall be forced to
	 * be taken down.
	 *
	 * # When this bit is set to '1", all other
	 * command input settings related to the link speed shall
	 * be ignored.
	 * Once the link state is forced down, it can be
	 * explicitly cleared from that state by setting this flag
	 * to '0'.
	 * # If this flag is set to '0', then the link shall be
	 * cleared from forced down state if the link is in forced
	 * down state.
	 * There may be conditions (e.g. out-of-band or sideband
	 * configuration changes for the link) outside the scope
	 * of the HWRM implementation that may clear forced down
	 * link state.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FLAGS_FORCE_LINK_DWN \
		UINT32_C(0x4000)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the auto_mode field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_MODE \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the auto_duplex field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_DUPLEX \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the auto_pause field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_PAUSE \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the auto_link_speed field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_LINK_SPEED \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the auto_link_speed_mask field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_AUTO_LINK_SPEED_MASK \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the wirespeed field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_WIRESPEED \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the lpbk field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_LPBK \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the preemphasis field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_PREEMPHASIS \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the force_pause field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_FORCE_PAUSE \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the eee_link_speed_mask field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_EEE_LINK_SPEED_MASK \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the tx_lpi_timer field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_ENABLES_TX_LPI_TIMER \
		UINT32_C(0x400)
	/* Port ID of port that is to be configured. */
	uint16_t	port_id;
	/*
	 * This is the speed that will be used if the force
	 * bit is '1'.  If unsupported speed is selected, an error
	 * will be generated.
	 */
	uint16_t	force_link_speed;
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_100MB UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_1GB   UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_2GB   UINT32_C(0x14)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_2_5GB UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_10GB  UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_20GB  UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_25GB  UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_40GB  UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_50GB  UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_100GB UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_10MB  UINT32_C(0xffff)
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_LAST \
		HWRM_PORT_PHY_CFG_INPUT_FORCE_LINK_SPEED_10MB
	/*
	 * This value is used to identify what autoneg mode is
	 * used when the link speed is not being forced.
	 */
	uint8_t	auto_mode;
	/* Disable autoneg or autoneg disabled. No speeds are selected. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_NONE         UINT32_C(0x0)
	/* Select all possible speeds for autoneg mode. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_ALL_SPEEDS   UINT32_C(0x1)
	/*
	 * Select only the auto_link_speed speed for autoneg mode. This mode has
	 * been DEPRECATED. An HWRM client should not use this mode.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_ONE_SPEED    UINT32_C(0x2)
	/*
	 * Select the auto_link_speed or any speed below that speed for autoneg.
	 * This mode has been DEPRECATED. An HWRM client should not use this mode.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_ONE_OR_BELOW UINT32_C(0x3)
	/*
	 * Select the speeds based on the corresponding link speed mask value
	 * that is provided.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_SPEED_MASK   UINT32_C(0x4)
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_LAST \
		HWRM_PORT_PHY_CFG_INPUT_AUTO_MODE_SPEED_MASK
	/*
	 * This is the duplex setting that will be used if the autoneg_mode
	 * is "one_speed" or "one_or_below".
	 */
	uint8_t	auto_duplex;
	/* Half Duplex will be requested. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_HALF UINT32_C(0x0)
	/* Full duplex will be requested. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_FULL UINT32_C(0x1)
	/* Both Half and Full dupex will be requested. */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_BOTH UINT32_C(0x2)
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_LAST \
		HWRM_PORT_PHY_CFG_INPUT_AUTO_DUPLEX_BOTH
	/*
	 * This value is used to configure the pause that will be
	 * used for autonegotiation.
	 * Add text on the usage of auto_pause and force_pause.
	 */
	uint8_t	auto_pause;
	/*
	 * When this bit is '1', Generation of tx pause messages
	 * has been requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_PAUSE_TX \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages
	 * has been requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_PAUSE_RX \
		UINT32_C(0x2)
	/*
	 * When set to 1, the advertisement of pause is enabled.
	 *
	 * # When the auto_mode is not set to none and this flag is
	 * set to 1, then the auto_pause bits on this port are being
	 * advertised and autoneg pause results are being interpreted.
	 * # When the auto_mode is not set to none and this
	 * flag is set to 0, the pause is forced as indicated in
	 * force_pause, and also advertised as auto_pause bits, but
	 * the autoneg results are not interpreted since the pause
	 * configuration is being forced.
	 * # When the auto_mode is set to none and this flag is set to
	 * 1, auto_pause bits should be ignored and should be set to 0.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_PAUSE_AUTONEG_PAUSE \
		UINT32_C(0x4)
	uint8_t	unused_0;
	/*
	 * This is the speed that will be used if the autoneg_mode
	 * is "one_speed" or "one_or_below".  If an unsupported speed
	 * is selected, an error will be generated.
	 */
	uint16_t	auto_link_speed;
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_100MB UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_1GB   UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_2GB   UINT32_C(0x14)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_2_5GB UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_10GB  UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_20GB  UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_25GB  UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_40GB  UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_50GB  UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_100GB UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_10MB  UINT32_C(0xffff)
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_LAST \
		HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_10MB
	/*
	 * This is a mask of link speeds that will be used if
	 * autoneg_mode is "mask".  If unsupported speed is enabled
	 * an error will be generated.
	 */
	uint16_t	auto_link_speed_mask;
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_100MBHD \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_100MB \
		UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_1GBHD \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_1GB \
		UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_2GB \
		UINT32_C(0x10)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_2_5GB \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_10GB \
		UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_20GB \
		UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_25GB \
		UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_40GB \
		UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_50GB \
		UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_100GB \
		UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_10MBHD \
		UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_AUTO_LINK_SPEED_MASK_10MB \
		UINT32_C(0x2000)
	/* This value controls the wirespeed feature. */
	uint8_t	wirespeed;
	/* Wirespeed feature is disabled. */
	#define HWRM_PORT_PHY_CFG_INPUT_WIRESPEED_OFF UINT32_C(0x0)
	/* Wirespeed feature is enabled. */
	#define HWRM_PORT_PHY_CFG_INPUT_WIRESPEED_ON  UINT32_C(0x1)
	#define HWRM_PORT_PHY_CFG_INPUT_WIRESPEED_LAST \
		HWRM_PORT_PHY_CFG_INPUT_WIRESPEED_ON
	/* This value controls the loopback setting for the PHY. */
	uint8_t	lpbk;
	/* No loopback is selected.  Normal operation. */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_NONE     UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that
	 * host data is sent back to the host without modification.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_LOCAL    UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that
	 * port logic will send packets back out the transmitter that
	 * are received.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_REMOTE   UINT32_C(0x2)
	/*
	 * The HW will be configured with external loopback such that
	 * host data is sent on the trasmitter and based on the external
	 * loopback connection the data will be received without modification.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_EXTERNAL UINT32_C(0x3)
	#define HWRM_PORT_PHY_CFG_INPUT_LPBK_LAST \
		HWRM_PORT_PHY_CFG_INPUT_LPBK_EXTERNAL
	/*
	 * This value is used to configure the pause that will be
	 * used for force mode.
	 */
	uint8_t	force_pause;
	/*
	 * When this bit is '1', Generation of tx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_PAUSE_TX     UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_CFG_INPUT_FORCE_PAUSE_RX     UINT32_C(0x2)
	uint8_t	unused_1;
	/*
	 * This value controls the pre-emphasis to be used for the
	 * link.  Driver should not set this value (use
	 * enable.preemphasis = 0) unless driver is sure of setting.
	 * Normally HWRM FW will determine proper pre-emphasis.
	 */
	uint32_t	preemphasis;
	/*
	 * Setting for link speed mask that is used to
	 * advertise speeds during autonegotiation when EEE is enabled.
	 * This field is valid only when EEE is enabled.
	 * The speeds specified in this field shall be a subset of
	 * speeds specified in auto_link_speed_mask.
	 * If EEE is enabled,then at least one speed shall be provided
	 * in this mask.
	 */
	uint16_t	eee_link_speed_mask;
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD1 \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_100MB \
		UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD2 \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_1GB \
		UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD3 \
		UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_RSVD4 \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_CFG_INPUT_EEE_LINK_SPEED_MASK_10GB \
		UINT32_C(0x40)
	uint8_t	unused_2[2];
	/*
	 * Reuested setting of TX LPI timer in microseconds.
	 * This field is valid only when EEE is enabled and TX LPI is
	 * enabled.
	 */
	uint32_t	tx_lpi_timer;
	#define HWRM_PORT_PHY_CFG_INPUT_TX_LPI_TIMER_MASK UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_CFG_INPUT_TX_LPI_TIMER_SFT 0
	uint32_t	unused_3;
} __attribute__((packed));

/* hwrm_port_phy_cfg_output (size:128b/16B) */
struct hwrm_port_phy_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_port_phy_cfg_cmd_err (size:64b/8B) */
struct hwrm_port_phy_cfg_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_PORT_PHY_CFG_CMD_ERR_CODE_UNKNOWN       UINT32_C(0x0)
	/* Unable to complete operation due to invalid speed */
	#define HWRM_PORT_PHY_CFG_CMD_ERR_CODE_ILLEGAL_SPEED UINT32_C(0x1)
	/*
	 * retry the command since the phy is not ready.
	 * retry count is returned in opaque_0.
	 * This is only valid for the first command and
	 * this value will not change for successive calls.
	 * but if a 0 is returned at any time then this should
	 * be treated as an un recoverable failure,
	 *
	 * retry interval in milli seconds is returned in opaque_1.
	 * This specifies the time that user should wait before
	 * issuing the next port_phy_cfg command.
	 */
	#define HWRM_PORT_PHY_CFG_CMD_ERR_CODE_RETRY         UINT32_C(0x2)
	#define HWRM_PORT_PHY_CFG_CMD_ERR_CODE_LAST \
		HWRM_PORT_PHY_CFG_CMD_ERR_CODE_RETRY
	uint8_t	unused_0[7];
} __attribute__((packed));

/**********************
 * hwrm_port_phy_qcfg *
 **********************/


/* hwrm_port_phy_qcfg_input (size:192b/24B) */
struct hwrm_port_phy_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is to be queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_phy_qcfg_output (size:768b/96B) */
struct hwrm_port_phy_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value indicates the current link status. */
	uint8_t	link;
	/* There is no link or cable detected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_NO_LINK UINT32_C(0x0)
	/* There is no link, but a cable has been detected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SIGNAL  UINT32_C(0x1)
	/* There is a link. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_LINK    UINT32_C(0x2)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_LINK_LINK
	uint8_t	unused_0;
	/* This value indicates the current link speed of the connection. */
	uint16_t	link_speed;
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_100MB UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_1GB   UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_2GB   UINT32_C(0x14)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_2_5GB UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_10GB  UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_20GB  UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_25GB  UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_40GB  UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_50GB  UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_100GB UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_10MB  UINT32_C(0xffff)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_LINK_SPEED_10MB
	/*
	 * This value is indicates the duplex of the current
	 * configuration.
	 */
	uint8_t	duplex_cfg;
	/* Half Duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_CFG_HALF UINT32_C(0x0)
	/* Full duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_CFG_FULL UINT32_C(0x1)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_CFG_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_CFG_FULL
	/*
	 * This value is used to indicate the current
	 * pause configuration. When autoneg is enabled, this value
	 * represents the autoneg results of pause configuration.
	 */
	uint8_t	pause;
	/*
	 * When this bit is '1', Generation of tx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PAUSE_TX     UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PAUSE_RX     UINT32_C(0x2)
	/*
	 * The supported speeds for the port. This is a bit mask.
	 * For each speed that is supported, the corrresponding
	 * bit will be set to '1'.
	 */
	uint16_t	support_speeds;
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_100MBHD \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_100MB \
		UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_1GBHD \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_1GB \
		UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_2GB \
		UINT32_C(0x10)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_2_5GB \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_10GB \
		UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_20GB \
		UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_25GB \
		UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_40GB \
		UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_50GB \
		UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_100GB \
		UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_10MBHD \
		UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_SUPPORT_SPEEDS_10MB \
		UINT32_C(0x2000)
	/*
	 * Current setting of forced link speed.
	 * When the link speed is not being forced, this
	 * value shall be set to 0.
	 */
	uint16_t	force_link_speed;
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_100MB UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_1GB   UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_2GB   UINT32_C(0x14)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_2_5GB UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_10GB  UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_20GB  UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_25GB  UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_40GB \
		UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_50GB \
		UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_100GB \
		UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_10MB \
		UINT32_C(0xffff)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_LINK_SPEED_10MB
	/* Current setting of auto negotiation mode. */
	uint8_t	auto_mode;
	/* Disable autoneg or autoneg disabled. No speeds are selected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_NONE         UINT32_C(0x0)
	/* Select all possible speeds for autoneg mode. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_ALL_SPEEDS   UINT32_C(0x1)
	/*
	 * Select only the auto_link_speed speed for autoneg mode. This mode has
	 * been DEPRECATED. An HWRM client should not use this mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_ONE_SPEED    UINT32_C(0x2)
	/*
	 * Select the auto_link_speed or any speed below that speed for autoneg.
	 * This mode has been DEPRECATED. An HWRM client should not use this mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_ONE_OR_BELOW UINT32_C(0x3)
	/*
	 * Select the speeds based on the corresponding link speed mask value
	 * that is provided.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_SPEED_MASK   UINT32_C(0x4)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_MODE_SPEED_MASK
	/*
	 * Current setting of pause autonegotiation.
	 * Move autoneg_pause flag here.
	 */
	uint8_t	auto_pause;
	/*
	 * When this bit is '1', Generation of tx pause messages
	 * has been requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_PAUSE_TX \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages
	 * has been requested. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_PAUSE_RX \
		UINT32_C(0x2)
	/*
	 * When set to 1, the advertisement of pause is enabled.
	 *
	 * # When the auto_mode is not set to none and this flag is
	 * set to 1, then the auto_pause bits on this port are being
	 * advertised and autoneg pause results are being interpreted.
	 * # When the auto_mode is not set to none and this
	 * flag is set to 0, the pause is forced as indicated in
	 * force_pause, and also advertised as auto_pause bits, but
	 * the autoneg results are not interpreted since the pause
	 * configuration is being forced.
	 * # When the auto_mode is set to none and this flag is set to
	 * 1, auto_pause bits should be ignored and should be set to 0.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_PAUSE_AUTONEG_PAUSE \
		UINT32_C(0x4)
	/*
	 * Current setting for auto_link_speed. This field is only
	 * valid when auto_mode is set to "one_speed" or "one_or_below".
	 */
	uint16_t	auto_link_speed;
	/* 100Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_100MB UINT32_C(0x1)
	/* 1Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_1GB   UINT32_C(0xa)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_2GB   UINT32_C(0x14)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_2_5GB UINT32_C(0x19)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_10GB  UINT32_C(0x64)
	/* 20Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_20GB  UINT32_C(0xc8)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_25GB  UINT32_C(0xfa)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_40GB  UINT32_C(0x190)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_50GB  UINT32_C(0x1f4)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_100GB UINT32_C(0x3e8)
	/* 10Mb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_10MB \
		UINT32_C(0xffff)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_10MB
	/*
	 * Current setting for auto_link_speed_mask that is used to
	 * advertise speeds during autonegotiation.
	 * This field is only valid when auto_mode is set to "mask".
	 * The speeds specified in this field shall be a subset of
	 * supported speeds on this port.
	 */
	uint16_t	auto_link_speed_mask;
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_100MBHD \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_100MB \
		UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_1GBHD \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_1GB \
		UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_2GB \
		UINT32_C(0x10)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_2_5GB \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_10GB \
		UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_20GB \
		UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_25GB \
		UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_40GB \
		UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_50GB \
		UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_100GB \
		UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_10MBHD \
		UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_AUTO_LINK_SPEED_MASK_10MB \
		UINT32_C(0x2000)
	/* Current setting for wirespeed. */
	uint8_t	wirespeed;
	/* Wirespeed feature is disabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_WIRESPEED_OFF UINT32_C(0x0)
	/* Wirespeed feature is enabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_WIRESPEED_ON  UINT32_C(0x1)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_WIRESPEED_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_WIRESPEED_ON
	/* Current setting for loopback. */
	uint8_t	lpbk;
	/* No loopback is selected.  Normal operation. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_NONE     UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that
	 * host data is sent back to the host without modification.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_LOCAL    UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that
	 * port logic will send packets back out the transmitter that
	 * are received.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_REMOTE   UINT32_C(0x2)
	/*
	 * The HW will be configured with external loopback such that
	 * host data is sent on the trasmitter and based on the external
	 * loopback connection the data will be received without modification.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_EXTERNAL UINT32_C(0x3)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_LPBK_EXTERNAL
	/*
	 * Current setting of forced pause.
	 * When the pause configuration is not being forced, then
	 * this value shall be set to 0.
	 */
	uint8_t	force_pause;
	/*
	 * When this bit is '1', Generation of tx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_PAUSE_TX     UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FORCE_PAUSE_RX     UINT32_C(0x2)
	/*
	 * This value indicates the current status of the optics module on
	 * this port.
	 */
	uint8_t	module_status;
	/* Module is inserted and accepted */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NONE \
		UINT32_C(0x0)
	/* Module is rejected and transmit side Laser is disabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_DISABLETX \
		UINT32_C(0x1)
	/* Module mismatch warning. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_WARNINGMSG \
		UINT32_C(0x2)
	/* Module is rejected and powered down. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_PWRDOWN \
		UINT32_C(0x3)
	/* Module is not inserted. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NOTINSERTED \
		UINT32_C(0x4)
	/* Module status is not applicable. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NOTAPPLICABLE \
		UINT32_C(0xff)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_MODULE_STATUS_NOTAPPLICABLE
	/* Current setting for preemphasis. */
	uint32_t	preemphasis;
	/* This field represents the major version of the PHY. */
	uint8_t	phy_maj;
	/* This field represents the minor version of the PHY. */
	uint8_t	phy_min;
	/* This field represents the build version of the PHY. */
	uint8_t	phy_bld;
	/* This value represents a PHY type. */
	uint8_t	phy_type;
	/* Unknown */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_UNKNOWN \
		UINT32_C(0x0)
	/* BASE-CR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASECR \
		UINT32_C(0x1)
	/* BASE-KR4 (Deprecated) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKR4 \
		UINT32_C(0x2)
	/* BASE-LR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASELR \
		UINT32_C(0x3)
	/* BASE-SR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASESR \
		UINT32_C(0x4)
	/* BASE-KR2 (Deprecated) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKR2 \
		UINT32_C(0x5)
	/* BASE-KX */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKX \
		UINT32_C(0x6)
	/* BASE-KR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASEKR \
		UINT32_C(0x7)
	/* BASE-T */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASET \
		UINT32_C(0x8)
	/* EEE capable BASE-T */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_BASETE \
		UINT32_C(0x9)
	/* SGMII connected external PHY */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_SGMIIEXTPHY \
		UINT32_C(0xa)
	/* 25G_BASECR_CA_L */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASECR_CA_L \
		UINT32_C(0xb)
	/* 25G_BASECR_CA_S */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASECR_CA_S \
		UINT32_C(0xc)
	/* 25G_BASECR_CA_N */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASECR_CA_N \
		UINT32_C(0xd)
	/* 25G_BASESR */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_25G_BASESR \
		UINT32_C(0xe)
	/* 100G_BASECR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASECR4 \
		UINT32_C(0xf)
	/* 100G_BASESR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASESR4 \
		UINT32_C(0x10)
	/* 100G_BASELR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASELR4 \
		UINT32_C(0x11)
	/* 100G_BASEER4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASEER4 \
		UINT32_C(0x12)
	/* 100G_BASESR10 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_100G_BASESR10 \
		UINT32_C(0x13)
	/* 40G_BASECR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASECR4 \
		UINT32_C(0x14)
	/* 40G_BASESR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASESR4 \
		UINT32_C(0x15)
	/* 40G_BASELR4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASELR4 \
		UINT32_C(0x16)
	/* 40G_BASEER4 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_BASEER4 \
		UINT32_C(0x17)
	/* 40G_ACTIVE_CABLE */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_40G_ACTIVE_CABLE \
		UINT32_C(0x18)
	/* 1G_baseT */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASET \
		UINT32_C(0x19)
	/* 1G_baseSX */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASESX \
		UINT32_C(0x1a)
	/* 1G_baseCX */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASECX \
		UINT32_C(0x1b)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_PHY_TYPE_1G_BASECX
	/* This value represents a media type. */
	uint8_t	media_type;
	/* Unknown */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_UNKNOWN UINT32_C(0x0)
	/* Twisted Pair */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_TP      UINT32_C(0x1)
	/* Direct Attached Copper */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_DAC     UINT32_C(0x2)
	/* Fiber */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_FIBRE   UINT32_C(0x3)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_MEDIA_TYPE_FIBRE
	/* This value represents a transceiver type. */
	uint8_t	xcvr_pkg_type;
	/* PHY and MAC are in the same package */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_PKG_TYPE_XCVR_INTERNAL \
		UINT32_C(0x1)
	/* PHY and MAC are in different packages */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_PKG_TYPE_XCVR_EXTERNAL \
		UINT32_C(0x2)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_PKG_TYPE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_PKG_TYPE_XCVR_EXTERNAL
	uint8_t	eee_config_phy_addr;
	/* This field represents PHY address. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_ADDR_MASK \
		UINT32_C(0x1f)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PHY_ADDR_SFT               0
	/*
	 * This field represents flags related to EEE configuration.
	 * These EEE configuration flags are valid only when the
	 * auto_mode is not set to none (in other words autonegotiation
	 * is enabled).
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_MASK \
		UINT32_C(0xe0)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_SFT             5
	/*
	 * When set to 1, Energy Efficient Ethernet (EEE) mode is enabled.
	 * Speeds for autoneg with EEE mode enabled
	 * are based on eee_link_speed_mask.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_EEE_ENABLED \
		UINT32_C(0x20)
	/*
	 * This flag is valid only when eee_enabled is set to 1.
	 *
	 * # If eee_enabled is set to 0, then EEE mode is disabled
	 * and this flag shall be ignored.
	 * # If eee_enabled is set to 1 and this flag is set to 1,
	 * then Energy Efficient Ethernet (EEE) mode is enabled
	 * and in use.
	 * # If eee_enabled is set to 1 and this flag is set to 0,
	 * then Energy Efficient Ethernet (EEE) mode is enabled
	 * but is currently not in use.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_EEE_ACTIVE \
		UINT32_C(0x40)
	/*
	 * This flag is valid only when eee_enabled is set to 1.
	 *
	 * # If eee_enabled is set to 0, then EEE mode is disabled
	 * and this flag shall be ignored.
	 * # If eee_enabled is set to 1 and this flag is set to 1,
	 * then Energy Efficient Ethernet (EEE) mode is enabled
	 * and TX LPI is enabled.
	 * # If eee_enabled is set to 1 and this flag is set to 0,
	 * then Energy Efficient Ethernet (EEE) mode is enabled
	 * but TX LPI is disabled.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_EEE_CONFIG_EEE_TX_LPI \
		UINT32_C(0x80)
	/*
	 * When set to 1, the parallel detection is used to determine
	 * the speed of the link partner.
	 *
	 * Parallel detection is used when a autonegotiation capable
	 * device is connected to a link parter that is not capable
	 * of autonegotiation.
	 */
	uint8_t	parallel_detect;
	/*
	 * When set to 1, the parallel detection is used to determine
	 * the speed of the link partner.
	 *
	 * Parallel detection is used when a autonegotiation capable
	 * device is connected to a link parter that is not capable
	 * of autonegotiation.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_PARALLEL_DETECT     UINT32_C(0x1)
	/*
	 * The advertised speeds for the port by the link partner.
	 * Each advertised speed will be set to '1'.
	 */
	uint16_t	link_partner_adv_speeds;
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_100MBHD \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_100MB \
		UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_1GBHD \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_1GB \
		UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_2GB \
		UINT32_C(0x10)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_2_5GB \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_10GB \
		UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_20GB \
		UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_25GB \
		UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_40GB \
		UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_50GB \
		UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_100GB \
		UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_10MBHD \
		UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_SPEEDS_10MB \
		UINT32_C(0x2000)
	/*
	 * The advertised autoneg for the port by the link partner.
	 * This field is deprecated and should be set to 0.
	 */
	uint8_t	link_partner_adv_auto_mode;
	/* Disable autoneg or autoneg disabled. No speeds are selected. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_NONE \
		UINT32_C(0x0)
	/* Select all possible speeds for autoneg mode. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_ALL_SPEEDS \
		UINT32_C(0x1)
	/*
	 * Select only the auto_link_speed speed for autoneg mode. This mode has
	 * been DEPRECATED. An HWRM client should not use this mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_ONE_SPEED \
		UINT32_C(0x2)
	/*
	 * Select the auto_link_speed or any speed below that speed for autoneg.
	 * This mode has been DEPRECATED. An HWRM client should not use this mode.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_ONE_OR_BELOW \
		UINT32_C(0x3)
	/*
	 * Select the speeds based on the corresponding link speed mask value
	 * that is provided.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_SPEED_MASK \
		UINT32_C(0x4)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_AUTO_MODE_SPEED_MASK
	/* The advertised pause settings on the port by the link partner. */
	uint8_t	link_partner_adv_pause;
	/*
	 * When this bit is '1', Generation of tx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_PAUSE_TX \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', Reception of rx pause messages
	 * is supported. Disabled otherwise.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_PAUSE_RX \
		UINT32_C(0x2)
	/*
	 * Current setting for link speed mask that is used to
	 * advertise speeds during autonegotiation when EEE is enabled.
	 * This field is valid only when eee_enabled flags is set to 1.
	 * The speeds specified in this field shall be a subset of
	 * speeds specified in auto_link_speed_mask.
	 */
	uint16_t	adv_eee_link_speed_mask;
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD1 \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_100MB \
		UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD2 \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_1GB \
		UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD3 \
		UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_RSVD4 \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_ADV_EEE_LINK_SPEED_MASK_10GB \
		UINT32_C(0x40)
	/*
	 * Current setting for link speed mask that is advertised by
	 * the link partner when EEE is enabled.
	 * This field is valid only when eee_enabled flags is set to 1.
	 */
	uint16_t	link_partner_adv_eee_link_speed_mask;
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD1 \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_100MB \
		UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD2 \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_1GB \
		UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD3 \
		UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_RSVD4 \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_LINK_PARTNER_ADV_EEE_LINK_SPEED_MASK_10GB \
		UINT32_C(0x40)
	uint32_t	xcvr_identifier_type_tx_lpi_timer;
	/*
	 * Current setting of TX LPI timer in microseconds.
	 * This field is valid only when_eee_enabled flag is set to 1
	 * and tx_lpi_enabled is set to 1.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_TX_LPI_TIMER_MASK \
		UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_TX_LPI_TIMER_SFT             0
	/* This value represents transceiver identifier type. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_MASK \
		UINT32_C(0xff000000)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_SFT     24
	/* Unknown */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_UNKNOWN \
		(UINT32_C(0x0) << 24)
	/* SFP/SFP+/SFP28 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_SFP \
		(UINT32_C(0x3) << 24)
	/* QSFP+ */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFP \
		(UINT32_C(0xc) << 24)
	/* QSFP+ */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFPPLUS \
		(UINT32_C(0xd) << 24)
	/* QSFP28 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFP28 \
		(UINT32_C(0x11) << 24)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_XCVR_IDENTIFIER_TYPE_QSFP28
	/*
	 * This value represents the current configuration of
	 * Forward Error Correction (FEC) on the port.
	 */
	uint16_t	fec_cfg;
	/*
	 * When set to 1, then FEC is not supported on this port. If this flag
	 * is set to 1, then all other FEC configuration flags shall be ignored.
	 * When set to 0, then FEC is supported as indicated by other
	 * configuration flags.
	 * If no cable is attached and the HWRM does not yet know the FEC
	 * capability, then the HWRM shall set this flag to 1 when reporting
	 * FEC capability.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_NONE_SUPPORTED \
		UINT32_C(0x1)
	/*
	 * When set to 1, then FEC autonegotiation is supported on this port.
	 * When set to 0, then FEC autonegotiation is not supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_AUTONEG_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * When set to 1, then FEC autonegotiation is enabled on this port.
	 * When set to 0, then FEC autonegotiation is disabled if supported.
	 * This flag should be ignored if FEC autonegotiation is not supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_AUTONEG_ENABLED \
		UINT32_C(0x4)
	/*
	 * When set to 1, then FEC CLAUSE 74 (Fire Code) is supported on this port.
	 * When set to 0, then FEC CLAUSE 74 (Fire Code) is not supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE74_SUPPORTED \
		UINT32_C(0x8)
	/*
	 * When set to 1, then FEC CLAUSE 74 (Fire Code) is enabled on this port.
	 * When set to 0, then FEC CLAUSE 74 (Fire Code) is disabled if supported.
	 * This flag should be ignored if FEC CLAUSE 74 is not supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE74_ENABLED \
		UINT32_C(0x10)
	/*
	 * When set to 1, then FEC CLAUSE 91 (Reed Solomon) is supported on this port.
	 * When set to 0, then FEC CLAUSE 91 (Reed Solomon) is not supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE91_SUPPORTED \
		UINT32_C(0x20)
	/*
	 * When set to 1, then FEC CLAUSE 91 (Reed Solomon) is enabled on this port.
	 * When set to 0, then FEC CLAUSE 91 (Reed Solomon) is disabled if supported.
	 * This flag should be ignored if FEC CLAUSE 91 is not supported on this port.
	 */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_FEC_CFG_FEC_CLAUSE91_ENABLED \
		UINT32_C(0x40)
	/*
	 * This value is indicates the duplex of the current
	 * connection state.
	 */
	uint8_t	duplex_state;
	/* Half Duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_STATE_HALF UINT32_C(0x0)
	/* Full duplex connection. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_STATE_FULL UINT32_C(0x1)
	#define HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_STATE_LAST \
		HWRM_PORT_PHY_QCFG_OUTPUT_DUPLEX_STATE_FULL
	/* Option flags fields. */
	uint8_t	option_flags;
	/* When this bit is '1', Media auto detect is enabled. */
	#define HWRM_PORT_PHY_QCFG_OUTPUT_OPTION_FLAGS_MEDIA_AUTO_DETECT \
		UINT32_C(0x1)
	/*
	 * Up to 16 bytes of null padded ASCII string representing
	 * PHY vendor.
	 * If the string is set to null, then the vendor name is not
	 * available.
	 */
	char	phy_vendor_name[16];
	/*
	 * Up to 16 bytes of null padded ASCII string that
	 * identifies vendor specific part number of the PHY.
	 * If the string is set to null, then the vendor specific
	 * part number is not available.
	 */
	char	phy_vendor_partnumber[16];
	uint8_t	unused_2[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_port_mac_cfg *
 *********************/


/* hwrm_port_mac_cfg_input (size:320b/40B) */
struct hwrm_port_mac_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * In this field, there are a number of CoS mappings related flags
	 * that are used to configure CoS mappings and their corresponding
	 * priorities in the hardware.
	 * For the priorities of CoS mappings, the HWRM uses the following
	 * priority order (high to low) by default:
	 * # vlan pri
	 * # ip_dscp
	 * # tunnel_vlan_pri
	 * # default cos
	 *
	 * A subset of CoS mappings can be enabled.
	 * If a priority is not specified for an enabled CoS mapping, the
	 * priority will be assigned in the above order for the enabled CoS
	 * mappings. For example, if vlan_pri and ip_dscp CoS mappings are
	 * enabled and their priorities are not specified, the following
	 * priority order (high to low) will be used by the HWRM:
	 * # vlan_pri
	 * # ip_dscp
	 * # default cos
	 *
	 * vlan_pri CoS mapping together with default CoS with lower priority
	 * are enabled by default by the HWRM.
	 */
	uint32_t	flags;
	/*
	 * When this bit is '1', this command will configure
	 * the MAC to match the current link state of the PHY.
	 * If the link is not established on the PHY, then this
	 * bit has no effect.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_MATCH_LINK \
		UINT32_C(0x1)
	/*
	 * When this bit is set to '1', the inner VLAN PRI to CoS mapping
	 * is requested to be enabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_VLAN_PRI2COS_ENABLE \
		UINT32_C(0x2)
	/*
	 * When this bit is set to '1', tunnel VLAN PRI field to
	 * CoS mapping is requested to be enabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_TUNNEL_PRI2COS_ENABLE \
		UINT32_C(0x4)
	/*
	 * When this bit is set to '1', the IP DSCP to CoS mapping is
	 * requested to be enabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_IP_DSCP2COS_ENABLE \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', the HWRM is requested to
	 * enable timestamp capture capability on the receive side
	 * of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_RX_TS_CAPTURE_ENABLE \
		UINT32_C(0x10)
	/*
	 * When this bit is '1', the HWRM is requested to
	 * disable timestamp capture capability on the receive side
	 * of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_RX_TS_CAPTURE_DISABLE \
		UINT32_C(0x20)
	/*
	 * When this bit is '1', the HWRM is requested to
	 * enable timestamp capture capability on the transmit side
	 * of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_TX_TS_CAPTURE_ENABLE \
		UINT32_C(0x40)
	/*
	 * When this bit is '1', the HWRM is requested to
	 * disable timestamp capture capability on the transmit side
	 * of this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_PTP_TX_TS_CAPTURE_DISABLE \
		UINT32_C(0x80)
	/*
	 * When this bit is '1', the Out-Of-Box WoL is requested to
	 * be enabled on this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_OOB_WOL_ENABLE \
		UINT32_C(0x100)
	/*
	 * When this bit is '1', the the Out-Of-Box WoL is requested to
	 * be disabled on this port.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_OOB_WOL_DISABLE \
		UINT32_C(0x200)
	/*
	 * When this bit is set to '1', the inner VLAN PRI to CoS mapping
	 * is requested to be disabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_VLAN_PRI2COS_DISABLE \
		UINT32_C(0x400)
	/*
	 * When this bit is set to '1', tunnel VLAN PRI field to
	 * CoS mapping is requested to be disabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_TUNNEL_PRI2COS_DISABLE \
		UINT32_C(0x800)
	/*
	 * When this bit is set to '1', the IP DSCP to CoS mapping is
	 * requested to be disabled.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_FLAGS_IP_DSCP2COS_DISABLE \
		UINT32_C(0x1000)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the ipg field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_IPG \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the lpbk field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_LPBK \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the vlan_pri2cos_map_pri field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_VLAN_PRI2COS_MAP_PRI \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the tunnel_pri2cos_map_pri field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_TUNNEL_PRI2COS_MAP_PRI \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the dscp2cos_map_pri field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_DSCP2COS_MAP_PRI \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the rx_ts_capture_ptp_msg_type field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_RX_TS_CAPTURE_PTP_MSG_TYPE \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tx_ts_capture_ptp_msg_type field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_TX_TS_CAPTURE_PTP_MSG_TYPE \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the cos_field_cfg field to be
	 * configured.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_ENABLES_COS_FIELD_CFG \
		UINT32_C(0x100)
	/* Port ID of port that is to be configured. */
	uint16_t	port_id;
	/*
	 * This value is used to configure the minimum IPG that will
	 * be sent between packets by this port.
	 */
	uint8_t	ipg;
	/* This value controls the loopback setting for the MAC. */
	uint8_t	lpbk;
	/* No loopback is selected.  Normal operation. */
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_NONE   UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that
	 * host data is sent back to the host without modification.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_LOCAL  UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that
	 * port logic will send packets back out the transmitter that
	 * are received.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_REMOTE UINT32_C(0x2)
	#define HWRM_PORT_MAC_CFG_INPUT_LPBK_LAST \
		HWRM_PORT_MAC_CFG_INPUT_LPBK_REMOTE
	/*
	 * This value controls the priority setting of VLAN PRI to CoS
	 * mapping based on VLAN Tags of inner packet headers of
	 * tunneled packets or packet headers of non-tunneled packets.
	 *
	 * # Each XXX_pri variable shall have a unique priority value
	 * when it is being specified.
	 * # When comparing priorities of mappings, higher value
	 * indicates higher priority.
	 * For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 */
	uint8_t	vlan_pri2cos_map_pri;
	/* Reserved field. */
	uint8_t	reserved1;
	/*
	 * This value controls the priority setting of VLAN PRI to CoS
	 * mapping based on VLAN Tags of tunneled header.
	 * This mapping only applies when tunneled headers
	 * are present.
	 *
	 * # Each XXX_pri variable shall have a unique priority value
	 * when it is being specified.
	 * # When comparing priorities of mappings, higher value
	 * indicates higher priority.
	 * For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 */
	uint8_t	tunnel_pri2cos_map_pri;
	/*
	 * This value controls the priority setting of IP DSCP to CoS
	 * mapping based on inner IP header of tunneled packets or
	 * IP header of non-tunneled packets.
	 *
	 * # Each XXX_pri variable shall have a unique priority value
	 * when it is being specified.
	 * # When comparing priorities of mappings, higher value
	 * indicates higher priority.
	 * For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 */
	uint8_t	dscp2pri_map_pri;
	/*
	 * This is a 16-bit bit mask that is used to request a
	 * specific configuration of time stamp capture of PTP messages
	 * on the receive side of this port.
	 * This field shall be ignored if the ptp_rx_ts_capture_enable
	 * flag is not set in this command.
	 * Otherwise, if bit 'i' is set, then the HWRM is being
	 * requested to configure the receive side of the port to
	 * capture the time stamp of every received PTP message
	 * with messageType field value set to i.
	 */
	uint16_t	rx_ts_capture_ptp_msg_type;
	/*
	 * This is a 16-bit bit mask that is used to request a
	 * specific configuration of time stamp capture of PTP messages
	 * on the transmit side of this port.
	 * This field shall be ignored if the ptp_tx_ts_capture_enable
	 * flag is not set in this command.
	 * Otherwise, if bit 'i' is set, then the HWRM is being
	 * requested to configure the transmit sied of the port to
	 * capture the time stamp of every transmitted PTP message
	 * with messageType field value set to i.
	 */
	uint16_t	tx_ts_capture_ptp_msg_type;
	/* Configuration of CoS fields. */
	uint8_t	cos_field_cfg;
	/* Reserved */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_RSVD1 \
		UINT32_C(0x1)
	/*
	 * This field is used to specify selection of VLAN PRI value
	 * based on whether one or two VLAN Tags are present in
	 * the inner packet headers of tunneled packets or
	 * non-tunneled packets.
	 * This field is valid only if inner VLAN PRI to CoS mapping
	 * is enabled.
	 * If VLAN PRI to CoS mapping is not enabled, then this
	 * field shall be ignored.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_MASK \
		UINT32_C(0x6)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_SFT \
		1
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are
	 * present in the inner packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_INNERMOST \
		(UINT32_C(0x0) << 1)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are
	 * present in the inner packet headers.
	 * No VLAN PRI shall be selected for this configuration
	 * if only one VLAN Tag is present in the inner
	 * packet headers.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTER \
		(UINT32_C(0x1) << 1)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags
	 * are present in the inner packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTERMOST \
		(UINT32_C(0x2) << 1)
	/* Unspecified */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED \
		(UINT32_C(0x3) << 1)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_LAST \
		HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field is used to specify selection of tunnel VLAN
	 * PRI value based on whether one or two VLAN Tags are
	 * present in tunnel headers.
	 * This field is valid only if tunnel VLAN PRI to CoS mapping
	 * is enabled.
	 * If tunnel VLAN PRI to CoS mapping is not enabled, then this
	 * field shall be ignored.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_MASK \
		UINT32_C(0x18)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_SFT \
		3
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are
	 * present in the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_INNERMOST \
		(UINT32_C(0x0) << 3)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are
	 * present in the tunnel packet headers.
	 * No tunnel VLAN PRI shall be selected for this
	 * configuration if only one VLAN Tag is present in
	 * the tunnel packet headers.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTER \
		(UINT32_C(0x1) << 3)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags
	 * are present in the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTERMOST \
		(UINT32_C(0x2) << 3)
	/* Unspecified */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED \
		(UINT32_C(0x3) << 3)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_LAST \
		HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field shall be used to provide default CoS value
	 * that has been configured on this port.
	 * This field is valid only if default CoS mapping
	 * is enabled.
	 * If default CoS mapping is not enabled, then this
	 * field shall be ignored.
	 */
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_DEFAULT_COS_MASK \
		UINT32_C(0xe0)
	#define HWRM_PORT_MAC_CFG_INPUT_COS_FIELD_CFG_DEFAULT_COS_SFT \
		5
	uint8_t	unused_0[3];
} __attribute__((packed));

/* hwrm_port_mac_cfg_output (size:128b/16B) */
struct hwrm_port_mac_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This is the configured maximum length of Ethernet packet
	 * payload that is allowed to be received on the port.
	 * This value does not include the number of bytes used by
	 * Ethernet header and trailer (CRC).
	 */
	uint16_t	mru;
	/*
	 * This is the configured maximum length of Ethernet packet
	 * payload that is allowed to be transmitted on the port.
	 * This value does not include the number of bytes used by
	 * Ethernet header and trailer (CRC).
	 */
	uint16_t	mtu;
	/* Current configuration of the IPG value. */
	uint8_t	ipg;
	/* Current value of the loopback value. */
	uint8_t	lpbk;
	/* No loopback is selected.  Normal operation. */
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_NONE   UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that
	 * host data is sent back to the host without modification.
	 */
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_LOCAL  UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that
	 * port logic will send packets back out the transmitter that
	 * are received.
	 */
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_REMOTE UINT32_C(0x2)
	#define HWRM_PORT_MAC_CFG_OUTPUT_LPBK_LAST \
		HWRM_PORT_MAC_CFG_OUTPUT_LPBK_REMOTE
	uint8_t	unused_0;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_port_mac_qcfg *
 **********************/


/* hwrm_port_mac_qcfg_input (size:192b/24B) */
struct hwrm_port_mac_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is to be configured. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_mac_qcfg_output (size:192b/24B) */
struct hwrm_port_mac_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This is the configured maximum length of Ethernet packet
	 * payload that is allowed to be received on the port.
	 * This value does not include the number of bytes used by the
	 * Ethernet header and trailer (CRC).
	 */
	uint16_t	mru;
	/*
	 * This is the configured maximum length of Ethernet packet
	 * payload that is allowed to be transmitted on the port.
	 * This value does not include the number of bytes used by the
	 * Ethernet header and trailer (CRC).
	 */
	uint16_t	mtu;
	/*
	 * The minimum IPG that will
	 * be sent between packets by this port.
	 */
	uint8_t	ipg;
	/* The loopback setting for the MAC. */
	uint8_t	lpbk;
	/* No loopback is selected.  Normal operation. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_NONE   UINT32_C(0x0)
	/*
	 * The HW will be configured with local loopback such that
	 * host data is sent back to the host without modification.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_LOCAL  UINT32_C(0x1)
	/*
	 * The HW will be configured with remote loopback such that
	 * port logic will send packets back out the transmitter that
	 * are received.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_REMOTE UINT32_C(0x2)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_LAST \
		HWRM_PORT_MAC_QCFG_OUTPUT_LPBK_REMOTE
	/*
	 * Priority setting for VLAN PRI to CoS mapping.
	 * # Each XXX_pri variable shall have a unique priority value
	 * when it is being used.
	 * # When comparing priorities of mappings, higher value
	 * indicates higher priority.
	 * For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 * # If the correspoding CoS mapping is not enabled, then this
	 * field should be ignored.
	 * # This value indicates the normalized priority value retained
	 * in the HWRM.
	 */
	uint8_t	vlan_pri2cos_map_pri;
	/*
	 * In this field, a number of CoS mappings related flags
	 * are used to indicate configured CoS mappings.
	 */
	uint8_t	flags;
	/*
	 * When this bit is set to '1', the inner VLAN PRI to CoS mapping
	 * is enabled.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_VLAN_PRI2COS_ENABLE \
		UINT32_C(0x1)
	/*
	 * When this bit is set to '1', tunnel VLAN PRI field to
	 * CoS mapping is enabled.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_TUNNEL_PRI2COS_ENABLE \
		UINT32_C(0x2)
	/*
	 * When this bit is set to '1', the IP DSCP to CoS mapping is
	 * enabled.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_IP_DSCP2COS_ENABLE \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the Out-Of-Box WoL is enabled on this
	 * port.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_OOB_WOL_ENABLE \
		UINT32_C(0x8)
	/* When this bit is '1', PTP is enabled for RX on this port. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_PTP_RX_TS_CAPTURE_ENABLE \
		UINT32_C(0x10)
	/* When this bit is '1', PTP is enabled for TX on this port. */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_FLAGS_PTP_TX_TS_CAPTURE_ENABLE \
		UINT32_C(0x20)
	/*
	 * Priority setting for tunnel VLAN PRI to CoS mapping.
	 * # Each XXX_pri variable shall have a unique priority value
	 * when it is being used.
	 * # When comparing priorities of mappings, higher value
	 * indicates higher priority.
	 * For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 * # If the correspoding CoS mapping is not enabled, then this
	 * field should be ignored.
	 * # This value indicates the normalized priority value retained
	 * in the HWRM.
	 */
	uint8_t	tunnel_pri2cos_map_pri;
	/*
	 * Priority setting for DSCP to PRI mapping.
	 * # Each XXX_pri variable shall have a unique priority value
	 * when it is being used.
	 * # When comparing priorities of mappings, higher value
	 * indicates higher priority.
	 * For example, a value of 0-3 is returned where 0 is being
	 * the lowest priority and 3 is being the highest priority.
	 * # If the correspoding CoS mapping is not enabled, then this
	 * field should be ignored.
	 * # This value indicates the normalized priority value retained
	 * in the HWRM.
	 */
	uint8_t	dscp2pri_map_pri;
	/*
	 * This is a 16-bit bit mask that represents the
	 * current configuration of time stamp capture of PTP messages
	 * on the receive side of this port.
	 * If bit 'i' is set, then the receive side of the port
	 * is configured to capture the time stamp of every
	 * received PTP message with messageType field value set
	 * to i.
	 * If all bits are set to 0 (i.e. field value set 0),
	 * then the receive side of the port is not configured
	 * to capture timestamp for PTP messages.
	 * If all bits are set to 1, then the receive side of the
	 * port is configured to capture timestamp for all PTP
	 * messages.
	 */
	uint16_t	rx_ts_capture_ptp_msg_type;
	/*
	 * This is a 16-bit bit mask that represents the
	 * current configuration of time stamp capture of PTP messages
	 * on the transmit side of this port.
	 * If bit 'i' is set, then the transmit side of the port
	 * is configured to capture the time stamp of every
	 * received PTP message with messageType field value set
	 * to i.
	 * If all bits are set to 0 (i.e. field value set 0),
	 * then the transmit side of the port is not configured
	 * to capture timestamp for PTP messages.
	 * If all bits are set to 1, then the transmit side of the
	 * port is configured to capture timestamp for all PTP
	 * messages.
	 */
	uint16_t	tx_ts_capture_ptp_msg_type;
	/* Configuration of CoS fields. */
	uint8_t	cos_field_cfg;
	/* Reserved */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_RSVD \
		UINT32_C(0x1)
	/*
	 * This field is used for selecting VLAN PRI value
	 * based on whether one or two VLAN Tags are present in
	 * the inner packet headers of tunneled packets or
	 * non-tunneled packets.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_MASK \
		UINT32_C(0x6)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_SFT \
		1
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are
	 * present in the inner packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_INNERMOST \
		(UINT32_C(0x0) << 1)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are
	 * present in the inner packet headers.
	 * No VLAN PRI is selected for this configuration
	 * if only one VLAN Tag is present in the inner
	 * packet headers.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTER \
		(UINT32_C(0x1) << 1)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags
	 * are present in the inner packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_OUTERMOST \
		(UINT32_C(0x2) << 1)
	/* Unspecified */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED \
		(UINT32_C(0x3) << 1)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_LAST \
		HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field is used for selecting tunnel VLAN PRI value
	 * based on whether one or two VLAN Tags are present in
	 * the tunnel headers of tunneled packets. This selection
	 * does not apply to non-tunneled packets.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_MASK \
		UINT32_C(0x18)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_SFT \
		3
	/*
	 * Select inner VLAN PRI when 1 or 2 VLAN Tags are
	 * present in the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_INNERMOST \
		(UINT32_C(0x0) << 3)
	/*
	 * Select outer VLAN Tag PRI when 2 VLAN Tags are
	 * present in the tunnel packet headers.
	 * No VLAN PRI is selected for this configuration
	 * if only one VLAN Tag is present in the tunnel
	 * packet headers.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTER \
		(UINT32_C(0x1) << 3)
	/*
	 * Select outermost VLAN PRI when 1 or 2 VLAN Tags
	 * are present in the tunnel packet headers
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_OUTERMOST \
		(UINT32_C(0x2) << 3)
	/* Unspecified */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED \
		(UINT32_C(0x3) << 3)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_LAST \
		HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_T_VLAN_PRI_SEL_UNSPECIFIED
	/*
	 * This field is used to provide default CoS value that
	 * has been configured on this port.
	 */
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_DEFAULT_COS_MASK \
		UINT32_C(0xe0)
	#define HWRM_PORT_MAC_QCFG_OUTPUT_COS_FIELD_CFG_DEFAULT_COS_SFT \
		5
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_port_mac_ptp_qcfg *
 **************************/


/* hwrm_port_mac_ptp_qcfg_input (size:192b/24B) */
struct hwrm_port_mac_ptp_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_mac_ptp_qcfg_output (size:640b/80B) */
struct hwrm_port_mac_ptp_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * In this field, a number of PTP related flags
	 * are used to indicate configured PTP capabilities.
	 */
	uint8_t	flags;
	/*
	 * When this bit is set to '1', the PTP related registers are
	 * directly accessible by the host.
	 */
	#define HWRM_PORT_MAC_PTP_QCFG_OUTPUT_FLAGS_DIRECT_ACCESS \
		UINT32_C(0x1)
	/*
	 * When this bit is set to '1', the PTP information is accessible
	 * via HWRM commands.
	 */
	#define HWRM_PORT_MAC_PTP_QCFG_OUTPUT_FLAGS_HWRM_ACCESS \
		UINT32_C(0x2)
	uint8_t	unused_0[3];
	/* Offset of the PTP register for the lower 32 bits of timestamp for RX. */
	uint32_t	rx_ts_reg_off_lower;
	/* Offset of the PTP register for the upper 32 bits of timestamp for RX. */
	uint32_t	rx_ts_reg_off_upper;
	/* Offset of the PTP register for the sequence ID for RX. */
	uint32_t	rx_ts_reg_off_seq_id;
	/* Offset of the first PTP source ID for RX. */
	uint32_t	rx_ts_reg_off_src_id_0;
	/* Offset of the second PTP source ID for RX. */
	uint32_t	rx_ts_reg_off_src_id_1;
	/* Offset of the third PTP source ID for RX. */
	uint32_t	rx_ts_reg_off_src_id_2;
	/* Offset of the domain ID for RX. */
	uint32_t	rx_ts_reg_off_domain_id;
	/* Offset of the PTP FIFO register for RX. */
	uint32_t	rx_ts_reg_off_fifo;
	/* Offset of the PTP advance FIFO register for RX. */
	uint32_t	rx_ts_reg_off_fifo_adv;
	/* PTP timestamp granularity for RX. */
	uint32_t	rx_ts_reg_off_granularity;
	/* Offset of the PTP register for the lower 32 bits of timestamp for TX. */
	uint32_t	tx_ts_reg_off_lower;
	/* Offset of the PTP register for the upper 32 bits of timestamp for TX. */
	uint32_t	tx_ts_reg_off_upper;
	/* Offset of the PTP register for the sequence ID for TX. */
	uint32_t	tx_ts_reg_off_seq_id;
	/* Offset of the PTP FIFO register for TX. */
	uint32_t	tx_ts_reg_off_fifo;
	/* PTP timestamp granularity for TX. */
	uint32_t	tx_ts_reg_off_granularity;
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_port_qstats *
 ********************/


/* hwrm_port_qstats_input (size:320b/40B) */
struct hwrm_port_qstats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
	/*
	 * This is the host address where
	 * Tx port statistics will be stored
	 */
	uint64_t	tx_stat_host_addr;
	/*
	 * This is the host address where
	 * Rx port statistics will be stored
	 */
	uint64_t	rx_stat_host_addr;
} __attribute__((packed));

/* hwrm_port_qstats_output (size:128b/16B) */
struct hwrm_port_qstats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The size of TX port statistics block in bytes. */
	uint16_t	tx_stat_size;
	/* The size of RX port statistics block in bytes. */
	uint16_t	rx_stat_size;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_port_qstats_ext *
 ************************/


/* hwrm_port_qstats_ext_input (size:320b/40B) */
struct hwrm_port_qstats_ext_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is being queried. */
	uint16_t	port_id;
	/*
	 * The size of TX port extended
	 * statistics block in bytes.
	 */
	uint16_t	tx_stat_size;
	/*
	 * The size of RX port extended
	 * statistics block in bytes
	 */
	uint16_t	rx_stat_size;
	uint8_t	unused_0[2];
	/*
	 * This is the host address where
	 * Tx port statistics will be stored
	 */
	uint64_t	tx_stat_host_addr;
	/*
	 * This is the host address where
	 * Rx port statistics will be stored
	 */
	uint64_t	rx_stat_host_addr;
} __attribute__((packed));

/* hwrm_port_qstats_ext_output (size:128b/16B) */
struct hwrm_port_qstats_ext_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The size of TX port statistics block in bytes. */
	uint16_t	tx_stat_size;
	/* The size of RX port statistics block in bytes. */
	uint16_t	rx_stat_size;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_port_lpbk_qstats *
 *************************/


/* hwrm_port_lpbk_qstats_input (size:128b/16B) */
struct hwrm_port_lpbk_qstats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_port_lpbk_qstats_output (size:768b/96B) */
struct hwrm_port_lpbk_qstats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of transmitted unicast frames */
	uint64_t	lpbk_ucast_frames;
	/* Number of transmitted multicast frames */
	uint64_t	lpbk_mcast_frames;
	/* Number of transmitted broadcast frames */
	uint64_t	lpbk_bcast_frames;
	/* Number of transmitted bytes for unicast traffic */
	uint64_t	lpbk_ucast_bytes;
	/* Number of transmitted bytes for multicast traffic */
	uint64_t	lpbk_mcast_bytes;
	/* Number of transmitted bytes for broadcast traffic */
	uint64_t	lpbk_bcast_bytes;
	/* Total Tx Drops for loopback traffic reported by STATS block */
	uint64_t	tx_stat_discard;
	/* Total Tx Error Drops for loopback traffic reported by STATS block */
	uint64_t	tx_stat_error;
	/* Total Rx Drops for loopback traffic reported by STATS block */
	uint64_t	rx_stat_discard;
	/* Total Rx Error Drops for loopback traffic reported by STATS block */
	uint64_t	rx_stat_error;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_port_clr_stats *
 ***********************/


/* hwrm_port_clr_stats_input (size:192b/24B) */
struct hwrm_port_clr_stats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_clr_stats_output (size:128b/16B) */
struct hwrm_port_clr_stats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_port_lpbk_clr_stats *
 ****************************/


/* hwrm_port_lpbk_clr_stats_input (size:128b/16B) */
struct hwrm_port_lpbk_clr_stats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_port_lpbk_clr_stats_output (size:128b/16B) */
struct hwrm_port_lpbk_clr_stats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_port_ts_query *
 **********************/


/* hwrm_port_ts_query_input (size:192b/24B) */
struct hwrm_port_ts_query_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_TX    UINT32_C(0x0)
	/* rx path */
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_RX    UINT32_C(0x1)
	#define HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_LAST \
		HWRM_PORT_TS_QUERY_INPUT_FLAGS_PATH_RX
	/* Port ID of port that is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_port_ts_query_output (size:192b/24B) */
struct hwrm_port_ts_query_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Timestamp value of PTP message captured. */
	uint64_t	ptp_msg_ts;
	/* Sequence ID of the PTP message captured. */
	uint16_t	ptp_msg_seqid;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_port_phy_qcaps *
 ***********************/


/* hwrm_port_phy_qcaps_input (size:192b/24B) */
struct hwrm_port_phy_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port that is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_phy_qcaps_output (size:192b/24B) */
struct hwrm_port_phy_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* PHY capability flags */
	uint8_t	flags;
	/*
	 * If set to 1, then this field indicates that the
	 * link is capable of supporting EEE.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_EEE_SUPPORTED \
		UINT32_C(0x1)
	/*
	 * If set to 1, then this field indicates that the
	 * PHY is capable of supporting external loopback.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_EXTERNAL_LPBK_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * Reserved field. The HWRM shall set this field to 0.
	 * An HWRM client shall ignore this field.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_RSVD1_MASK \
		UINT32_C(0xfc)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_FLAGS_RSVD1_SFT                   2
	/* Number of front panel ports for this device. */
	uint8_t	port_cnt;
	/* Not supported or unknown */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_UNKNOWN UINT32_C(0x0)
	/* single port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_1       UINT32_C(0x1)
	/* 2-port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_2       UINT32_C(0x2)
	/* 3-port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_3       UINT32_C(0x3)
	/* 4-port device */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_4       UINT32_C(0x4)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_LAST \
		HWRM_PORT_PHY_QCAPS_OUTPUT_PORT_CNT_4
	/*
	 * This is a bit mask to indicate what speeds are supported
	 * as forced speeds on this link.
	 * For each speed that can be forced on this link, the
	 * corresponding mask bit shall be set to '1'.
	 */
	uint16_t	supported_speeds_force_mode;
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_100MBHD \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_100MB \
		UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_1GBHD \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_1GB \
		UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_2GB \
		UINT32_C(0x10)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_2_5GB \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_10GB \
		UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_20GB \
		UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_25GB \
		UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_40GB \
		UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_50GB \
		UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_100GB \
		UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_10MBHD \
		UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_FORCE_MODE_10MB \
		UINT32_C(0x2000)
	/*
	 * This is a bit mask to indicate what speeds are supported
	 * for autonegotiation on this link.
	 * For each speed that can be autonegotiated on this link, the
	 * corresponding mask bit shall be set to '1'.
	 */
	uint16_t	supported_speeds_auto_mode;
	/* 100Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_100MBHD \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_100MB \
		UINT32_C(0x2)
	/* 1Gb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_1GBHD \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_1GB \
		UINT32_C(0x8)
	/* 2Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_2GB \
		UINT32_C(0x10)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_2_5GB \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_10GB \
		UINT32_C(0x40)
	/* 20Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_20GB \
		UINT32_C(0x80)
	/* 25Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_25GB \
		UINT32_C(0x100)
	/* 40Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_40GB \
		UINT32_C(0x200)
	/* 50Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_50GB \
		UINT32_C(0x400)
	/* 100Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_100GB \
		UINT32_C(0x800)
	/* 10Mb link speed (Half-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_10MBHD \
		UINT32_C(0x1000)
	/* 10Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_AUTO_MODE_10MB \
		UINT32_C(0x2000)
	/*
	 * This is a bit mask to indicate what speeds are supported
	 * for EEE on this link.
	 * For each speed that can be autonegotiated when EEE is enabled
	 * on this link, the corresponding mask bit shall be set to '1'.
	 * This field is only valid when the eee_suppotred is set to '1'.
	 */
	uint16_t	supported_speeds_eee_mode;
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD1 \
		UINT32_C(0x1)
	/* 100Mb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_100MB \
		UINT32_C(0x2)
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD2 \
		UINT32_C(0x4)
	/* 1Gb link speed (Full-duplex) */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_1GB \
		UINT32_C(0x8)
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD3 \
		UINT32_C(0x10)
	/* Reserved */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_RSVD4 \
		UINT32_C(0x20)
	/* 10Gb link speed */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_SUPPORTED_SPEEDS_EEE_MODE_10GB \
		UINT32_C(0x40)
	uint32_t	tx_lpi_timer_low;
	/*
	 * The lowest value of TX LPI timer that can be set on this link
	 * when EEE is enabled. This value is in microseconds.
	 * This field is valid only when_eee_supported is set to '1'.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_LOW_MASK \
		UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_LOW_SFT 0
	/*
	 * Reserved field. The HWRM shall set this field to 0.
	 * An HWRM client shall ignore this field.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_RSVD2_MASK \
		UINT32_C(0xff000000)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_RSVD2_SFT            24
	uint32_t	valid_tx_lpi_timer_high;
	/*
	 * The highest value of TX LPI timer that can be set on this link
	 * when EEE is enabled. This value is in microseconds.
	 * This field is valid only when_eee_supported is set to '1'.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_HIGH_MASK \
		UINT32_C(0xffffff)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_TX_LPI_TIMER_HIGH_SFT 0
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_VALID_MASK \
		UINT32_C(0xff000000)
	#define HWRM_PORT_PHY_QCAPS_OUTPUT_VALID_SFT             24
} __attribute__((packed));

/***************************
 * hwrm_port_phy_i2c_write *
 ***************************/


/* hwrm_port_phy_i2c_write_input (size:832b/104B) */
struct hwrm_port_phy_i2c_write_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the page_offset field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_I2C_WRITE_INPUT_ENABLES_PAGE_OFFSET \
		UINT32_C(0x1)
	/* Port ID of port. */
	uint16_t	port_id;
	/* 8-bit I2C slave address. */
	uint8_t	i2c_slave_addr;
	uint8_t	unused_0;
	/* The page number that is being accessed over I2C. */
	uint16_t	page_number;
	/* Offset within the page that is being accessed over I2C. */
	uint16_t	page_offset;
	/*
	 * Length of data to write, in bytes starting at the offset
	 * specified above. If the offset is not specified, then
	 * the data shall be written from the beginning of the page.
	 */
	uint8_t	data_length;
	uint8_t	unused_1[7];
	/* Up to 64B of data. */
	uint32_t	data[16];
} __attribute__((packed));

/* hwrm_port_phy_i2c_write_output (size:128b/16B) */
struct hwrm_port_phy_i2c_write_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_port_phy_i2c_read *
 **************************/


/* hwrm_port_phy_i2c_read_input (size:320b/40B) */
struct hwrm_port_phy_i2c_read_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the page_offset field to be
	 * configured.
	 */
	#define HWRM_PORT_PHY_I2C_READ_INPUT_ENABLES_PAGE_OFFSET \
		UINT32_C(0x1)
	/* Port ID of port. */
	uint16_t	port_id;
	/* 8-bit I2C slave address. */
	uint8_t	i2c_slave_addr;
	uint8_t	unused_0;
	/* The page number that is being accessed over I2C. */
	uint16_t	page_number;
	/* Offset within the page that is being accessed over I2C. */
	uint16_t	page_offset;
	/*
	 * Length of data to read, in bytes starting at the offset
	 * specified above. If the offset is not specified, then
	 * the data shall be read from the beginning of the page.
	 */
	uint8_t	data_length;
	uint8_t	unused_1[7];
} __attribute__((packed));

/* hwrm_port_phy_i2c_read_output (size:640b/80B) */
struct hwrm_port_phy_i2c_read_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Up to 64B of data. */
	uint32_t	data[16];
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_port_led_cfg *
 *********************/


/* hwrm_port_led_cfg_input (size:512b/64B) */
struct hwrm_port_led_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the led0_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the led0_state field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_STATE \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the led0_color field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_COLOR \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the led0_blink_on field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_BLINK_ON \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the led0_blink_off field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_BLINK_OFF \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the led0_group_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED0_GROUP_ID \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the led1_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_ID \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the led1_state field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_STATE \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the led1_color field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_COLOR \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the led1_blink_on field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_BLINK_ON \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the led1_blink_off field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_BLINK_OFF \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the led1_group_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED1_GROUP_ID \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the led2_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_ID \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the led2_state field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_STATE \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the led2_color field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_COLOR \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the led2_blink_on field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_BLINK_ON \
		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the led2_blink_off field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_BLINK_OFF \
		UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the led2_group_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED2_GROUP_ID \
		UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the led3_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_ID \
		UINT32_C(0x40000)
	/*
	 * This bit must be '1' for the led3_state field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_STATE \
		UINT32_C(0x80000)
	/*
	 * This bit must be '1' for the led3_color field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_COLOR \
		UINT32_C(0x100000)
	/*
	 * This bit must be '1' for the led3_blink_on field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_BLINK_ON \
		UINT32_C(0x200000)
	/*
	 * This bit must be '1' for the led3_blink_off field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_BLINK_OFF \
		UINT32_C(0x400000)
	/*
	 * This bit must be '1' for the led3_group_id field to be
	 * configured.
	 */
	#define HWRM_PORT_LED_CFG_INPUT_ENABLES_LED3_GROUP_ID \
		UINT32_C(0x800000)
	/* Port ID of port whose LEDs are configured. */
	uint16_t	port_id;
	/*
	 * The number of LEDs that are being configured.
	 * Up to 4 LEDs can be configured with this command.
	 */
	uint8_t	num_leds;
	/* Reserved field. */
	uint8_t	rsvd;
	/* An identifier for the LED #0. */
	uint8_t	led0_id;
	/* The requested state of the LED #0. */
	uint8_t	led0_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_CFG_INPUT_LED0_STATE_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED0_STATE_BLINKALT
	/* The requested color of LED #0. */
	uint8_t	led0_color;
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED0_COLOR_GREENAMBER
	uint8_t	unused_0;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led0_blink_on;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led0_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #0 belongs
	 * to.
	 * If set to 0, then the LED #0 shall not be grouped and
	 * shall be treated as an individual resource.
	 * For all other non-zero values of this field, LED #0 shall
	 * be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led0_group_id;
	/* Reserved field. */
	uint8_t	rsvd0;
	/* An identifier for the LED #1. */
	uint8_t	led1_id;
	/* The requested state of the LED #1. */
	uint8_t	led1_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_CFG_INPUT_LED1_STATE_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED1_STATE_BLINKALT
	/* The requested color of LED #1. */
	uint8_t	led1_color;
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED1_COLOR_GREENAMBER
	uint8_t	unused_1;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led1_blink_on;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led1_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #1 belongs
	 * to.
	 * If set to 0, then the LED #1 shall not be grouped and
	 * shall be treated as an individual resource.
	 * For all other non-zero values of this field, LED #1 shall
	 * be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led1_group_id;
	/* Reserved field. */
	uint8_t	rsvd1;
	/* An identifier for the LED #2. */
	uint8_t	led2_id;
	/* The requested state of the LED #2. */
	uint8_t	led2_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_CFG_INPUT_LED2_STATE_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED2_STATE_BLINKALT
	/* The requested color of LED #2. */
	uint8_t	led2_color;
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED2_COLOR_GREENAMBER
	uint8_t	unused_2;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led2_blink_on;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led2_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #2 belongs
	 * to.
	 * If set to 0, then the LED #2 shall not be grouped and
	 * shall be treated as an individual resource.
	 * For all other non-zero values of this field, LED #2 shall
	 * be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led2_group_id;
	/* Reserved field. */
	uint8_t	rsvd2;
	/* An identifier for the LED #3. */
	uint8_t	led3_id;
	/* The requested state of the LED #3. */
	uint8_t	led3_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_CFG_INPUT_LED3_STATE_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED3_STATE_BLINKALT
	/* The requested color of LED #3. */
	uint8_t	led3_color;
	/* Default */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_LAST \
		HWRM_PORT_LED_CFG_INPUT_LED3_COLOR_GREENAMBER
	uint8_t	unused_3;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led3_blink_on;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led3_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #3 belongs
	 * to.
	 * If set to 0, then the LED #3 shall not be grouped and
	 * shall be treated as an individual resource.
	 * For all other non-zero values of this field, LED #3 shall
	 * be grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led3_group_id;
	/* Reserved field. */
	uint8_t	rsvd3;
} __attribute__((packed));

/* hwrm_port_led_cfg_output (size:128b/16B) */
struct hwrm_port_led_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_port_led_qcfg *
 **********************/


/* hwrm_port_led_qcfg_input (size:192b/24B) */
struct hwrm_port_led_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port whose LED configuration is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_led_qcfg_output (size:448b/56B) */
struct hwrm_port_led_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * The number of LEDs that are configured on this port.
	 * Up to 4 LEDs can be returned in the response.
	 */
	uint8_t	num_leds;
	/* An identifier for the LED #0. */
	uint8_t	led0_id;
	/* The type of LED #0. */
	uint8_t	led0_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED0_TYPE_INVALID
	/* The current state of the LED #0. */
	uint8_t	led0_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED0_STATE_BLINKALT
	/* The color of LED #0. */
	uint8_t	led0_color;
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED0_COLOR_GREENAMBER
	uint8_t	unused_0;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led0_blink_on;
	/*
	 * If the LED #0 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led0_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #0 belongs
	 * to.
	 * If set to 0, then the LED #0 is not grouped.
	 * For all other non-zero values of this field, LED #0 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led0_group_id;
	/* An identifier for the LED #1. */
	uint8_t	led1_id;
	/* The type of LED #1. */
	uint8_t	led1_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED1_TYPE_INVALID
	/* The current state of the LED #1. */
	uint8_t	led1_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED1_STATE_BLINKALT
	/* The color of LED #1. */
	uint8_t	led1_color;
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED1_COLOR_GREENAMBER
	uint8_t	unused_1;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led1_blink_on;
	/*
	 * If the LED #1 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led1_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #1 belongs
	 * to.
	 * If set to 0, then the LED #1 is not grouped.
	 * For all other non-zero values of this field, LED #1 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led1_group_id;
	/* An identifier for the LED #2. */
	uint8_t	led2_id;
	/* The type of LED #2. */
	uint8_t	led2_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED2_TYPE_INVALID
	/* The current state of the LED #2. */
	uint8_t	led2_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED2_STATE_BLINKALT
	/* The color of LED #2. */
	uint8_t	led2_color;
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED2_COLOR_GREENAMBER
	uint8_t	unused_2;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led2_blink_on;
	/*
	 * If the LED #2 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led2_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #2 belongs
	 * to.
	 * If set to 0, then the LED #2 is not grouped.
	 * For all other non-zero values of this field, LED #2 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led2_group_id;
	/* An identifier for the LED #3. */
	uint8_t	led3_id;
	/* The type of LED #3. */
	uint8_t	led3_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED3_TYPE_INVALID
	/* The current state of the LED #3. */
	uint8_t	led3_state;
	/* Default state of the LED */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_DEFAULT  UINT32_C(0x0)
	/* Off */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_OFF      UINT32_C(0x1)
	/* On */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_ON       UINT32_C(0x2)
	/* Blink */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_BLINK    UINT32_C(0x3)
	/* Blink Alternately */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_BLINKALT UINT32_C(0x4)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED3_STATE_BLINKALT
	/* The color of LED #3. */
	uint8_t	led3_color;
	/* Default */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_DEFAULT    UINT32_C(0x0)
	/* Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_AMBER      UINT32_C(0x1)
	/* Green */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_GREEN      UINT32_C(0x2)
	/* Green or Amber */
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_GREENAMBER UINT32_C(0x3)
	#define HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_LAST \
		HWRM_PORT_LED_QCFG_OUTPUT_LED3_COLOR_GREENAMBER
	uint8_t	unused_3;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED on between cycles.
	 */
	uint16_t	led3_blink_on;
	/*
	 * If the LED #3 state is "blink" or "blinkalt", then
	 * this field represents the requested time in milliseconds
	 * to keep LED off between cycles.
	 */
	uint16_t	led3_blink_off;
	/*
	 * An identifier for the group of LEDs that LED #3 belongs
	 * to.
	 * If set to 0, then the LED #3 is not grouped.
	 * For all other non-zero values of this field, LED #3 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led3_group_id;
	uint8_t	unused_4[6];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_port_led_qcaps *
 ***********************/


/* hwrm_port_led_qcaps_input (size:192b/24B) */
struct hwrm_port_led_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Port ID of port whose LED configuration is being queried. */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_port_led_qcaps_output (size:384b/48B) */
struct hwrm_port_led_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * The number of LEDs that are configured on this port.
	 * Up to 4 LEDs can be returned in the response.
	 */
	uint8_t	num_leds;
	/* Reserved for future use. */
	uint8_t	unused[3];
	/* An identifier for the LED #0. */
	uint8_t	led0_id;
	/* The type of LED #0. */
	uint8_t	led0_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_LAST \
		HWRM_PORT_LED_QCAPS_OUTPUT_LED0_TYPE_INVALID
	/*
	 * An identifier for the group of LEDs that LED #0 belongs
	 * to.
	 * If set to 0, then the LED #0 cannot be grouped.
	 * For all other non-zero values of this field, LED #0 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led0_group_id;
	uint8_t	unused_0;
	/* The states supported by LED #0. */
	uint16_t	led0_state_caps;
	/*
	 * If set to 1, this LED is enabled.
	 * If set to 0, this LED is disabled.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_ENABLED \
		UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED.
	 * If set to 0, off state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_OFF_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED.
	 * If set to 0, on state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_ON_SUPPORTED \
		UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED.
	 * If set to 0, blink state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_BLINK_SUPPORTED \
		UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED.
	 * If set to 0, blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_STATE_CAPS_BLINK_ALT_SUPPORTED \
		UINT32_C(0x10)
	/* The colors supported by LED #0. */
	uint16_t	led0_color_caps;
	/* reserved. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_COLOR_CAPS_RSVD \
		UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED.
	 * If set to 0, Amber color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_COLOR_CAPS_AMBER_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED.
	 * If set to 0, Green color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED0_COLOR_CAPS_GREEN_SUPPORTED \
		UINT32_C(0x4)
	/* An identifier for the LED #1. */
	uint8_t	led1_id;
	/* The type of LED #1. */
	uint8_t	led1_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_LAST \
		HWRM_PORT_LED_QCAPS_OUTPUT_LED1_TYPE_INVALID
	/*
	 * An identifier for the group of LEDs that LED #1 belongs
	 * to.
	 * If set to 0, then the LED #0 cannot be grouped.
	 * For all other non-zero values of this field, LED #0 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led1_group_id;
	uint8_t	unused_1;
	/* The states supported by LED #1. */
	uint16_t	led1_state_caps;
	/*
	 * If set to 1, this LED is enabled.
	 * If set to 0, this LED is disabled.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_ENABLED \
		UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED.
	 * If set to 0, off state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_OFF_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED.
	 * If set to 0, on state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_ON_SUPPORTED \
		UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED.
	 * If set to 0, blink state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_BLINK_SUPPORTED \
		UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED.
	 * If set to 0, blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_STATE_CAPS_BLINK_ALT_SUPPORTED \
		UINT32_C(0x10)
	/* The colors supported by LED #1. */
	uint16_t	led1_color_caps;
	/* reserved. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_COLOR_CAPS_RSVD \
		UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED.
	 * If set to 0, Amber color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_COLOR_CAPS_AMBER_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED.
	 * If set to 0, Green color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED1_COLOR_CAPS_GREEN_SUPPORTED \
		UINT32_C(0x4)
	/* An identifier for the LED #2. */
	uint8_t	led2_id;
	/* The type of LED #2. */
	uint8_t	led2_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_LAST \
		HWRM_PORT_LED_QCAPS_OUTPUT_LED2_TYPE_INVALID
	/*
	 * An identifier for the group of LEDs that LED #0 belongs
	 * to.
	 * If set to 0, then the LED #0 cannot be grouped.
	 * For all other non-zero values of this field, LED #0 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led2_group_id;
	uint8_t	unused_2;
	/* The states supported by LED #2. */
	uint16_t	led2_state_caps;
	/*
	 * If set to 1, this LED is enabled.
	 * If set to 0, this LED is disabled.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_ENABLED \
		UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED.
	 * If set to 0, off state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_OFF_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED.
	 * If set to 0, on state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_ON_SUPPORTED \
		UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED.
	 * If set to 0, blink state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_BLINK_SUPPORTED \
		UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED.
	 * If set to 0, blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_STATE_CAPS_BLINK_ALT_SUPPORTED \
		UINT32_C(0x10)
	/* The colors supported by LED #2. */
	uint16_t	led2_color_caps;
	/* reserved. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_COLOR_CAPS_RSVD \
		UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED.
	 * If set to 0, Amber color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_COLOR_CAPS_AMBER_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED.
	 * If set to 0, Green color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED2_COLOR_CAPS_GREEN_SUPPORTED \
		UINT32_C(0x4)
	/* An identifier for the LED #3. */
	uint8_t	led3_id;
	/* The type of LED #3. */
	uint8_t	led3_type;
	/* Speed LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_SPEED    UINT32_C(0x0)
	/* Activity LED */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_ACTIVITY UINT32_C(0x1)
	/* Invalid */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_INVALID  UINT32_C(0xff)
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_LAST \
		HWRM_PORT_LED_QCAPS_OUTPUT_LED3_TYPE_INVALID
	/*
	 * An identifier for the group of LEDs that LED #3 belongs
	 * to.
	 * If set to 0, then the LED #0 cannot be grouped.
	 * For all other non-zero values of this field, LED #0 is
	 * grouped together with the LEDs with the same group ID
	 * value.
	 */
	uint8_t	led3_group_id;
	uint8_t	unused_3;
	/* The states supported by LED #3. */
	uint16_t	led3_state_caps;
	/*
	 * If set to 1, this LED is enabled.
	 * If set to 0, this LED is disabled.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_ENABLED \
		UINT32_C(0x1)
	/*
	 * If set to 1, off state is supported on this LED.
	 * If set to 0, off state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_OFF_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, on state is supported on this LED.
	 * If set to 0, on state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_ON_SUPPORTED \
		UINT32_C(0x4)
	/*
	 * If set to 1, blink state is supported on this LED.
	 * If set to 0, blink state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_BLINK_SUPPORTED \
		UINT32_C(0x8)
	/*
	 * If set to 1, blink_alt state is supported on this LED.
	 * If set to 0, blink_alt state is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_STATE_CAPS_BLINK_ALT_SUPPORTED \
		UINT32_C(0x10)
	/* The colors supported by LED #3. */
	uint16_t	led3_color_caps;
	/* reserved. */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_COLOR_CAPS_RSVD \
		UINT32_C(0x1)
	/*
	 * If set to 1, Amber color is supported on this LED.
	 * If set to 0, Amber color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_COLOR_CAPS_AMBER_SUPPORTED \
		UINT32_C(0x2)
	/*
	 * If set to 1, Green color is supported on this LED.
	 * If set to 0, Green color is not supported on this LED.
	 */
	#define HWRM_PORT_LED_QCAPS_OUTPUT_LED3_COLOR_CAPS_GREEN_SUPPORTED \
		UINT32_C(0x4)
	uint8_t	unused_4[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_queue_qportcfg *
 ***********************/


/* hwrm_queue_qportcfg_input (size:192b/24B) */
struct hwrm_queue_qportcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_TX    UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_RX    UINT32_C(0x1)
	#define HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_LAST \
		HWRM_QUEUE_QPORTCFG_INPUT_FLAGS_PATH_RX
	/*
	 * Port ID of port for which the queue configuration is being
	 * queried.  This field is only required when sent by IPC.
	 */
	uint16_t	port_id;
	/*
	 * Drivers will set this capability when it can use
	 * queue_idx_service_profile to map the queues to application.
	 */
	uint8_t	drv_qmap_cap;
	/* disabled */
	#define HWRM_QUEUE_QPORTCFG_INPUT_DRV_QMAP_CAP_DISABLED UINT32_C(0x0)
	/* enabled */
	#define HWRM_QUEUE_QPORTCFG_INPUT_DRV_QMAP_CAP_ENABLED  UINT32_C(0x1)
	#define HWRM_QUEUE_QPORTCFG_INPUT_DRV_QMAP_CAP_LAST \
		HWRM_QUEUE_QPORTCFG_INPUT_DRV_QMAP_CAP_ENABLED
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_queue_qportcfg_output (size:256b/32B) */
struct hwrm_queue_qportcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * The maximum number of queues that can be configured on this
	 * port.
	 * Valid values range from 1 through 8.
	 */
	uint8_t	max_configurable_queues;
	/*
	 * The maximum number of lossless queues that can be configured
	 * on this port.
	 * Valid values range from 0 through 8.
	 */
	uint8_t	max_configurable_lossless_queues;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_cfg command.
	 *
	 * Each bit represents a specific queue where bit 0 represents
	 * queue 0 and bit 7 represents queue 7.
	 * # A value of 0 indicates that the queue is not configurable
	 * by the hwrm_queue_cfg command.
	 * # A value of 1 indicates that the queue is configurable.
	 * # A hwrm_queue_cfg command shall return error when trying to
	 * configure a queue not configurable.
	 */
	uint8_t	queue_cfg_allowed;
	/* Information about queue configuration. */
	uint8_t	queue_cfg_info;
	/*
	 * If this flag is set to '1', then the queues are
	 * configured asymmetrically on TX and RX sides.
	 * If this flag is set to '0', then the queues are
	 * configured symmetrically on TX and RX sides. For
	 * symmetric configuration, the queue configuration
	 * including queue ids and service profiles on the
	 * TX side is the same as the corresponding queue
	 * configuration on the RX side.
	 */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_CFG_INFO_ASYM_CFG \
		UINT32_C(0x1)
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_pfcenable_cfg command.
	 *
	 * Each bit represents a specific priority where bit 0 represents
	 * priority 0 and bit 7 represents priority 7.
	 * # A value of 0 indicates that the priority is not configurable by
	 * the hwrm_queue_pfcenable_cfg command.
	 * # A value of 1 indicates that the priority is configurable.
	 * # A hwrm_queue_pfcenable_cfg command shall return error when
	 * trying to configure a priority that is not configurable.
	 */
	uint8_t	queue_pfcenable_cfg_allowed;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_pri2cos_cfg command.
	 *
	 * Each bit represents a specific queue where bit 0 represents
	 * queue 0 and bit 7 represents queue 7.
	 * # A value of 0 indicates that the queue is not configurable
	 * by the hwrm_queue_pri2cos_cfg command.
	 * # A value of 1 indicates that the queue is configurable.
	 * # A hwrm_queue_pri2cos_cfg command shall return error when
	 * trying to configure a queue that is not configurable.
	 */
	uint8_t	queue_pri2cos_cfg_allowed;
	/*
	 * Bitmask indicating which queues can be configured by the
	 * hwrm_queue_pri2cos_cfg command.
	 *
	 * Each bit represents a specific queue where bit 0 represents
	 * queue 0 and bit 7 represents queue 7.
	 * # A value of 0 indicates that the queue is not configurable
	 * by the hwrm_queue_pri2cos_cfg command.
	 * # A value of 1 indicates that the queue is configurable.
	 * # A hwrm_queue_pri2cos_cfg command shall return error when
	 * trying to configure a queue not configurable.
	 */
	uint8_t	queue_cos2bw_cfg_allowed;
	/*
	 * ID of CoS Queue 0.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id0;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id0_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID0_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 1.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id1;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id1_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID1_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 2.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id2;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id2_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID2_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 3.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id3;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id3_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID3_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 4.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id4;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id4_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID4_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 5.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id5;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id5_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID5_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 6.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id6;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id6_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID6_SERVICE_PROFILE_UNKNOWN
	/*
	 * ID of CoS Queue 7.
	 * FF - Invalid id
	 *
	 * # This ID can be used on any subsequent call to an hwrm command
	 * that takes a queue id.
	 * # IDs must always be queried by this command before any use
	 * by the driver or software.
	 * # Any driver or software should not make any assumptions about
	 * queue IDs.
	 * # A value of 0xff indicates that the queue is not available.
	 * # Available queues may not be in sequential order.
	 */
	uint8_t	queue_id7;
	/* This value is applicable to CoS queues only. */
	uint8_t	queue_id7_service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSY \
		UINT32_C(0x0)
	/* Lossless (legacy) */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSLESS \
		UINT32_C(0x1)
	/* Lossless RoCE */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSLESS_ROCE \
		UINT32_C(0x1)
	/* Lossy RoCE CNP */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSY_ROCE_CNP \
		UINT32_C(0x2)
	/* Lossless NIC */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LOSSLESS_NIC \
		UINT32_C(0x3)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_UNKNOWN \
		UINT32_C(0xff)
	#define HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QPORTCFG_OUTPUT_QUEUE_ID7_SERVICE_PROFILE_UNKNOWN
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_queue_qcfg *
 *******************/


/* hwrm_queue_qcfg_input (size:192b/24B) */
struct hwrm_queue_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_TX    UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_RX    UINT32_C(0x1)
	#define HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_LAST \
		HWRM_QUEUE_QCFG_INPUT_FLAGS_PATH_RX
	/* Queue ID of the queue. */
	uint32_t	queue_id;
} __attribute__((packed));

/* hwrm_queue_qcfg_output (size:128b/16B) */
struct hwrm_queue_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This value is a the estimate packet length used in the
	 * TX arbiter.
	 */
	uint32_t	queue_len;
	/* This value is applicable to CoS queues only. */
	uint8_t	service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_LOSSY    UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_UNKNOWN  UINT32_C(0xff)
	#define HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_QCFG_OUTPUT_SERVICE_PROFILE_UNKNOWN
	/* Information about queue configuration. */
	uint8_t	queue_cfg_info;
	/*
	 * If this flag is set to '1', then the queue is
	 * configured asymmetrically on TX and RX sides.
	 * If this flag is set to '0', then this queue is
	 * configured symmetrically on TX and RX sides.
	 */
	#define HWRM_QUEUE_QCFG_OUTPUT_QUEUE_CFG_INFO_ASYM_CFG \
		UINT32_C(0x1)
	uint8_t	unused_0;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_queue_cfg *
 ******************/


/* hwrm_queue_cfg_input (size:320b/40B) */
struct hwrm_queue_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX, or both directions applicable to the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_MASK UINT32_C(0x3)
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_SFT  0
	/* tx path */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_TX     UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_RX     UINT32_C(0x1)
	/* Bi-directional (Symmetrically applicable to TX and RX paths) */
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_BIDIR  UINT32_C(0x2)
	#define HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_LAST \
		HWRM_QUEUE_CFG_INPUT_FLAGS_PATH_BIDIR
	uint32_t	enables;
	/*
	 * This bit must be '1' for the dflt_len field to be
	 * configured.
	 */
	#define HWRM_QUEUE_CFG_INPUT_ENABLES_DFLT_LEN            UINT32_C(0x1)
	/*
	 * This bit must be '1' for the service_profile field to be
	 * configured.
	 */
	#define HWRM_QUEUE_CFG_INPUT_ENABLES_SERVICE_PROFILE     UINT32_C(0x2)
	/* Queue ID of queue that is to be configured by this function. */
	uint32_t	queue_id;
	/*
	 * This value is a the estimate packet length used in the
	 * TX arbiter.
	 * Set to 0xFF... (All Fs) to not adjust this value.
	 */
	uint32_t	dflt_len;
	/* This value is applicable to CoS queues only. */
	uint8_t	service_profile;
	/* Lossy (best-effort) */
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_LOSSY    UINT32_C(0x0)
	/* Lossless */
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_LOSSLESS UINT32_C(0x1)
	/* Set to 0xFF... (All Fs) if there is no service profile specified */
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_UNKNOWN  UINT32_C(0xff)
	#define HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_LAST \
		HWRM_QUEUE_CFG_INPUT_SERVICE_PROFILE_UNKNOWN
	uint8_t	unused_0[7];
} __attribute__((packed));

/* hwrm_queue_cfg_output (size:128b/16B) */
struct hwrm_queue_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************
 * hwrm_queue_pfcenable_qcfg *
 *****************************/


/* hwrm_queue_pfcenable_qcfg_input (size:192b/24B) */
struct hwrm_queue_pfcenable_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_queue_pfcenable_qcfg_output (size:128b/16B) */
struct hwrm_queue_pfcenable_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/* If set to 1, then PFC is enabled on PRI 0. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI0_PFC_ENABLED \
		UINT32_C(0x1)
	/* If set to 1, then PFC is enabled on PRI 1. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI1_PFC_ENABLED \
		UINT32_C(0x2)
	/* If set to 1, then PFC is enabled on PRI 2. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI2_PFC_ENABLED \
		UINT32_C(0x4)
	/* If set to 1, then PFC is enabled on PRI 3. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI3_PFC_ENABLED \
		UINT32_C(0x8)
	/* If set to 1, then PFC is enabled on PRI 4. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI4_PFC_ENABLED \
		UINT32_C(0x10)
	/* If set to 1, then PFC is enabled on PRI 5. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI5_PFC_ENABLED \
		UINT32_C(0x20)
	/* If set to 1, then PFC is enabled on PRI 6. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI6_PFC_ENABLED \
		UINT32_C(0x40)
	/* If set to 1, then PFC is enabled on PRI 7. */
	#define HWRM_QUEUE_PFCENABLE_QCFG_OUTPUT_FLAGS_PRI7_PFC_ENABLED \
		UINT32_C(0x80)
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_queue_pfcenable_cfg *
 ****************************/


/* hwrm_queue_pfcenable_cfg_input (size:192b/24B) */
struct hwrm_queue_pfcenable_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* If set to 1, then PFC is requested to be enabled on PRI 0. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI0_PFC_ENABLED \
		UINT32_C(0x1)
	/* If set to 1, then PFC is requested to be enabled on PRI 1. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI1_PFC_ENABLED \
		UINT32_C(0x2)
	/* If set to 1, then PFC is requested to  be enabled on PRI 2. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI2_PFC_ENABLED \
		UINT32_C(0x4)
	/* If set to 1, then PFC is requested to  be enabled on PRI 3. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI3_PFC_ENABLED \
		UINT32_C(0x8)
	/* If set to 1, then PFC is requested to  be enabled on PRI 4. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI4_PFC_ENABLED \
		UINT32_C(0x10)
	/* If set to 1, then PFC is requested to  be enabled on PRI 5. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI5_PFC_ENABLED \
		UINT32_C(0x20)
	/* If set to 1, then PFC is requested to  be enabled on PRI 6. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI6_PFC_ENABLED \
		UINT32_C(0x40)
	/* If set to 1, then PFC is requested to  be enabled on PRI 7. */
	#define HWRM_QUEUE_PFCENABLE_CFG_INPUT_FLAGS_PRI7_PFC_ENABLED \
		UINT32_C(0x80)
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint16_t	port_id;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_queue_pfcenable_cfg_output (size:128b/16B) */
struct hwrm_queue_pfcenable_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_queue_pri2cos_qcfg *
 ***************************/


/* hwrm_queue_pri2cos_qcfg_input (size:192b/24B) */
struct hwrm_queue_pri2cos_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH      UINT32_C(0x1)
	/* tx path */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_TX     UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_RX     UINT32_C(0x1)
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_LAST \
		HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_PATH_RX
	/*
	 * When this bit is set to '0', the query is
	 * for VLAN PRI field in tunnel headers.
	 * When this bit is set to '1', the query is
	 * for VLAN PRI field in inner packet headers.
	 */
	#define HWRM_QUEUE_PRI2COS_QCFG_INPUT_FLAGS_IVLAN     UINT32_C(0x2)
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint8_t	port_id;
	uint8_t	unused_0[3];
} __attribute__((packed));

/* hwrm_queue_pri2cos_qcfg_output (size:192b/24B) */
struct hwrm_queue_pri2cos_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * CoS Queue assigned to priority 0.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri0_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 1.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri1_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 2  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri2_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 3.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri3_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 4.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri4_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 5.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri5_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 6.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri6_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 7.  This value can only
	 * be changed before traffic has started.
	 * A value of 0xff indicates that no CoS queue is assigned to the
	 * specified priority.
	 */
	uint8_t	pri7_cos_queue_id;
	/* Information about queue configuration. */
	uint8_t	queue_cfg_info;
	/*
	 * If this flag is set to '1', then the PRI to CoS
	 * configuration is asymmetric on TX and RX sides.
	 * If this flag is set to '0', then PRI to CoS configuration
	 * is symmetric on TX and RX sides.
	 */
	#define HWRM_QUEUE_PRI2COS_QCFG_OUTPUT_QUEUE_CFG_INFO_ASYM_CFG \
		UINT32_C(0x1)
	uint8_t	unused_0[6];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_queue_pri2cos_cfg *
 **************************/


/* hwrm_queue_pri2cos_cfg_input (size:320b/40B) */
struct hwrm_queue_pri2cos_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX, or both directions applicable to the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_MASK UINT32_C(0x3)
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_SFT  0
	/* tx path */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_TX     UINT32_C(0x0)
	/* rx path */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_RX     UINT32_C(0x1)
	/* Bi-directional (Symmetrically applicable to TX and RX paths) */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_BIDIR  UINT32_C(0x2)
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_LAST \
		HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_PATH_BIDIR
	/*
	 * When this bit is set to '0', the mapping is requested
	 * for VLAN PRI field in tunnel headers.
	 * When this bit is set to '1', the mapping is requested
	 * for VLAN PRI field in inner packet headers.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_FLAGS_IVLAN     UINT32_C(0x4)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the pri0_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI0_COS_QUEUE_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the pri1_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI1_COS_QUEUE_ID \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the pri2_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI2_COS_QUEUE_ID \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the pri3_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI3_COS_QUEUE_ID \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the pri4_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI4_COS_QUEUE_ID \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the pri5_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI5_COS_QUEUE_ID \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the pri6_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI6_COS_QUEUE_ID \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the pri7_cos_queue_id field to be
	 * configured.
	 */
	#define HWRM_QUEUE_PRI2COS_CFG_INPUT_ENABLES_PRI7_COS_QUEUE_ID \
		UINT32_C(0x80)
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint8_t	port_id;
	/*
	 * CoS Queue assigned to priority 0.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri0_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 1.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri1_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 2  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri2_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 3.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri3_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 4.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri4_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 5.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri5_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 6.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri6_cos_queue_id;
	/*
	 * CoS Queue assigned to priority 7.  This value can only
	 * be changed before traffic has started.
	 */
	uint8_t	pri7_cos_queue_id;
	uint8_t	unused_0[7];
} __attribute__((packed));

/* hwrm_queue_pri2cos_cfg_output (size:128b/16B) */
struct hwrm_queue_pri2cos_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_queue_cos2bw_qcfg *
 **************************/


/* hwrm_queue_cos2bw_qcfg_input (size:192b/24B) */
struct hwrm_queue_cos2bw_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure TC BW assignment on this port.
	 */
	uint16_t	port_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_queue_cos2bw_qcfg_output (size:896b/112B) */
struct hwrm_queue_cos2bw_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* ID of CoS Queue 0. */
	uint8_t	queue_id0;
	uint8_t	unused_0;
	uint16_t	unused_1;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id0_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id0_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id0_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id0_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id0_bw_weight;
	/* ID of CoS Queue 1. */
	uint8_t	queue_id1;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id1_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id1_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id1_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id1_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id1_bw_weight;
	/* ID of CoS Queue 2. */
	uint8_t	queue_id2;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id2_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id2_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id2_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id2_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id2_bw_weight;
	/* ID of CoS Queue 3. */
	uint8_t	queue_id3;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id3_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id3_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id3_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id3_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id3_bw_weight;
	/* ID of CoS Queue 4. */
	uint8_t	queue_id4;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id4_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id4_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id4_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id4_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id4_bw_weight;
	/* ID of CoS Queue 5. */
	uint8_t	queue_id5;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id5_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id5_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id5_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id5_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id5_bw_weight;
	/* ID of CoS Queue 6. */
	uint8_t	queue_id6;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id6_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id6_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id6_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id6_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id6_bw_weight;
	/* ID of CoS Queue 7. */
	uint8_t	queue_id7;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id7_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id7_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id7_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_QCFG_OUTPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id7_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id7_bw_weight;
	uint8_t	unused_2[4];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_queue_cos2bw_cfg *
 *************************/


/* hwrm_queue_cos2bw_cfg_input (size:1024b/128B) */
struct hwrm_queue_cos2bw_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	uint32_t	enables;
	/*
	 * If this bit is set to 1, then all queue_id0 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID0_VALID \
		UINT32_C(0x1)
	/*
	 * If this bit is set to 1, then all queue_id1 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID1_VALID \
		UINT32_C(0x2)
	/*
	 * If this bit is set to 1, then all queue_id2 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID2_VALID \
		UINT32_C(0x4)
	/*
	 * If this bit is set to 1, then all queue_id3 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID3_VALID \
		UINT32_C(0x8)
	/*
	 * If this bit is set to 1, then all queue_id4 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID4_VALID \
		UINT32_C(0x10)
	/*
	 * If this bit is set to 1, then all queue_id5 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID5_VALID \
		UINT32_C(0x20)
	/*
	 * If this bit is set to 1, then all queue_id6 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID6_VALID \
		UINT32_C(0x40)
	/*
	 * If this bit is set to 1, then all queue_id7 related
	 * parameters in this command are valid.
	 */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_ENABLES_COS_QUEUE_ID7_VALID \
		UINT32_C(0x80)
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure TC BW assignment on this port.
	 */
	uint16_t	port_id;
	/* ID of CoS Queue 0. */
	uint8_t	queue_id0;
	uint8_t	unused_0;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id0_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id0_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id0_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID0_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id0_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id0_bw_weight;
	/* ID of CoS Queue 1. */
	uint8_t	queue_id1;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id1_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id1_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id1_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID1_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id1_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id1_bw_weight;
	/* ID of CoS Queue 2. */
	uint8_t	queue_id2;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id2_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id2_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id2_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID2_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id2_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id2_bw_weight;
	/* ID of CoS Queue 3. */
	uint8_t	queue_id3;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id3_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id3_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id3_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID3_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id3_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id3_bw_weight;
	/* ID of CoS Queue 4. */
	uint8_t	queue_id4;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id4_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id4_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id4_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID4_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id4_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id4_bw_weight;
	/* ID of CoS Queue 5. */
	uint8_t	queue_id5;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id5_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id5_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id5_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID5_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id5_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id5_bw_weight;
	/* ID of CoS Queue 6. */
	uint8_t	queue_id6;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id6_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id6_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id6_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID6_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id6_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id6_bw_weight;
	/* ID of CoS Queue 7. */
	uint8_t	queue_id7;
	/*
	 * Minimum BW allocated to CoS Queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id7_min_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MIN_BW_BW_VALUE_UNIT_INVALID
	/*
	 * Maximum BW allocated to CoS queue.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this COS inside the device.
	 */
	uint32_t	queue_id7_max_bw;
	/* The bandwidth value. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_MAX_BW_BW_VALUE_UNIT_INVALID
	/* Transmission Selection Algorithm (TSA) for CoS Queue. */
	uint8_t	queue_id7_tsa_assign;
	/* Strict Priority */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_SP \
		UINT32_C(0x0)
	/* Enhanced Transmission Selection */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_ETS \
		UINT32_C(0x1)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_FIRST \
		UINT32_C(0x2)
	/* reserved. */
	#define HWRM_QUEUE_COS2BW_CFG_INPUT_QUEUE_ID7_TSA_ASSIGN_RESERVED_LAST \
		UINT32_C(0xff)
	/*
	 * Priority level for strict priority. Valid only when the
	 * tsa_assign is 0 - Strict Priority (SP)
	 * 0..7 - Valid values.
	 * 8..255 - Reserved.
	 */
	uint8_t	queue_id7_pri_lvl;
	/*
	 * Weight used to allocate remaining BW for this COS after
	 * servicing guaranteed bandwidths for all COS.
	 */
	uint8_t	queue_id7_bw_weight;
	uint8_t	unused_1[5];
} __attribute__((packed));

/* hwrm_queue_cos2bw_cfg_output (size:128b/16B) */
struct hwrm_queue_cos2bw_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_queue_dscp_qcaps *
 *************************/


/* hwrm_queue_dscp_qcaps_input (size:192b/24B) */
struct hwrm_queue_dscp_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint8_t	port_id;
	uint8_t	unused_0[7];
} __attribute__((packed));

/* hwrm_queue_dscp_qcaps_output (size:128b/16B) */
struct hwrm_queue_dscp_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The number of bits provided by the hardware for the DSCP value. */
	uint8_t	num_dscp_bits;
	uint8_t	unused_0;
	/* Max number of DSCP-MASK-PRI entries supported. */
	uint16_t	max_entries;
	uint8_t	unused_1[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_queue_dscp2pri_qcfg *
 ****************************/


/* hwrm_queue_dscp2pri_qcfg_input (size:256b/32B) */
struct hwrm_queue_dscp2pri_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is the host address where the 24-bits DSCP-MASK-PRI
	 * tuple(s) will be copied to.
	 */
	uint64_t	dest_data_addr;
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint8_t	port_id;
	uint8_t	unused_0;
	/* Size of the buffer pointed to by dest_data_addr. */
	uint16_t	dest_data_buffer_size;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_queue_dscp2pri_qcfg_output (size:128b/16B) */
struct hwrm_queue_dscp2pri_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * A count of the number of DSCP-MASK-PRI tuple(s) pointed to
	 * by the dest_data_addr.
	 */
	uint16_t	entry_cnt;
	/*
	 * This is the default PRI which un-initialized DSCP values are
	 * mapped to.
	 */
	uint8_t	default_pri;
	uint8_t	unused_0[4];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_queue_dscp2pri_cfg *
 ***************************/


/* hwrm_queue_dscp2pri_cfg_input (size:320b/40B) */
struct hwrm_queue_dscp2pri_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is the host address where the 24-bits DSCP-MASK-PRI tuple
	 * will be copied from.
	 */
	uint64_t	src_data_addr;
	uint32_t	flags;
	/* use_hw_default_pri is 1 b */
	#define HWRM_QUEUE_DSCP2PRI_CFG_INPUT_FLAGS_USE_HW_DEFAULT_PRI \
		UINT32_C(0x1)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the default_pri field to be
	 * configured.
	 */
	#define HWRM_QUEUE_DSCP2PRI_CFG_INPUT_ENABLES_DEFAULT_PRI \
		UINT32_C(0x1)
	/*
	 * Port ID of port for which the table is being configured.
	 * The HWRM needs to check whether this function is allowed
	 * to configure pri2cos mapping on this port.
	 */
	uint8_t	port_id;
	/*
	 * This is the default PRI which un-initialized DSCP values will be
	 * mapped to.
	 */
	uint8_t	default_pri;
	/*
	 * A count of the number of DSCP-MASK-PRI tuple(s) in the data pointed
	 * to by src_data_addr.
	 */
	uint16_t	entry_cnt;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_queue_dscp2pri_cfg_output (size:128b/16B) */
struct hwrm_queue_dscp2pri_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_vnic_alloc *
 *******************/


/* hwrm_vnic_alloc_input (size:192b/24B) */
struct hwrm_vnic_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', this VNIC is requested to
	 * be the default VNIC for this function.
	 */
	#define HWRM_VNIC_ALLOC_INPUT_FLAGS_DEFAULT     UINT32_C(0x1)
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_vnic_alloc_output (size:128b/16B) */
struct hwrm_vnic_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Logical vnic ID */
	uint32_t	vnic_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_vnic_free *
 ******************/


/* hwrm_vnic_free_input (size:192b/24B) */
struct hwrm_vnic_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Logical vnic ID */
	uint32_t	vnic_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_vnic_free_output (size:128b/16B) */
struct hwrm_vnic_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************
 * hwrm_vnic_cfg *
 *****************/


/* hwrm_vnic_cfg_input (size:320b/40B) */
struct hwrm_vnic_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the VNIC is requested to
	 * be the default VNIC for the function.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_DEFAULT \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is being configured to
	 * strip VLAN in the RX path.
	 * If set to '0', then VLAN stripping is disabled on
	 * this VNIC.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_VLAN_STRIP_MODE \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is being configured to
	 * buffer receive packets in the hardware until the host
	 * posts new receive buffers.
	 * If set to '0', then bd_stall is being configured to be
	 * disabled on this VNIC.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_BD_STALL_MODE \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is being configured to
	 * receive both RoCE and non-RoCE traffic.
	 * If set to '0', then this VNIC is not configured to be
	 * operating in dual VNIC mode.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_ROCE_DUAL_VNIC_MODE \
		UINT32_C(0x8)
	/*
	 * When this flag is set to '1', the VNIC is requested to
	 * be configured to receive only RoCE traffic.
	 * If this flag is set to '0', then this flag shall be
	 * ignored by the HWRM.
	 * If roce_dual_vnic_mode flag is set to '1'
	 * or roce_mirroring_capable_vnic_mode flag to 1,
	 * then the HWRM client shall not set this flag to '1'.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_ROCE_ONLY_VNIC_MODE \
		UINT32_C(0x10)
	/*
	 * When a VNIC uses one destination ring group for certain
	 * application (e.g. Receive Flow Steering) where
	 * exact match is used to direct packets to a VNIC with one
	 * destination ring group only, there is no need to configure
	 * RSS indirection table for that VNIC as only one destination
	 * ring group is used.
	 *
	 * This flag is used to enable a mode where
	 * RSS is enabled in the VNIC using a RSS context
	 * for computing RSS hash but the RSS indirection table is
	 * not configured using hwrm_vnic_rss_cfg.
	 *
	 * If this mode is enabled, then the driver should not program
	 * RSS indirection table for the RSS context that is used for
	 * computing RSS hash only.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_RSS_DFLT_CR_MODE \
		UINT32_C(0x20)
	/*
	 * When this bit is '1', the VNIC is being configured to
	 * receive both RoCE and non-RoCE traffic, but forward only the
	 * RoCE traffic further. Also, RoCE traffic can be mirrored to
	 * L2 driver.
	 */
	#define HWRM_VNIC_CFG_INPUT_FLAGS_ROCE_MIRRORING_CAPABLE_VNIC_MODE \
		UINT32_C(0x40)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the dflt_ring_grp field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_DFLT_RING_GRP \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the rss_rule field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_RSS_RULE \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the cos_rule field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_COS_RULE \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the lb_rule field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_LB_RULE \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the mru field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_MRU \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the default_rx_ring_id field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_DEFAULT_RX_RING_ID \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the default_cmpl_ring_id field to be
	 * configured.
	 */
	#define HWRM_VNIC_CFG_INPUT_ENABLES_DEFAULT_CMPL_RING_ID \
		UINT32_C(0x40)
	/* Logical vnic ID */
	uint16_t	vnic_id;
	/*
	 * Default Completion ring for the VNIC.  This ring will
	 * be chosen if packet does not match any RSS rules and if
	 * there is no COS rule.
	 */
	uint16_t	dflt_ring_grp;
	/*
	 * RSS ID for RSS rule/table structure.  0xFF... (All Fs) if
	 * there is no RSS rule.
	 */
	uint16_t	rss_rule;
	/*
	 * RSS ID for COS rule/table structure.  0xFF... (All Fs) if
	 * there is no COS rule.
	 */
	uint16_t	cos_rule;
	/*
	 * RSS ID for load balancing rule/table structure.
	 * 0xFF... (All Fs) if there is no LB rule.
	 */
	uint16_t	lb_rule;
	/*
	 * The maximum receive unit of the vnic.
	 * Each vnic is associated with a function.
	 * The vnic mru value overwrites the mru setting of the
	 * associated function.
	 * The HWRM shall make sure that vnic mru does not exceed
	 * the mru of the port the function is associated with.
	 */
	uint16_t	mru;
	/*
	 * Default Rx ring for the VNIC.  This ring will
	 * be chosen if packet does not match any RSS rules.
	 * The aggregation ring associated with the Rx ring is
	 * implied based on the Rx ring specified when the
	 * aggregation ring was allocated.
	 */
	uint16_t	default_rx_ring_id;
	/*
	 * Default completion ring for the VNIC.  This ring will
	 * be chosen if packet does not match any RSS rules.
	 */
	uint16_t	default_cmpl_ring_id;
} __attribute__((packed));

/* hwrm_vnic_cfg_output (size:128b/16B) */
struct hwrm_vnic_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_vnic_qcfg *
 ******************/


/* hwrm_vnic_qcfg_input (size:256b/32B) */
struct hwrm_vnic_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the vf_id_valid field to be
	 * configured.
	 */
	#define HWRM_VNIC_QCFG_INPUT_ENABLES_VF_ID_VALID     UINT32_C(0x1)
	/* Logical vnic ID */
	uint32_t	vnic_id;
	/* ID of Virtual Function whose VNIC resource is being queried. */
	uint16_t	vf_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_vnic_qcfg_output (size:256b/32B) */
struct hwrm_vnic_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Default Completion ring for the VNIC. */
	uint16_t	dflt_ring_grp;
	/*
	 * RSS ID for RSS rule/table structure.  0xFF... (All Fs) if
	 * there is no RSS rule.
	 */
	uint16_t	rss_rule;
	/*
	 * RSS ID for COS rule/table structure.  0xFF... (All Fs) if
	 * there is no COS rule.
	 */
	uint16_t	cos_rule;
	/*
	 * RSS ID for load balancing rule/table structure.
	 * 0xFF... (All Fs) if there is no LB rule.
	 */
	uint16_t	lb_rule;
	/* The maximum receive unit of the vnic. */
	uint16_t	mru;
	uint8_t	unused_0[2];
	uint32_t	flags;
	/*
	 * When this bit is '1', the VNIC is the default VNIC for
	 * the function.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_DEFAULT \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * strip VLAN in the RX path.
	 * If set to '0', then VLAN stripping is disabled on
	 * this VNIC.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_VLAN_STRIP_MODE \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * buffer receive packets in the hardware until the host
	 * posts new receive buffers.
	 * If set to '0', then bd_stall is disabled on
	 * this VNIC.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_BD_STALL_MODE \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * receive both RoCE and non-RoCE traffic.
	 * If set to '0', then this VNIC is not configured to
	 * operate in dual VNIC mode.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_ROCE_DUAL_VNIC_MODE \
		UINT32_C(0x8)
	/*
	 * When this flag is set to '1', the VNIC is configured to
	 * receive only RoCE traffic.
	 * When this flag is set to '0', the VNIC is not configured
	 * to receive only RoCE traffic.
	 * If roce_dual_vnic_mode flag and this flag both are set
	 * to '1', then it is an invalid configuration of the
	 * VNIC. The HWRM should not allow that type of
	 * mis-configuration by HWRM clients.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_ROCE_ONLY_VNIC_MODE \
		UINT32_C(0x10)
	/*
	 * When a VNIC uses one destination ring group for certain
	 * application (e.g. Receive Flow Steering) where
	 * exact match is used to direct packets to a VNIC with one
	 * destination ring group only, there is no need to configure
	 * RSS indirection table for that VNIC as only one destination
	 * ring group is used.
	 *
	 * When this bit is set to '1', then the VNIC is enabled in a
	 * mode where RSS is enabled in the VNIC using a RSS context
	 * for computing RSS hash but the RSS indirection table is
	 * not configured.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_RSS_DFLT_CR_MODE \
		UINT32_C(0x20)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * receive both RoCE and non-RoCE traffic, but forward only
	 * RoCE traffic further. Also RoCE traffic can be mirrored to
	 * L2 driver.
	 */
	#define HWRM_VNIC_QCFG_OUTPUT_FLAGS_ROCE_MIRRORING_CAPABLE_VNIC_MODE \
		UINT32_C(0x40)
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_vnic_qcaps *
 *******************/


/* hwrm_vnic_qcaps_input (size:192b/24B) */
struct hwrm_vnic_qcaps_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_vnic_qcaps_output (size:192b/24B) */
struct hwrm_vnic_qcaps_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The maximum receive unit that is settable on a vnic. */
	uint16_t	mru;
	uint8_t	unused_0[2];
	uint32_t	flags;
	/* Unused. */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_UNUSED \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the capability of stripping VLAN in
	 * the RX path is supported on VNIC(s).
	 * If set to '0', then VLAN stripping capability is
	 * not supported on VNIC(s).
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_VLAN_STRIP_CAP \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the capability to buffer receive
	 * packets in the hardware until the host posts new receive buffers
	 * is supported on VNIC(s).
	 * If set to '0', then bd_stall capability is not supported
	 * on VNIC(s).
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_BD_STALL_CAP \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the capability to
	 * receive both RoCE and non-RoCE traffic on VNIC(s) is
	 * supported.
	 * If set to '0', then the capability to receive
	 * both RoCE and non-RoCE traffic on VNIC(s) is
	 * not supported.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_ROCE_DUAL_VNIC_CAP \
		UINT32_C(0x8)
	/*
	 * When this bit is set to '1', the capability to configure
	 * a VNIC to receive only RoCE traffic is supported.
	 * When this flag is set to '0', the VNIC capability to
	 * configure to receive only RoCE traffic is not supported.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_ROCE_ONLY_VNIC_CAP \
		UINT32_C(0x10)
	/*
	 * When this bit is set to '1', then the capability to enable
	 * a VNIC in a mode where RSS context without configuring
	 * RSS indirection table is supported (for RSS hash computation).
	 * When this bit is set to '0', then a VNIC can not be configured
	 * with a mode to enable RSS context without configuring RSS
	 * indirection table.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_RSS_DFLT_CR_CAP \
		UINT32_C(0x20)
	/*
	 * When this bit is '1', the capability to
	 * mirror the the RoCE traffic is supported.
	 * If set to '0', then the capability to mirror the
	 * RoCE traffic is not supported.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_ROCE_MIRRORING_CAPABLE_VNIC_CAP \
		UINT32_C(0x40)
	/*
	 * When this bit is '1', the outermost RSS hashing capability
	 * is supported. If set to '0', then the outermost RSS hashing
	 * capability is not supported.
	 */
	#define HWRM_VNIC_QCAPS_OUTPUT_FLAGS_OUTERMOST_RSS_CAP \
		UINT32_C(0x80)
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_vnic_tpa_cfg *
 *********************/


/* hwrm_vnic_tpa_cfg_input (size:320b/40B) */
struct hwrm_vnic_tpa_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) of
	 * non-tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_TPA \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) of
	 * tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_ENCAP_TPA \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) according
	 * to Windows Receive Segment Coalescing (RSC) rules.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_RSC_WND_UPDATE \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) according
	 * to Linux Generic Receive Offload (GRO) rules.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_GRO \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) for TCP
	 * packets with IP ECN set to non-zero.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_AGG_WITH_ECN \
		UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) for
	 * GRE tunneled TCP packets only if all packets have the
	 * same GRE sequence.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_AGG_WITH_SAME_GRE_SEQ \
		UINT32_C(0x20)
	/*
	 * When this bit is '1' and the GRO mode is enabled,
	 * the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) for
	 * TCP/IPv4 packets with consecutively increasing IPIDs.
	 * In other words, the last packet that is being
	 * aggregated to an already existing aggregation context
	 * shall have IPID 1 more than the IPID of the last packet
	 * that was aggregated in that aggregation context.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_GRO_IPID_CHECK \
		UINT32_C(0x40)
	/*
	 * When this bit is '1' and the GRO mode is enabled,
	 * the VNIC shall be configured to
	 * perform transparent packet aggregation (TPA) for
	 * TCP packets with the same TTL (IPv4) or Hop limit (IPv6)
	 * value.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_FLAGS_GRO_TTL_CHECK \
		UINT32_C(0x80)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the max_agg_segs field to be
	 * configured.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MAX_AGG_SEGS      UINT32_C(0x1)
	/*
	 * This bit must be '1' for the max_aggs field to be
	 * configured.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MAX_AGGS          UINT32_C(0x2)
	/*
	 * This bit must be '1' for the max_agg_timer field to be
	 * configured.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MAX_AGG_TIMER     UINT32_C(0x4)
	/*
	 * This bit must be '1' for the min_agg_len field to be
	 * configured.
	 */
	#define HWRM_VNIC_TPA_CFG_INPUT_ENABLES_MIN_AGG_LEN       UINT32_C(0x8)
	/* Logical vnic ID */
	uint16_t	vnic_id;
	/*
	 * This is the maximum number of TCP segments that can
	 * be aggregated (unit is Log2). Max value is 31.
	 */
	uint16_t	max_agg_segs;
	/* 1 segment */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_1   UINT32_C(0x0)
	/* 2 segments */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_2   UINT32_C(0x1)
	/* 4 segments */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_4   UINT32_C(0x2)
	/* 8 segments */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_8   UINT32_C(0x3)
	/* Any segment size larger than this is not valid */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_MAX UINT32_C(0x1f)
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_LAST \
		HWRM_VNIC_TPA_CFG_INPUT_MAX_AGG_SEGS_MAX
	/*
	 * This is the maximum number of aggregations this VNIC is
	 * allowed (unit is Log2). Max value is 7
	 */
	uint16_t	max_aggs;
	/* 1 aggregation */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_1   UINT32_C(0x0)
	/* 2 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_2   UINT32_C(0x1)
	/* 4 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_4   UINT32_C(0x2)
	/* 8 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_8   UINT32_C(0x3)
	/* 16 aggregations */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_16  UINT32_C(0x4)
	/* Any aggregation size larger than this is not valid */
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_MAX UINT32_C(0x7)
	#define HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_LAST \
		HWRM_VNIC_TPA_CFG_INPUT_MAX_AGGS_MAX
	uint8_t	unused_0[2];
	/*
	 * This is the maximum amount of time allowed for
	 * an aggregation context to complete after it was initiated.
	 */
	uint32_t	max_agg_timer;
	/*
	 * This is the minimum amount of payload length required to
	 * start an aggregation context.
	 */
	uint32_t	min_agg_len;
} __attribute__((packed));

/* hwrm_vnic_tpa_cfg_output (size:128b/16B) */
struct hwrm_vnic_tpa_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_vnic_tpa_qcfg *
 **********************/


/* hwrm_vnic_tpa_qcfg_input (size:192b/24B) */
struct hwrm_vnic_tpa_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Logical vnic ID */
	uint16_t	vnic_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_vnic_tpa_qcfg_output (size:256b/32B) */
struct hwrm_vnic_tpa_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/*
	 * When this bit is '1', the VNIC is configured to
	 * perform transparent packet aggregation (TPA) of
	 * non-tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_TPA \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * perform transparent packet aggregation (TPA) of
	 * tunneled TCP packets.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_ENCAP_TPA \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * perform transparent packet aggregation (TPA) according
	 * to Windows Receive Segment Coalescing (RSC) rules.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_RSC_WND_UPDATE \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * perform transparent packet aggregation (TPA) according
	 * to Linux Generic Receive Offload (GRO) rules.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_GRO \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * perform transparent packet aggregation (TPA) for TCP
	 * packets with IP ECN set to non-zero.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_AGG_WITH_ECN \
		UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * perform transparent packet aggregation (TPA) for
	 * GRE tunneled TCP packets only if all packets have the
	 * same GRE sequence.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_AGG_WITH_SAME_GRE_SEQ \
		UINT32_C(0x20)
	/*
	 * When this bit is '1' and the GRO mode is enabled,
	 * the VNIC is configured to
	 * perform transparent packet aggregation (TPA) for
	 * TCP/IPv4 packets with consecutively increasing IPIDs.
	 * In other words, the last packet that is being
	 * aggregated to an already existing aggregation context
	 * shall have IPID 1 more than the IPID of the last packet
	 * that was aggregated in that aggregation context.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_GRO_IPID_CHECK \
		UINT32_C(0x40)
	/*
	 * When this bit is '1' and the GRO mode is enabled,
	 * the VNIC is configured to
	 * perform transparent packet aggregation (TPA) for
	 * TCP packets with the same TTL (IPv4) or Hop limit (IPv6)
	 * value.
	 */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_FLAGS_GRO_TTL_CHECK \
		UINT32_C(0x80)
	/*
	 * This is the maximum number of TCP segments that can
	 * be aggregated (unit is Log2). Max value is 31.
	 */
	uint16_t	max_agg_segs;
	/* 1 segment */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_1   UINT32_C(0x0)
	/* 2 segments */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_2   UINT32_C(0x1)
	/* 4 segments */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_4   UINT32_C(0x2)
	/* 8 segments */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_8   UINT32_C(0x3)
	/* Any segment size larger than this is not valid */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_MAX UINT32_C(0x1f)
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_LAST \
		HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGG_SEGS_MAX
	/*
	 * This is the maximum number of aggregations this VNIC is
	 * allowed (unit is Log2). Max value is 7
	 */
	uint16_t	max_aggs;
	/* 1 aggregation */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_1   UINT32_C(0x0)
	/* 2 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_2   UINT32_C(0x1)
	/* 4 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_4   UINT32_C(0x2)
	/* 8 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_8   UINT32_C(0x3)
	/* 16 aggregations */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_16  UINT32_C(0x4)
	/* Any aggregation size larger than this is not valid */
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_MAX UINT32_C(0x7)
	#define HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_LAST \
		HWRM_VNIC_TPA_QCFG_OUTPUT_MAX_AGGS_MAX
	/*
	 * This is the maximum amount of time allowed for
	 * an aggregation context to complete after it was initiated.
	 */
	uint32_t	max_agg_timer;
	/*
	 * This is the minimum amount of payload length required to
	 * start an aggregation context.
	 */
	uint32_t	min_agg_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_vnic_rss_cfg *
 *********************/


/* hwrm_vnic_rss_cfg_input (size:384b/48B) */
struct hwrm_vnic_rss_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	hash_type;
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source and destination IPv4 addresses of IPv4
	 * packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_IPV4         UINT32_C(0x1)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv4 addresses and
	 * source/destination ports of TCP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_TCP_IPV4     UINT32_C(0x2)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv4 addresses and
	 * source/destination ports of UDP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_UDP_IPV4     UINT32_C(0x4)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source and destination IPv4 addresses of IPv6
	 * packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_IPV6         UINT32_C(0x8)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv6 addresses and
	 * source/destination ports of TCP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_TCP_IPV6     UINT32_C(0x10)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv6 addresses and
	 * source/destination ports of UDP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_TYPE_UDP_IPV6     UINT32_C(0x20)
	/* VNIC ID of VNIC associated with RSS table being configured. */
	uint16_t	vnic_id;
	/*
	 * Specifies which VNIC ring table pair to configure.
	 * Valid values range from 0 to 7.
	 */
	uint8_t	ring_table_pair_index;
	/* Flags to specify different RSS hash modes. */
	uint8_t	hash_mode_flags;
	/*
	 * When this bit is '1', it indicates using current RSS
	 * hash mode setting configured in the device.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_MODE_FLAGS_DEFAULT \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over innermost 4 tuples {l3.src, l3.dest,
	 * l4.src, l4.dest} for tunnel packets. For none-tunnel
	 * packets, the RSS hash is computed over the normal
	 * src/dest l3 and src/dest l4 headers.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_MODE_FLAGS_INNERMOST_4 \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over innermost 2 tuples {l3.src, l3.dest} for
	 * tunnel packets. For none-tunnel packets, the RSS hash is
	 * computed over the normal src/dest l3 headers.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_MODE_FLAGS_INNERMOST_2 \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over outermost 4 tuples {t_l3.src, t_l3.dest,
	 * t_l4.src, t_l4.dest} for tunnel packets. For none-tunnel
	 * packets, the RSS hash is computed over the normal
	 * src/dest l3 and src/dest l4 headers.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_MODE_FLAGS_OUTERMOST_4 \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over outermost 2 tuples {t_l3.src, t_l3.dest} for
	 * tunnel packets. For none-tunnel packets, the RSS hash is
	 * computed over the normal src/dest l3 headers.
	 */
	#define HWRM_VNIC_RSS_CFG_INPUT_HASH_MODE_FLAGS_OUTERMOST_2 \
		UINT32_C(0x10)
	/* This is the address for rss ring group table */
	uint64_t	ring_grp_tbl_addr;
	/* This is the address for rss hash key table */
	uint64_t	hash_key_tbl_addr;
	/* Index to the rss indirection table. */
	uint16_t	rss_ctx_idx;
	uint8_t	unused_1[6];
} __attribute__((packed));

/* hwrm_vnic_rss_cfg_output (size:128b/16B) */
struct hwrm_vnic_rss_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_vnic_rss_qcfg *
 **********************/


/* hwrm_vnic_rss_qcfg_input (size:192b/24B) */
struct hwrm_vnic_rss_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Index to the rss indirection table. */
	uint16_t	rss_ctx_idx;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_vnic_rss_qcfg_output (size:512b/64B) */
struct hwrm_vnic_rss_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	hash_type;
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source and destination IPv4 addresses of IPv4
	 * packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_IPV4         UINT32_C(0x1)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv4 addresses and
	 * source/destination ports of TCP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_TCP_IPV4     UINT32_C(0x2)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv4 addresses and
	 * source/destination ports of UDP/IPv4 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_UDP_IPV4     UINT32_C(0x4)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source and destination IPv4 addresses of IPv6
	 * packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_IPV6         UINT32_C(0x8)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv6 addresses and
	 * source/destination ports of TCP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_TCP_IPV6     UINT32_C(0x10)
	/*
	 * When this bit is '1', the RSS hash shall be computed
	 * over source/destination IPv6 addresses and
	 * source/destination ports of UDP/IPv6 packets.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_TYPE_UDP_IPV6     UINT32_C(0x20)
	uint8_t	unused_0[4];
	/* This is the value of rss hash key */
	uint32_t	hash_key[10];
	/* Flags to specify different RSS hash modes. */
	uint8_t	hash_mode_flags;
	/*
	 * When this bit is '1', it indicates using current RSS
	 * hash mode setting configured in the device.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_MODE_FLAGS_DEFAULT \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over innermost 4 tuples {l3.src, l3.dest,
	 * l4.src, l4.dest} for tunnel packets. For none-tunnel
	 * packets, the RSS hash is computed over the normal
	 * src/dest l3 and src/dest l4 headers.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_MODE_FLAGS_INNERMOST_4 \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over innermost 2 tuples {l3.src, l3.dest} for
	 * tunnel packets. For none-tunnel packets, the RSS hash is
	 * computed over the normal src/dest l3 headers.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_MODE_FLAGS_INNERMOST_2 \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over outermost 4 tuples {t_l3.src, t_l3.dest,
	 * t_l4.src, t_l4.dest} for tunnel packets. For none-tunnel
	 * packets, the RSS hash is computed over the normal
	 * src/dest l3 and src/dest l4 headers.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_MODE_FLAGS_OUTERMOST_4 \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', it indicates requesting support of
	 * RSS hashing over outermost 2 tuples {t_l3.src, t_l3.dest} for
	 * tunnel packets. For none-tunnel packets, the RSS hash is
	 * computed over the normal src/dest l3 headers.
	 */
	#define HWRM_VNIC_RSS_QCFG_OUTPUT_HASH_MODE_FLAGS_OUTERMOST_2 \
		UINT32_C(0x10)
	uint8_t	unused_1[6];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_vnic_plcmodes_cfg *
 **************************/


/* hwrm_vnic_plcmodes_cfg_input (size:320b/40B) */
struct hwrm_vnic_plcmodes_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * When this bit is '1', the VNIC shall be configured to
	 * use regular placement algorithm.
	 * By default, the regular placement algorithm shall be
	 * enabled on the VNIC.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_REGULAR_PLACEMENT \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC shall be configured
	 * use the jumbo placement algorithm.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_JUMBO_PLACEMENT \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC shall be configured
	 * to enable Header-Data split for IPv4 packets according
	 * to the following rules:
	 * # If the packet is identified as TCP/IPv4, then the
	 * packet is split at the beginning of the TCP payload.
	 * # If the packet is identified as UDP/IPv4, then the
	 * packet is split at the beginning of UDP payload.
	 * # If the packet is identified as non-TCP and non-UDP
	 * IPv4 packet, then the packet is split at the beginning
	 * of the upper layer protocol header carried in the IPv4
	 * packet.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_IPV4 \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC shall be configured
	 * to enable Header-Data split for IPv6 packets according
	 * to the following rules:
	 * # If the packet is identified as TCP/IPv6, then the
	 * packet is split at the beginning of the TCP payload.
	 * # If the packet is identified as UDP/IPv6, then the
	 * packet is split at the beginning of UDP payload.
	 * # If the packet is identified as non-TCP and non-UDP
	 * IPv6 packet, then the packet is split at the beginning
	 * of the upper layer protocol header carried in the IPv6
	 * packet.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_IPV6 \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC shall be configured
	 * to enable Header-Data split for FCoE packets at the
	 * beginning of FC payload.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_FCOE \
		UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC shall be configured
	 * to enable Header-Data split for RoCE packets at the
	 * beginning of RoCE payload (after BTH/GRH headers).
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_FLAGS_HDS_ROCE \
		UINT32_C(0x20)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the jumbo_thresh_valid field to be
	 * configured.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_ENABLES_JUMBO_THRESH_VALID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the hds_offset_valid field to be
	 * configured.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_ENABLES_HDS_OFFSET_VALID \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the hds_threshold_valid field to be
	 * configured.
	 */
	#define HWRM_VNIC_PLCMODES_CFG_INPUT_ENABLES_HDS_THRESHOLD_VALID \
		UINT32_C(0x4)
	/* Logical vnic ID */
	uint32_t	vnic_id;
	/*
	 * When jumbo placement algorithm is enabled, this value
	 * is used to determine the threshold for jumbo placement.
	 * Packets with length larger than this value will be
	 * placed according to the jumbo placement algorithm.
	 */
	uint16_t	jumbo_thresh;
	/*
	 * This value is used to determine the offset into
	 * packet buffer where the split data (payload) will be
	 * placed according to one of of HDS placement algorithm.
	 *
	 * The lengths of packet buffers provided for split data
	 * shall be larger than this value.
	 */
	uint16_t	hds_offset;
	/*
	 * When one of the HDS placement algorithm is enabled, this
	 * value is used to determine the threshold for HDS
	 * placement.
	 * Packets with length larger than this value will be
	 * placed according to the HDS placement algorithm.
	 * This value shall be in multiple of 4 bytes.
	 */
	uint16_t	hds_threshold;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_vnic_plcmodes_cfg_output (size:128b/16B) */
struct hwrm_vnic_plcmodes_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_vnic_plcmodes_qcfg *
 ***************************/


/* hwrm_vnic_plcmodes_qcfg_input (size:192b/24B) */
struct hwrm_vnic_plcmodes_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Logical vnic ID */
	uint32_t	vnic_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_vnic_plcmodes_qcfg_output (size:192b/24B) */
struct hwrm_vnic_plcmodes_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint32_t	flags;
	/*
	 * When this bit is '1', the VNIC is configured to
	 * use regular placement algorithm.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_REGULAR_PLACEMENT \
		UINT32_C(0x1)
	/*
	 * When this bit is '1', the VNIC is configured to
	 * use the jumbo placement algorithm.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_JUMBO_PLACEMENT \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the VNIC is configured
	 * to enable Header-Data split for IPv4 packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_IPV4 \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the VNIC is configured
	 * to enable Header-Data split for IPv6 packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_IPV6 \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', the VNIC is configured
	 * to enable Header-Data split for FCoE packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_FCOE \
		UINT32_C(0x10)
	/*
	 * When this bit is '1', the VNIC is configured
	 * to enable Header-Data split for RoCE packets.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_HDS_ROCE \
		UINT32_C(0x20)
	/*
	 * When this bit is '1', the VNIC is configured
	 * to be the default VNIC of the requesting function.
	 */
	#define HWRM_VNIC_PLCMODES_QCFG_OUTPUT_FLAGS_DFLT_VNIC \
		UINT32_C(0x40)
	/*
	 * When jumbo placement algorithm is enabled, this value
	 * is used to determine the threshold for jumbo placement.
	 * Packets with length larger than this value will be
	 * placed according to the jumbo placement algorithm.
	 */
	uint16_t	jumbo_thresh;
	/*
	 * This value is used to determine the offset into
	 * packet buffer where the split data (payload) will be
	 * placed according to one of of HDS placement algorithm.
	 *
	 * The lengths of packet buffers provided for split data
	 * shall be larger than this value.
	 */
	uint16_t	hds_offset;
	/*
	 * When one of the HDS placement algorithm is enabled, this
	 * value is used to determine the threshold for HDS
	 * placement.
	 * Packets with length larger than this value will be
	 * placed according to the HDS placement algorithm.
	 * This value shall be in multiple of 4 bytes.
	 */
	uint16_t	hds_threshold;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************************
 * hwrm_vnic_rss_cos_lb_ctx_alloc *
 **********************************/


/* hwrm_vnic_rss_cos_lb_ctx_alloc_input (size:128b/16B) */
struct hwrm_vnic_rss_cos_lb_ctx_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_vnic_rss_cos_lb_ctx_alloc_output (size:128b/16B) */
struct hwrm_vnic_rss_cos_lb_ctx_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* rss_cos_lb_ctx_id is 16 b */
	uint16_t	rss_cos_lb_ctx_id;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************************
 * hwrm_vnic_rss_cos_lb_ctx_free *
 *********************************/


/* hwrm_vnic_rss_cos_lb_ctx_free_input (size:192b/24B) */
struct hwrm_vnic_rss_cos_lb_ctx_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* rss_cos_lb_ctx_id is 16 b */
	uint16_t	rss_cos_lb_ctx_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_vnic_rss_cos_lb_ctx_free_output (size:128b/16B) */
struct hwrm_vnic_rss_cos_lb_ctx_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_ring_alloc *
 *******************/


/* hwrm_ring_alloc_input (size:640b/80B) */
struct hwrm_ring_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the ring_arb_cfg field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RING_ARB_CFG \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the stat_ctx_id_valid field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_STAT_CTX_ID_VALID \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the max_bw_valid field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_MAX_BW_VALID \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the rx_ring_id field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RX_RING_ID_VALID \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the nq_ring_id field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_NQ_RING_ID_VALID \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the rx_buf_size field to be
	 * configured.
	 */
	#define HWRM_RING_ALLOC_INPUT_ENABLES_RX_BUF_SIZE_VALID \
		UINT32_C(0x100)
	/* Ring Type. */
	uint8_t	ring_type;
	/* L2 Completion Ring (CR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_L2_CMPL   UINT32_C(0x0)
	/* TX Ring (TR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_TX        UINT32_C(0x1)
	/* RX Ring (RR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_RX        UINT32_C(0x2)
	/* RoCE Notification Completion Ring (ROCE_CR) */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_ROCE_CMPL UINT32_C(0x3)
	/* RX Aggregation Ring */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_RX_AGG    UINT32_C(0x4)
	/* Notification Queue */
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_NQ        UINT32_C(0x5)
	#define HWRM_RING_ALLOC_INPUT_RING_TYPE_LAST \
		HWRM_RING_ALLOC_INPUT_RING_TYPE_NQ
	uint8_t	unused_0[3];
	/*
	 * This value is a pointer to the page table for the
	 * Ring.
	 */
	uint64_t	page_tbl_addr;
	/* First Byte Offset of the first entry in the first page. */
	uint32_t	fbo;
	/*
	 * Actual page size in 2^page_size. The supported range is increments
	 * in powers of 2 from 16 bytes to 1GB.
	 * - 4 = 16 B
	 *     Page size is 16 B.
	 * - 12 = 4 KB
	 *     Page size is 4 KB.
	 * - 13 = 8 KB
	 *     Page size is 8 KB.
	 * - 16 = 64 KB
	 *     Page size is 64 KB.
	 * - 21 = 2 MB
	 *     Page size is 2 MB.
	 * - 22 = 4 MB
	 *     Page size is 4 MB.
	 * - 30 = 1 GB
	 *     Page size is 1 GB.
	 */
	uint8_t	page_size;
	/*
	 * This value indicates the depth of page table.
	 * For this version of the specification, value other than 0 or
	 * 1 shall be considered as an invalid value.
	 * When the page_tbl_depth = 0, then it is treated as a
	 * special case with the following.
	 * 1. FBO and page size fields are not valid.
	 * 2. page_tbl_addr is the physical address of the first
	 *    element of the ring.
	 */
	uint8_t	page_tbl_depth;
	uint8_t	unused_1[2];
	/*
	 * Number of 16B units in the ring.  Minimum size for
	 * a ring is 16 16B entries.
	 */
	uint32_t	length;
	/*
	 * Logical ring number for the ring to be allocated.
	 * This value determines the position in the doorbell
	 * area where the update to the ring will be made.
	 *
	 * For completion rings, this value is also the MSI-X
	 * vector number for the function the completion ring is
	 * associated with.
	 */
	uint16_t	logical_id;
	/*
	 * This field is used only when ring_type is a TX ring.
	 * This value indicates what completion ring the TX ring
	 * is associated with.
	 */
	uint16_t	cmpl_ring_id;
	/*
	 * This field is used only when ring_type is a TX ring.
	 * This value indicates what CoS queue the TX ring
	 * is associated with.
	 */
	uint16_t	queue_id;
	/*
	 * When allocating a Rx ring or Rx aggregation ring, this field
	 * specifies the size of the buffer descriptors posted to the ring.
	 */
	uint16_t	rx_buf_size;
	/*
	 * When allocating an Rx aggregation ring, this field
	 * specifies the associated Rx ring ID.
	 */
	uint16_t	rx_ring_id;
	/*
	 * When allocating a completion ring, this field
	 * specifies the associated NQ ring ID.
	 */
	uint16_t	nq_ring_id;
	/*
	 * This field is used only when ring_type is a TX ring.
	 * This field is used to configure arbitration related
	 * parameters for a TX ring.
	 */
	uint16_t	ring_arb_cfg;
	/* Arbitration policy used for the ring. */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_MASK \
		UINT32_C(0xf)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_SFT       0
	/*
	 * Use strict priority for the TX ring.
	 * Priority value is specified in arb_policy_param
	 */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_SP \
		UINT32_C(0x1)
	/*
	 * Use weighted fair queue arbitration for the TX ring.
	 * Weight is specified in arb_policy_param
	 */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_WFQ \
		UINT32_C(0x2)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_LAST \
		HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_WFQ
	/* Reserved field. */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_RSVD_MASK \
		UINT32_C(0xf0)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_RSVD_SFT             4
	/*
	 * Arbitration policy specific parameter.
	 * # For strict priority arbitration policy, this field
	 * represents a priority value. If set to 0, then the priority
	 * is not specified and the HWRM is allowed to select
	 * any priority for this TX ring.
	 * # For weighted fair queue arbitration policy, this field
	 * represents a weight value. If set to 0, then the weight
	 * is not specified and the HWRM is allowed to select
	 * any weight for this TX ring.
	 */
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_PARAM_MASK \
		UINT32_C(0xff00)
	#define HWRM_RING_ALLOC_INPUT_RING_ARB_CFG_ARB_POLICY_PARAM_SFT 8
	uint16_t	unused_3;
	/*
	 * This field is reserved for the future use.
	 * It shall be set to 0.
	 */
	uint32_t	reserved3;
	/*
	 * This field is used only when ring_type is a TX ring.
	 * This input indicates what statistics context this ring
	 * should be associated with.
	 */
	uint32_t	stat_ctx_id;
	/*
	 * This field is reserved for the future use.
	 * It shall be set to 0.
	 */
	uint32_t	reserved4;
	/*
	 * This field is used only when ring_type is a TX ring
	 * to specify maximum BW allocated to the TX ring.
	 * The HWRM will translate this value into byte counter and
	 * time interval used for this ring inside the device.
	 */
	uint32_t	max_bw;
	/* The bandwidth value. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_SFT              0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_LAST \
		HWRM_RING_ALLOC_INPUT_MAX_BW_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_SFT         29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_LAST \
		HWRM_RING_ALLOC_INPUT_MAX_BW_BW_VALUE_UNIT_INVALID
	/*
	 * This field is used only when ring_type is a Completion ring.
	 * This value indicates what interrupt mode should be used
	 * on this completion ring.
	 * Note: In the legacy interrupt mode, no more than 16
	 * completion rings are allowed.
	 */
	uint8_t	int_mode;
	/* Legacy INTA */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_LEGACY UINT32_C(0x0)
	/* Reserved */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_RSVD   UINT32_C(0x1)
	/* MSI-X */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_MSIX   UINT32_C(0x2)
	/* No Interrupt - Polled mode */
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_POLL   UINT32_C(0x3)
	#define HWRM_RING_ALLOC_INPUT_INT_MODE_LAST \
		HWRM_RING_ALLOC_INPUT_INT_MODE_POLL
	uint8_t	unused_4[3];
} __attribute__((packed));

/* hwrm_ring_alloc_output (size:128b/16B) */
struct hwrm_ring_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Physical number of ring allocated.
	 * This value shall be unique for a ring type.
	 */
	uint16_t	ring_id;
	/* Logical number of ring allocated. */
	uint16_t	logical_ring_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_ring_free *
 ******************/


/* hwrm_ring_free_input (size:192b/24B) */
struct hwrm_ring_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Ring Type. */
	uint8_t	ring_type;
	/* L2 Completion Ring (CR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_L2_CMPL   UINT32_C(0x0)
	/* TX Ring (TR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_TX        UINT32_C(0x1)
	/* RX Ring (RR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_RX        UINT32_C(0x2)
	/* RoCE Notification Completion Ring (ROCE_CR) */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_ROCE_CMPL UINT32_C(0x3)
	/* RX Aggregation Ring */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_RX_AGG    UINT32_C(0x4)
	/* Notification Queue */
	#define HWRM_RING_FREE_INPUT_RING_TYPE_NQ        UINT32_C(0x5)
	#define HWRM_RING_FREE_INPUT_RING_TYPE_LAST \
		HWRM_RING_FREE_INPUT_RING_TYPE_NQ
	uint8_t	unused_0;
	/* Physical number of ring allocated. */
	uint16_t	ring_id;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_ring_free_output (size:128b/16B) */
struct hwrm_ring_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************************
 * hwrm_ring_cmpl_ring_qaggint_params *
 **************************************/


/* hwrm_ring_cmpl_ring_qaggint_params_input (size:192b/24B) */
struct hwrm_ring_cmpl_ring_qaggint_params_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Physical number of completion ring. */
	uint16_t	ring_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_ring_cmpl_ring_qaggint_params_output (size:256b/32B) */
struct hwrm_ring_cmpl_ring_qaggint_params_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint16_t	flags;
	/*
	 * When this bit is set to '1', interrupt max
	 * timer is reset whenever a completion is received.
	 */
	#define HWRM_RING_CMPL_RING_QAGGINT_PARAMS_OUTPUT_FLAGS_TIMER_RESET \
		UINT32_C(0x1)
	/*
	 * When this bit is set to '1', ring idle mode
	 * aggregation will be enabled.
	 */
	#define HWRM_RING_CMPL_RING_QAGGINT_PARAMS_OUTPUT_FLAGS_RING_IDLE \
		UINT32_C(0x2)
	/*
	 * Number of completions to aggregate before DMA
	 * during the normal mode.
	 */
	uint16_t	num_cmpl_dma_aggr;
	/*
	 * Number of completions to aggregate before DMA
	 * during the interrupt mode.
	 */
	uint16_t	num_cmpl_dma_aggr_during_int;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before
	 * DMA during the normal mode (not in interrupt mode).
	 */
	uint16_t	cmpl_aggr_dma_tmr;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before
	 * DMA during the interrupt mode.
	 */
	uint16_t	cmpl_aggr_dma_tmr_during_int;
	/* Minimum time (in unit of 80-nsec) between two interrupts. */
	uint16_t	int_lat_tmr_min;
	/*
	 * Maximum wait time (in unit of 80-nsec) spent aggregating
	 * completions before signaling the interrupt after the
	 * interrupt is enabled.
	 */
	uint16_t	int_lat_tmr_max;
	/*
	 * Minimum number of completions aggregated before signaling
	 * an interrupt.
	 */
	uint16_t	num_cmpl_aggr_int;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************************
 * hwrm_ring_cmpl_ring_cfg_aggint_params *
 *****************************************/


/* hwrm_ring_cmpl_ring_cfg_aggint_params_input (size:320b/40B) */
struct hwrm_ring_cmpl_ring_cfg_aggint_params_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Physical number of completion ring. */
	uint16_t	ring_id;
	uint16_t	flags;
	/*
	 * When this bit is set to '1', interrupt latency max
	 * timer is reset whenever a completion is received.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_FLAGS_TIMER_RESET \
		UINT32_C(0x1)
	/*
	 * When this bit is set to '1', ring idle mode
	 * aggregation will be enabled.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_FLAGS_RING_IDLE \
		UINT32_C(0x2)
	/*
	 * Set this flag to 1 when configuring parameters on a
	 * notification queue. Set this flag to 0 when configuring
	 * parameters on a completion queue.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_FLAGS_IS_NQ \
		UINT32_C(0x4)
	/*
	 * Number of completions to aggregate before DMA
	 * during the normal mode.
	 */
	uint16_t	num_cmpl_dma_aggr;
	/*
	 * Number of completions to aggregate before DMA
	 * during the interrupt mode.
	 */
	uint16_t	num_cmpl_dma_aggr_during_int;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before
	 * DMA during the normal mode (not in interrupt mode).
	 */
	uint16_t	cmpl_aggr_dma_tmr;
	/*
	 * Timer in unit of 80-nsec used to aggregate completions before
	 * DMA during the interrupt mode.
	 */
	uint16_t	cmpl_aggr_dma_tmr_during_int;
	/* Minimum time (in unit of 80-nsec) between two interrupts. */
	uint16_t	int_lat_tmr_min;
	/*
	 * Maximum wait time (in unit of 80-nsec) spent aggregating
	 * cmpls before signaling the interrupt after the
	 * interrupt is enabled.
	 */
	uint16_t	int_lat_tmr_max;
	/*
	 * Minimum number of completions aggregated before signaling
	 * an interrupt.
	 */
	uint16_t	num_cmpl_aggr_int;
	/*
	 * Bitfield that indicates which parameters are to be applied. Only
	 * required when configuring devices with notification queues, and
	 * used in that case to set certain parameters on completion queues
	 * and others on notification queues.
	 */
	uint16_t	enables;
	/*
	 * This bit must be '1' for the num_cmpl_dma_aggr field to be
	 * configured.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_ENABLES_NUM_CMPL_DMA_AGGR \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the num_cmpl_dma_aggr_during_int field to be
	 * configured.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_ENABLES_NUM_CMPL_DMA_AGGR_DURING_INT \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the cmpl_aggr_dma_tmr field to be
	 * configured.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_ENABLES_CMPL_AGGR_DMA_TMR \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the int_lat_tmr_min field to be
	 * configured.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_ENABLES_INT_LAT_TMR_MIN \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the int_lat_tmr_max field to be
	 * configured.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_ENABLES_INT_LAT_TMR_MAX \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the num_cmpl_aggr_int field to be
	 * configured.
	 */
	#define HWRM_RING_CMPL_RING_CFG_AGGINT_PARAMS_INPUT_ENABLES_NUM_CMPL_AGGR_INT \
		UINT32_C(0x20)
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_ring_cmpl_ring_cfg_aggint_params_output (size:128b/16B) */
struct hwrm_ring_cmpl_ring_cfg_aggint_params_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************
 * hwrm_ring_reset *
 *******************/


/* hwrm_ring_reset_input (size:192b/24B) */
struct hwrm_ring_reset_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Ring Type. */
	uint8_t	ring_type;
	/* L2 Completion Ring (CR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_L2_CMPL   UINT32_C(0x0)
	/* TX Ring (TR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_TX        UINT32_C(0x1)
	/* RX Ring (RR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_RX        UINT32_C(0x2)
	/* RoCE Notification Completion Ring (ROCE_CR) */
	#define HWRM_RING_RESET_INPUT_RING_TYPE_ROCE_CMPL UINT32_C(0x3)
	#define HWRM_RING_RESET_INPUT_RING_TYPE_LAST \
		HWRM_RING_RESET_INPUT_RING_TYPE_ROCE_CMPL
	uint8_t	unused_0;
	/* Physical number of the ring. */
	uint16_t	ring_id;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_ring_reset_output (size:128b/16B) */
struct hwrm_ring_reset_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_ring_grp_alloc *
 ***********************/


/* hwrm_ring_grp_alloc_input (size:192b/24B) */
struct hwrm_ring_grp_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value identifies the CR associated with the ring
	 * group.
	 */
	uint16_t	cr;
	/*
	 * This value identifies the main RR associated with the ring
	 * group.
	 */
	uint16_t	rr;
	/*
	 * This value identifies the aggregation RR associated with
	 * the ring group.  If this value is 0xFF... (All Fs), then no
	 * Aggregation ring will be set.
	 */
	uint16_t	ar;
	/*
	 * This value identifies the statistics context associated
	 * with the ring group.
	 */
	uint16_t	sc;
} __attribute__((packed));

/* hwrm_ring_grp_alloc_output (size:128b/16B) */
struct hwrm_ring_grp_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This is the ring group ID value.  Use this value to program
	 * the default ring group for the VNIC or as table entries
	 * in an RSS/COS context.
	 */
	uint32_t	ring_group_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_ring_grp_free *
 **********************/


/* hwrm_ring_grp_free_input (size:192b/24B) */
struct hwrm_ring_grp_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This is the ring group ID value. */
	uint32_t	ring_group_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_ring_grp_free_output (size:128b/16B) */
struct hwrm_ring_grp_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_cfa_l2_filter_alloc *
 ****************************/


/* hwrm_cfa_l2_filter_alloc_input (size:768b/96B) */
struct hwrm_cfa_l2_filter_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH \
		UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_TX \
		UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_RX \
		UINT32_C(0x1)
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_PATH_RX
	/* Setting of this flag indicates the applicability to the loopback path. */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_LOOPBACK \
		UINT32_C(0x2)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_DROP \
		UINT32_C(0x4)
	/*
	 * If this flag is set, all t_l2_* fields are invalid
	 * and they should not be specified.
	 * If this flag is set, then l2_* fields refer to
	 * fields of outermost L2 header.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_FLAGS_OUTERMOST \
		UINT32_C(0x8)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the l2_addr field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_ADDR \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the l2_addr_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_ADDR_MASK \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the l2_ovlan field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_OVLAN \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the l2_ovlan_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_OVLAN_MASK \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the l2_ivlan field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_IVLAN \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the l2_ivlan_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_L2_IVLAN_MASK \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the t_l2_addr field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_ADDR \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the t_l2_addr_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_ADDR_MASK \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the t_l2_ovlan field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_OVLAN \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the t_l2_ovlan_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_OVLAN_MASK \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the t_l2_ivlan field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_IVLAN \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the t_l2_ivlan_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_T_L2_IVLAN_MASK \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the src_type field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_SRC_TYPE \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the src_id field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_SRC_ID \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the tunnel_type field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_DST_ID \
		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID \
		UINT32_C(0x10000)
	/*
	 * This value sets the match value for the L2 MAC address.
	 * Destination MAC address for RX path.
	 * Source MAC address for TX path.
	 */
	uint8_t	l2_addr[6];
	uint8_t	unused_0[2];
	/*
	 * This value sets the mask value for the L2 address.
	 * A value of 0 will mask the corresponding bit from
	 * compare.
	 */
	uint8_t	l2_addr_mask[6];
	/* This value sets VLAN ID value for outer VLAN. */
	uint16_t	l2_ovlan;
	/*
	 * This value sets the mask value for the ovlan id.
	 * A value of 0 will mask the corresponding bit from
	 * compare.
	 */
	uint16_t	l2_ovlan_mask;
	/* This value sets VLAN ID value for inner VLAN. */
	uint16_t	l2_ivlan;
	/*
	 * This value sets the mask value for the ivlan id.
	 * A value of 0 will mask the corresponding bit from
	 * compare.
	 */
	uint16_t	l2_ivlan_mask;
	uint8_t	unused_1[2];
	/*
	 * This value sets the match value for the tunnel
	 * L2 MAC address.
	 * Destination MAC address for RX path.
	 * Source MAC address for TX path.
	 */
	uint8_t	t_l2_addr[6];
	uint8_t	unused_2[2];
	/*
	 * This value sets the mask value for the tunnel L2
	 * address.
	 * A value of 0 will mask the corresponding bit from
	 * compare.
	 */
	uint8_t	t_l2_addr_mask[6];
	/* This value sets VLAN ID value for tunnel outer VLAN. */
	uint16_t	t_l2_ovlan;
	/*
	 * This value sets the mask value for the tunnel ovlan id.
	 * A value of 0 will mask the corresponding bit from
	 * compare.
	 */
	uint16_t	t_l2_ovlan_mask;
	/* This value sets VLAN ID value for tunnel inner VLAN. */
	uint16_t	t_l2_ivlan;
	/*
	 * This value sets the mask value for the tunnel ivlan id.
	 * A value of 0 will mask the corresponding bit from
	 * compare.
	 */
	uint16_t	t_l2_ivlan_mask;
	/* This value identifies the type of source of the packet. */
	uint8_t	src_type;
	/* Network port */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_NPORT UINT32_C(0x0)
	/* Physical function */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_PF    UINT32_C(0x1)
	/* Virtual function */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_VF    UINT32_C(0x2)
	/* Virtual NIC of a function */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_VNIC  UINT32_C(0x3)
	/* Embedded processor for CFA management */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_KONG  UINT32_C(0x4)
	/* Embedded processor for OOB management */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_APE   UINT32_C(0x5)
	/* Embedded processor for RoCE */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_BONO  UINT32_C(0x6)
	/* Embedded processor for network proxy functions */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_TANG  UINT32_C(0x7)
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_LAST \
		HWRM_CFA_L2_FILTER_ALLOC_INPUT_SRC_TYPE_TANG
	uint8_t	unused_3;
	/*
	 * This value is the id of the source.
	 * For a network port, it represents port_id.
	 * For a physical function, it represents fid.
	 * For a virtual function, it represents vf_id.
	 * For a vnic, it represents vnic_id.
	 * For embedded processors, this id is not valid.
	 *
	 * Notes:
	 * 1. The function ID is implied if it src_id is
	 *    not provided for a src_type that is either
	 */
	uint32_t	src_id;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Any tunneled traffic */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_L2_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL
	uint8_t	unused_4;
	/*
	 * If set, this value shall represent the
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path and network port id of the destination port for
	 * the TX path.
	 */
	uint16_t	dst_id;
	/*
	 * Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint16_t	mirror_vnic_id;
	/*
	 * This hint is provided to help in placing
	 * the filter in the filter table.
	 */
	uint8_t	pri_hint;
	/* No preference */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_NO_PREFER \
		UINT32_C(0x0)
	/* Above the given filter */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_ABOVE_FILTER \
		UINT32_C(0x1)
	/* Below the given filter */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_BELOW_FILTER \
		UINT32_C(0x2)
	/* As high as possible */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_MAX \
		UINT32_C(0x3)
	/* As low as possible */
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_MIN \
		UINT32_C(0x4)
	#define HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_LAST \
		HWRM_CFA_L2_FILTER_ALLOC_INPUT_PRI_HINT_MIN
	uint8_t	unused_5;
	uint32_t	unused_6;
	/*
	 * This is the ID of the filter that goes along with
	 * the pri_hint.
	 *
	 * This field is valid only for the following values.
	 * 1 - Above the given filter
	 * 2 - Below the given filter
	 */
	uint64_t	l2_filter_id_hint;
} __attribute__((packed));

/* hwrm_cfa_l2_filter_alloc_output (size:192b/24B) */
struct hwrm_cfa_l2_filter_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint64_t	l2_filter_id;
	/*
	 * This is the ID of the flow associated with this
	 * filter.
	 * This value shall be used to match and associate the
	 * flow identifier returned in completion records.
	 * A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint32_t	flow_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_cfa_l2_filter_free *
 ***************************/


/* hwrm_cfa_l2_filter_free_input (size:192b/24B) */
struct hwrm_cfa_l2_filter_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint64_t	l2_filter_id;
} __attribute__((packed));

/* hwrm_cfa_l2_filter_free_output (size:128b/16B) */
struct hwrm_cfa_l2_filter_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_cfa_l2_filter_cfg *
 **************************/


/* hwrm_cfa_l2_filter_cfg_input (size:320b/40B) */
struct hwrm_cfa_l2_filter_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_TX    UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_RX    UINT32_C(0x1)
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_PATH_RX
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_FLAGS_DROP     UINT32_C(0x2)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_ENABLES_DST_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the new_mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_L2_FILTER_CFG_INPUT_ENABLES_NEW_MIRROR_VNIC_ID \
		UINT32_C(0x2)
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint64_t	l2_filter_id;
	/*
	 * If set, this value shall represent the
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path and network port id of the destination port for
	 * the TX path.
	 */
	uint32_t	dst_id;
	/*
	 * New Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint32_t	new_mirror_vnic_id;
} __attribute__((packed));

/* hwrm_cfa_l2_filter_cfg_output (size:128b/16B) */
struct hwrm_cfa_l2_filter_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_cfa_l2_set_rx_mask *
 ***************************/


/* hwrm_cfa_l2_set_rx_mask_input (size:448b/56B) */
struct hwrm_cfa_l2_set_rx_mask_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* VNIC ID */
	uint32_t	vnic_id;
	uint32_t	mask;
	/*
	 * When this bit is '1', the function is requested to accept
	 * multi-cast packets specified by the multicast addr table.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_MCAST \
		UINT32_C(0x2)
	/*
	 * When this bit is '1', the function is requested to accept
	 * all multi-cast packets.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_ALL_MCAST \
		UINT32_C(0x4)
	/*
	 * When this bit is '1', the function is requested to accept
	 * broadcast packets.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_BCAST \
		UINT32_C(0x8)
	/*
	 * When this bit is '1', the function is requested to be
	 * put in the promiscuous mode.
	 *
	 * The HWRM should accept any function to set up
	 * promiscuous mode.
	 *
	 * The HWRM shall follow the semantics below for the
	 * promiscuous mode support.
	 * # When partitioning is not enabled on a port
	 * (i.e. single PF on the port), then the PF shall
	 * be allowed to be in the promiscuous mode. When the
	 * PF is in the promiscuous mode, then it shall
	 * receive all host bound traffic on that port.
	 * # When partitioning is enabled on a port
	 * (i.e. multiple PFs per port) and a PF on that
	 * port is in the promiscuous mode, then the PF
	 * receives all traffic within that partition as
	 * identified by a unique identifier for the
	 * PF (e.g. S-Tag). If a unique outer VLAN
	 * for the PF is specified, then the setting of
	 * promiscuous mode on that PF shall result in the
	 * PF receiving all host bound traffic with matching
	 * outer VLAN.
	 * # A VF shall can be set in the promiscuous mode.
	 * In the promiscuous mode, the VF does not receive any
	 * traffic unless a unique outer VLAN for the
	 * VF is specified. If a unique outer VLAN
	 * for the VF is specified, then the setting of
	 * promiscuous mode on that VF shall result in the
	 * VF receiving all host bound traffic with the
	 * matching outer VLAN.
	 * # The HWRM shall allow the setting of promiscuous
	 * mode on a function independently from the
	 * promiscuous mode settings on other functions.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_PROMISCUOUS \
		UINT32_C(0x10)
	/*
	 * If this flag is set, the corresponding RX
	 * filters shall be set up to cover multicast/broadcast
	 * filters for the outermost Layer 2 destination MAC
	 * address field.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_OUTERMOST \
		UINT32_C(0x20)
	/*
	 * If this flag is set, the corresponding RX
	 * filters shall be set up to cover multicast/broadcast
	 * filters for the VLAN-tagged packets that match the
	 * TPID and VID fields of VLAN tags in the VLAN tag
	 * table specified in this command.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_VLANONLY \
		UINT32_C(0x40)
	/*
	 * If this flag is set, the corresponding RX
	 * filters shall be set up to cover multicast/broadcast
	 * filters for non-VLAN tagged packets and VLAN-tagged
	 * packets that match the TPID and VID fields of VLAN
	 * tags in the VLAN tag table specified in this command.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_VLAN_NONVLAN \
		UINT32_C(0x80)
	/*
	 * If this flag is set, the corresponding RX
	 * filters shall be set up to cover multicast/broadcast
	 * filters for non-VLAN tagged packets and VLAN-tagged
	 * packets matching any VLAN tag.
	 *
	 * If this flag is set, then the HWRM shall ignore
	 * VLAN tags specified in vlan_tag_tbl.
	 *
	 * If none of vlanonly, vlan_nonvlan, and anyvlan_nonvlan
	 * flags is set, then the HWRM shall ignore
	 * VLAN tags specified in vlan_tag_tbl.
	 *
	 * The HWRM client shall set at most one flag out of
	 * vlanonly, vlan_nonvlan, and anyvlan_nonvlan.
	 */
	#define HWRM_CFA_L2_SET_RX_MASK_INPUT_MASK_ANYVLAN_NONVLAN \
		UINT32_C(0x100)
	/* This is the address for mcast address tbl. */
	uint64_t	mc_tbl_addr;
	/*
	 * This value indicates how many entries in mc_tbl are valid.
	 * Each entry is 6 bytes.
	 */
	uint32_t	num_mc_entries;
	uint8_t	unused_0[4];
	/*
	 * This is the address for VLAN tag table.
	 * Each VLAN entry in the table is 4 bytes of a VLAN tag
	 * including TPID, PCP, DEI, and VID fields in network byte
	 * order.
	 */
	uint64_t	vlan_tag_tbl_addr;
	/*
	 * This value indicates how many entries in vlan_tag_tbl are
	 * valid. Each entry is 4 bytes.
	 */
	uint32_t	num_vlan_tags;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_cfa_l2_set_rx_mask_output (size:128b/16B) */
struct hwrm_cfa_l2_set_rx_mask_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_cfa_l2_set_rx_mask_cmd_err (size:64b/8B) */
struct hwrm_cfa_l2_set_rx_mask_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_CFA_L2_SET_RX_MASK_CMD_ERR_CODE_UNKNOWN \
		UINT32_C(0x0)
	/* Unable to complete operation due to conflict with Ntuple Filter */
	#define HWRM_CFA_L2_SET_RX_MASK_CMD_ERR_CODE_NTUPLE_FILTER_CONFLICT_ERR \
		UINT32_C(0x1)
	#define HWRM_CFA_L2_SET_RX_MASK_CMD_ERR_CODE_LAST \
		HWRM_CFA_L2_SET_RX_MASK_CMD_ERR_CODE_NTUPLE_FILTER_CONFLICT_ERR
	uint8_t	unused_0[7];
} __attribute__((packed));

/*******************************
 * hwrm_cfa_vlan_antispoof_cfg *
 *******************************/


/* hwrm_cfa_vlan_antispoof_cfg_input (size:256b/32B) */
struct hwrm_cfa_vlan_antispoof_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being configured.
	 * Only valid for a VF FID configured by the PF.
	 */
	uint16_t	fid;
	uint8_t	unused_0[2];
	/* Number of VLAN entries in the vlan_tag_mask_tbl. */
	uint32_t	num_vlan_entries;
	/*
	 * The vlan_tag_mask_tbl_addr is the DMA address of the VLAN
	 * antispoof table. Each table entry contains the 16-bit TPID
	 * (0x8100 or 0x88a8 only), 16-bit VLAN ID, and a 16-bit mask,
	 * all in network order to match hwrm_cfa_l2_set_rx_mask.
	 * For an individual VLAN entry, the mask value should be 0xfff
	 * for the 12-bit VLAN ID.
	 */
	uint64_t	vlan_tag_mask_tbl_addr;
} __attribute__((packed));

/* hwrm_cfa_vlan_antispoof_cfg_output (size:128b/16B) */
struct hwrm_cfa_vlan_antispoof_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_cfa_vlan_antispoof_qcfg *
 ********************************/


/* hwrm_cfa_vlan_antispoof_qcfg_input (size:256b/32B) */
struct hwrm_cfa_vlan_antispoof_qcfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Function ID of the function that is being queried.
	 * Only valid for a VF FID queried by the PF.
	 */
	uint16_t	fid;
	uint8_t	unused_0[2];
	/*
	 * Maximum number of VLAN entries the firmware is allowed to DMA
	 * to vlan_tag_mask_tbl.
	 */
	uint32_t	max_vlan_entries;
	/*
	 * The vlan_tag_mask_tbl_addr is the DMA address of the VLAN
	 * antispoof table to which firmware will DMA to. Each table
	 * entry will contain the 16-bit TPID (0x8100 or 0x88a8 only),
	 * 16-bit VLAN ID, and a 16-bit mask, all in network order to
	 * match hwrm_cfa_l2_set_rx_mask. For an individual VLAN entry,
	 * the mask value should be 0xfff for the 12-bit VLAN ID.
	 */
	uint64_t	vlan_tag_mask_tbl_addr;
} __attribute__((packed));

/* hwrm_cfa_vlan_antispoof_qcfg_output (size:128b/16B) */
struct hwrm_cfa_vlan_antispoof_qcfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of valid entries DMAd by firmware to vlan_tag_mask_tbl. */
	uint32_t	num_vlan_entries;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_cfa_tunnel_filter_alloc *
 ********************************/


/* hwrm_cfa_tunnel_filter_alloc_input (size:704b/88B) */
struct hwrm_cfa_tunnel_filter_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* Setting of this flag indicates the applicability to the loopback path. */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_FLAGS_LOOPBACK \
		UINT32_C(0x1)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the l2_filter_id field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L2_FILTER_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the l2_addr field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L2_ADDR \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the l2_ivlan field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L2_IVLAN \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the l3_addr field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L3_ADDR \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the l3_addr_type field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_L3_ADDR_TYPE \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the t_l3_addr_type field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_T_L3_ADDR_TYPE \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the t_l3_addr field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_T_L3_ADDR \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the tunnel_type field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the vni field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_VNI \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the dst_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_DST_VNIC_ID \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID \
		UINT32_C(0x400)
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint64_t	l2_filter_id;
	/*
	 * This value sets the match value for the inner L2
	 * MAC address.
	 * Destination MAC address for RX path.
	 * Source MAC address for TX path.
	 */
	uint8_t	l2_addr[6];
	/*
	 * This value sets VLAN ID value for inner VLAN.
	 * Only 12-bits of VLAN ID are used in setting the filter.
	 */
	uint16_t	l2_ivlan;
	/*
	 * The value of inner destination IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	l3_addr[4];
	/*
	 * The value of tunnel destination IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	t_l3_addr[4];
	/*
	 * This value indicates the type of inner IP address.
	 * 4 - IPv4
	 * 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t	l3_addr_type;
	/*
	 * This value indicates the type of tunnel IP address.
	 * 4 - IPv4
	 * 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t	t_l3_addr_type;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Any tunneled traffic */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL
	/*
	 * tunnel_flags allows the user to indicate the tunnel tag detection
	 * for the tunnel type specified in tunnel_type.
	 */
	uint8_t	tunnel_flags;
	/*
	 * If the tunnel_type is geneve, then this bit indicates if we
	 * need to match the geneve OAM packet.
	 * If the tunnel_type is nvgre or gre, then this bit indicates if
	 * we need to detect checksum present bit in geneve header.
	 * If the tunnel_type is mpls, then this bit indicates if we need
	 * to match mpls packet with explicit IPV4/IPV6 null header.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_FLAGS_TUN_FLAGS_OAM_CHECKSUM_EXPLHDR \
		UINT32_C(0x1)
	/*
	 * If the tunnel_type is geneve, then this bit indicates if we
	 * need to detect the critical option bit set in the oam packet.
	 * If the tunnel_type is nvgre or gre, then this bit indicates
	 * if we need to match nvgre packets with key present bit set in
	 * gre header.
	 * If the tunnel_type is mpls, then this bit indicates if we
	 * need to match mpls packet with S bit from inner/second label.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_FLAGS_TUN_FLAGS_CRITICAL_OPT_S1 \
		UINT32_C(0x2)
	/*
	 * If the tunnel_type is geneve, then this bit indicates if we
	 * need to match geneve packet with extended header bit set in
	 * geneve header.
	 * If the tunnel_type is nvgre or gre, then this bit indicates
	 * if we need to match nvgre packets with sequence number
	 * present bit set in gre header.
	 * If the tunnel_type is mpls, then this bit indicates if we
	 * need to match mpls packet with S bit from out/first label.
	 */
	#define HWRM_CFA_TUNNEL_FILTER_ALLOC_INPUT_TUNNEL_FLAGS_TUN_FLAGS_EXTHDR_SEQNUM_S0 \
		UINT32_C(0x4)
	/*
	 * Virtual Network Identifier (VNI). Only valid with
	 * tunnel_types VXLAN, NVGRE, and Geneve.
	 * Only lower 24-bits of VNI field are used
	 * in setting up the filter.
	 */
	uint32_t	vni;
	/* Logical VNIC ID of the destination VNIC. */
	uint32_t	dst_vnic_id;
	/*
	 * Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint32_t	mirror_vnic_id;
} __attribute__((packed));

/* hwrm_cfa_tunnel_filter_alloc_output (size:192b/24B) */
struct hwrm_cfa_tunnel_filter_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value is an opaque id into CFA data structures. */
	uint64_t	tunnel_filter_id;
	/*
	 * This is the ID of the flow associated with this
	 * filter.
	 * This value shall be used to match and associate the
	 * flow identifier returned in completion records.
	 * A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint32_t	flow_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************************
 * hwrm_cfa_tunnel_filter_free *
 *******************************/


/* hwrm_cfa_tunnel_filter_free_input (size:192b/24B) */
struct hwrm_cfa_tunnel_filter_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This value is an opaque id into CFA data structures. */
	uint64_t	tunnel_filter_id;
} __attribute__((packed));

/* hwrm_cfa_tunnel_filter_free_output (size:128b/16B) */
struct hwrm_cfa_tunnel_filter_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************************
 * hwrm_cfa_redirect_tunnel_type_alloc *
 ***************************************/


/* hwrm_cfa_redirect_tunnel_type_alloc_input (size:192b/24B) */
struct hwrm_cfa_redirect_tunnel_type_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* The destination function id, to whom the traffic is redirected. */
	uint16_t	dest_fid;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Enhance Generic Routing Encapsulation (GRE version 1) inside IP datagram payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_IPGRE_V1 \
		UINT32_C(0xa)
	/* Any tunneled traffic */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL
	/* Tunnel alloc flags. */
	uint8_t	flags;
	/* Setting of this flag indicates modify existing redirect tunnel to new destination function ID. */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_ALLOC_INPUT_FLAGS_MODIFY_DST \
		UINT32_C(0x1)
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_cfa_redirect_tunnel_type_alloc_output (size:128b/16B) */
struct hwrm_cfa_redirect_tunnel_type_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************************
 * hwrm_cfa_redirect_tunnel_type_free *
 **************************************/


/* hwrm_cfa_redirect_tunnel_type_free_input (size:192b/24B) */
struct hwrm_cfa_redirect_tunnel_type_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* The destination function id, to whom the traffic is redirected. */
	uint16_t	dest_fid;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Enhance Generic Routing Encapsulation (GRE version 1) inside IP datagram payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_IPGRE_V1 \
		UINT32_C(0xa)
	/* Any tunneled traffic */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_REDIRECT_TUNNEL_TYPE_FREE_INPUT_TUNNEL_TYPE_ANYTUNNEL
	uint8_t	unused_0[5];
} __attribute__((packed));

/* hwrm_cfa_redirect_tunnel_type_free_output (size:128b/16B) */
struct hwrm_cfa_redirect_tunnel_type_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************************
 * hwrm_cfa_redirect_tunnel_type_info *
 **************************************/


/* hwrm_cfa_redirect_tunnel_type_info_input (size:192b/24B) */
struct hwrm_cfa_redirect_tunnel_type_info_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* The source function id. */
	uint16_t	src_fid;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Enhance Generic Routing Encapsulation (GRE version 1) inside IP datagram payload */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_IPGRE_V1 \
		UINT32_C(0xa)
	/* Any tunneled traffic */
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_REDIRECT_TUNNEL_TYPE_INFO_INPUT_TUNNEL_TYPE_ANYTUNNEL
	uint8_t	unused_0[5];
} __attribute__((packed));

/* hwrm_cfa_redirect_tunnel_type_info_output (size:128b/16B) */
struct hwrm_cfa_redirect_tunnel_type_info_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The destination function id, to whom the traffic is redirected. */
	uint16_t	dest_fid;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_vxlan_ipv4_hdr (size:128b/16B) */
struct hwrm_vxlan_ipv4_hdr {
	/* IPv4 version and header length. */
	uint8_t	ver_hlen;
	/* IPv4 header length */
	#define HWRM_VXLAN_IPV4_HDR_VER_HLEN_HEADER_LENGTH_MASK UINT32_C(0xf)
	#define HWRM_VXLAN_IPV4_HDR_VER_HLEN_HEADER_LENGTH_SFT 0
	/* Version */
	#define HWRM_VXLAN_IPV4_HDR_VER_HLEN_VERSION_MASK      UINT32_C(0xf0)
	#define HWRM_VXLAN_IPV4_HDR_VER_HLEN_VERSION_SFT       4
	/* IPv4 type of service. */
	uint8_t	tos;
	/* IPv4 identification. */
	uint16_t	ip_id;
	/* IPv4 flags and offset. */
	uint16_t	flags_frag_offset;
	/* IPv4 TTL. */
	uint8_t	ttl;
	/* IPv4 protocol. */
	uint8_t	protocol;
	/* IPv4 source address. */
	uint32_t	src_ip_addr;
	/* IPv4 destination address. */
	uint32_t	dest_ip_addr;
} __attribute__((packed));

/* hwrm_vxlan_ipv6_hdr (size:320b/40B) */
struct hwrm_vxlan_ipv6_hdr {
	/* IPv6 version, traffic class and flow label. */
	uint32_t	ver_tc_flow_label;
	/* IPv6 version shift */
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_VER_SFT \
		UINT32_C(0x1c)
	/* IPv6 version mask */
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_VER_MASK \
		UINT32_C(0xf0000000)
	/* IPv6 TC shift */
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_TC_SFT \
		UINT32_C(0x14)
	/* IPv6 TC mask */
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_TC_MASK \
		UINT32_C(0xff00000)
	/* IPv6 flow label shift */
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_FLOW_LABEL_SFT \
		UINT32_C(0x0)
	/* IPv6 flow label mask */
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_FLOW_LABEL_MASK \
		UINT32_C(0xfffff)
	#define HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_LAST \
		HWRM_VXLAN_IPV6_HDR_VER_TC_FLOW_LABEL_FLOW_LABEL_MASK
	/* IPv6 payload length. */
	uint16_t	payload_len;
	/* IPv6 next header. */
	uint8_t	next_hdr;
	/* IPv6 TTL. */
	uint8_t	ttl;
	/* IPv6 source address. */
	uint32_t	src_ip_addr[4];
	/* IPv6 destination address. */
	uint32_t	dest_ip_addr[4];
} __attribute__((packed));

/* hwrm_cfa_encap_data_vxlan (size:576b/72B) */
struct hwrm_cfa_encap_data_vxlan {
	/* Source MAC address. */
	uint8_t	src_mac_addr[6];
	/* reserved. */
	uint16_t	unused_0;
	/* Destination MAC address. */
	uint8_t	dst_mac_addr[6];
	/* Number of VLAN tags. */
	uint8_t	num_vlan_tags;
	/* reserved. */
	uint8_t	unused_1;
	/* Outer VLAN TPID. */
	uint16_t	ovlan_tpid;
	/* Outer VLAN TCI. */
	uint16_t	ovlan_tci;
	/* Inner VLAN TPID. */
	uint16_t	ivlan_tpid;
	/* Inner VLAN TCI. */
	uint16_t	ivlan_tci;
	/* L3 header fields. */
	uint32_t	l3[10];
	/* IP version mask. */
	#define HWRM_CFA_ENCAP_DATA_VXLAN_L3_VER_MASK UINT32_C(0xf)
	/* IP version 4. */
	#define HWRM_CFA_ENCAP_DATA_VXLAN_L3_VER_IPV4 UINT32_C(0x4)
	/* IP version 6. */
	#define HWRM_CFA_ENCAP_DATA_VXLAN_L3_VER_IPV6 UINT32_C(0x6)
	#define HWRM_CFA_ENCAP_DATA_VXLAN_L3_LAST \
		HWRM_CFA_ENCAP_DATA_VXLAN_L3_VER_IPV6
	/* UDP source port. */
	uint16_t	src_port;
	/* UDP destination port. */
	uint16_t	dst_port;
	/* VXLAN Network Identifier. */
	uint32_t	vni;
} __attribute__((packed));

/*******************************
 * hwrm_cfa_encap_record_alloc *
 *******************************/


/* hwrm_cfa_encap_record_alloc_input (size:832b/104B) */
struct hwrm_cfa_encap_record_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* Setting of this flag indicates the applicability to the loopback path. */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_FLAGS_LOOPBACK \
		UINT32_C(0x1)
	/* Encapsulation Type. */
	uint8_t	encap_type;
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) after inside Ethernet payload */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_MPLS \
		UINT32_C(0x6)
	/* VLAN */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_VLAN \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_IPGRE \
		UINT32_C(0x8)
	#define HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_LAST \
		HWRM_CFA_ENCAP_RECORD_ALLOC_INPUT_ENCAP_TYPE_IPGRE
	uint8_t	unused_0[3];
	/* This value is encap data used for the given encap type. */
	uint32_t	encap_data[20];
} __attribute__((packed));

/* hwrm_cfa_encap_record_alloc_output (size:128b/16B) */
struct hwrm_cfa_encap_record_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value is an opaque id into CFA data structures. */
	uint32_t	encap_record_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************************
 * hwrm_cfa_encap_record_free *
 ******************************/


/* hwrm_cfa_encap_record_free_input (size:192b/24B) */
struct hwrm_cfa_encap_record_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This value is an opaque id into CFA data structures. */
	uint32_t	encap_record_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_cfa_encap_record_free_output (size:128b/16B) */
struct hwrm_cfa_encap_record_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_cfa_ntuple_filter_alloc *
 ********************************/


/* hwrm_cfa_ntuple_filter_alloc_input (size:1024b/128B) */
struct hwrm_cfa_ntuple_filter_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* Setting of this flag indicates the applicability to the loopback path. */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_FLAGS_LOOPBACK \
		UINT32_C(0x1)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_FLAGS_DROP \
		UINT32_C(0x2)
	/*
	 * Setting of this flag indicates that a meter is expected to be attached
	 * to this flow. This hint can be used when choosing the action record
	 * format required for the flow.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_FLAGS_METER \
		UINT32_C(0x4)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the l2_filter_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_L2_FILTER_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the ethertype field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_ETHERTYPE \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the tunnel_type field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the src_macaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_MACADDR \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the ipaddr_type field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_IPADDR_TYPE \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the src_ipaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_IPADDR \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the src_ipaddr_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_IPADDR_MASK \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the dst_ipaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_IPADDR \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the dst_ipaddr_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_IPADDR_MASK \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the ip_protocol field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_IP_PROTOCOL \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the src_port field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_PORT \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the src_port_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_SRC_PORT_MASK \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the dst_port field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_PORT \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the dst_port_mask field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_PORT_MASK \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the pri_hint field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_PRI_HINT \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the ntuple_filter_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_NTUPLE_FILTER_ID \
		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_ID \
		UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID \
		UINT32_C(0x20000)
	/*
	 * This bit must be '1' for the dst_macaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_ENABLES_DST_MACADDR \
		UINT32_C(0x40000)
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint64_t	l2_filter_id;
	/*
	 * This value indicates the source MAC address in
	 * the Ethernet header.
	 */
	uint8_t	src_macaddr[6];
	/* This value indicates the ethertype in the Ethernet header. */
	uint16_t	ethertype;
	/*
	 * This value indicates the type of IP address.
	 * 4 - IPv4
	 * 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t	ip_addr_type;
	/* invalid */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_UNKNOWN \
		UINT32_C(0x0)
	/* IPv4 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV4 \
		UINT32_C(0x4)
	/* IPv6 */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV6 \
		UINT32_C(0x6)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_LAST \
		HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV6
	/*
	 * The value of protocol filed in IP header.
	 * Applies to UDP and TCP traffic.
	 * 6 - TCP
	 * 17 - UDP
	 */
	uint8_t	ip_protocol;
	/* invalid */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_UNKNOWN \
		UINT32_C(0x0)
	/* TCP */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_TCP \
		UINT32_C(0x6)
	/* UDP */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_UDP \
		UINT32_C(0x11)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_LAST \
		HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_IP_PROTOCOL_UDP
	/*
	 * If set, this value shall represent the
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path and network port id of the destination port for
	 * the TX path.
	 */
	uint16_t	dst_id;
	/*
	 * Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint16_t	mirror_vnic_id;
	/*
	 * This value indicates the tunnel type for this filter.
	 * If this field is not specified, then the filter shall
	 * apply to both non-tunneled and tunneled packets.
	 * If this field conflicts with the tunnel_type specified
	 * in the l2_filter_id, then the HWRM shall return an
	 * error for this command.
	 */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Any tunneled traffic */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL
	/*
	 * This hint is provided to help in placing
	 * the filter in the filter table.
	 */
	uint8_t	pri_hint;
	/* No preference */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_NO_PREFER \
		UINT32_C(0x0)
	/* Above the given filter */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_ABOVE \
		UINT32_C(0x1)
	/* Below the given filter */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_BELOW \
		UINT32_C(0x2)
	/* As high as possible */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_HIGHEST \
		UINT32_C(0x3)
	/* As low as possible */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_LOWEST \
		UINT32_C(0x4)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_LAST \
		HWRM_CFA_NTUPLE_FILTER_ALLOC_INPUT_PRI_HINT_LOWEST
	/*
	 * The value of source IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	src_ipaddr[4];
	/*
	 * The value of source IP address mask to be used in
	 * filtering.
	 * For IPv4, first four bytes represent the IP address mask.
	 */
	uint32_t	src_ipaddr_mask[4];
	/*
	 * The value of destination IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	dst_ipaddr[4];
	/*
	 * The value of destination IP address mask to be used in
	 * filtering.
	 * For IPv4, first four bytes represent the IP address mask.
	 */
	uint32_t	dst_ipaddr_mask[4];
	/*
	 * The value of source port to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	src_port;
	/*
	 * The value of source port mask to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	src_port_mask;
	/*
	 * The value of destination port to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	dst_port;
	/*
	 * The value of destination port mask to be used in
	 * filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	dst_port_mask;
	/*
	 * This is the ID of the filter that goes along with
	 * the pri_hint.
	 */
	uint64_t	ntuple_filter_id_hint;
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_alloc_output (size:192b/24B) */
struct hwrm_cfa_ntuple_filter_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value is an opaque id into CFA data structures. */
	uint64_t	ntuple_filter_id;
	/*
	 * This is the ID of the flow associated with this
	 * filter.
	 * This value shall be used to match and associate the
	 * flow identifier returned in completion records.
	 * A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint32_t	flow_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_alloc_cmd_err (size:64b/8B) */
struct hwrm_cfa_ntuple_filter_alloc_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_CMD_ERR_CODE_UNKNOWN \
		UINT32_C(0x0)
	/* Unable to complete operation due to conflict with Rx Mask VLAN */
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_CMD_ERR_CODE_RX_MASK_VLAN_CONFLICT_ERR \
		UINT32_C(0x1)
	#define HWRM_CFA_NTUPLE_FILTER_ALLOC_CMD_ERR_CODE_LAST \
		HWRM_CFA_NTUPLE_FILTER_ALLOC_CMD_ERR_CODE_RX_MASK_VLAN_CONFLICT_ERR
	uint8_t	unused_0[7];
} __attribute__((packed));

/*******************************
 * hwrm_cfa_ntuple_filter_free *
 *******************************/


/* hwrm_cfa_ntuple_filter_free_input (size:192b/24B) */
struct hwrm_cfa_ntuple_filter_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This value is an opaque id into CFA data structures. */
	uint64_t	ntuple_filter_id;
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_free_output (size:128b/16B) */
struct hwrm_cfa_ntuple_filter_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************************
 * hwrm_cfa_ntuple_filter_cfg *
 ******************************/


/* hwrm_cfa_ntuple_filter_cfg_input (size:384b/48B) */
struct hwrm_cfa_ntuple_filter_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the new_dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_ENABLES_NEW_DST_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the new_mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_ENABLES_NEW_MIRROR_VNIC_ID \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the new_meter_instance_id field to be
	 * configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_ENABLES_NEW_METER_INSTANCE_ID \
		UINT32_C(0x4)
	uint8_t	unused_0[4];
	/* This value is an opaque id into CFA data structures. */
	uint64_t	ntuple_filter_id;
	/*
	 * If set, this value shall represent the new
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path and new network port id of the destination port for
	 * the TX path.
	 */
	uint32_t	new_dst_id;
	/*
	 * New Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint32_t	new_mirror_vnic_id;
	/*
	 * New meter to attach to the flow. Specifying the
	 * invalid instance ID is used to remove any existing
	 * meter from the flow.
	 */
	uint16_t	new_meter_instance_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_NEW_METER_INSTANCE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_NEW_METER_INSTANCE_ID_LAST \
		HWRM_CFA_NTUPLE_FILTER_CFG_INPUT_NEW_METER_INSTANCE_ID_INVALID
	uint8_t	unused_1[6];
} __attribute__((packed));

/* hwrm_cfa_ntuple_filter_cfg_output (size:128b/16B) */
struct hwrm_cfa_ntuple_filter_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_cfa_em_flow_alloc *
 **************************/


/* hwrm_cfa_em_flow_alloc_input (size:896b/112B) */
struct hwrm_cfa_em_flow_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH         UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_TX        UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_RX        UINT32_C(0x1)
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PATH_RX
	/*
	 * Setting of this flag indicates enabling of a byte counter for a given
	 * flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_BYTE_CTR     UINT32_C(0x2)
	/*
	 * Setting of this flag indicates enabling of a packet counter for a given
	 * flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_PKT_CTR      UINT32_C(0x4)
	/* Setting of this flag indicates de-capsulation action for the given flow. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_DECAP        UINT32_C(0x8)
	/* Setting of this flag indicates encapsulation action for the given flow. */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_ENCAP        UINT32_C(0x10)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_DROP         UINT32_C(0x20)
	/*
	 * Setting of this flag indicates that a meter is expected to be attached
	 * to this flow. This hint can be used when choosing the action record
	 * format required for the flow.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_FLAGS_METER        UINT32_C(0x40)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the l2_filter_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_L2_FILTER_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the tunnel_type field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_TUNNEL_TYPE \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the tunnel_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_TUNNEL_ID \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the src_macaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_SRC_MACADDR \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the dst_macaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_MACADDR \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the ovlan_vid field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_OVLAN_VID \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the ivlan_vid field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_IVLAN_VID \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the ethertype field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_ETHERTYPE \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the src_ipaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_SRC_IPADDR \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the dst_ipaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_IPADDR \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the ipaddr_type field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_IPADDR_TYPE \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the ip_protocol field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_IP_PROTOCOL \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the src_port field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_SRC_PORT \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the dst_port field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_PORT \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_DST_ID \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID \
		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the encap_record_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_ENCAP_RECORD_ID \
		UINT32_C(0x10000)
	/*
	 * This bit must be '1' for the meter_instance_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_ENABLES_METER_INSTANCE_ID \
		UINT32_C(0x20000)
	/*
	 * This value identifies a set of CFA data structures used for an L2
	 * context.
	 */
	uint64_t	l2_filter_id;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Any tunneled traffic */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_EM_FLOW_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL
	uint8_t	unused_0[3];
	/*
	 * Tunnel identifier.
	 * Virtual Network Identifier (VNI). Only valid with
	 * tunnel_types VXLAN, NVGRE, and Geneve.
	 * Only lower 24-bits of VNI field are used
	 * in setting up the filter.
	 */
	uint32_t	tunnel_id;
	/*
	 * This value indicates the source MAC address in
	 * the Ethernet header.
	 */
	uint8_t	src_macaddr[6];
	/* The meter instance to attach to the flow. */
	uint16_t	meter_instance_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_METER_INSTANCE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_METER_INSTANCE_ID_LAST \
		HWRM_CFA_EM_FLOW_ALLOC_INPUT_METER_INSTANCE_ID_INVALID
	/*
	 * This value indicates the destination MAC address in
	 * the Ethernet header.
	 */
	uint8_t	dst_macaddr[6];
	/*
	 * This value indicates the VLAN ID of the outer VLAN tag
	 * in the Ethernet header.
	 */
	uint16_t	ovlan_vid;
	/*
	 * This value indicates the VLAN ID of the inner VLAN tag
	 * in the Ethernet header.
	 */
	uint16_t	ivlan_vid;
	/* This value indicates the ethertype in the Ethernet header. */
	uint16_t	ethertype;
	/*
	 * This value indicates the type of IP address.
	 * 4 - IPv4
	 * 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t	ip_addr_type;
	/* invalid */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_UNKNOWN UINT32_C(0x0)
	/* IPv4 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_IPV4    UINT32_C(0x4)
	/* IPv6 */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_IPV6    UINT32_C(0x6)
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_LAST \
		HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_ADDR_TYPE_IPV6
	/*
	 * The value of protocol filed in IP header.
	 * Applies to UDP and TCP traffic.
	 * 6 - TCP
	 * 17 - UDP
	 */
	uint8_t	ip_protocol;
	/* invalid */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_UNKNOWN UINT32_C(0x0)
	/* TCP */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_TCP     UINT32_C(0x6)
	/* UDP */
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_UDP     UINT32_C(0x11)
	#define HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_LAST \
		HWRM_CFA_EM_FLOW_ALLOC_INPUT_IP_PROTOCOL_UDP
	uint8_t	unused_1[2];
	/*
	 * The value of source IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	src_ipaddr[4];
	/*
	 * big_endian = True
	 *     The value of destination IP address to be used in filtering.
	 *     For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	dst_ipaddr[4];
	/*
	 * The value of source port to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	src_port;
	/*
	 * The value of destination port to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	dst_port;
	/*
	 * If set, this value shall represent the
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path and network port id of the destination port for
	 * the TX path.
	 */
	uint16_t	dst_id;
	/*
	 * Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint16_t	mirror_vnic_id;
	/* Logical ID of the encapsulation record. */
	uint32_t	encap_record_id;
	uint8_t	unused_2[4];
} __attribute__((packed));

/* hwrm_cfa_em_flow_alloc_output (size:192b/24B) */
struct hwrm_cfa_em_flow_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value is an opaque id into CFA data structures. */
	uint64_t	em_filter_id;
	/*
	 * This is the ID of the flow associated with this
	 * filter.
	 * This value shall be used to match and associate the
	 * flow identifier returned in completion records.
	 * A value of 0xFFFFFFFF shall indicate no flow id.
	 */
	uint32_t	flow_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_cfa_em_flow_free *
 *************************/


/* hwrm_cfa_em_flow_free_input (size:192b/24B) */
struct hwrm_cfa_em_flow_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This value is an opaque id into CFA data structures. */
	uint64_t	em_filter_id;
} __attribute__((packed));

/* hwrm_cfa_em_flow_free_output (size:128b/16B) */
struct hwrm_cfa_em_flow_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_cfa_em_flow_cfg *
 ************************/


/* hwrm_cfa_em_flow_cfg_input (size:384b/48B) */
struct hwrm_cfa_em_flow_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the new_dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_ENABLES_NEW_DST_ID \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the new_mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_ENABLES_NEW_MIRROR_VNIC_ID \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the new_meter_instance_id field to be
	 * configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_ENABLES_NEW_METER_INSTANCE_ID \
		UINT32_C(0x4)
	uint8_t	unused_0[4];
	/* This value is an opaque id into CFA data structures. */
	uint64_t	em_filter_id;
	/*
	 * If set, this value shall represent the new
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path and network port id of the destination port for
	 * the TX path.
	 */
	uint32_t	new_dst_id;
	/*
	 * New Logical VNIC ID of the VNIC where traffic is
	 * mirrored.
	 */
	uint32_t	new_mirror_vnic_id;
	/*
	 * New meter to attach to the flow. Specifying the
	 * invalid instance ID is used to remove any existing
	 * meter from the flow.
	 */
	uint16_t	new_meter_instance_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_NEW_METER_INSTANCE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_EM_FLOW_CFG_INPUT_NEW_METER_INSTANCE_ID_LAST \
		HWRM_CFA_EM_FLOW_CFG_INPUT_NEW_METER_INSTANCE_ID_INVALID
	uint8_t	unused_1[6];
} __attribute__((packed));

/* hwrm_cfa_em_flow_cfg_output (size:128b/16B) */
struct hwrm_cfa_em_flow_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_cfa_meter_profile_alloc *
 ********************************/


/* hwrm_cfa_meter_profile_alloc_input (size:320b/40B) */
struct hwrm_cfa_meter_profile_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_TX \
		UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_RX \
		UINT32_C(0x1)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_FLAGS_PATH_RX
	/* The meter algorithm type. */
	uint8_t	meter_type;
	/* RFC 2697 (srTCM) */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC2697 \
		UINT32_C(0x0)
	/* RFC 2698 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC2698 \
		UINT32_C(0x1)
	/* RFC 4115 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC4115 \
		UINT32_C(0x2)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_METER_TYPE_RFC4115
	/*
	 * This field is reserved for the future use.
	 * It shall be set to 0.
	 */
	uint16_t	reserved1;
	/*
	 * This field is reserved for the future use.
	 * It shall be set to 0.
	 */
	uint32_t	reserved2;
	/* A meter rate specified in bytes-per-second. */
	uint32_t	commit_rate;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID
	/* A meter burst size specified in bytes. */
	uint32_t	commit_burst;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID
	/* A meter rate specified in bytes-per-second. */
	uint32_t	excess_peak_rate;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID
	/* A meter burst size specified in bytes. */
	uint32_t	excess_peak_burst;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID
} __attribute__((packed));

/* hwrm_cfa_meter_profile_alloc_output (size:128b/16B) */
struct hwrm_cfa_meter_profile_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value identifies a meter profile in CFA. */
	uint16_t	meter_profile_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_PROFILE_ALLOC_OUTPUT_METER_PROFILE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_METER_PROFILE_ALLOC_OUTPUT_METER_PROFILE_ID_LAST \
		HWRM_CFA_METER_PROFILE_ALLOC_OUTPUT_METER_PROFILE_ID_INVALID
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************************
 * hwrm_cfa_meter_profile_free *
 *******************************/


/* hwrm_cfa_meter_profile_free_input (size:192b/24B) */
struct hwrm_cfa_meter_profile_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_TX \
		UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_RX \
		UINT32_C(0x1)
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_METER_PROFILE_FREE_INPUT_FLAGS_PATH_RX
	uint8_t	unused_0;
	/* This value identifies a meter profile in CFA. */
	uint16_t	meter_profile_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_METER_PROFILE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_METER_PROFILE_FREE_INPUT_METER_PROFILE_ID_LAST \
		HWRM_CFA_METER_PROFILE_FREE_INPUT_METER_PROFILE_ID_INVALID
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_cfa_meter_profile_free_output (size:128b/16B) */
struct hwrm_cfa_meter_profile_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************************
 * hwrm_cfa_meter_profile_cfg *
 ******************************/


/* hwrm_cfa_meter_profile_cfg_input (size:320b/40B) */
struct hwrm_cfa_meter_profile_cfg_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_TX    UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_RX    UINT32_C(0x1)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_FLAGS_PATH_RX
	/* The meter algorithm type. */
	uint8_t	meter_type;
	/* RFC 2697 (srTCM) */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC2697 \
		UINT32_C(0x0)
	/* RFC 2698 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC2698 \
		UINT32_C(0x1)
	/* RFC 4115 (trTCM) */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC4115 \
		UINT32_C(0x2)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_TYPE_RFC4115
	/* This value identifies a meter profile in CFA. */
	uint16_t	meter_profile_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_PROFILE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_PROFILE_ID_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_METER_PROFILE_ID_INVALID
	/*
	 * This field is reserved for the future use.
	 * It shall be set to 0.
	 */
	uint32_t	reserved;
	/* A meter rate specified in bytes-per-second. */
	uint32_t	commit_rate;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_RATE_BW_VALUE_UNIT_INVALID
	/* A meter burst size specified in bytes. */
	uint32_t	commit_burst;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_COMMIT_BURST_BW_VALUE_UNIT_INVALID
	/* A meter rate specified in bytes-per-second. */
	uint32_t	excess_peak_rate;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_RATE_BW_VALUE_UNIT_INVALID
	/* A meter burst size specified in bytes. */
	uint32_t	excess_peak_burst;
	/* The bandwidth value. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_MASK \
		UINT32_C(0xfffffff)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_SFT \
		0
	/* The granularity of the value (bits or bytes). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE \
		UINT32_C(0x10000000)
	/* Value is in bits. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_BITS \
		(UINT32_C(0x0) << 28)
	/* Value is in bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES \
		(UINT32_C(0x1) << 28)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_SCALE_BYTES
	/* bw_value_unit is 3 b */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MASK \
		UINT32_C(0xe0000000)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_SFT \
		29
	/* Value is in Mb or MB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_MEGA \
		(UINT32_C(0x0) << 29)
	/* Value is in Kb or KB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_KILO \
		(UINT32_C(0x2) << 29)
	/* Value is in bits or bytes. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_BASE \
		(UINT32_C(0x4) << 29)
	/* Value is in Gb or GB (base 10). */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_GIGA \
		(UINT32_C(0x6) << 29)
	/* Value is in 1/100th of a percentage of total bandwidth. */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_PERCENT1_100 \
		(UINT32_C(0x1) << 29)
	/* Invalid unit */
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID \
		(UINT32_C(0x7) << 29)
	#define HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_LAST \
		HWRM_CFA_METER_PROFILE_CFG_INPUT_EXCESS_PEAK_BURST_BW_VALUE_UNIT_INVALID
} __attribute__((packed));

/* hwrm_cfa_meter_profile_cfg_output (size:128b/16B) */
struct hwrm_cfa_meter_profile_cfg_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************************
 * hwrm_cfa_meter_instance_alloc *
 *********************************/


/* hwrm_cfa_meter_instance_alloc_input (size:192b/24B) */
struct hwrm_cfa_meter_instance_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH \
		UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_TX \
		UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_RX \
		UINT32_C(0x1)
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_FLAGS_PATH_RX
	uint8_t	unused_0;
	/* This value identifies a meter profile in CFA. */
	uint16_t	meter_profile_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * profile is not configured.
	 */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_METER_PROFILE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_METER_PROFILE_ID_LAST \
		HWRM_CFA_METER_INSTANCE_ALLOC_INPUT_METER_PROFILE_ID_INVALID
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_cfa_meter_instance_alloc_output (size:128b/16B) */
struct hwrm_cfa_meter_instance_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value identifies a meter instance in CFA. */
	uint16_t	meter_instance_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_METER_INSTANCE_ALLOC_OUTPUT_METER_INSTANCE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_METER_INSTANCE_ALLOC_OUTPUT_METER_INSTANCE_ID_LAST \
		HWRM_CFA_METER_INSTANCE_ALLOC_OUTPUT_METER_INSTANCE_ID_INVALID
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************************
 * hwrm_cfa_meter_instance_free *
 ********************************/


/* hwrm_cfa_meter_instance_free_input (size:192b/24B) */
struct hwrm_cfa_meter_instance_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint8_t	flags;
	/*
	 * Enumeration denoting the RX, TX type of the resource.
	 * This enumeration is used for resources that are similar for both
	 * TX and RX paths of the chip.
	 */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH     UINT32_C(0x1)
	/* tx path */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_TX \
		UINT32_C(0x0)
	/* rx path */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_RX \
		UINT32_C(0x1)
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_LAST \
		HWRM_CFA_METER_INSTANCE_FREE_INPUT_FLAGS_PATH_RX
	uint8_t	unused_0;
	/* This value identifies a meter instance in CFA. */
	uint16_t	meter_instance_id;
	/*
	 * A value of 0xfff is considered invalid and implies the
	 * instance is not configured.
	 */
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_METER_INSTANCE_ID_INVALID \
		UINT32_C(0xffff)
	#define HWRM_CFA_METER_INSTANCE_FREE_INPUT_METER_INSTANCE_ID_LAST \
		HWRM_CFA_METER_INSTANCE_FREE_INPUT_METER_INSTANCE_ID_INVALID
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_cfa_meter_instance_free_output (size:128b/16B) */
struct hwrm_cfa_meter_instance_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*******************************
 * hwrm_cfa_decap_filter_alloc *
 *******************************/


/* hwrm_cfa_decap_filter_alloc_input (size:832b/104B) */
struct hwrm_cfa_decap_filter_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* ovs_tunnel is 1 b */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_FLAGS_OVS_TUNNEL \
		UINT32_C(0x1)
	uint32_t	enables;
	/*
	 * This bit must be '1' for the tunnel_type field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_TYPE \
		UINT32_C(0x1)
	/*
	 * This bit must be '1' for the tunnel_id field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_TUNNEL_ID \
		UINT32_C(0x2)
	/*
	 * This bit must be '1' for the src_macaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_SRC_MACADDR \
		UINT32_C(0x4)
	/*
	 * This bit must be '1' for the dst_macaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_MACADDR \
		UINT32_C(0x8)
	/*
	 * This bit must be '1' for the ovlan_vid field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_OVLAN_VID \
		UINT32_C(0x10)
	/*
	 * This bit must be '1' for the ivlan_vid field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_IVLAN_VID \
		UINT32_C(0x20)
	/*
	 * This bit must be '1' for the t_ovlan_vid field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_T_OVLAN_VID \
		UINT32_C(0x40)
	/*
	 * This bit must be '1' for the t_ivlan_vid field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_T_IVLAN_VID \
		UINT32_C(0x80)
	/*
	 * This bit must be '1' for the ethertype field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_ETHERTYPE \
		UINT32_C(0x100)
	/*
	 * This bit must be '1' for the src_ipaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_SRC_IPADDR \
		UINT32_C(0x200)
	/*
	 * This bit must be '1' for the dst_ipaddr field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_IPADDR \
		UINT32_C(0x400)
	/*
	 * This bit must be '1' for the ipaddr_type field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_IPADDR_TYPE \
		UINT32_C(0x800)
	/*
	 * This bit must be '1' for the ip_protocol field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_IP_PROTOCOL \
		UINT32_C(0x1000)
	/*
	 * This bit must be '1' for the src_port field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_SRC_PORT \
		UINT32_C(0x2000)
	/*
	 * This bit must be '1' for the dst_port field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_PORT \
		UINT32_C(0x4000)
	/*
	 * This bit must be '1' for the dst_id field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_DST_ID \
		UINT32_C(0x8000)
	/*
	 * This bit must be '1' for the mirror_vnic_id field to be
	 * configured.
	 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_ENABLES_MIRROR_VNIC_ID \
		UINT32_C(0x10000)
	/*
	 * Tunnel identifier.
	 * Virtual Network Identifier (VNI). Only valid with
	 * tunnel_types VXLAN, NVGRE, and Geneve.
	 * Only lower 24-bits of VNI field are used
	 * in setting up the filter.
	 */
	uint32_t	tunnel_id;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Non-tunnel */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NONTUNNEL \
		UINT32_C(0x0)
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Network Virtualization Generic Routing Encapsulation (NVGRE) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_NVGRE \
		UINT32_C(0x2)
	/* Generic Routing Encapsulation (GRE) inside Ethernet payload */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_L2GRE \
		UINT32_C(0x3)
	/* IP in IP */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPIP \
		UINT32_C(0x4)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* Multi-Protocol Lable Switching (MPLS) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_MPLS \
		UINT32_C(0x6)
	/* Stateless Transport Tunnel (STT) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_STT \
		UINT32_C(0x7)
	/* Generic Routing Encapsulation (GRE) inside IP datagram payload */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_IPGRE \
		UINT32_C(0x8)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Any tunneled traffic */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL \
		UINT32_C(0xff)
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_TUNNEL_TYPE_ANYTUNNEL
	uint8_t	unused_0;
	uint16_t	unused_1;
	/*
	 * This value indicates the source MAC address in
	 * the Ethernet header.
	 */
	uint8_t	src_macaddr[6];
	uint8_t	unused_2[2];
	/*
	 * This value indicates the destination MAC address in
	 * the Ethernet header.
	 */
	uint8_t	dst_macaddr[6];
	/*
	 * This value indicates the VLAN ID of the outer VLAN tag
	 * in the Ethernet header.
	 */
	uint16_t	ovlan_vid;
	/*
	 * This value indicates the VLAN ID of the inner VLAN tag
	 * in the Ethernet header.
	 */
	uint16_t	ivlan_vid;
	/*
	 * This value indicates the VLAN ID of the outer VLAN tag
	 * in the tunnel Ethernet header.
	 */
	uint16_t	t_ovlan_vid;
	/*
	 * This value indicates the VLAN ID of the inner VLAN tag
	 * in the tunnel Ethernet header.
	 */
	uint16_t	t_ivlan_vid;
	/* This value indicates the ethertype in the Ethernet header. */
	uint16_t	ethertype;
	/*
	 * This value indicates the type of IP address.
	 * 4 - IPv4
	 * 6 - IPv6
	 * All others are invalid.
	 */
	uint8_t	ip_addr_type;
	/* invalid */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_UNKNOWN \
		UINT32_C(0x0)
	/* IPv4 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV4 \
		UINT32_C(0x4)
	/* IPv6 */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV6 \
		UINT32_C(0x6)
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_LAST \
		HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_ADDR_TYPE_IPV6
	/*
	 * The value of protocol filed in IP header.
	 * Applies to UDP and TCP traffic.
	 * 6 - TCP
	 * 17 - UDP
	 */
	uint8_t	ip_protocol;
	/* invalid */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_UNKNOWN \
		UINT32_C(0x0)
	/* TCP */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_TCP \
		UINT32_C(0x6)
	/* UDP */
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_UDP \
		UINT32_C(0x11)
	#define HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_LAST \
		HWRM_CFA_DECAP_FILTER_ALLOC_INPUT_IP_PROTOCOL_UDP
	uint16_t	unused_3;
	uint32_t	unused_4;
	/*
	 * The value of source IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	src_ipaddr[4];
	/*
	 * The value of destination IP address to be used in filtering.
	 * For IPv4, first four bytes represent the IP address.
	 */
	uint32_t	dst_ipaddr[4];
	/*
	 * The value of source port to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	src_port;
	/*
	 * The value of destination port to be used in filtering.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	dst_port;
	/*
	 * If set, this value shall represent the
	 * Logical VNIC ID of the destination VNIC for the RX
	 * path.
	 */
	uint16_t	dst_id;
	/*
	 * If set, this value shall represent the L2 context that matches the L2
	 * information of the decap filter.
	 */
	uint16_t	l2_ctxt_ref_id;
} __attribute__((packed));

/* hwrm_cfa_decap_filter_alloc_output (size:128b/16B) */
struct hwrm_cfa_decap_filter_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This value is an opaque id into CFA data structures. */
	uint32_t	decap_filter_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************************
 * hwrm_cfa_decap_filter_free *
 ******************************/


/* hwrm_cfa_decap_filter_free_input (size:192b/24B) */
struct hwrm_cfa_decap_filter_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This value is an opaque id into CFA data structures. */
	uint32_t	decap_filter_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_cfa_decap_filter_free_output (size:128b/16B) */
struct hwrm_cfa_decap_filter_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_cfa_flow_alloc *
 ***********************/


/* hwrm_cfa_flow_alloc_input (size:1024b/128B) */
struct hwrm_cfa_flow_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint16_t	flags;
	/* tunnel is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_TUNNEL       UINT32_C(0x1)
	/* num_vlan is 2 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_MASK UINT32_C(0x6)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_SFT 1
	/* no tags */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_NONE \
		(UINT32_C(0x0) << 1)
	/* 1 tag */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_ONE \
		(UINT32_C(0x1) << 1)
	/* 2 tags */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_TWO \
		(UINT32_C(0x2) << 1)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_LAST \
		HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_NUM_VLAN_TWO
	/* Enumeration denoting the Flow Type. */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_MASK UINT32_C(0x38)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_SFT 3
	/* L2 flow */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_L2 \
		(UINT32_C(0x0) << 3)
	/* IPV4 flow */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_IPV4 \
		(UINT32_C(0x1) << 3)
	/* IPV6 flow */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_IPV6 \
		(UINT32_C(0x2) << 3)
	#define HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_LAST \
		HWRM_CFA_FLOW_ALLOC_INPUT_FLAGS_FLOWTYPE_IPV6
	/*
	 * Tx Flow: vf fid.
	 * Rx Flow: pf fid.
	 */
	uint16_t	src_fid;
	/* Tunnel handle valid when tunnel flag is set. */
	uint32_t	tunnel_handle;
	uint16_t	action_flags;
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_FWD \
		UINT32_C(0x1)
	/* recycle is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_RECYCLE \
		UINT32_C(0x2)
	/*
	 * Setting of this flag indicates drop action. If this flag is not set,
	 * then it should be considered accept action.
	 */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_DROP \
		UINT32_C(0x4)
	/* meter is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_METER \
		UINT32_C(0x8)
	/* tunnel is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_TUNNEL \
		UINT32_C(0x10)
	/* nat_src is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_NAT_SRC \
		UINT32_C(0x20)
	/* nat_dest is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_NAT_DEST \
		UINT32_C(0x40)
	/* nat_ipv4_address is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_NAT_IPV4_ADDRESS \
		UINT32_C(0x80)
	/* l2_header_rewrite is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_L2_HEADER_REWRITE \
		UINT32_C(0x100)
	/* ttl_decrement is 1 b */
	#define HWRM_CFA_FLOW_ALLOC_INPUT_ACTION_FLAGS_TTL_DECREMENT \
		UINT32_C(0x200)
	/*
	 * Tx Flow: pf or vf fid.
	 * Rx Flow: vf fid.
	 */
	uint16_t	dst_fid;
	/* VLAN tpid, valid when push_vlan flag is set. */
	uint16_t	l2_rewrite_vlan_tpid;
	/* VLAN tci, valid when push_vlan flag is set. */
	uint16_t	l2_rewrite_vlan_tci;
	/* Meter id, valid when meter flag is set. */
	uint16_t	act_meter_id;
	/* Flow with the same l2 context tcam key. */
	uint16_t	ref_flow_handle;
	/* This value sets the match value for the ethertype. */
	uint16_t	ethertype;
	/* valid when num tags is 1 or 2. */
	uint16_t	outer_vlan_tci;
	/* This value sets the match value for the Destination MAC address. */
	uint16_t	dmac[3];
	/* valid when num tags is 2. */
	uint16_t	inner_vlan_tci;
	/* This value sets the match value for the Source MAC address. */
	uint16_t	smac[3];
	/* The bit length of destination IP address mask. */
	uint8_t	ip_dst_mask_len;
	/* The bit length of source IP address mask. */
	uint8_t	ip_src_mask_len;
	/* The value of destination IPv4/IPv6 address. */
	uint32_t	ip_dst[4];
	/* The source IPv4/IPv6 address. */
	uint32_t	ip_src[4];
	/*
	 * The value of source port.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	l4_src_port;
	/*
	 * The value of source port mask.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	l4_src_port_mask;
	/*
	 * The value of destination port.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	l4_dst_port;
	/*
	 * The value of destination port mask.
	 * Applies to UDP and TCP traffic.
	 */
	uint16_t	l4_dst_port_mask;
	/*
	 * NAT IPv4/6 address based on address type flag.
	 * 0 values are ignored.
	 */
	uint32_t	nat_ip_address[4];
	/* L2 header re-write Destination MAC address. */
	uint16_t	l2_rewrite_dmac[3];
	/*
	 * The NAT source/destination port based on direction flag.
	 * Applies to UDP and TCP traffic.
	 * 0 values are ignored.
	 */
	uint16_t	nat_port;
	/* L2 header re-write Source MAC address. */
	uint16_t	l2_rewrite_smac[3];
	/* The value of ip protocol. */
	uint8_t	ip_proto;
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_cfa_flow_alloc_output (size:128b/16B) */
struct hwrm_cfa_flow_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Flow record index. */
	uint16_t	flow_handle;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_cfa_flow_free *
 **********************/


/* hwrm_cfa_flow_free_input (size:192b/24B) */
struct hwrm_cfa_flow_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Flow record index. */
	uint16_t	flow_handle;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_cfa_flow_free_output (size:256b/32B) */
struct hwrm_cfa_flow_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* packet is 64 b */
	uint64_t	packet;
	/* byte is 64 b */
	uint64_t	byte;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_cfa_flow_info *
 **********************/


/* hwrm_cfa_flow_info_input (size:192b/24B) */
struct hwrm_cfa_flow_info_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Flow record index. */
	uint16_t	flow_handle;
	/* Max flow handle */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_MAX_MASK \
		UINT32_C(0xfff)
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_MAX_SFT     0
	/* CNP flow handle */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_CNP_CNT \
		UINT32_C(0x1000)
	/* Direction rx = 1 */
	#define HWRM_CFA_FLOW_INFO_INPUT_FLOW_HANDLE_DIR_RX \
		UINT32_C(0x8000)
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_cfa_flow_info_output (size:448b/56B) */
struct hwrm_cfa_flow_info_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* flags is 8 b */
	uint8_t	flags;
	/* profile is 8 b */
	uint8_t	profile;
	/* src_fid is 16 b */
	uint16_t	src_fid;
	/* dst_fid is 16 b */
	uint16_t	dst_fid;
	/* l2_ctxt_id is 16 b */
	uint16_t	l2_ctxt_id;
	/* em_info is 64 b */
	uint64_t	em_info;
	/* tcam_info is 64 b */
	uint64_t	tcam_info;
	/* vfp_tcam_info is 64 b */
	uint64_t	vfp_tcam_info;
	/* ar_id is 16 b */
	uint16_t	ar_id;
	/* flow_handle is 16 b */
	uint16_t	flow_handle;
	/* tunnel_handle is 32 b */
	uint32_t	tunnel_handle;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_cfa_flow_flush *
 ***********************/


/* hwrm_cfa_flow_flush_input (size:192b/24B) */
struct hwrm_cfa_flow_flush_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_cfa_flow_flush_output (size:128b/16B) */
struct hwrm_cfa_flow_flush_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_cfa_flow_stats *
 ***********************/


/* hwrm_cfa_flow_stats_input (size:320b/40B) */
struct hwrm_cfa_flow_stats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Flow handle. */
	uint16_t	num_flows;
	/* Flow handle. */
	uint16_t	flow_handle_0;
	/* Flow handle. */
	uint16_t	flow_handle_1;
	/* Flow handle. */
	uint16_t	flow_handle_2;
	/* Flow handle. */
	uint16_t	flow_handle_3;
	/* Flow handle. */
	uint16_t	flow_handle_4;
	/* Flow handle. */
	uint16_t	flow_handle_5;
	/* Flow handle. */
	uint16_t	flow_handle_6;
	/* Flow handle. */
	uint16_t	flow_handle_7;
	/* Flow handle. */
	uint16_t	flow_handle_8;
	/* Flow handle. */
	uint16_t	flow_handle_9;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_cfa_flow_stats_output (size:1408b/176B) */
struct hwrm_cfa_flow_stats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* packet_0 is 64 b */
	uint64_t	packet_0;
	/* packet_1 is 64 b */
	uint64_t	packet_1;
	/* packet_2 is 64 b */
	uint64_t	packet_2;
	/* packet_3 is 64 b */
	uint64_t	packet_3;
	/* packet_4 is 64 b */
	uint64_t	packet_4;
	/* packet_5 is 64 b */
	uint64_t	packet_5;
	/* packet_6 is 64 b */
	uint64_t	packet_6;
	/* packet_7 is 64 b */
	uint64_t	packet_7;
	/* packet_8 is 64 b */
	uint64_t	packet_8;
	/* packet_9 is 64 b */
	uint64_t	packet_9;
	/* byte_0 is 64 b */
	uint64_t	byte_0;
	/* byte_1 is 64 b */
	uint64_t	byte_1;
	/* byte_2 is 64 b */
	uint64_t	byte_2;
	/* byte_3 is 64 b */
	uint64_t	byte_3;
	/* byte_4 is 64 b */
	uint64_t	byte_4;
	/* byte_5 is 64 b */
	uint64_t	byte_5;
	/* byte_6 is 64 b */
	uint64_t	byte_6;
	/* byte_7 is 64 b */
	uint64_t	byte_7;
	/* byte_8 is 64 b */
	uint64_t	byte_8;
	/* byte_9 is 64 b */
	uint64_t	byte_9;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_cfa_vf_pair_alloc *
 **************************/


/* hwrm_cfa_vf_pair_alloc_input (size:448b/56B) */
struct hwrm_cfa_vf_pair_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t	vf_a_id;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t	vf_b_id;
	uint8_t	unused_0[4];
	/* VF Pair name (32 byte string). */
	char	pair_name[32];
} __attribute__((packed));

/* hwrm_cfa_vf_pair_alloc_output (size:128b/16B) */
struct hwrm_cfa_vf_pair_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_cfa_vf_pair_free *
 *************************/


/* hwrm_cfa_vf_pair_free_input (size:384b/48B) */
struct hwrm_cfa_vf_pair_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* VF Pair name (32 byte string). */
	char	pair_name[32];
} __attribute__((packed));

/* hwrm_cfa_vf_pair_free_output (size:128b/16B) */
struct hwrm_cfa_vf_pair_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_cfa_vf_pair_info *
 *************************/


/* hwrm_cfa_vf_pair_info_input (size:448b/56B) */
struct hwrm_cfa_vf_pair_info_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* If this flag is set, lookup by name else lookup by index. */
	#define HWRM_CFA_VF_PAIR_INFO_INPUT_FLAGS_LOOKUP_TYPE     UINT32_C(0x1)
	/* vf pair table index. */
	uint16_t	vf_pair_index;
	uint8_t	unused_0[2];
	/* VF Pair name (32 byte string). */
	char	vf_pair_name[32];
} __attribute__((packed));

/* hwrm_cfa_vf_pair_info_output (size:512b/64B) */
struct hwrm_cfa_vf_pair_info_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* vf pair table index. */
	uint16_t	next_vf_pair_index;
	/* vf pair member a's vf_fid. */
	uint16_t	vf_a_fid;
	/* vf pair member a's Linux logical VF number. */
	uint16_t	vf_a_index;
	/* vf pair member b's vf_fid. */
	uint16_t	vf_b_fid;
	/* vf pair member a's Linux logical VF number. */
	uint16_t	vf_b_index;
	/* vf pair state. */
	uint8_t	pair_state;
	/* Pair has been allocated */
	#define HWRM_CFA_VF_PAIR_INFO_OUTPUT_PAIR_STATE_ALLOCATED UINT32_C(0x1)
	/* Both pair members are active */
	#define HWRM_CFA_VF_PAIR_INFO_OUTPUT_PAIR_STATE_ACTIVE    UINT32_C(0x2)
	#define HWRM_CFA_VF_PAIR_INFO_OUTPUT_PAIR_STATE_LAST \
		HWRM_CFA_VF_PAIR_INFO_OUTPUT_PAIR_STATE_ACTIVE
	uint8_t	unused_0[5];
	/* VF Pair name (32 byte string). */
	char	pair_name[32];
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_cfa_pair_alloc *
 ***********************/


/* hwrm_cfa_pair_alloc_input (size:576b/72B) */
struct hwrm_cfa_pair_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Pair mode (0-vf2fn, 1-rep2fn, 2-rep2rep, 3-proxy, 4-pfpair, 5-rep2fn_mod). */
	uint8_t	pair_mode;
	/* Pair between VF on local host with PF or VF on specified host. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_VF2FN         UINT32_C(0x0)
	/* Pair between REP on local host with PF or VF on specified host. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_REP2FN        UINT32_C(0x1)
	/* Pair between REP on local host with REP on specified host. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_REP2REP       UINT32_C(0x2)
	/* Pair for the proxy interface. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_PROXY         UINT32_C(0x3)
	/* Pair for the PF interface. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_PFPAIR        UINT32_C(0x4)
	/* Modify exiting rep2fn pair and move pair to new PF. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_REP2FN_MOD    UINT32_C(0x5)
	/* Modify exiting rep2fn pairs paired with same PF and move pairs to new PF. */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_REP2FN_MODALL UINT32_C(0x6)
	#define HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_LAST \
		HWRM_CFA_PAIR_ALLOC_INPUT_PAIR_MODE_REP2FN_MODALL
	uint8_t	unused_0;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t	vf_a_id;
	/* Logical Host (0xff-local host). */
	uint8_t	host_b_id;
	/* Logical PF (0xff-PF for command channel). */
	uint8_t	pf_b_id;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t	vf_b_id;
	/* Loopback port (0xff-internal loopback), valid for mode-3. */
	uint8_t	port_id;
	/* Priority used for encap of loopback packets valid for mode-3. */
	uint8_t	pri;
	/* New PF for rep2fn modify, valid for mode 5. */
	uint16_t	new_pf_fid;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the q_ab field to be
	 * configured.
	 */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_ENABLES_Q_AB_VALID      UINT32_C(0x1)
	/*
	 * This bit must be '1' for the q_ba field to be
	 * configured.
	 */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_ENABLES_Q_BA_VALID      UINT32_C(0x2)
	/*
	 * This bit must be '1' for the fc_ab field to be
	 * configured.
	 */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_ENABLES_FC_AB_VALID     UINT32_C(0x4)
	/*
	 * This bit must be '1' for the fc_ba field to be
	 * configured.
	 */
	#define HWRM_CFA_PAIR_ALLOC_INPUT_ENABLES_FC_BA_VALID     UINT32_C(0x8)
	/* VF Pair name (32 byte string). */
	char	pair_name[32];
	/*
	 * The q_ab value specifies the logical index of the TX/RX CoS
	 * queue to be assigned for traffic in the A to B direction of
	 * the interface pair. The default value is 0.
	 */
	uint8_t	q_ab;
	/*
	 * The q_ba value specifies the logical index of the TX/RX CoS
	 * queue to be assigned for traffic in the B to A direction of
	 * the interface pair. The default value is 1.
	 */
	uint8_t	q_ba;
	/*
	 * Specifies whether RX ring flow control is disabled (0) or enabled
	 * (1) in the A to B direction. The default value is 0, meaning that
	 * packets will be dropped when the B-side RX rings are full.
	 */
	uint8_t	fc_ab;
	/*
	 * Specifies whether RX ring flow control is disabled (0) or enabled
	 * (1) in the B to A direction. The default value is 1, meaning that
	 * the RX CoS queue will be flow controlled when the A-side RX rings
	 * are full.
	 */
	uint8_t	fc_ba;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_cfa_pair_alloc_output (size:192b/24B) */
struct hwrm_cfa_pair_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Only valid for modes 1 and 2. */
	uint16_t	rx_cfa_code_a;
	/* Only valid for modes 1 and 2. */
	uint16_t	tx_cfa_action_a;
	/* Only valid for mode 2. */
	uint16_t	rx_cfa_code_b;
	/* Only valid for mode 2. */
	uint16_t	tx_cfa_action_b;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_cfa_pair_free *
 **********************/


/* hwrm_cfa_pair_free_input (size:384b/48B) */
struct hwrm_cfa_pair_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* VF Pair name (32 byte string). */
	char	pair_name[32];
} __attribute__((packed));

/* hwrm_cfa_pair_free_output (size:128b/16B) */
struct hwrm_cfa_pair_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_cfa_pair_info *
 **********************/


/* hwrm_cfa_pair_info_input (size:448b/56B) */
struct hwrm_cfa_pair_info_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	flags;
	/* If this flag is set, lookup by name else lookup by index. */
	#define HWRM_CFA_PAIR_INFO_INPUT_FLAGS_LOOKUP_TYPE      UINT32_C(0x1)
	/* If this flag is set, lookup by PF id and VF id. */
	#define HWRM_CFA_PAIR_INFO_INPUT_FLAGS_LOOKUP_REPRE     UINT32_C(0x2)
	/* Pair table index. */
	uint16_t	pair_index;
	/* Pair pf index. */
	uint8_t	pair_pfid;
	/* Pair vf index. */
	uint8_t	pair_vfid;
	/* Pair name (32 byte string). */
	char	pair_name[32];
} __attribute__((packed));

/* hwrm_cfa_pair_info_output (size:576b/72B) */
struct hwrm_cfa_pair_info_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Pair table index. */
	uint16_t	next_pair_index;
	/* Pair member a's fid. */
	uint16_t	a_fid;
	/* Logical host number. */
	uint8_t	host_a_index;
	/* Logical PF number. */
	uint8_t	pf_a_index;
	/* Pair member a's Linux logical VF number. */
	uint16_t	vf_a_index;
	/* Rx CFA code. */
	uint16_t	rx_cfa_code_a;
	/* Tx CFA action. */
	uint16_t	tx_cfa_action_a;
	/* Pair member b's fid. */
	uint16_t	b_fid;
	/* Logical host number. */
	uint8_t	host_b_index;
	/* Logical PF number. */
	uint8_t	pf_b_index;
	/* Pair member a's Linux logical VF number. */
	uint16_t	vf_b_index;
	/* Rx CFA code. */
	uint16_t	rx_cfa_code_b;
	/* Tx CFA action. */
	uint16_t	tx_cfa_action_b;
	/* Pair mode (0-vf2fn, 1-rep2fn, 2-rep2rep, 3-proxy, 4-pfpair). */
	uint8_t	pair_mode;
	/* Pair between VF on local host with PF or VF on specified host. */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_VF2FN   UINT32_C(0x0)
	/* Pair between REP on local host with PF or VF on specified host. */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_REP2FN  UINT32_C(0x1)
	/* Pair between REP on local host with REP on specified host. */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_REP2REP UINT32_C(0x2)
	/* Pair for the proxy interface. */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_PROXY   UINT32_C(0x3)
	/* Pair for the PF interface. */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_PFPAIR  UINT32_C(0x4)
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_LAST \
		HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_MODE_PFPAIR
	/* Pair state. */
	uint8_t	pair_state;
	/* Pair has been allocated */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_STATE_ALLOCATED UINT32_C(0x1)
	/* Both pair members are active */
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_STATE_ACTIVE    UINT32_C(0x2)
	#define HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_STATE_LAST \
		HWRM_CFA_PAIR_INFO_OUTPUT_PAIR_STATE_ACTIVE
	/* Pair name (32 byte string). */
	char	pair_name[32];
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_cfa_vfr_alloc *
 **********************/


/* hwrm_cfa_vfr_alloc_input (size:448b/56B) */
struct hwrm_cfa_vfr_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Logical VF number (range: 0 -> MAX_VFS -1). */
	uint16_t	vf_id;
	/*
	 * This field is reserved for the future use.
	 * It shall be set to 0.
	 */
	uint16_t	reserved;
	uint8_t	unused_0[4];
	/* VF Representor name (32 byte string). */
	char	vfr_name[32];
} __attribute__((packed));

/* hwrm_cfa_vfr_alloc_output (size:128b/16B) */
struct hwrm_cfa_vfr_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Rx CFA code. */
	uint16_t	rx_cfa_code;
	/* Tx CFA action. */
	uint16_t	tx_cfa_action;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_cfa_vfr_free *
 *********************/


/* hwrm_cfa_vfr_free_input (size:384b/48B) */
struct hwrm_cfa_vfr_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* VF Representor name (32 byte string). */
	char	vfr_name[32];
} __attribute__((packed));

/* hwrm_cfa_vfr_free_output (size:128b/16B) */
struct hwrm_cfa_vfr_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************************
 * hwrm_tunnel_dst_port_query *
 ******************************/


/* hwrm_tunnel_dst_port_query_input (size:192b/24B) */
struct hwrm_tunnel_dst_port_query_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Enhance Generic Routing Encapsulation (GRE version 1) inside IP datagram payload */
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_IPGRE_V1 \
		UINT32_C(0xa)
	#define HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_LAST \
		HWRM_TUNNEL_DST_PORT_QUERY_INPUT_TUNNEL_TYPE_IPGRE_V1
	uint8_t	unused_0[7];
} __attribute__((packed));

/* hwrm_tunnel_dst_port_query_output (size:128b/16B) */
struct hwrm_tunnel_dst_port_query_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * This field represents the identifier of L4 destination port
	 * used for the given tunnel type. This field is valid for
	 * specific tunnel types that use layer 4 (e.g. UDP)
	 * transports for tunneling.
	 */
	uint16_t	tunnel_dst_port_id;
	/*
	 * This field represents the value of L4 destination port
	 * identified by tunnel_dst_port_id. This field is valid for
	 * specific tunnel types that use layer 4 (e.g. UDP)
	 * transports for tunneling.
	 * This field is in network byte order.
	 *
	 * A value of 0 means that the destination port is not
	 * configured.
	 */
	uint16_t	tunnel_dst_port_val;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************************
 * hwrm_tunnel_dst_port_alloc *
 ******************************/


/* hwrm_tunnel_dst_port_alloc_input (size:192b/24B) */
struct hwrm_tunnel_dst_port_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Enhance Generic Routing Encapsulation (GRE version 1) inside IP datagram payload */
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_IPGRE_V1 \
		UINT32_C(0xa)
	#define HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_LAST \
		HWRM_TUNNEL_DST_PORT_ALLOC_INPUT_TUNNEL_TYPE_IPGRE_V1
	uint8_t	unused_0;
	/*
	 * This field represents the value of L4 destination port used
	 * for the given tunnel type. This field is valid for
	 * specific tunnel types that use layer 4 (e.g. UDP)
	 * transports for tunneling.
	 *
	 * This field is in network byte order.
	 *
	 * A value of 0 shall fail the command.
	 */
	uint16_t	tunnel_dst_port_val;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_tunnel_dst_port_alloc_output (size:128b/16B) */
struct hwrm_tunnel_dst_port_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Identifier of a tunnel L4 destination port value. Only applies to tunnel
	 * types that has l4 destination port parameters.
	 */
	uint16_t	tunnel_dst_port_id;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************
 * hwrm_tunnel_dst_port_free *
 *****************************/


/* hwrm_tunnel_dst_port_free_input (size:192b/24B) */
struct hwrm_tunnel_dst_port_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Tunnel Type. */
	uint8_t	tunnel_type;
	/* Virtual eXtensible Local Area Network (VXLAN) */
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_VXLAN \
		UINT32_C(0x1)
	/* Generic Network Virtualization Encapsulation (Geneve) */
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_GENEVE \
		UINT32_C(0x5)
	/* IPV4 over virtual eXtensible Local Area Network (IPV4oVXLAN) */
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_VXLAN_V4 \
		UINT32_C(0x9)
	/* Enhance Generic Routing Encapsulation (GRE version 1) inside IP datagram payload */
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_IPGRE_V1 \
		UINT32_C(0xa)
	#define HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_LAST \
		HWRM_TUNNEL_DST_PORT_FREE_INPUT_TUNNEL_TYPE_IPGRE_V1
	uint8_t	unused_0;
	/*
	 * Identifier of a tunnel L4 destination port value. Only applies to tunnel
	 * types that has l4 destination port parameters.
	 */
	uint16_t	tunnel_dst_port_id;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_tunnel_dst_port_free_output (size:128b/16B) */
struct hwrm_tunnel_dst_port_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_1[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* ctx_hw_stats (size:1280b/160B) */
struct ctx_hw_stats {
	/* Number of received unicast packets */
	uint64_t	rx_ucast_pkts;
	/* Number of received multicast packets */
	uint64_t	rx_mcast_pkts;
	/* Number of received broadcast packets */
	uint64_t	rx_bcast_pkts;
	/* Number of discarded packets on received path */
	uint64_t	rx_discard_pkts;
	/* Number of dropped packets on received path */
	uint64_t	rx_drop_pkts;
	/* Number of received bytes for unicast traffic */
	uint64_t	rx_ucast_bytes;
	/* Number of received bytes for multicast traffic */
	uint64_t	rx_mcast_bytes;
	/* Number of received bytes for broadcast traffic */
	uint64_t	rx_bcast_bytes;
	/* Number of transmitted unicast packets */
	uint64_t	tx_ucast_pkts;
	/* Number of transmitted multicast packets */
	uint64_t	tx_mcast_pkts;
	/* Number of transmitted broadcast packets */
	uint64_t	tx_bcast_pkts;
	/* Number of discarded packets on transmit path */
	uint64_t	tx_discard_pkts;
	/* Number of dropped packets on transmit path */
	uint64_t	tx_drop_pkts;
	/* Number of transmitted bytes for unicast traffic */
	uint64_t	tx_ucast_bytes;
	/* Number of transmitted bytes for multicast traffic */
	uint64_t	tx_mcast_bytes;
	/* Number of transmitted bytes for broadcast traffic */
	uint64_t	tx_bcast_bytes;
	/* Number of TPA packets */
	uint64_t	tpa_pkts;
	/* Number of TPA bytes */
	uint64_t	tpa_bytes;
	/* Number of TPA events */
	uint64_t	tpa_events;
	/* Number of TPA aborts */
	uint64_t	tpa_aborts;
} __attribute__((packed));

/***********************
 * hwrm_stat_ctx_alloc *
 ***********************/


/* hwrm_stat_ctx_alloc_input (size:256b/32B) */
struct hwrm_stat_ctx_alloc_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* This is the address for statistic block. */
	uint64_t	stats_dma_addr;
	/*
	 * The statistic block update period in ms.
	 * e.g. 250ms, 500ms, 750ms, 1000ms.
	 * If update_period_ms is 0, then the stats update
	 * shall be never done and the DMA address shall not be used.
	 * In this case, the stat block can only be read by
	 * hwrm_stat_ctx_query command.
	 */
	uint32_t	update_period_ms;
	/*
	 * This field is used to specify statistics context specific
	 * configuration flags.
	 */
	uint8_t	stat_ctx_flags;
	/*
	 * When this bit is set to '1', the statistics context shall be
	 * allocated for RoCE traffic only. In this case, traffic other
	 * than offloaded RoCE traffic shall not be included in this
	 * statistic context.
	 * When this bit is set to '0', the statistics context shall be
	 * used for the network traffic other than offloaded RoCE traffic.
	 */
	#define HWRM_STAT_CTX_ALLOC_INPUT_STAT_CTX_FLAGS_ROCE     UINT32_C(0x1)
	uint8_t	unused_0[3];
} __attribute__((packed));

/* hwrm_stat_ctx_alloc_output (size:128b/16B) */
struct hwrm_stat_ctx_alloc_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This is the statistics context ID value. */
	uint32_t	stat_ctx_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**********************
 * hwrm_stat_ctx_free *
 **********************/


/* hwrm_stat_ctx_free_input (size:192b/24B) */
struct hwrm_stat_ctx_free_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* ID of the statistics context that is being queried. */
	uint32_t	stat_ctx_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_stat_ctx_free_output (size:128b/16B) */
struct hwrm_stat_ctx_free_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* This is the statistics context ID value. */
	uint32_t	stat_ctx_id;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***********************
 * hwrm_stat_ctx_query *
 ***********************/


/* hwrm_stat_ctx_query_input (size:192b/24B) */
struct hwrm_stat_ctx_query_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* ID of the statistics context that is being queried. */
	uint32_t	stat_ctx_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_stat_ctx_query_output (size:1408b/176B) */
struct hwrm_stat_ctx_query_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of transmitted unicast packets */
	uint64_t	tx_ucast_pkts;
	/* Number of transmitted multicast packets */
	uint64_t	tx_mcast_pkts;
	/* Number of transmitted broadcast packets */
	uint64_t	tx_bcast_pkts;
	/* Number of transmitted packets with error */
	uint64_t	tx_err_pkts;
	/* Number of dropped packets on transmit path */
	uint64_t	tx_drop_pkts;
	/* Number of transmitted bytes for unicast traffic */
	uint64_t	tx_ucast_bytes;
	/* Number of transmitted bytes for multicast traffic */
	uint64_t	tx_mcast_bytes;
	/* Number of transmitted bytes for broadcast traffic */
	uint64_t	tx_bcast_bytes;
	/* Number of received unicast packets */
	uint64_t	rx_ucast_pkts;
	/* Number of received multicast packets */
	uint64_t	rx_mcast_pkts;
	/* Number of received broadcast packets */
	uint64_t	rx_bcast_pkts;
	/* Number of received packets with error */
	uint64_t	rx_err_pkts;
	/* Number of dropped packets on received path */
	uint64_t	rx_drop_pkts;
	/* Number of received bytes for unicast traffic */
	uint64_t	rx_ucast_bytes;
	/* Number of received bytes for multicast traffic */
	uint64_t	rx_mcast_bytes;
	/* Number of received bytes for broadcast traffic */
	uint64_t	rx_bcast_bytes;
	/* Number of aggregated unicast packets */
	uint64_t	rx_agg_pkts;
	/* Number of aggregated unicast bytes */
	uint64_t	rx_agg_bytes;
	/* Number of aggregation events */
	uint64_t	rx_agg_events;
	/* Number of aborted aggregations */
	uint64_t	rx_agg_aborts;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_stat_ctx_clr_stats *
 ***************************/


/* hwrm_stat_ctx_clr_stats_input (size:192b/24B) */
struct hwrm_stat_ctx_clr_stats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* ID of the statistics context that is being queried. */
	uint32_t	stat_ctx_id;
	uint8_t	unused_0[4];
} __attribute__((packed));

/* hwrm_stat_ctx_clr_stats_output (size:128b/16B) */
struct hwrm_stat_ctx_clr_stats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/********************
 * hwrm_pcie_qstats *
 ********************/


/* hwrm_pcie_qstats_input (size:256b/32B) */
struct hwrm_pcie_qstats_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * The size of PCIe statistics block in bytes.
	 * Firmware will DMA the PCIe statistics to
	 * the host with this field size in the response.
	 */
	uint16_t	pcie_stat_size;
	uint8_t	unused_0[6];
	/*
	 * This is the host address where
	 * PCIe statistics will be stored
	 */
	uint64_t	pcie_stat_host_addr;
} __attribute__((packed));

/* hwrm_pcie_qstats_output (size:128b/16B) */
struct hwrm_pcie_qstats_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* The size of PCIe statistics block in bytes. */
	uint16_t	pcie_stat_size;
	uint8_t	unused_0[5];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* Port Tx Statistics Formats */
/* tx_port_stats (size:3264b/408B) */
struct tx_port_stats {
	/* Total Number of 64 Bytes frames transmitted */
	uint64_t	tx_64b_frames;
	/* Total Number of 65-127 Bytes frames transmitted */
	uint64_t	tx_65b_127b_frames;
	/* Total Number of 128-255 Bytes frames transmitted */
	uint64_t	tx_128b_255b_frames;
	/* Total Number of 256-511 Bytes frames transmitted */
	uint64_t	tx_256b_511b_frames;
	/* Total Number of 512-1023 Bytes frames transmitted */
	uint64_t	tx_512b_1023b_frames;
	/* Total Number of 1024-1518 Bytes frames transmitted */
	uint64_t	tx_1024b_1518_frames;
	/*
	 * Total Number of each good VLAN (exludes FCS errors)
	 * frame transmitted which is 1519 to 1522 bytes in length
	 * inclusive (excluding framing bits but including FCS bytes).
	 */
	uint64_t	tx_good_vlan_frames;
	/* Total Number of 1519-2047 Bytes frames transmitted */
	uint64_t	tx_1519b_2047_frames;
	/* Total Number of 2048-4095 Bytes frames transmitted */
	uint64_t	tx_2048b_4095b_frames;
	/* Total Number of 4096-9216 Bytes frames transmitted */
	uint64_t	tx_4096b_9216b_frames;
	/* Total Number of 9217-16383 Bytes frames transmitted */
	uint64_t	tx_9217b_16383b_frames;
	/* Total Number of good frames transmitted */
	uint64_t	tx_good_frames;
	/* Total Number of frames transmitted */
	uint64_t	tx_total_frames;
	/* Total number of unicast frames transmitted */
	uint64_t	tx_ucast_frames;
	/* Total number of multicast frames transmitted */
	uint64_t	tx_mcast_frames;
	/* Total number of broadcast frames transmitted */
	uint64_t	tx_bcast_frames;
	/* Total number of PAUSE control frames transmitted */
	uint64_t	tx_pause_frames;
	/*
	 * Total number of PFC/per-priority PAUSE
	 * control frames transmitted
	 */
	uint64_t	tx_pfc_frames;
	/* Total number of jabber frames transmitted */
	uint64_t	tx_jabber_frames;
	/* Total number of frames transmitted with FCS error */
	uint64_t	tx_fcs_err_frames;
	/* Total number of control frames transmitted */
	uint64_t	tx_control_frames;
	/* Total number of over-sized frames transmitted */
	uint64_t	tx_oversz_frames;
	/* Total number of frames with single deferral */
	uint64_t	tx_single_dfrl_frames;
	/* Total number of frames with multiple deferrals */
	uint64_t	tx_multi_dfrl_frames;
	/* Total number of frames with single collision */
	uint64_t	tx_single_coll_frames;
	/* Total number of frames with multiple collisions */
	uint64_t	tx_multi_coll_frames;
	/* Total number of frames with late collisions */
	uint64_t	tx_late_coll_frames;
	/* Total number of frames with excessive collisions */
	uint64_t	tx_excessive_coll_frames;
	/* Total number of fragmented frames transmitted */
	uint64_t	tx_frag_frames;
	/* Total number of transmit errors */
	uint64_t	tx_err;
	/* Total number of single VLAN tagged frames transmitted */
	uint64_t	tx_tagged_frames;
	/* Total number of double VLAN tagged frames transmitted */
	uint64_t	tx_dbl_tagged_frames;
	/* Total number of runt frames transmitted */
	uint64_t	tx_runt_frames;
	/* Total number of TX FIFO under runs */
	uint64_t	tx_fifo_underruns;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 0 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri0;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 1 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri1;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 2 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri2;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 3 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri3;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 4 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri4;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 5 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri5;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 6 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri6;
	/*
	 * Total number of PFC frames with PFC enabled bit for
	 * Pri 7 transmitted
	 */
	uint64_t	tx_pfc_ena_frames_pri7;
	/* Total number of EEE LPI Events on TX */
	uint64_t	tx_eee_lpi_events;
	/* EEE LPI Duration Counter on TX */
	uint64_t	tx_eee_lpi_duration;
	/*
	 * Total number of Link Level Flow Control (LLFC) messages
	 * transmitted
	 */
	uint64_t	tx_llfc_logical_msgs;
	/* Total number of HCFC messages transmitted */
	uint64_t	tx_hcfc_msgs;
	/* Total number of TX collisions */
	uint64_t	tx_total_collisions;
	/* Total number of transmitted bytes */
	uint64_t	tx_bytes;
	/* Total number of end-to-end HOL frames */
	uint64_t	tx_xthol_frames;
	/* Total Tx Drops per Port reported by STATS block */
	uint64_t	tx_stat_discard;
	/* Total Tx Error Drops per Port reported by STATS block */
	uint64_t	tx_stat_error;
} __attribute__((packed));

/* Port Rx Statistics Formats */
/* rx_port_stats (size:4224b/528B) */
struct rx_port_stats {
	/* Total Number of 64 Bytes frames received */
	uint64_t	rx_64b_frames;
	/* Total Number of 65-127 Bytes frames received */
	uint64_t	rx_65b_127b_frames;
	/* Total Number of 128-255 Bytes frames received */
	uint64_t	rx_128b_255b_frames;
	/* Total Number of 256-511 Bytes frames received */
	uint64_t	rx_256b_511b_frames;
	/* Total Number of 512-1023 Bytes frames received */
	uint64_t	rx_512b_1023b_frames;
	/* Total Number of 1024-1518 Bytes frames received */
	uint64_t	rx_1024b_1518_frames;
	/*
	 * Total Number of each good VLAN (exludes FCS errors)
	 * frame received which is 1519 to 1522 bytes in length
	 * inclusive (excluding framing bits but including FCS bytes).
	 */
	uint64_t	rx_good_vlan_frames;
	/* Total Number of 1519-2047 Bytes frames received */
	uint64_t	rx_1519b_2047b_frames;
	/* Total Number of 2048-4095 Bytes frames received */
	uint64_t	rx_2048b_4095b_frames;
	/* Total Number of 4096-9216 Bytes frames received */
	uint64_t	rx_4096b_9216b_frames;
	/* Total Number of 9217-16383 Bytes frames received */
	uint64_t	rx_9217b_16383b_frames;
	/* Total number of frames received */
	uint64_t	rx_total_frames;
	/* Total number of unicast frames received */
	uint64_t	rx_ucast_frames;
	/* Total number of multicast frames received */
	uint64_t	rx_mcast_frames;
	/* Total number of broadcast frames received */
	uint64_t	rx_bcast_frames;
	/* Total number of received frames with FCS error */
	uint64_t	rx_fcs_err_frames;
	/* Total number of control frames received */
	uint64_t	rx_ctrl_frames;
	/* Total number of PAUSE frames received */
	uint64_t	rx_pause_frames;
	/* Total number of PFC frames received */
	uint64_t	rx_pfc_frames;
	/*
	 * Total number of frames received with an unsupported
	 * opcode
	 */
	uint64_t	rx_unsupported_opcode_frames;
	/*
	 * Total number of frames received with an unsupported
	 * DA for pause and PFC
	 */
	uint64_t	rx_unsupported_da_pausepfc_frames;
	/* Total number of frames received with an unsupported SA */
	uint64_t	rx_wrong_sa_frames;
	/* Total number of received packets with alignment error */
	uint64_t	rx_align_err_frames;
	/* Total number of received frames with out-of-range length */
	uint64_t	rx_oor_len_frames;
	/* Total number of received frames with error termination */
	uint64_t	rx_code_err_frames;
	/*
	 * Total number of received frames with a false carrier is
	 * detected during idle, as defined by RX_ER samples active
	 * and RXD is 0xE. The event is reported along with the
	 * statistics generated on the next received frame. Only
	 * one false carrier condition can be detected and logged
	 * between frames.
	 *
	 * Carrier event, valid for 10M/100M speed modes only.
	 */
	uint64_t	rx_false_carrier_frames;
	/* Total number of over-sized frames received */
	uint64_t	rx_ovrsz_frames;
	/* Total number of jabber packets received */
	uint64_t	rx_jbr_frames;
	/* Total number of received frames with MTU error */
	uint64_t	rx_mtu_err_frames;
	/* Total number of received frames with CRC match */
	uint64_t	rx_match_crc_frames;
	/* Total number of frames received promiscuously */
	uint64_t	rx_promiscuous_frames;
	/*
	 * Total number of received frames with one or two VLAN
	 * tags
	 */
	uint64_t	rx_tagged_frames;
	/* Total number of received frames with two VLAN tags */
	uint64_t	rx_double_tagged_frames;
	/* Total number of truncated frames received */
	uint64_t	rx_trunc_frames;
	/* Total number of good frames (without errors) received */
	uint64_t	rx_good_frames;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 0
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri0;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 1
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri1;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 2
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri2;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 3
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri3;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 4
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri4;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 5
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri5;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 6
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri6;
	/*
	 * Total number of received PFC frames with transition from
	 * XON to XOFF on Pri 7
	 */
	uint64_t	rx_pfc_xon2xoff_frames_pri7;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 0
	 */
	uint64_t	rx_pfc_ena_frames_pri0;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 1
	 */
	uint64_t	rx_pfc_ena_frames_pri1;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 2
	 */
	uint64_t	rx_pfc_ena_frames_pri2;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 3
	 */
	uint64_t	rx_pfc_ena_frames_pri3;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 4
	 */
	uint64_t	rx_pfc_ena_frames_pri4;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 5
	 */
	uint64_t	rx_pfc_ena_frames_pri5;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 6
	 */
	uint64_t	rx_pfc_ena_frames_pri6;
	/*
	 * Total number of received PFC frames with PFC enabled
	 * bit for Pri 7
	 */
	uint64_t	rx_pfc_ena_frames_pri7;
	/* Total Number of frames received with SCH CRC error */
	uint64_t	rx_sch_crc_err_frames;
	/* Total Number of under-sized frames received */
	uint64_t	rx_undrsz_frames;
	/* Total Number of fragmented frames received */
	uint64_t	rx_frag_frames;
	/* Total number of RX EEE LPI Events */
	uint64_t	rx_eee_lpi_events;
	/* EEE LPI Duration Counter on RX */
	uint64_t	rx_eee_lpi_duration;
	/*
	 * Total number of physical type Link Level Flow Control
	 * (LLFC) messages received
	 */
	uint64_t	rx_llfc_physical_msgs;
	/*
	 * Total number of logical type Link Level Flow Control
	 * (LLFC) messages received
	 */
	uint64_t	rx_llfc_logical_msgs;
	/*
	 * Total number of logical type Link Level Flow Control
	 * (LLFC) messages received with CRC error
	 */
	uint64_t	rx_llfc_msgs_with_crc_err;
	/* Total number of HCFC messages received */
	uint64_t	rx_hcfc_msgs;
	/* Total number of HCFC messages received with CRC error */
	uint64_t	rx_hcfc_msgs_with_crc_err;
	/* Total number of received bytes */
	uint64_t	rx_bytes;
	/* Total number of bytes received in runt frames */
	uint64_t	rx_runt_bytes;
	/* Total number of runt frames received */
	uint64_t	rx_runt_frames;
	/* Total Rx Discards per Port reported by STATS block */
	uint64_t	rx_stat_discard;
	uint64_t	rx_stat_err;
} __attribute__((packed));

/* Port Rx Statistics extended Formats */
/* rx_port_stats_ext (size:320b/40B) */
struct rx_port_stats_ext {
	/* Number of times link state changed to down */
	uint64_t	link_down_events;
	/* Number of times the idle rings with pause bit are found */
	uint64_t	continuous_pause_events;
	/* Number of times the active rings pause bit resumed back */
	uint64_t	resume_pause_events;
	/* Number of times, the ROCE cos queue PFC is disabled to avoid pause flood/burst */
	uint64_t	continuous_roce_pause_events;
	/* Number of times, the ROCE cos queue PFC is enabled back */
	uint64_t	resume_roce_pause_events;
} __attribute__((packed));

/* PCIe Statistics Formats */
/* pcie_ctx_hw_stats (size:768b/96B) */
struct pcie_ctx_hw_stats {
	/* Number of physical layer receiver errors */
	uint64_t	pcie_pl_signal_integrity;
	/* Number of DLLP CRC errors detected by Data Link Layer */
	uint64_t	pcie_dl_signal_integrity;
	/*
	 * Number of TLP LCRC and sequence number errors detected
	 * by Data Link Layer
	 */
	uint64_t	pcie_tl_signal_integrity;
	/* Number of times LTSSM entered Recovery state */
	uint64_t	pcie_link_integrity;
	/* Number of TLP bytes that have been trasmitted */
	uint64_t	pcie_tx_traffic_rate;
	/* Number of TLP bytes that have been received */
	uint64_t	pcie_rx_traffic_rate;
	/* Number of DLLP bytes that have been trasmitted */
	uint64_t	pcie_tx_dllp_statistics;
	/* Number of DLLP bytes that have been received */
	uint64_t	pcie_rx_dllp_statistics;
	/*
	 * Number of times spent in each phase of gen3
	 * equalization
	 */
	uint64_t	pcie_equalization_time;
	/* Records the last 16 transitions of the LTSSM */
	uint32_t	pcie_ltssm_histogram[4];
	/*
	 * Record the last 8 reasons on why LTSSM transitioned
	 * to Recovery
	 */
	uint64_t	pcie_recovery_histogram;
} __attribute__((packed));

/**********************
 * hwrm_exec_fwd_resp *
 **********************/


/* hwrm_exec_fwd_resp_input (size:1024b/128B) */
struct hwrm_exec_fwd_resp_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is an encapsulated request. This request should
	 * be executed by the HWRM and the response should be
	 * provided in the response buffer inside the encapsulated
	 * request.
	 */
	uint32_t	encap_request[26];
	/*
	 * This value indicates the target id of the response to
	 * the encapsulated request.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	encap_resp_target_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_exec_fwd_resp_output (size:128b/16B) */
struct hwrm_exec_fwd_resp_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/************************
 * hwrm_reject_fwd_resp *
 ************************/


/* hwrm_reject_fwd_resp_input (size:1024b/128B) */
struct hwrm_reject_fwd_resp_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is an encapsulated request. This request should
	 * be rejected by the HWRM and the error response should be
	 * provided in the response buffer inside the encapsulated
	 * request.
	 */
	uint32_t	encap_request[26];
	/*
	 * This value indicates the target id of the response to
	 * the encapsulated request.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	encap_resp_target_id;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_reject_fwd_resp_output (size:128b/16B) */
struct hwrm_reject_fwd_resp_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************
 * hwrm_fwd_resp *
 *****************/


/* hwrm_fwd_resp_input (size:1024b/128B) */
struct hwrm_fwd_resp_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value indicates the target id of the encapsulated
	 * response.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - HWRM
	 */
	uint16_t	encap_resp_target_id;
	/*
	 * This value indicates the completion ring the encapsulated
	 * response will be optionally completed on.  If the value is
	 * -1, then no CR completion shall be generated for the
	 * encapsulated response. Any other value must be a
	 * valid CR ring_id value. If a valid encap_resp_cmpl_ring
	 * is provided, then a CR completion shall be generated for
	 * the encapsulated response.
	 */
	uint16_t	encap_resp_cmpl_ring;
	/* This field indicates the length of encapsulated response. */
	uint16_t	encap_resp_len;
	uint8_t	unused_0;
	uint8_t	unused_1;
	/*
	 * This is the host address where the encapsulated response
	 * will be written.
	 * This area must be 16B aligned and must be cleared to zero
	 * before the original request is made.
	 */
	uint64_t	encap_resp_addr;
	/* This is an encapsulated response. */
	uint32_t	encap_resp[24];
} __attribute__((packed));

/* hwrm_fwd_resp_output (size:128b/16B) */
struct hwrm_fwd_resp_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************************
 * hwrm_fwd_async_event_cmpl *
 *****************************/


/* hwrm_fwd_async_event_cmpl_input (size:320b/40B) */
struct hwrm_fwd_async_event_cmpl_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This value indicates the target id of the encapsulated
	 * asynchronous event.
	 * 0x0 - 0xFFF8 - Used for function ids
	 * 0xFFF8 - 0xFFFE - Reserved for internal processors
	 * 0xFFFF - Broadcast to all children VFs (only applicable when
	 * a PF is the requester)
	 */
	uint16_t	encap_async_event_target_id;
	uint8_t	unused_0[6];
	/* This is an encapsulated asynchronous event completion. */
	uint32_t	encap_async_event_cmpl[4];
} __attribute__((packed));

/* hwrm_fwd_async_event_cmpl_output (size:128b/16B) */
struct hwrm_fwd_async_event_cmpl_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_nvm_raw_write_blk *
 **************************/


/* hwrm_nvm_raw_write_blk_input (size:256b/32B) */
struct hwrm_nvm_raw_write_blk_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * 64-bit Host Source Address.
	 * This is the loation of the source data to be written.
	 */
	uint64_t	host_src_addr;
	/*
	 * 32-bit Destination Address.
	 * This is the NVRAM byte-offset where the source data will be written to.
	 */
	uint32_t	dest_addr;
	/* Length of data to be written, in bytes. */
	uint32_t	len;
} __attribute__((packed));

/* hwrm_nvm_raw_write_blk_output (size:128b/16B) */
struct hwrm_nvm_raw_write_blk_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*****************
 * hwrm_nvm_read *
 *****************/


/* hwrm_nvm_read_input (size:320b/40B) */
struct hwrm_nvm_read_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * 64-bit Host Destination Address.
	 * This is the host address where the data will be written to.
	 */
	uint64_t	host_dest_addr;
	/* The 0-based index of the directory entry. */
	uint16_t	dir_idx;
	uint8_t	unused_0[2];
	/* The NVRAM byte-offset to read from. */
	uint32_t	offset;
	/* The length of the data to be read, in bytes. */
	uint32_t	len;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_nvm_read_output (size:128b/16B) */
struct hwrm_nvm_read_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*********************
 * hwrm_nvm_raw_dump *
 *********************/


/* hwrm_nvm_raw_dump_input (size:256b/32B) */
struct hwrm_nvm_raw_dump_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * 64-bit Host Destination Address.
	 * This is the host address where the data will be written to.
	 */
	uint64_t	host_dest_addr;
	/* 32-bit NVRAM byte-offset to read from. */
	uint32_t	offset;
	/* Total length of NVRAM contents to be read, in bytes. */
	uint32_t	len;
} __attribute__((packed));

/* hwrm_nvm_raw_dump_output (size:128b/16B) */
struct hwrm_nvm_raw_dump_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_nvm_get_dir_entries *
 ****************************/


/* hwrm_nvm_get_dir_entries_input (size:192b/24B) */
struct hwrm_nvm_get_dir_entries_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * 64-bit Host Destination Address.
	 * This is the host address where the directory will be written.
	 */
	uint64_t	host_dest_addr;
} __attribute__((packed));

/* hwrm_nvm_get_dir_entries_output (size:128b/16B) */
struct hwrm_nvm_get_dir_entries_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_nvm_get_dir_info *
 *************************/


/* hwrm_nvm_get_dir_info_input (size:128b/16B) */
struct hwrm_nvm_get_dir_info_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_nvm_get_dir_info_output (size:192b/24B) */
struct hwrm_nvm_get_dir_info_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Number of directory entries in the directory. */
	uint32_t	entries;
	/* Size of each directory entry, in bytes. */
	uint32_t	entry_length;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/******************
 * hwrm_nvm_write *
 ******************/


/* hwrm_nvm_write_input (size:384b/48B) */
struct hwrm_nvm_write_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * 64-bit Host Source Address.
	 * This is where the source data is.
	 */
	uint64_t	host_src_addr;
	/* The Directory Entry Type (valid values are defined in the bnxnvm_directory_type enum defined in the file bnxnvm_defs.h). */
	uint16_t	dir_type;
	/*
	 * Directory ordinal.
	 * The 0-based instance of the combined Directory Entry Type and Extension.
	 */
	uint16_t	dir_ordinal;
	/* The Directory Entry Extension flags (see BNX_DIR_EXT_* in the file bnxnvm_defs.h). */
	uint16_t	dir_ext;
	/* Directory Entry Attribute flags (see BNX_DIR_ATTR_* in the file bnxnvm_defs.h). */
	uint16_t	dir_attr;
	/*
	 * Length of data to write, in bytes. May be less than or equal to the allocated size for the directory entry.
	 * The data length stored in the directory entry will be updated to reflect this value once the write is complete.
	 */
	uint32_t	dir_data_length;
	/* Option. */
	uint16_t	option;
	uint16_t	flags;
	/*
	 * When this bit is '1', the original active image
	 * will not be removed. TBD: what purpose is this?
	 */
	#define HWRM_NVM_WRITE_INPUT_FLAGS_KEEP_ORIG_ACTIVE_IMG \
		UINT32_C(0x1)
	/*
	 * The requested length of the allocated NVM for the item, in bytes. This value may be greater than or equal to the specified data length (dir_data_length).
	 * If this value is less than the specified data length, it will be ignored.
	 * The response will contain the actual allocated item length, which may be greater than the requested item length.
	 * The purpose for allocating more than the required number of bytes for an item's data is to pre-allocate extra storage (padding) to accomodate
	 * the potential future growth of an item (e.g. upgraded firmware with a size increase, log growth, expanded configuration data).
	 */
	uint32_t	dir_item_length;
	uint32_t	unused_0;
} __attribute__((packed));

/* hwrm_nvm_write_output (size:128b/16B) */
struct hwrm_nvm_write_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Length of the allocated NVM for the item, in bytes. The value may be greater than or equal to the specified data length or the requested item length.
	 * The actual item length used when creating a new directory entry will be a multiple of an NVM block size.
	 */
	uint32_t	dir_item_length;
	/* The directory index of the created or modified item. */
	uint16_t	dir_idx;
	uint8_t	unused_0;
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_nvm_write_cmd_err (size:64b/8B) */
struct hwrm_nvm_write_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_UNKNOWN  UINT32_C(0x0)
	/* Unable to complete operation due to fragmentation */
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_FRAG_ERR UINT32_C(0x1)
	/* nvm is completely full. */
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_NO_SPACE UINT32_C(0x2)
	#define HWRM_NVM_WRITE_CMD_ERR_CODE_LAST \
		HWRM_NVM_WRITE_CMD_ERR_CODE_NO_SPACE
	uint8_t	unused_0[7];
} __attribute__((packed));

/*******************
 * hwrm_nvm_modify *
 *******************/


/* hwrm_nvm_modify_input (size:320b/40B) */
struct hwrm_nvm_modify_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * 64-bit Host Source Address.
	 * This is where the modified data is.
	 */
	uint64_t	host_src_addr;
	/* 16-bit directory entry index. */
	uint16_t	dir_idx;
	uint8_t	unused_0[2];
	/* 32-bit NVRAM byte-offset to modify content from. */
	uint32_t	offset;
	/*
	 * Length of data to be modified, in bytes. The length shall
	 * be non-zero.
	 */
	uint32_t	len;
	uint8_t	unused_1[4];
} __attribute__((packed));

/* hwrm_nvm_modify_output (size:128b/16B) */
struct hwrm_nvm_modify_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_nvm_find_dir_entry *
 ***************************/


/* hwrm_nvm_find_dir_entry_input (size:256b/32B) */
struct hwrm_nvm_find_dir_entry_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the dir_idx_valid field to be
	 * configured.
	 */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_ENABLES_DIR_IDX_VALID \
		UINT32_C(0x1)
	/* Directory Entry Index */
	uint16_t	dir_idx;
	/* Directory Entry (Image) Type */
	uint16_t	dir_type;
	/*
	 * Directory ordinal.
	 * The instance of this Directory Type
	 */
	uint16_t	dir_ordinal;
	/* The Directory Entry Extension flags. */
	uint16_t	dir_ext;
	/* This value indicates the search option using dir_ordinal. */
	uint8_t	opt_ordinal;
	/* This value indicates the search option using dir_ordinal. */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_MASK UINT32_C(0x3)
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_SFT 0
	/* Equal to specified ordinal value. */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_EQ    UINT32_C(0x0)
	/* Greater than or equal to specified ordinal value */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_GE    UINT32_C(0x1)
	/* Greater than specified ordinal value */
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_GT    UINT32_C(0x2)
	#define HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_LAST \
		HWRM_NVM_FIND_DIR_ENTRY_INPUT_OPT_ORDINAL_GT
	uint8_t	unused_0[3];
} __attribute__((packed));

/* hwrm_nvm_find_dir_entry_output (size:256b/32B) */
struct hwrm_nvm_find_dir_entry_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Allocated NVRAM for this directory entry, in bytes. */
	uint32_t	dir_item_length;
	/* Size of the stored data for this directory entry, in bytes. */
	uint32_t	dir_data_length;
	/*
	 * Firmware version.
	 * Only valid if the directory entry is for embedded firmware stored in APE_BIN Format.
	 */
	uint32_t	fw_ver;
	/* Directory ordinal. */
	uint16_t	dir_ordinal;
	/* Directory Entry Index */
	uint16_t	dir_idx;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/****************************
 * hwrm_nvm_erase_dir_entry *
 ****************************/


/* hwrm_nvm_erase_dir_entry_input (size:192b/24B) */
struct hwrm_nvm_erase_dir_entry_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Directory Entry Index */
	uint16_t	dir_idx;
	uint8_t	unused_0[6];
} __attribute__((packed));

/* hwrm_nvm_erase_dir_entry_output (size:128b/16B) */
struct hwrm_nvm_erase_dir_entry_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/*************************
 * hwrm_nvm_get_dev_info *
 *************************/


/* hwrm_nvm_get_dev_info_input (size:128b/16B) */
struct hwrm_nvm_get_dev_info_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_nvm_get_dev_info_output (size:256b/32B) */
struct hwrm_nvm_get_dev_info_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* Manufacturer ID. */
	uint16_t	manufacturer_id;
	/* Device ID. */
	uint16_t	device_id;
	/* Sector size of the NVRAM device. */
	uint32_t	sector_size;
	/* Total size, in bytes of the NVRAM device. */
	uint32_t	nvram_size;
	uint32_t	reserved_size;
	/* Available size that can be used, in bytes.  Available size is the NVRAM size take away the used size and reserved size. */
	uint32_t	available_size;
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_nvm_mod_dir_entry *
 **************************/


/* hwrm_nvm_mod_dir_entry_input (size:256b/32B) */
struct hwrm_nvm_mod_dir_entry_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	uint32_t	enables;
	/*
	 * This bit must be '1' for the checksum field to be
	 * configured.
	 */
	#define HWRM_NVM_MOD_DIR_ENTRY_INPUT_ENABLES_CHECKSUM     UINT32_C(0x1)
	/* Directory Entry Index */
	uint16_t	dir_idx;
	/*
	 * Directory ordinal.
	 * The (0-based) instance of this Directory Type.
	 */
	uint16_t	dir_ordinal;
	/* The Directory Entry Extension flags (see BNX_DIR_EXT_* for extension flag definitions). */
	uint16_t	dir_ext;
	/* Directory Entry Attribute flags (see BNX_DIR_ATTR_* for attribute flag definitions). */
	uint16_t	dir_attr;
	/*
	 * If valid, then this field updates the checksum
	 * value of the content in the directory entry.
	 */
	uint32_t	checksum;
} __attribute__((packed));

/* hwrm_nvm_mod_dir_entry_output (size:128b/16B) */
struct hwrm_nvm_mod_dir_entry_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/**************************
 * hwrm_nvm_verify_update *
 **************************/


/* hwrm_nvm_verify_update_input (size:192b/24B) */
struct hwrm_nvm_verify_update_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* Directory Entry Type, to be verified. */
	uint16_t	dir_type;
	/*
	 * Directory ordinal.
	 * The instance of the Directory Type to be verified.
	 */
	uint16_t	dir_ordinal;
	/*
	 * The Directory Entry Extension flags.
	 * The "UPDATE" extension flag must be set in this value.
	 * A corresponding directory entry with the same type and ordinal values but *without*
	 * the "UPDATE" extension flag must also exist. The other flags of the extension must
	 * be identical between the active and update entries.
	 */
	uint16_t	dir_ext;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_nvm_verify_update_output (size:128b/16B) */
struct hwrm_nvm_verify_update_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/***************************
 * hwrm_nvm_install_update *
 ***************************/


/* hwrm_nvm_install_update_input (size:192b/24B) */
struct hwrm_nvm_install_update_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * Installation type. If the value 3 through 0xffff is used,
	 * only packaged items with that type value will be installed and
	 * conditional installation directives for those packaged items
	 * will be over-ridden (i.e. 'create' or 'replace' will be treated
	 * as 'install').
	 */
	uint32_t	install_type;
	/*
	 * Perform a normal package installation. Conditional installation
	 * directives (e.g. 'create' and 'replace') of packaged items
	 * will be followed.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_INSTALL_TYPE_NORMAL UINT32_C(0x0)
	/*
	 * Install all packaged items regardless of installation directive
	 * (i.e. treat all packaged items as though they have an installation
	 * directive of 'install').
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_INSTALL_TYPE_ALL \
		UINT32_C(0xffffffff)
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_INSTALL_TYPE_LAST \
		HWRM_NVM_INSTALL_UPDATE_INPUT_INSTALL_TYPE_ALL
	uint16_t	flags;
	/* If set to 1, then securely erase all unused locations in persistent storage. */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_FLAGS_ERASE_UNUSED_SPACE \
		UINT32_C(0x1)
	/*
	 * If set to 1, then unspecifed images, images not in the package file, will be safely deleted.
	 * When combined with erase_unused_space then unspecified images will be securely erased.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_FLAGS_REMOVE_UNUSED_PKG \
		UINT32_C(0x2)
	/*
	 * If set to 1, FW will defragment the NVM if defragmentation is required for the update.
	 * Allow additional time for this command to complete if this bit is set to 1.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_INPUT_FLAGS_ALLOWED_TO_DEFRAG \
		UINT32_C(0x4)
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_nvm_install_update_output (size:192b/24B) */
struct hwrm_nvm_install_update_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/*
	 * Bit-mask of successfully installed items.
	 * Bit-0 corresponding to the first packaged item, Bit-1 for the second item, etc.
	 * A value of 0 indicates that no items were successfully installed.
	 */
	uint64_t	installed_items;
	/* result is 8 b */
	uint8_t	result;
	/* There was no problem with the package installation. */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESULT_SUCCESS UINT32_C(0x0)
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESULT_LAST \
		HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESULT_SUCCESS
	/* problem_item is 8 b */
	uint8_t	problem_item;
	/* There was no problem with any packaged items. */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_PROBLEM_ITEM_NONE \
		UINT32_C(0x0)
	/* There was a problem with the NVM package itself. */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_PROBLEM_ITEM_PACKAGE \
		UINT32_C(0xff)
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_PROBLEM_ITEM_LAST \
		HWRM_NVM_INSTALL_UPDATE_OUTPUT_PROBLEM_ITEM_PACKAGE
	/* reset_required is 8 b */
	uint8_t	reset_required;
	/*
	 * No reset is required for installed/updated firmware or
	 * microcode to take effect.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_NONE \
		UINT32_C(0x0)
	/*
	 * A PCIe reset (e.g. system reboot) is
	 * required for newly installed/updated firmware or
	 * microcode to take effect.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_PCI \
		UINT32_C(0x1)
	/*
	 * A controller power reset (e.g. system power-cycle) is
	 * required for newly installed/updated firmware or
	 * microcode to take effect. Some newly installed/updated
	 * firmware or microcode may still take effect upon the
	 * next PCIe reset.
	 */
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_POWER \
		UINT32_C(0x2)
	#define HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_LAST \
		HWRM_NVM_INSTALL_UPDATE_OUTPUT_RESET_REQUIRED_POWER
	uint8_t	unused_0[4];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_nvm_install_update_cmd_err (size:64b/8B) */
struct hwrm_nvm_install_update_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_UNKNOWN  UINT32_C(0x0)
	/* Unable to complete operation due to fragmentation */
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_FRAG_ERR UINT32_C(0x1)
	/* nvm is completely full. */
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_NO_SPACE UINT32_C(0x2)
	#define HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_LAST \
		HWRM_NVM_INSTALL_UPDATE_CMD_ERR_CODE_NO_SPACE
	uint8_t	unused_0[7];
} __attribute__((packed));

/******************
 * hwrm_nvm_flush *
 ******************/


/* hwrm_nvm_flush_input (size:128b/16B) */
struct hwrm_nvm_flush_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
} __attribute__((packed));

/* hwrm_nvm_flush_output (size:128b/16B) */
struct hwrm_nvm_flush_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_nvm_flush_cmd_err (size:64b/8B) */
struct hwrm_nvm_flush_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_NVM_FLUSH_CMD_ERR_CODE_UNKNOWN UINT32_C(0x0)
	/* flush could not be performed */
	#define HWRM_NVM_FLUSH_CMD_ERR_CODE_FAIL    UINT32_C(0x1)
	#define HWRM_NVM_FLUSH_CMD_ERR_CODE_LAST \
		HWRM_NVM_FLUSH_CMD_ERR_CODE_FAIL
	uint8_t	unused_0[7];
} __attribute__((packed));

/*************************
 * hwrm_nvm_get_variable *
 *************************/


/* hwrm_nvm_get_variable_input (size:320b/40B) */
struct hwrm_nvm_get_variable_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is the host address where
	 * nvm variable will be stored
	 */
	uint64_t	dest_data_addr;
	/* size of data in bits */
	uint16_t	data_len;
	/* nvm cfg option number */
	uint16_t	option_num;
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_INPUT_OPTION_NUM_RSVD_0    UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_INPUT_OPTION_NUM_RSVD_FFFF \
		UINT32_C(0xffff)
	#define HWRM_NVM_GET_VARIABLE_INPUT_OPTION_NUM_LAST \
		HWRM_NVM_GET_VARIABLE_INPUT_OPTION_NUM_RSVD_FFFF
	/*
	 * Number of dimensions for this nvm configuration variable.
	 * This value indicates how many of the indexN values to use.
	 * A value of 0 means that none of the indexN values are valid.
	 * A value of 1 requires at index0 is valued, a value of 2
	 * requires that index0 and index1 are valid, and so forth
	 */
	uint16_t	dimensions;
	/* index for the 1st dimensions */
	uint16_t	index_0;
	/* index for the 2nd dimensions */
	uint16_t	index_1;
	/* index for the 3rd dimensions */
	uint16_t	index_2;
	/* index for the 4th dimensions */
	uint16_t	index_3;
	uint8_t	flags;
	/*
	 * When this bit is set to 1, the factory default value will be returned,
	 * 0 returns the operational value.
	 */
	#define HWRM_NVM_GET_VARIABLE_INPUT_FLAGS_FACTORY_DFLT \
		UINT32_C(0x1)
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_nvm_get_variable_output (size:128b/16B) */
struct hwrm_nvm_get_variable_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	/* size of data of the actual variable retrieved in bits */
	uint16_t	data_len;
	/*
	 * option_num is the option number for the data retrieved.  It is possible in the
	 * future that the option number returned would be different than requested.  This
	 * condition could occur if an option is deprecated and a new option id is defined
	 * with similar characteristics, but has a slightly different definition.  This
	 * also makes it convenient for the caller to identify the variable result with
	 * the option id from the response.
	 */
	uint16_t	option_num;
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_OUTPUT_OPTION_NUM_RSVD_0    UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_GET_VARIABLE_OUTPUT_OPTION_NUM_RSVD_FFFF \
		UINT32_C(0xffff)
	#define HWRM_NVM_GET_VARIABLE_OUTPUT_OPTION_NUM_LAST \
		HWRM_NVM_GET_VARIABLE_OUTPUT_OPTION_NUM_RSVD_FFFF
	uint8_t	unused_0[3];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_nvm_get_variable_cmd_err (size:64b/8B) */
struct hwrm_nvm_get_variable_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_UNKNOWN       UINT32_C(0x0)
	/* variable does not exist */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_VAR_NOT_EXIST UINT32_C(0x1)
	/* configuration is corrupted and the variable cannot be saved */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_CORRUPT_VAR   UINT32_C(0x2)
	/* length specified is too small */
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_LEN_TOO_SHORT UINT32_C(0x3)
	#define HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_LAST \
		HWRM_NVM_GET_VARIABLE_CMD_ERR_CODE_LEN_TOO_SHORT
	uint8_t	unused_0[7];
} __attribute__((packed));

/*************************
 * hwrm_nvm_set_variable *
 *************************/


/* hwrm_nvm_set_variable_input (size:320b/40B) */
struct hwrm_nvm_set_variable_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is the host address where
	 * nvm variable will be copied from
	 */
	uint64_t	src_data_addr;
	/* size of data in bits */
	uint16_t	data_len;
	/* nvm cfg option number */
	uint16_t	option_num;
	/* reserved. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_OPTION_NUM_RSVD_0    UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_OPTION_NUM_RSVD_FFFF \
		UINT32_C(0xffff)
	#define HWRM_NVM_SET_VARIABLE_INPUT_OPTION_NUM_LAST \
		HWRM_NVM_SET_VARIABLE_INPUT_OPTION_NUM_RSVD_FFFF
	/*
	 * Number of dimensions for this nvm configuration variable.
	 * This value indicates how many of the indexN values to use.
	 * A value of 0 means that none of the indexN values are valid.
	 * A value of 1 requires at index0 is valued, a value of 2
	 * requires that index0 and index1 are valid, and so forth
	 */
	uint16_t	dimensions;
	/* index for the 1st dimensions */
	uint16_t	index_0;
	/* index for the 2nd dimensions */
	uint16_t	index_1;
	/* index for the 3rd dimensions */
	uint16_t	index_2;
	/* index for the 4th dimensions */
	uint16_t	index_3;
	uint8_t	flags;
	/* When this bit is 1, flush internal cache after this write operation (see hwrm_nvm_flush command.) */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_FORCE_FLUSH \
		UINT32_C(0x1)
	/* encryption method */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_MASK \
		UINT32_C(0xe)
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_SFT           1
	/* No encryption. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_NONE \
		(UINT32_C(0x0) << 1)
	/* one-way encryption. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_HMAC_SHA1 \
		(UINT32_C(0x1) << 1)
	/* symmetric AES256 encryption. */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_AES256 \
		(UINT32_C(0x2) << 1)
	/* SHA1 digest appended to plaintext contents, for authentication */
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_HMAC_SHA1_AUTH \
		(UINT32_C(0x3) << 1)
	#define HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_LAST \
		HWRM_NVM_SET_VARIABLE_INPUT_FLAGS_ENCRYPT_MODE_HMAC_SHA1_AUTH
	uint8_t	unused_0;
} __attribute__((packed));

/* hwrm_nvm_set_variable_output (size:128b/16B) */
struct hwrm_nvm_set_variable_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	unused_0[7];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_nvm_set_variable_cmd_err (size:64b/8B) */
struct hwrm_nvm_set_variable_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_UNKNOWN       UINT32_C(0x0)
	/* variable does not exist */
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_VAR_NOT_EXIST UINT32_C(0x1)
	/* configuration is corrupted and the variable cannot be saved */
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_CORRUPT_VAR   UINT32_C(0x2)
	#define HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_LAST \
		HWRM_NVM_SET_VARIABLE_CMD_ERR_CODE_CORRUPT_VAR
	uint8_t	unused_0[7];
} __attribute__((packed));

/****************************
 * hwrm_nvm_validate_option *
 ****************************/


/* hwrm_nvm_validate_option_input (size:320b/40B) */
struct hwrm_nvm_validate_option_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/*
	 * This is the host address where
	 * nvm variable will be copied from
	 */
	uint64_t	src_data_addr;
	/* size of data in bits */
	uint16_t	data_len;
	/* nvm cfg option number */
	uint16_t	option_num;
	/* reserved. */
	#define HWRM_NVM_VALIDATE_OPTION_INPUT_OPTION_NUM_RSVD_0 \
		UINT32_C(0x0)
	/* reserved. */
	#define HWRM_NVM_VALIDATE_OPTION_INPUT_OPTION_NUM_RSVD_FFFF \
		UINT32_C(0xffff)
	#define HWRM_NVM_VALIDATE_OPTION_INPUT_OPTION_NUM_LAST \
		HWRM_NVM_VALIDATE_OPTION_INPUT_OPTION_NUM_RSVD_FFFF
	/*
	 * Number of dimensions for this nvm configuration variable.
	 * This value indicates how many of the indexN values to use.
	 * A value of 0 means that none of the indexN values are valid.
	 * A value of 1 requires at index0 is valued, a value of 2
	 * requires that index0 and index1 are valid, and so forth
	 */
	uint16_t	dimensions;
	/* index for the 1st dimensions */
	uint16_t	index_0;
	/* index for the 2nd dimensions */
	uint16_t	index_1;
	/* index for the 3rd dimensions */
	uint16_t	index_2;
	/* index for the 4th dimensions */
	uint16_t	index_3;
	uint8_t	unused_0[2];
} __attribute__((packed));

/* hwrm_nvm_validate_option_output (size:128b/16B) */
struct hwrm_nvm_validate_option_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	result;
	/* indicates that the value provided for the option is not matching with the saved data. */
	#define HWRM_NVM_VALIDATE_OPTION_OUTPUT_RESULT_NOT_MATCH UINT32_C(0x0)
	/* indicates that the value provided for the option is matching the saved data. */
	#define HWRM_NVM_VALIDATE_OPTION_OUTPUT_RESULT_MATCH     UINT32_C(0x1)
	#define HWRM_NVM_VALIDATE_OPTION_OUTPUT_RESULT_LAST \
		HWRM_NVM_VALIDATE_OPTION_OUTPUT_RESULT_MATCH
	uint8_t	unused_0[6];
	/*
	 * This field is used in Output records to indicate that the output
	 * is completely written to RAM.  This field should be read as '1'
	 * to indicate that the output has been completely written.
	 * When writing a command completion or response to an internal processor,
	 * the order of writes has to be such that this field is written last.
	 */
	uint8_t	valid;
} __attribute__((packed));

/* hwrm_nvm_validate_option_cmd_err (size:64b/8B) */
struct hwrm_nvm_validate_option_cmd_err {
	/*
	 * command specific error codes that goes to
	 * the cmd_err field in Common HWRM Error Response.
	 */
	uint8_t	code;
	/* Unknown error */
	#define HWRM_NVM_VALIDATE_OPTION_CMD_ERR_CODE_UNKNOWN UINT32_C(0x0)
	#define HWRM_NVM_VALIDATE_OPTION_CMD_ERR_CODE_LAST \
		HWRM_NVM_VALIDATE_OPTION_CMD_ERR_CODE_UNKNOWN
	uint8_t	unused_0[7];
} __attribute__((packed));

/*****************************
 * hwrm_nvm_factory_defaults *
 *****************************/


/* hwrm_nvm_factory_defaults_input (size:192b/24B) */
struct hwrm_nvm_factory_defaults_input {
	/* The HWRM command request type. */
	uint16_t	req_type;
	/*
	 * The completion ring to send the completion event on. This should
	 * be the NQ ID returned from the `nq_alloc` HWRM command.
	 */
	uint16_t	cmpl_ring;
	/*
	 * The sequence ID is used by the driver for tracking multiple
	 * commands. This ID is treated as opaque data by the firmware and
	 * the value is returned in the `hwrm_resp_hdr` upon completion.
	 */
	uint16_t	seq_id;
	/*
	 * The target ID of the command:
	 * * 0x0-0xFFF8 - The function ID
	 * * 0xFFF8-0xFFFE - Reserved for internal processors
	 * * 0xFFFF - HWRM
	 */
	uint16_t	target_id;
	/*
	 * A physical address pointer pointing to a host buffer that the
	 * command's response data will be written. This can be either a host
	 * physical address (HPA) or a guest physical address (GPA) and must
	 * point to a physically contiguous block of memory.
	 */
	uint64_t	resp_addr;
	/* mode is 8 b */
	uint8_t	mode;
	/* If set to 1, it will trigger restoration of factory default settings */
	#define HWRM_NVM_FACTORY_DEFAULTS_INPUT_MODE_RESTORE UINT32_C(0x0)
	/* If set to 1, it will trigger creation of factory default settings */
	#define HWRM_NVM_FACTORY_DEFAULTS_INPUT_MODE_CREATE  UINT32_C(0x1)
	#define HWRM_NVM_FACTORY_DEFAULTS_INPUT_MODE_LAST \
		HWRM_NVM_FACTORY_DEFAULTS_INPUT_MODE_CREATE
	uint8_t	unused_0[7];
} __attribute__((packed));

/* hwrm_nvm_factory_defaults_output (size:128b/16B) */
struct hwrm_nvm_factory_defaults_output {
	/* The specific error status for the command. */
	uint16_t	error_code;
	/* The HWRM command request type. */
	uint16_t	req_type;
	/* The sequence ID from the original command. */
	uint16_t	seq_id;
	/* The length of the response data in number of bytes. */
	uint16_t	resp_len;
	uint8_t	result;
	/* factory defaults created successfully. */