#!/bin/sh

check_for_pkg_config() {
    which pkg-config >/dev/null && return

    echo
    echo "Error: could not find pkg-config"
    echo
    echo "Please make sure you have pkg-config installed."
    echo
    exit 1
}

rm -f config.cache
aclocal #-I m4
check_for_pkg_config
libtoolize --force --copy
autoconf
autoheader
automake -a --add-missing -Wall
( cd src/gtest && autoreconf -fvi; )
( cd src/leveldb && mkdir -p m4 && autoreconf -fvi; )
exit
