package agent

import (
	"gitlab.com/gitlab-org/security-products/analyzers/trivy-k8s-wrapper/data/analyzers/report"
)

var TrivyScanner = report.ScannerDetails{
	ID:   "starboard_trivy",
	Name: "Trivy (via Starboard Operator)",
	Vendor: report.Vendor{
		Name: "GitLab",
	},
}

func getTrivyScannerPayload(version string) report.ScannerDetails {
	d := TrivyScanner
	d.Version = version
	return d
}

// Payload resembles the create-starboard-vulnerability payload of the
// KAS API
// https://docs.gitlab.com/ee/development/internal_api/#create-starboard-vulnerability
type Payload struct {
	Vulnerability *report.Vulnerability `json:"vulnerability"`
	Scanner       report.ScannerDetails `json:"scanner"`
}
