/* ----- nPbatch/montgomery25519, derived from supercop/crypto_nPbatch/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *nPbatch_montgomery25519_checksums[] = {
  "70ad918d115325afd930af794ffaa7941a917fcda4f80a02079566e6164fa970",
  "a0b24a12c2f75852961141d12324d5ee943e8200fcba97c56ce239362e4cdda3",
} ;

static void (*crypto_nPbatch)(unsigned char *,const unsigned char *,const unsigned char *,long long);
#define crypto_nPbatch_SCALARBYTES lib25519_nPbatch_montgomery25519_SCALARBYTES
#define crypto_nPbatch_POINTBYTES lib25519_nPbatch_montgomery25519_POINTBYTES

static void *storage_nPbatch_montgomery25519_q;
static unsigned char *test_nPbatch_montgomery25519_q;
static void *storage_nPbatch_montgomery25519_n;
static unsigned char *test_nPbatch_montgomery25519_n;
static void *storage_nPbatch_montgomery25519_p;
static unsigned char *test_nPbatch_montgomery25519_p;
static void *storage_nPbatch_montgomery25519_q2;
static unsigned char *test_nPbatch_montgomery25519_q2;
static void *storage_nPbatch_montgomery25519_n2;
static unsigned char *test_nPbatch_montgomery25519_n2;
static void *storage_nPbatch_montgomery25519_p2;
static unsigned char *test_nPbatch_montgomery25519_p2;

#define precomputed_nPbatch_montgomery25519_NUM 17

static const unsigned char precomputed_nPbatch_montgomery25519_q_0[] = {};
static const unsigned char precomputed_nPbatch_montgomery25519_n_0[] = {};
static const unsigned char precomputed_nPbatch_montgomery25519_p_0[] = {};
static const unsigned char precomputed_nPbatch_montgomery25519_q_1[] = {132,211,21,191,66,248,248,89,73,111,43,217,220,90,21,178,4,219,49,48,22,113,99,190,107,95,35,114,217,59,197,42};
static const unsigned char precomputed_nPbatch_montgomery25519_n_1[] = {233,7,88,169,245,138,136,155,68,93,31,123,215,120,20,114,152,0,25,64,65,69,245,208,239,35,197,64,79,172,241,2};
static const unsigned char precomputed_nPbatch_montgomery25519_p_1[] = {199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122};
static const unsigned char precomputed_nPbatch_montgomery25519_q_2[] = {217,115,32,35,66,144,65,8,25,143,191,82,225,61,129,97,90,4,150,71,57,17,1,231,14,199,229,207,221,174,89,13,33,8,41,21,196,57,27,11,142,108,106,99,167,6,192,237,255,230,224,36,117,7,242,70,226,111,243,213,61,23,15,53};
static const unsigned char precomputed_nPbatch_montgomery25519_n_2[] = {2,222,22,131,160,78,116,188,224,216,251,122,243,253,84,123,180,252,82,233,141,218,42,150,213,250,32,17,174,233,198,144,77,142,218,116,40,190,158,142,14,25,103,22,220,112,238,115,106,208,60,113,132,11,139,211,134,73,184,101,247,197,94,92};
static const unsigned char precomputed_nPbatch_montgomery25519_p_2[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,46,183,255,198,153,158,240,122,231,14,3,68,224,88,41,255,150,5,100,114,25,47,223,131,156,7,132,91,115,13,36};
static const unsigned char precomputed_nPbatch_montgomery25519_q_3[] = {69,121,86,227,222,239,11,208,33,176,252,85,217,169,174,186,246,248,170,213,13,176,85,81,25,23,34,81,251,61,27,15,31,224,135,97,215,173,1,8,159,103,168,115,190,1,26,137,189,20,155,104,150,122,79,28,21,220,74,33,159,177,72,76,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99};
static const unsigned char precomputed_nPbatch_montgomery25519_n_3[] = {232,59,52,197,225,94,168,91,231,73,162,9,196,84,83,9,115,91,228,28,110,247,129,120,199,247,248,114,2,161,167,146,250,114,79,178,120,16,130,147,4,253,171,208,74,42,200,186,236,25,149,137,139,159,200,123,139,203,55,136,171,168,21,138,236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nPbatch_montgomery25519_p_3[] = {216,133,220,191,70,32,82,157,83,231,220,192,43,155,5,1,175,92,52,144,185,209,117,107,251,155,54,254,111,193,98,99,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_4[] = {162,93,163,159,20,188,94,13,51,72,116,75,189,214,110,123,124,9,238,31,79,7,237,111,225,81,4,77,40,149,130,82,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,49,255,250,144,86,100,223,59,248,213,193,15,175,5,233,5,93,3,178,104,161,187,55,226,138,69,127,23,37,210,251,30,136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91};
static const unsigned char precomputed_nPbatch_montgomery25519_n_4[] = {249,136,238,59,164,86,241,133,205,15,12,226,199,113,49,1,247,239,150,87,31,12,54,21,210,187,99,46,64,166,182,166,199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,53,245,55,25,59,19,52,104,12,190,154,155,254,60,211,10,173,59,255,119,78,185,214,240,80,140,246,173,40,214,178,31,142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nPbatch_montgomery25519_p_4[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,9,183,167,211,71,178,197,159,211,252,106,164,133,217,230,19,245,215,29,92,240,192,129,163,60,151,149,102,219,251,61,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_5[] = {228,112,130,63,107,81,23,249,186,10,22,86,99,174,198,10,157,41,6,67,30,228,13,31,83,154,42,32,230,159,64,116,237,233,209,128,35,74,98,191,219,14,142,247,21,184,48,218,12,66,235,142,38,201,74,115,203,99,197,195,181,145,64,18,215,194,226,30,5,48,102,158,105,8,172,181,127,251,175,126,0,25,101,220,84,10,197,19,105,58,237,49,123,52,190,117,141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48,167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106};
static const unsigned char precomputed_nPbatch_montgomery25519_n_5[] = {29,139,208,144,158,44,163,1,154,204,136,129,249,124,170,119,165,192,236,183,170,69,227,92,93,168,183,102,236,70,132,35,128,176,62,75,113,107,246,234,120,66,247,56,41,217,30,167,80,190,150,146,17,193,11,247,74,235,142,53,223,132,110,26,31,239,111,66,250,165,152,62,61,1,47,9,134,219,166,127,174,8,170,206,103,158,99,99,235,95,103,58,250,213,120,252,40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139,37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42};
static const unsigned char precomputed_nPbatch_montgomery25519_p_5[] = {56,103,119,158,120,22,48,230,208,156,54,119,226,189,178,33,160,83,156,57,66,229,19,16,110,194,27,195,36,104,230,50,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66};
static const unsigned char precomputed_nPbatch_montgomery25519_q_6[] = {8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,235,14,110,53,191,65,207,130,47,77,134,173,120,240,222,139,29,180,151,72,162,218,70,217,73,77,253,120,147,236,10,61,184,152,148,235,8,16,51,133,188,254,11,79,161,191,124,78,106,124,211,231,108,219,92,138,18,188,205,203,223,38,138,118,167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106};
static const unsigned char precomputed_nPbatch_montgomery25519_n_6[] = {42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52,236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,242,118,199,205,119,164,108,93,255,103,82,80,71,24,76,10,37,191,147,128,26,14,16,1,201,170,187,82,112,15,231,179,10,131,96,200,92,222,33,20,40,227,105,197,27,52,94,103,254,50,55,208,121,2,232,214,99,15,32,20,15,43,222,109,37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42};
static const unsigned char precomputed_nPbatch_montgomery25519_p_6[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66};
static const unsigned char precomputed_nPbatch_montgomery25519_q_7[] = {116,70,20,190,1,228,58,162,97,230,38,210,46,203,75,121,38,47,150,168,111,194,217,74,139,93,163,63,251,59,118,43,230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48,143,113,135,245,250,124,30,154,148,22,222,2,117,102,37,93,250,232,201,25,74,171,107,245,58,131,36,66,114,107,208,2,99,251,119,112,231,187,226,19,201,44,152,12,75,37,149,216,238,92,77,90,182,244,215,236,152,248,64,29,159,78,248,62,64,91,102,139,101,206,222,171,228,8,235,102,170,68,4,28,147,133,171,48,83,187,216,119,107,20,43,2,254,116,218,94,197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113,230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48};
static const unsigned char precomputed_nPbatch_montgomery25519_n_7[] = {24,143,235,33,67,131,180,27,71,202,101,41,90,157,230,92,56,143,162,41,110,98,199,236,58,206,79,101,250,17,98,84,21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187,182,169,173,124,154,41,121,130,249,60,17,47,224,46,34,4,109,78,19,61,55,95,38,31,3,241,167,172,114,247,68,94,231,146,78,235,9,155,237,211,193,96,61,198,102,79,190,77,54,114,95,224,213,45,193,36,145,253,126,52,11,186,208,182,117,246,27,36,54,185,197,126,128,70,19,206,190,244,213,241,2,214,6,42,73,184,224,42,134,19,67,210,95,131,206,65,61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237,21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187};
static const unsigned char precomputed_nPbatch_montgomery25519_p_7[] = {216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148};
static const unsigned char precomputed_nPbatch_montgomery25519_q_8[] = {5,168,106,188,73,12,34,187,203,246,72,18,25,207,249,218,205,93,206,60,174,15,128,30,117,208,119,125,204,0,69,104,45,234,189,106,93,41,197,201,25,229,188,27,200,109,20,28,157,91,139,137,162,0,243,82,191,136,58,230,14,123,21,126,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,247,47,178,248,52,54,192,213,119,42,9,99,242,192,111,160,106,220,145,217,226,58,89,18,9,81,100,252,221,221,46,36,55,236,229,245,79,207,49,203,20,232,169,77,191,14,108,115,63,173,247,108,115,162,142,117,229,217,72,26,175,68,106,66,245,111,3,98,139,24,189,155,145,236,234,46,217,98,153,28,247,110,223,14,222,218,185,48,86,154,56,134,240,21,93,24,51,215,230,138,23,30,88,143,60,86,238,203,211,116,63,245,76,50,7,178,47,174,153,162,153,90,26,244,64,247,126};
static const unsigned char precomputed_nPbatch_montgomery25519_n_8[] = {116,185,13,114,141,41,129,67,255,178,218,214,149,9,141,97,144,215,186,32,22,135,194,93,20,52,11,141,223,165,75,67,196,142,88,86,120,128,248,216,203,143,30,145,212,88,8,226,44,209,237,51,95,0,37,209,222,37,184,14,51,238,143,113,218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,173,229,74,44,190,251,221,217,123,144,158,53,116,65,212,153,140,78,191,166,177,29,200,208,116,177,250,141,151,172,255,18,238,205,118,104,224,32,1,124,103,246,230,131,211,47,8,131,118,55,85,122,152,0,26,90,147,81,190,53,208,236,202,243,23,50,2,94,118,21,204,94,239,46,9,3,10,238,121,200,247,28,126,236,204,216,61,30,175,166,142,170,88,128,44,182,176,167,216,65,10,75,148,78,76,151,92,161,168,237,252,14,170,191,18,24,113,151,192,59,92,204,29,110,25,193,162,76,139,212,131,124,25,171,27,175,3,6,47,161,15,105,79,142,37,119,173,48,58,0,91,57,41,8,131,142,248,37,47,75};
static const unsigned char precomputed_nPbatch_montgomery25519_p_8[] = {210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,166,71,52,250,165,142,124,133,244,167,47,167,159,231,196,183,228,176,163,220,102,133,113,231,10,178,182,106,107,111,142,89,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,183,227,89,201,132,189,69,4,190,233,93,209,47,210,121,112,180,254,123,62,210,123,36,178,222,2,150,99,8,35,66,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128};
static const unsigned char precomputed_nPbatch_montgomery25519_q_9[] = {84,52,11,125,245,132,150,18,72,100,216,10,97,116,194,219,120,17,230,231,77,86,11,115,18,17,117,83,207,244,176,124,121,232,151,106,249,132,75,30,73,205,71,105,61,158,181,131,150,161,64,69,138,140,30,8,40,61,72,109,102,207,107,46,228,228,179,142,119,218,163,179,18,100,15,16,219,88,146,63,140,252,124,190,66,108,232,165,55,163,242,240,143,207,151,79,170,208,209,190,88,225,4,146,80,242,232,41,199,19,207,109,186,249,155,73,43,228,161,96,105,32,252,159,150,203,35,3,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,218,19,60,95,164,29,193,143,31,60,118,76,181,15,34,25,36,25,107,130,112,1,254,30,88,119,91,143,204,104,68,115,85,216,96,126,239,24,171,238,158,88,201,26,202,187,130,154,241,114,114,95,95,29,6,98,33,120,172,125,108,180,197,114,118,218,149,241,214,33,125,242,130,22,147,72,83,220,163,24,130,172,18,66,72,206,244,12,146,34,20,156,123,174,125,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_n_9[] = {138,118,50,4,97,30,223,67,133,227,178,230,148,132,25,72,174,35,177,140,212,86,244,251,114,81,166,39,66,105,57,204,176,21,36,69,234,239,12,133,189,95,127,247,243,129,176,233,252,210,8,4,62,179,45,71,132,151,131,142,107,226,149,82,253,78,2,197,246,2,80,67,175,244,59,34,195,228,158,234,134,91,114,225,55,146,120,105,181,188,229,205,129,46,176,76,178,94,69,233,220,50,222,130,166,39,181,69,40,191,116,203,151,218,24,220,132,222,107,236,239,184,160,139,114,252,191,162,198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,102,244,58,119,155,31,176,155,201,67,186,91,94,48,167,170,255,129,116,151,167,203,173,120,226,156,230,70,180,187,160,129,190,147,100,101,77,151,179,249,20,102,182,218,161,187,38,207,142,126,195,32,205,249,96,90,162,80,63,226,98,120,239,127,65,99,53,92,228,166,24,237,239,207,164,149,189,109,242,0,113,5,174,121,235,137,62,7,24,44,128,29,111,223,2,8,29,96,25,19,112,147,141,120,188,41,78,222,44,150,121,75,69,175,171,106,40,52,87,126,121,16,126,87,23,36,150,140};
static const unsigned char precomputed_nPbatch_montgomery25519_p_9[] = {224,127,120,206,90,168,171,155,214,37,59,146,114,174,149,43,10,200,87,58,190,106,83,37,22,129,102,187,150,99,56,112,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,231,77,226,40,229,224,72,3,74,203,150,143,218,164,211,149,236,191,232,231,122,157,146,89,72,59,89,49,46,161,128,143,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nPbatch_montgomery25519_q_10[] = {227,182,214,47,131,182,21,112,64,150,229,231,76,159,115,101,254,178,24,4,238,128,253,76,19,54,242,153,40,8,96,107,155,56,106,143,220,91,199,35,51,40,34,60,68,132,234,215,235,216,224,102,48,147,31,123,65,192,218,123,192,69,204,88,56,21,5,209,153,28,67,172,37,109,174,13,123,39,248,41,6,32,97,215,136,83,40,105,144,155,46,38,66,191,92,111,161,223,243,227,234,158,42,211,46,211,205,39,166,23,202,203,26,65,220,32,37,204,145,199,242,178,16,111,221,227,215,116,218,151,19,123,28,234,235,200,163,179,10,170,252,43,86,73,85,71,114,100,167,146,135,33,146,246,108,40,7,137,39,115,255,82,248,88,61,49,168,220,29,130,1,110,152,243,156,136,217,219,236,92,185,217,90,81,253,170,11,27,2,238,82,54,43,186,50,61,113,54,20,246,129,62,252,230,142,137,188,131,52,135,179,98,232,100,109,104,47,120,116,195,104,53,219,76,73,60,108,146,86,171,58,233,185,238,63,146,73,30,24,34,168,99,126,227,84,5,105,118,225,99,196,231,236,222,30,78,135,110,236,86,44,66,16,135,102,160,234,251,75,169,40,162,23,252,170,56,119,186,208,82,4,133,157,1,170,36,83,77,79,44,236,112,159,54,150,95,117,110,182,61,177,18,158,99,107,124,142,159,114,211,46,83,130,42,252,119,143,232,229,84};
static const unsigned char precomputed_nPbatch_montgomery25519_n_10[] = {212,34,94,235,200,193,0,184,101,187,23,99,253,170,8,165,176,93,221,119,178,52,105,186,227,109,125,247,157,129,161,28,216,66,150,88,66,14,93,184,117,133,100,210,116,16,39,29,158,140,14,79,195,252,81,101,222,179,28,201,66,97,137,95,216,225,212,157,91,85,59,235,154,67,45,114,168,180,42,127,197,112,107,19,206,209,121,58,84,128,9,85,201,218,145,12,128,211,202,5,133,44,165,24,11,106,41,213,148,126,225,3,196,79,227,38,11,161,243,167,11,73,135,245,143,32,105,241,7,253,193,58,175,41,205,115,33,166,243,153,184,10,43,46,177,68,128,214,230,75,53,63,110,205,14,138,28,4,170,122,114,237,141,232,195,47,33,59,235,143,14,231,243,190,94,78,53,71,137,45,84,252,75,0,62,232,175,124,142,112,220,222,140,20,116,65,40,144,224,107,218,207,103,120,233,230,200,36,235,153,213,2,165,191,132,50,23,197,154,210,54,80,227,225,122,58,111,170,110,97,174,165,185,228,229,99,23,86,80,121,81,137,76,171,44,133,24,21,47,189,44,142,110,203,172,228,193,95,146,115,121,195,161,67,226,160,12,126,178,128,86,146,245,113,187,78,36,100,116,199,49,41,122,79,39,152,203,40,167,187,243,125,206,236,2,177,69,39,27,152,40,227,228,231,28,216,46,12,238,71,36,195,154,40,15,179,66,180,77,245};
static const unsigned char precomputed_nPbatch_montgomery25519_p_10[] = {108,20,31,116,94,141,126,45,163,85,126,44,19,190,238,243,224,86,12,212,102,52,127,109,241,32,139,167,37,52,87,39,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,207,108,156,64,182,29,155,51,168,111,164,225,193,194,145,89,21,77,220,193,35,3,222,175,89,78,123,87,130,50,248,22,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,16,248,176,17,243,88,13,137,6,58,182,139,221,105,188,108,139,108,94,186,224,118,160,35,97,77,197,56,233,17,190,206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,142,22,38,205,200,222,195,37,214,165,19,37,81,22,87,95,227,152,243,211,179,168,34,169,78,193,55,91,16,56,230,222,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nPbatch_montgomery25519_q_11[] = {8,100,222,18,220,20,218,99,254,188,214,171,119,88,234,228,50,86,45,103,188,156,0,91,129,17,52,149,192,244,246,108,139,147,141,94,93,143,239,121,211,81,7,154,161,209,7,107,178,61,20,223,137,117,220,32,14,123,164,122,20,46,70,31,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99,146,43,123,255,31,155,213,85,188,25,221,200,248,13,245,68,170,167,163,189,220,88,41,78,249,84,138,234,158,186,176,75,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,167,69,92,82,21,33,118,83,239,21,209,140,157,76,171,158,207,12,119,240,246,209,154,135,0,78,7,81,200,101,186,99,8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24,40,200,204,209,91,183,68,11,249,72,60,139,63,177,138,71,245,134,205,27,114,128,202,70,153,135,44,233,35,233,100,28,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,118,218,149,241,214,33,125,242,130,22,147,72,83,220,163,24,130,172,18,66,72,206,244,12,146,34,20,156,123,174,125,122,119,243,169,67,101,142,55,101,19,229,2,251,162,150,18,160,112,134,178,193,7,225,98,208,156,230,253,183,65,134,234,30};
static const unsigned char precomputed_nPbatch_montgomery25519_n_11[] = {145,52,243,43,154,181,28,84,69,217,127,105,124,26,144,86,194,239,44,38,126,15,220,245,35,24,159,43,124,97,207,182,217,184,164,88,62,54,210,17,153,249,234,177,206,234,187,1,173,27,4,169,47,206,63,97,199,12,146,88,111,217,78,65,235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,147,175,202,105,252,90,225,232,240,127,173,129,198,217,39,91,13,202,235,161,2,63,4,105,31,248,88,122,189,14,202,217,124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,251,163,38,67,159,49,110,10,31,29,115,131,183,15,141,31,33,127,239,142,94,23,75,0,189,146,169,229,4,13,46,20,42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52,211,246,247,134,90,237,209,205,238,198,243,113,12,34,103,183,150,113,189,173,254,100,88,246,192,98,123,82,70,180,97,180,125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,65,99,53,92,228,166,24,237,239,207,164,149,189,109,242,0,113,5,174,121,235,137,62,7,24,44,128,29,111,223,2,8,139,232,90,130,109,54,160,143,19,93,33,62,239,86,106,141,212,170,67,203,91,227,33,162,207,68,209,31,55,222,213,61};
static const unsigned char precomputed_nPbatch_montgomery25519_p_11[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nPbatch_montgomery25519_q_12[] = {231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48,90,21,239,238,78,202,71,98,221,74,25,14,52,104,86,203,129,112,143,228,68,7,250,19,186,252,225,53,99,87,39,95,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,49,171,76,227,245,47,149,115,6,126,210,49,141,165,156,142,7,128,23,25,254,255,223,153,207,248,237,162,250,198,67,156,161,169,73,10,135,164,15,62,197,29,189,29,233,29,213,248,37,51,240,20,220,225,237,118,6,251,192,160,51,249,13,128,200,33,171,61,181,149,40,157,81,87,232,179,117,143,223,16,178,66,151,121,165,153,244,21,43,97,130,164,152,211,35,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,141,157,167,22,166,233,3,111,51,116,212,34,62,101,204,129,57,112,28,177,46,211,164,76,149,205,39,197,223,238,176,48,197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113,218,19,60,95,164,29,193,143,31,60,118,76,181,15,34,25,36,25,107,130,112,1,254,30,88,119,91,143,204,104,68,115,191,96,234,8,162,191,161,169,220,137,105,236,215,170,48,86,253,59,49,95,28,131,143,42,119,57,37,26,0,6,3,74};
static const unsigned char precomputed_nPbatch_montgomery25519_n_12[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139,90,45,40,212,48,116,157,8,31,149,17,162,168,8,80,160,222,248,234,103,130,82,113,71,231,32,77,51,157,127,251,13,160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,46,91,106,192,105,223,139,150,210,41,132,178,108,215,36,18,140,88,150,236,62,245,186,175,145,96,199,179,208,55,177,25,129,142,251,243,96,133,162,230,82,12,236,18,159,228,13,83,177,127,202,40,226,42,20,212,223,131,93,100,186,166,252,46,228,205,241,152,208,216,43,53,3,195,46,142,103,217,206,84,73,194,178,157,241,64,165,11,152,2,113,151,69,234,12,192,123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,40,60,147,152,199,95,6,38,58,248,50,106,237,28,163,224,234,179,168,129,118,218,213,122,233,59,115,10,208,154,53,139,61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237,102,244,58,119,155,31,176,155,201,67,186,91,94,48,167,170,255,129,116,151,167,203,173,120,226,156,230,70,180,187,160,129,75,114,85,162,109,230,214,121,39,165,181,96,16,182,162,72,61,8,9,52,189,26,92,30,158,109,130,167,215,80,130,122};
static const unsigned char precomputed_nPbatch_montgomery25519_p_12[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,221,110,85,119,102,142,32,139,41,201,114,77,187,166,133,54,229,25,180,236,76,218,201,124,44,182,42,4,183,49,172,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_nPbatch_montgomery25519_q_13[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,192,51,223,88,76,165,65,245,172,169,217,135,30,175,238,107,118,156,229,115,148,251,35,247,181,153,141,64,209,111,48,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,133,37,52,169,133,200,97,68,65,139,30,226,202,18,162,33,55,136,193,253,245,29,8,169,139,55,159,251,46,166,107,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,227,182,214,47,131,182,21,112,64,150,229,231,76,159,115,101,254,178,24,4,238,128,253,76,19,54,242,153,40,8,96,107,110,203,38,47,155,200,34,223,176,221,103,84,230,144,95,250,34,28,202,120,170,176,202,218,74,129,95,249,77,229,72,123,190,145,102,90,116,173,9,96,1,136,94,70,240,65,189,201,171,145,254,247,129,62,21,105,243,190,11,68,201,228,8,12,8,189,66,216,234,113,36,241,5,26,29,3,178,167,139,138,18,138,176,138,255,185,236,227,217,63,49,202,131,61,120,24,4,243,251,109,137,210,96,75,126,55,164,203,108,60,142,184,22,115,198,64,107,67,90,220,241,226,200,57,51,125,193,103,231,135,174,215,156,67,163,120,76,181,241,178,10,247,172,245,31,239,228,196,174,195,118,22,142,51,13,168,31,199,62,43,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78};
static const unsigned char precomputed_nPbatch_montgomery25519_n_13[] = {107,186,160,142,195,202,118,52,209,113,10,53,105,99,156,228,1,98,117,197,252,194,43,191,179,77,159,99,106,32,14,129,21,84,254,236,239,46,126,131,224,60,237,210,58,234,219,65,146,237,251,203,220,41,72,103,157,160,236,158,3,232,217,187,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,66,162,214,17,77,227,115,67,248,216,210,73,216,96,172,93,126,63,38,233,228,89,232,80,113,127,88,112,85,247,241,224,198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,212,34,94,235,200,193,0,184,101,187,23,99,253,170,8,165,176,93,221,119,178,52,105,186,227,109,125,247,157,129,161,28,1,212,157,103,232,159,234,223,107,249,58,63,187,122,154,71,215,115,105,125,123,13,216,158,238,87,62,1,147,150,74,91,225,250,207,49,79,0,242,177,148,78,153,60,96,143,63,27,126,123,35,67,94,64,246,82,4,143,123,46,214,217,4,203,42,103,110,219,153,124,6,226,248,13,38,209,54,17,138,229,63,108,43,253,67,156,23,218,80,216,42,141,83,202,51,52,204,176,178,17,32,215,206,10,207,12,78,92,119,191,189,237,111,57,21,219,243,225,101,99,132,103,153,131,44,57,99,194,205,134,235,203,124,126,159,19,10,114,85,61,128,28,54,139,148,212,84,221,41,170,135,244,16,248,51,220,233,21,148,142,122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nPbatch_montgomery25519_p_13[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,223,12,82,97,145,239,48,99,177,83,194,80,181,66,99,23,65,96,19,230,123,192,120,197,142,28,29,234,21,134,160,148,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,20,31,116,94,141,126,45,163,85,126,44,19,190,238,243,224,86,12,212,102,52,127,109,241,32,139,167,37,52,87,39,125,242,29,114,232,48,27,244,31,171,46,41,1,218,112,38,126,119,17,27,127,158,41,97,36,105,51,103,198,133,79,214,23,11,234,10,227,139,156,80,199,166,30,156,2,164,43,61,58,71,110,74,197,50,42,192,114,28,144,175,233,77,233,181,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,185,44,222,234,105,45,228,84,211,77,226,210,230,92,138,18,64,100,12,109,20,161,29,169,107,73,50,2,113,32,184,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_14[] = {104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77,62,0,123,251,99,62,66,71,243,231,164,120,115,181,126,254,237,36,36,32,140,194,68,35,73,35,222,199,199,107,28,117,218,151,19,123,28,234,235,200,163,179,10,170,252,43,86,73,85,71,114,100,167,146,135,33,146,246,108,40,7,137,39,115,239,148,237,0,202,18,221,76,204,192,173,223,64,192,155,240,126,69,40,188,148,63,98,179,153,171,127,132,205,146,38,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,233,94,100,214,120,245,139,186,201,108,21,34,160,141,46,28,199,221,166,87,96,122,5,69,213,139,52,244,140,249,113,104,184,73,21,234,140,146,89,66,128,93,207,104,48,232,88,217,71,111,230,170,67,145,116,165,245,23,47,124,139,236,77,143,113,135,245,250,124,30,154,148,22,222,2,117,102,37,93,250,232,201,25,74,171,107,245,58,131,36,66,114,107,208,2,237,127,188,222,241,16,254,146,84,195,223,127,96,31,31,85,67,186,200,162,130,186,146,173,211,182,140,232,125,203,222,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,219,221,104,83,243,49,44,209,154,240,113,203,222,164,106,101,186,231,195,242,96,115,182,109,1,17,204,66,19,22,106,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,236,127,198,169,148,118,83,58,50,75,21,133,21,65,45,14,189,87,81,215,96,59,78,219,142,162,18,59,85,83,99};
static const unsigned char precomputed_nPbatch_montgomery25519_n_14[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,22,25,157,191,182,145,141,114,11,227,34,104,72,192,36,19,221,45,137,85,89,83,163,40,16,141,176,151,27,155,53,98,7,253,193,58,175,41,205,115,33,166,243,153,184,10,43,46,177,68,128,214,230,75,53,63,110,205,14,138,28,4,170,122,252,94,239,81,117,164,15,227,11,136,47,221,160,0,112,48,75,245,169,49,28,66,103,200,31,165,123,91,102,225,49,181,139,146,167,138,83,58,254,190,251,60,110,156,52,211,217,116,28,175,54,171,72,205,88,250,162,123,91,36,201,104,201,225,61,89,240,133,62,242,120,222,117,147,198,216,16,175,16,247,248,60,11,128,6,172,143,37,36,0,216,122,160,69,173,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,182,169,173,124,154,41,121,130,249,60,17,47,224,46,34,4,109,78,19,61,55,95,38,31,3,241,167,172,114,247,68,94,199,15,246,104,121,68,176,114,148,63,133,234,196,214,43,48,37,221,32,76,238,144,186,125,120,124,75,164,245,223,232,123,29,96,25,19,112,147,141,120,188,41,78,222,44,150,121,75,69,175,171,106,40,52,87,126,121,16,126,87,23,36,150,140,160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,37,37,206,228,45,61,199,89,10,17,7,249,133,9,82,105,39,44,59,174,252,120,185,49,25,36,174,51,102,101,30,42,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,42,75,239,217,24,95,98,148,232,45,231,23,58,147,211,241,137,82,226,205,0,137,96,60,250,6,17,71,225,110,153,121};
static const unsigned char precomputed_nPbatch_montgomery25519_p_14[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,33,33,195,205,95,87,46,215,226,73,47,6,206,1,220,87,223,209,122,91,233,94,210,113,168,229,78,121,87,53,230,92,16,248,176,17,243,88,13,137,6,58,182,139,221,105,188,108,139,108,94,186,224,118,160,35,97,77,197,56,233,17,190,90,240,227,251,144,184,238,241,55,58,14,223,188,73,5,141,231,144,206,200,253,27,157,213,251,175,49,90,4,21,43,193,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,91,92,141,74,120,143,102,65,177,14,15,243,89,123,207,69,62,223,25,195,152,71,40,96,65,238,58,41,216,213,97,82,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,35,226,102,111,234,137,9,121,153,51,58,8,51,155,153,57,79,246,105,200,26,149,246,46,35,137,143,149,5,19,66,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_nPbatch_montgomery25519_q_15[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,232,223,29,50,126,217,13,125,105,77,176,189,58,93,172,9,98,165,81,119,248,183,137,75,104,255,23,182,247,162,99,8,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40,52,64,63,32,59,126,186,249,244,99,54,83,22,9,37,16,48,126,99,33,177,126,99,80,233,21,61,226,163,249,55,32,85,216,96,126,239,24,171,238,158,88,201,26,202,187,130,154,241,114,114,95,95,29,6,98,33,120,172,125,108,180,197,114,250,24,107,107,6,101,57,112,116,170,102,232,87,148,128,233,176,179,128,225,215,239,98,241,165,238,3,177,50,199,204,1,174,55,84,177,14,127,76,178,164,64,128,169,117,204,11,247,182,187,200,91,189,166,41,125,251,5,34,240,60,43,170,99,231,139,75,87,251,198,105,248,16,76,143,20,195,153,152,96,240,141,255,220,107,212,231,155,20,32,248,139,96,147,226,70,136,163,126,187,77,21,125,112,229,232,232,195,194,74,226,127,55,149,208,19,158,134,22,89,225,31,185,184,35,162,25,91,32,9,88,219,42,178,51,219,92,36,92,6,17,122,205,3,143,164,248,172,108,77,113,31,45,213,215,21,152,78,171,51,101,8,45,230,27,51,148,195,75,127,203,167,78,137,135,248,54,28,30,246,64,138,219,86,134,110,189,60,9,77,225,121,96,152,132,105,44,180,126,28,69,184,225,234,81,248,99,233,148,25,242,161,80,3,51,87,86,219,28,141,82,225,91,18,209,108,157,87,217,185,241,67,140,38,65,108,77,247,109,169,226,0,168,35,246,109,220,135,77,138,106,158,243,48,87,40};
static const unsigned char precomputed_nPbatch_montgomery25519_n_15[] = {107,93,211,155,221,173,12,104,216,40,219,59,4,41,87,244,86,208,62,135,204,236,147,28,221,9,196,79,1,84,193,178,217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,160,100,121,66,86,16,225,47,180,132,98,217,222,58,98,233,242,189,70,72,24,109,180,168,134,12,202,37,38,186,241,243,199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,66,244,159,19,88,253,213,23,32,209,189,251,8,249,71,51,66,19,33,88,169,184,184,83,24,137,123,237,88,112,136,100,190,147,100,101,77,151,179,249,20,102,182,218,161,187,38,207,142,126,195,32,205,249,96,90,162,80,63,226,98,120,239,127,92,165,88,239,5,221,61,225,13,149,25,23,82,2,96,1,119,0,65,173,221,78,4,206,227,5,131,64,13,203,112,190,237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,48,124,248,1,229,78,90,159,144,127,179,25,138,145,171,159,139,209,42,221,103,134,165,156,190,149,2,186,49,191,106,198,208,146,223,0,10,130,154,248,2,157,61,204,147,5,204,21,114,250,40,205,43,8,80,214,5,101,127,169,30,178,53,137,127,56,48,91,234,196,208,190,82,145,55,146,222,16,9,128,161,66,197,177,237,132,255,64,248,2,201,114,190,1,253,140,197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nPbatch_montgomery25519_p_15[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,219,85,141,78,156,71,229,153,137,212,86,246,41,139,137,210,13,246,3,78,206,173,113,225,30,236,100,242,203,91,142,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,96,42,30,228,229,15,43,141,229,125,150,149,63,62,255,69,132,153,11,122,8,147,80,31,71,0,114,172,6,236,188,169,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nPbatch_montgomery25519_q_16[] = {176,182,52,252,134,77,176,235,75,203,19,14,204,192,20,85,158,135,211,17,217,16,231,54,41,73,208,31,27,201,231,67,215,194,226,30,5,48,102,158,105,8,172,181,127,251,175,126,0,25,101,220,84,10,197,19,105,58,237,49,123,52,190,117,175,8,94,200,26,183,77,83,31,204,57,39,124,104,223,137,28,239,203,131,34,179,127,231,231,26,223,14,36,198,12,102,207,99,98,54,244,37,197,214,156,117,144,114,91,66,109,51,150,66,7,58,125,133,76,166,247,62,34,75,174,82,117,119,245,147,197,14,116,81,238,160,86,55,195,142,129,205,120,245,176,155,135,184,139,85,206,241,38,229,120,82,130,101,111,12,208,178,249,55,16,189,207,176,231,55,81,212,146,150,15,170,230,58,26,147,125,3,171,100,93,198,10,185,34,241,199,78,31,100,25,145,30,62,144,212,64,219,186,236,38,135,240,173,18,18,210,133,193,58,175,187,132,2,62,79,230,138,149,63,121,223,164,139,202,179,32,228,109,181,229,181,139,0,181,124,140,230,145,47,130,223,137,147,17,118,27,113,92,100,228,98,184,104,230,182,129,76,150,111,49,140,51,165,182,24,57,150,50,121,20,24,229,80,67,104,254,120,83,13,14,124,45,86,62,0,123,251,99,62,66,71,243,231,164,120,115,181,126,254,237,36,36,32,140,194,68,35,73,35,222,199,199,107,28,117,250,24,107,107,6,101,57,112,116,170,102,232,87,148,128,233,176,179,128,225,215,239,98,241,165,238,3,177,50,199,204,1,81,212,247,2,165,203,138,13,12,188,47,181,141,146,236,57,186,2,196,20,129,165,17,228,157,55,212,222,126,114,58,74,15,110,14,218,109,97,208,5,119,1,172,107,129,13,15,212,190,36,103,67,142,60,73,93,73,192,62,251,214,1,248,33,8,230,182,92,48,214,174,119,128,155,246,232,247,243,230,27,18,49,135,212,35,67,70,253,49,55,189,111,188,19,5,108,215,155,105,172,214,147,237,205,119,60,252,47,67,96,235,114,110,201,226,162,219,48,127,194,252,165,209,248,235,150,64,23,235,14,110,53,191,65,207,130,47,77,134,173,120,240,222,139,29,180,151,72,162,218,70,217,73,77,253,120,147,236,10,61};
static const unsigned char precomputed_nPbatch_montgomery25519_n_16[] = {15,178,181,41,106,62,93,252,17,170,218,222,225,22,147,136,1,241,195,59,36,141,156,234,43,72,126,126,41,17,193,34,31,239,111,66,250,165,152,62,61,1,47,9,134,219,166,127,174,8,170,206,103,158,99,99,235,95,103,58,250,213,120,252,91,236,197,142,183,255,180,242,223,169,55,214,19,251,194,108,83,232,55,186,94,32,121,252,117,219,77,53,28,82,178,197,202,5,147,74,179,48,169,40,156,198,55,4,197,182,10,91,43,62,80,143,47,103,78,121,37,164,50,113,36,101,11,118,132,172,226,25,189,173,154,215,196,207,251,66,181,178,144,119,92,47,169,146,3,24,13,155,176,60,167,107,65,196,145,120,124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,106,22,136,121,130,169,103,161,11,79,65,78,207,152,232,123,241,32,124,101,14,77,170,5,120,175,47,189,82,25,245,59,45,15,68,93,105,161,236,142,132,222,64,65,61,38,44,243,32,161,134,170,84,232,175,213,242,206,236,93,30,166,38,12,31,60,154,239,1,99,22,215,237,93,143,96,188,253,160,127,211,130,94,5,225,196,37,124,3,57,3,71,4,241,231,15,22,25,157,191,182,145,141,114,11,227,34,104,72,192,36,19,221,45,137,85,89,83,163,40,16,141,176,151,27,155,53,98,92,165,88,239,5,221,61,225,13,149,25,23,82,2,96,1,119,0,65,173,221,78,4,206,227,5,131,64,13,203,112,190,86,113,216,237,144,237,27,77,43,86,221,218,78,165,92,68,2,121,158,174,144,41,197,225,133,57,198,150,193,205,31,80,83,201,187,156,49,162,122,98,244,64,232,65,97,99,249,20,112,35,197,48,214,75,215,12,58,113,197,148,113,214,183,52,132,175,87,38,2,127,24,123,10,20,230,220,70,101,14,168,26,154,32,108,78,93,106,112,2,147,7,146,149,82,157,35,24,113,214,137,60,212,159,0,197,103,163,201,179,148,131,59,203,28,179,9,203,249,187,135,0,163,200,149,208,20,23,253,242,118,199,205,119,164,108,93,255,103,82,80,71,24,76,10,37,191,147,128,26,14,16,1,201,170,187,82,112,15,231,179};
static const unsigned char precomputed_nPbatch_montgomery25519_p_16[] = {56,0,37,25,36,249,203,33,105,221,23,56,110,251,249,180,154,183,67,64,123,150,36,125,50,218,191,132,212,126,128,222,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,77,177,87,210,156,163,175,191,211,150,62,37,21,150,200,44,125,200,224,117,67,164,169,113,221,215,61,61,88,133,65,237,58,50,13,118,120,27,56,5,140,124,44,234,250,149,21,57,233,36,207,197,165,234,195,118,154,167,56,193,69,102,30,217,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,22,72,68,27,247,111,127,36,102,253,162,235,57,103,223,77,206,56,9,214,96,69,138,244,14,98,103,63,107,126,98,84,33,33,195,205,95,87,46,215,226,73,47,6,206,1,220,87,223,209,122,91,233,94,210,113,168,229,78,121,87,53,230,112,219,85,141,78,156,71,229,153,137,212,86,246,41,139,137,210,13,246,3,78,206,173,113,225,30,236,100,242,203,91,142,245,196,70,99,114,97,152,96,91,20,31,160,88,52,151,161,94,92,11,177,23,242,92,137,253,43,147,168,159,120,99,3,68,129,160,218,218,241,248,204,45,63,176,224,36,15,218,40,118,107,85,223,166,31,199,0,47,181,170,156,116,254,39,22,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,0,5,175,234,211,162,13,126,160,91,211,165,51,116,163,210,242,48,25,249,254,242,78,240,81,44,86,166,90,115,206,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
  const unsigned char *p;
  long long psize;
  long long batch;
} precomputed_nPbatch_montgomery25519[precomputed_nPbatch_montgomery25519_NUM] = {
  {
    precomputed_nPbatch_montgomery25519_q_0,0,
    precomputed_nPbatch_montgomery25519_n_0,0,
    precomputed_nPbatch_montgomery25519_p_0,0,
    0,
  },
  {
    precomputed_nPbatch_montgomery25519_q_1,32,
    precomputed_nPbatch_montgomery25519_n_1,32,
    precomputed_nPbatch_montgomery25519_p_1,32,
    1,
  },
  {
    precomputed_nPbatch_montgomery25519_q_2,64,
    precomputed_nPbatch_montgomery25519_n_2,64,
    precomputed_nPbatch_montgomery25519_p_2,64,
    2,
  },
  {
    precomputed_nPbatch_montgomery25519_q_3,96,
    precomputed_nPbatch_montgomery25519_n_3,96,
    precomputed_nPbatch_montgomery25519_p_3,96,
    3,
  },
  {
    precomputed_nPbatch_montgomery25519_q_4,128,
    precomputed_nPbatch_montgomery25519_n_4,128,
    precomputed_nPbatch_montgomery25519_p_4,128,
    4,
  },
  {
    precomputed_nPbatch_montgomery25519_q_5,160,
    precomputed_nPbatch_montgomery25519_n_5,160,
    precomputed_nPbatch_montgomery25519_p_5,160,
    5,
  },
  {
    precomputed_nPbatch_montgomery25519_q_6,192,
    precomputed_nPbatch_montgomery25519_n_6,192,
    precomputed_nPbatch_montgomery25519_p_6,192,
    6,
  },
  {
    precomputed_nPbatch_montgomery25519_q_7,224,
    precomputed_nPbatch_montgomery25519_n_7,224,
    precomputed_nPbatch_montgomery25519_p_7,224,
    7,
  },
  {
    precomputed_nPbatch_montgomery25519_q_8,256,
    precomputed_nPbatch_montgomery25519_n_8,256,
    precomputed_nPbatch_montgomery25519_p_8,256,
    8,
  },
  {
    precomputed_nPbatch_montgomery25519_q_9,288,
    precomputed_nPbatch_montgomery25519_n_9,288,
    precomputed_nPbatch_montgomery25519_p_9,288,
    9,
  },
  {
    precomputed_nPbatch_montgomery25519_q_10,320,
    precomputed_nPbatch_montgomery25519_n_10,320,
    precomputed_nPbatch_montgomery25519_p_10,320,
    10,
  },
  {
    precomputed_nPbatch_montgomery25519_q_11,352,
    precomputed_nPbatch_montgomery25519_n_11,352,
    precomputed_nPbatch_montgomery25519_p_11,352,
    11,
  },
  {
    precomputed_nPbatch_montgomery25519_q_12,384,
    precomputed_nPbatch_montgomery25519_n_12,384,
    precomputed_nPbatch_montgomery25519_p_12,384,
    12,
  },
  {
    precomputed_nPbatch_montgomery25519_q_13,416,
    precomputed_nPbatch_montgomery25519_n_13,416,
    precomputed_nPbatch_montgomery25519_p_13,416,
    13,
  },
  {
    precomputed_nPbatch_montgomery25519_q_14,448,
    precomputed_nPbatch_montgomery25519_n_14,448,
    precomputed_nPbatch_montgomery25519_p_14,448,
    14,
  },
  {
    precomputed_nPbatch_montgomery25519_q_15,480,
    precomputed_nPbatch_montgomery25519_n_15,480,
    precomputed_nPbatch_montgomery25519_p_15,480,
    15,
  },
  {
    precomputed_nPbatch_montgomery25519_q_16,512,
    precomputed_nPbatch_montgomery25519_n_16,512,
    precomputed_nPbatch_montgomery25519_p_16,512,
    16,
  },
} ;

static void test_nPbatch_montgomery25519_impl(long long impl)
{
  unsigned char *q = test_nPbatch_montgomery25519_q;
  unsigned char *n = test_nPbatch_montgomery25519_n;
  unsigned char *p = test_nPbatch_montgomery25519_p;
  unsigned char *q2 = test_nPbatch_montgomery25519_q2;
  unsigned char *n2 = test_nPbatch_montgomery25519_n2;
  unsigned char *p2 = test_nPbatch_montgomery25519_p2;
  long long qlen;
  long long nlen;
  long long plen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_nPbatch_montgomery25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_nPbatch = lib25519_dispatch_nPbatch_montgomery25519(impl);
    printf("nPbatch_montgomery25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_nPbatch_montgomery25519_implementation(impl),lib25519_dispatch_nPbatch_montgomery25519_compiler(impl));
  } else {
    crypto_nPbatch = lib25519_nPbatch_montgomery25519;
    printf("nPbatch_montgomery25519 selected implementation %s compiler %s\n",lib25519_nPbatch_montgomery25519_implementation(),lib25519_nPbatch_montgomery25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 256 : 32;
    long long maxtest = checksumbig ? 128 : 16;
    long long mlen;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      mlen = myrandom() % (maxtest + 1);

      qlen = mlen * crypto_nPbatch_POINTBYTES;
      nlen = mlen * crypto_nPbatch_SCALARBYTES;
      plen = mlen * crypto_nPbatch_POINTBYTES;
      output_prepare(q2,q,qlen);
      input_prepare(n2,n,nlen);
      input_prepare(p2,p,plen);
      secret(n,nlen);
      secret(p,plen);
      crypto_nPbatch(q,n,p,mlen);
      public(n,nlen);
      public(p,plen);
      public(q,qlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_nPbatch");
      input_compare(n2,n,nlen,"crypto_nPbatch");
      input_compare(p2,p,plen,"crypto_nPbatch");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      double_canary(p2,p,plen);
      secret(n2,nlen);
      secret(p2,plen);
      crypto_nPbatch(q2,n2,p2,mlen);
      public(n2,nlen);
      public(p2,plen);
      public(q2,qlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_nPbatch is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      double_canary(p2,p,plen);
      secret(n2,nlen);
      secret(p,plen);
      crypto_nPbatch(n2,n2,p,mlen);
      public(n2,qlen);
      public(p,plen);
      if (memcmp(n2,q,qlen) != 0) fail("failure: crypto_nPbatch does not handle n=q overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(p2,plen);
      crypto_nPbatch(p2,n,p2,mlen);
      public(p2,qlen);
      public(n,nlen);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_nPbatch does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(nPbatch_montgomery25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_nPbatch_montgomery25519_NUM;++precomp) {
    long long mlen = precomputed_nPbatch_montgomery25519[precomp].batch;
    output_prepare(q2,q,precomputed_nPbatch_montgomery25519[precomp].qsize);
    input_prepare(n2,n,precomputed_nPbatch_montgomery25519[precomp].nsize);
    memcpy(n,precomputed_nPbatch_montgomery25519[precomp].n,precomputed_nPbatch_montgomery25519[precomp].nsize);
    memcpy(n2,precomputed_nPbatch_montgomery25519[precomp].n,precomputed_nPbatch_montgomery25519[precomp].nsize);
    input_prepare(p2,p,precomputed_nPbatch_montgomery25519[precomp].psize);
    memcpy(p,precomputed_nPbatch_montgomery25519[precomp].p,precomputed_nPbatch_montgomery25519[precomp].psize);
    memcpy(p2,precomputed_nPbatch_montgomery25519[precomp].p,precomputed_nPbatch_montgomery25519[precomp].psize);
    crypto_nPbatch(q,n,p,mlen);
    if (memcmp(q,precomputed_nPbatch_montgomery25519[precomp].q,precomputed_nPbatch_montgomery25519[precomp].qsize)) {
      fail("failure: crypto_nPbatch fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_nPbatch_montgomery25519[precomp].qsize;++pos) printf("%02x",precomputed_nPbatch_montgomery25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_nPbatch_montgomery25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_nPbatch_montgomery25519[precomp].qsize,"crypto_nPbatch");
    input_compare(n2,n,precomputed_nPbatch_montgomery25519[precomp].nsize,"crypto_nPbatch");
    input_compare(p2,p,precomputed_nPbatch_montgomery25519[precomp].psize,"crypto_nPbatch");
  }
}

void test_nPbatch_montgomery25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"nPbatch")) return;
  if (targetp && strcmp(targetp,"montgomery25519")) return;
  storage_nPbatch_montgomery25519_q = callocplus(128*crypto_nPbatch_POINTBYTES);
  test_nPbatch_montgomery25519_q = aligned(storage_nPbatch_montgomery25519_q,128*crypto_nPbatch_POINTBYTES);
  if (128*crypto_nPbatch_POINTBYTES > maxalloc) maxalloc = 128*crypto_nPbatch_POINTBYTES;
  storage_nPbatch_montgomery25519_n = callocplus(128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES));
  test_nPbatch_montgomery25519_n = aligned(storage_nPbatch_montgomery25519_n,128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES));
  if (128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES) > maxalloc) maxalloc = 128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES);
  storage_nPbatch_montgomery25519_p = callocplus(128*crypto_nPbatch_POINTBYTES);
  test_nPbatch_montgomery25519_p = aligned(storage_nPbatch_montgomery25519_p,128*crypto_nPbatch_POINTBYTES);
  if (128*crypto_nPbatch_POINTBYTES > maxalloc) maxalloc = 128*crypto_nPbatch_POINTBYTES;
  storage_nPbatch_montgomery25519_q2 = callocplus(maxalloc);
  test_nPbatch_montgomery25519_q2 = aligned(storage_nPbatch_montgomery25519_q2,128*crypto_nPbatch_POINTBYTES);
  storage_nPbatch_montgomery25519_n2 = callocplus(maxalloc);
  test_nPbatch_montgomery25519_n2 = aligned(storage_nPbatch_montgomery25519_n2,128*(crypto_nPbatch_SCALARBYTES+crypto_nPbatch_POINTBYTES));
  storage_nPbatch_montgomery25519_p2 = callocplus(maxalloc);
  test_nPbatch_montgomery25519_p2 = aligned(storage_nPbatch_montgomery25519_p2,128*crypto_nPbatch_POINTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("nPbatch_montgomery25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_nPbatch_montgomery25519();++impl)
      forked(test_nPbatch_montgomery25519_impl,impl);
    ++test_nPbatch_montgomery25519_q;
    ++test_nPbatch_montgomery25519_n;
    ++test_nPbatch_montgomery25519_p;
    ++test_nPbatch_montgomery25519_q2;
    ++test_nPbatch_montgomery25519_n2;
    ++test_nPbatch_montgomery25519_p2;
  }
  free(storage_nPbatch_montgomery25519_p2);
  free(storage_nPbatch_montgomery25519_n2);
  free(storage_nPbatch_montgomery25519_q2);
  free(storage_nPbatch_montgomery25519_p);
  free(storage_nPbatch_montgomery25519_n);
  free(storage_nPbatch_montgomery25519_q);
}
#undef crypto_nPbatch_SCALARBYTES
#undef crypto_nPbatch_POINTBYTES

