/* ----- powbatch/inv25519, derived from supercop/crypto_powbatch/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *powbatch_inv25519_checksums[] = {
  "45b0b9dfeb75a7599064cbcd4fb3a5616105fe80f1dc7bf5258de9d1cb48c8e6",
  "9640b3e6b144ed3ef470ab7c8a24c30c18d951f36ca19890224c1ea3d7703317",
} ;

static void (*crypto_powbatch)(unsigned char *,const unsigned char *,long long);
#define crypto_powbatch_BYTES lib25519_powbatch_inv25519_BYTES

static void *storage_powbatch_inv25519_q;
static unsigned char *test_powbatch_inv25519_q;
static void *storage_powbatch_inv25519_p;
static unsigned char *test_powbatch_inv25519_p;
static void *storage_powbatch_inv25519_q2;
static unsigned char *test_powbatch_inv25519_q2;
static void *storage_powbatch_inv25519_p2;
static unsigned char *test_powbatch_inv25519_p2;

#define precomputed_powbatch_inv25519_NUM 170

static const unsigned char precomputed_powbatch_inv25519_q_0[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_0[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_1[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_1[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_2[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_2[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_3[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_3[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_4[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_4[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_5[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_5[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_6[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_6[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_7[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_7[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_8[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_8[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_9[] = {};
static const unsigned char precomputed_powbatch_inv25519_p_9[] = {};
static const unsigned char precomputed_powbatch_inv25519_q_10[] = {47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15};
static const unsigned char precomputed_powbatch_inv25519_p_10[] = {35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209};
static const unsigned char precomputed_powbatch_inv25519_q_11[] = {122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28};
static const unsigned char precomputed_powbatch_inv25519_p_11[] = {142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102};
static const unsigned char precomputed_powbatch_inv25519_q_12[] = {60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44};
static const unsigned char precomputed_powbatch_inv25519_p_12[] = {114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51};
static const unsigned char precomputed_powbatch_inv25519_q_13[] = {107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68};
static const unsigned char precomputed_powbatch_inv25519_p_13[] = {108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192};
static const unsigned char precomputed_powbatch_inv25519_q_14[] = {164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_powbatch_inv25519_p_14[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_15[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_15[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_16[] = {220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15};
static const unsigned char precomputed_powbatch_inv25519_p_16[] = {27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144};
static const unsigned char precomputed_powbatch_inv25519_q_17[] = {44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111};
static const unsigned char precomputed_powbatch_inv25519_p_17[] = {56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177};
static const unsigned char precomputed_powbatch_inv25519_q_18[] = {37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21};
static const unsigned char precomputed_powbatch_inv25519_p_18[] = {237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108};
static const unsigned char precomputed_powbatch_inv25519_q_19[] = {195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111};
static const unsigned char precomputed_powbatch_inv25519_p_19[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_20[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75};
static const unsigned char precomputed_powbatch_inv25519_p_20[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16};
static const unsigned char precomputed_powbatch_inv25519_q_21[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_powbatch_inv25519_p_21[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_22[] = {244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12};
static const unsigned char precomputed_powbatch_inv25519_p_22[] = {22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_23[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_powbatch_inv25519_p_23[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_24[] = {157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_24[] = {244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_25[] = {204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_powbatch_inv25519_p_25[] = {238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_26[] = {239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_powbatch_inv25519_p_26[] = {190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_27[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106};
static const unsigned char precomputed_powbatch_inv25519_p_27[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17};
static const unsigned char precomputed_powbatch_inv25519_q_28[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_powbatch_inv25519_p_28[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_29[] = {68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_powbatch_inv25519_p_29[] = {109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_30[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3};
static const unsigned char precomputed_powbatch_inv25519_p_30[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_powbatch_inv25519_q_31[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40};
static const unsigned char precomputed_powbatch_inv25519_p_31[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_powbatch_inv25519_q_32[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85};
static const unsigned char precomputed_powbatch_inv25519_p_32[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212};
static const unsigned char precomputed_powbatch_inv25519_q_33[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1};
static const unsigned char precomputed_powbatch_inv25519_p_33[] = {221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16};
static const unsigned char precomputed_powbatch_inv25519_q_34[] = {149,77,244,53,53,179,126,41,219,42,231,103,64,15,240,173,90,157,174,130,89,199,42,206,228,212,76,252,106,140,56,21,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10};
static const unsigned char precomputed_powbatch_inv25519_p_34[] = {19,137,17,15,242,181,77,55,255,2,106,123,184,194,112,245,204,230,90,240,209,188,209,175,61,67,172,143,75,148,1,255,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204};
static const unsigned char precomputed_powbatch_inv25519_q_35[] = {61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_powbatch_inv25519_p_35[] = {194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_36[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8};
static const unsigned char precomputed_powbatch_inv25519_p_36[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253};
static const unsigned char precomputed_powbatch_inv25519_q_37[] = {37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104};
static const unsigned char precomputed_powbatch_inv25519_p_37[] = {237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118};
static const unsigned char precomputed_powbatch_inv25519_q_38[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_38[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_39[] = {32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51};
static const unsigned char precomputed_powbatch_inv25519_p_39[] = {46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151};
static const unsigned char precomputed_powbatch_inv25519_q_40[] = {154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127};
static const unsigned char precomputed_powbatch_inv25519_p_40[] = {213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3};
static const unsigned char precomputed_powbatch_inv25519_q_41[] = {1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_powbatch_inv25519_p_41[] = {89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_42[] = {218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18};
static const unsigned char precomputed_powbatch_inv25519_p_42[] = {86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_43[] = {20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,133,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49};
static const unsigned char precomputed_powbatch_inv25519_p_43[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_44[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_44[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_45[] = {95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24};
static const unsigned char precomputed_powbatch_inv25519_p_45[] = {192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255};
static const unsigned char precomputed_powbatch_inv25519_q_46[] = {160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5};
static const unsigned char precomputed_powbatch_inv25519_p_46[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207};
static const unsigned char precomputed_powbatch_inv25519_q_47[] = {231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12};
static const unsigned char precomputed_powbatch_inv25519_p_47[] = {180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157};
static const unsigned char precomputed_powbatch_inv25519_q_48[] = {102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120};
static const unsigned char precomputed_powbatch_inv25519_p_48[] = {27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176};
static const unsigned char precomputed_powbatch_inv25519_q_49[] = {98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78};
static const unsigned char precomputed_powbatch_inv25519_p_49[] = {187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_50[] = {30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82};
static const unsigned char precomputed_powbatch_inv25519_p_50[] = {93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32};
static const unsigned char precomputed_powbatch_inv25519_q_51[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_powbatch_inv25519_p_51[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_52[] = {250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_powbatch_inv25519_p_52[] = {244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_53[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_powbatch_inv25519_p_53[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_powbatch_inv25519_q_54[] = {61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_54[] = {223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_55[] = {145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,57,223,157,125,238,224,147,49,254,234,178,208,159,240,225,64,132,52,197,214,65,81,250,170,171,134,212,82,97,17,143,57};
static const unsigned char precomputed_powbatch_inv25519_p_55[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,147,246,106,224,201,236,94,37,219,83,4,251,201,149,209,68,14,88,2,140,90,210,82,209,250,61,250,245,196,119,203,26};
static const unsigned char precomputed_powbatch_inv25519_q_56[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115};
static const unsigned char precomputed_powbatch_inv25519_p_56[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_57[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_57[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_58[] = {131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_58[] = {135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_59[] = {87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100};
static const unsigned char precomputed_powbatch_inv25519_p_59[] = {76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253};
static const unsigned char precomputed_powbatch_inv25519_q_60[] = {30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_powbatch_inv25519_p_60[] = {93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_61[] = {44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18};
static const unsigned char precomputed_powbatch_inv25519_p_61[] = {33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_62[] = {10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87};
static const unsigned char precomputed_powbatch_inv25519_p_62[] = {138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80};
static const unsigned char precomputed_powbatch_inv25519_q_63[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_63[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_64[] = {92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80};
static const unsigned char precomputed_powbatch_inv25519_p_64[] = {220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_65[] = {223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123};
static const unsigned char precomputed_powbatch_inv25519_p_65[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53};
static const unsigned char precomputed_powbatch_inv25519_q_66[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54};
static const unsigned char precomputed_powbatch_inv25519_p_66[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163};
static const unsigned char precomputed_powbatch_inv25519_q_67[] = {113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_powbatch_inv25519_p_67[] = {6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_68[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_powbatch_inv25519_p_68[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_69[] = {131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_69[] = {135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_70[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111};
static const unsigned char precomputed_powbatch_inv25519_p_70[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221};
static const unsigned char precomputed_powbatch_inv25519_q_71[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,10,112,77,248,215,20,81,248,239,85,249,63,227,118,43,8,62,101,27,56,86,116,15,149,157,61,205,251,137,165,102,37,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16};
static const unsigned char precomputed_powbatch_inv25519_p_71[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,173,58,243,101,117,198,170,56,209,211,188,81,55,42,168,124,219,190,185,49,16,182,103,120,142,68,168,211,236,170,161,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247};
static const unsigned char precomputed_powbatch_inv25519_q_72[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103};
static const unsigned char precomputed_powbatch_inv25519_p_72[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_powbatch_inv25519_q_73[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39};
static const unsigned char precomputed_powbatch_inv25519_p_73[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_74[] = {64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,57,223,157,125,238,224,147,49,254,234,178,208,159,240,225,64,132,52,197,214,65,81,250,170,171,134,212,82,97,17,143,57,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32};
static const unsigned char precomputed_powbatch_inv25519_p_74[] = {144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,147,246,106,224,201,236,94,37,219,83,4,251,201,149,209,68,14,88,2,140,90,210,82,209,250,61,250,245,196,119,203,26,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108};
static const unsigned char precomputed_powbatch_inv25519_q_75[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_75[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_76[] = {191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_powbatch_inv25519_p_76[] = {197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_77[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12};
static const unsigned char precomputed_powbatch_inv25519_p_77[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_78[] = {21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3};
static const unsigned char precomputed_powbatch_inv25519_p_78[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_powbatch_inv25519_q_79[] = {122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23};
static const unsigned char precomputed_powbatch_inv25519_p_79[] = {142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_80[] = {128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_powbatch_inv25519_p_80[] = {95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_81[] = {68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_p_81[] = {109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_82[] = {163,122,63,119,3,151,5,212,188,30,80,65,104,9,118,149,121,77,179,29,167,6,121,68,20,203,120,37,24,177,88,49,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,65,202,102,109,103,80,115,84,86,255,69,144,130,156,246,146,171,184,205,92,6,56,1,209,45,189,61,184,217,216,238,107};
static const unsigned char precomputed_powbatch_inv25519_p_82[] = {71,203,163,127,61,162,83,158,17,109,46,29,186,163,167,133,48,164,87,132,47,234,224,217,22,54,128,190,165,114,54,40,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,164,38,103,254,232,227,99,197,120,216,11,141,6,80,149,82,139,5,14,109,151,171,95,140,120,105,222,29,75,225,179};
static const unsigned char precomputed_powbatch_inv25519_q_83[] = {119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_powbatch_inv25519_p_83[] = {143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_84[] = {223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51};
static const unsigned char precomputed_powbatch_inv25519_p_84[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172};
static const unsigned char precomputed_powbatch_inv25519_q_85[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_powbatch_inv25519_p_85[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_86[] = {47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49,68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_powbatch_inv25519_p_86[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_87[] = {183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_powbatch_inv25519_p_87[] = {151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_88[] = {226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,183,19,131,62,107,60,139,25,159,81,252,127,241,150,167,10,86,224,76,177,199,197,197,80,104,31,181,26,122,42,200,107,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_powbatch_inv25519_p_88[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,81,108,252,226,91,123,2,58,201,115,182,53,216,106,226,19,255,189,15,42,27,210,228,103,255,63,80,6,101,105,24,137,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_89[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,170,226,249,137,116,167,226,120,193,243,124,147,88,138,15,162,48,71,145,111,254,119,63,233,128,23,10,92,67,118,30,30,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54};
static const unsigned char precomputed_powbatch_inv25519_p_89[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,91,245,72,216,90,199,134,172,165,93,168,104,67,11,211,223,41,7,195,248,1,92,138,40,187,117,230,81,86,91,26,174,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163};
static const unsigned char precomputed_powbatch_inv25519_q_90[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28};
static const unsigned char precomputed_powbatch_inv25519_p_90[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30};
static const unsigned char precomputed_powbatch_inv25519_q_91[] = {160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30};
static const unsigned char precomputed_powbatch_inv25519_p_91[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179};
static const unsigned char precomputed_powbatch_inv25519_q_92[] = {52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,30,77,35,14,207,56,225,204,214,84,214,43,10,5,131,1,232,164,48,194,28,249,10,221,177,149,235,251,97,74,211,10,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_92[] = {40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,108,209,156,236,156,166,225,245,1,255,55,161,87,186,87,163,186,173,58,130,239,62,58,38,221,97,184,184,72,35,198,201,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_93[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16};
static const unsigned char precomputed_powbatch_inv25519_p_93[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247};
static const unsigned char precomputed_powbatch_inv25519_q_94[] = {87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_powbatch_inv25519_p_94[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_powbatch_inv25519_q_95[] = {162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,176,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,45,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,24,0,179,212,28,171,145,205,100,98,74,136,173,166,5,71,245,245,134,228,226,81,250,177,85,93,34,216,87,56,39,8,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30};
static const unsigned char precomputed_powbatch_inv25519_p_95[] = {139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,210,202,220,164,246,20,113,100,180,12,151,155,88,88,88,145,232,83,65,207,203,112,134,14,206,120,161,44,178,247,76,79,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179};
static const unsigned char precomputed_powbatch_inv25519_q_96[] = {10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,225,186,121,98,173,21,21,215,110,75,191,20,71,113,25,23,202,27,131,16,127,51,113,82,20,236,251,108,6,13,170,112,70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_96[] = {138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,57,236,93,48,192,237,101,125,11,22,182,131,135,237,215,120,196,89,208,70,90,68,155,140,49,154,250,205,35,42,34,171,250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_97[] = {64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_powbatch_inv25519_p_97[] = {18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_98[] = {1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_98[] = {183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_99[] = {229,167,235,58,38,253,227,229,144,252,65,147,155,192,1,200,234,201,60,53,72,205,125,195,152,107,147,58,133,244,226,57,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40};
static const unsigned char precomputed_powbatch_inv25519_p_99[] = {46,145,77,66,148,249,125,134,154,224,31,41,99,28,127,185,90,83,173,89,42,15,229,221,132,185,57,226,109,127,221,195,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199};
static const unsigned char precomputed_powbatch_inv25519_q_100[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81};
static const unsigned char precomputed_powbatch_inv25519_p_100[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_101[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12};
static const unsigned char precomputed_powbatch_inv25519_p_101[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_102[] = {203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,194,21,95,5,118,195,213,133,77,184,255,154,248,106,211,69,190,97,64,75,113,2,168,123,145,239,139,148,112,167,185,35,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_powbatch_inv25519_p_102[] = {125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,196,226,59,10,69,172,238,59,12,106,114,210,55,110,197,177,226,149,26,253,22,198,190,45,156,32,60,94,30,193,155,190,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_103[] = {52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29};
static const unsigned char precomputed_powbatch_inv25519_p_103[] = {40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_104[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30,42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16};
static const unsigned char precomputed_powbatch_inv25519_p_104[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_105[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_105[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_106[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100};
static const unsigned char precomputed_powbatch_inv25519_p_106[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253};
static const unsigned char precomputed_powbatch_inv25519_q_107[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_107[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_108[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104};
static const unsigned char precomputed_powbatch_inv25519_p_108[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118};
static const unsigned char precomputed_powbatch_inv25519_q_109[] = {61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_powbatch_inv25519_p_109[] = {194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_110[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,89,198,80,48,244,56,47,214,227,188,88,156,193,94,9,89,75,209,109,178,3,109,160,247,107,98,103,234,213,41,188,13,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69};
static const unsigned char precomputed_powbatch_inv25519_p_110[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,91,94,189,239,65,25,164,16,97,157,57,15,98,46,197,53,97,137,208,106,56,113,72,246,21,174,146,118,48,34,127,250,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_111[] = {174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,65,202,102,109,103,80,115,84,86,255,69,144,130,156,246,146,171,184,205,92,6,56,1,209,45,189,61,184,217,216,238,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_powbatch_inv25519_p_111[] = {242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,164,38,103,254,232,227,99,197,120,216,11,141,6,80,149,82,139,5,14,109,151,171,95,140,120,105,222,29,75,225,179,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_112[] = {29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82};
static const unsigned char precomputed_powbatch_inv25519_p_112[] = {222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32};
static const unsigned char precomputed_powbatch_inv25519_q_113[] = {216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,99,201,196,169,55,97,250,40,141,136,16,157,64,175,118,170,88,177,140,160,7,30,114,150,4,66,180,241,24,77,251,24,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_powbatch_inv25519_p_113[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,172,37,106,178,186,134,115,186,94,177,212,105,200,72,126,162,183,252,84,234,71,113,123,115,27,145,22,179,65,52,126,200,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_114[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106};
static const unsigned char precomputed_powbatch_inv25519_p_114[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17};
static const unsigned char precomputed_powbatch_inv25519_q_115[] = {75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104};
static const unsigned char precomputed_powbatch_inv25519_p_115[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14};
static const unsigned char precomputed_powbatch_inv25519_q_116[] = {25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,194,21,95,5,118,195,213,133,77,184,255,154,248,106,211,69,190,97,64,75,113,2,168,123,145,239,139,148,112,167,185,35,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_116[] = {15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,196,226,59,10,69,172,238,59,12,106,114,210,55,110,197,177,226,149,26,253,22,198,190,45,156,32,60,94,30,193,155,190,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_117[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,10,112,77,248,215,20,81,248,239,85,249,63,227,118,43,8,62,101,27,56,86,116,15,149,157,61,205,251,137,165,102,37};
static const unsigned char precomputed_powbatch_inv25519_p_117[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,66,173,58,243,101,117,198,170,56,209,211,188,81,55,42,168,124,219,190,185,49,16,182,103,120,142,68,168,211,236,170,161};
static const unsigned char precomputed_powbatch_inv25519_q_118[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,89,145,129,24,248,62,149,212,214,140,43,190,89,228,1,213,214,167,111,57,89,200,78,150,104,191,130,246,83,119,194,71,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_p_118[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,168,188,69,201,152,212,193,230,142,199,30,182,79,33,156,162,216,59,153,29,99,172,127,139,16,93,159,100,40,94,29,239,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_119[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,198,198,211,121,255,219,233,129,21,15,70,214,117,210,246,255,141,73,177,65,9,198,234,94,196,241,32,208,245,146,188,115,26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7};
static const unsigned char precomputed_powbatch_inv25519_p_119[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,249,139,242,180,114,253,231,63,42,190,37,169,162,179,81,193,126,98,185,1,76,62,17,143,53,76,176,138,212,238,81,67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181};
static const unsigned char precomputed_powbatch_inv25519_q_120[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19};
static const unsigned char precomputed_powbatch_inv25519_p_120[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_121[] = {19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,229,167,235,58,38,253,227,229,144,252,65,147,155,192,1,200,234,201,60,53,72,205,125,195,152,107,147,58,133,244,226,57,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_121[] = {5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,46,145,77,66,148,249,125,134,154,224,31,41,99,28,127,185,90,83,173,89,42,15,229,221,132,185,57,226,109,127,221,195,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_122[] = {252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39};
static const unsigned char precomputed_powbatch_inv25519_p_122[] = {195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245};
static const unsigned char precomputed_powbatch_inv25519_q_123[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_powbatch_inv25519_p_123[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_124[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_124[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_125[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_p_125[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_126[] = {124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,99,139,94,252,32,74,144,89,201,238,12,147,88,178,109,115,251,249,27,173,176,90,202,53,157,93,69,69,158,207,96,85,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24,172,154,20,26,177,187,189,219,238,205,20,135,222,148,10,180,45,77,167,230,85,220,108,93,190,152,222,115,194,46,238,38,107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67};
static const unsigned char precomputed_powbatch_inv25519_p_126[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,187,57,121,219,7,180,245,79,199,28,235,3,229,24,162,210,72,140,56,149,230,163,235,193,41,191,151,78,2,170,133,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255,49,227,89,1,60,152,183,120,89,158,57,84,116,231,55,213,6,81,44,123,127,232,229,121,133,50,184,254,130,13,213,183,108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200};
static const unsigned char precomputed_powbatch_inv25519_q_127[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,225,186,121,98,173,21,21,215,110,75,191,20,71,113,25,23,202,27,131,16,127,51,113,82,20,236,251,108,6,13,170,112,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_powbatch_inv25519_p_127[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,57,236,93,48,192,237,101,125,11,22,182,131,135,237,215,120,196,89,208,70,90,68,155,140,49,154,250,205,35,42,34,171,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_128[] = {154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95,154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_powbatch_inv25519_p_128[] = {213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180,213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_129[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_powbatch_inv25519_p_129[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_130[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98};
static const unsigned char precomputed_powbatch_inv25519_p_130[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_131[] = {222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_powbatch_inv25519_p_131[] = {102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_132[] = {19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103};
static const unsigned char precomputed_powbatch_inv25519_p_132[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_powbatch_inv25519_q_133[] = {70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92,131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86,99,139,94,252,32,74,144,89,201,238,12,147,88,178,109,115,251,249,27,173,176,90,202,53,157,93,69,69,158,207,96,85};
static const unsigned char precomputed_powbatch_inv25519_p_133[] = {250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223,214,187,57,121,219,7,180,245,79,199,28,235,3,229,24,162,210,72,140,56,149,230,163,235,193,41,191,151,78,2,170,133};
static const unsigned char precomputed_powbatch_inv25519_q_134[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32,252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34};
static const unsigned char precomputed_powbatch_inv25519_p_134[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108,195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_135[] = {252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46,47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118};
static const unsigned char precomputed_powbatch_inv25519_p_135[] = {195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16,35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224};
static const unsigned char precomputed_powbatch_inv25519_q_136[] = {183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7};
static const unsigned char precomputed_powbatch_inv25519_p_136[] = {151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181};
static const unsigned char precomputed_powbatch_inv25519_q_137[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8};
static const unsigned char precomputed_powbatch_inv25519_p_137[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41};
static const unsigned char precomputed_powbatch_inv25519_q_138[] = {250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51};
static const unsigned char precomputed_powbatch_inv25519_p_138[] = {244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172};
static const unsigned char precomputed_powbatch_inv25519_q_139[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79};
static const unsigned char precomputed_powbatch_inv25519_p_139[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_140[] = {60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,163,122,63,119,3,151,5,212,188,30,80,65,104,9,118,149,121,77,179,29,167,6,121,68,20,203,120,37,24,177,88,49,50,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,46,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_powbatch_inv25519_p_140[] = {180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,71,203,163,127,61,162,83,158,17,109,46,29,186,163,167,133,48,164,87,132,47,234,224,217,22,54,128,190,165,114,54,40,201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_141[] = {133,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_powbatch_inv25519_p_141[] = {206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_142[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_powbatch_inv25519_p_142[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_143[] = {23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_powbatch_inv25519_p_143[] = {170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_144[] = {120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58};
static const unsigned char precomputed_powbatch_inv25519_p_144[] = {129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_powbatch_inv25519_q_145[] = {107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92,231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_powbatch_inv25519_p_145[] = {108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_146[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35};
static const unsigned char precomputed_powbatch_inv25519_p_146[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_147[] = {153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123};
static const unsigned char precomputed_powbatch_inv25519_p_147[] = {62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235};
static const unsigned char precomputed_powbatch_inv25519_q_148[] = {87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13};
static const unsigned char precomputed_powbatch_inv25519_p_148[] = {97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119};
static const unsigned char precomputed_powbatch_inv25519_q_149[] = {113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15};
static const unsigned char precomputed_powbatch_inv25519_p_149[] = {211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144};
static const unsigned char precomputed_powbatch_inv25519_q_150[] = {153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49,218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_powbatch_inv25519_p_150[] = {62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_151[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,149,77,244,53,53,179,126,41,219,42,231,103,64,15,240,173,90,157,174,130,89,199,42,206,228,212,76,252,106,140,56,21,89,145,129,24,248,62,149,212,214,140,43,190,89,228,1,213,214,167,111,57,89,200,78,150,104,191,130,246,83,119,194,71,20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,50,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,46,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_powbatch_inv25519_p_151[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,137,17,15,242,181,77,55,255,2,106,123,184,194,112,245,204,230,90,240,209,188,209,175,61,67,172,143,75,148,1,255,168,188,69,201,152,212,193,230,142,199,30,182,79,33,156,162,216,59,153,29,99,172,127,139,16,93,159,100,40,94,29,239,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_152[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,170,226,249,137,116,167,226,120,193,243,124,147,88,138,15,162,48,71,145,111,254,119,63,233,128,23,10,92,67,118,30,30,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,139,217,27,238,113,28,242,233,76,16,196,238,215,96,153,61,0,64,134,198,20,205,154,208,84,164,135,54,153,95,4,126,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21};
static const unsigned char precomputed_powbatch_inv25519_p_152[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,91,245,72,216,90,199,134,172,165,93,168,104,67,11,211,223,41,7,195,248,1,92,138,40,187,117,230,81,86,91,26,174,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,189,68,80,58,53,159,69,72,96,63,22,164,219,217,177,104,30,162,150,170,40,227,107,49,103,70,18,244,141,182,4,120,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155};
static const unsigned char precomputed_powbatch_inv25519_q_153[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51,239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,153,123,171,215,228,176,169,26,86,118,67,64,128,172,246,201,4,70,71,252,163,227,127,42,24,49,155,199,77,129,4,45,64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123};
static const unsigned char precomputed_powbatch_inv25519_p_153[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151,190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,232,64,0,7,2,215,145,253,104,71,120,112,176,10,157,243,134,72,12,11,14,242,103,82,237,168,70,157,242,247,10,224,18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235};
static const unsigned char precomputed_powbatch_inv25519_q_154[] = {255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18,153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106,47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15,44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92};
static const unsigned char precomputed_powbatch_inv25519_p_154[] = {205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17,35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209,56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_155[] = {230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41,78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116,145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32};
static const unsigned char precomputed_powbatch_inv25519_p_155[] = {16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108};
static const unsigned char precomputed_powbatch_inv25519_q_156[] = {145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29,218,44,117,234,3,221,97,148,64,22,1,104,162,171,212,147,56,101,247,120,8,181,246,246,147,242,168,40,240,191,81,91,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_powbatch_inv25519_p_156[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,88,23,254,127,125,50,108,114,175,73,57,176,55,155,159,156,225,178,180,167,133,57,53,105,82,105,36,21,156,137,88,193,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_157[] = {128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_powbatch_inv25519_p_157[] = {95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_powbatch_inv25519_q_158[] = {87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21,223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22,26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67,214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5,60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105};
static const unsigned char precomputed_powbatch_inv25519_p_158[] = {102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155,147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44,14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200,204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207,114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234};
static const unsigned char precomputed_powbatch_inv25519_q_159[] = {88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111,148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125};
static const unsigned char precomputed_powbatch_inv25519_p_159[] = {174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221,174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146};
static const unsigned char precomputed_powbatch_inv25519_q_160[] = {204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40,145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43,73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92,44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_powbatch_inv25519_p_160[] = {238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_161[] = {126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,153,123,171,215,228,176,169,26,86,118,67,64,128,172,246,201,4,70,71,252,163,227,127,42,24,49,155,199,77,129,4,45,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0,102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105,191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92,137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40,195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113,48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51,8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75};
static const unsigned char precomputed_powbatch_inv25519_p_161[] = {25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,232,64,0,7,2,215,145,253,104,71,120,112,176,10,157,243,134,72,12,11,14,242,103,82,237,168,70,157,242,247,10,224,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132,27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196,34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172,226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16};
static const unsigned char precomputed_powbatch_inv25519_q_162[] = {26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10,36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123,191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13,214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5,231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40};
static const unsigned char precomputed_powbatch_inv25519_p_162[] = {67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204,170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173,204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207,180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_powbatch_inv25519_q_163[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,218,44,117,234,3,221,97,148,64,22,1,104,162,171,212,147,56,101,247,120,8,181,246,246,147,242,168,40,240,191,81,91,136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111,68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85};
static const unsigned char precomputed_powbatch_inv25519_p_163[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,88,23,254,127,125,50,108,114,175,73,57,176,55,155,159,156,225,178,180,167,133,57,53,105,82,105,36,21,156,137,88,193,35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212};
static const unsigned char precomputed_powbatch_inv25519_q_164[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115,249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103,87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15,247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_powbatch_inv25519_p_164[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144,210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_powbatch_inv25519_q_165[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82,226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60,42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16,98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10,19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49,6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23,119,103,199,145,13,212,68,180,32,154,11,70,33,64,99,183,127,26,61,109,5,129,168,139,16,89,194,52,24,154,5,41,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5,189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_powbatch_inv25519_p_165[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96,5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,37,10,26,225,245,150,67,90,82,89,131,201,239,182,175,225,228,27,31,200,10,216,0,158,161,240,56,190,37,98,129,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_166[] = {186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83,244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113,160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37,184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43,56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8,24,0,179,212,28,171,145,205,100,98,74,136,173,166,5,71,245,245,134,228,226,81,250,177,85,93,34,216,87,56,39,8,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67,113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61,198,198,211,121,255,219,233,129,21,15,70,214,117,210,246,255,141,73,177,65,9,198,234,94,196,241,32,208,245,146,188,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28,34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_powbatch_inv25519_p_166[] = {54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152,22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136,99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41,210,202,220,164,246,20,113,100,180,12,151,155,88,88,88,145,232,83,65,207,203,112,134,14,206,120,161,44,178,247,76,79,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214,6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67,139,249,139,242,180,114,253,231,63,42,190,37,169,162,179,81,193,126,98,185,1,76,62,17,143,53,76,176,138,212,238,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_powbatch_inv25519_q_167[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81,11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123,92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7,208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93,216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68,119,103,199,145,13,212,68,180,32,154,11,70,33,64,99,183,127,26,61,109,5,129,168,139,16,89,194,52,24,154,5,41,230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103,23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16,77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_powbatch_inv25519_p_167[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235,220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,160,37,10,26,225,245,150,67,90,82,89,131,201,239,182,175,225,228,27,31,200,10,216,0,158,161,240,56,190,37,98,129,16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123,170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_powbatch_inv25519_q_168[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35,1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45,99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125,246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37,166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7,31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37,137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69,92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70,219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,58,222,210,172,117,119,57,61,224,20,29,150,221,44,144,70,140,51,231,175,210,153,37,88,146,194,225,169,73,158,19,113,113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34,107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10};
static const unsigned char precomputed_powbatch_inv25519_p_168[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193,28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146,82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58,241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6,129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5,222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,192,151,177,212,242,244,63,100,18,73,46,25,215,142,32,185,134,95,138,231,167,29,123,189,146,175,242,71,212,160,210,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204};
static const unsigned char precomputed_powbatch_inv25519_q_169[] = {100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92,150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25,164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42,124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87,242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2,75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69,207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26,107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68,162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58,21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47,25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77,19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8,61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_powbatch_inv25519_p_169[] = {219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80,149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55,108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169,239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *p;
  long long psize;
  long long batch;
} precomputed_powbatch_inv25519[precomputed_powbatch_inv25519_NUM] = {
  {
    precomputed_powbatch_inv25519_q_0,0,
    precomputed_powbatch_inv25519_p_0,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_1,0,
    precomputed_powbatch_inv25519_p_1,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_2,0,
    precomputed_powbatch_inv25519_p_2,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_3,0,
    precomputed_powbatch_inv25519_p_3,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_4,0,
    precomputed_powbatch_inv25519_p_4,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_5,0,
    precomputed_powbatch_inv25519_p_5,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_6,0,
    precomputed_powbatch_inv25519_p_6,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_7,0,
    precomputed_powbatch_inv25519_p_7,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_8,0,
    precomputed_powbatch_inv25519_p_8,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_9,0,
    precomputed_powbatch_inv25519_p_9,0,
    0,
  },
  {
    precomputed_powbatch_inv25519_q_10,32,
    precomputed_powbatch_inv25519_p_10,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_11,32,
    precomputed_powbatch_inv25519_p_11,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_12,32,
    precomputed_powbatch_inv25519_p_12,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_13,32,
    precomputed_powbatch_inv25519_p_13,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_14,32,
    precomputed_powbatch_inv25519_p_14,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_15,32,
    precomputed_powbatch_inv25519_p_15,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_16,32,
    precomputed_powbatch_inv25519_p_16,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_17,32,
    precomputed_powbatch_inv25519_p_17,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_18,32,
    precomputed_powbatch_inv25519_p_18,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_19,32,
    precomputed_powbatch_inv25519_p_19,32,
    1,
  },
  {
    precomputed_powbatch_inv25519_q_20,64,
    precomputed_powbatch_inv25519_p_20,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_21,64,
    precomputed_powbatch_inv25519_p_21,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_22,64,
    precomputed_powbatch_inv25519_p_22,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_23,64,
    precomputed_powbatch_inv25519_p_23,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_24,64,
    precomputed_powbatch_inv25519_p_24,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_25,64,
    precomputed_powbatch_inv25519_p_25,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_26,64,
    precomputed_powbatch_inv25519_p_26,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_27,64,
    precomputed_powbatch_inv25519_p_27,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_28,64,
    precomputed_powbatch_inv25519_p_28,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_29,64,
    precomputed_powbatch_inv25519_p_29,64,
    2,
  },
  {
    precomputed_powbatch_inv25519_q_30,96,
    precomputed_powbatch_inv25519_p_30,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_31,96,
    precomputed_powbatch_inv25519_p_31,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_32,96,
    precomputed_powbatch_inv25519_p_32,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_33,96,
    precomputed_powbatch_inv25519_p_33,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_34,96,
    precomputed_powbatch_inv25519_p_34,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_35,96,
    precomputed_powbatch_inv25519_p_35,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_36,96,
    precomputed_powbatch_inv25519_p_36,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_37,96,
    precomputed_powbatch_inv25519_p_37,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_38,96,
    precomputed_powbatch_inv25519_p_38,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_39,96,
    precomputed_powbatch_inv25519_p_39,96,
    3,
  },
  {
    precomputed_powbatch_inv25519_q_40,128,
    precomputed_powbatch_inv25519_p_40,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_41,128,
    precomputed_powbatch_inv25519_p_41,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_42,128,
    precomputed_powbatch_inv25519_p_42,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_43,128,
    precomputed_powbatch_inv25519_p_43,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_44,128,
    precomputed_powbatch_inv25519_p_44,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_45,128,
    precomputed_powbatch_inv25519_p_45,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_46,128,
    precomputed_powbatch_inv25519_p_46,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_47,128,
    precomputed_powbatch_inv25519_p_47,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_48,128,
    precomputed_powbatch_inv25519_p_48,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_49,128,
    precomputed_powbatch_inv25519_p_49,128,
    4,
  },
  {
    precomputed_powbatch_inv25519_q_50,160,
    precomputed_powbatch_inv25519_p_50,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_51,160,
    precomputed_powbatch_inv25519_p_51,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_52,160,
    precomputed_powbatch_inv25519_p_52,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_53,160,
    precomputed_powbatch_inv25519_p_53,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_54,160,
    precomputed_powbatch_inv25519_p_54,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_55,160,
    precomputed_powbatch_inv25519_p_55,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_56,160,
    precomputed_powbatch_inv25519_p_56,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_57,160,
    precomputed_powbatch_inv25519_p_57,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_58,160,
    precomputed_powbatch_inv25519_p_58,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_59,160,
    precomputed_powbatch_inv25519_p_59,160,
    5,
  },
  {
    precomputed_powbatch_inv25519_q_60,192,
    precomputed_powbatch_inv25519_p_60,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_61,192,
    precomputed_powbatch_inv25519_p_61,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_62,192,
    precomputed_powbatch_inv25519_p_62,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_63,192,
    precomputed_powbatch_inv25519_p_63,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_64,192,
    precomputed_powbatch_inv25519_p_64,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_65,192,
    precomputed_powbatch_inv25519_p_65,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_66,192,
    precomputed_powbatch_inv25519_p_66,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_67,192,
    precomputed_powbatch_inv25519_p_67,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_68,192,
    precomputed_powbatch_inv25519_p_68,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_69,192,
    precomputed_powbatch_inv25519_p_69,192,
    6,
  },
  {
    precomputed_powbatch_inv25519_q_70,224,
    precomputed_powbatch_inv25519_p_70,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_71,224,
    precomputed_powbatch_inv25519_p_71,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_72,224,
    precomputed_powbatch_inv25519_p_72,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_73,224,
    precomputed_powbatch_inv25519_p_73,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_74,224,
    precomputed_powbatch_inv25519_p_74,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_75,224,
    precomputed_powbatch_inv25519_p_75,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_76,224,
    precomputed_powbatch_inv25519_p_76,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_77,224,
    precomputed_powbatch_inv25519_p_77,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_78,224,
    precomputed_powbatch_inv25519_p_78,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_79,224,
    precomputed_powbatch_inv25519_p_79,224,
    7,
  },
  {
    precomputed_powbatch_inv25519_q_80,256,
    precomputed_powbatch_inv25519_p_80,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_81,256,
    precomputed_powbatch_inv25519_p_81,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_82,256,
    precomputed_powbatch_inv25519_p_82,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_83,256,
    precomputed_powbatch_inv25519_p_83,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_84,256,
    precomputed_powbatch_inv25519_p_84,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_85,256,
    precomputed_powbatch_inv25519_p_85,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_86,256,
    precomputed_powbatch_inv25519_p_86,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_87,256,
    precomputed_powbatch_inv25519_p_87,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_88,256,
    precomputed_powbatch_inv25519_p_88,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_89,256,
    precomputed_powbatch_inv25519_p_89,256,
    8,
  },
  {
    precomputed_powbatch_inv25519_q_90,288,
    precomputed_powbatch_inv25519_p_90,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_91,288,
    precomputed_powbatch_inv25519_p_91,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_92,288,
    precomputed_powbatch_inv25519_p_92,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_93,288,
    precomputed_powbatch_inv25519_p_93,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_94,288,
    precomputed_powbatch_inv25519_p_94,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_95,288,
    precomputed_powbatch_inv25519_p_95,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_96,288,
    precomputed_powbatch_inv25519_p_96,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_97,288,
    precomputed_powbatch_inv25519_p_97,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_98,288,
    precomputed_powbatch_inv25519_p_98,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_99,288,
    precomputed_powbatch_inv25519_p_99,288,
    9,
  },
  {
    precomputed_powbatch_inv25519_q_100,320,
    precomputed_powbatch_inv25519_p_100,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_101,320,
    precomputed_powbatch_inv25519_p_101,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_102,320,
    precomputed_powbatch_inv25519_p_102,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_103,320,
    precomputed_powbatch_inv25519_p_103,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_104,320,
    precomputed_powbatch_inv25519_p_104,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_105,320,
    precomputed_powbatch_inv25519_p_105,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_106,320,
    precomputed_powbatch_inv25519_p_106,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_107,320,
    precomputed_powbatch_inv25519_p_107,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_108,320,
    precomputed_powbatch_inv25519_p_108,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_109,320,
    precomputed_powbatch_inv25519_p_109,320,
    10,
  },
  {
    precomputed_powbatch_inv25519_q_110,352,
    precomputed_powbatch_inv25519_p_110,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_111,352,
    precomputed_powbatch_inv25519_p_111,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_112,352,
    precomputed_powbatch_inv25519_p_112,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_113,352,
    precomputed_powbatch_inv25519_p_113,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_114,352,
    precomputed_powbatch_inv25519_p_114,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_115,352,
    precomputed_powbatch_inv25519_p_115,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_116,352,
    precomputed_powbatch_inv25519_p_116,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_117,352,
    precomputed_powbatch_inv25519_p_117,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_118,352,
    precomputed_powbatch_inv25519_p_118,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_119,352,
    precomputed_powbatch_inv25519_p_119,352,
    11,
  },
  {
    precomputed_powbatch_inv25519_q_120,384,
    precomputed_powbatch_inv25519_p_120,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_121,384,
    precomputed_powbatch_inv25519_p_121,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_122,384,
    precomputed_powbatch_inv25519_p_122,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_123,384,
    precomputed_powbatch_inv25519_p_123,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_124,384,
    precomputed_powbatch_inv25519_p_124,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_125,384,
    precomputed_powbatch_inv25519_p_125,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_126,384,
    precomputed_powbatch_inv25519_p_126,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_127,384,
    precomputed_powbatch_inv25519_p_127,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_128,384,
    precomputed_powbatch_inv25519_p_128,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_129,384,
    precomputed_powbatch_inv25519_p_129,384,
    12,
  },
  {
    precomputed_powbatch_inv25519_q_130,416,
    precomputed_powbatch_inv25519_p_130,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_131,416,
    precomputed_powbatch_inv25519_p_131,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_132,416,
    precomputed_powbatch_inv25519_p_132,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_133,416,
    precomputed_powbatch_inv25519_p_133,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_134,416,
    precomputed_powbatch_inv25519_p_134,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_135,416,
    precomputed_powbatch_inv25519_p_135,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_136,416,
    precomputed_powbatch_inv25519_p_136,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_137,416,
    precomputed_powbatch_inv25519_p_137,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_138,416,
    precomputed_powbatch_inv25519_p_138,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_139,416,
    precomputed_powbatch_inv25519_p_139,416,
    13,
  },
  {
    precomputed_powbatch_inv25519_q_140,448,
    precomputed_powbatch_inv25519_p_140,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_141,448,
    precomputed_powbatch_inv25519_p_141,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_142,448,
    precomputed_powbatch_inv25519_p_142,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_143,448,
    precomputed_powbatch_inv25519_p_143,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_144,448,
    precomputed_powbatch_inv25519_p_144,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_145,448,
    precomputed_powbatch_inv25519_p_145,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_146,448,
    precomputed_powbatch_inv25519_p_146,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_147,448,
    precomputed_powbatch_inv25519_p_147,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_148,448,
    precomputed_powbatch_inv25519_p_148,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_149,448,
    precomputed_powbatch_inv25519_p_149,448,
    14,
  },
  {
    precomputed_powbatch_inv25519_q_150,480,
    precomputed_powbatch_inv25519_p_150,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_151,480,
    precomputed_powbatch_inv25519_p_151,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_152,480,
    precomputed_powbatch_inv25519_p_152,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_153,480,
    precomputed_powbatch_inv25519_p_153,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_154,480,
    precomputed_powbatch_inv25519_p_154,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_155,480,
    precomputed_powbatch_inv25519_p_155,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_156,480,
    precomputed_powbatch_inv25519_p_156,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_157,480,
    precomputed_powbatch_inv25519_p_157,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_158,480,
    precomputed_powbatch_inv25519_p_158,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_159,480,
    precomputed_powbatch_inv25519_p_159,480,
    15,
  },
  {
    precomputed_powbatch_inv25519_q_160,512,
    precomputed_powbatch_inv25519_p_160,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_161,512,
    precomputed_powbatch_inv25519_p_161,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_162,512,
    precomputed_powbatch_inv25519_p_162,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_163,512,
    precomputed_powbatch_inv25519_p_163,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_164,512,
    precomputed_powbatch_inv25519_p_164,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_165,512,
    precomputed_powbatch_inv25519_p_165,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_166,512,
    precomputed_powbatch_inv25519_p_166,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_167,512,
    precomputed_powbatch_inv25519_p_167,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_168,512,
    precomputed_powbatch_inv25519_p_168,512,
    16,
  },
  {
    precomputed_powbatch_inv25519_q_169,512,
    precomputed_powbatch_inv25519_p_169,512,
    16,
  },
} ;

static void test_powbatch_inv25519_impl(long long impl)
{
  unsigned char *q = test_powbatch_inv25519_q;
  unsigned char *p = test_powbatch_inv25519_p;
  unsigned char *q2 = test_powbatch_inv25519_q2;
  unsigned char *p2 = test_powbatch_inv25519_p2;
  long long qlen;
  long long plen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_powbatch_inv25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_powbatch = lib25519_dispatch_powbatch_inv25519(impl);
    printf("powbatch_inv25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_powbatch_inv25519_implementation(impl),lib25519_dispatch_powbatch_inv25519_compiler(impl));
  } else {
    crypto_powbatch = lib25519_powbatch_inv25519;
    printf("powbatch_inv25519 selected implementation %s compiler %s\n",lib25519_powbatch_inv25519_implementation(),lib25519_powbatch_inv25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;
    long long maxtest = checksumbig ? 128 : 16;
    long long mlen;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      mlen = myrandom() % (maxtest + 1);

      qlen = mlen * crypto_powbatch_BYTES;
      plen = mlen * crypto_powbatch_BYTES;
      output_prepare(q2,q,qlen);
      input_prepare(p2,p,plen);
      secret(p,plen);
      crypto_powbatch(q,p,mlen);
      public(p,plen);
      public(q,qlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_powbatch");
      input_compare(p2,p,plen,"crypto_powbatch");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      secret(p2,plen);
      crypto_powbatch(q2,p2,mlen);
      public(p2,plen);
      public(q2,qlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_powbatch is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      secret(p2,plen);
      crypto_powbatch(p2,p2,mlen);
      public(p2,qlen);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_powbatch does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(powbatch_inv25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_powbatch_inv25519_NUM;++precomp) {
    long long mlen = precomputed_powbatch_inv25519[precomp].batch;
    output_prepare(q2,q,precomputed_powbatch_inv25519[precomp].qsize);
    input_prepare(p2,p,precomputed_powbatch_inv25519[precomp].psize);
    memcpy(p,precomputed_powbatch_inv25519[precomp].p,precomputed_powbatch_inv25519[precomp].psize);
    memcpy(p2,precomputed_powbatch_inv25519[precomp].p,precomputed_powbatch_inv25519[precomp].psize);
    crypto_powbatch(q,p,mlen);
    if (memcmp(q,precomputed_powbatch_inv25519[precomp].q,precomputed_powbatch_inv25519[precomp].qsize)) {
      fail("failure: crypto_powbatch fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_powbatch_inv25519[precomp].qsize;++pos) printf("%02x",precomputed_powbatch_inv25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_powbatch_inv25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_powbatch_inv25519[precomp].qsize,"crypto_powbatch");
    input_compare(p2,p,precomputed_powbatch_inv25519[precomp].psize,"crypto_powbatch");
  }
}

void test_powbatch_inv25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"powbatch")) return;
  if (targetp && strcmp(targetp,"inv25519")) return;
  storage_powbatch_inv25519_q = callocplus(128*crypto_powbatch_BYTES);
  test_powbatch_inv25519_q = aligned(storage_powbatch_inv25519_q,128*crypto_powbatch_BYTES);
  if (128*crypto_powbatch_BYTES > maxalloc) maxalloc = 128*crypto_powbatch_BYTES;
  storage_powbatch_inv25519_p = callocplus(128*crypto_powbatch_BYTES);
  test_powbatch_inv25519_p = aligned(storage_powbatch_inv25519_p,128*crypto_powbatch_BYTES);
  if (128*crypto_powbatch_BYTES > maxalloc) maxalloc = 128*crypto_powbatch_BYTES;
  storage_powbatch_inv25519_q2 = callocplus(maxalloc);
  test_powbatch_inv25519_q2 = aligned(storage_powbatch_inv25519_q2,128*crypto_powbatch_BYTES);
  storage_powbatch_inv25519_p2 = callocplus(maxalloc);
  test_powbatch_inv25519_p2 = aligned(storage_powbatch_inv25519_p2,128*crypto_powbatch_BYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("powbatch_inv25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_powbatch_inv25519();++impl)
      forked(test_powbatch_inv25519_impl,impl);
    ++test_powbatch_inv25519_q;
    ++test_powbatch_inv25519_p;
    ++test_powbatch_inv25519_q2;
    ++test_powbatch_inv25519_p2;
  }
  free(storage_powbatch_inv25519_p2);
  free(storage_powbatch_inv25519_q2);
  free(storage_powbatch_inv25519_p);
  free(storage_powbatch_inv25519_q);
}
#undef crypto_powbatch_BYTES

