/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPageHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPageWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFirstPageNumberAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFootnoteMaxHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridBaseHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridBaseWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridDisplayAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridLinesAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridPrintAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridRubyBelowAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridRubyHeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridSnapToAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLayoutGridStandardModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumPrefixAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumSuffixAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePaperTrayNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintOrientationAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintPageOrderAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRegisterTruthRefStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleScaleToAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleScaleToPagesAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTableCenteringAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;

/**
 * DOM implementation of OpenDocument element  {@odf.element style:page-layout-properties}.
 *
 */
public class StylePageLayoutPropertiesElement extends OdfStylePropertiesBase {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.STYLE, "page-layout-properties");

	/**
	 * Create the instance of <code>StylePageLayoutPropertiesElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public StylePageLayoutPropertiesElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element style:page-layout-properties}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	public final static OdfStyleProperty BackgroundColor =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "background-color"));

	public final static OdfStyleProperty Border =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "border"));

	public final static OdfStyleProperty BorderBottom =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "border-bottom"));

	public final static OdfStyleProperty BorderLeft =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "border-left"));

	public final static OdfStyleProperty BorderRight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "border-right"));

	public final static OdfStyleProperty BorderTop =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "border-top"));

	public final static OdfStyleProperty Margin =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "margin"));

	public final static OdfStyleProperty MarginBottom =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "margin-bottom"));

	public final static OdfStyleProperty MarginLeft =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "margin-left"));

	public final static OdfStyleProperty MarginRight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "margin-right"));

	public final static OdfStyleProperty MarginTop =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "margin-top"));

	public final static OdfStyleProperty Padding =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "padding"));

	public final static OdfStyleProperty PaddingBottom =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "padding-bottom"));

	public final static OdfStyleProperty PaddingLeft =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "padding-left"));

	public final static OdfStyleProperty PaddingRight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "padding-right"));

	public final static OdfStyleProperty PaddingTop =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "padding-top"));

	public final static OdfStyleProperty PageHeight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "page-height"));

	public final static OdfStyleProperty PageWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.FO, "page-width"));

	public final static OdfStyleProperty BorderLineWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width"));

	public final static OdfStyleProperty BorderLineWidthBottom =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-bottom"));

	public final static OdfStyleProperty BorderLineWidthLeft =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-left"));

	public final static OdfStyleProperty BorderLineWidthRight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-right"));

	public final static OdfStyleProperty BorderLineWidthTop =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-top"));

	public final static OdfStyleProperty FirstPageNumber =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "first-page-number"));

	public final static OdfStyleProperty FootnoteMaxHeight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "footnote-max-height"));

	public final static OdfStyleProperty LayoutGridBaseHeight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-base-height"));

	public final static OdfStyleProperty LayoutGridBaseWidth =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-base-width"));

	public final static OdfStyleProperty LayoutGridColor =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-color"));

	public final static OdfStyleProperty LayoutGridDisplay =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-display"));

	public final static OdfStyleProperty LayoutGridLines =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-lines"));

	public final static OdfStyleProperty LayoutGridMode =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-mode"));

	public final static OdfStyleProperty LayoutGridPrint =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-print"));

	public final static OdfStyleProperty LayoutGridRubyBelow =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-ruby-below"));

	public final static OdfStyleProperty LayoutGridRubyHeight =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-ruby-height"));

	public final static OdfStyleProperty LayoutGridSnapTo =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-snap-to"));

	public final static OdfStyleProperty LayoutGridStandardMode =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "layout-grid-standard-mode"));

	public final static OdfStyleProperty NumFormat =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "num-format"));

	public final static OdfStyleProperty NumLetterSync =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "num-letter-sync"));

	public final static OdfStyleProperty NumPrefix =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "num-prefix"));

	public final static OdfStyleProperty NumSuffix =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "num-suffix"));

	public final static OdfStyleProperty PaperTrayName =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "paper-tray-name"));

	public final static OdfStyleProperty Print =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "print"));

	public final static OdfStyleProperty PrintOrientation =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "print-orientation"));

	public final static OdfStyleProperty PrintPageOrder =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "print-page-order"));

	public final static OdfStyleProperty RegisterTruthRefStyleName =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "register-truth-ref-style-name"));

	public final static OdfStyleProperty ScaleTo =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "scale-to"));

	public final static OdfStyleProperty ScaleToPages =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "scale-to-pages"));

	public final static OdfStyleProperty Shadow =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "shadow"));

	public final static OdfStyleProperty TableCentering =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "table-centering"));

	public final static OdfStyleProperty WritingMode =
		OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.newName(OdfDocumentNamespace.STYLE, "writing-mode"));

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See {@odf.attribute fo:background-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBackgroundColorAttribute() {
		FoBackgroundColorAttribute attr = (FoBackgroundColorAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "background-color");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See {@odf.attribute fo:background-color}
	 *
	 * @param foBackgroundColorValue   The type is <code>String</code>
	 */
	public void setFoBackgroundColorAttribute(String foBackgroundColorValue) {
		FoBackgroundColorAttribute attr = new FoBackgroundColorAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBackgroundColorValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderAttribute</code> , See {@odf.attribute fo:border}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderAttribute() {
		FoBorderAttribute attr = (FoBorderAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderAttribute</code> , See {@odf.attribute fo:border}
	 *
	 * @param foBorderValue   The type is <code>String</code>
	 */
	public void setFoBorderAttribute(String foBorderValue) {
		FoBorderAttribute attr = new FoBorderAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBorderValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See {@odf.attribute fo:border-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderBottomAttribute() {
		FoBorderBottomAttribute attr = (FoBorderBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-bottom");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See {@odf.attribute fo:border-bottom}
	 *
	 * @param foBorderBottomValue   The type is <code>String</code>
	 */
	public void setFoBorderBottomAttribute(String foBorderBottomValue) {
		FoBorderBottomAttribute attr = new FoBorderBottomAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBorderBottomValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See {@odf.attribute fo:border-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderLeftAttribute() {
		FoBorderLeftAttribute attr = (FoBorderLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-left");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See {@odf.attribute fo:border-left}
	 *
	 * @param foBorderLeftValue   The type is <code>String</code>
	 */
	public void setFoBorderLeftAttribute(String foBorderLeftValue) {
		FoBorderLeftAttribute attr = new FoBorderLeftAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBorderLeftValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See {@odf.attribute fo:border-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderRightAttribute() {
		FoBorderRightAttribute attr = (FoBorderRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-right");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See {@odf.attribute fo:border-right}
	 *
	 * @param foBorderRightValue   The type is <code>String</code>
	 */
	public void setFoBorderRightAttribute(String foBorderRightValue) {
		FoBorderRightAttribute attr = new FoBorderRightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBorderRightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See {@odf.attribute fo:border-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoBorderTopAttribute() {
		FoBorderTopAttribute attr = (FoBorderTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-top");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See {@odf.attribute fo:border-top}
	 *
	 * @param foBorderTopValue   The type is <code>String</code>
	 */
	public void setFoBorderTopAttribute(String foBorderTopValue) {
		FoBorderTopAttribute attr = new FoBorderTopAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foBorderTopValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginAttribute</code> , See {@odf.attribute fo:margin}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginAttribute() {
		FoMarginAttribute attr = (FoMarginAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginAttribute</code> , See {@odf.attribute fo:margin}
	 *
	 * @param foMarginValue   The type is <code>String</code>
	 */
	public void setFoMarginAttribute(String foMarginValue) {
		FoMarginAttribute attr = new FoMarginAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foMarginValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See {@odf.attribute fo:margin-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginBottomAttribute() {
		FoMarginBottomAttribute attr = (FoMarginBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-bottom");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginBottomAttribute</code> , See {@odf.attribute fo:margin-bottom}
	 *
	 * @param foMarginBottomValue   The type is <code>String</code>
	 */
	public void setFoMarginBottomAttribute(String foMarginBottomValue) {
		FoMarginBottomAttribute attr = new FoMarginBottomAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foMarginBottomValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See {@odf.attribute fo:margin-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginLeftAttribute() {
		FoMarginLeftAttribute attr = (FoMarginLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-left");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginLeftAttribute</code> , See {@odf.attribute fo:margin-left}
	 *
	 * @param foMarginLeftValue   The type is <code>String</code>
	 */
	public void setFoMarginLeftAttribute(String foMarginLeftValue) {
		FoMarginLeftAttribute attr = new FoMarginLeftAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foMarginLeftValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See {@odf.attribute fo:margin-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginRightAttribute() {
		FoMarginRightAttribute attr = (FoMarginRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-right");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginRightAttribute</code> , See {@odf.attribute fo:margin-right}
	 *
	 * @param foMarginRightValue   The type is <code>String</code>
	 */
	public void setFoMarginRightAttribute(String foMarginRightValue) {
		FoMarginRightAttribute attr = new FoMarginRightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foMarginRightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See {@odf.attribute fo:margin-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoMarginTopAttribute() {
		FoMarginTopAttribute attr = (FoMarginTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "margin-top");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoMarginTopAttribute</code> , See {@odf.attribute fo:margin-top}
	 *
	 * @param foMarginTopValue   The type is <code>String</code>
	 */
	public void setFoMarginTopAttribute(String foMarginTopValue) {
		FoMarginTopAttribute attr = new FoMarginTopAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foMarginTopValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingAttribute</code> , See {@odf.attribute fo:padding}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingAttribute() {
		FoPaddingAttribute attr = (FoPaddingAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingAttribute</code> , See {@odf.attribute fo:padding}
	 *
	 * @param foPaddingValue   The type is <code>String</code>
	 */
	public void setFoPaddingAttribute(String foPaddingValue) {
		FoPaddingAttribute attr = new FoPaddingAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPaddingValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See {@odf.attribute fo:padding-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingBottomAttribute() {
		FoPaddingBottomAttribute attr = (FoPaddingBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-bottom");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See {@odf.attribute fo:padding-bottom}
	 *
	 * @param foPaddingBottomValue   The type is <code>String</code>
	 */
	public void setFoPaddingBottomAttribute(String foPaddingBottomValue) {
		FoPaddingBottomAttribute attr = new FoPaddingBottomAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPaddingBottomValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See {@odf.attribute fo:padding-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingLeftAttribute() {
		FoPaddingLeftAttribute attr = (FoPaddingLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-left");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See {@odf.attribute fo:padding-left}
	 *
	 * @param foPaddingLeftValue   The type is <code>String</code>
	 */
	public void setFoPaddingLeftAttribute(String foPaddingLeftValue) {
		FoPaddingLeftAttribute attr = new FoPaddingLeftAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPaddingLeftValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See {@odf.attribute fo:padding-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingRightAttribute() {
		FoPaddingRightAttribute attr = (FoPaddingRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-right");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See {@odf.attribute fo:padding-right}
	 *
	 * @param foPaddingRightValue   The type is <code>String</code>
	 */
	public void setFoPaddingRightAttribute(String foPaddingRightValue) {
		FoPaddingRightAttribute attr = new FoPaddingRightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPaddingRightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See {@odf.attribute fo:padding-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPaddingTopAttribute() {
		FoPaddingTopAttribute attr = (FoPaddingTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-top");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See {@odf.attribute fo:padding-top}
	 *
	 * @param foPaddingTopValue   The type is <code>String</code>
	 */
	public void setFoPaddingTopAttribute(String foPaddingTopValue) {
		FoPaddingTopAttribute attr = new FoPaddingTopAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPaddingTopValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPageHeightAttribute</code> , See {@odf.attribute fo:page-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPageHeightAttribute() {
		FoPageHeightAttribute attr = (FoPageHeightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "page-height");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPageHeightAttribute</code> , See {@odf.attribute fo:page-height}
	 *
	 * @param foPageHeightValue   The type is <code>String</code>
	 */
	public void setFoPageHeightAttribute(String foPageHeightValue) {
		FoPageHeightAttribute attr = new FoPageHeightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPageHeightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>FoPageWidthAttribute</code> , See {@odf.attribute fo:page-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getFoPageWidthAttribute() {
		FoPageWidthAttribute attr = (FoPageWidthAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "page-width");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>FoPageWidthAttribute</code> , See {@odf.attribute fo:page-width}
	 *
	 * @param foPageWidthValue   The type is <code>String</code>
	 */
	public void setFoPageWidthAttribute(String foPageWidthValue) {
		FoPageWidthAttribute attr = new FoPageWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(foPageWidthValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> , See {@odf.attribute style:border-line-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthAttribute() {
		StyleBorderLineWidthAttribute attr = (StyleBorderLineWidthAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> , See {@odf.attribute style:border-line-width}
	 *
	 * @param styleBorderLineWidthValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthAttribute(String styleBorderLineWidthValue) {
		StyleBorderLineWidthAttribute attr = new StyleBorderLineWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleBorderLineWidthValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute style:border-line-width-bottom}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthBottomAttribute() {
		StyleBorderLineWidthBottomAttribute attr = (StyleBorderLineWidthBottomAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-bottom");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute style:border-line-width-bottom}
	 *
	 * @param styleBorderLineWidthBottomValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthBottomAttribute(String styleBorderLineWidthBottomValue) {
		StyleBorderLineWidthBottomAttribute attr = new StyleBorderLineWidthBottomAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleBorderLineWidthBottomValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthLeftAttribute() {
		StyleBorderLineWidthLeftAttribute attr = (StyleBorderLineWidthLeftAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-left");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
	 *
	 * @param styleBorderLineWidthLeftValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthLeftAttribute(String styleBorderLineWidthLeftValue) {
		StyleBorderLineWidthLeftAttribute attr = new StyleBorderLineWidthLeftAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleBorderLineWidthLeftValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthRightAttribute() {
		StyleBorderLineWidthRightAttribute attr = (StyleBorderLineWidthRightAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-right");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
	 *
	 * @param styleBorderLineWidthRightValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthRightAttribute(String styleBorderLineWidthRightValue) {
		StyleBorderLineWidthRightAttribute attr = new StyleBorderLineWidthRightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleBorderLineWidthRightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleBorderLineWidthTopAttribute() {
		StyleBorderLineWidthTopAttribute attr = (StyleBorderLineWidthTopAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-top");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
	 *
	 * @param styleBorderLineWidthTopValue   The type is <code>String</code>
	 */
	public void setStyleBorderLineWidthTopAttribute(String styleBorderLineWidthTopValue) {
		StyleBorderLineWidthTopAttribute attr = new StyleBorderLineWidthTopAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleBorderLineWidthTopValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleFirstPageNumberAttribute</code> , See {@odf.attribute style:first-page-number}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getStyleFirstPageNumberAttribute() {
		StyleFirstPageNumberAttribute attr = (StyleFirstPageNumberAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "first-page-number");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleFirstPageNumberAttribute</code> , See {@odf.attribute style:first-page-number}
	 *
	 * @param styleFirstPageNumberValue   The type is <code>Integer</code>
	 */
	public void setStyleFirstPageNumberAttribute(Integer styleFirstPageNumberValue) {
		StyleFirstPageNumberAttribute attr = new StyleFirstPageNumberAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(styleFirstPageNumberValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleFootnoteMaxHeightAttribute</code> , See {@odf.attribute style:footnote-max-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleFootnoteMaxHeightAttribute() {
		StyleFootnoteMaxHeightAttribute attr = (StyleFootnoteMaxHeightAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "footnote-max-height");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleFootnoteMaxHeightAttribute</code> , See {@odf.attribute style:footnote-max-height}
	 *
	 * @param styleFootnoteMaxHeightValue   The type is <code>String</code>
	 */
	public void setStyleFootnoteMaxHeightAttribute(String styleFootnoteMaxHeightValue) {
		StyleFootnoteMaxHeightAttribute attr = new StyleFootnoteMaxHeightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleFootnoteMaxHeightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridBaseHeightAttribute</code> , See {@odf.attribute style:layout-grid-base-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLayoutGridBaseHeightAttribute() {
		StyleLayoutGridBaseHeightAttribute attr = (StyleLayoutGridBaseHeightAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-base-height");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridBaseHeightAttribute</code> , See {@odf.attribute style:layout-grid-base-height}
	 *
	 * @param styleLayoutGridBaseHeightValue   The type is <code>String</code>
	 */
	public void setStyleLayoutGridBaseHeightAttribute(String styleLayoutGridBaseHeightValue) {
		StyleLayoutGridBaseHeightAttribute attr = new StyleLayoutGridBaseHeightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleLayoutGridBaseHeightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridBaseWidthAttribute</code> , See {@odf.attribute style:layout-grid-base-width}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLayoutGridBaseWidthAttribute() {
		StyleLayoutGridBaseWidthAttribute attr = (StyleLayoutGridBaseWidthAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-base-width");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridBaseWidthAttribute</code> , See {@odf.attribute style:layout-grid-base-width}
	 *
	 * @param styleLayoutGridBaseWidthValue   The type is <code>String</code>
	 */
	public void setStyleLayoutGridBaseWidthAttribute(String styleLayoutGridBaseWidthValue) {
		StyleLayoutGridBaseWidthAttribute attr = new StyleLayoutGridBaseWidthAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleLayoutGridBaseWidthValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridColorAttribute</code> , See {@odf.attribute style:layout-grid-color}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLayoutGridColorAttribute() {
		StyleLayoutGridColorAttribute attr = (StyleLayoutGridColorAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-color");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridColorAttribute</code> , See {@odf.attribute style:layout-grid-color}
	 *
	 * @param styleLayoutGridColorValue   The type is <code>String</code>
	 */
	public void setStyleLayoutGridColorAttribute(String styleLayoutGridColorValue) {
		StyleLayoutGridColorAttribute attr = new StyleLayoutGridColorAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleLayoutGridColorValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridDisplayAttribute</code> , See {@odf.attribute style:layout-grid-display}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleLayoutGridDisplayAttribute() {
		StyleLayoutGridDisplayAttribute attr = (StyleLayoutGridDisplayAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-display");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridDisplayAttribute</code> , See {@odf.attribute style:layout-grid-display}
	 *
	 * @param styleLayoutGridDisplayValue   The type is <code>Boolean</code>
	 */
	public void setStyleLayoutGridDisplayAttribute(Boolean styleLayoutGridDisplayValue) {
		StyleLayoutGridDisplayAttribute attr = new StyleLayoutGridDisplayAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleLayoutGridDisplayValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridLinesAttribute</code> , See {@odf.attribute style:layout-grid-lines}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getStyleLayoutGridLinesAttribute() {
		StyleLayoutGridLinesAttribute attr = (StyleLayoutGridLinesAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-lines");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridLinesAttribute</code> , See {@odf.attribute style:layout-grid-lines}
	 *
	 * @param styleLayoutGridLinesValue   The type is <code>Integer</code>
	 */
	public void setStyleLayoutGridLinesAttribute(Integer styleLayoutGridLinesValue) {
		StyleLayoutGridLinesAttribute attr = new StyleLayoutGridLinesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(styleLayoutGridLinesValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridModeAttribute</code> , See {@odf.attribute style:layout-grid-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLayoutGridModeAttribute() {
		StyleLayoutGridModeAttribute attr = (StyleLayoutGridModeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-mode");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridModeAttribute</code> , See {@odf.attribute style:layout-grid-mode}
	 *
	 * @param styleLayoutGridModeValue   The type is <code>String</code>
	 */
	public void setStyleLayoutGridModeAttribute(String styleLayoutGridModeValue) {
		StyleLayoutGridModeAttribute attr = new StyleLayoutGridModeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleLayoutGridModeValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridPrintAttribute</code> , See {@odf.attribute style:layout-grid-print}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleLayoutGridPrintAttribute() {
		StyleLayoutGridPrintAttribute attr = (StyleLayoutGridPrintAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-print");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridPrintAttribute</code> , See {@odf.attribute style:layout-grid-print}
	 *
	 * @param styleLayoutGridPrintValue   The type is <code>Boolean</code>
	 */
	public void setStyleLayoutGridPrintAttribute(Boolean styleLayoutGridPrintValue) {
		StyleLayoutGridPrintAttribute attr = new StyleLayoutGridPrintAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleLayoutGridPrintValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridRubyBelowAttribute</code> , See {@odf.attribute style:layout-grid-ruby-below}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleLayoutGridRubyBelowAttribute() {
		StyleLayoutGridRubyBelowAttribute attr = (StyleLayoutGridRubyBelowAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-ruby-below");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridRubyBelowAttribute</code> , See {@odf.attribute style:layout-grid-ruby-below}
	 *
	 * @param styleLayoutGridRubyBelowValue   The type is <code>Boolean</code>
	 */
	public void setStyleLayoutGridRubyBelowAttribute(Boolean styleLayoutGridRubyBelowValue) {
		StyleLayoutGridRubyBelowAttribute attr = new StyleLayoutGridRubyBelowAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleLayoutGridRubyBelowValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridRubyHeightAttribute</code> , See {@odf.attribute style:layout-grid-ruby-height}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleLayoutGridRubyHeightAttribute() {
		StyleLayoutGridRubyHeightAttribute attr = (StyleLayoutGridRubyHeightAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-ruby-height");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridRubyHeightAttribute</code> , See {@odf.attribute style:layout-grid-ruby-height}
	 *
	 * @param styleLayoutGridRubyHeightValue   The type is <code>String</code>
	 */
	public void setStyleLayoutGridRubyHeightAttribute(String styleLayoutGridRubyHeightValue) {
		StyleLayoutGridRubyHeightAttribute attr = new StyleLayoutGridRubyHeightAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleLayoutGridRubyHeightValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridSnapToAttribute</code> , See {@odf.attribute style:layout-grid-snap-to}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleLayoutGridSnapToAttribute() {
		StyleLayoutGridSnapToAttribute attr = (StyleLayoutGridSnapToAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-snap-to");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridSnapToAttribute</code> , See {@odf.attribute style:layout-grid-snap-to}
	 *
	 * @param styleLayoutGridSnapToValue   The type is <code>Boolean</code>
	 */
	public void setStyleLayoutGridSnapToAttribute(Boolean styleLayoutGridSnapToValue) {
		StyleLayoutGridSnapToAttribute attr = new StyleLayoutGridSnapToAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleLayoutGridSnapToValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleLayoutGridStandardModeAttribute</code> , See {@odf.attribute style:layout-grid-standard-mode}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleLayoutGridStandardModeAttribute() {
		StyleLayoutGridStandardModeAttribute attr = (StyleLayoutGridStandardModeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "layout-grid-standard-mode");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleLayoutGridStandardModeAttribute</code> , See {@odf.attribute style:layout-grid-standard-mode}
	 *
	 * @param styleLayoutGridStandardModeValue   The type is <code>Boolean</code>
	 */
	public void setStyleLayoutGridStandardModeAttribute(Boolean styleLayoutGridStandardModeValue) {
		StyleLayoutGridStandardModeAttribute attr = new StyleLayoutGridStandardModeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleLayoutGridStandardModeValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumFormatAttribute</code> , See {@odf.attribute style:num-format}
	 *
	 * Attribute is mandatory.
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumFormatAttribute() {
		StyleNumFormatAttribute attr = (StyleNumFormatAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumFormatAttribute</code> , See {@odf.attribute style:num-format}
	 *
	 * @param styleNumFormatValue   The type is <code>String</code>
	 */
	public void setStyleNumFormatAttribute(String styleNumFormatValue) {
		StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumFormatValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumLetterSyncAttribute</code> , See {@odf.attribute style:num-letter-sync}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getStyleNumLetterSyncAttribute() {
		StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumLetterSyncAttribute</code> , See {@odf.attribute style:num-letter-sync}
	 *
	 * @param styleNumLetterSyncValue   The type is <code>Boolean</code>
	 */
	public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
		StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(styleNumLetterSyncValue.booleanValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumPrefixAttribute</code> , See {@odf.attribute style:num-prefix}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumPrefixAttribute() {
		StyleNumPrefixAttribute attr = (StyleNumPrefixAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-prefix");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumPrefixAttribute</code> , See {@odf.attribute style:num-prefix}
	 *
	 * @param styleNumPrefixValue   The type is <code>String</code>
	 */
	public void setStyleNumPrefixAttribute(String styleNumPrefixValue) {
		StyleNumPrefixAttribute attr = new StyleNumPrefixAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumPrefixValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleNumSuffixAttribute</code> , See {@odf.attribute style:num-suffix}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleNumSuffixAttribute() {
		StyleNumSuffixAttribute attr = (StyleNumSuffixAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "num-suffix");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleNumSuffixAttribute</code> , See {@odf.attribute style:num-suffix}
	 *
	 * @param styleNumSuffixValue   The type is <code>String</code>
	 */
	public void setStyleNumSuffixAttribute(String styleNumSuffixValue) {
		StyleNumSuffixAttribute attr = new StyleNumSuffixAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleNumSuffixValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePaperTrayNameAttribute</code> , See {@odf.attribute style:paper-tray-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStylePaperTrayNameAttribute() {
		StylePaperTrayNameAttribute attr = (StylePaperTrayNameAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "paper-tray-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePaperTrayNameAttribute</code> , See {@odf.attribute style:paper-tray-name}
	 *
	 * @param stylePaperTrayNameValue   The type is <code>String</code>
	 */
	public void setStylePaperTrayNameAttribute(String stylePaperTrayNameValue) {
		StylePaperTrayNameAttribute attr = new StylePaperTrayNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(stylePaperTrayNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePrintAttribute</code> , See {@odf.attribute style:print}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStylePrintAttribute() {
		StylePrintAttribute attr = (StylePrintAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "print");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePrintAttribute</code> , See {@odf.attribute style:print}
	 *
	 * @param stylePrintValue   The type is <code>String</code>
	 */
	public void setStylePrintAttribute(String stylePrintValue) {
		StylePrintAttribute attr = new StylePrintAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(stylePrintValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePrintOrientationAttribute</code> , See {@odf.attribute style:print-orientation}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStylePrintOrientationAttribute() {
		StylePrintOrientationAttribute attr = (StylePrintOrientationAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "print-orientation");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePrintOrientationAttribute</code> , See {@odf.attribute style:print-orientation}
	 *
	 * @param stylePrintOrientationValue   The type is <code>String</code>
	 */
	public void setStylePrintOrientationAttribute(String stylePrintOrientationValue) {
		StylePrintOrientationAttribute attr = new StylePrintOrientationAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(stylePrintOrientationValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StylePrintPageOrderAttribute</code> , See {@odf.attribute style:print-page-order}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStylePrintPageOrderAttribute() {
		StylePrintPageOrderAttribute attr = (StylePrintPageOrderAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "print-page-order");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StylePrintPageOrderAttribute</code> , See {@odf.attribute style:print-page-order}
	 *
	 * @param stylePrintPageOrderValue   The type is <code>String</code>
	 */
	public void setStylePrintPageOrderAttribute(String stylePrintPageOrderValue) {
		StylePrintPageOrderAttribute attr = new StylePrintPageOrderAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(stylePrintPageOrderValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleRegisterTruthRefStyleNameAttribute</code> , See {@odf.attribute style:register-truth-ref-style-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleRegisterTruthRefStyleNameAttribute() {
		StyleRegisterTruthRefStyleNameAttribute attr = (StyleRegisterTruthRefStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "register-truth-ref-style-name");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleRegisterTruthRefStyleNameAttribute</code> , See {@odf.attribute style:register-truth-ref-style-name}
	 *
	 * @param styleRegisterTruthRefStyleNameValue   The type is <code>String</code>
	 */
	public void setStyleRegisterTruthRefStyleNameAttribute(String styleRegisterTruthRefStyleNameValue) {
		StyleRegisterTruthRefStyleNameAttribute attr = new StyleRegisterTruthRefStyleNameAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleRegisterTruthRefStyleNameValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleScaleToAttribute</code> , See {@odf.attribute style:scale-to}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleScaleToAttribute() {
		StyleScaleToAttribute attr = (StyleScaleToAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "scale-to");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleScaleToAttribute</code> , See {@odf.attribute style:scale-to}
	 *
	 * @param styleScaleToValue   The type is <code>String</code>
	 */
	public void setStyleScaleToAttribute(String styleScaleToValue) {
		StyleScaleToAttribute attr = new StyleScaleToAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleScaleToValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleScaleToPagesAttribute</code> , See {@odf.attribute style:scale-to-pages}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getStyleScaleToPagesAttribute() {
		StyleScaleToPagesAttribute attr = (StyleScaleToPagesAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "scale-to-pages");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleScaleToPagesAttribute</code> , See {@odf.attribute style:scale-to-pages}
	 *
	 * @param styleScaleToPagesValue   The type is <code>Integer</code>
	 */
	public void setStyleScaleToPagesAttribute(Integer styleScaleToPagesValue) {
		StyleScaleToPagesAttribute attr = new StyleScaleToPagesAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(styleScaleToPagesValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleShadowAttribute</code> , See {@odf.attribute style:shadow}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleShadowAttribute() {
		StyleShadowAttribute attr = (StyleShadowAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "shadow");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleShadowAttribute</code> , See {@odf.attribute style:shadow}
	 *
	 * @param styleShadowValue   The type is <code>String</code>
	 */
	public void setStyleShadowAttribute(String styleShadowValue) {
		StyleShadowAttribute attr = new StyleShadowAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleShadowValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleTableCenteringAttribute</code> , See {@odf.attribute style:table-centering}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleTableCenteringAttribute() {
		StyleTableCenteringAttribute attr = (StyleTableCenteringAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "table-centering");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleTableCenteringAttribute</code> , See {@odf.attribute style:table-centering}
	 *
	 * @param styleTableCenteringValue   The type is <code>String</code>
	 */
	public void setStyleTableCenteringAttribute(String styleTableCenteringValue) {
		StyleTableCenteringAttribute attr = new StyleTableCenteringAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleTableCenteringValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See {@odf.attribute style:writing-mode}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getStyleWritingModeAttribute() {
		StyleWritingModeAttribute attr = (StyleWritingModeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "writing-mode");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See {@odf.attribute style:writing-mode}
	 *
	 * @param styleWritingModeValue   The type is <code>String</code>
	 */
	public void setStyleWritingModeAttribute(String styleWritingModeValue) {
		StyleWritingModeAttribute attr = new StyleWritingModeAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(styleWritingModeValue);
	}

	/**
	 * Create child element {@odf.element style:background-image}.
	 *
	 * Child element is new in Odf 1.2
	 *
	 * @return the element {@odf.element style:background-image}
	 */
	public StyleBackgroundImageElement newStyleBackgroundImageElement() {
		StyleBackgroundImageElement styleBackgroundImage = ((OdfFileDom) this.ownerDocument).newOdfElement(StyleBackgroundImageElement.class);
		this.appendChild(styleBackgroundImage);
		return styleBackgroundImage;
	}

	/**
	 * Create child element {@odf.element style:columns}.
	 *
	 * @param foColumnCountValue  the <code>Integer</code> value of <code>FoColumnCountAttribute</code>, see {@odf.attribute  fo:column-count} at specification
	 * Child element is new in Odf 1.2
	 *
	 * @return the element {@odf.element style:columns}
	 */
	 public StyleColumnsElement newStyleColumnsElement(int foColumnCountValue) {
		StyleColumnsElement styleColumns = ((OdfFileDom) this.ownerDocument).newOdfElement(StyleColumnsElement.class);
		styleColumns.setFoColumnCountAttribute(foColumnCountValue);
		this.appendChild(styleColumns);
		return styleColumns;
	}

	/**
	 * Create child element {@odf.element style:footnote-sep}.
	 *
	 * Child element is new in Odf 1.2
	 *
	 * @return the element {@odf.element style:footnote-sep}
	 */
	public StyleFootnoteSepElement newStyleFootnoteSepElement() {
		StyleFootnoteSepElement styleFootnoteSep = ((OdfFileDom) this.ownerDocument).newOdfElement(StyleFootnoteSepElement.class);
		this.appendChild(styleFootnoteSep);
		return styleFootnoteSep;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
