// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLAL_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLAL_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmlal_2D[] = {
  0x000000007c080000, 0x000000007e020001,
  0x000000007d040000, 0x0000007efd060001,
  0x0000007dfd0c0000, 0x0000000000000001,
  0x0000000000000000, 0x000000000000fe01,
  0x000000000000fc00, 0x000000000001fc01,
  0x000000000001f800, 0x00000000001fc001,
  0x00000000001f8000, 0x00000000007c0601,
  0x00000000007b0c00, 0x00000000007d0401,
  0x00000000007c0800, 0x00000000007e0201,
  0x00000000007d0400, 0x000000007efd0601,
  0x000000007dfd0c00, 0x000000007efe0401,
  0x000000007dfe0800, 0x000000007eff0201,
  0x000000007dff0400, 0x000032cccccc9a01,
  0x0000326666663400, 0x000054aaaaaa5601,
  0x000053ffffffac00, 0x00007efffffd0601,
  0x00007dfffffd0c00, 0x00007efffffe0401,
  0x00007dfffffe0800, 0x00007effffff0201,
  0x00007dffffff0400, 0xffff810000000001,
  0xffff820000000000, 0xffff81000000fe01,
  0xffff82000000fc00, 0xffffab555554ac01,
  0xffffabffffff5800, 0xffffcd3333326801,
  0xffffcd999998d000, 0xffffffff81000001,
  0xffffffff82000000, 0xffffffff8100fe01,
  0xffffffff8200fc00, 0xffffffff8101fc01,
  0xffffffff8201f800, 0xffffffff8102fa01,
  0xffffffff8202f400, 0xffffffffff810001,
  0xffffffffff820000, 0xffffffffff81fe01,
  0xffffffffff82fc00, 0xffffffffff82fc01,
  0xffffffffff83f800, 0xffffffffff83fa01,
  0xffffffffff84f400, 0xffffffffffe04001,
  0xffffffffffe08000, 0xfffffffffffd0601,
  0xfffffffffffd0600, 0xfffffffffe000c01,
  0xfffffffffffe0400, 0xffffffffff000601,
  0xffffffffffff0200, 0x0000000000000001,
  0x0000000000000000, 0x0000000000fffa01,
  0x000000000000fe00, 0x0000000001fff401,
  0x000000000001fc00, 0x000000001fff4001,
  0x00000000001fc000, 0x000000007cfd1201,
  0x00000000007c0600, 0x000000007dfd0c01,
  0x00000000007d0400, 0x000000007efd0601,
  0x00000000007e0200, 0x0000007ffa001201,
  0x000000007efd0600, 0x0000007ffb000c01,
  0x000000007efe0400, 0x0000007ffc000601,
  0x000000007eff0200, 0x003331ffffccce01,
  0x000032cccccc9a00, 0x0055535555000201,
  0x000054aaaaaa5600, 0x007ffcfffd001201,
  0x00007efffffd0600, 0x007ffcfffe000c01,
  0x00007efffffe0400, 0x007ffcffff000601,
  0x00007effffff0200, 0xff80030000000001,
  0xffff810000000000, 0xff80030000fffa01,
  0xffff81000000fe00, 0xffaaacaaaa000401,
  0xffffab555554ac00, 0xffcccdffff333801,
  0xffffcd3333326800, 0xffffff8003000001,
  0xffffffff81000000, 0xffffff8003fffa01,
  0xffffffff8100fe00, 0xffffff8004fff401,
  0xffffffff8101fc00, 0xffffff8005ffee01,
  0xffffffff8102fa00, 0xffffffff80030001,
  0xffffffffff810000, 0xffffffff8102fa01,
  0xffffffffff81fe00, 0xffffffff8202f401,
  0xffffffffff82fc00, 0xffffffff8302ee01,
  0xffffffffff83fa00, 0xffffffffe000c001,
  0xffffffffffe04000, 0xfffffffffd001201,
  0xfffffffffd001200, 0x0000000000000001,
  0xfffffffffe000c00, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x0000000001fff400, 0x0000000000000001,
  0x000000001fff4000, 0x0000000000000001,
  0x000000007cfd1200, 0x0000000000000001,
  0x000000007dfd0c00, 0x0000000000000001,
  0x000000007efd0600, 0x0000000000000001,
  0x0000007ffa001200, 0x0000000000000001,
  0x0000007ffb000c00, 0x0000000000000001,
  0x0000007ffc000600, 0x0000000000000001,
  0x003331ffffccce00, 0x0000000000000001,
  0x0055535555000200, 0x0000000000000001,
  0x007ffcfffd001200, 0x0000000000000001,
  0x007ffcfffe000c00, 0x0000000000000001,
  0x007ffcffff000600, 0x0000000000000001,
  0xff80030000000000, 0x0000000000000001,
  0xff80030000fffa00, 0x0000000000000001,
  0xffaaacaaaa000400, 0x0000000000000001,
  0xffcccdffff333800, 0x0000000000000001,
  0xffffff8003000000, 0x0000000000000001,
  0xffffff8003fffa00, 0x0000000000000001,
  0xffffff8004fff400, 0x0000000000000001,
  0xffffff8005ffee00, 0x0000000000000001,
  0xffffffff80030000, 0x0000000000000001,
  0xffffffff8102fa00, 0x0000000000000001,
  0xffffffff8202f400, 0x0000000000000001,
  0xffffffff8302ee00, 0x0000000000000001,
  0xffffffffe000c000, 0x0000000000000001,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000041,
  0x0000000000000000, 0x00000000000000fb,
  0x0000000000000000, 0x00000000000000fd,
  0x0000000000000000, 0x00000000000000ff,
  0x0000000000000000, 0x000000000000fffb,
  0x0000000000000000, 0x000000000000fffd,
  0x0000000000000000, 0x000000000000ffff,
  0x0000000000000000, 0x0000000066666667,
  0x0000000000000000, 0x00000000aaaaaaab,
  0x0000000000000000, 0x00000000fffffffb,
  0x0000000000000000, 0x00000000fffffffd,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000000000000, 0xffffffff00000001,
  0x0000000000000000, 0xffffffff00000003,
  0x0000000000000000, 0xffffffff55555555,
  0x0000000000000000, 0xffffffff99999999,
  0x0000000000000000, 0xffffffffffff0001,
  0x0000000000000000, 0xffffffffffff0003,
  0x0000000000000000, 0xffffffffffff0005,
  0x0000000000000000, 0xffffffffffff0007,
  0x0000000000000000, 0xffffffffffffff01,
  0x0000000000000000, 0xffffffffffffff03,
  0x0000000000000000, 0xffffffffffffff05,
  0x0000000000000000, 0xffffffffffffff07,
  0x0000000000000000, 0xffffffffffffffc1,
  0x0000000000000000, 0xfffffffffffffffb,
  0xfffffffffffffffa, 0xfffffffffffffff9,
  0xfffffffffffffffc, 0xfffffffffffffffd,
  0xfffffffffffffffe, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000002, 0x0000000000000009,
  0x0000000000000004, 0x0000000000000081,
  0x0000000000000040, 0x00000000000001f5,
  0x00000000000000fa, 0x00000000000001f9,
  0x00000000000000fc, 0x00000000000001fd,
  0x00000000000000fe, 0x000000000001fff5,
  0x000000000000fffa, 0x000000000001fff9,
  0x000000000000fffc, 0x000000000001fffd,
  0x000000000000fffe, 0x00000000cccccccd,
  0x0000000066666666, 0x0000000155555555,
  0x00000000aaaaaaaa, 0x00000001fffffff5,
  0x00000000fffffffa, 0x00000001fffffff9,
  0x00000000fffffffc, 0x00000001fffffffd,
  0x00000000fffffffe, 0xfffffffe00000001,
  0xffffffff00000000, 0xfffffffe00000005,
  0xffffffff00000002, 0xfffffffeaaaaaaa9,
  0xffffffff55555554, 0xffffffff33333331,
  0xffffffff99999998, 0xfffffffffffe0001,
  0xffffffffffff0000, 0xfffffffffffe0005,
  0xffffffffffff0002, 0xfffffffffffe0009,
  0xffffffffffff0004, 0xfffffffffffe000d,
  0xffffffffffff0006, 0xfffffffffffffe01,
  0xffffffffffffff00, 0xfffffffffffffe05,
  0xffffffffffffff02, 0xfffffffffffffe09,
  0xffffffffffffff04, 0xfffffffffffffe0d,
  0xffffffffffffff06, 0xffffffffffffff81,
  0xffffffffffffffc0, 0xfffffffffffffff5,
  0xfffffffffffffff4, 0xffffffffffffff81,
  0xfffffffffffffff8, 0xffffffffffffffc1,
  0xfffffffffffffffc, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000041,
  0x0000000000000004, 0x0000000000000081,
  0x0000000000000008, 0x0000000000000801,
  0x0000000000000080, 0x0000000000001f41,
  0x00000000000001f4, 0x0000000000001f81,
  0x00000000000001f8, 0x0000000000001fc1,
  0x00000000000001fc, 0x00000000001fff41,
  0x000000000001fff4, 0x00000000001fff81,
  0x000000000001fff8, 0x00000000001fffc1,
  0x000000000001fffc, 0x0000000cccccccc1,
  0x00000000cccccccc, 0x0000001555555541,
  0x0000000155555554, 0x0000001fffffff41,
  0x00000001fffffff4, 0x0000001fffffff81,
  0x00000001fffffff8, 0x0000001fffffffc1,
  0x00000001fffffffc, 0xffffffe000000001,
  0xfffffffe00000000, 0xffffffe000000041,
  0xfffffffe00000004, 0xffffffeaaaaaaa81,
  0xfffffffeaaaaaaa8, 0xfffffff333333301,
  0xffffffff33333330, 0xffffffffffe00001,
  0xfffffffffffe0000, 0xffffffffffe00041,
  0xfffffffffffe0004, 0xffffffffffe00081,
  0xfffffffffffe0008, 0xffffffffffe000c1,
  0xfffffffffffe000c, 0xffffffffffffe001,
  0xfffffffffffffe00, 0xffffffffffffe041,
  0xfffffffffffffe04, 0xffffffffffffe081,
  0xfffffffffffffe08, 0xffffffffffffe0c1,
  0xfffffffffffffe0c, 0xfffffffffffff801,
  0xffffffffffffff80, 0xffffffffffffff41,
  0xffffffffffffff40, 0xfffffffffffffe0d,
  0xffffffffffffff80, 0xffffffffffffff07,
  0xffffffffffffffc0, 0x0000000000000001,
  0x0000000000000000, 0x00000000000000fb,
  0x0000000000000040, 0x00000000000001f5,
  0x0000000000000080, 0x0000000000001f41,
  0x0000000000000800, 0x0000000000007a13,
  0x0000000000001f40, 0x0000000000007b0d,
  0x0000000000001f80, 0x0000000000007c07,
  0x0000000000001fc0, 0x00000000007cfd13,
  0x00000000001fff40, 0x00000000007cfe0d,
  0x00000000001fff80, 0x00000000007cff07,
  0x00000000001fffc0, 0x00000031ffffffcf,
  0x0000000cccccccc0, 0x0000005355555503,
  0x0000001555555540, 0x0000007cfffffd13,
  0x0000001fffffff40, 0x0000007cfffffe0d,
  0x0000001fffffff80, 0x0000007cffffff07,
  0x0000001fffffffc0, 0xffffff8300000001,
  0xffffffe000000000, 0xffffff83000000fb,
  0xffffffe000000040, 0xffffffacaaaaaa05,
  0xffffffeaaaaaaa80, 0xffffffcdffffff39,
  0xfffffff333333300, 0xffffffffff830001,
  0xffffffffffe00000, 0xffffffffff8300fb,
  0xffffffffffe00040, 0xffffffffff8301f5,
  0xffffffffffe00080, 0xffffffffff8302ef,
  0xffffffffffe000c0, 0xffffffffffff8301,
  0xffffffffffffe000, 0xffffffffffff83fb,
  0xffffffffffffe040, 0xffffffffffff84f5,
  0xffffffffffffe080, 0xffffffffffff85ef,
  0xffffffffffffe0c0, 0xffffffffffffe0c1,
  0xfffffffffffff800, 0xfffffffffffffd13,
  0xfffffffffffffd12, 0xfffffffffffffe09,
  0xfffffffffffffe0c, 0xffffffffffffff05,
  0xffffffffffffff06, 0x0000000000000001,
  0x0000000000000000, 0x00000000000000fd,
  0x00000000000000fa, 0x00000000000001f9,
  0x00000000000001f4, 0x0000000000001f81,
  0x0000000000001f40, 0x0000000000007b0d,
  0x0000000000007a12, 0x0000000000007c09,
  0x0000000000007b0c, 0x0000000000007d05,
  0x0000000000007c06, 0x00000000007dfd0d,
  0x00000000007cfd12, 0x00000000007dfe09,
  0x00000000007cfe0c, 0x00000000007dff05,
  0x00000000007cff06, 0x0000003266666635,
  0x00000031ffffffce, 0x00000053ffffffad,
  0x0000005355555502, 0x0000007dfffffd0d,
  0x0000007cfffffd12, 0x0000007dfffffe09,
  0x0000007cfffffe0c, 0x0000007dffffff05,
  0x0000007cffffff06, 0xffffff8200000001,
  0xffffff8300000000, 0xffffff82000000fd,
  0xffffff83000000fa, 0xffffffabffffff59,
  0xffffffacaaaaaa04, 0xffffffcd999998d1,
  0xffffffcdffffff38, 0xffffffffff820001,
  0xffffffffff830000, 0xffffffffff8200fd,
  0xffffffffff8300fa, 0xffffffffff8201f9,
  0xffffffffff8301f4, 0xffffffffff8202f5,
  0xffffffffff8302ee, 0xffffffffffff8201,
  0xffffffffffff8300, 0xffffffffffff82fd,
  0xffffffffffff83fa, 0xffffffffffff83f9,
  0xffffffffffff84f4, 0xffffffffffff84f5,
  0xffffffffffff85ee, 0xffffffffffffe081,
  0xffffffffffffe0c0, 0xfffffffffffffd0d,
  0xfffffffffffffd0c, 0xfffffffffffffe05,
  0xfffffffffffffe08, 0xffffffffffffff03,
  0xffffffffffffff04, 0x0000000000000001,
  0x0000000000000000, 0x00000000000000ff,
  0x00000000000000fc, 0x00000000000001fd,
  0x00000000000001f8, 0x0000000000001fc1,
  0x0000000000001f80, 0x0000000000007c07,
  0x0000000000007b0c, 0x0000000000007d05,
  0x0000000000007c08, 0x0000000000007e03,
  0x0000000000007d04, 0x00000000007efd07,
  0x00000000007dfd0c, 0x00000000007efe05,
  0x00000000007dfe08, 0x00000000007eff03,
  0x00000000007dff04, 0x00000032cccccc9b,
  0x0000003266666634, 0x00000054aaaaaa57,
  0x00000053ffffffac, 0x0000007efffffd07,
  0x0000007dfffffd0c, 0x0000007efffffe05,
  0x0000007dfffffe08, 0x0000007effffff03,
  0x0000007dffffff04, 0xffffff8100000001,
  0xffffff8200000000, 0xffffff81000000ff,
  0xffffff82000000fc, 0xffffffab555554ad,
  0xffffffabffffff58, 0xffffffcd33333269,
  0xffffffcd999998d0, 0xffffffffff810001,
  0xffffffffff820000, 0xffffffffff8100ff,
  0xffffffffff8200fc, 0xffffffffff8101fd,
  0xffffffffff8201f8, 0xffffffffff8102fb,
  0xffffffffff8202f4, 0xffffffffffff8101,
  0xffffffffffff8200, 0xffffffffffff81ff,
  0xffffffffffff82fc, 0xffffffffffff82fd,
  0xffffffffffff83f8, 0xffffffffffff83fb,
  0xffffffffffff84f4, 0xffffffffffffe041,
  0xffffffffffffe080, 0xfffffffffffffd07,
  0xfffffffffffffd06, 0xfffffffffffe000d,
  0xfffffffffffffe04, 0xffffffffffff0007,
  0xffffffffffffff02, 0x0000000000000001,
  0x0000000000000000, 0x000000000000fffb,
  0x00000000000000fe, 0x000000000001fff5,
  0x00000000000001fc, 0x00000000001fff41,
  0x0000000000001fc0, 0x00000000007cfd13,
  0x0000000000007c06, 0x00000000007dfd0d,
  0x0000000000007d04, 0x00000000007efd07,
  0x0000000000007e02, 0x000000007ffa0013,
  0x00000000007efd06, 0x000000007ffb000d,
  0x00000000007efe04, 0x000000007ffc0007,
  0x00000000007eff02, 0x00003331ffffcccf,
  0x00000032cccccc9a, 0x0000555355550003,
  0x00000054aaaaaa56, 0x00007ffcfffd0013,
  0x0000007efffffd06, 0x00007ffcfffe000d,
  0x0000007efffffe04, 0x00007ffcffff0007,
  0x0000007effffff02, 0xffff800300000001,
  0xffffff8100000000, 0xffff80030000fffb,
  0xffffff81000000fe, 0xffffaaacaaaa0005,
  0xffffffab555554ac, 0xffffcccdffff3339,
  0xffffffcd33333268, 0xffffffff80030001,
  0xffffffffff810000, 0xffffffff8003fffb,
  0xffffffffff8100fe, 0xffffffff8004fff5,
  0xffffffffff8101fc, 0xffffffff8005ffef,
  0xffffffffff8102fa, 0xffffffffff800301,
  0xffffffffffff8100, 0xffffffffff8102fb,
  0xffffffffffff81fe, 0xffffffffff8202f5,
  0xffffffffffff82fc, 0xffffffffff8302ef,
  0xffffffffffff83fa, 0xffffffffffe000c1,
  0xffffffffffffe040, 0xfffffffffffd0013,
  0xfffffffffffd0012, 0xfffffffffffe0009,
  0xfffffffffffe000c, 0xffffffffffff0005,
  0xffffffffffff0006, 0x0000000000000001,
  0x0000000000000000, 0x000000000000fffd,
  0x000000000000fffa, 0x000000000001fff9,
  0x000000000001fff4, 0x00000000001fff81,
  0x00000000001fff40, 0x00000000007cfe0d,
  0x00000000007cfd12, 0x00000000007dfe09,
  0x00000000007dfd0c, 0x00000000007efe05,
  0x00000000007efd06, 0x000000007ffb000d,
  0x000000007ffa0012, 0x000000007ffc0009,
  0x000000007ffb000c, 0x000000007ffd0005,
  0x000000007ffc0006, 0x0000333266663335,
  0x00003331ffffccce, 0x00005553ffffaaad,
  0x0000555355550002, 0x00007ffdfffd000d,
  0x00007ffcfffd0012, 0x00007ffdfffe0009,
  0x00007ffcfffe000c, 0x00007ffdffff0005,
  0x00007ffcffff0006, 0xffff800200000001,
  0xffff800300000000, 0xffff80020000fffd,
  0xffff80030000fffa, 0xffffaaabffff5559,
  0xffffaaacaaaa0004, 0xffffcccd9998ccd1,
  0xffffcccdffff3338, 0xffffffff80020001,
  0xffffffff80030000, 0xffffffff8002fffd,
  0xffffffff8003fffa, 0xffffffff8003fff9,
  0xffffffff8004fff4, 0xffffffff8004fff5,
  0xffffffff8005ffee, 0xffffffffff800201,
  0xffffffffff800300, 0xffffffffff8101fd,
  0xffffffffff8102fa, 0xffffffffff8201f9,
  0xffffffffff8202f4, 0xffffffffff8301f5,
  0xffffffffff8302ee, 0xffffffffffe00081,
  0xffffffffffe000c0, 0xfffffffffffd000d,
  0xfffffffffffd000c, 0xfffffffffffe0005,
  0xfffffffffffe0008, 0xffffffffffff0003,
  0xffffffffffff0004, 0x0000000000000001,
  0x0000000000000000, 0x000000000000ffff,
  0x000000000000fffc, 0x000000000001fffd,
  0x000000000001fff8, 0x00000000001fffc1,
  0x00000000001fff80, 0x00000000007cff07,
  0x00000000007cfe0c, 0x00000000007dff05,
  0x00000000007dfe08, 0x00000000007eff03,
  0x00000000007efe04, 0x000000007ffc0007,
  0x000000007ffb000c, 0x000000007ffd0005,
  0x000000007ffc0008, 0x000000007ffe0003,
  0x000000007ffd0004, 0x00003332cccc999b,
  0x0000333266663334, 0x00005554aaaa5557,
  0x00005553ffffaaac, 0x00007ffefffd0007,
  0x00007ffdfffd000c, 0x00007ffefffe0005,
  0x00007ffdfffe0008, 0x00007ffeffff0003,
  0x00007ffdffff0004, 0xffff800100000001,
  0xffff800200000000, 0xffff80010000ffff,
  0xffff80020000fffc, 0xffffaaab5554aaad,
  0xffffaaabffff5558, 0xffffcccd33326669,
  0xffffcccd9998ccd0, 0xffffffff80010001,
  0xffffffff80020000, 0xffffffff8001ffff,
  0xffffffff8002fffc, 0xffffffff8002fffd,
  0xffffffff8003fff8, 0xffffffff8003fffb,
  0xffffffff8004fff4, 0xffffffffff800101,
  0xffffffffff800200, 0xffffffffff8100ff,
  0xffffffffff8101fc, 0xffffffffff8200fd,
  0xffffffffff8201f8, 0xffffffffff8300fb,
  0xffffffffff8301f4, 0xffffffffffe00041,
  0xffffffffffe00080, 0xfffffffffffd0007,
  0xfffffffffffd0006, 0xffffffff33333335,
  0xfffffffffffe0004, 0xffffffff9999999b,
  0xffffffffffff0002, 0x0000000000000001,
  0x0000000000000000, 0x0000000066666667,
  0x000000000000fffe, 0x00000000cccccccd,
  0x000000000001fffc, 0x0000000cccccccc1,
  0x00000000001fffc0, 0x00000031ffffffcf,
  0x00000000007cff06, 0x0000003266666635,
  0x00000000007dff04, 0x00000032cccccc9b,
  0x00000000007eff02, 0x00003331ffffcccf,
  0x000000007ffc0006, 0x0000333266663335,
  0x000000007ffd0004, 0x00003332cccc999b,
  0x000000007ffe0002, 0x147ae147851eb853,
  0x00003332cccc999a, 0x22222221dddddddf,
  0x00005554aaaa5556, 0x33333331cccccccf,
  0x00007ffefffd0006, 0x3333333233333335,
  0x00007ffefffe0004, 0x333333329999999b,
  0x00007ffeffff0002, 0xcccccccd00000001,
  0xffff800100000000, 0xcccccccd66666667,
  0xffff80010000fffe, 0xddddddddbbbbbbbd,
  0xffffaaab5554aaac, 0xeb851eb8147ae149,
  0xffffcccd33326668, 0xffffcccccccd0001,
  0xffffffff80010000, 0xffffcccd33336667,
  0xffffffff8001fffe, 0xffffcccd9999cccd,
  0xffffffff8002fffc, 0xffffccce00003333,
  0xffffffff8003fffa, 0xffffffcccccccd01,
  0xffffffffff800100, 0xffffffcd33333367,
  0xffffffffff8100fe, 0xffffffcd999999cd,
  0xffffffffff8200fc, 0xffffffce00000033,
  0xffffffffff8300fa, 0xfffffff333333341,
  0xffffffffffe00040, 0xfffffffecccccccf,
  0xfffffffeccccccce, 0xfffffffeaaaaaaad,
  0xffffffff33333334, 0xffffffff55555557,
  0xffffffff9999999a, 0x0000000000000001,
  0x0000000000000000, 0x00000000aaaaaaab,
  0x0000000066666666, 0x0000000155555555,
  0x00000000cccccccc, 0x0000001555555541,
  0x0000000cccccccc0, 0x0000005355555503,
  0x00000031ffffffce, 0x00000053ffffffad,
  0x0000003266666634, 0x00000054aaaaaa57,
  0x00000032cccccc9a, 0x0000555355550003,
  0x00003331ffffccce, 0x00005553ffffaaad,
  0x0000333266663334, 0x00005554aaaa5557,
  0x00003332cccc999a, 0x22222221dddddddf,
  0x147ae147851eb852, 0x38e38e3871c71c73,
  0x22222221ddddddde, 0x5555555300000003,
  0x33333331ccccccce, 0x55555553aaaaaaad,
  0x3333333233333334, 0x5555555455555557,
  0x333333329999999a, 0xaaaaaaab00000001,
  0xcccccccd00000000, 0xaaaaaaabaaaaaaab,
  0xcccccccd66666666, 0xc71c71c6e38e38e5,
  0xddddddddbbbbbbbc, 0xdddddddd77777779,
  0xeb851eb8147ae148, 0xffffaaaaaaab0001,
  0xffffcccccccd0000, 0xffffaaab5555aaab,
  0xffffcccd33336666, 0xffffaaac00005555,
  0xffffcccd9999cccc, 0xffffaaacaaaaffff,
  0xffffccce00003332, 0xffffffaaaaaaab01,
  0xffffffcccccccd00, 0xffffffab555555ab,
  0xffffffcd33333366, 0xffffffac00000055,
  0xffffffcd999999cc, 0xffffffacaaaaaaff,
  0xffffffce00000032, 0xffffffeaaaaaaac1,
  0xfffffff333333340, 0xfffffffe00000003,
  0xfffffffe00000002, 0xfffffffe0000000d,
  0xfffffffeaaaaaaac, 0xffffffff00000007,
  0xffffffff55555556, 0x0000000000000001,
  0x0000000000000000, 0x00000000fffffffb,
  0x00000000aaaaaaaa, 0x00000001fffffff5,
  0x0000000155555554, 0x0000001fffffff41,
  0x0000001555555540, 0x0000007cfffffd13,
  0x0000005355555502, 0x0000007dfffffd0d,
  0x00000053ffffffac, 0x0000007efffffd07,
  0x00000054aaaaaa56, 0x00007ffcfffd0013,
  0x0000555355550002, 0x00007ffdfffd000d,
  0x00005553ffffaaac, 0x00007ffefffd0007,
  0x00005554aaaa5556, 0x33333331cccccccf,
  0x22222221ddddddde, 0x5555555300000003,
  0x38e38e3871c71c72, 0x7ffffffa00000013,
  0x5555555300000002, 0x7ffffffb0000000d,
  0x55555553aaaaaaac, 0x7ffffffc00000007,
  0x5555555455555556, 0x8000000300000001,
  0xaaaaaaab00000000, 0x80000003fffffffb,
  0xaaaaaaabaaaaaaaa, 0xaaaaaaac00000005,
  0xc71c71c6e38e38e4, 0xcccccccd33333339,
  0xdddddddd77777778, 0xffff800000030001,
  0xffffaaaaaaab0000, 0xffff80010002fffb,
  0xffffaaab5555aaaa, 0xffff80020002fff5,
  0xffffaaac00005554, 0xffff80030002ffef,
  0xffffaaacaaaafffe, 0xffffff8000000301,
  0xffffffaaaaaaab00, 0xffffff81000002fb,
  0xffffffab555555aa, 0xffffff82000002f5,
  0xffffffac00000054, 0xffffff83000002ef,
  0xffffffacaaaaaafe, 0xffffffe0000000c1,
  0xffffffeaaaaaaac0, 0xfffffffd00000013,
  0xfffffffd00000012, 0xfffffffe00000009,
  0xfffffffe0000000c, 0xffffffff00000005,
  0xffffffff00000006, 0x0000000000000001,
  0x0000000000000000, 0x00000000fffffffd,
  0x00000000fffffffa, 0x00000001fffffff9,
  0x00000001fffffff4, 0x0000001fffffff81,
  0x0000001fffffff40, 0x0000007cfffffe0d,
  0x0000007cfffffd12, 0x0000007dfffffe09,
  0x0000007dfffffd0c, 0x0000007efffffe05,
  0x0000007efffffd06, 0x00007ffcfffe000d,
  0x00007ffcfffd0012, 0x00007ffdfffe0009,
  0x00007ffdfffd000c, 0x00007ffefffe0005,
  0x00007ffefffd0006, 0x3333333233333335,
  0x33333331ccccccce, 0x55555553aaaaaaad,
  0x5555555300000002, 0x7ffffffb0000000d,
  0x7ffffffa00000012, 0x7ffffffc00000009,
  0x7ffffffb0000000c, 0x7ffffffd00000005,
  0x7ffffffc00000006, 0x8000000200000001,
  0x8000000300000000, 0x80000002fffffffd,
  0x80000003fffffffa, 0xaaaaaaab55555559,
  0xaaaaaaac00000004, 0xccccccccccccccd1,
  0xcccccccd33333338, 0xffff800000020001,
  0xffff800000030000, 0xffff80010001fffd,
  0xffff80010002fffa, 0xffff80020001fff9,
  0xffff80020002fff4, 0xffff80030001fff5,
  0xffff80030002ffee, 0xffffff8000000201,
  0xffffff8000000300, 0xffffff81000001fd,
  0xffffff81000002fa, 0xffffff82000001f9,
  0xffffff82000002f4, 0xffffff83000001f5,
  0xffffff83000002ee, 0xffffffe000000081,
  0xffffffe0000000c0, 0xfffffffd0000000d,
  0xfffffffd0000000c, 0xfffffffe00000005,
  0xfffffffe00000008, 0xffffffff00000003,
  0xffffffff00000004, 0x0000000000000001,
  0x0000000000000000, 0x00000000ffffffff,
  0x00000000fffffffc, 0x00000001fffffffd,
  0x00000001fffffff8, 0x0000001fffffffc1,
  0x0000001fffffff80, 0x0000007cffffff07,
  0x0000007cfffffe0c, 0x0000007dffffff05,
  0x0000007dfffffe08, 0x0000007effffff03,
  0x0000007efffffe04, 0x00007ffcffff0007,
  0x00007ffcfffe000c, 0x00007ffdffff0005,
  0x00007ffdfffe0008, 0x00007ffeffff0003,
  0x00007ffefffe0004, 0x333333329999999b,
  0x3333333233333334, 0x5555555455555557,
  0x55555553aaaaaaac, 0x7ffffffc00000007,
  0x7ffffffb0000000c, 0x7ffffffd00000005,
  0x7ffffffc00000008, 0x7ffffffe00000003,
  0x7ffffffd00000004, 0x8000000100000001,
  0x8000000200000000, 0x80000001ffffffff,
  0x80000002fffffffc, 0xaaaaaaaaaaaaaaad,
  0xaaaaaaab55555558, 0xcccccccc66666669,
  0xccccccccccccccd0, 0xffff800000010001,
  0xffff800000020000, 0xffff80010000ffff,
  0xffff80010001fffc, 0xffff80020000fffd,
  0xffff80020001fff8, 0xffff80030000fffb,
  0xffff80030001fff4, 0xffffff8000000101,
  0xffffff8000000200, 0xffffff81000000ff,
  0xffffff81000001fc, 0xffffff82000000fd,
  0xffffff82000001f8, 0xffffff83000000fb,
  0xffffff83000001f4, 0xffffffe000000041,
  0xffffffe000000080, 0xfffffffd00000007,
  0xfffffffd00000006, 0x0000000200000001,
  0xfffffffe00000004, 0x0000000100000001,
  0xffffffff00000002, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000001,
  0x00000000fffffffe, 0xfffffffe00000001,
  0x00000001fffffffc, 0xffffffe000000001,
  0x0000001fffffffc0, 0xffffff8300000001,
  0x0000007cffffff06, 0xffffff8200000001,
  0x0000007dffffff04, 0xffffff8100000001,
  0x0000007effffff02, 0xffff800300000001,
  0x00007ffcffff0006, 0xffff800200000001,
  0x00007ffdffff0004, 0xffff800100000001,
  0x00007ffeffff0002, 0xcccccccd00000001,
  0x333333329999999a, 0xaaaaaaab00000001,
  0x5555555455555556, 0x8000000300000001,
  0x7ffffffc00000006, 0x8000000200000001,
  0x7ffffffd00000004, 0x8000000100000001,
  0x7ffffffe00000002, 0x7fffffffffffffff,
  0x8000000100000000, 0x7fffffff00000001,
  0x80000001fffffffe, 0x5555555600000001,
  0xaaaaaaaaaaaaaaac, 0x3333333400000001,
  0xcccccccc66666668, 0x0000800000000001,
  0xffff800000010000, 0x00007fff00000001,
  0xffff80010000fffe, 0x00007ffe00000001,
  0xffff80020000fffc, 0x00007ffd00000001,
  0xffff80030000fffa, 0x0000008000000001,
  0xffffff8000000100, 0x0000007f00000001,
  0xffffff81000000fe, 0x0000007e00000001,
  0xffffff82000000fc, 0x0000007d00000001,
  0xffffff83000000fa, 0x0000002000000001,
  0xffffffe000000040, 0x0000000300000001,
  0x0000000300000000, 0x00000001fffffffd,
  0x0000000200000000, 0x00000000ffffffff,
  0x0000000100000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000003,
  0xffffffff00000000, 0xfffffffe00000005,
  0xfffffffe00000000, 0xffffffe000000041,
  0xffffffe000000000, 0xffffff83000000fb,
  0xffffff8300000000, 0xffffff82000000fd,
  0xffffff8200000000, 0xffffff81000000ff,
  0xffffff8100000000, 0xffff80030000fffb,
  0xffff800300000000, 0xffff80020000fffd,
  0xffff800200000000, 0xffff80010000ffff,
  0xffff800100000000, 0xcccccccd66666667,
  0xcccccccd00000000, 0xaaaaaaabaaaaaaab,
  0xaaaaaaab00000000, 0x80000003fffffffb,
  0x8000000300000000, 0x80000002fffffffd,
  0x8000000200000000, 0x80000001ffffffff,
  0x8000000100000000, 0x7fffffff00000001,
  0x7fffffffffffffff, 0x7ffffffe00000003,
  0x7fffffff00000000, 0x5555555555555555,
  0x5555555600000000, 0x3333333399999999,
  0x3333333400000000, 0x00007fffffff0001,
  0x0000800000000000, 0x00007ffeffff0003,
  0x00007fff00000000, 0x00007ffdffff0005,
  0x00007ffe00000000, 0x00007ffcffff0007,
  0x00007ffd00000000, 0x0000007fffffff01,
  0x0000008000000000, 0x0000007effffff03,
  0x0000007f00000000, 0x0000007dffffff05,
  0x0000007e00000000, 0x0000007cffffff07,
  0x0000007d00000000, 0x0000001fffffffc1,
  0x0000002000000000, 0x00000002fffffffb,
  0x00000002fffffffa, 0x0000000155555559,
  0x00000001fffffffc, 0x00000000aaaaaaad,
  0x00000000fffffffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffff55555555,
  0xffffffff00000002, 0xfffffffeaaaaaaa9,
  0xfffffffe00000004, 0xffffffeaaaaaaa81,
  0xffffffe000000040, 0xffffffacaaaaaa05,
  0xffffff83000000fa, 0xffffffabffffff59,
  0xffffff82000000fc, 0xffffffab555554ad,
  0xffffff81000000fe, 0xffffaaacaaaa0005,
  0xffff80030000fffa, 0xffffaaabffff5559,
  0xffff80020000fffc, 0xffffaaab5554aaad,
  0xffff80010000fffe, 0xddddddddbbbbbbbd,
  0xcccccccd66666666, 0xc71c71c6e38e38e5,
  0xaaaaaaabaaaaaaaa, 0xaaaaaaac00000005,
  0x80000003fffffffa, 0xaaaaaaab55555559,
  0x80000002fffffffc, 0xaaaaaaaaaaaaaaad,
  0x80000001fffffffe, 0x5555555600000001,
  0x7fffffff00000000, 0x5555555555555555,
  0x7ffffffe00000002, 0x38e38e39c71c71c9,
  0x5555555555555554, 0x22222222eeeeeef1,
  0x3333333399999998, 0x0000555555560001,
  0x00007fffffff0000, 0x00005554aaab5555,
  0x00007ffeffff0002, 0x000055540000aaa9,
  0x00007ffdffff0004, 0x000055535555fffd,
  0x00007ffcffff0006, 0x0000005555555601,
  0x0000007fffffff00, 0x00000054aaaaab55,
  0x0000007effffff02, 0x00000054000000a9,
  0x0000007dffffff04, 0x00000053555555fd,
  0x0000007cffffff06, 0x0000001555555581,
  0x0000001fffffffc0, 0x0000000200000005,
  0x0000000200000004, 0x00000000ccccccd1,
  0x0000000155555558, 0x0000000066666669,
  0x00000000aaaaaaac, 0x0000000000000001,
  0x0000000000000000, 0xffffffff99999999,
  0xffffffff55555554, 0xffffffff33333331,
  0xfffffffeaaaaaaa8, 0xfffffff333333301,
  0xffffffeaaaaaaa80, 0xffffffcdffffff39,
  0xffffffacaaaaaa04, 0xffffffcd999998d1,
  0xffffffabffffff58, 0xffffffcd33333269,
  0xffffffab555554ac, 0xffffcccdffff3339,
  0xffffaaacaaaa0004, 0xffffcccd9998ccd1,
  0xffffaaabffff5558, 0xffffcccd33326669,
  0xffffaaab5554aaac, 0xeb851eb8147ae149,
  0xddddddddbbbbbbbc, 0xdddddddd77777779,
  0xc71c71c6e38e38e4, 0xcccccccd33333339,
  0xaaaaaaac00000004, 0xccccccccccccccd1,
  0xaaaaaaab55555558, 0xcccccccc66666669,
  0xaaaaaaaaaaaaaaac, 0x3333333400000001,
  0x5555555600000000, 0x3333333399999999,
  0x5555555555555554, 0x22222222eeeeeef1,
  0x38e38e39c71c71c8, 0x147ae14851eb8521,
  0x22222222eeeeeef0, 0x0000333333340001,
  0x0000555555560000, 0x00003332cccd9999,
  0x00005554aaab5554, 0x0000333266673331,
  0x000055540000aaa8, 0x000033320000ccc9,
  0x000055535555fffc, 0x0000003333333401,
  0x0000005555555600, 0x00000032cccccd99,
  0x00000054aaaaab54, 0x0000003266666731,
  0x00000054000000a8, 0x00000032000000c9,
  0x00000053555555fc, 0x0000000ccccccd01,
  0x0000001555555580, 0x0000000133333339,
  0x0000000133333338, 0x0000000000020001,
  0x00000000ccccccd0, 0x0000000000010001,
  0x0000000066666668, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0001,
  0xffffffff99999998, 0xfffffffffffe0001,
  0xffffffff33333330, 0xffffffffffe00001,
  0xfffffff333333300, 0xffffffffff830001,
  0xffffffcdffffff38, 0xffffffffff820001,
  0xffffffcd999998d0, 0xffffffffff810001,
  0xffffffcd33333268, 0xffffffff80030001,
  0xffffcccdffff3338, 0xffffffff80020001,
  0xffffcccd9998ccd0, 0xffffffff80010001,
  0xffffcccd33326668, 0xffffcccccccd0001,
  0xeb851eb8147ae148, 0xffffaaaaaaab0001,
  0xdddddddd77777778, 0xffff800000030001,
  0xcccccccd33333338, 0xffff800000020001,
  0xccccccccccccccd0, 0xffff800000010001,
  0xcccccccc66666668, 0x0000800000000001,
  0x3333333400000000, 0x00007fffffff0001,
  0x3333333399999998, 0x0000555555560001,
  0x22222222eeeeeef0, 0x0000333333340001,
  0x147ae14851eb8520, 0x0000000080000001,
  0x0000333333340000, 0x000000007fff0001,
  0x00003332cccd9998, 0x000000007ffe0001,
  0x0000333266673330, 0x000000007ffd0001,
  0x000033320000ccc8, 0x0000000000800001,
  0x0000003333333400, 0x00000000007f0001,
  0x00000032cccccd98, 0x00000000007e0001,
  0x0000003266666730, 0x00000000007d0001,
  0x00000032000000c8, 0x0000000000200001,
  0x0000000ccccccd00, 0x0000000000030001,
  0x0000000000030000, 0x000000000001fffd,
  0x0000000000020000, 0x000000000000ffff,
  0x0000000000010000, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0003,
  0xffffffffffff0000, 0xfffffffffffe0005,
  0xfffffffffffe0000, 0xffffffffffe00041,
  0xffffffffffe00000, 0xffffffffff8300fb,
  0xffffffffff830000, 0xffffffffff8200fd,
  0xffffffffff820000, 0xffffffffff8100ff,
  0xffffffffff810000, 0xffffffff8003fffb,
  0xffffffff80030000, 0xffffffff8002fffd,
  0xffffffff80020000, 0xffffffff8001ffff,
  0xffffffff80010000, 0xffffcccd33336667,
  0xffffcccccccd0000, 0xffffaaab5555aaab,
  0xffffaaaaaaab0000, 0xffff80010002fffb,
  0xffff800000030000, 0xffff80010001fffd,
  0xffff800000020000, 0xffff80010000ffff,
  0xffff800000010000, 0x00007fff00000001,
  0x0000800000000000, 0x00007ffeffff0003,
  0x00007fffffff0000, 0x00005554aaab5555,
  0x0000555555560000, 0x00003332cccd9999,
  0x0000333333340000, 0x000000007fff0001,
  0x0000000080000000, 0x000000007ffe0003,
  0x000000007fff0000, 0x000000007ffd0005,
  0x000000007ffe0000, 0x000000007ffc0007,
  0x000000007ffd0000, 0x00000000007fff01,
  0x0000000000800000, 0x00000000007eff03,
  0x00000000007f0000, 0x00000000007dff05,
  0x00000000007e0000, 0x00000000007cff07,
  0x00000000007d0000, 0x00000000001fffc1,
  0x0000000000200000, 0x000000000002fffb,
  0x000000000002fffa, 0x000000000001fff9,
  0x000000000001fffc, 0x000000000000fffd,
  0x000000000000fffe, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0005,
  0xffffffffffff0002, 0xfffffffffffe0009,
  0xfffffffffffe0004, 0xffffffffffe00081,
  0xffffffffffe00040, 0xffffffffff8301f5,
  0xffffffffff8300fa, 0xffffffffff8201f9,
  0xffffffffff8200fc, 0xffffffffff8101fd,
  0xffffffffff8100fe, 0xffffffff8004fff5,
  0xffffffff8003fffa, 0xffffffff8003fff9,
  0xffffffff8002fffc, 0xffffffff8002fffd,
  0xffffffff8001fffe, 0xffffcccd9999cccd,
  0xffffcccd33336666, 0xffffaaac00005555,
  0xffffaaab5555aaaa, 0xffff80020002fff5,
  0xffff80010002fffa, 0xffff80020001fff9,
  0xffff80010001fffc, 0xffff80020000fffd,
  0xffff80010000fffe, 0x00007ffe00000001,
  0x00007fff00000000, 0x00007ffdffff0005,
  0x00007ffeffff0002, 0x000055540000aaa9,
  0x00005554aaab5554, 0x0000333266673331,
  0x00003332cccd9998, 0x000000007ffe0001,
  0x000000007fff0000, 0x000000007ffd0005,
  0x000000007ffe0002, 0x000000007ffc0009,
  0x000000007ffd0004, 0x000000007ffb000d,
  0x000000007ffc0006, 0x00000000007ffe01,
  0x00000000007fff00, 0x00000000007efe05,
  0x00000000007eff02, 0x00000000007dfe09,
  0x00000000007dff04, 0x00000000007cfe0d,
  0x00000000007cff06, 0x00000000001fff81,
  0x00000000001fffc0, 0x000000000002fff5,
  0x000000000002fff4, 0x000000000001fff5,
  0x000000000001fff8, 0x000000000000fffb,
  0x000000000000fffc, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffff0007,
  0xffffffffffff0004, 0xfffffffffffe000d,
  0xfffffffffffe0008, 0xffffffffffe000c1,
  0xffffffffffe00080, 0xffffffffff8302ef,
  0xffffffffff8301f4, 0xffffffffff8202f5,
  0xffffffffff8201f8, 0xffffffffff8102fb,
  0xffffffffff8101fc, 0xffffffff8005ffef,
  0xffffffff8004fff4, 0xffffffff8004fff5,
  0xffffffff8003fff8, 0xffffffff8003fffb,
  0xffffffff8002fffc, 0xffffccce00003333,
  0xffffcccd9999cccc, 0xffffaaacaaaaffff,
  0xffffaaac00005554, 0xffff80030002ffef,
  0xffff80020002fff4, 0xffff80030001fff5,
  0xffff80020001fff8, 0xffff80030000fffb,
  0xffff80020000fffc, 0x00007ffd00000001,
  0x00007ffe00000000, 0x00007ffcffff0007,
  0x00007ffdffff0004, 0x000055535555fffd,
  0x000055540000aaa8, 0x000033320000ccc9,
  0x0000333266673330, 0x000000007ffd0001,
  0x000000007ffe0000, 0x000000007ffc0007,
  0x000000007ffd0004, 0x000000007ffb000d,
  0x000000007ffc0008, 0x000000007ffa0013,
  0x000000007ffb000c, 0x00000000007ffd01,
  0x00000000007ffe00, 0x00000000007efd07,
  0x00000000007efe04, 0x00000000007dfd0d,
  0x00000000007dfe08, 0x00000000007cfd13,
  0x00000000007cfe0c, 0x00000000001fff41,
  0x00000000001fff80, 0x000000000002ffef,
  0x000000000002ffee, 0x0000000000000201,
  0x000000000001fff4, 0x0000000000000101,
  0x000000000000fffa, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff01,
  0xffffffffffff0006, 0xfffffffffffffe01,
  0xfffffffffffe000c, 0xffffffffffffe001,
  0xffffffffffe000c0, 0xffffffffffff8301,
  0xffffffffff8302ee, 0xffffffffffff8201,
  0xffffffffff8202f4, 0xffffffffffff8101,
  0xffffffffff8102fa, 0xffffffffff800301,
  0xffffffff8005ffee, 0xffffffffff800201,
  0xffffffff8004fff4, 0xffffffffff800101,
  0xffffffff8003fffa, 0xffffffcccccccd01,
  0xffffccce00003332, 0xffffffaaaaaaab01,
  0xffffaaacaaaafffe, 0xffffff8000000301,
  0xffff80030002ffee, 0xffffff8000000201,
  0xffff80030001fff4, 0xffffff8000000101,
  0xffff80030000fffa, 0x0000008000000001,
  0x00007ffd00000000, 0x0000007fffffff01,
  0x00007ffcffff0006, 0x0000005555555601,
  0x000055535555fffc, 0x0000003333333401,
  0x000033320000ccc8, 0x0000000000800001,
  0x000000007ffd0000, 0x00000000007fff01,
  0x000000007ffc0006, 0x00000000007ffe01,
  0x000000007ffb000c, 0x00000000007ffd01,
  0x000000007ffa0012, 0x0000000000008001,
  0x00000000007ffd00, 0x0000000000007f01,
  0x00000000007efd06, 0x0000000000007e01,
  0x00000000007dfd0c, 0x0000000000007d01,
  0x00000000007cfd12, 0x0000000000002001,
  0x00000000001fff40, 0x0000000000000301,
  0x0000000000000300, 0x00000000000001fd,
  0x0000000000000200, 0x00000000000000ff,
  0x0000000000000100, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff03,
  0xffffffffffffff00, 0xfffffffffffffe05,
  0xfffffffffffffe00, 0xffffffffffffe041,
  0xffffffffffffe000, 0xffffffffffff83fb,
  0xffffffffffff8300, 0xffffffffffff82fd,
  0xffffffffffff8200, 0xffffffffffff81ff,
  0xffffffffffff8100, 0xffffffffff8102fb,
  0xffffffffff800300, 0xffffffffff8101fd,
  0xffffffffff800200, 0xffffffffff8100ff,
  0xffffffffff800100, 0xffffffcd33333367,
  0xffffffcccccccd00, 0xffffffab555555ab,
  0xffffffaaaaaaab00, 0xffffff81000002fb,
  0xffffff8000000300, 0xffffff81000001fd,
  0xffffff8000000200, 0xffffff81000000ff,
  0xffffff8000000100, 0x0000007f00000001,
  0x0000008000000000, 0x0000007effffff03,
  0x0000007fffffff00, 0x00000054aaaaab55,
  0x0000005555555600, 0x00000032cccccd99,
  0x0000003333333400, 0x00000000007f0001,
  0x0000000000800000, 0x00000000007eff03,
  0x00000000007fff00, 0x00000000007efe05,
  0x00000000007ffe00, 0x00000000007efd07,
  0x00000000007ffd00, 0x0000000000007f01,
  0x0000000000008000, 0x0000000000007e03,
  0x0000000000007f00, 0x0000000000007d05,
  0x0000000000007e00, 0x0000000000007c07,
  0x0000000000007d00, 0x0000000000001fc1,
  0x0000000000002000, 0x00000000000002fb,
  0x00000000000002fa, 0x00000000000001f9,
  0x00000000000001fc, 0x00000000000000fd,
  0x00000000000000fe, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff05,
  0xffffffffffffff02, 0xfffffffffffffe09,
  0xfffffffffffffe04, 0xffffffffffffe081,
  0xffffffffffffe040, 0xffffffffffff84f5,
  0xffffffffffff83fa, 0xffffffffffff83f9,
  0xffffffffffff82fc, 0xffffffffffff82fd,
  0xffffffffffff81fe, 0xffffffffff8202f5,
  0xffffffffff8102fa, 0xffffffffff8201f9,
  0xffffffffff8101fc, 0xffffffffff8200fd,
  0xffffffffff8100fe, 0xffffffcd999999cd,
  0xffffffcd33333366, 0xffffffac00000055,
  0xffffffab555555aa, 0xffffff82000002f5,
  0xffffff81000002fa, 0xffffff82000001f9,
  0xffffff81000001fc, 0xffffff82000000fd,
  0xffffff81000000fe, 0x0000007e00000001,
  0x0000007f00000000, 0x0000007dffffff05,
  0x0000007effffff02, 0x00000054000000a9,
  0x00000054aaaaab54, 0x0000003266666731,
  0x00000032cccccd98, 0x00000000007e0001,
  0x00000000007f0000, 0x00000000007dff05,
  0x00000000007eff02, 0x00000000007dfe09,
  0x00000000007efe04, 0x00000000007dfd0d,
  0x00000000007efd06, 0x0000000000007e01,
  0x0000000000007f00, 0x0000000000007d05,
  0x0000000000007e02, 0x0000000000007c09,
  0x0000000000007d04, 0x0000000000007b0d,
  0x0000000000007c06, 0x0000000000001f81,
  0x0000000000001fc0, 0x00000000000002f5,
  0x00000000000002f4, 0x00000000000001f5,
  0x00000000000001f8, 0x00000000000000fb,
  0x00000000000000fc, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffff07,
  0xffffffffffffff04, 0xfffffffffffffe0d,
  0xfffffffffffffe08, 0xffffffffffffe0c1,
  0xffffffffffffe080, 0xffffffffffff85ef,
  0xffffffffffff84f4, 0xffffffffffff84f5,
  0xffffffffffff83f8, 0xffffffffffff83fb,
  0xffffffffffff82fc, 0xffffffffff8302ef,
  0xffffffffff8202f4, 0xffffffffff8301f5,
  0xffffffffff8201f8, 0xffffffffff8300fb,
  0xffffffffff8200fc, 0xffffffce00000033,
  0xffffffcd999999cc, 0xffffffacaaaaaaff,
  0xffffffac00000054, 0xffffff83000002ef,
  0xffffff82000002f4, 0xffffff83000001f5,
  0xffffff82000001f8, 0xffffff83000000fb,
  0xffffff82000000fc, 0x0000007d00000001,
  0x0000007e00000000, 0x0000007cffffff07,
  0x0000007dffffff04, 0x00000053555555fd,
  0x00000054000000a8, 0x00000032000000c9,
  0x0000003266666730, 0x00000000007d0001,
  0x00000000007e0000, 0x00000000007cff07,
  0x00000000007dff04, 0x00000000007cfe0d,
  0x00000000007dfe08, 0x00000000007cfd13,
  0x00000000007dfd0c, 0x0000000000007d01,
  0x0000000000007e00, 0x0000000000007c07,
  0x0000000000007d04, 0x0000000000007b0d,
  0x0000000000007c08, 0x0000000000007a13,
  0x0000000000007b0c, 0x0000000000001f41,
  0x0000000000001f80, 0x00000000000002ef,
  0x00000000000002ee, 0x0000000000000081,
  0x00000000000001f4, 0x0000000000000041,
  0x00000000000000fa, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffc1,
  0xffffffffffffff06, 0xffffffffffffff81,
  0xfffffffffffffe0c, 0xfffffffffffff801,
  0xffffffffffffe0c0, 0xffffffffffffe0c1,
  0xffffffffffff85ee, 0xffffffffffffe081,
  0xffffffffffff84f4, 0xffffffffffffe041,
  0xffffffffffff83fa, 0xffffffffffe000c1,
  0xffffffffff8302ee, 0xffffffffffe00081,
  0xffffffffff8301f4, 0xffffffffffe00041,
  0xffffffffff8300fa, 0xfffffff333333341,
  0xffffffce00000032, 0xffffffeaaaaaaac1,
  0xffffffacaaaaaafe, 0xffffffe0000000c1,
  0xffffff83000002ee, 0xffffffe000000081,
  0xffffff83000001f4, 0xffffffe000000041,
  0xffffff83000000fa, 0x0000002000000001,
  0x0000007d00000000, 0x0000001fffffffc1,
  0x0000007cffffff06, 0x0000001555555581,
  0x00000053555555fc, 0x0000000ccccccd01,
  0x00000032000000c8, 0x0000000000200001,
  0x00000000007d0000, 0x00000000001fffc1,
  0x00000000007cff06, 0x00000000001fff81,
  0x00000000007cfe0c, 0x00000000001fff41,
  0x00000000007cfd12, 0x0000000000002001,
  0x0000000000007d00, 0x0000000000001fc1,
  0x0000000000007c06, 0x0000000000001f81,
  0x0000000000007b0c, 0x0000000000001f41,
  0x0000000000007a12, 0x0000000000000801,
  0x0000000000001f40, 0x00000000000000c1,
  0x00000000000000c0, 0x000000000000000d,
  0x0000000000000080, 0x0000000000000007,
  0x0000000000000040, 0x0000000000000001,
  0x0000000000000000, 0xfffffffffffffffb,
  0xffffffffffffffc0, 0xfffffffffffffff5,
  0xffffffffffffff80, 0xffffffffffffff41,
  0xfffffffffffff800, 0xfffffffffffffd13,
  0xffffffffffffe0c0, 0xfffffffffffffd0d,
  0xffffffffffffe080, 0xfffffffffffffd07,
  0xffffffffffffe040, 0xfffffffffffd0013,
  0xffffffffffe000c0, 0xfffffffffffd000d,
  0xffffffffffe00080, 0xfffffffffffd0007,
  0xffffffffffe00040, 0xfffffffecccccccf,
  0xfffffff333333340, 0xfffffffe00000003,
  0xffffffeaaaaaaac0, 0xfffffffd00000013,
  0xffffffe0000000c0, 0xfffffffd0000000d,
  0xffffffe000000080, 0xfffffffd00000007,
  0xffffffe000000040, 0x0000000300000001,
  0x0000002000000000, 0x00000002fffffffb,
  0x0000001fffffffc0, 0x0000000200000005,
  0x0000001555555580, 0x0000000133333339,
  0x0000000ccccccd00, 0x0000000000030001,
  0x0000000000200000, 0x000000000002fffb,
  0x00000000001fffc0, 0x000000000002fff5,
  0x00000000001fff80, 0x000000000002ffef,
  0x00000000001fff40, 0x0000000000000301,
  0x0000000000002000, 0x00000000000002fb,
  0x0000000000001fc0, 0x00000000000002f5,
  0x0000000000001f80, 0x00000000000002ef,
  0x0000000000001f40, 0x00000000000000c1,
  0x0000000000000800, 0x0000000000000013,
};
const unsigned kExpectedCount_NEON_sqdmlal_2D = 961;

#endif  // VIXL_SIM_SQDMLAL_2D_TRACE_AARCH64_H_
