// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SHADD_2S_TRACE_AARCH64_H_
#define VIXL_SIM_SHADD_2S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_shadd_2S[] = {
  0x00007e00, 0x00007f00, 0x00000000, 0x00000000,
  0x00007e80, 0x00403e00, 0x00000000, 0x00000000,
  0x00403d80, 0x00003f80, 0x00000000, 0x00000000,
  0x00003f00, 0x00003f80, 0x00000000, 0x00000000,
  0x00003f00, 0x00003f81, 0x00000000, 0x00000000,
  0x00003f01, 0x00003f90, 0x00000000, 0x00000000,
  0x00003f10, 0x00003fbe, 0x00000000, 0x00000000,
  0x00003f3e, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003f3f, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003f3f, 0x00007f7e, 0x00000000, 0x00000000,
  0x00007efe, 0x00007f7f, 0x00000000, 0x00000000,
  0x00007eff, 0x00007f7f, 0x00000000, 0x00000000,
  0x00007eff, 0x1999d919, 0x00000000, 0x00000000,
  0x1999d899, 0x2aaaea2a, 0x00000000, 0x00000000,
  0x2aaae9aa, 0x40003f7e, 0x00000000, 0x00000000,
  0x40003efe, 0x40003f7f, 0x00000000, 0x00000000,
  0x40003eff, 0x40003f7f, 0x00000000, 0x00000000,
  0x40003eff, 0xc0003f80, 0x00000000, 0x00000000,
  0xc0003f00, 0xc0003f80, 0x00000000, 0x00000000,
  0xc0003f00, 0xd55594d5, 0x00000000, 0x00000000,
  0xd5559455, 0xe666a5e6, 0x00000000, 0x00000000,
  0xe666a566, 0xffffff80, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff80, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff01, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff01, 0x00003f40, 0x00000000, 0x00000000,
  0x00003ec0, 0x00003f40, 0x00000000, 0x00000000,
  0x00003ec0, 0x00003f41, 0x00000000, 0x00000000,
  0x00003ec1, 0x00003f41, 0x00000000, 0x00000000,
  0x00003ec1, 0x00003f70, 0x00000000, 0x00000000,
  0x00003ef0, 0x00003f7e, 0x00000000, 0x00000000,
  0x00003f7e, 0x003ffe7f, 0x00000000, 0x00000000,
  0x00003f7f, 0x003ffe7f, 0x00000000, 0x00000000,
  0x00003f7f, 0x003ffe80, 0x00000000, 0x00000000,
  0x00003f80, 0x003ffe80, 0x00000000, 0x00000000,
  0x00003f80, 0x003ffe81, 0x00000000, 0x00000000,
  0x00003f81, 0x003ffe90, 0x00000000, 0x00000000,
  0x00003f90, 0x003ffebe, 0x00000000, 0x00000000,
  0x00003fbe, 0x003ffebf, 0x00000000, 0x00000000,
  0x00003fbf, 0x003ffebf, 0x00000000, 0x00000000,
  0x00003fbf, 0x00403e7e, 0x00000000, 0x00000000,
  0x00007f7e, 0x00403e7f, 0x00000000, 0x00000000,
  0x00007f7f, 0x00403e7f, 0x00000000, 0x00000000,
  0x00007f7f, 0x19d99819, 0x00000000, 0x00000000,
  0x1999d919, 0x2aeaa92a, 0x00000000, 0x00000000,
  0x2aaaea2a, 0x403ffe7e, 0x00000000, 0x00000000,
  0x40003f7e, 0x403ffe7f, 0x00000000, 0x00000000,
  0x40003f7f, 0x403ffe7f, 0x00000000, 0x00000000,
  0x40003f7f, 0xc03ffe80, 0x00000000, 0x00000000,
  0xc0003f80, 0xc03ffe80, 0x00000000, 0x00000000,
  0xc0003f80, 0xd59553d5, 0x00000000, 0x00000000,
  0xd55594d5, 0xe6a664e6, 0x00000000, 0x00000000,
  0xe666a5e6, 0x003fbe80, 0x00000000, 0x00000000,
  0xffffff80, 0x003fbe80, 0x00000000, 0x00000000,
  0xffffff80, 0x003fbe81, 0x00000000, 0x00000000,
  0xffffff81, 0x003fbe81, 0x00000000, 0x00000000,
  0xffffff81, 0x003ffe40, 0x00000000, 0x00000000,
  0x00003f40, 0x003ffe40, 0x00000000, 0x00000000,
  0x00003f40, 0x003ffe41, 0x00000000, 0x00000000,
  0x00003f41, 0x003ffe41, 0x00000000, 0x00000000,
  0x00003f41, 0x003ffe70, 0x00000000, 0x00000000,
  0x00003f70, 0x003ffe7e, 0x00000000, 0x00000000,
  0x003ffe7e, 0xffffffff, 0x00000000, 0x00000000,
  0x003ffe7f, 0xffffffff, 0x00000000, 0x00000000,
  0x003ffe7f, 0x00000000, 0x00000000, 0x00000000,
  0x003ffe80, 0x00000000, 0x00000000, 0x00000000,
  0x003ffe80, 0x00000001, 0x00000000, 0x00000000,
  0x003ffe81, 0x00000010, 0x00000000, 0x00000000,
  0x003ffe90, 0x0000003e, 0x00000000, 0x00000000,
  0x003ffebe, 0x0000003f, 0x00000000, 0x00000000,
  0x003ffebf, 0x0000003f, 0x00000000, 0x00000000,
  0x003ffebf, 0x00003ffe, 0x00000000, 0x00000000,
  0x00403e7e, 0x00003fff, 0x00000000, 0x00000000,
  0x00403e7f, 0x00003fff, 0x00000000, 0x00000000,
  0x00403e7f, 0x19999999, 0x00000000, 0x00000000,
  0x19d99819, 0x2aaaaaaa, 0x00000000, 0x00000000,
  0x2aeaa92a, 0x3ffffffe, 0x00000000, 0x00000000,
  0x403ffe7e, 0x3fffffff, 0x00000000, 0x00000000,
  0x403ffe7f, 0x3fffffff, 0x00000000, 0x00000000,
  0x403ffe7f, 0xc0000000, 0x00000000, 0x00000000,
  0xc03ffe80, 0xc0000000, 0x00000000, 0x00000000,
  0xc03ffe80, 0xd5555555, 0x00000000, 0x00000000,
  0xd59553d5, 0xe6666666, 0x00000000, 0x00000000,
  0xe6a664e6, 0xffffc000, 0x00000000, 0x00000000,
  0x003fbe80, 0xffffc000, 0x00000000, 0x00000000,
  0x003fbe80, 0xffffc001, 0x00000000, 0x00000000,
  0x003fbe81, 0xffffc001, 0x00000000, 0x00000000,
  0x003fbe81, 0xffffffc0, 0x00000000, 0x00000000,
  0x003ffe40, 0xffffffc0, 0x00000000, 0x00000000,
  0x003ffe40, 0xffffffc1, 0x00000000, 0x00000000,
  0x003ffe41, 0xffffffc1, 0x00000000, 0x00000000,
  0x003ffe41, 0xfffffff0, 0x00000000, 0x00000000,
  0x003ffe70, 0xfffffffe, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000001, 0x00000010, 0x00000000, 0x00000000,
  0x00000010, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003e, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003f, 0x00000040, 0x00000000, 0x00000000,
  0x0000003f, 0x00003fff, 0x00000000, 0x00000000,
  0x00003ffe, 0x00003fff, 0x00000000, 0x00000000,
  0x00003fff, 0x00004000, 0x00000000, 0x00000000,
  0x00003fff, 0x1999999a, 0x00000000, 0x00000000,
  0x19999999, 0x2aaaaaab, 0x00000000, 0x00000000,
  0x2aaaaaaa, 0x3fffffff, 0x00000000, 0x00000000,
  0x3ffffffe, 0x3fffffff, 0x00000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x00000000, 0x00000000,
  0x3fffffff, 0xc0000000, 0x00000000, 0x00000000,
  0xc0000000, 0xc0000001, 0x00000000, 0x00000000,
  0xc0000000, 0xd5555555, 0x00000000, 0x00000000,
  0xd5555555, 0xe6666666, 0x00000000, 0x00000000,
  0xe6666666, 0xffffc000, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc002, 0x00000000, 0x00000000,
  0xffffc001, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffc2, 0x00000000, 0x00000000,
  0xffffffc1, 0xfffffff0, 0x00000000, 0x00000000,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000000, 0x00000000,
  0x00000001, 0x00000011, 0x00000000, 0x00000000,
  0x00000010, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003f, 0x00000040, 0x00000000, 0x00000000,
  0x0000003f, 0x00000040, 0x00000000, 0x00000000,
  0x00000040, 0x00003fff, 0x00000000, 0x00000000,
  0x00003fff, 0x00004000, 0x00000000, 0x00000000,
  0x00003fff, 0x00004000, 0x00000000, 0x00000000,
  0x00004000, 0x1999999a, 0x00000000, 0x00000000,
  0x1999999a, 0x2aaaaaab, 0x00000000, 0x00000000,
  0x2aaaaaab, 0x3fffffff, 0x00000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x00000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x00000000, 0x00000000,
  0x40000000, 0xc0000001, 0x00000000, 0x00000000,
  0xc0000000, 0xc0000001, 0x00000000, 0x00000000,
  0xc0000001, 0xd5555556, 0x00000000, 0x00000000,
  0xd5555555, 0xe6666667, 0x00000000, 0x00000000,
  0xe6666666, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc002, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc002, 0x00000000, 0x00000000,
  0xffffc002, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffc2, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffc2, 0x00000000, 0x00000000,
  0xffffffc2, 0xfffffff1, 0x00000000, 0x00000000,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x0000000f, 0x00000000, 0x00000000,
  0x00000000, 0x0000000f, 0x00000000, 0x00000000,
  0x00000000, 0x00000010, 0x00000000, 0x00000000,
  0x00000001, 0x00000010, 0x00000000, 0x00000000,
  0x00000001, 0x00000011, 0x00000000, 0x00000000,
  0x00000002, 0x00000020, 0x00000000, 0x00000000,
  0x00000011, 0x0000004e, 0x00000000, 0x00000000,
  0x0000003f, 0x0000004f, 0x00000000, 0x00000000,
  0x00000040, 0x0000004f, 0x00000000, 0x00000000,
  0x00000040, 0x0000400e, 0x00000000, 0x00000000,
  0x00003fff, 0x0000400f, 0x00000000, 0x00000000,
  0x00004000, 0x0000400f, 0x00000000, 0x00000000,
  0x00004000, 0x199999a9, 0x00000000, 0x00000000,
  0x1999999a, 0x2aaaaaba, 0x00000000, 0x00000000,
  0x2aaaaaab, 0x4000000e, 0x00000000, 0x00000000,
  0x3fffffff, 0x4000000f, 0x00000000, 0x00000000,
  0x40000000, 0x4000000f, 0x00000000, 0x00000000,
  0x40000000, 0xc0000010, 0x00000000, 0x00000000,
  0xc0000001, 0xc0000010, 0x00000000, 0x00000000,
  0xc0000001, 0xd5555565, 0x00000000, 0x00000000,
  0xd5555556, 0xe6666676, 0x00000000, 0x00000000,
  0xe6666667, 0xffffc010, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc010, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc011, 0x00000000, 0x00000000,
  0xffffc002, 0xffffc011, 0x00000000, 0x00000000,
  0xffffc002, 0xffffffd0, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffd0, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffd1, 0x00000000, 0x00000000,
  0xffffffc2, 0xffffffd1, 0x00000000, 0x00000000,
  0xffffffc2, 0x00000000, 0x00000000, 0x00000000,
  0xfffffff1, 0x0000000e, 0x00000000, 0x00000000,
  0x0000000e, 0x0000003d, 0x00000000, 0x00000000,
  0x0000000f, 0x0000003e, 0x00000000, 0x00000000,
  0x0000000f, 0x0000003e, 0x00000000, 0x00000000,
  0x00000010, 0x0000003f, 0x00000000, 0x00000000,
  0x00000010, 0x0000003f, 0x00000000, 0x00000000,
  0x00000011, 0x0000004e, 0x00000000, 0x00000000,
  0x00000020, 0x0000007d, 0x00000000, 0x00000000,
  0x0000004e, 0x0000007d, 0x00000000, 0x00000000,
  0x0000004f, 0x0000007e, 0x00000000, 0x00000000,
  0x0000004f, 0x0000403d, 0x00000000, 0x00000000,
  0x0000400e, 0x0000403d, 0x00000000, 0x00000000,
  0x0000400f, 0x0000403e, 0x00000000, 0x00000000,
  0x0000400f, 0x199999d8, 0x00000000, 0x00000000,
  0x199999a9, 0x2aaaaae9, 0x00000000, 0x00000000,
  0x2aaaaaba, 0x4000003d, 0x00000000, 0x00000000,
  0x4000000e, 0x4000003d, 0x00000000, 0x00000000,
  0x4000000f, 0x4000003e, 0x00000000, 0x00000000,
  0x4000000f, 0xc000003e, 0x00000000, 0x00000000,
  0xc0000010, 0xc000003f, 0x00000000, 0x00000000,
  0xc0000010, 0xd5555593, 0x00000000, 0x00000000,
  0xd5555565, 0xe66666a4, 0x00000000, 0x00000000,
  0xe6666676, 0xffffc03e, 0x00000000, 0x00000000,
  0xffffc010, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc010, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc011, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc011, 0xfffffffe, 0x00000000, 0x00000000,
  0xffffffd0, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffd0, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffd1, 0x00000000, 0x00000000, 0x00000000,
  0xffffffd1, 0x0000002e, 0x00000000, 0x00000000,
  0x00000000, 0x0000003d, 0x00000000, 0x00000000,
  0x0000003d, 0x0000003e, 0x00000000, 0x00000000,
  0x0000003d, 0x0000003e, 0x00000000, 0x00000000,
  0x0000003e, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003e, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003f, 0x00000040, 0x00000000, 0x00000000,
  0x0000003f, 0x0000004f, 0x00000000, 0x00000000,
  0x0000004e, 0x0000007d, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x00000000, 0x00000000,
  0x0000007e, 0x0000403d, 0x00000000, 0x00000000,
  0x0000403d, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403d, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403e, 0x199999d8, 0x00000000, 0x00000000,
  0x199999d8, 0x2aaaaae9, 0x00000000, 0x00000000,
  0x2aaaaae9, 0x4000003d, 0x00000000, 0x00000000,
  0x4000003d, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003d, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003e, 0xc000003f, 0x00000000, 0x00000000,
  0xc000003e, 0xc000003f, 0x00000000, 0x00000000,
  0xc000003f, 0xd5555594, 0x00000000, 0x00000000,
  0xd5555593, 0xe66666a5, 0x00000000, 0x00000000,
  0xe66666a4, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc03e, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x0000002f, 0x00000000, 0x00000000,
  0x0000002e, 0x0000003d, 0x00000000, 0x00000000,
  0x0000003d, 0x0000003e, 0x00000000, 0x00000000,
  0x0000003e, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003e, 0x0000003f, 0x00000000, 0x00000000,
  0x0000003f, 0x00000040, 0x00000000, 0x00000000,
  0x0000003f, 0x00000040, 0x00000000, 0x00000000,
  0x00000040, 0x0000004f, 0x00000000, 0x00000000,
  0x0000004f, 0x0000007e, 0x00000000, 0x00000000,
  0x0000007d, 0x0000007e, 0x00000000, 0x00000000,
  0x0000007e, 0x0000007f, 0x00000000, 0x00000000,
  0x0000007e, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403d, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403e, 0x0000403f, 0x00000000, 0x00000000,
  0x0000403e, 0x199999d9, 0x00000000, 0x00000000,
  0x199999d8, 0x2aaaaaea, 0x00000000, 0x00000000,
  0x2aaaaae9, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003d, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003e, 0x4000003f, 0x00000000, 0x00000000,
  0x4000003e, 0xc000003f, 0x00000000, 0x00000000,
  0xc000003f, 0xc0000040, 0x00000000, 0x00000000,
  0xc000003f, 0xd5555594, 0x00000000, 0x00000000,
  0xd5555594, 0xe66666a5, 0x00000000, 0x00000000,
  0xe66666a5, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc040, 0xffffc041, 0x00000000, 0x00000000,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x0000002f, 0x00000000, 0x00000000,
  0x0000002f, 0x0000003e, 0x00000000, 0x00000000,
  0x0000003e, 0x00003ffd, 0x00000000, 0x00000000,
  0x0000003e, 0x00003ffe, 0x00000000, 0x00000000,
  0x0000003f, 0x00003ffe, 0x00000000, 0x00000000,
  0x0000003f, 0x00003fff, 0x00000000, 0x00000000,
  0x00000040, 0x00003fff, 0x00000000, 0x00000000,
  0x00000040, 0x0000400e, 0x00000000, 0x00000000,
  0x0000004f, 0x0000403d, 0x00000000, 0x00000000,
  0x0000007e, 0x0000403d, 0x00000000, 0x00000000,
  0x0000007e, 0x0000403e, 0x00000000, 0x00000000,
  0x0000007f, 0x00007ffd, 0x00000000, 0x00000000,
  0x0000403e, 0x00007ffd, 0x00000000, 0x00000000,
  0x0000403e, 0x00007ffe, 0x00000000, 0x00000000,
  0x0000403f, 0x1999d998, 0x00000000, 0x00000000,
  0x199999d9, 0x2aaaeaa9, 0x00000000, 0x00000000,
  0x2aaaaaea, 0x40003ffd, 0x00000000, 0x00000000,
  0x4000003e, 0x40003ffd, 0x00000000, 0x00000000,
  0x4000003e, 0x40003ffe, 0x00000000, 0x00000000,
  0x4000003f, 0xc0003ffe, 0x00000000, 0x00000000,
  0xc000003f, 0xc0003fff, 0x00000000, 0x00000000,
  0xc0000040, 0xd5559553, 0x00000000, 0x00000000,
  0xd5555594, 0xe666a664, 0x00000000, 0x00000000,
  0xe66666a5, 0xfffffffe, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffffff, 0x00000000, 0x00000000,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000000,
  0xffffc040, 0x00000000, 0x00000000, 0x00000000,
  0xffffc041, 0x00003fbe, 0x00000000, 0x00000000,
  0xffffffff, 0x00003fbf, 0x00000000, 0x00000000,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00000000, 0x00003fc0, 0x00000000, 0x00000000,
  0x00000001, 0x00003fee, 0x00000000, 0x00000000,
  0x0000002f, 0x00003ffd, 0x00000000, 0x00000000,
  0x00003ffd, 0x00003ffe, 0x00000000, 0x00000000,
  0x00003ffd, 0x00003ffe, 0x00000000, 0x00000000,
  0x00003ffe, 0x00003fff, 0x00000000, 0x00000000,
  0x00003ffe, 0x00003fff, 0x00000000, 0x00000000,
  0x00003fff, 0x00004000, 0x00000000, 0x00000000,
  0x00003fff, 0x0000400f, 0x00000000, 0x00000000,
  0x0000400e, 0x0000403d, 0x00000000, 0x00000000,
  0x0000403d, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403d, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403e, 0x00007ffd, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00000000, 0x00000000,
  0x00007ffe, 0x1999d998, 0x00000000, 0x00000000,
  0x1999d998, 0x2aaaeaa9, 0x00000000, 0x00000000,
  0x2aaaeaa9, 0x40003ffd, 0x00000000, 0x00000000,
  0x40003ffd, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffd, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffe, 0xc0003fff, 0x00000000, 0x00000000,
  0xc0003ffe, 0xc0003fff, 0x00000000, 0x00000000,
  0xc0003fff, 0xd5559554, 0x00000000, 0x00000000,
  0xd5559553, 0xe666a665, 0x00000000, 0x00000000,
  0xe666a664, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003fbe, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fc0, 0x00003fef, 0x00000000, 0x00000000,
  0x00003fee, 0x00003ffd, 0x00000000, 0x00000000,
  0x00003ffd, 0x00003ffe, 0x00000000, 0x00000000,
  0x00003ffe, 0x00003fff, 0x00000000, 0x00000000,
  0x00003ffe, 0x00003fff, 0x00000000, 0x00000000,
  0x00003fff, 0x00004000, 0x00000000, 0x00000000,
  0x00003fff, 0x00004000, 0x00000000, 0x00000000,
  0x00004000, 0x0000400f, 0x00000000, 0x00000000,
  0x0000400f, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403d, 0x0000403e, 0x00000000, 0x00000000,
  0x0000403e, 0x0000403f, 0x00000000, 0x00000000,
  0x0000403e, 0x00007ffe, 0x00000000, 0x00000000,
  0x00007ffd, 0x00007ffe, 0x00000000, 0x00000000,
  0x00007ffe, 0x00007fff, 0x00000000, 0x00000000,
  0x00007ffe, 0x1999d999, 0x00000000, 0x00000000,
  0x1999d998, 0x2aaaeaaa, 0x00000000, 0x00000000,
  0x2aaaeaa9, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffd, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffe, 0x40003fff, 0x00000000, 0x00000000,
  0x40003ffe, 0xc0003fff, 0x00000000, 0x00000000,
  0xc0003fff, 0xc0004000, 0x00000000, 0x00000000,
  0xc0003fff, 0xd5559554, 0x00000000, 0x00000000,
  0xd5559554, 0xe666a665, 0x00000000, 0x00000000,
  0xe666a665, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fc0, 0x00003fc1, 0x00000000, 0x00000000,
  0x00003fc0, 0x00003fef, 0x00000000, 0x00000000,
  0x00003fef, 0x00003ffe, 0x00000000, 0x00000000,
  0x00003ffe, 0x19999998, 0x00000000, 0x00000000,
  0x00003ffe, 0x19999999, 0x00000000, 0x00000000,
  0x00003fff, 0x19999999, 0x00000000, 0x00000000,
  0x00003fff, 0x1999999a, 0x00000000, 0x00000000,
  0x00004000, 0x1999999a, 0x00000000, 0x00000000,
  0x00004000, 0x199999a9, 0x00000000, 0x00000000,
  0x0000400f, 0x199999d8, 0x00000000, 0x00000000,
  0x0000403e, 0x199999d8, 0x00000000, 0x00000000,
  0x0000403e, 0x199999d9, 0x00000000, 0x00000000,
  0x0000403f, 0x1999d998, 0x00000000, 0x00000000,
  0x00007ffe, 0x1999d998, 0x00000000, 0x00000000,
  0x00007ffe, 0x1999d999, 0x00000000, 0x00000000,
  0x00007fff, 0x33333333, 0x00000000, 0x00000000,
  0x1999d999, 0x44444444, 0x00000000, 0x00000000,
  0x2aaaeaaa, 0x59999998, 0x00000000, 0x00000000,
  0x40003ffe, 0x59999998, 0x00000000, 0x00000000,
  0x40003ffe, 0x59999999, 0x00000000, 0x00000000,
  0x40003fff, 0xd9999999, 0x00000000, 0x00000000,
  0xc0003fff, 0xd999999a, 0x00000000, 0x00000000,
  0xc0004000, 0xeeeeeeee, 0x00000000, 0x00000000,
  0xd5559554, 0xffffffff, 0x00000000, 0x00000000,
  0xe666a665, 0x19995999, 0x00000000, 0x00000000,
  0xffffffff, 0x1999599a, 0x00000000, 0x00000000,
  0x00000000, 0x1999599a, 0x00000000, 0x00000000,
  0x00000000, 0x1999599b, 0x00000000, 0x00000000,
  0x00000001, 0x19999959, 0x00000000, 0x00000000,
  0x00003fbf, 0x1999995a, 0x00000000, 0x00000000,
  0x00003fc0, 0x1999995a, 0x00000000, 0x00000000,
  0x00003fc0, 0x1999995b, 0x00000000, 0x00000000,
  0x00003fc1, 0x19999989, 0x00000000, 0x00000000,
  0x00003fef, 0x19999998, 0x00000000, 0x00000000,
  0x19999998, 0x2aaaaaa9, 0x00000000, 0x00000000,
  0x19999998, 0x2aaaaaaa, 0x00000000, 0x00000000,
  0x19999999, 0x2aaaaaaa, 0x00000000, 0x00000000,
  0x19999999, 0x2aaaaaab, 0x00000000, 0x00000000,
  0x1999999a, 0x2aaaaaab, 0x00000000, 0x00000000,
  0x1999999a, 0x2aaaaaba, 0x00000000, 0x00000000,
  0x199999a9, 0x2aaaaae9, 0x00000000, 0x00000000,
  0x199999d8, 0x2aaaaae9, 0x00000000, 0x00000000,
  0x199999d8, 0x2aaaaaea, 0x00000000, 0x00000000,
  0x199999d9, 0x2aaaeaa9, 0x00000000, 0x00000000,
  0x1999d998, 0x2aaaeaa9, 0x00000000, 0x00000000,
  0x1999d998, 0x2aaaeaaa, 0x00000000, 0x00000000,
  0x1999d999, 0x44444444, 0x00000000, 0x00000000,
  0x33333333, 0x55555555, 0x00000000, 0x00000000,
  0x44444444, 0x6aaaaaa9, 0x00000000, 0x00000000,
  0x59999998, 0x6aaaaaa9, 0x00000000, 0x00000000,
  0x59999998, 0x6aaaaaaa, 0x00000000, 0x00000000,
  0x59999999, 0xeaaaaaaa, 0x00000000, 0x00000000,
  0xd9999999, 0xeaaaaaab, 0x00000000, 0x00000000,
  0xd999999a, 0xffffffff, 0x00000000, 0x00000000,
  0xeeeeeeee, 0x11111110, 0x00000000, 0x00000000,
  0xffffffff, 0x2aaa6aaa, 0x00000000, 0x00000000,
  0x19995999, 0x2aaa6aab, 0x00000000, 0x00000000,
  0x1999599a, 0x2aaa6aab, 0x00000000, 0x00000000,
  0x1999599a, 0x2aaa6aac, 0x00000000, 0x00000000,
  0x1999599b, 0x2aaaaa6a, 0x00000000, 0x00000000,
  0x19999959, 0x2aaaaa6b, 0x00000000, 0x00000000,
  0x1999995a, 0x2aaaaa6b, 0x00000000, 0x00000000,
  0x1999995a, 0x2aaaaa6c, 0x00000000, 0x00000000,
  0x1999995b, 0x2aaaaa9a, 0x00000000, 0x00000000,
  0x19999989, 0x2aaaaaa9, 0x00000000, 0x00000000,
  0x2aaaaaa9, 0x3ffffffd, 0x00000000, 0x00000000,
  0x2aaaaaa9, 0x3ffffffe, 0x00000000, 0x00000000,
  0x2aaaaaaa, 0x3ffffffe, 0x00000000, 0x00000000,
  0x2aaaaaaa, 0x3fffffff, 0x00000000, 0x00000000,
  0x2aaaaaab, 0x3fffffff, 0x00000000, 0x00000000,
  0x2aaaaaab, 0x4000000e, 0x00000000, 0x00000000,
  0x2aaaaaba, 0x4000003d, 0x00000000, 0x00000000,
  0x2aaaaae9, 0x4000003d, 0x00000000, 0x00000000,
  0x2aaaaae9, 0x4000003e, 0x00000000, 0x00000000,
  0x2aaaaaea, 0x40003ffd, 0x00000000, 0x00000000,
  0x2aaaeaa9, 0x40003ffd, 0x00000000, 0x00000000,
  0x2aaaeaa9, 0x40003ffe, 0x00000000, 0x00000000,
  0x2aaaeaaa, 0x59999998, 0x00000000, 0x00000000,
  0x44444444, 0x6aaaaaa9, 0x00000000, 0x00000000,
  0x55555555, 0x7ffffffd, 0x00000000, 0x00000000,
  0x6aaaaaa9, 0x7ffffffd, 0x00000000, 0x00000000,
  0x6aaaaaa9, 0x7ffffffe, 0x00000000, 0x00000000,
  0x6aaaaaaa, 0xfffffffe, 0x00000000, 0x00000000,
  0xeaaaaaaa, 0xffffffff, 0x00000000, 0x00000000,
  0xeaaaaaab, 0x15555553, 0x00000000, 0x00000000,
  0xffffffff, 0x26666664, 0x00000000, 0x00000000,
  0x11111110, 0x3fffbffe, 0x00000000, 0x00000000,
  0x2aaa6aaa, 0x3fffbfff, 0x00000000, 0x00000000,
  0x2aaa6aab, 0x3fffbfff, 0x00000000, 0x00000000,
  0x2aaa6aab, 0x3fffc000, 0x00000000, 0x00000000,
  0x2aaa6aac, 0x3fffffbe, 0x00000000, 0x00000000,
  0x2aaaaa6a, 0x3fffffbf, 0x00000000, 0x00000000,
  0x2aaaaa6b, 0x3fffffbf, 0x00000000, 0x00000000,
  0x2aaaaa6b, 0x3fffffc0, 0x00000000, 0x00000000,
  0x2aaaaa6c, 0x3fffffee, 0x00000000, 0x00000000,
  0x2aaaaa9a, 0x3ffffffd, 0x00000000, 0x00000000,
  0x3ffffffd, 0x3ffffffe, 0x00000000, 0x00000000,
  0x3ffffffd, 0x3ffffffe, 0x00000000, 0x00000000,
  0x3ffffffe, 0x3fffffff, 0x00000000, 0x00000000,
  0x3ffffffe, 0x3fffffff, 0x00000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x00000000, 0x00000000,
  0x3fffffff, 0x4000000f, 0x00000000, 0x00000000,
  0x4000000e, 0x4000003d, 0x00000000, 0x00000000,
  0x4000003d, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003d, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003e, 0x40003ffd, 0x00000000, 0x00000000,
  0x40003ffd, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffd, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffe, 0x59999998, 0x00000000, 0x00000000,
  0x59999998, 0x6aaaaaa9, 0x00000000, 0x00000000,
  0x6aaaaaa9, 0x7ffffffd, 0x00000000, 0x00000000,
  0x7ffffffd, 0x7ffffffe, 0x00000000, 0x00000000,
  0x7ffffffd, 0x7ffffffe, 0x00000000, 0x00000000,
  0x7ffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x15555554, 0x00000000, 0x00000000,
  0x15555553, 0x26666665, 0x00000000, 0x00000000,
  0x26666664, 0x3fffbfff, 0x00000000, 0x00000000,
  0x3fffbffe, 0x3fffbfff, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffc000, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffffbe, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffc0, 0x3fffffef, 0x00000000, 0x00000000,
  0x3fffffee, 0x3ffffffd, 0x00000000, 0x00000000,
  0x3ffffffd, 0x3ffffffe, 0x00000000, 0x00000000,
  0x3ffffffe, 0x3fffffff, 0x00000000, 0x00000000,
  0x3ffffffe, 0x3fffffff, 0x00000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x00000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x00000000, 0x00000000,
  0x40000000, 0x4000000f, 0x00000000, 0x00000000,
  0x4000000f, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003d, 0x4000003e, 0x00000000, 0x00000000,
  0x4000003e, 0x4000003f, 0x00000000, 0x00000000,
  0x4000003e, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffd, 0x40003ffe, 0x00000000, 0x00000000,
  0x40003ffe, 0x40003fff, 0x00000000, 0x00000000,
  0x40003ffe, 0x59999999, 0x00000000, 0x00000000,
  0x59999998, 0x6aaaaaaa, 0x00000000, 0x00000000,
  0x6aaaaaa9, 0x7ffffffe, 0x00000000, 0x00000000,
  0x7ffffffd, 0x7ffffffe, 0x00000000, 0x00000000,
  0x7ffffffe, 0x7fffffff, 0x00000000, 0x00000000,
  0x7ffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x15555554, 0x00000000, 0x00000000,
  0x15555554, 0x26666665, 0x00000000, 0x00000000,
  0x26666665, 0x3fffbfff, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffc000, 0x3fffc001, 0x00000000, 0x00000000,
  0x3fffc000, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffc0, 0x3fffffc1, 0x00000000, 0x00000000,
  0x3fffffc0, 0x3fffffef, 0x00000000, 0x00000000,
  0x3fffffef, 0x3ffffffe, 0x00000000, 0x00000000,
  0x3ffffffe, 0xbfffffff, 0x00000000, 0x00000000,
  0x3ffffffe, 0xbfffffff, 0x00000000, 0x00000000,
  0x3fffffff, 0xc0000000, 0x00000000, 0x00000000,
  0x3fffffff, 0xc0000000, 0x00000000, 0x00000000,
  0x40000000, 0xc0000001, 0x00000000, 0x00000000,
  0x40000000, 0xc0000010, 0x00000000, 0x00000000,
  0x4000000f, 0xc000003e, 0x00000000, 0x00000000,
  0x4000003e, 0xc000003f, 0x00000000, 0x00000000,
  0x4000003e, 0xc000003f, 0x00000000, 0x00000000,
  0x4000003f, 0xc0003ffe, 0x00000000, 0x00000000,
  0x40003ffe, 0xc0003fff, 0x00000000, 0x00000000,
  0x40003ffe, 0xc0003fff, 0x00000000, 0x00000000,
  0x40003fff, 0xd9999999, 0x00000000, 0x00000000,
  0x59999999, 0xeaaaaaaa, 0x00000000, 0x00000000,
  0x6aaaaaaa, 0xfffffffe, 0x00000000, 0x00000000,
  0x7ffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0x7ffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0x7fffffff, 0x80000000, 0x00000000, 0x00000000,
  0xffffffff, 0x80000000, 0x00000000, 0x00000000,
  0x00000000, 0x95555555, 0x00000000, 0x00000000,
  0x15555554, 0xa6666666, 0x00000000, 0x00000000,
  0x26666665, 0xbfffc000, 0x00000000, 0x00000000,
  0x3fffbfff, 0xbfffc000, 0x00000000, 0x00000000,
  0x3fffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0x3fffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0x3fffc001, 0xbfffffc0, 0x00000000, 0x00000000,
  0x3fffffbf, 0xbfffffc0, 0x00000000, 0x00000000,
  0x3fffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0x3fffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0x3fffffc1, 0xbffffff0, 0x00000000, 0x00000000,
  0x3fffffef, 0xbffffffe, 0x00000000, 0x00000000,
  0xbffffffe, 0xbfffffff, 0x00000000, 0x00000000,
  0xbfffffff, 0xc0000000, 0x00000000, 0x00000000,
  0xbfffffff, 0xc0000000, 0x00000000, 0x00000000,
  0xc0000000, 0xc0000001, 0x00000000, 0x00000000,
  0xc0000000, 0xc0000001, 0x00000000, 0x00000000,
  0xc0000001, 0xc0000010, 0x00000000, 0x00000000,
  0xc0000010, 0xc000003f, 0x00000000, 0x00000000,
  0xc000003e, 0xc000003f, 0x00000000, 0x00000000,
  0xc000003f, 0xc0000040, 0x00000000, 0x00000000,
  0xc000003f, 0xc0003fff, 0x00000000, 0x00000000,
  0xc0003ffe, 0xc0003fff, 0x00000000, 0x00000000,
  0xc0003fff, 0xc0004000, 0x00000000, 0x00000000,
  0xc0003fff, 0xd999999a, 0x00000000, 0x00000000,
  0xd9999999, 0xeaaaaaab, 0x00000000, 0x00000000,
  0xeaaaaaaa, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x80000000, 0x00000000, 0x00000000,
  0x80000000, 0x80000001, 0x00000000, 0x00000000,
  0x80000000, 0x95555555, 0x00000000, 0x00000000,
  0x95555555, 0xa6666666, 0x00000000, 0x00000000,
  0xa6666666, 0xbfffc000, 0x00000000, 0x00000000,
  0xbfffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0xbfffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0xbfffc001, 0xbfffc002, 0x00000000, 0x00000000,
  0xbfffc001, 0xbfffffc0, 0x00000000, 0x00000000,
  0xbfffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0xbfffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0xbfffffc1, 0xbfffffc2, 0x00000000, 0x00000000,
  0xbfffffc1, 0xbffffff0, 0x00000000, 0x00000000,
  0xbffffff0, 0xbfffffff, 0x00000000, 0x00000000,
  0xbfffffff, 0xd5555554, 0x00000000, 0x00000000,
  0xbfffffff, 0xd5555554, 0x00000000, 0x00000000,
  0xc0000000, 0xd5555555, 0x00000000, 0x00000000,
  0xc0000000, 0xd5555555, 0x00000000, 0x00000000,
  0xc0000001, 0xd5555556, 0x00000000, 0x00000000,
  0xc0000001, 0xd5555565, 0x00000000, 0x00000000,
  0xc0000010, 0xd5555593, 0x00000000, 0x00000000,
  0xc000003f, 0xd5555594, 0x00000000, 0x00000000,
  0xc000003f, 0xd5555594, 0x00000000, 0x00000000,
  0xc0000040, 0xd5559553, 0x00000000, 0x00000000,
  0xc0003fff, 0xd5559554, 0x00000000, 0x00000000,
  0xc0003fff, 0xd5559554, 0x00000000, 0x00000000,
  0xc0004000, 0xeeeeeeee, 0x00000000, 0x00000000,
  0xd999999a, 0xffffffff, 0x00000000, 0x00000000,
  0xeaaaaaab, 0x15555553, 0x00000000, 0x00000000,
  0xffffffff, 0x15555554, 0x00000000, 0x00000000,
  0xffffffff, 0x15555554, 0x00000000, 0x00000000,
  0x00000000, 0x95555555, 0x00000000, 0x00000000,
  0x80000000, 0x95555555, 0x00000000, 0x00000000,
  0x80000001, 0xaaaaaaaa, 0x00000000, 0x00000000,
  0x95555555, 0xbbbbbbbb, 0x00000000, 0x00000000,
  0xa6666666, 0xd5551555, 0x00000000, 0x00000000,
  0xbfffc000, 0xd5551555, 0x00000000, 0x00000000,
  0xbfffc001, 0xd5551556, 0x00000000, 0x00000000,
  0xbfffc001, 0xd5551556, 0x00000000, 0x00000000,
  0xbfffc002, 0xd5555515, 0x00000000, 0x00000000,
  0xbfffffc0, 0xd5555515, 0x00000000, 0x00000000,
  0xbfffffc1, 0xd5555516, 0x00000000, 0x00000000,
  0xbfffffc1, 0xd5555516, 0x00000000, 0x00000000,
  0xbfffffc2, 0xd5555545, 0x00000000, 0x00000000,
  0xbffffff0, 0xd5555553, 0x00000000, 0x00000000,
  0xd5555553, 0xe6666665, 0x00000000, 0x00000000,
  0xd5555554, 0xe6666665, 0x00000000, 0x00000000,
  0xd5555554, 0xe6666666, 0x00000000, 0x00000000,
  0xd5555555, 0xe6666666, 0x00000000, 0x00000000,
  0xd5555555, 0xe6666667, 0x00000000, 0x00000000,
  0xd5555556, 0xe6666676, 0x00000000, 0x00000000,
  0xd5555565, 0xe66666a4, 0x00000000, 0x00000000,
  0xd5555593, 0xe66666a5, 0x00000000, 0x00000000,
  0xd5555594, 0xe66666a5, 0x00000000, 0x00000000,
  0xd5555594, 0xe666a664, 0x00000000, 0x00000000,
  0xd5559553, 0xe666a665, 0x00000000, 0x00000000,
  0xd5559554, 0xe666a665, 0x00000000, 0x00000000,
  0xd5559554, 0xffffffff, 0x00000000, 0x00000000,
  0xeeeeeeee, 0x11111110, 0x00000000, 0x00000000,
  0xffffffff, 0x26666664, 0x00000000, 0x00000000,
  0x15555553, 0x26666665, 0x00000000, 0x00000000,
  0x15555554, 0x26666665, 0x00000000, 0x00000000,
  0x15555554, 0xa6666666, 0x00000000, 0x00000000,
  0x95555555, 0xa6666666, 0x00000000, 0x00000000,
  0x95555555, 0xbbbbbbbb, 0x00000000, 0x00000000,
  0xaaaaaaaa, 0xcccccccc, 0x00000000, 0x00000000,
  0xbbbbbbbb, 0xe6662666, 0x00000000, 0x00000000,
  0xd5551555, 0xe6662666, 0x00000000, 0x00000000,
  0xd5551555, 0xe6662667, 0x00000000, 0x00000000,
  0xd5551556, 0xe6662667, 0x00000000, 0x00000000,
  0xd5551556, 0xe6666626, 0x00000000, 0x00000000,
  0xd5555515, 0xe6666626, 0x00000000, 0x00000000,
  0xd5555515, 0xe6666627, 0x00000000, 0x00000000,
  0xd5555516, 0xe6666627, 0x00000000, 0x00000000,
  0xd5555516, 0xe6666656, 0x00000000, 0x00000000,
  0xd5555545, 0xe6666664, 0x00000000, 0x00000000,
  0xe6666664, 0xffffbfff, 0x00000000, 0x00000000,
  0xe6666665, 0xffffbfff, 0x00000000, 0x00000000,
  0xe6666665, 0xffffc000, 0x00000000, 0x00000000,
  0xe6666666, 0xffffc000, 0x00000000, 0x00000000,
  0xe6666666, 0xffffc001, 0x00000000, 0x00000000,
  0xe6666667, 0xffffc010, 0x00000000, 0x00000000,
  0xe6666676, 0xffffc03e, 0x00000000, 0x00000000,
  0xe66666a4, 0xffffc03f, 0x00000000, 0x00000000,
  0xe66666a5, 0xffffc03f, 0x00000000, 0x00000000,
  0xe66666a5, 0xfffffffe, 0x00000000, 0x00000000,
  0xe666a664, 0xffffffff, 0x00000000, 0x00000000,
  0xe666a665, 0xffffffff, 0x00000000, 0x00000000,
  0xe666a665, 0x19995999, 0x00000000, 0x00000000,
  0xffffffff, 0x2aaa6aaa, 0x00000000, 0x00000000,
  0x11111110, 0x3fffbffe, 0x00000000, 0x00000000,
  0x26666664, 0x3fffbfff, 0x00000000, 0x00000000,
  0x26666665, 0x3fffbfff, 0x00000000, 0x00000000,
  0x26666665, 0xbfffc000, 0x00000000, 0x00000000,
  0xa6666666, 0xbfffc000, 0x00000000, 0x00000000,
  0xa6666666, 0xd5551555, 0x00000000, 0x00000000,
  0xbbbbbbbb, 0xe6662666, 0x00000000, 0x00000000,
  0xcccccccc, 0xffff8000, 0x00000000, 0x00000000,
  0xe6662666, 0xffff8000, 0x00000000, 0x00000000,
  0xe6662666, 0xffff8001, 0x00000000, 0x00000000,
  0xe6662667, 0xffff8001, 0x00000000, 0x00000000,
  0xe6662667, 0xffffbfc0, 0x00000000, 0x00000000,
  0xe6666626, 0xffffbfc0, 0x00000000, 0x00000000,
  0xe6666626, 0xffffbfc1, 0x00000000, 0x00000000,
  0xe6666627, 0xffffbfc1, 0x00000000, 0x00000000,
  0xe6666627, 0xffffbff0, 0x00000000, 0x00000000,
  0xe6666656, 0xffffbffe, 0x00000000, 0x00000000,
  0xffffbffe, 0xffffbfff, 0x00000000, 0x00000000,
  0xffffbfff, 0xffffc000, 0x00000000, 0x00000000,
  0xffffbfff, 0xffffc000, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc010, 0x00000000, 0x00000000,
  0xffffc010, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc03e, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x1999599a, 0x00000000, 0x00000000,
  0x19995999, 0x2aaa6aab, 0x00000000, 0x00000000,
  0x2aaa6aaa, 0x3fffbfff, 0x00000000, 0x00000000,
  0x3fffbffe, 0x3fffbfff, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffbfff, 0xbfffc000, 0x00000000, 0x00000000,
  0xbfffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0xbfffc000, 0xd5551555, 0x00000000, 0x00000000,
  0xd5551555, 0xe6662666, 0x00000000, 0x00000000,
  0xe6662666, 0xffff8000, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0x00000000, 0x00000000,
  0xffff8001, 0xffff8002, 0x00000000, 0x00000000,
  0xffff8001, 0xffffbfc0, 0x00000000, 0x00000000,
  0xffffbfc0, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc0, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbff0, 0x00000000, 0x00000000,
  0xffffbff0, 0xffffbfff, 0x00000000, 0x00000000,
  0xffffbfff, 0xffffc000, 0x00000000, 0x00000000,
  0xffffbfff, 0xffffc000, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc002, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc011, 0x00000000, 0x00000000,
  0xffffc010, 0xffffc03f, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x1999599a, 0x00000000, 0x00000000,
  0x1999599a, 0x2aaa6aab, 0x00000000, 0x00000000,
  0x2aaa6aab, 0x3fffbfff, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0xbfffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0xbfffc001, 0xd5551556, 0x00000000, 0x00000000,
  0xd5551555, 0xe6662667, 0x00000000, 0x00000000,
  0xe6662666, 0xffff8001, 0x00000000, 0x00000000,
  0xffff8000, 0xffff8001, 0x00000000, 0x00000000,
  0xffff8001, 0xffff8002, 0x00000000, 0x00000000,
  0xffff8001, 0xffff8002, 0x00000000, 0x00000000,
  0xffff8002, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc0, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffbff1, 0x00000000, 0x00000000,
  0xffffbff0, 0xffffbfff, 0x00000000, 0x00000000,
  0xffffbfff, 0xffffc000, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc000, 0xffffc001, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc002, 0x00000000, 0x00000000,
  0xffffc001, 0xffffc002, 0x00000000, 0x00000000,
  0xffffc002, 0xffffc011, 0x00000000, 0x00000000,
  0xffffc011, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc03f, 0xffffc040, 0x00000000, 0x00000000,
  0xffffc040, 0xffffc041, 0x00000000, 0x00000000,
  0xffffc040, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x1999599b, 0x00000000, 0x00000000,
  0x1999599a, 0x2aaa6aac, 0x00000000, 0x00000000,
  0x2aaa6aab, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffbfff, 0x3fffc000, 0x00000000, 0x00000000,
  0x3fffc000, 0x3fffc001, 0x00000000, 0x00000000,
  0x3fffc000, 0xbfffc001, 0x00000000, 0x00000000,
  0xbfffc001, 0xbfffc002, 0x00000000, 0x00000000,
  0xbfffc001, 0xd5551556, 0x00000000, 0x00000000,
  0xd5551556, 0xe6662667, 0x00000000, 0x00000000,
  0xe6662667, 0xffff8001, 0x00000000, 0x00000000,
  0xffff8001, 0xffff8002, 0x00000000, 0x00000000,
  0xffff8001, 0xffff8002, 0x00000000, 0x00000000,
  0xffff8002, 0xffff8003, 0x00000000, 0x00000000,
  0xffff8002, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffbfc3, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffbff1, 0x00000000, 0x00000000,
  0xffffbff1, 0xffffc000, 0x00000000, 0x00000000,
  0xffffc000, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffc000, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffc001, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffc001, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffc002, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffc002, 0xffffffd0, 0x00000000, 0x00000000,
  0xffffc011, 0xfffffffe, 0x00000000, 0x00000000,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000000,
  0xffffc040, 0xffffffff, 0x00000000, 0x00000000,
  0xffffc041, 0x00003fbe, 0x00000000, 0x00000000,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00000001, 0x19999959, 0x00000000, 0x00000000,
  0x1999599b, 0x2aaaaa6a, 0x00000000, 0x00000000,
  0x2aaa6aac, 0x3fffffbe, 0x00000000, 0x00000000,
  0x3fffc000, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffc000, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffc001, 0xbfffffc0, 0x00000000, 0x00000000,
  0xbfffc001, 0xbfffffc0, 0x00000000, 0x00000000,
  0xbfffc002, 0xd5555515, 0x00000000, 0x00000000,
  0xd5551556, 0xe6666626, 0x00000000, 0x00000000,
  0xe6662667, 0xffffbfc0, 0x00000000, 0x00000000,
  0xffff8001, 0xffffbfc0, 0x00000000, 0x00000000,
  0xffff8002, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffff8002, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffff8003, 0xffffff80, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffff80, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffff81, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffff81, 0x00000000, 0x00000000,
  0xffffbfc3, 0xffffffb0, 0x00000000, 0x00000000,
  0xffffbff1, 0xffffffbe, 0x00000000, 0x00000000,
  0xffffffbe, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffffbf, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffbf, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffd0, 0x00000000, 0x00000000,
  0xffffffd0, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003fbe, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fbf, 0x1999995a, 0x00000000, 0x00000000,
  0x19999959, 0x2aaaaa6b, 0x00000000, 0x00000000,
  0x2aaaaa6a, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffffbe, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffbf, 0xbfffffc0, 0x00000000, 0x00000000,
  0xbfffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0xbfffffc0, 0xd5555515, 0x00000000, 0x00000000,
  0xd5555515, 0xe6666626, 0x00000000, 0x00000000,
  0xe6666626, 0xffffbfc0, 0x00000000, 0x00000000,
  0xffffbfc0, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc0, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffff80, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff81, 0xffffff82, 0x00000000, 0x00000000,
  0xffffff81, 0xffffffb0, 0x00000000, 0x00000000,
  0xffffffb0, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffffbf, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffbf, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffc2, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffd1, 0x00000000, 0x00000000,
  0xffffffd0, 0xffffffff, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fc0, 0x1999995a, 0x00000000, 0x00000000,
  0x1999995a, 0x2aaaaa6b, 0x00000000, 0x00000000,
  0x2aaaaa6b, 0x3fffffbf, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0xbfffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0xbfffffc1, 0xd5555516, 0x00000000, 0x00000000,
  0xd5555515, 0xe6666627, 0x00000000, 0x00000000,
  0xe6666626, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc0, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff80, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff81, 0xffffff82, 0x00000000, 0x00000000,
  0xffffff81, 0xffffff82, 0x00000000, 0x00000000,
  0xffffff82, 0xffffffb1, 0x00000000, 0x00000000,
  0xffffffb0, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffffbf, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffc1, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffc2, 0x00000000, 0x00000000,
  0xffffffc1, 0xffffffc2, 0x00000000, 0x00000000,
  0xffffffc2, 0xffffffd1, 0x00000000, 0x00000000,
  0xffffffd1, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000001, 0x00000000, 0x00000000,
  0x00000000, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fbf, 0x00003fc0, 0x00000000, 0x00000000,
  0x00003fc0, 0x00003fc1, 0x00000000, 0x00000000,
  0x00003fc0, 0x1999995b, 0x00000000, 0x00000000,
  0x1999995a, 0x2aaaaa6c, 0x00000000, 0x00000000,
  0x2aaaaa6b, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffbf, 0x3fffffc0, 0x00000000, 0x00000000,
  0x3fffffc0, 0x3fffffc1, 0x00000000, 0x00000000,
  0x3fffffc0, 0xbfffffc1, 0x00000000, 0x00000000,
  0xbfffffc1, 0xbfffffc2, 0x00000000, 0x00000000,
  0xbfffffc1, 0xd5555516, 0x00000000, 0x00000000,
  0xd5555516, 0xe6666627, 0x00000000, 0x00000000,
  0xe6666627, 0xffffbfc1, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbfc2, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffbfc3, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffff81, 0x00000000, 0x00000000,
  0xffffff81, 0xffffff82, 0x00000000, 0x00000000,
  0xffffff81, 0xffffff82, 0x00000000, 0x00000000,
  0xffffff82, 0xffffff83, 0x00000000, 0x00000000,
  0xffffff82, 0xffffffb1, 0x00000000, 0x00000000,
  0xffffffb1, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffef, 0x00000000, 0x00000000,
  0xffffffc0, 0xffffffef, 0x00000000, 0x00000000,
  0xffffffc1, 0xfffffff0, 0x00000000, 0x00000000,
  0xffffffc1, 0xfffffff0, 0x00000000, 0x00000000,
  0xffffffc2, 0xfffffff1, 0x00000000, 0x00000000,
  0xffffffc2, 0x00000000, 0x00000000, 0x00000000,
  0xffffffd1, 0x0000002e, 0x00000000, 0x00000000,
  0x00000000, 0x0000002f, 0x00000000, 0x00000000,
  0x00000000, 0x0000002f, 0x00000000, 0x00000000,
  0x00000001, 0x00003fee, 0x00000000, 0x00000000,
  0x00003fc0, 0x00003fef, 0x00000000, 0x00000000,
  0x00003fc0, 0x00003fef, 0x00000000, 0x00000000,
  0x00003fc1, 0x19999989, 0x00000000, 0x00000000,
  0x1999995b, 0x2aaaaa9a, 0x00000000, 0x00000000,
  0x2aaaaa6c, 0x3fffffee, 0x00000000, 0x00000000,
  0x3fffffc0, 0x3fffffef, 0x00000000, 0x00000000,
  0x3fffffc0, 0x3fffffef, 0x00000000, 0x00000000,
  0x3fffffc1, 0xbffffff0, 0x00000000, 0x00000000,
  0xbfffffc1, 0xbffffff0, 0x00000000, 0x00000000,
  0xbfffffc2, 0xd5555545, 0x00000000, 0x00000000,
  0xd5555516, 0xe6666656, 0x00000000, 0x00000000,
  0xe6666627, 0xffffbff0, 0x00000000, 0x00000000,
  0xffffbfc1, 0xffffbff0, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffbff1, 0x00000000, 0x00000000,
  0xffffbfc2, 0xffffbff1, 0x00000000, 0x00000000,
  0xffffbfc3, 0xffffffb0, 0x00000000, 0x00000000,
  0xffffff81, 0xffffffb0, 0x00000000, 0x00000000,
  0xffffff82, 0xffffffb1, 0x00000000, 0x00000000,
  0xffffff82, 0xffffffb1, 0x00000000, 0x00000000,
  0xffffff83, 0xffffffe0, 0x00000000, 0x00000000,
  0xffffffb1, 0xffffffee, 0x00000000, 0x00000000,
  0xffffffee, 0xfffffffd, 0x00000000, 0x00000000,
  0xffffffef, 0xfffffffe, 0x00000000, 0x00000000,
  0xffffffef, 0xfffffffe, 0x00000000, 0x00000000,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffff0, 0xffffffff, 0x00000000, 0x00000000,
  0xfffffff1, 0x0000000e, 0x00000000, 0x00000000,
  0x00000000, 0x0000003d, 0x00000000, 0x00000000,
  0x0000002e, 0x0000003d, 0x00000000, 0x00000000,
  0x0000002f, 0x0000003e, 0x00000000, 0x00000000,
  0x0000002f, 0x00003ffd, 0x00000000, 0x00000000,
  0x00003fee, 0x00003ffd, 0x00000000, 0x00000000,
  0x00003fef, 0x00003ffe, 0x00000000, 0x00000000,
  0x00003fef, 0x19999998, 0x00000000, 0x00000000,
  0x19999989, 0x2aaaaaa9, 0x00000000, 0x00000000,
  0x2aaaaa9a, 0x3ffffffd, 0x00000000, 0x00000000,
  0x3fffffee, 0x3ffffffd, 0x00000000, 0x00000000,
  0x3fffffef, 0x3ffffffe, 0x00000000, 0x00000000,
  0x3fffffef, 0xbffffffe, 0x00000000, 0x00000000,
  0xbffffff0, 0xbfffffff, 0x00000000, 0x00000000,
  0xbffffff0, 0xd5555553, 0x00000000, 0x00000000,
  0xd5555545, 0xe6666664, 0x00000000, 0x00000000,
  0xe6666656, 0xffffbffe, 0x00000000, 0x00000000,
  0xffffbff0, 0xffffbfff, 0x00000000, 0x00000000,
  0xffffbff0, 0xffffbfff, 0x00000000, 0x00000000,
  0xffffbff1, 0xffffc000, 0x00000000, 0x00000000,
  0xffffbff1, 0xffffffbe, 0x00000000, 0x00000000,
  0xffffffb0, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffffb0, 0xffffffbf, 0x00000000, 0x00000000,
  0xffffffb1, 0xffffffc0, 0x00000000, 0x00000000,
  0xffffffb1, 0xffffffee, 0x00000000, 0x00000000,
  0xffffffe0, 0xfffffffd, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_shadd_2S = 961;

#endif  // VIXL_SIM_SHADD_2S_TRACE_AARCH64_H_
