/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

public class VertexData {
    static final byte COORD_ONLY = 1;
    static final byte COLOR_ONLY = 2;
    static final byte TEXTURE_ONLY = 3;
    static final byte TEXTURE_AND_COLOR = 4;
    final byte dataType;
    private float[] coords;
    private byte[] colors;
    private float[] textureCoords;
    private int index;
    private int texIndex;

    public VertexData(int n, boolean bl, boolean bl2) {
        this.coords = new float[n * n * 2 * 3 * 3];
        if (bl) {
            this.textureCoords = new float[n * n * 2 * 3 * 2];
        }
        if (bl2) {
            this.colors = new byte[this.coords.length];
        }
        int n2 = 1;
        n2 = (byte)(n2 + (bl2 ? 1 : 0));
        n2 = (byte)(n2 + (bl ? 2 : 0));
        this.dataType = (byte)n2;
    }

    public float[] getCoords() {
        return this.coords;
    }

    public byte[] getColors() {
        return this.colors;
    }

    public float[] getTextureCoords() {
        return this.textureCoords;
    }

    void addVertex(float f, float f2, float f3) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        this.index += 3;
    }

    void addVertex(float f, float f2, float f3, byte by, byte by2, byte by3) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        if (this.dataType != 2 && this.dataType != 4) {
            System.out.println("Setting color on a uncolored object");
        } else {
            this.colors[this.index] = by;
            this.colors[this.index + 1] = by2;
            this.colors[this.index + 2] = by3;
        }
        this.index += 3;
    }

    void addVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        byte by = (byte)(f4 * 255.0f);
        byte by2 = (byte)(f5 * 255.0f);
        byte by3 = (byte)(f6 * 255.0f);
        this.addVertex(f, f2, f3, by, by2, by3);
    }

    void addVertex(float f, float f2, float f3, float f4, float f5) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        if (this.dataType != 3 && this.dataType != 4) {
            System.out.println("Setting texture coords in untextured object");
        } else {
            this.textureCoords[this.texIndex++] = f4;
            this.textureCoords[this.texIndex++] = f5;
        }
        this.index += 3;
    }

    void addVertex(float f, float f2, float f3, byte by, byte by2, byte by3, float f4, float f5) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        if (this.dataType != 2 && this.dataType != 4) {
            System.out.println("Setting color on a uncolored object");
        } else {
            this.colors[this.index] = by;
            this.colors[this.index + 1] = by2;
            this.colors[this.index + 2] = by3;
        }
        this.index += 3;
        if (this.dataType != 3 && this.dataType != 4) {
            System.out.println("Setting texture coords in untextured object");
        } else {
            this.textureCoords[this.texIndex++] = f4;
            this.textureCoords[this.texIndex++] = f5;
        }
    }

    void addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        byte by = (byte)(f4 * 255.0f);
        byte by2 = (byte)(f5 * 255.0f);
        byte by3 = (byte)(f6 * 255.0f);
        this.addVertex(f, f2, f3, by, by2, by3, f7, f8);
    }

    public int getVertexCount() {
        return this.index / 3;
    }

    void reset() {
        this.index = 0;
        this.texIndex = 0;
    }
}

