/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.util.EmptyStackException;

public class IntStack {
    private static final int STACK_START_SIZE = 20;
    private static final int STACK_INCREMENT = 5;
    private int[] stackContents;
    private int topOfStack;

    public IntStack() {
        this(20);
    }

    public IntStack(int n) {
        this.stackContents = new int[n];
        this.topOfStack = -1;
    }

    public int size() {
        return this.topOfStack + 1;
    }

    public boolean isEmpty() {
        return this.topOfStack == -1;
    }

    public void push(int n) {
        this.resizeStack();
        this.stackContents[++this.topOfStack] = n;
    }

    public int peek() throws EmptyStackException {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        return this.stackContents[this.topOfStack];
    }

    public int pop() {
        if (this.topOfStack == -1) {
            throw new EmptyStackException();
        }
        int n = this.stackContents[this.topOfStack];
        --this.topOfStack;
        return n;
    }

    public void clear() {
        this.topOfStack = -1;
    }

    private final void resizeStack() {
        int n = this.stackContents.length;
        if (this.topOfStack + 1 == n) {
            int n2 = n + 5;
            int[] nArray = new int[n2];
            System.arraycopy(this.stackContents, 0, nArray, 0, n);
            this.stackContents = nArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IntStack: size: ");
        stringBuffer.append(this.topOfStack + 1);
        stringBuffer.append(" vals: ");
        for (int i = 0; i <= this.topOfStack; ++i) {
            stringBuffer.append(this.stackContents[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

