/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.web3d.util.HashSet;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.export.MutableInteger;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;

public class StatisticsCollector
implements StringContentHandler,
ProtoHandler,
ScriptHandler,
Comparator {
    private int totalNodeCount = 0;
    private int totalFieldCount = 0;
    private HashMap nodeNum = new HashMap(128);
    private HashMap defNum = new HashMap(128);
    private int lastDef = 0;
    private int lastNode = 0;
    protected HashMap protoMap;
    protected HashMap externProtoMap;
    private boolean parsing = false;
    private HashMap counts = new HashMap(128);
    private HashMap nodeFieldMap;
    private int[] fieldCounts = new int[31];
    private int maxFieldCount;
    private int externProtoCount;
    private int protoCount;
    private SimpleStack fieldCountStack = new SimpleStack();
    private SimpleStack fieldNamesStack = new SimpleStack();
    private SimpleStack nodeNumStack = new SimpleStack();

    public StatisticsCollector() {
        this.nodeFieldMap = new HashMap(128);
    }

    public HashMap getNodeTable() {
        return this.nodeNum;
    }

    public HashMap getFieldTable() {
        return this.nodeFieldMap;
    }

    public HashMap getDEFTable() {
        return this.defNum;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        this.parsing = true;
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
    }

    public void endDocument() throws SAVException, VRMLException {
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        Integer n;
        Integer n2 = (Integer)this.nodeNum.get(string);
        if (n2 == null) {
            ++this.lastNode;
            n2 = new Integer(this.lastNode);
            this.nodeNum.put(string, n2);
        }
        if ((n = (Integer)this.counts.get(string)) != null) {
            int n3 = n;
            n = new Integer(++n3);
            this.counts.put(string, n);
        } else {
            n = new Integer(1);
            this.counts.put(string, n);
        }
        ++this.totalNodeCount;
        if (string2 != null && this.defNum.get(string2) == null) {
            ++this.lastDef;
            this.defNum.put(string2, new Integer(this.lastDef));
        }
        this.fieldCountStack.push(new MutableInteger(0));
        this.fieldNamesStack.push(new HashSet());
        this.nodeNumStack.push(n2);
    }

    public void endNode() throws SAVException, VRMLException {
        HashSet hashSet;
        MutableInteger mutableInteger = (MutableInteger)this.fieldCountStack.pop();
        int n = mutableInteger.intValue();
        if (n > this.maxFieldCount) {
            this.maxFieldCount = n;
        }
        HashSet hashSet2 = (HashSet)this.fieldNamesStack.pop();
        Integer n2 = (Integer)this.nodeNumStack.pop();
        if (n2 == null) {
            System.out.println("***Error in end node no nodeNumStack entry");
        }
        if ((hashSet = (HashSet)this.nodeFieldMap.get(n2)) == null) {
            this.nodeFieldMap.put(n2, hashSet2);
        } else {
            hashSet.addAll(hashSet2);
        }
    }

    public void startField(String string) throws SAVException, VRMLException {
        ++this.totalFieldCount;
        HashSet hashSet = (HashSet)this.fieldNamesStack.peek();
        if (!hashSet.contains(string)) {
            hashSet.add(string);
            MutableInteger mutableInteger = (MutableInteger)this.fieldCountStack.peek();
            mutableInteger.inc();
        }
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
    }

    public void useDecl(String string) throws SAVException, VRMLException {
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        ++this.protoCount;
        Integer n = (Integer)this.nodeNum.get(string);
        if (n == null) {
            this.nodeNum.put(string, new Integer(this.lastNode++));
        }
    }

    public void endProtoDecl() throws SAVException, VRMLException {
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
    }

    public void startProtoBody() throws SAVException, VRMLException {
    }

    public void endProtoBody() throws SAVException, VRMLException {
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        ++this.externProtoCount;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
    }

    public void startScriptDecl() throws SAVException, VRMLException {
    }

    public void endScriptDecl() throws SAVException, VRMLException {
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
    }

    public int compare(Object object, Object object2) {
        Integer n = (Integer)((Map.Entry)object).getValue();
        Integer n2 = (Integer)((Map.Entry)object2).getValue();
        return n2 - n;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public void printStats() {
        System.out.println("Total Node Count: " + this.totalNodeCount);
        System.out.println("Total Field Count: " + this.totalFieldCount);
        System.out.println("Number of native Node Types: " + this.counts.size());
        System.out.println("Number of PROTO Node Types: " + this.protoCount + " total: " + (this.counts.size() + this.protoCount));
        System.out.println("Maximum number of fields in a node: " + this.maxFieldCount);
        System.out.println("DEFed nodes: " + this.lastDef);
        System.out.println();
        Set set = this.counts.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry[] entryArray = new Map.Entry[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            entryArray[n++] = iterator.next();
        }
        Arrays.sort(entryArray, this);
        for (n = 0; n < entryArray.length; ++n) {
            System.out.println(entryArray[n]);
        }
    }

    public int getNativeNodeTypeCount() {
        return this.counts.size();
    }

    public int getProtoTypeCount() {
        return this.protoCount + this.externProtoCount;
    }

    public int getMaxFieldCount() {
        return this.maxFieldCount;
    }

    public int getDEFCount() {
        return this.lastDef;
    }
}

