/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.layering;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLayerNodeType;
import org.web3d.vrml.nodes.VRMLLayerSetNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseLayerSet
extends AbstractNode
implements VRMLLayerSetNodeType {
    protected static final int FIELD_LAYERS = 1;
    protected static final int FIELD_ACTIVE_LAYER = 2;
    protected static final int FIELD_ORDER = 3;
    protected static final int LAST_LAYERSET_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    protected static final String LAYER_PROTO_MSG = "Proto does not describe a Layer object";
    protected static final String LAYER_NODE_MSG = "Node does not describe a Layer object";
    private static final String NEGATIVE_ORDER_ERR = "The order field of LayerSet cannot contain negative values.";
    private static final String INVALID_ORDER_IDX_ERR = "One or more order index values in this LayerSet is greater than the number of Layer nodes provided: ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected ArrayList vfLayers;
    protected int vfActiveLayer = 0;
    protected int[] vfOrder = FieldConstants.EMPTY_MFINT32;
    private int layerCount;
    private int numOrder;
    private boolean renderOrderChanged = false;
    private boolean layerListChanged = false;

    protected BaseLayerSet() {
        super("LayerSet");
        this.vfLayers = new ArrayList();
        this.hasChanged = new boolean[4];
    }

    protected BaseLayerSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public void allEventsComplete() {
        int n = this.vfLayers.size() + 1;
        for (int i = 0; i < this.numOrder; ++i) {
            if (this.vfOrder[i] < n) continue;
            this.errorReporter.errorReport(INVALID_ORDER_IDX_ERR + this.vfOrder[i], null);
        }
    }

    public VRMLNodeType[] getLayers() {
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfLayers.size()];
        this.vfLayers.toArray(vRMLNodeTypeArray);
        return vRMLNodeTypeArray;
    }

    public void setLayers(VRMLNodeType[] vRMLNodeTypeArray) {
        this.clearChildren();
        if (vRMLNodeTypeArray == null) {
            return;
        }
        this.layerCount = 0;
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            this.addChildNode(vRMLNodeTypeArray[i]);
        }
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public int getActiveNavigationLayer() {
        return this.vfActiveLayer;
    }

    public int getNumRenderedLayers() {
        return this.numOrder;
    }

    public void getRenderOrder(int[] nArray) {
        System.arraycopy(this.vfOrder, 0, nArray, 0, this.numOrder);
    }

    public boolean hasLayerListChanged() {
        boolean bl = this.layerListChanged;
        this.layerListChanged = false;
        return bl;
    }

    public boolean hasRenderOrderChanged() {
        boolean bl = this.renderOrderChanged;
        this.renderOrderChanged = false;
        return bl;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return 4;
    }

    public int getPrimaryType() {
        return 90;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        for (int i = 0; i < this.vfLayers.size(); ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfLayers.get(i);
            vRMLNodeType.setupFinished();
        }
        this.allEventsComplete();
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                int n2 = this.vfLayers.size();
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
                this.vfLayers.toArray(vRMLNodeTypeArray);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = n2;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfOrder;
                vRMLFieldData.dataType = (short)9;
                vRMLFieldData.numElements = this.numOrder;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfActiveLayer;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    int n3 = this.vfLayers.size();
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n3];
                    this.vfLayers.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, n3);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfOrder, this.numOrder);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfActiveLayer);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (n == 2) {
            this.vfActiveLayer = n2;
            if (!this.inSetup) {
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
        } else {
            super.setValue(n, n2);
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (n == 3) {
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] >= 0) continue;
                throw new InvalidFieldValueException(NEGATIVE_ORDER_ERR);
            }
            if (this.vfOrder.length < n2) {
                this.vfOrder = new int[n2];
            }
            System.arraycopy(nArray, 0, this.vfOrder, 0, n2);
            this.numOrder = n2;
            this.renderOrderChanged = true;
            if (!this.inSetup) {
                this.stateManager.addEndOfThisFrameListener(this);
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
            }
        } else {
            super.setValue(n, nArray, n2);
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                if (vRMLNodeType != null) {
                    this.addChildNode(vRMLNodeType);
                }
                this.layerListChanged = true;
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener(this);
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearChildren();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                }
                this.layerListChanged = true;
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener(this);
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void clearChildren() {
        int n = this.vfLayers.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfLayers.get(i);
            this.stateManager.registerRemovedNode(vRMLNodeType);
        }
        this.layerCount = 0;
        this.vfLayers.clear();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLLayerNodeType vRMLLayerNodeType = null;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLLayerNodeType)) {
                throw new InvalidFieldValueException(LAYER_PROTO_MSG);
            }
            vRMLLayerNodeType = (VRMLLayerNodeType)vRMLNodeType2;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLLayerNodeType)) {
                throw new InvalidFieldValueException(LAYER_NODE_MSG);
            }
            vRMLLayerNodeType = (VRMLLayerNodeType)vRMLNodeType;
        }
        ++this.layerCount;
        vRMLLayerNodeType.setLayerId(this.layerCount);
        this.vfLayers.add(vRMLNodeType);
        if (!this.inSetup) {
            this.stateManager.registerAddedNode(vRMLNodeType);
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        --this.layerCount;
        if (!this.inSetup) {
            this.vfLayers.remove(vRMLNodeType);
        }
        if (!this.inSetup) {
            this.stateManager.registerRemovedNode(vRMLNodeType);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseLayerSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "layers");
        BaseLayerSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFInt32", "activeLayer");
        BaseLayerSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLayerSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFInt32", "order");
        Integer n = new Integer(1);
        fieldMap.put("layers", n);
        fieldMap.put("set_layers", n);
        fieldMap.put("layers_changed", n);
        n = new Integer(2);
        fieldMap.put("activeLayer", n);
        fieldMap.put("set_activeLayer", n);
        fieldMap.put("activeLayer_changed", n);
        n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("order", n);
        fieldMap.put("set_order", n);
        fieldMap.put("order_changed", n);
    }
}

