/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xfsm-client-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.xfce.Session.Client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XfsmDbusClient
 * @title: XfsmDbusClient
 * @short_description: Generated C code for the org.xfce.Session.Client D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.xfce.Session.Client ---- */

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_get_id_OUT_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_get_id_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_get_id_OUT_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_get_id =
{
  {
    -1,
    (gchar *) "GetID",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_get_id_OUT_ARG_pointers,
    NULL
  },
  "handle-get-id",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_get_state_OUT_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_get_state_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_get_state_OUT_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_get_state =
{
  {
    -1,
    (gchar *) "GetState",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_get_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_get_all_sm_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_get_all_sm_properties_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_get_all_sm_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_get_all_sm_properties =
{
  {
    -1,
    (gchar *) "GetAllSmProperties",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_get_all_sm_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-all-sm-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_get_sm_properties_IN_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_get_sm_properties_IN_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_get_sm_properties_IN_ARG_names.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_get_sm_properties_OUT_ARG_values =
{
  {
    -1,
    (gchar *) "values",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_get_sm_properties_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_get_sm_properties_OUT_ARG_values.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_get_sm_properties =
{
  {
    -1,
    (gchar *) "GetSmProperties",
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_get_sm_properties_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_get_sm_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-sm-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_set_sm_properties_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_set_sm_properties_IN_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_set_sm_properties_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_set_sm_properties =
{
  {
    -1,
    (gchar *) "SetSmProperties",
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_set_sm_properties_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-sm-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_delete_sm_properties_IN_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_delete_sm_properties_IN_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_delete_sm_properties_IN_ARG_names.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_delete_sm_properties =
{
  {
    -1,
    (gchar *) "DeleteSmProperties",
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_delete_sm_properties_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-sm-properties",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_terminate =
{
  {
    -1,
    (gchar *) "Terminate",
    NULL,
    NULL,
    NULL
  },
  "handle-terminate",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_end_session_response_IN_ARG_is_ok =
{
  {
    -1,
    (gchar *) "is_ok",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_method_info_end_session_response_IN_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_method_info_end_session_response_IN_ARG_pointers[] =
{
  &_xfsm_dbus_client_method_info_end_session_response_IN_ARG_is_ok.parent_struct,
  &_xfsm_dbus_client_method_info_end_session_response_IN_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_client_method_info_end_session_response =
{
  {
    -1,
    (gchar *) "EndSessionResponse",
    (GDBusArgInfo **) &_xfsm_dbus_client_method_info_end_session_response_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-end-session-response",
  FALSE
};

static const GDBusMethodInfo * const _xfsm_dbus_client_method_info_pointers[] =
{
  &_xfsm_dbus_client_method_info_get_id.parent_struct,
  &_xfsm_dbus_client_method_info_get_state.parent_struct,
  &_xfsm_dbus_client_method_info_get_all_sm_properties.parent_struct,
  &_xfsm_dbus_client_method_info_get_sm_properties.parent_struct,
  &_xfsm_dbus_client_method_info_set_sm_properties.parent_struct,
  &_xfsm_dbus_client_method_info_delete_sm_properties.parent_struct,
  &_xfsm_dbus_client_method_info_terminate.parent_struct,
  &_xfsm_dbus_client_method_info_end_session_response.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_state_changed_ARG_old_state =
{
  {
    -1,
    (gchar *) "old_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_state_changed_ARG_new_state =
{
  {
    -1,
    (gchar *) "new_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_signal_info_state_changed_ARG_pointers[] =
{
  &_xfsm_dbus_client_signal_info_state_changed_ARG_old_state.parent_struct,
  &_xfsm_dbus_client_signal_info_state_changed_ARG_new_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_xfsm_dbus_client_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_sm_property_changed_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_sm_property_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_signal_info_sm_property_changed_ARG_pointers[] =
{
  &_xfsm_dbus_client_signal_info_sm_property_changed_ARG_name.parent_struct,
  &_xfsm_dbus_client_signal_info_sm_property_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_sm_property_changed =
{
  {
    -1,
    (gchar *) "SmPropertyChanged",
    (GDBusArgInfo **) &_xfsm_dbus_client_signal_info_sm_property_changed_ARG_pointers,
    NULL
  },
  "sm-property-changed"
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_sm_property_deleted_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_signal_info_sm_property_deleted_ARG_pointers[] =
{
  &_xfsm_dbus_client_signal_info_sm_property_deleted_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_sm_property_deleted =
{
  {
    -1,
    (gchar *) "SmPropertyDeleted",
    (GDBusArgInfo **) &_xfsm_dbus_client_signal_info_sm_property_deleted_ARG_pointers,
    NULL
  },
  "sm-property-deleted"
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_query_end_session_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_signal_info_query_end_session_ARG_pointers[] =
{
  &_xfsm_dbus_client_signal_info_query_end_session_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_query_end_session =
{
  {
    -1,
    (gchar *) "QueryEndSession",
    (GDBusArgInfo **) &_xfsm_dbus_client_signal_info_query_end_session_ARG_pointers,
    NULL
  },
  "query-end-session"
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_client_signal_info_end_session_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_client_signal_info_end_session_ARG_pointers[] =
{
  &_xfsm_dbus_client_signal_info_end_session_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_end_session =
{
  {
    -1,
    (gchar *) "EndSession",
    (GDBusArgInfo **) &_xfsm_dbus_client_signal_info_end_session_ARG_pointers,
    NULL
  },
  "end-session"
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_cancel_end_session =
{
  {
    -1,
    (gchar *) "CancelEndSession",
    NULL,
    NULL
  },
  "cancel-end-session"
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_client_signal_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL
  },
  "stop"
};

static const GDBusSignalInfo * const _xfsm_dbus_client_signal_info_pointers[] =
{
  &_xfsm_dbus_client_signal_info_state_changed.parent_struct,
  &_xfsm_dbus_client_signal_info_sm_property_changed.parent_struct,
  &_xfsm_dbus_client_signal_info_sm_property_deleted.parent_struct,
  &_xfsm_dbus_client_signal_info_query_end_session.parent_struct,
  &_xfsm_dbus_client_signal_info_end_session.parent_struct,
  &_xfsm_dbus_client_signal_info_cancel_end_session.parent_struct,
  &_xfsm_dbus_client_signal_info_stop.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xfsm_dbus_client_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "xfsm_client_dbus",
  NULL
};

static const GDBusAnnotationInfo _xfsm_dbus_client_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.ClientCSymbol",
  (gchar *) "xfsm_client_dbus_client",
  NULL
};

static const GDBusAnnotationInfo * const _xfsm_dbus_client_annotation_info_pointers[] =
{
  &_xfsm_dbus_client_annotation_info_0,
  &_xfsm_dbus_client_annotation_info_1,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xfsm_dbus_client_interface_info =
{
  {
    -1,
    (gchar *) "org.xfce.Session.Client",
    (GDBusMethodInfo **) &_xfsm_dbus_client_method_info_pointers,
    (GDBusSignalInfo **) &_xfsm_dbus_client_signal_info_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xfsm_dbus_client_annotation_info_pointers
  },
  "client",
};


/**
 * xfsm_dbus_client_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xfsm_dbus_client_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xfsm_dbus_client_interface_info.parent_struct;
}

/**
 * xfsm_dbus_client_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XfsmDbusClient interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xfsm_dbus_client_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XfsmDbusClient:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link>.
 */

/**
 * XfsmDbusClientIface:
 * @parent_iface: The parent interface.
 * @handle_delete_sm_properties: Handler for the #XfsmDbusClient::handle-delete-sm-properties signal.
 * @handle_end_session_response: Handler for the #XfsmDbusClient::handle-end-session-response signal.
 * @handle_get_all_sm_properties: Handler for the #XfsmDbusClient::handle-get-all-sm-properties signal.
 * @handle_get_id: Handler for the #XfsmDbusClient::handle-get-id signal.
 * @handle_get_sm_properties: Handler for the #XfsmDbusClient::handle-get-sm-properties signal.
 * @handle_get_state: Handler for the #XfsmDbusClient::handle-get-state signal.
 * @handle_set_sm_properties: Handler for the #XfsmDbusClient::handle-set-sm-properties signal.
 * @handle_terminate: Handler for the #XfsmDbusClient::handle-terminate signal.
 * @cancel_end_session: Handler for the #XfsmDbusClient::cancel-end-session signal.
 * @end_session: Handler for the #XfsmDbusClient::end-session signal.
 * @query_end_session: Handler for the #XfsmDbusClient::query-end-session signal.
 * @sm_property_changed: Handler for the #XfsmDbusClient::sm-property-changed signal.
 * @sm_property_deleted: Handler for the #XfsmDbusClient::sm-property-deleted signal.
 * @state_changed: Handler for the #XfsmDbusClient::state-changed signal.
 * @stop: Handler for the #XfsmDbusClient::stop signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link>.
 */

typedef XfsmDbusClientIface XfsmDbusClientInterface;
G_DEFINE_INTERFACE (XfsmDbusClient, xfsm_dbus_client, G_TYPE_OBJECT)

static void
xfsm_dbus_client_default_init (XfsmDbusClientIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XfsmDbusClient::handle-get-id:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.GetID">GetID()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_get_id() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-id",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_get_id),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusClient::handle-get-state:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.GetState">GetState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_get_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_get_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusClient::handle-get-all-sm-properties:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.GetAllSmProperties">GetAllSmProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_get_all_sm_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-all-sm-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_get_all_sm_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusClient::handle-get-sm-properties:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_names: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.GetSmProperties">GetSmProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_get_sm_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-sm-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_get_sm_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * XfsmDbusClient::handle-set-sm-properties:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.SetSmProperties">SetSmProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_set_sm_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-sm-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_set_sm_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * XfsmDbusClient::handle-delete-sm-properties:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_names: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.DeleteSmProperties">DeleteSmProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_delete_sm_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-sm-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_delete_sm_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * XfsmDbusClient::handle-terminate:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.Terminate">Terminate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_terminate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-terminate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_terminate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusClient::handle-end-session-response:
   * @object: A #XfsmDbusClient.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_is_ok: Argument passed by remote caller.
   * @arg_reason: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Client.EndSessionResponse">EndSessionResponse()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_client_complete_end_session_response() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-end-session-response",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, handle_end_session_response),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XfsmDbusClient::state-changed:
   * @object: A #XfsmDbusClient.
   * @arg_old_state: Argument.
   * @arg_new_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * XfsmDbusClient::sm-property-changed:
   * @object: A #XfsmDbusClient.
   * @arg_name: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.SmPropertyChanged">"SmPropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("sm-property-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, sm_property_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XfsmDbusClient::sm-property-deleted:
   * @object: A #XfsmDbusClient.
   * @arg_name: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.SmPropertyDeleted">"SmPropertyDeleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("sm-property-deleted",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, sm_property_deleted),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * XfsmDbusClient::query-end-session:
   * @object: A #XfsmDbusClient.
   * @arg_flags: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.QueryEndSession">"QueryEndSession"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("query-end-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, query_end_session),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UINT);

  /**
   * XfsmDbusClient::end-session:
   * @object: A #XfsmDbusClient.
   * @arg_flags: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.EndSession">"EndSession"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("end-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, end_session),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UINT);

  /**
   * XfsmDbusClient::cancel-end-session:
   * @object: A #XfsmDbusClient.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.CancelEndSession">"CancelEndSession"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("cancel-end-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, cancel_end_session),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * XfsmDbusClient::stop:
   * @object: A #XfsmDbusClient.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Client.Stop">"Stop"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusClientIface, stop),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * xfsm_dbus_client_emit_state_changed:
 * @object: A #XfsmDbusClient.
 * @arg_old_state: Argument to pass with the signal.
 * @arg_new_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_state_changed (
    XfsmDbusClient *object,
    guint arg_old_state,
    guint arg_new_state)
{
  g_signal_emit_by_name (object, "state-changed", arg_old_state, arg_new_state);
}

/**
 * xfsm_dbus_client_emit_sm_property_changed:
 * @object: A #XfsmDbusClient.
 * @arg_name: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.SmPropertyChanged">"SmPropertyChanged"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_sm_property_changed (
    XfsmDbusClient *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  g_signal_emit_by_name (object, "sm-property-changed", arg_name, arg_value);
}

/**
 * xfsm_dbus_client_emit_sm_property_deleted:
 * @object: A #XfsmDbusClient.
 * @arg_name: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.SmPropertyDeleted">"SmPropertyDeleted"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_sm_property_deleted (
    XfsmDbusClient *object,
    const gchar *arg_name)
{
  g_signal_emit_by_name (object, "sm-property-deleted", arg_name);
}

/**
 * xfsm_dbus_client_emit_query_end_session:
 * @object: A #XfsmDbusClient.
 * @arg_flags: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.QueryEndSession">"QueryEndSession"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_query_end_session (
    XfsmDbusClient *object,
    guint arg_flags)
{
  g_signal_emit_by_name (object, "query-end-session", arg_flags);
}

/**
 * xfsm_dbus_client_emit_end_session:
 * @object: A #XfsmDbusClient.
 * @arg_flags: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.EndSession">"EndSession"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_end_session (
    XfsmDbusClient *object,
    guint arg_flags)
{
  g_signal_emit_by_name (object, "end-session", arg_flags);
}

/**
 * xfsm_dbus_client_emit_cancel_end_session:
 * @object: A #XfsmDbusClient.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.CancelEndSession">"CancelEndSession"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_cancel_end_session (
    XfsmDbusClient *object)
{
  g_signal_emit_by_name (object, "cancel-end-session");
}

/**
 * xfsm_dbus_client_emit_stop:
 * @object: A #XfsmDbusClient.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Client.Stop">"Stop"</link> D-Bus signal.
 */
void
xfsm_dbus_client_emit_stop (
    XfsmDbusClient *object)
{
  g_signal_emit_by_name (object, "stop");
}

/**
 * xfsm_dbus_client_call_get_id:
 * @proxy: A #XfsmDbusClientProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetID">GetID()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_get_id_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_get_id_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_get_id (
    XfsmDbusClient *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetID",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_get_id_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_get_id().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_get_id().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_id_finish (
    XfsmDbusClient *proxy,
    gchar **out_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_id_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetID">GetID()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_get_id() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_id_sync (
    XfsmDbusClient *proxy,
    gchar **out_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetID",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_state:
 * @proxy: A #XfsmDbusClientProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetState">GetState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_get_state_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_get_state_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_get_state (
    XfsmDbusClient *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_get_state_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_get_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_get_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_state_finish (
    XfsmDbusClient *proxy,
    guint *out_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_state_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetState">GetState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_get_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_state_sync (
    XfsmDbusClient *proxy,
    guint *out_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_all_sm_properties:
 * @proxy: A #XfsmDbusClientProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetAllSmProperties">GetAllSmProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_get_all_sm_properties_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_get_all_sm_properties_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_get_all_sm_properties (
    XfsmDbusClient *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAllSmProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_get_all_sm_properties_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_get_all_sm_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_get_all_sm_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_all_sm_properties_finish (
    XfsmDbusClient *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_all_sm_properties_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetAllSmProperties">GetAllSmProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_get_all_sm_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_all_sm_properties_sync (
    XfsmDbusClient *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAllSmProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_sm_properties:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetSmProperties">GetSmProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_get_sm_properties_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_get_sm_properties_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_get_sm_properties (
    XfsmDbusClient *proxy,
    const gchar *const *arg_names,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSmProperties",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_get_sm_properties_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @out_values: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_get_sm_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_get_sm_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_sm_properties_finish (
    XfsmDbusClient *proxy,
    GVariant **out_values,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_values);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_get_sm_properties_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @out_values: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.GetSmProperties">GetSmProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_get_sm_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_get_sm_properties_sync (
    XfsmDbusClient *proxy,
    const gchar *const *arg_names,
    GVariant **out_values,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSmProperties",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_values);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_set_sm_properties:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.SetSmProperties">SetSmProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_set_sm_properties_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_set_sm_properties_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_set_sm_properties (
    XfsmDbusClient *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSmProperties",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_set_sm_properties_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_set_sm_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_set_sm_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_set_sm_properties_finish (
    XfsmDbusClient *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_set_sm_properties_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.SetSmProperties">SetSmProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_set_sm_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_set_sm_properties_sync (
    XfsmDbusClient *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSmProperties",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_delete_sm_properties:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.DeleteSmProperties">DeleteSmProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_delete_sm_properties_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_delete_sm_properties_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_delete_sm_properties (
    XfsmDbusClient *proxy,
    const gchar *const *arg_names,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteSmProperties",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_delete_sm_properties_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_delete_sm_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_delete_sm_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_delete_sm_properties_finish (
    XfsmDbusClient *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_delete_sm_properties_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_names: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.DeleteSmProperties">DeleteSmProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_delete_sm_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_delete_sm_properties_sync (
    XfsmDbusClient *proxy,
    const gchar *const *arg_names,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteSmProperties",
    g_variant_new ("(^as)",
                   arg_names),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_terminate:
 * @proxy: A #XfsmDbusClientProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.Terminate">Terminate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_terminate_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_terminate_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_terminate (
    XfsmDbusClient *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Terminate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_terminate_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_terminate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_terminate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_terminate_finish (
    XfsmDbusClient *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_terminate_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.Terminate">Terminate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_terminate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_terminate_sync (
    XfsmDbusClient *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Terminate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_end_session_response:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_is_ok: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.EndSessionResponse">EndSessionResponse()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_call_end_session_response_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_call_end_session_response_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_client_call_end_session_response (
    XfsmDbusClient *proxy,
    gboolean arg_is_ok,
    const gchar *arg_reason,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EndSessionResponse",
    g_variant_new ("(bs)",
                   arg_is_ok,
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_client_call_end_session_response_finish:
 * @proxy: A #XfsmDbusClientProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_call_end_session_response().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_client_call_end_session_response().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_end_session_response_finish (
    XfsmDbusClient *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_call_end_session_response_sync:
 * @proxy: A #XfsmDbusClientProxy.
 * @arg_is_ok: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Client.EndSessionResponse">EndSessionResponse()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_call_end_session_response() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_client_call_end_session_response_sync (
    XfsmDbusClient *proxy,
    gboolean arg_is_ok,
    const gchar *arg_reason,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EndSessionResponse",
    g_variant_new ("(bs)",
                   arg_is_ok,
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_client_complete_get_id:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.GetID">GetID()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_get_id (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   id));
}

/**
 * xfsm_dbus_client_complete_get_state:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.GetState">GetState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_get_state (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   state));
}

/**
 * xfsm_dbus_client_complete_get_all_sm_properties:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.GetAllSmProperties">GetAllSmProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_get_all_sm_properties (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/**
 * xfsm_dbus_client_complete_get_sm_properties:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @values: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.GetSmProperties">GetSmProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_get_sm_properties (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *values)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   values));
}

/**
 * xfsm_dbus_client_complete_set_sm_properties:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.SetSmProperties">SetSmProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_set_sm_properties (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_client_complete_delete_sm_properties:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.DeleteSmProperties">DeleteSmProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_delete_sm_properties (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_client_complete_terminate:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.Terminate">Terminate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_terminate (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_client_complete_end_session_response:
 * @object: A #XfsmDbusClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Client.EndSessionResponse">EndSessionResponse()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_client_complete_end_session_response (
    XfsmDbusClient *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XfsmDbusClientProxy:
 *
 * The #XfsmDbusClientProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfsmDbusClientProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfsmDbusClientProxy.
 */

struct _XfsmDbusClientProxyPrivate
{
  GData *qdata;
};

static void xfsm_dbus_client_proxy_iface_init (XfsmDbusClientIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfsmDbusClientProxy, xfsm_dbus_client_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XfsmDbusClientProxy)
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_CLIENT, xfsm_dbus_client_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfsmDbusClientProxy, xfsm_dbus_client_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_CLIENT, xfsm_dbus_client_proxy_iface_init))

#endif
static void
xfsm_dbus_client_proxy_finalize (GObject *object)
{
  XfsmDbusClientProxy *proxy = XFSM_DBUS_CLIENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xfsm_dbus_client_proxy_parent_class)->finalize (object);
}

static void
xfsm_dbus_client_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfsm_dbus_client_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfsm_dbus_client_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xfsm_dbus_client_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XFSM_DBUS_TYPE_CLIENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFSM_DBUS_TYPE_CLIENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xfsm_dbus_client_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XfsmDbusClientProxy *proxy = XFSM_DBUS_CLIENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_client_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_client_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xfsm_dbus_client_proxy_init (XfsmDbusClientProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xfsm_dbus_client_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XFSM_DBUS_TYPE_CLIENT_PROXY, XfsmDbusClientProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xfsm_dbus_client_interface_info ());
}

static void
xfsm_dbus_client_proxy_class_init (XfsmDbusClientProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xfsm_dbus_client_proxy_finalize;
  gobject_class->get_property = xfsm_dbus_client_proxy_get_property;
  gobject_class->set_property = xfsm_dbus_client_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xfsm_dbus_client_proxy_g_signal;
  proxy_class->g_properties_changed = xfsm_dbus_client_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfsmDbusClientProxyPrivate));
#endif
}

static void
xfsm_dbus_client_proxy_iface_init (XfsmDbusClientIface *iface G_GNUC_UNUSED)
{
}

/**
 * xfsm_dbus_client_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_proxy_new_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xfsm_dbus_client_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFSM_DBUS_TYPE_CLIENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Client", NULL);
}

/**
 * xfsm_dbus_client_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfsm_dbus_client_proxy_new().
 *
 * Returns: (transfer full) (type XfsmDbusClientProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusClient *
xfsm_dbus_client_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFSM_DBUS_CLIENT (ret);
  else
    return NULL;
}

/**
 * xfsm_dbus_client_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfsmDbusClientProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusClient *
xfsm_dbus_client_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFSM_DBUS_TYPE_CLIENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Client", NULL);
  if (ret != NULL)
    return XFSM_DBUS_CLIENT (ret);
  else
    return NULL;
}


/**
 * xfsm_dbus_client_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xfsm_dbus_client_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_client_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xfsm_dbus_client_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xfsm_dbus_client_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFSM_DBUS_TYPE_CLIENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Client", NULL);
}

/**
 * xfsm_dbus_client_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_client_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfsm_dbus_client_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XfsmDbusClientProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusClient *
xfsm_dbus_client_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFSM_DBUS_CLIENT (ret);
  else
    return NULL;
}

/**
 * xfsm_dbus_client_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xfsm_dbus_client_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_client_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfsmDbusClientProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusClient *
xfsm_dbus_client_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFSM_DBUS_TYPE_CLIENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Client", NULL);
  if (ret != NULL)
    return XFSM_DBUS_CLIENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XfsmDbusClientSkeleton:
 *
 * The #XfsmDbusClientSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfsmDbusClientSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfsmDbusClientSkeleton.
 */

struct _XfsmDbusClientSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xfsm_dbus_client_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XFSM_DBUS_TYPE_CLIENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFSM_DBUS_TYPE_CLIENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xfsm_dbus_client_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_client_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xfsm_dbus_client_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_client_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xfsm_dbus_client_skeleton_vtable =
{
  _xfsm_dbus_client_skeleton_handle_method_call,
  _xfsm_dbus_client_skeleton_handle_get_property,
  _xfsm_dbus_client_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xfsm_dbus_client_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xfsm_dbus_client_interface_info ();
}

static GDBusInterfaceVTable *
xfsm_dbus_client_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xfsm_dbus_client_skeleton_vtable;
}

static GVariant *
xfsm_dbus_client_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xfsm_dbus_client_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xfsm_dbus_client_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xfsm_dbus_client_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xfsm_dbus_client_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xfsm_dbus_client_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xfsm_dbus_client_on_signal_state_changed (
    XfsmDbusClient *object,
    guint arg_old_state,
    guint arg_new_state)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_old_state,
                   arg_new_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_client_on_signal_sm_property_changed (
    XfsmDbusClient *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_name,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "SmPropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_client_on_signal_sm_property_deleted (
    XfsmDbusClient *object,
    const gchar *arg_name)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_name));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "SmPropertyDeleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_client_on_signal_query_end_session (
    XfsmDbusClient *object,
    guint arg_flags)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_flags));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "QueryEndSession",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_client_on_signal_end_session (
    XfsmDbusClient *object,
    guint arg_flags)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_flags));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "EndSession",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_client_on_signal_cancel_end_session (
    XfsmDbusClient *object)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "CancelEndSession",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_client_on_signal_stop (
    XfsmDbusClient *object)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Client", "Stop",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xfsm_dbus_client_skeleton_iface_init (XfsmDbusClientIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfsmDbusClientSkeleton, xfsm_dbus_client_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XfsmDbusClientSkeleton)
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_CLIENT, xfsm_dbus_client_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfsmDbusClientSkeleton, xfsm_dbus_client_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_CLIENT, xfsm_dbus_client_skeleton_iface_init))

#endif
static void
xfsm_dbus_client_skeleton_finalize (GObject *object)
{
  XfsmDbusClientSkeleton *skeleton = XFSM_DBUS_CLIENT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xfsm_dbus_client_skeleton_parent_class)->finalize (object);
}

static void
xfsm_dbus_client_skeleton_init (XfsmDbusClientSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xfsm_dbus_client_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XFSM_DBUS_TYPE_CLIENT_SKELETON, XfsmDbusClientSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xfsm_dbus_client_skeleton_class_init (XfsmDbusClientSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xfsm_dbus_client_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xfsm_dbus_client_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xfsm_dbus_client_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xfsm_dbus_client_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xfsm_dbus_client_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfsmDbusClientSkeletonPrivate));
#endif
}

static void
xfsm_dbus_client_skeleton_iface_init (XfsmDbusClientIface *iface)
{
  iface->state_changed = _xfsm_dbus_client_on_signal_state_changed;
  iface->sm_property_changed = _xfsm_dbus_client_on_signal_sm_property_changed;
  iface->sm_property_deleted = _xfsm_dbus_client_on_signal_sm_property_deleted;
  iface->query_end_session = _xfsm_dbus_client_on_signal_query_end_session;
  iface->end_session = _xfsm_dbus_client_on_signal_end_session;
  iface->cancel_end_session = _xfsm_dbus_client_on_signal_cancel_end_session;
  iface->stop = _xfsm_dbus_client_on_signal_stop;
}

/**
 * xfsm_dbus_client_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Client.top_of_page">org.xfce.Session.Client</link>.
 *
 * Returns: (transfer full) (type XfsmDbusClientSkeleton): The skeleton object.
 */
XfsmDbusClient *
xfsm_dbus_client_skeleton_new (void)
{
  return XFSM_DBUS_CLIENT (g_object_new (XFSM_DBUS_TYPE_CLIENT_SKELETON, NULL));
}

