/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name: udio.c
 * Abstract:    User Device Input/Output functions. Here are enclosed all
 *              non-portable functions.
 */

#include "yforth.h"
#if HAVE_CONIO
#	include <conio.h>
#endif
#include "udio.h"

/* d_clrscr: clear the screen */
void d_clrscr() {
#if HAVE_CONIO
	clrscr();
#endif
}

/* d_clreol: clear to end of line */
void d_clreol() {
#if HAVE_CONIO
	clreol();
#endif
}

/* d_setattr: set default attributes */
void d_setaddr(Cell attr) {
#if HAVE_CONIO
	textattr(attr);
#endif
}

/* d_getattr: get default attributes */
Cell d_getattr() {
#if HAVE_CONIO
	struct text_info ti;
	gettextinfo(&ti);
	return (ti.attribute);
#endif
}

/* d_gotoxy: move the cursor to the location (x, y) of the screen */
void d_gotoxy(Cell x, Cell y) {
#if HAVE_CONIO
	gotoxy(x, y);
#endif
}

/* d_wherex: current column position of the cursor */
Cell d_wherex() {
#if HAVE_CONIO
	return (wherex());
#endif
}

/* d_wherey: current row position of the cursor */
Cell d_wherey() {
#if HAVE_CONIO
	return (wherey());
#endif
}

/* d_getch: read a characted from the input device without displaying it and
 * return as soon as the character is enteres (i.e. no wait for Carriage 
 * Return
 */
Char d_getch() {
#if HAVE_CONIO
	return (getch());
#endif 
}

/* d_kbhit: return True if a character is available */
Cell d_kbhit() {
#if HAVE_CONIO
	return (kbhit());
#endif
}

/* d_open: Initialize the Input/Output device */
void d_open() {
}

/* d_close: make some work when program finish to restore Input/Output device */
void d_close() {
}









