// SPDX-FileCopyrightText: Copyright 2023 yuzu Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#include <catch2/catch_test_macros.hpp>

#include "common/common_types.h"
#include "common/container_hash.h"

TEST_CASE("ContainerHash", "[common]") {
    constexpr std::array<u8, 32> U8Values{
        114, 10, 238, 189, 199, 242, 86, 96, 53,  193, 195, 247, 249, 56, 253, 61,
        205, 3,  172, 4,   210, 197, 43, 72, 103, 8,   99,  89,  5,   97, 68,  196,
    };
    constexpr std::array<u16, 32> U16Values{
        61586, 49151, 3313,  11641, 31695, 54795, 46764, 20965, 23287, 14039, 19265,
        49093, 58932, 22518, 27139, 42825, 57417, 54237, 48057, 14586, 42813, 32994,
        33970, 45501, 5619,  15895, 33227, 27509, 25391, 37275, 60218, 17599,
    };
    constexpr std::array<u32, 32> U32Values{
        3838402410U, 2029146863U, 1730869921U, 985528872U,  186773874U,  2094639868U, 3324775932U,
        1795512424U, 2571165571U, 3256934519U, 2358691590U, 2752682538U, 1484336451U, 378124520U,
        3463015699U, 3395942161U, 1263211979U, 3473632889U, 3039822212U, 2068707357U, 2223837919U,
        1823232191U, 1583884041U, 1264393380U, 4087566993U, 3188607101U, 3933680362U, 1464520765U,
        1786838406U, 1311734848U, 2773642241U, 3993641692U,
    };
    constexpr std::array<u64, 32> U64Values{
        5908025796157537817ULL, 10947547850358315100ULL, 844798943576724669ULL,
        7999662937458523703ULL, 4006550374705895164ULL,  1832550525423503632ULL,
        9323088254855830976ULL, 12028890075598379412ULL, 6021511300787826236ULL,
        7864675007938747948ULL, 18099387408859708806ULL, 6438638299316820708ULL,
        9029399285648501543ULL, 18195459433089960253ULL, 17214335092761966083ULL,
        5549347964591337833ULL, 14899526073304962015ULL, 5058883181561464475ULL,
        7436311795731206973ULL, 7535129567768649864ULL,  1287169596809258072ULL,
        8237671246353565927ULL, 1715230541978016153ULL,  8443157615068813300ULL,
        6098675262328527839ULL, 704652094100376853ULL,   1303411723202926503ULL,
        7808312933946424854ULL, 6863726670433556594ULL,  9870361541383217495ULL,
        9273671094091079488ULL, 17541434976160119010ULL,
    };

    REQUIRE(Common::HashValue(U8Values) == 5867183267093890552ULL);
    REQUIRE(Common::HashValue(U16Values) == 9594135570564347135ULL);
    REQUIRE(Common::HashValue(U32Values) == 13123757214696618460ULL);
    REQUIRE(Common::HashValue(U64Values) == 7296500016546938380ULL);
}
