package mappers

var SubFieldDefMap = map[uint64]map[uint64]map[string]map[string]FieldDef{
	0: {
		2: {
			"manufacturer": {
				"garmin":         {Name: "garmin_product", Type: "garmin_product"},
				"dynastream":     {Name: "garmin_product", Type: "garmin_product"},
				"dynastream_oem": {Name: "garmin_product", Type: "garmin_product"},
				"tacx":           {Name: "garmin_product", Type: "garmin_product"},
			},
		},
	},
	18: {
		10: {
			"sport": {
				"cycling":                 {Name: "total_strokes", Unit: "strokes"},
				"swimming":                {Name: "total_strokes", Unit: "strokes"},
				"rowing":                  {Name: "total_strokes", Unit: "strokes"},
				"stand_up_paddleboarding": {Name: "total_strokes", Unit: "strokes"},
			},
		},
		18: {
			"sport": {
				"running": {Name: "avg_running_cadence", Unit: "strides/min"},
			},
		},
		19: {
			"sport": {
				"running": {Name: "max_running_cadence", Unit: "strides/min"},
			},
		},
	},
	19: {
		10: {
			"sport": {
				"cycling":                 {Name: "total_strokes", Unit: "strokes"},
				"swimming":                {Name: "total_strokes", Unit: "strokes"},
				"rowing":                  {Name: "total_strokes", Unit: "strokes"},
				"stand_up_paddleboarding": {Name: "total_strokes", Unit: "strokes"},
			},
		},
		17: {
			"sport": {
				"running": {Name: "avg_running_cadence", Unit: "strides/min"},
			},
		},
		18: {
			"sport": {
				"running": {Name: "max_running_cadence", Unit: "strides/min"},
			},
		},
	},
	21: {
		3: {
			"event": {
				"radar_threat_alert": {Name: "radar_threat_alert"},
			},
		},
		15: {
			"event": {
				"auto_activity_detect": {Name: "auto_activity_detect_start_timestamp", Type: "date_time", Unit: "s"},
			},
		},
	},
	23: {
		1: {
			"source_type": {
				"local": {Name: "local_device_type", Type: "local_device_type"},
			},
		},
		4: {
			"manufacturer": {
				"garmin":         {Name: "garmin_product", Type: "garmin_product"},
				"dynastream":     {Name: "garmin_product", Type: "garmin_product"},
				"dynastream_oem": {Name: "garmin_product", Type: "garmin_product"},
				"tacx":           {Name: "garmin_product", Type: "garmin_product"},
			},
		},
	},
	27: {
		2: {
			"duration_type": {
				"reps": {Name: "duration_reps"},
			},
		},
		4: {
			"target_type": {
				"swim_stroke": {Name: "target_stroke_type", Type: "swim_stroke"},
			},
		},
		5: {
			"target_type": {
				"power": {Name: "custom_target_power_low", Type: "workout_power", Unit: "% or watts"},
			},
		},
		6: {
			"target_type": {
				"power": {Name: "custom_target_power_high", Type: "workout_power", Unit: "% or watts"},
			},
		},
		20: {
			"secondary_target_type": {
				"swim_stroke": {Name: "secondary_target_stroke_type", Type: "swim_stroke"},
			},
		},
		21: {
			"secondary_target_type": {
				"power": {Name: "secondary_custom_target_power_low", Type: "workout_power", Unit: "% or watts"},
			},
		},
		22: {
			"secondary_target_type": {
				"power": {Name: "secondary_custom_target_power_high", Type: "workout_power", Unit: "% or watts"},
			},
		},
	},
	28: {
		1: {
			"manufacturer": {
				"garmin":         {Name: "garmin_product", Type: "garmin_product"},
				"dynastream":     {Name: "garmin_product", Type: "garmin_product"},
				"dynastream_oem": {Name: "garmin_product", Type: "garmin_product"},
				"tacx":           {Name: "garmin_product", Type: "garmin_product"},
			},
		},
	},
	38: {
		3: {
			"count_type": {
				"max_per_file_type": {Name: "max_per_file_type"},
			},
		},
	},
	55: {
		3: {
			"activity_type": {
				"cycling":  {Name: "strokes", Unit: "strokes", Scale: 2},
				"swimming": {Name: "strokes", Unit: "strokes", Scale: 2},
			},
		},
	},
	72: {
		2: {
			"manufacturer": {
				"garmin":         {Name: "garmin_product", Type: "garmin_product"},
				"dynastream":     {Name: "garmin_product", Type: "garmin_product"},
				"dynastream_oem": {Name: "garmin_product", Type: "garmin_product"},
				"tacx":           {Name: "garmin_product", Type: "garmin_product"},
			},
		},
	},
	106: {
		1: {
			"manufacturer": {
				"garmin":         {Name: "garmin_product", Type: "garmin_product"},
				"dynastream":     {Name: "garmin_product", Type: "garmin_product"},
				"dynastream_oem": {Name: "garmin_product", Type: "garmin_product"},
				"tacx":           {Name: "garmin_product", Type: "garmin_product"},
			},
		},
	},
	142: {
		10: {
			"sport": {
				"cycling": {Name: "total_strokes", Unit: "strokes"},
			},
		},
	},
	159: {
		1: {
			"mode": {
				"analog": {Name: "analog_layout", Type: "analog_watchface_layout"},
			},
		},
	},
	167: {
		1: {
			"sensor_type": {
				"gyroscope": {Name: "gyro_cal_factor", Unit: "deg/s"},
			},
		},
	},
	210: {
		1: {
			"sensor_type": {
				"barometer": {Name: "baro_cal_factor", Unit: "Pa"},
			},
		},
	},
	258: {
		20: {
			"heart_rate_source_type": {
				"local": {Name: "heart_rate_local_device_type", Type: "local_device_type"},
			},
		},
	},
}

var FieldDefMap = map[uint64]fieldDefMap{
	0: {
		0: {Name: "type", Type: "file"},
		1: {Name: "manufacturer", Type: "manufacturer"},
		2: {Name: "product", HasSubField: true},
		3: {Name: "serial_number"},
		4: {Name: "time_created", Type: "date_time"},
		5: {Name: "number"},
		8: {Name: "product_name"},
	},
	1: {
		0:  {Name: "languages"},
		1:  {Name: "sports", Type: "sport_bits_0"},
		21: {Name: "workouts_supported", Type: "workout_capabilities"},
		23: {Name: "connectivity_supported", Type: "connectivity_capabilities"},
	},
	2: {
		0:   {Name: "active_time_zone"},
		1:   {Name: "utc_offset"},
		2:   {Name: "time_offset", Unit: "s"},
		4:   {Name: "time_mode", Type: "time_mode"},
		5:   {Name: "time_zone_offset", Unit: "hr", Scale: 4},
		12:  {Name: "backlight_mode", Type: "backlight_mode"},
		36:  {Name: "activity_tracker_enabled"},
		39:  {Name: "clock_time", Type: "date_time"},
		40:  {Name: "pages_enabled"},
		46:  {Name: "move_alert_enabled"},
		47:  {Name: "date_mode", Type: "date_mode"},
		55:  {Name: "display_orientation", Type: "display_orientation"},
		56:  {Name: "mounting_side", Type: "side"},
		57:  {Name: "default_page"},
		58:  {Name: "autosync_min_steps", Unit: "steps"},
		59:  {Name: "autosync_min_time", Unit: "minutes"},
		80:  {Name: "lactate_threshold_autodetect_enabled"},
		86:  {Name: "ble_auto_upload_enabled"},
		89:  {Name: "auto_sync_frequency", Type: "auto_sync_frequency"},
		90:  {Name: "auto_activity_detect", Type: "auto_activity_detect"},
		94:  {Name: "number_of_screens"},
		95:  {Name: "smart_notification_display_orientation", Type: "display_orientation"},
		134: {Name: "tap_interface", Type: "switch"},
		174: {Name: "tap_sensitivity", Type: "tap_sensitivity"},
	},
	3: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "friendly_name"},
		1:   {Name: "gender", Type: "gender"},
		2:   {Name: "age", Unit: "years"},
		3:   {Name: "height", Unit: "m", Scale: 100},
		4:   {Name: "weight", Unit: "kg", Scale: 10},
		5:   {Name: "language", Type: "language"},
		6:   {Name: "elev_setting", Type: "display_measure"},
		7:   {Name: "weight_setting", Type: "display_measure"},
		8:   {Name: "resting_heart_rate", Unit: "bpm"},
		9:   {Name: "default_max_running_heart_rate", Unit: "bpm"},
		10:  {Name: "default_max_biking_heart_rate", Unit: "bpm"},
		11:  {Name: "default_max_heart_rate", Unit: "bpm"},
		12:  {Name: "hr_setting", Type: "display_heart"},
		13:  {Name: "speed_setting", Type: "display_measure"},
		14:  {Name: "dist_setting", Type: "display_measure"},
		16:  {Name: "power_setting", Type: "display_power"},
		17:  {Name: "activity_class", Type: "activity_class"},
		18:  {Name: "position_setting", Type: "display_position"},
		21:  {Name: "temperature_setting", Type: "display_measure"},
		22:  {Name: "local_id", Type: "user_local_id"},
		23:  {Name: "global_id"},
		28:  {Name: "wake_time", Type: "localtime_into_day"},
		29:  {Name: "sleep_time", Type: "localtime_into_day"},
		30:  {Name: "height_setting", Type: "display_measure"},
		31:  {Name: "user_running_step_length", Unit: "m", Scale: 1000},
		32:  {Name: "user_walking_step_length", Unit: "m", Scale: 1000},
		47:  {Name: "depth_setting", Type: "display_measure"},
		49:  {Name: "dive_count"},
	},
	4: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "enabled"},
		1:   {Name: "hrm_ant_id"},
		2:   {Name: "log_hrv"},
		3:   {Name: "hrm_ant_id_trans_type"},
	},
	5: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "enabled"},
		1:   {Name: "sdm_ant_id"},
		2:   {Name: "sdm_cal_factor", Unit: "%", Scale: 10},
		3:   {Name: "odometer", Unit: "m", Scale: 100},
		4:   {Name: "speed_source"},
		5:   {Name: "sdm_ant_id_trans_type"},
		7:   {Name: "odometer_rollover"},
	},
	6: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "name"},
		1:   {Name: "sport", Type: "sport"},
		2:   {Name: "sub_sport", Type: "sub_sport"},
		3:   {Name: "odometer", Unit: "m", Scale: 100},
		4:   {Name: "bike_spd_ant_id"},
		5:   {Name: "bike_cad_ant_id"},
		6:   {Name: "bike_spdcad_ant_id"},
		7:   {Name: "bike_power_ant_id"},
		8:   {Name: "custom_wheelsize", Unit: "m", Scale: 1000},
		9:   {Name: "auto_wheelsize", Unit: "m", Scale: 1000},
		10:  {Name: "bike_weight", Unit: "kg", Scale: 10},
		11:  {Name: "power_cal_factor", Unit: "%", Scale: 10},
		12:  {Name: "auto_wheel_cal"},
		13:  {Name: "auto_power_zero"},
		14:  {Name: "id"},
		15:  {Name: "spd_enabled"},
		16:  {Name: "cad_enabled"},
		17:  {Name: "spdcad_enabled"},
		18:  {Name: "power_enabled"},
		19:  {Name: "crank_length", Unit: "mm", Scale: 2, Offset: -110},
		20:  {Name: "enabled"},
		21:  {Name: "bike_spd_ant_id_trans_type"},
		22:  {Name: "bike_cad_ant_id_trans_type"},
		23:  {Name: "bike_spdcad_ant_id_trans_type"},
		24:  {Name: "bike_power_ant_id_trans_type"},
		37:  {Name: "odometer_rollover"},
		38:  {Name: "front_gear_num"},
		39:  {Name: "front_gear"},
		40:  {Name: "rear_gear_num"},
		41:  {Name: "rear_gear"},
		44:  {Name: "shimano_di2_enabled"},
	},
	7: {
		1: {Name: "max_heart_rate"},
		2: {Name: "threshold_heart_rate"},
		3: {Name: "functional_threshold_power"},
		5: {Name: "hr_calc_type", Type: "hr_zone_calc"},
		7: {Name: "pwr_calc_type", Type: "pwr_zone_calc"},
	},
	8: {
		254: {Name: "message_index", Type: "message_index"},
		1:   {Name: "high_bpm", Unit: "bpm"},
		2:   {Name: "name"},
	},
	9: {
		254: {Name: "message_index", Type: "message_index"},
		1:   {Name: "high_value", Unit: "watts"},
		2:   {Name: "name"},
	},
	10: {
		254: {Name: "message_index", Type: "message_index"},
		1:   {Name: "high_bpm"},
		2:   {Name: "calories", Unit: "kcal / min", Scale: 10},
		3:   {Name: "fat_calories", Unit: "kcal / min", Scale: 10},
	},
	12: {
		0: {Name: "sport", Type: "sport"},
		1: {Name: "sub_sport", Type: "sub_sport"},
		3: {Name: "name"},
	},
	15: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "sport", Type: "sport"},
		1:   {Name: "sub_sport", Type: "sub_sport"},
		2:   {Name: "start_date", Type: "date_time"},
		3:   {Name: "end_date", Type: "date_time"},
		4:   {Name: "type", Type: "goal"},
		5:   {Name: "value"},
		6:   {Name: "repeat"},
		7:   {Name: "target_value"},
		8:   {Name: "recurrence", Type: "goal_recurrence"},
		9:   {Name: "recurrence_value"},
		10:  {Name: "enabled"},
		11:  {Name: "source", Type: "goal_source"},
	},
	18: {
		254: {Name: "message_index", Type: "message_index"},
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "event", Type: "event"},
		1:   {Name: "event_type", Type: "event_type"},
		2:   {Name: "start_time", Type: "date_time"},
		3:   {Name: "start_position_lat", Unit: "semicircles"},
		4:   {Name: "start_position_long", Unit: "semicircles"},
		5:   {Name: "sport", Type: "sport"},
		6:   {Name: "sub_sport", Type: "sub_sport"},
		7:   {Name: "total_elapsed_time", Unit: "s", Scale: 1000},
		8:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		9:   {Name: "total_distance", Unit: "m", Scale: 100},
		10:  {Name: "total_cycles", Unit: "cycles", HasSubField: true},
		11:  {Name: "total_calories", Unit: "kcal"},
		13:  {Name: "total_fat_calories", Unit: "kcal"},
		14:  {Name: "avg_speed", Unit: "m/s", Scale: 1000},
		15:  {Name: "max_speed", Unit: "m/s", Scale: 1000},
		16:  {Name: "avg_heart_rate", Unit: "bpm"},
		17:  {Name: "max_heart_rate", Unit: "bpm"},
		18:  {Name: "avg_cadence", Unit: "rpm", HasSubField: true},
		19:  {Name: "max_cadence", Unit: "rpm", HasSubField: true},
		20:  {Name: "avg_power", Unit: "watts"},
		21:  {Name: "max_power", Unit: "watts"},
		22:  {Name: "total_ascent", Unit: "m"},
		23:  {Name: "total_descent", Unit: "m"},
		24:  {Name: "total_training_effect", Scale: 10},
		25:  {Name: "first_lap_index"},
		26:  {Name: "num_laps"},
		27:  {Name: "event_group"},
		28:  {Name: "trigger", Type: "session_trigger"},
		29:  {Name: "nec_lat", Unit: "semicircles"},
		30:  {Name: "nec_long", Unit: "semicircles"},
		31:  {Name: "swc_lat", Unit: "semicircles"},
		32:  {Name: "swc_long", Unit: "semicircles"},
		33:  {Name: "num_lengths", Unit: "lengths"},
		34:  {Name: "normalized_power", Unit: "watts"},
		35:  {Name: "training_stress_score", Unit: "tss", Scale: 10},
		36:  {Name: "intensity_factor", Unit: "if", Scale: 1000},
		37:  {Name: "left_right_balance", Type: "left_right_balance_100"},
		38:  {Name: "end_position_lat", Unit: "semicircles"},
		39:  {Name: "end_position_long", Unit: "semicircles"},
		41:  {Name: "avg_stroke_count", Unit: "strokes/lap", Scale: 10},
		42:  {Name: "avg_stroke_distance", Unit: "m", Scale: 100},
		43:  {Name: "swim_stroke", Type: "swim_stroke", Unit: "swim_stroke"},
		44:  {Name: "pool_length", Unit: "m", Scale: 100},
		45:  {Name: "threshold_power", Unit: "watts"},
		46:  {Name: "pool_length_unit", Type: "display_measure"},
		47:  {Name: "num_active_lengths", Unit: "lengths"},
		48:  {Name: "total_work", Unit: "J"},
		49:  {Name: "avg_altitude", Unit: "m", Scale: 5, Offset: 500},
		50:  {Name: "max_altitude", Unit: "m", Scale: 5, Offset: 500},
		51:  {Name: "gps_accuracy", Unit: "m"},
		52:  {Name: "avg_grade", Unit: "%", Scale: 100},
		53:  {Name: "avg_pos_grade", Unit: "%", Scale: 100},
		54:  {Name: "avg_neg_grade", Unit: "%", Scale: 100},
		55:  {Name: "max_pos_grade", Unit: "%", Scale: 100},
		56:  {Name: "max_neg_grade", Unit: "%", Scale: 100},
		57:  {Name: "avg_temperature", Unit: "C"},
		58:  {Name: "max_temperature", Unit: "C"},
		59:  {Name: "total_moving_time", Unit: "s", Scale: 1000},
		60:  {Name: "avg_pos_vertical_speed", Unit: "m/s", Scale: 1000},
		61:  {Name: "avg_neg_vertical_speed", Unit: "m/s", Scale: 1000},
		62:  {Name: "max_pos_vertical_speed", Unit: "m/s", Scale: 1000},
		63:  {Name: "max_neg_vertical_speed", Unit: "m/s", Scale: 1000},
		64:  {Name: "min_heart_rate", Unit: "bpm"},
		65:  {Name: "time_in_hr_zone", Unit: "s", Scale: 1000},
		66:  {Name: "time_in_speed_zone", Unit: "s", Scale: 1000},
		67:  {Name: "time_in_cadence_zone", Unit: "s", Scale: 1000},
		68:  {Name: "time_in_power_zone", Unit: "s", Scale: 1000},
		69:  {Name: "avg_lap_time", Unit: "s", Scale: 1000},
		70:  {Name: "best_lap_index"},
		71:  {Name: "min_altitude", Unit: "m", Scale: 5, Offset: 500},
		82:  {Name: "player_score"},
		83:  {Name: "opponent_score"},
		84:  {Name: "opponent_name"},
		85:  {Name: "stroke_count", Unit: "counts"},
		86:  {Name: "zone_count", Unit: "counts"},
		87:  {Name: "max_ball_speed", Unit: "m/s", Scale: 100},
		88:  {Name: "avg_ball_speed", Unit: "m/s", Scale: 100},
		89:  {Name: "avg_vertical_oscillation", Unit: "mm", Scale: 10},
		90:  {Name: "avg_stance_time_percent", Unit: "percent", Scale: 100},
		91:  {Name: "avg_stance_time", Unit: "ms", Scale: 10},
		92:  {Name: "avg_fractional_cadence", Unit: "rpm", Scale: 128},
		93:  {Name: "max_fractional_cadence", Unit: "rpm", Scale: 128},
		94:  {Name: "total_fractional_cycles", Unit: "cycles", Scale: 128},
		95:  {Name: "avg_total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		96:  {Name: "min_total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		97:  {Name: "max_total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		98:  {Name: "avg_saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		99:  {Name: "min_saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		100: {Name: "max_saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		101: {Name: "avg_left_torque_effectiveness", Unit: "percent", Scale: 2},
		102: {Name: "avg_right_torque_effectiveness", Unit: "percent", Scale: 2},
		103: {Name: "avg_left_pedal_smoothness", Unit: "percent", Scale: 2},
		104: {Name: "avg_right_pedal_smoothness", Unit: "percent", Scale: 2},
		105: {Name: "avg_combined_pedal_smoothness", Unit: "percent", Scale: 2},
		110: {Name: "sport_profile_name"},
		111: {Name: "sport_index"},
		112: {Name: "time_standing", Unit: "s", Scale: 1000},
		113: {Name: "stand_count"},
		114: {Name: "avg_left_pco", Unit: "mm"},
		115: {Name: "avg_right_pco", Unit: "mm"},
		116: {Name: "avg_left_power_phase", Unit: "degrees", Scale: 0.7111111},
		117: {Name: "avg_left_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		118: {Name: "avg_right_power_phase", Unit: "degrees", Scale: 0.7111111},
		119: {Name: "avg_right_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		120: {Name: "avg_power_position", Unit: "watts"},
		121: {Name: "max_power_position", Unit: "watts"},
		122: {Name: "avg_cadence_position", Unit: "rpm"},
		123: {Name: "max_cadence_position", Unit: "rpm"},
		124: {Name: "enhanced_avg_speed", Unit: "m/s", Scale: 1000},
		125: {Name: "enhanced_max_speed", Unit: "m/s", Scale: 1000},
		126: {Name: "enhanced_avg_altitude", Unit: "m", Scale: 5, Offset: 500},
		127: {Name: "enhanced_min_altitude", Unit: "m", Scale: 5, Offset: 500},
		128: {Name: "enhanced_max_altitude", Unit: "m", Scale: 5, Offset: 500},
		129: {Name: "avg_lev_motor_power", Unit: "watts"},
		130: {Name: "max_lev_motor_power", Unit: "watts"},
		131: {Name: "lev_battery_consumption", Unit: "percent", Scale: 2},
		132: {Name: "avg_vertical_ratio", Unit: "percent", Scale: 100},
		133: {Name: "avg_stance_time_balance", Unit: "percent", Scale: 100},
		134: {Name: "avg_step_length", Unit: "mm", Scale: 10},
		137: {Name: "total_anaerobic_training_effect", Scale: 10},
		139: {Name: "avg_vam", Unit: "m/s", Scale: 1000},
		140: {Name: "avg_depth", Unit: "m", Scale: 1000},
		141: {Name: "max_depth", Unit: "m", Scale: 1000},
		142: {Name: "surface_interval", Unit: "s", Scale: 1},
		143: {Name: "start_cns", Unit: "percent", Scale: 1},
		144: {Name: "end_cns", Unit: "percent", Scale: 1},
		145: {Name: "start_n2", Unit: "percent", Scale: 1},
		146: {Name: "end_n2", Unit: "percent", Scale: 1},
		147: {Name: "avg_respiration_rate"},
		148: {Name: "max_respiration_rate"},
		149: {Name: "min_respiration_rate"},
		150: {Name: "min_temperature", Unit: "C"},
		155: {Name: "o2_toxicity", Unit: "OTUs"},
		156: {Name: "dive_number"},
		168: {Name: "training_load_peak", Scale: 65536},
		169: {Name: "enhanced_avg_respiration_rate", Unit: "Breaths/min", Scale: 100},
		170: {Name: "enhanced_max_respiration_rate", Unit: "Breaths/min", Scale: 100},
		180: {Name: "enhanced_min_respiration_rate", Scale: 100},
		181: {Name: "total_grit", Unit: "kGrit"},
		182: {Name: "total_flow", Unit: "Flow"},
		183: {Name: "jump_count"},
		186: {Name: "avg_grit", Unit: "kGrit"},
		187: {Name: "avg_flow", Unit: "Flow"},
		194: {Name: "avg_spo2", Unit: "percent"},
		195: {Name: "avg_stress", Unit: "percent"},
		197: {Name: "sdrr_hrv", Unit: "mS"},
		198: {Name: "rmssd_hrv", Unit: "mS"},
		199: {Name: "total_fractional_ascent", Unit: "m", Scale: 100},
		200: {Name: "total_fractional_descent", Unit: "m", Scale: 100},
		208: {Name: "avg_core_temperature", Unit: "C", Scale: 100},
		209: {Name: "min_core_temperature", Unit: "C", Scale: 100},
		210: {Name: "max_core_temperature", Unit: "C", Scale: 100},
	},
	19: {
		254: {Name: "message_index", Type: "message_index"},
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "event", Type: "event"},
		1:   {Name: "event_type", Type: "event_type"},
		2:   {Name: "start_time", Type: "date_time"},
		3:   {Name: "start_position_lat", Unit: "semicircles"},
		4:   {Name: "start_position_long", Unit: "semicircles"},
		5:   {Name: "end_position_lat", Unit: "semicircles"},
		6:   {Name: "end_position_long", Unit: "semicircles"},
		7:   {Name: "total_elapsed_time", Unit: "s", Scale: 1000},
		8:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		9:   {Name: "total_distance", Unit: "m", Scale: 100},
		10:  {Name: "total_cycles", Unit: "cycles", HasSubField: true},
		11:  {Name: "total_calories", Unit: "kcal"},
		12:  {Name: "total_fat_calories", Unit: "kcal"},
		13:  {Name: "avg_speed", Unit: "m/s", Scale: 1000},
		14:  {Name: "max_speed", Unit: "m/s", Scale: 1000},
		15:  {Name: "avg_heart_rate", Unit: "bpm"},
		16:  {Name: "max_heart_rate", Unit: "bpm"},
		17:  {Name: "avg_cadence", Unit: "rpm", HasSubField: true},
		18:  {Name: "max_cadence", Unit: "rpm", HasSubField: true},
		19:  {Name: "avg_power", Unit: "watts"},
		20:  {Name: "max_power", Unit: "watts"},
		21:  {Name: "total_ascent", Unit: "m"},
		22:  {Name: "total_descent", Unit: "m"},
		23:  {Name: "intensity", Type: "intensity"},
		24:  {Name: "lap_trigger", Type: "lap_trigger"},
		25:  {Name: "sport", Type: "sport"},
		26:  {Name: "event_group"},
		32:  {Name: "num_lengths", Unit: "lengths"},
		33:  {Name: "normalized_power", Unit: "watts"},
		34:  {Name: "left_right_balance", Type: "left_right_balance_100"},
		35:  {Name: "first_length_index"},
		37:  {Name: "avg_stroke_distance", Unit: "m", Scale: 100},
		38:  {Name: "swim_stroke", Type: "swim_stroke"},
		39:  {Name: "sub_sport", Type: "sub_sport"},
		40:  {Name: "num_active_lengths", Unit: "lengths"},
		41:  {Name: "total_work", Unit: "J"},
		42:  {Name: "avg_altitude", Unit: "m", Scale: 5, Offset: 500},
		43:  {Name: "max_altitude", Unit: "m", Scale: 5, Offset: 500},
		44:  {Name: "gps_accuracy", Unit: "m"},
		45:  {Name: "avg_grade", Unit: "%", Scale: 100},
		46:  {Name: "avg_pos_grade", Unit: "%", Scale: 100},
		47:  {Name: "avg_neg_grade", Unit: "%", Scale: 100},
		48:  {Name: "max_pos_grade", Unit: "%", Scale: 100},
		49:  {Name: "max_neg_grade", Unit: "%", Scale: 100},
		50:  {Name: "avg_temperature", Unit: "C"},
		51:  {Name: "max_temperature", Unit: "C"},
		52:  {Name: "total_moving_time", Unit: "s", Scale: 1000},
		53:  {Name: "avg_pos_vertical_speed", Unit: "m/s", Scale: 1000},
		54:  {Name: "avg_neg_vertical_speed", Unit: "m/s", Scale: 1000},
		55:  {Name: "max_pos_vertical_speed", Unit: "m/s", Scale: 1000},
		56:  {Name: "max_neg_vertical_speed", Unit: "m/s", Scale: 1000},
		57:  {Name: "time_in_hr_zone", Unit: "s", Scale: 1000},
		58:  {Name: "time_in_speed_zone", Unit: "s", Scale: 1000},
		59:  {Name: "time_in_cadence_zone", Unit: "s", Scale: 1000},
		60:  {Name: "time_in_power_zone", Unit: "s", Scale: 1000},
		61:  {Name: "repetition_num"},
		62:  {Name: "min_altitude", Unit: "m", Scale: 5, Offset: 500},
		63:  {Name: "min_heart_rate", Unit: "bpm"},
		71:  {Name: "wkt_step_index", Type: "message_index"},
		74:  {Name: "opponent_score"},
		75:  {Name: "stroke_count", Unit: "counts"},
		76:  {Name: "zone_count", Unit: "counts"},
		77:  {Name: "avg_vertical_oscillation", Unit: "mm", Scale: 10},
		78:  {Name: "avg_stance_time_percent", Unit: "percent", Scale: 100},
		79:  {Name: "avg_stance_time", Unit: "ms", Scale: 10},
		80:  {Name: "avg_fractional_cadence", Unit: "rpm", Scale: 128},
		81:  {Name: "max_fractional_cadence", Unit: "rpm", Scale: 128},
		82:  {Name: "total_fractional_cycles", Unit: "cycles", Scale: 128},
		83:  {Name: "player_score"},
		84:  {Name: "avg_total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		85:  {Name: "min_total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		86:  {Name: "max_total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		87:  {Name: "avg_saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		88:  {Name: "min_saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		89:  {Name: "max_saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		91:  {Name: "avg_left_torque_effectiveness", Unit: "percent", Scale: 2},
		92:  {Name: "avg_right_torque_effectiveness", Unit: "percent", Scale: 2},
		93:  {Name: "avg_left_pedal_smoothness", Unit: "percent", Scale: 2},
		94:  {Name: "avg_right_pedal_smoothness", Unit: "percent", Scale: 2},
		95:  {Name: "avg_combined_pedal_smoothness", Unit: "percent", Scale: 2},
		98:  {Name: "time_standing", Unit: "s", Scale: 1000},
		99:  {Name: "stand_count"},
		100: {Name: "avg_left_pco", Unit: "mm"},
		101: {Name: "avg_right_pco", Unit: "mm"},
		102: {Name: "avg_left_power_phase", Unit: "degrees", Scale: 0.7111111},
		103: {Name: "avg_left_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		104: {Name: "avg_right_power_phase", Unit: "degrees", Scale: 0.7111111},
		105: {Name: "avg_right_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		106: {Name: "avg_power_position", Unit: "watts"},
		107: {Name: "max_power_position", Unit: "watts"},
		108: {Name: "avg_cadence_position", Unit: "rpm"},
		109: {Name: "max_cadence_position", Unit: "rpm"},
		110: {Name: "enhanced_avg_speed", Unit: "m/s", Scale: 1000},
		111: {Name: "enhanced_max_speed", Unit: "m/s", Scale: 1000},
		112: {Name: "enhanced_avg_altitude", Unit: "m", Scale: 5, Offset: 500},
		113: {Name: "enhanced_min_altitude", Unit: "m", Scale: 5, Offset: 500},
		114: {Name: "enhanced_max_altitude", Unit: "m", Scale: 5, Offset: 500},
		115: {Name: "avg_lev_motor_power", Unit: "watts"},
		116: {Name: "max_lev_motor_power", Unit: "watts"},
		117: {Name: "lev_battery_consumption", Unit: "percent", Scale: 2},
		118: {Name: "avg_vertical_ratio", Unit: "percent", Scale: 100},
		119: {Name: "avg_stance_time_balance", Unit: "percent", Scale: 100},
		120: {Name: "avg_step_length", Unit: "mm", Scale: 10},
		121: {Name: "avg_vam", Unit: "m/s", Scale: 1000},
		122: {Name: "avg_depth", Unit: "m", Scale: 1000},
		123: {Name: "max_depth", Unit: "m", Scale: 1000},
		124: {Name: "min_temperature", Unit: "C"},
		136: {Name: "enhanced_avg_respiration_rate", Unit: "Breaths/min", Scale: 100},
		137: {Name: "enhanced_max_respiration_rate", Unit: "Breaths/min", Scale: 100},
		147: {Name: "avg_respiration_rate"},
		148: {Name: "max_respiration_rate"},
		149: {Name: "total_grit", Unit: "kGrit"},
		150: {Name: "total_flow", Unit: "Flow"},
		151: {Name: "jump_count"},
		153: {Name: "avg_grit", Unit: "kGrit"},
		154: {Name: "avg_flow", Unit: "Flow"},
		156: {Name: "total_fractional_ascent", Unit: "m", Scale: 100},
		157: {Name: "total_fractional_descent", Unit: "m", Scale: 100},
		158: {Name: "avg_core_temperature", Unit: "C", Scale: 100},
		159: {Name: "min_core_temperature", Unit: "C", Scale: 100},
		160: {Name: "max_core_temperature", Unit: "C", Scale: 100},
	},
	20: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "position_lat", Unit: "semicircles"},
		1:   {Name: "position_long", Unit: "semicircles"},
		2:   {Name: "altitude", Unit: "m", Scale: 5, Offset: 500},
		3:   {Name: "heart_rate", Unit: "bpm"},
		4:   {Name: "cadence", Unit: "rpm"},
		5:   {Name: "distance", Unit: "m", Scale: 100},
		6:   {Name: "speed", Unit: "m/s", Scale: 1000},
		7:   {Name: "power", Unit: "watts"},
		8:   {Name: "compressed_speed_distance", Unit: "m/s,m"},
		9:   {Name: "grade", Unit: "%", Scale: 100},
		10:  {Name: "resistance"},
		11:  {Name: "time_from_course", Unit: "s", Scale: 1000},
		12:  {Name: "cycle_length", Unit: "m", Scale: 100},
		13:  {Name: "temperature", Unit: "C"},
		17:  {Name: "speed_1s", Unit: "m/s", Scale: 16},
		18:  {Name: "cycles", Unit: "cycles"},
		19:  {Name: "total_cycles", Unit: "cycles"},
		28:  {Name: "compressed_accumulated_power", Unit: "watts"},
		29:  {Name: "accumulated_power", Unit: "watts"},
		30:  {Name: "left_right_balance", Type: "left_right_balance"},
		31:  {Name: "gps_accuracy", Unit: "m"},
		32:  {Name: "vertical_speed", Unit: "m/s", Scale: 1000},
		33:  {Name: "calories", Unit: "kcal"},
		39:  {Name: "vertical_oscillation", Unit: "mm", Scale: 10},
		40:  {Name: "stance_time_percent", Unit: "percent", Scale: 100},
		41:  {Name: "stance_time", Unit: "ms", Scale: 10},
		42:  {Name: "activity_type", Type: "activity_type"},
		43:  {Name: "left_torque_effectiveness", Unit: "percent", Scale: 2},
		44:  {Name: "right_torque_effectiveness", Unit: "percent", Scale: 2},
		45:  {Name: "left_pedal_smoothness", Unit: "percent", Scale: 2},
		46:  {Name: "right_pedal_smoothness", Unit: "percent", Scale: 2},
		47:  {Name: "combined_pedal_smoothness", Unit: "percent", Scale: 2},
		48:  {Name: "time128", Unit: "s", Scale: 128},
		49:  {Name: "stroke_type", Type: "stroke_type"},
		50:  {Name: "zone"},
		51:  {Name: "ball_speed", Unit: "m/s", Scale: 100},
		52:  {Name: "cadence256", Unit: "rpm", Scale: 256},
		53:  {Name: "fractional_cadence", Unit: "rpm", Scale: 128},
		54:  {Name: "total_hemoglobin_conc", Unit: "g/dL", Scale: 100},
		55:  {Name: "total_hemoglobin_conc_min", Unit: "g/dL", Scale: 100},
		56:  {Name: "total_hemoglobin_conc_max", Unit: "g/dL", Scale: 100},
		57:  {Name: "saturated_hemoglobin_percent", Unit: "%", Scale: 10},
		58:  {Name: "saturated_hemoglobin_percent_min", Unit: "%", Scale: 10},
		59:  {Name: "saturated_hemoglobin_percent_max", Unit: "%", Scale: 10},
		62:  {Name: "device_index", Type: "device_index"},
		67:  {Name: "left_pco", Unit: "mm"},
		68:  {Name: "right_pco", Unit: "mm"},
		69:  {Name: "left_power_phase", Unit: "degrees", Scale: 0.7111111},
		70:  {Name: "left_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		71:  {Name: "right_power_phase", Unit: "degrees", Scale: 0.7111111},
		72:  {Name: "right_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		73:  {Name: "enhanced_speed", Unit: "m/s", Scale: 1000},
		78:  {Name: "enhanced_altitude", Unit: "m", Scale: 5, Offset: 500},
		81:  {Name: "battery_soc", Unit: "percent", Scale: 2},
		82:  {Name: "motor_power", Unit: "watts"},
		83:  {Name: "vertical_ratio", Unit: "percent", Scale: 100},
		84:  {Name: "stance_time_balance", Unit: "percent", Scale: 100},
		85:  {Name: "step_length", Unit: "mm", Scale: 10},
		87:  {Name: "cycle_length16", Unit: "m", Scale: 100},
		91:  {Name: "absolute_pressure", Unit: "Pa"},
		92:  {Name: "depth", Unit: "m", Scale: 1000},
		93:  {Name: "next_stop_depth", Unit: "m", Scale: 1000},
		94:  {Name: "next_stop_time", Unit: "s", Scale: 1},
		95:  {Name: "time_to_surface", Unit: "s", Scale: 1},
		96:  {Name: "ndl_time", Unit: "s", Scale: 1},
		97:  {Name: "cns_load", Unit: "percent"},
		98:  {Name: "n2_load", Unit: "percent", Scale: 1},
		99:  {Name: "respiration_rate", Unit: "s", Scale: 1},
		108: {Name: "enhanced_respiration_rate", Unit: "Breaths/min", Scale: 100},
		114: {Name: "grit"},
		115: {Name: "flow"},
		116: {Name: "current_stress", Scale: 100},
		117: {Name: "ebike_travel_range", Unit: "km"},
		118: {Name: "ebike_battery_level", Unit: "percent"},
		119: {Name: "ebike_assist_mode", Unit: "depends on sensor"},
		120: {Name: "ebike_assist_level_percent", Unit: "percent"},
		123: {Name: "air_time_remaining", Unit: "s"},
		124: {Name: "pressure_sac", Unit: "bar/min", Scale: 100},
		125: {Name: "volume_sac", Unit: "L/min", Scale: 100},
		126: {Name: "rmv", Unit: "L/min", Scale: 100},
		127: {Name: "ascent_rate", Unit: "m/s", Scale: 1000},
		129: {Name: "po2", Unit: "percent", Scale: 100},
		139: {Name: "core_temperature", Unit: "C", Scale: 100},
	},
	21: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "event", Type: "event"},
		1:   {Name: "event_type", Type: "event_type"},
		2:   {Name: "data16"},
		3:   {Name: "data", HasSubField: true},
		4:   {Name: "event_group"},
		7:   {Name: "score"},
		8:   {Name: "opponent_score"},
		9:   {Name: "front_gear_num"},
		10:  {Name: "front_gear"},
		11:  {Name: "rear_gear_num"},
		12:  {Name: "rear_gear"},
		13:  {Name: "device_index", Type: "device_index"},
		14:  {Name: "activity_type", Type: "activity_type"},
		15:  {Name: "start_timestamp", Type: "date_time", Unit: "s", HasSubField: true},
		21:  {Name: "radar_threat_level_max", Type: "radar_threat_level_type"},
		22:  {Name: "radar_threat_count"},
		23:  {Name: "radar_threat_avg_approach_speed", Unit: "m/s", Scale: 10},
		24:  {Name: "radar_threat_max_approach_speed", Unit: "m/s", Scale: 10},
	},
	23: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "device_index", Type: "device_index"},
		1:   {Name: "device_type", HasSubField: true},
		2:   {Name: "manufacturer", Type: "manufacturer"},
		3:   {Name: "serial_number"},
		4:   {Name: "product", HasSubField: true},
		5:   {Name: "software_version", Scale: 100},
		6:   {Name: "hardware_version"},
		7:   {Name: "cum_operating_time", Unit: "s"},
		10:  {Name: "battery_voltage", Unit: "V", Scale: 256},
		11:  {Name: "battery_status", Type: "battery_status"},
		18:  {Name: "sensor_position", Type: "body_location"},
		19:  {Name: "descriptor"},
		20:  {Name: "ant_transmission_type"},
		21:  {Name: "ant_device_number"},
		22:  {Name: "ant_network", Type: "ant_network"},
		25:  {Name: "source_type", Type: "source_type"},
		27:  {Name: "product_name"},
		32:  {Name: "battery_level", Unit: "%"},
	},
	26: {
		254: {Name: "message_index", Type: "message_index"},
		4:   {Name: "sport", Type: "sport"},
		5:   {Name: "capabilities", Type: "workout_capabilities"},
		6:   {Name: "num_valid_steps"},
		8:   {Name: "wkt_name"},
		11:  {Name: "sub_sport", Type: "sub_sport"},
		14:  {Name: "pool_length", Unit: "m", Scale: 100},
		15:  {Name: "pool_length_unit", Type: "display_measure"},
	},
	27: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "wkt_step_name"},
		1:   {Name: "duration_type", Type: "wkt_step_duration"},
		2:   {Name: "duration_value", HasSubField: true},
		3:   {Name: "target_type", Type: "wkt_step_target"},
		4:   {Name: "target_value", HasSubField: true},
		5:   {Name: "custom_target_value_low", HasSubField: true},
		6:   {Name: "custom_target_value_high", HasSubField: true},
		7:   {Name: "intensity", Type: "intensity"},
		8:   {Name: "notes"},
		9:   {Name: "equipment", Type: "workout_equipment"},
		10:  {Name: "exercise_category", Type: "exercise_category"},
		11:  {Name: "exercise_name"},
		12:  {Name: "exercise_weight", Unit: "kg", Scale: 100},
		13:  {Name: "weight_display_unit", Type: "fit_base_unit"},
		19:  {Name: "secondary_target_type", Type: "wkt_step_target"},
		20:  {Name: "secondary_target_value", HasSubField: true},
		21:  {Name: "secondary_custom_target_value_low", HasSubField: true},
		22:  {Name: "secondary_custom_target_value_high", HasSubField: true},
	},
	28: {
		0: {Name: "manufacturer", Type: "manufacturer"},
		1: {Name: "product", HasSubField: true},
		2: {Name: "serial_number"},
		3: {Name: "time_created", Type: "date_time"},
		4: {Name: "completed"},
		5: {Name: "type", Type: "schedule"},
		6: {Name: "scheduled_time", Type: "local_date_time"},
	},
	30: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "weight", Type: "weight", Unit: "kg", Scale: 100},
		1:   {Name: "percent_fat", Unit: "%", Scale: 100},
		2:   {Name: "percent_hydration", Unit: "%", Scale: 100},
		3:   {Name: "visceral_fat_mass", Unit: "kg", Scale: 100},
		4:   {Name: "bone_mass", Unit: "kg", Scale: 100},
		5:   {Name: "muscle_mass", Unit: "kg", Scale: 100},
		7:   {Name: "basal_met", Unit: "kcal/day", Scale: 4},
		8:   {Name: "physique_rating"},
		9:   {Name: "active_met", Unit: "kcal/day", Scale: 4},
		10:  {Name: "metabolic_age", Unit: "years"},
		11:  {Name: "visceral_fat_rating"},
		12:  {Name: "user_profile_index", Type: "message_index"},
		13:  {Name: "bmi", Unit: "kg/m^2", Scale: 10},
	},
	31: {
		4: {Name: "sport", Type: "sport"},
		5: {Name: "name"},
		6: {Name: "capabilities", Type: "course_capabilities"},
		7: {Name: "sub_sport", Type: "sub_sport"},
	},
	32: {
		254: {Name: "message_index", Type: "message_index"},
		1:   {Name: "timestamp", Type: "date_time"},
		2:   {Name: "position_lat", Unit: "semicircles"},
		3:   {Name: "position_long", Unit: "semicircles"},
		4:   {Name: "distance", Unit: "m", Scale: 100},
		5:   {Name: "type", Type: "course_point"},
		6:   {Name: "name"},
		8:   {Name: "favorite"},
	},
	33: {
		254: {Name: "message_index", Type: "message_index"},
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timer_time", Unit: "s"},
		1:   {Name: "distance", Unit: "m"},
		2:   {Name: "calories", Unit: "kcal"},
		3:   {Name: "sport", Type: "sport"},
		4:   {Name: "elapsed_time", Unit: "s"},
		5:   {Name: "sessions"},
		6:   {Name: "active_time", Unit: "s"},
		9:   {Name: "sport_index"},
	},
	34: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		1:   {Name: "num_sessions"},
		2:   {Name: "type", Type: "activity"},
		3:   {Name: "event", Type: "event"},
		4:   {Name: "event_type", Type: "event_type"},
		5:   {Name: "local_timestamp", Type: "local_date_time"},
		6:   {Name: "event_group"},
	},
	35: {
		254: {Name: "message_index", Type: "message_index"},
		3:   {Name: "version", Scale: 100},
		5:   {Name: "part_number"},
	},
	37: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "type", Type: "file"},
		1:   {Name: "flags", Type: "file_flags"},
		2:   {Name: "directory"},
		3:   {Name: "max_count"},
		4:   {Name: "max_size", Unit: "bytes"},
	},
	38: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "file", Type: "file"},
		1:   {Name: "mesg_num", Type: "mesg_num"},
		2:   {Name: "count_type", Type: "mesg_count"},
		3:   {Name: "count", HasSubField: true},
	},
	39: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "file", Type: "file"},
		1:   {Name: "mesg_num", Type: "mesg_num"},
		2:   {Name: "field_num"},
		3:   {Name: "count"},
	},
	49: {
		0: {Name: "software_version"},
		1: {Name: "hardware_version"},
	},
	51: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "systolic_pressure", Unit: "mmHg"},
		1:   {Name: "diastolic_pressure", Unit: "mmHg"},
		2:   {Name: "mean_arterial_pressure", Unit: "mmHg"},
		3:   {Name: "map_3_sample_mean", Unit: "mmHg"},
		4:   {Name: "map_morning_values", Unit: "mmHg"},
		5:   {Name: "map_evening_values", Unit: "mmHg"},
		6:   {Name: "heart_rate", Unit: "bpm"},
		7:   {Name: "heart_rate_type", Type: "hr_type"},
		8:   {Name: "status", Type: "bp_status"},
		9:   {Name: "user_profile_index", Type: "message_index"},
	},
	53: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "high_value", Unit: "m/s", Scale: 1000},
		1:   {Name: "name"},
	},
	55: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "device_index", Type: "device_index"},
		1:   {Name: "calories", Unit: "kcal"},
		2:   {Name: "distance", Unit: "m", Scale: 100},
		3:   {Name: "cycles", Unit: "cycles", Scale: 2, HasSubField: true},
		4:   {Name: "active_time", Unit: "s", Scale: 1000},
		5:   {Name: "activity_type", Type: "activity_type"},
		6:   {Name: "activity_subtype", Type: "activity_subtype"},
		7:   {Name: "activity_level", Type: "activity_level"},
		8:   {Name: "distance_16", Unit: "100 * m"},
		9:   {Name: "cycles_16", Unit: "2 * cycles (steps)"},
		10:  {Name: "active_time_16", Unit: "s"},
		11:  {Name: "local_timestamp", Type: "local_date_time"},
		12:  {Name: "temperature", Unit: "C", Scale: 100},
		14:  {Name: "temperature_min", Unit: "C", Scale: 100},
		15:  {Name: "temperature_max", Unit: "C", Scale: 100},
		16:  {Name: "activity_time", Unit: "minutes"},
		19:  {Name: "active_calories", Unit: "kcal"},
		24:  {Name: "current_activity_type_intensity"},
		25:  {Name: "timestamp_min_8", Unit: "min"},
		26:  {Name: "timestamp_16", Unit: "s"},
		27:  {Name: "heart_rate", Unit: "bpm"},
		28:  {Name: "intensity", Scale: 10},
		29:  {Name: "duration_min", Unit: "min"},
		30:  {Name: "duration", Unit: "s"},
		31:  {Name: "ascent", Unit: "m", Scale: 1000},
		32:  {Name: "descent", Unit: "m", Scale: 1000},
		33:  {Name: "moderate_activity_minutes", Unit: "minutes"},
		34:  {Name: "vigorous_activity_minutes", Unit: "minutes"},
	},
	72: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "type", Type: "file"},
		1:   {Name: "manufacturer", Type: "manufacturer"},
		2:   {Name: "product", HasSubField: true},
		3:   {Name: "serial_number"},
		4:   {Name: "time_created", Type: "date_time"},
	},
	78: {
		0: {Name: "time", Unit: "s", Scale: 1000},
	},
	80: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "fractional_timestamp", Unit: "s", Scale: 32768},
		1:   {Name: "mesg_id"},
		2:   {Name: "mesg_data"},
		3:   {Name: "channel_number"},
		4:   {Name: "data"},
	},
	81: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "fractional_timestamp", Unit: "s", Scale: 32768},
		1:   {Name: "mesg_id"},
		2:   {Name: "mesg_data"},
		3:   {Name: "channel_number"},
		4:   {Name: "data"},
	},
	82: {
		0: {Name: "channel_number"},
		1: {Name: "device_type"},
		2: {Name: "device_number"},
		3: {Name: "transmission_type"},
		4: {Name: "device_index", Type: "device_index"},
	},
	101: {
		254: {Name: "message_index", Type: "message_index"},
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "event", Type: "event"},
		1:   {Name: "event_type", Type: "event_type"},
		2:   {Name: "start_time", Type: "date_time"},
		3:   {Name: "total_elapsed_time", Unit: "s", Scale: 1000},
		4:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		5:   {Name: "total_strokes", Unit: "strokes"},
		6:   {Name: "avg_speed", Unit: "m/s", Scale: 1000},
		7:   {Name: "swim_stroke", Type: "swim_stroke", Unit: "swim_stroke"},
		9:   {Name: "avg_swimming_cadence", Unit: "strokes/min"},
		10:  {Name: "event_group"},
		11:  {Name: "total_calories", Unit: "kcal"},
		12:  {Name: "length_type", Type: "length_type"},
		18:  {Name: "player_score"},
		19:  {Name: "opponent_score"},
		20:  {Name: "stroke_count", Unit: "counts"},
		21:  {Name: "zone_count", Unit: "counts"},
		22:  {Name: "enhanced_avg_respiration_rate", Unit: "Breaths/min", Scale: 100},
		23:  {Name: "enhanced_max_respiration_rate", Unit: "Breaths/min", Scale: 100},
		24:  {Name: "avg_respiration_rate"},
		25:  {Name: "max_respiration_rate"},
	},
	103: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "local_timestamp", Type: "local_date_time", Unit: "s"},
		1:   {Name: "activity_type", Type: "activity_type"},
		3:   {Name: "cycles_to_distance", Unit: "m/cycle", Scale: 5000},
		4:   {Name: "cycles_to_calories", Unit: "kcal/cycle", Scale: 5000},
		5:   {Name: "resting_metabolic_rate", Unit: "kcal / day"},
	},
	106: {
		0: {Name: "manufacturer", Type: "manufacturer"},
		1: {Name: "product", HasSubField: true},
	},
	127: {
		0:  {Name: "bluetooth_enabled"},
		1:  {Name: "bluetooth_le_enabled"},
		2:  {Name: "ant_enabled"},
		3:  {Name: "name"},
		4:  {Name: "live_tracking_enabled"},
		5:  {Name: "weather_conditions_enabled"},
		6:  {Name: "weather_alerts_enabled"},
		7:  {Name: "auto_activity_upload_enabled"},
		8:  {Name: "course_download_enabled"},
		9:  {Name: "workout_download_enabled"},
		10: {Name: "gps_ephemeris_download_enabled"},
		11: {Name: "incident_detection_enabled"},
		12: {Name: "grouptrack_enabled"},
	},
	128: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "weather_report", Type: "weather_report"},
		1:   {Name: "temperature", Unit: "C"},
		2:   {Name: "condition", Type: "weather_status"},
		3:   {Name: "wind_direction", Unit: "degrees"},
		4:   {Name: "wind_speed", Unit: "m/s", Scale: 1000},
		5:   {Name: "precipitation_probability"},
		6:   {Name: "temperature_feels_like", Unit: "C"},
		7:   {Name: "relative_humidity"},
		8:   {Name: "location"},
		9:   {Name: "observed_at_time", Type: "date_time"},
		10:  {Name: "observed_location_lat", Unit: "semicircles"},
		11:  {Name: "observed_location_long", Unit: "semicircles"},
		12:  {Name: "day_of_week", Type: "day_of_week"},
		13:  {Name: "high_temperature", Unit: "C"},
		14:  {Name: "low_temperature", Unit: "C"},
	},
	129: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "report_id"},
		1:   {Name: "issue_time", Type: "date_time"},
		2:   {Name: "expire_time", Type: "date_time"},
		3:   {Name: "severity", Type: "weather_severity"},
		4:   {Name: "type", Type: "weather_severe_type"},
	},
	131: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "high_value", Unit: "rpm"},
		1:   {Name: "name"},
	},
	132: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "fractional_timestamp", Unit: "s", Scale: 32768},
		1:   {Name: "time256", Unit: "s", Scale: 256},
		6:   {Name: "filtered_bpm", Unit: "bpm"},
		9:   {Name: "event_timestamp", Unit: "s", Scale: 1024},
		10:  {Name: "event_timestamp_12", Unit: "s"},
	},
	142: {
		254: {Name: "message_index", Type: "message_index"},
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "event", Type: "event"},
		1:   {Name: "event_type", Type: "event_type"},
		2:   {Name: "start_time", Type: "date_time"},
		3:   {Name: "start_position_lat", Unit: "semicircles"},
		4:   {Name: "start_position_long", Unit: "semicircles"},
		5:   {Name: "end_position_lat", Unit: "semicircles"},
		6:   {Name: "end_position_long", Unit: "semicircles"},
		7:   {Name: "total_elapsed_time", Unit: "s", Scale: 1000},
		8:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		9:   {Name: "total_distance", Unit: "m", Scale: 100},
		10:  {Name: "total_cycles", Unit: "cycles", HasSubField: true},
		11:  {Name: "total_calories", Unit: "kcal"},
		12:  {Name: "total_fat_calories", Unit: "kcal"},
		13:  {Name: "avg_speed", Unit: "m/s", Scale: 1000},
		14:  {Name: "max_speed", Unit: "m/s", Scale: 1000},
		15:  {Name: "avg_heart_rate", Unit: "bpm"},
		16:  {Name: "max_heart_rate", Unit: "bpm"},
		17:  {Name: "avg_cadence", Unit: "rpm"},
		18:  {Name: "max_cadence", Unit: "rpm"},
		19:  {Name: "avg_power", Unit: "watts"},
		20:  {Name: "max_power", Unit: "watts"},
		21:  {Name: "total_ascent", Unit: "m"},
		22:  {Name: "total_descent", Unit: "m"},
		23:  {Name: "sport", Type: "sport"},
		24:  {Name: "event_group"},
		25:  {Name: "nec_lat", Unit: "semicircles"},
		26:  {Name: "nec_long", Unit: "semicircles"},
		27:  {Name: "swc_lat", Unit: "semicircles"},
		28:  {Name: "swc_long", Unit: "semicircles"},
		29:  {Name: "name"},
		30:  {Name: "normalized_power", Unit: "watts"},
		31:  {Name: "left_right_balance", Type: "left_right_balance_100"},
		32:  {Name: "sub_sport", Type: "sub_sport"},
		33:  {Name: "total_work", Unit: "J"},
		34:  {Name: "avg_altitude", Unit: "m", Scale: 5, Offset: 500},
		35:  {Name: "max_altitude", Unit: "m", Scale: 5, Offset: 500},
		36:  {Name: "gps_accuracy", Unit: "m"},
		37:  {Name: "avg_grade", Unit: "%", Scale: 100},
		38:  {Name: "avg_pos_grade", Unit: "%", Scale: 100},
		39:  {Name: "avg_neg_grade", Unit: "%", Scale: 100},
		40:  {Name: "max_pos_grade", Unit: "%", Scale: 100},
		41:  {Name: "max_neg_grade", Unit: "%", Scale: 100},
		42:  {Name: "avg_temperature", Unit: "C"},
		43:  {Name: "max_temperature", Unit: "C"},
		44:  {Name: "total_moving_time", Unit: "s", Scale: 1000},
		45:  {Name: "avg_pos_vertical_speed", Unit: "m/s", Scale: 1000},
		46:  {Name: "avg_neg_vertical_speed", Unit: "m/s", Scale: 1000},
		47:  {Name: "max_pos_vertical_speed", Unit: "m/s", Scale: 1000},
		48:  {Name: "max_neg_vertical_speed", Unit: "m/s", Scale: 1000},
		49:  {Name: "time_in_hr_zone", Unit: "s", Scale: 1000},
		50:  {Name: "time_in_speed_zone", Unit: "s", Scale: 1000},
		51:  {Name: "time_in_cadence_zone", Unit: "s", Scale: 1000},
		52:  {Name: "time_in_power_zone", Unit: "s", Scale: 1000},
		53:  {Name: "repetition_num"},
		54:  {Name: "min_altitude", Unit: "m", Scale: 5, Offset: 500},
		55:  {Name: "min_heart_rate", Unit: "bpm"},
		56:  {Name: "active_time", Unit: "s", Scale: 1000},
		57:  {Name: "wkt_step_index", Type: "message_index"},
		58:  {Name: "sport_event", Type: "sport_event"},
		59:  {Name: "avg_left_torque_effectiveness", Unit: "percent", Scale: 2},
		60:  {Name: "avg_right_torque_effectiveness", Unit: "percent", Scale: 2},
		61:  {Name: "avg_left_pedal_smoothness", Unit: "percent", Scale: 2},
		62:  {Name: "avg_right_pedal_smoothness", Unit: "percent", Scale: 2},
		63:  {Name: "avg_combined_pedal_smoothness", Unit: "percent", Scale: 2},
		64:  {Name: "status", Type: "segment_lap_status"},
		65:  {Name: "uuid"},
		66:  {Name: "avg_fractional_cadence", Unit: "rpm", Scale: 128},
		67:  {Name: "max_fractional_cadence", Unit: "rpm", Scale: 128},
		68:  {Name: "total_fractional_cycles", Unit: "cycles", Scale: 128},
		69:  {Name: "front_gear_shift_count"},
		70:  {Name: "rear_gear_shift_count"},
		71:  {Name: "time_standing", Unit: "s", Scale: 1000},
		72:  {Name: "stand_count"},
		73:  {Name: "avg_left_pco", Unit: "mm"},
		74:  {Name: "avg_right_pco", Unit: "mm"},
		75:  {Name: "avg_left_power_phase", Unit: "degrees", Scale: 0.7111111},
		76:  {Name: "avg_left_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		77:  {Name: "avg_right_power_phase", Unit: "degrees", Scale: 0.7111111},
		78:  {Name: "avg_right_power_phase_peak", Unit: "degrees", Scale: 0.7111111},
		79:  {Name: "avg_power_position", Unit: "watts"},
		80:  {Name: "max_power_position", Unit: "watts"},
		81:  {Name: "avg_cadence_position", Unit: "rpm"},
		82:  {Name: "max_cadence_position", Unit: "rpm"},
		83:  {Name: "manufacturer", Type: "manufacturer"},
		84:  {Name: "total_grit", Unit: "kGrit"},
		85:  {Name: "total_flow", Unit: "Flow"},
		86:  {Name: "avg_grit", Unit: "kGrit"},
		87:  {Name: "avg_flow", Unit: "Flow"},
		89:  {Name: "total_fractional_ascent", Unit: "m", Scale: 100},
		90:  {Name: "total_fractional_descent", Unit: "m", Scale: 100},
		91:  {Name: "enhanced_avg_altitude", Unit: "m", Scale: 5, Offset: 500},
		92:  {Name: "enhanced_max_altitude", Unit: "m", Scale: 5, Offset: 500},
		93:  {Name: "enhanced_min_altitude", Unit: "m", Scale: 5, Offset: 500},
	},
	145: {
		250: {Name: "part_index"},
		0:   {Name: "memo"},
		1:   {Name: "mesg_num", Type: "mesg_num"},
		2:   {Name: "parent_index", Type: "message_index"},
		3:   {Name: "field_num"},
		4:   {Name: "data"},
	},
	148: {
		0: {Name: "name"},
		1: {Name: "uuid"},
		2: {Name: "sport", Type: "sport"},
		3: {Name: "enabled"},
		4: {Name: "user_profile_primary_key"},
		5: {Name: "device_id"},
		6: {Name: "default_race_leader"},
		7: {Name: "delete_status", Type: "segment_delete_status"},
		8: {Name: "selection_type", Type: "segment_selection_type"},
	},
	149: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "name"},
		1:   {Name: "type", Type: "segment_leaderboard_type"},
		2:   {Name: "group_primary_key"},
		3:   {Name: "activity_id"},
		4:   {Name: "segment_time", Unit: "s", Scale: 1000},
		5:   {Name: "activity_id_string"},
	},
	150: {
		254: {Name: "message_index", Type: "message_index"},
		1:   {Name: "position_lat", Unit: "semicircles"},
		2:   {Name: "position_long", Unit: "semicircles"},
		3:   {Name: "distance", Unit: "m", Scale: 100},
		4:   {Name: "altitude", Unit: "m", Scale: 5, Offset: 500},
		5:   {Name: "leader_time", Unit: "s", Scale: 1000},
		6:   {Name: "enhanced_altitude", Unit: "m", Scale: 5, Offset: 500},
	},
	151: {
		254: {Name: "message_index", Type: "message_index"},
		1:   {Name: "file_uuid"},
		3:   {Name: "enabled"},
		4:   {Name: "user_profile_primary_key"},
		7:   {Name: "leader_type", Type: "segment_leaderboard_type"},
		8:   {Name: "leader_group_primary_key"},
		9:   {Name: "leader_activity_id"},
		10:  {Name: "leader_activity_id_string"},
		11:  {Name: "default_race_leader"},
	},
	158: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "sport", Type: "sport"},
		1:   {Name: "sub_sport", Type: "sub_sport"},
		2:   {Name: "num_valid_steps"},
		3:   {Name: "first_step_index"},
		4:   {Name: "pool_length", Unit: "m", Scale: 100},
		5:   {Name: "pool_length_unit", Type: "display_measure"},
	},
	159: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "mode", Type: "watchface_mode"},
		1:   {Name: "layout", HasSubField: true},
	},
	160: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "position_lat", Unit: "semicircles"},
		2:   {Name: "position_long", Unit: "semicircles"},
		3:   {Name: "enhanced_altitude", Unit: "m", Scale: 5, Offset: 500},
		4:   {Name: "enhanced_speed", Unit: "m/s", Scale: 1000},
		5:   {Name: "heading", Unit: "degrees", Scale: 100},
		6:   {Name: "utc_timestamp", Type: "date_time", Unit: "s"},
		7:   {Name: "velocity", Unit: "m/s", Scale: 100},
	},
	161: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "camera_event_type", Type: "camera_event_type"},
		2:   {Name: "camera_file_uuid"},
		3:   {Name: "camera_orientation", Type: "camera_orientation_type"},
	},
	162: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "fractional_timestamp", Unit: "s", Scale: 32768},
		1:   {Name: "system_timestamp", Type: "date_time", Unit: "s"},
		2:   {Name: "fractional_system_timestamp", Unit: "s", Scale: 32768},
		3:   {Name: "local_timestamp", Type: "local_date_time", Unit: "s"},
		4:   {Name: "timestamp_ms", Unit: "ms"},
		5:   {Name: "system_timestamp_ms", Unit: "ms"},
	},
	164: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "sample_time_offset", Unit: "ms"},
		2:   {Name: "gyro_x", Unit: "counts"},
		3:   {Name: "gyro_y", Unit: "counts"},
		4:   {Name: "gyro_z", Unit: "counts"},
		5:   {Name: "calibrated_gyro_x", Unit: "deg/s"},
		6:   {Name: "calibrated_gyro_y", Unit: "deg/s"},
		7:   {Name: "calibrated_gyro_z", Unit: "deg/s"},
	},
	165: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "sample_time_offset", Unit: "ms"},
		2:   {Name: "accel_x", Unit: "counts"},
		3:   {Name: "accel_y", Unit: "counts"},
		4:   {Name: "accel_z", Unit: "counts"},
		5:   {Name: "calibrated_accel_x", Unit: "g"},
		6:   {Name: "calibrated_accel_y", Unit: "g"},
		7:   {Name: "calibrated_accel_z", Unit: "g"},
		8:   {Name: "compressed_calibrated_accel_x", Unit: "mG"},
		9:   {Name: "compressed_calibrated_accel_y", Unit: "mG"},
		10:  {Name: "compressed_calibrated_accel_z", Unit: "mG"},
	},
	167: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "sensor_type", Type: "sensor_type"},
		1:   {Name: "calibration_factor", HasSubField: true},
		2:   {Name: "calibration_divisor", Unit: "counts"},
		3:   {Name: "level_shift"},
		4:   {Name: "offset_cal"},
		5:   {Name: "orientation_matrix", Scale: 65535},
	},
	169: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "frame_number"},
	},
	174: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "time_offset", Unit: "ms"},
		2:   {Name: "pid"},
		3:   {Name: "raw_data"},
		4:   {Name: "pid_data_size"},
		5:   {Name: "system_time"},
		6:   {Name: "start_timestamp", Type: "date_time"},
		7:   {Name: "start_timestamp_ms", Unit: "ms"},
	},
	177: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "sentence"},
	},
	178: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "system_time", Unit: "ms"},
		2:   {Name: "pitch", Unit: "radians", Scale: 10430.38},
		3:   {Name: "roll", Unit: "radians", Scale: 10430.38},
		4:   {Name: "accel_lateral", Unit: "m/s^2", Scale: 100},
		5:   {Name: "accel_normal", Unit: "m/s^2", Scale: 100},
		6:   {Name: "turn_rate", Unit: "radians/second", Scale: 1024},
		7:   {Name: "stage", Type: "attitude_stage"},
		8:   {Name: "attitude_stage_complete", Unit: "%"},
		9:   {Name: "track", Unit: "radians", Scale: 10430.38},
		10:  {Name: "validity", Type: "attitude_validity"},
	},
	184: {
		0: {Name: "url"},
		1: {Name: "hosting_provider"},
		2: {Name: "duration", Unit: "ms"},
	},
	185: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "message_count"},
		1:   {Name: "text"},
	},
	186: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "message_count"},
		1:   {Name: "text"},
	},
	187: {
		0: {Name: "clip_number"},
		1: {Name: "start_timestamp", Type: "date_time"},
		2: {Name: "start_timestamp_ms"},
		3: {Name: "end_timestamp", Type: "date_time"},
		4: {Name: "end_timestamp_ms"},
		6: {Name: "clip_start", Unit: "ms"},
		7: {Name: "clip_end", Unit: "ms"},
	},
	188: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "enabled", Type: "switch"},
	},
	200: {
		0: {Name: "screen_index"},
		1: {Name: "field_count"},
		2: {Name: "layout", Type: "exd_layout"},
		3: {Name: "screen_enabled"},
	},
	201: {
		0: {Name: "screen_index"},
		1: {Name: "concept_field"},
		2: {Name: "field_id"},
		3: {Name: "concept_count"},
		4: {Name: "display_type", Type: "exd_display_type"},
		5: {Name: "title"},
	},
	202: {
		0:  {Name: "screen_index"},
		1:  {Name: "concept_field"},
		2:  {Name: "field_id"},
		3:  {Name: "concept_index"},
		4:  {Name: "data_page"},
		5:  {Name: "concept_key"},
		6:  {Name: "scaling"},
		8:  {Name: "data_units", Type: "exd_data_units"},
		9:  {Name: "qualifier", Type: "exd_qualifiers"},
		10: {Name: "descriptor", Type: "exd_descriptors"},
		11: {Name: "is_signed"},
	},
	206: {
		0:  {Name: "developer_data_index"},
		1:  {Name: "field_definition_number"},
		2:  {Name: "fit_base_type_id", Type: "fit_base_type"},
		3:  {Name: "field_name"},
		4:  {Name: "array"},
		5:  {Name: "components"},
		6:  {Name: "scale"},
		7:  {Name: "offset"},
		8:  {Name: "units"},
		9:  {Name: "bits"},
		10: {Name: "accumulate"},
		13: {Name: "fit_base_unit_id", Type: "fit_base_unit"},
		14: {Name: "native_mesg_num", Type: "mesg_num"},
		15: {Name: "native_field_num"},
	},
	207: {
		0: {Name: "developer_id"},
		1: {Name: "application_id"},
		2: {Name: "manufacturer_id", Type: "manufacturer"},
		3: {Name: "developer_data_index"},
		4: {Name: "application_version"},
	},
	208: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "sample_time_offset", Unit: "ms"},
		2:   {Name: "mag_x", Unit: "counts"},
		3:   {Name: "mag_y", Unit: "counts"},
		4:   {Name: "mag_z", Unit: "counts"},
		5:   {Name: "calibrated_mag_x", Unit: "G"},
		6:   {Name: "calibrated_mag_y", Unit: "G"},
		7:   {Name: "calibrated_mag_z", Unit: "G"},
	},
	209: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "sample_time_offset", Unit: "ms"},
		2:   {Name: "baro_pres", Unit: "Pa"},
	},
	210: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "sensor_type", Type: "sensor_type"},
		1:   {Name: "calibration_factor", HasSubField: true},
		2:   {Name: "calibration_divisor", Unit: "counts"},
		3:   {Name: "level_shift"},
		4:   {Name: "offset_cal"},
	},
	211: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "resting_heart_rate", Unit: "bpm"},
		1:   {Name: "current_day_resting_heart_rate", Unit: "bpm"},
	},
	216: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "reference_mesg", Type: "mesg_num"},
		1:   {Name: "reference_index", Type: "message_index"},
		2:   {Name: "time_in_hr_zone", Unit: "s", Scale: 1000},
		3:   {Name: "time_in_speed_zone", Unit: "s", Scale: 1000},
		4:   {Name: "time_in_cadence_zone", Unit: "s", Scale: 1000},
		5:   {Name: "time_in_power_zone", Unit: "s", Scale: 1000},
		6:   {Name: "hr_zone_high_boundary", Unit: "bpm"},
		7:   {Name: "speed_zone_high_boundary", Unit: "m/s", Scale: 1000},
		8:   {Name: "cadence_zone_high_boundary", Unit: "rpm"},
		9:   {Name: "power_zone_high_boundary", Unit: "watts"},
		10:  {Name: "hr_calc_type", Type: "hr_zone_calc"},
		11:  {Name: "max_heart_rate"},
		12:  {Name: "resting_heart_rate"},
		13:  {Name: "threshold_heart_rate"},
		14:  {Name: "pwr_calc_type", Type: "pwr_zone_calc"},
		15:  {Name: "functional_threshold_power"},
	},
	225: {
		254: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "duration", Unit: "s", Scale: 1000},
		3:   {Name: "repetitions"},
		4:   {Name: "weight", Unit: "kg", Scale: 16},
		5:   {Name: "set_type", Type: "set_type"},
		6:   {Name: "start_time", Type: "date_time"},
		7:   {Name: "category", Type: "exercise_category"},
		8:   {Name: "category_subtype"},
		9:   {Name: "weight_display_unit", Type: "fit_base_unit"},
		10:  {Name: "message_index", Type: "message_index"},
		11:  {Name: "wkt_step_index", Type: "message_index"},
	},
	227: {
		0: {Name: "stress_level_value"},
		1: {Name: "stress_level_time", Type: "date_time", Unit: "s"},
	},
	229: {
		0:  {Name: "update_time", Type: "date_time"},
		2:  {Name: "vo2_max", Unit: "mL/kg/min", Scale: 10},
		5:  {Name: "sport", Type: "sport"},
		6:  {Name: "sub_sport", Type: "sub_sport"},
		8:  {Name: "max_met_category", Type: "max_met_category"},
		9:  {Name: "calibrated_data"},
		12: {Name: "hr_source", Type: "max_met_heart_rate_source"},
		13: {Name: "speed_source", Type: "max_met_speed_source"},
	},
	258: {
		253: {Name: "timestamp", Type: "date_time"},
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "name"},
		1:   {Name: "model", Type: "tissue_model_type"},
		2:   {Name: "gf_low", Unit: "percent"},
		3:   {Name: "gf_high", Unit: "percent"},
		4:   {Name: "water_type", Type: "water_type"},
		5:   {Name: "water_density", Unit: "kg/m^3"},
		6:   {Name: "po2_warn", Unit: "percent", Scale: 100},
		7:   {Name: "po2_critical", Unit: "percent", Scale: 100},
		8:   {Name: "po2_deco", Unit: "percent", Scale: 100},
		9:   {Name: "safety_stop_enabled"},
		10:  {Name: "bottom_depth"},
		11:  {Name: "bottom_time"},
		12:  {Name: "apnea_countdown_enabled"},
		13:  {Name: "apnea_countdown_time"},
		14:  {Name: "backlight_mode", Type: "dive_backlight_mode"},
		15:  {Name: "backlight_brightness"},
		16:  {Name: "backlight_timeout", Type: "backlight_timeout"},
		17:  {Name: "repeat_dive_interval", Unit: "s", Scale: 1},
		18:  {Name: "safety_stop_time", Unit: "s", Scale: 1},
		19:  {Name: "heart_rate_source_type", Type: "source_type"},
		20:  {Name: "heart_rate_source", HasSubField: true},
		21:  {Name: "travel_gas", Type: "message_index"},
		22:  {Name: "ccr_low_setpoint_switch_mode", Type: "ccr_setpoint_switch_mode"},
		23:  {Name: "ccr_low_setpoint", Unit: "percent", Scale: 100},
		24:  {Name: "ccr_low_setpoint_depth", Unit: "m", Scale: 1000},
		25:  {Name: "ccr_high_setpoint_switch_mode", Type: "ccr_setpoint_switch_mode"},
		26:  {Name: "ccr_high_setpoint", Unit: "percent", Scale: 100},
		27:  {Name: "ccr_high_setpoint_depth", Unit: "m", Scale: 1000},
		29:  {Name: "gas_consumption_display", Type: "gas_consumption_rate_type"},
		30:  {Name: "up_key_enabled"},
		35:  {Name: "dive_sounds", Type: "tone"},
		36:  {Name: "last_stop_multiple", Scale: 10},
		37:  {Name: "no_fly_time_mode", Type: "no_fly_time_mode"},
	},
	259: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "helium_content", Unit: "percent"},
		1:   {Name: "oxygen_content", Unit: "percent"},
		2:   {Name: "status", Type: "dive_gas_status"},
		3:   {Name: "mode", Type: "dive_gas_mode"},
	},
	262: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "depth", Unit: "m", Scale: 1000},
		1:   {Name: "time", Unit: "s", Scale: 1},
		2:   {Name: "enabled"},
		3:   {Name: "alarm_type", Type: "dive_alarm_type"},
		4:   {Name: "sound", Type: "tone"},
		5:   {Name: "dive_types", Type: "sub_sport"},
		6:   {Name: "id"},
		7:   {Name: "popup_enabled"},
		8:   {Name: "trigger_on_descent"},
		9:   {Name: "trigger_on_ascent"},
		10:  {Name: "repeating"},
		11:  {Name: "speed", Unit: "mps", Scale: 1000},
	},
	264: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "exercise_category", Type: "exercise_category"},
		1:   {Name: "exercise_name"},
		2:   {Name: "wkt_step_name"},
	},
	268: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "reference_mesg", Type: "mesg_num"},
		1:   {Name: "reference_index", Type: "message_index"},
		2:   {Name: "avg_depth", Unit: "m", Scale: 1000},
		3:   {Name: "max_depth", Unit: "m", Scale: 1000},
		4:   {Name: "surface_interval", Unit: "s", Scale: 1},
		5:   {Name: "start_cns", Unit: "percent", Scale: 1},
		6:   {Name: "end_cns", Unit: "percent", Scale: 1},
		7:   {Name: "start_n2", Unit: "percent", Scale: 1},
		8:   {Name: "end_n2", Unit: "percent", Scale: 1},
		9:   {Name: "o2_toxicity", Unit: "OTUs"},
		10:  {Name: "dive_number"},
		11:  {Name: "bottom_time", Unit: "s", Scale: 1000},
		12:  {Name: "avg_pressure_sac", Unit: "bar/min", Scale: 100},
		13:  {Name: "avg_volume_sac", Unit: "L/min", Scale: 100},
		14:  {Name: "avg_rmv", Unit: "L/min", Scale: 100},
		15:  {Name: "descent_time", Unit: "s", Scale: 1000},
		16:  {Name: "ascent_time", Unit: "s", Scale: 1000},
		17:  {Name: "avg_ascent_rate", Unit: "m/s", Scale: 1000},
		22:  {Name: "avg_descent_rate", Unit: "m/s", Scale: 1000},
		23:  {Name: "max_ascent_rate", Unit: "m/s", Scale: 1000},
		24:  {Name: "max_descent_rate", Unit: "m/s", Scale: 1000},
		25:  {Name: "hang_time", Unit: "s", Scale: 1000},
	},
	269: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "reading_spo2", Unit: "percent", Scale: 1},
		1:   {Name: "reading_confidence", Scale: 1},
		2:   {Name: "mode", Type: "spo2_measurement_type"},
	},
	275: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "sleep_level", Type: "sleep_level"},
	},
	285: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "distance", Unit: "m"},
		1:   {Name: "height", Unit: "m"},
		2:   {Name: "rotations"},
		3:   {Name: "hang_time", Unit: "s"},
		4:   {Name: "score"},
		5:   {Name: "position_lat", Unit: "semicircles"},
		6:   {Name: "position_long", Unit: "semicircles"},
		7:   {Name: "speed", Unit: "m/s", Scale: 1000},
		8:   {Name: "enhanced_speed", Unit: "m/s", Scale: 1000},
	},
	290: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "timestamp_ms", Unit: "ms"},
		1:   {Name: "time", Unit: "ms"},
	},
	297: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "respiration_rate", Unit: "breaths/min", Scale: 100},
	},
	312: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "split_type", Type: "split_type"},
		1:   {Name: "total_elapsed_time", Unit: "s", Scale: 1000},
		2:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		3:   {Name: "total_distance", Unit: "m", Scale: 100},
		4:   {Name: "avg_speed", Unit: "m/s", Scale: 1000},
		9:   {Name: "start_time", Type: "date_time"},
		13:  {Name: "total_ascent", Unit: "m"},
		14:  {Name: "total_descent", Unit: "m"},
		21:  {Name: "start_position_lat", Unit: "semicircles"},
		22:  {Name: "start_position_long", Unit: "semicircles"},
		23:  {Name: "end_position_lat", Unit: "semicircles"},
		24:  {Name: "end_position_long", Unit: "semicircles"},
		25:  {Name: "max_speed", Unit: "m/s", Scale: 1000},
		26:  {Name: "avg_vert_speed", Unit: "m/s", Scale: 1000},
		27:  {Name: "end_time", Type: "date_time"},
		28:  {Name: "total_calories", Unit: "kcal"},
		74:  {Name: "start_elevation", Unit: "m", Scale: 5, Offset: 500},
		110: {Name: "total_moving_time", Unit: "s", Scale: 1000},
	},
	313: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "split_type", Type: "split_type"},
		3:   {Name: "num_splits"},
		4:   {Name: "total_timer_time", Unit: "s", Scale: 1000},
		5:   {Name: "total_distance", Unit: "m", Scale: 100},
		6:   {Name: "avg_speed", Unit: "m/s", Scale: 1000},
		7:   {Name: "max_speed", Unit: "m/s", Scale: 1000},
		8:   {Name: "total_ascent", Unit: "m"},
		9:   {Name: "total_descent", Unit: "m"},
		10:  {Name: "avg_heart_rate", Unit: "bpm"},
		11:  {Name: "max_heart_rate", Unit: "bpm"},
		12:  {Name: "avg_vert_speed", Unit: "m/s", Scale: 1000},
		13:  {Name: "total_calories", Unit: "kcal"},
		77:  {Name: "total_moving_time", Unit: "s", Scale: 1000},
	},
	317: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "position_lat", Unit: "semicircles"},
		1:   {Name: "position_long", Unit: "semicircles"},
		2:   {Name: "climb_pro_event", Type: "climb_pro_event"},
		3:   {Name: "climb_number"},
		4:   {Name: "climb_category"},
		5:   {Name: "current_dist", Unit: "m"},
	},
	319: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "sensor", Type: "ant_channel_id"},
		1:   {Name: "pressure", Unit: "bar", Scale: 100},
	},
	323: {
		253: {Name: "timestamp", Type: "date_time", Unit: "s"},
		0:   {Name: "sensor", Type: "ant_channel_id"},
		1:   {Name: "start_pressure", Unit: "bar", Scale: 100},
		2:   {Name: "end_pressure", Unit: "bar", Scale: 100},
		3:   {Name: "volume_used", Unit: "L", Scale: 100},
	},
	346: {
		0:  {Name: "combined_awake_score"},
		1:  {Name: "awake_time_score"},
		2:  {Name: "awakenings_count_score"},
		3:  {Name: "deep_sleep_score"},
		4:  {Name: "sleep_duration_score"},
		5:  {Name: "light_sleep_score"},
		6:  {Name: "overall_sleep_score"},
		7:  {Name: "sleep_quality_score"},
		8:  {Name: "sleep_recovery_score"},
		9:  {Name: "rem_sleep_score"},
		10: {Name: "sleep_restlessness_score"},
		11: {Name: "awakenings_count"},
		14: {Name: "interruptions_score"},
		15: {Name: "average_stress_during_sleep", Scale: 100},
	},
	370: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "weekly_average", Unit: "ms", Scale: 128},
		1:   {Name: "last_night_average", Unit: "ms", Scale: 128},
		2:   {Name: "last_night_5_min_high", Unit: "ms", Scale: 128},
		3:   {Name: "baseline_low_upper", Unit: "ms", Scale: 128},
		4:   {Name: "baseline_balanced_lower", Unit: "ms", Scale: 128},
		5:   {Name: "baseline_balanced_upper", Unit: "ms", Scale: 128},
		6:   {Name: "status", Type: "hrv_status"},
	},
	371: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "value", Unit: "ms", Scale: 128},
	},
	375: {
		253: {Name: "timestamp", Type: "date_time"},
		0:   {Name: "device_index", Type: "device_index"},
		1:   {Name: "battery_voltage", Unit: "V", Scale: 256},
		2:   {Name: "battery_status", Type: "battery_status"},
		3:   {Name: "battery_identifier"},
	},
	393: {
		254: {Name: "message_index", Type: "message_index"},
		0:   {Name: "depth", Unit: "m", Scale: 1000},
		1:   {Name: "time", Unit: "s", Scale: 1},
		2:   {Name: "enabled"},
		3:   {Name: "alarm_type", Type: "dive_alarm_type"},
		4:   {Name: "sound", Type: "tone"},
		5:   {Name: "dive_types", Type: "sub_sport"},
		6:   {Name: "id"},
		7:   {Name: "popup_enabled"},
		8:   {Name: "trigger_on_descent"},
		9:   {Name: "trigger_on_ascent"},
		10:  {Name: "repeating"},
		11:  {Name: "speed", Unit: "mps", Scale: 1000},
	},
}
