
#include "ledChannel.h"

ledChannel::ledChannel( int pin )
{
  pinMode(pin, OUTPUT);

  this->pin = pin;
}

byte
ledChannel::value() const
{
  int v = _value * dim + 0.5;

  if( v > 255 )
    v = 255;

  return v;
}

void
ledChannel::setValue( byte v )
{
#if 0
  dim = 1.0;
  _value = v;
#else
  dim = v / 255.0;
  _value = 255;
#endif

  analogWrite(pin, value());
}

bool
ledChannel::dimUp()
{
  if( value() == 255 )
    return false;
  else if( !value() )
    dim = 1/_value;
  else
    dim *= 1.1;

  analogWrite(pin, value());

  return true;
}

bool
ledChannel::dimDown()
{
  if( !value() )
    return false;

  dim *= 0.9;

  analogWrite(pin, value());

  return true;
}
