/*
 * Copyright (c) 1999-2001,2004,2011,2014 Apple Inc. All Rights Reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 *
 * oidscrl.h -- Object Identifiers for X509 CRLs and OCSP
 */

#ifndef _OIDSCRL_H_
#define _OIDSCRL_H_  1

#include <Security/cssmconfig.h>
#include <Security/cssmtype.h>
#include <Security/oidsbase.h>

#ifdef __cplusplus
extern "C" {
#endif

#define INTEL_X509V2_CRL_R08 INTEL_SEC_FORMATS, 2, 1
#define INTEL_X509V2_CRL_R08_LENGTH INTEL_SEC_FORMATS_LENGTH+2

	
extern const CSSM_OID
    /* CRL OIDs */
	CSSMOID_X509V2CRLSignedCrlStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLSignedCrlCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLTbsCertListStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLTbsCertListCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLVersion DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLIssuerStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLIssuerNameCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLIssuerNameLDAP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLThisUpdate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLNextUpdate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 

	/* CRL Entry (CRL CertList) OIDS */
	CSSMOID_X509V1CRLRevokedCertificatesStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLRevokedCertificatesCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLNumberOfRevokedCertEntries DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLRevokedEntryStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLRevokedEntryCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLRevokedEntrySerialNumber DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V1CRLRevokedEntryRevocationDate DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 

	/* CRL Entry (CRL CertList) Extension OIDs */
	CSSMOID_X509V2CRLRevokedEntryAllExtensionsStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntryAllExtensionsCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntryNumberOfExtensions DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntrySingleExtensionStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntrySingleExtensionCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntryExtensionId DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntryExtensionCritical DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntryExtensionType DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLRevokedEntryExtensionValue DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 

	/* CRL Extension OIDs */
	CSSMOID_X509V2CRLAllExtensionsStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLAllExtensionsCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLNumberOfExtensions DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLSingleExtensionStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLSingleExtensionCStruct DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLExtensionId DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLExtensionCritical DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_X509V2CRLExtensionType DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	
	/* OCSP */
	CSSMOID_PKIX_OCSP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_BASIC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_NONCE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_CRL DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_RESPONSE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_NOCHECK DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_ARCHIVE_CUTOFF DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 
	CSSMOID_PKIX_OCSP_SERVICE_LOCATOR DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

	
#ifdef __cplusplus
}
#endif

#endif /* _OIDSCRL_H_ */
