---
layout: post
title: "CVE-2022-46149: Possible out-of-bounds read related to list-of-pointers"
author: kentonv
---

David Renshaw, the author of the Rust implementation of Cap'n Proto, discovered a security vulnerability affecting both the C++ and Rust implementations of Cap'n Proto. The vulnerability was discovered using fuzzing. In theory, the vulnerability could lead to out-of-bounds reads which could cause crashes or perhaps exfiltration of memory.

The vulnerability is exploitable only if an application performs a certain unusual set of actions. As of this writing, we are not aware of any applications that are actually affected. However, out of an abundance of caution, we are issuing a security advisory and advising everyone to patch.

[Our security advisory](https://github.com/capnproto/capnproto/blob/master/security-advisories/2022-11-30-0-pointer-list-bounds.md) explains the impact of the bug, what an app must do to be affected, and where to find the fix.

Check out [David's blog post](https://dwrensha.github.io/capnproto-rust/2022/11/30/out_of_bounds_memory_access_bug.html) for an in-depth explanation of the bug itself, including some of the inner workings of Cap'n Proto.
