// Code generated by protoc-gen-go. DO NOT EDIT.
// source: api/v3/clairpb/clair.proto

/*
Package clairpb is a generated protocol buffer package.

It is generated from these files:
	api/v3/clairpb/clair.proto

It has these top-level messages:
	Vulnerability
	Detector
	Namespace
	Feature
	Layer
	ClairStatus
	GetAncestryRequest
	GetAncestryResponse
	PostAncestryRequest
	PostAncestryResponse
	GetNotificationRequest
	GetNotificationResponse
	PagedVulnerableAncestries
	MarkNotificationAsReadRequest
	MarkNotificationAsReadResponse
	GetStatusRequest
	GetStatusResponse
*/
package clairpb

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Detector_DType int32

const (
	Detector_DETECTOR_D_TYPE_INVALID   Detector_DType = 0
	Detector_DETECTOR_D_TYPE_NAMESPACE Detector_DType = 1
	Detector_DETECTOR_D_TYPE_FEATURE   Detector_DType = 2
)

var Detector_DType_name = map[int32]string{
	0: "DETECTOR_D_TYPE_INVALID",
	1: "DETECTOR_D_TYPE_NAMESPACE",
	2: "DETECTOR_D_TYPE_FEATURE",
}
var Detector_DType_value = map[string]int32{
	"DETECTOR_D_TYPE_INVALID":   0,
	"DETECTOR_D_TYPE_NAMESPACE": 1,
	"DETECTOR_D_TYPE_FEATURE":   2,
}

func (x Detector_DType) String() string {
	return proto.EnumName(Detector_DType_name, int32(x))
}
func (Detector_DType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

type Vulnerability struct {
	// The name of the vulnerability.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the namespace in which the vulnerability was detected.
	NamespaceName string `protobuf:"bytes,2,opt,name=namespace_name,json=namespaceName" json:"namespace_name,omitempty"`
	// A description of the vulnerability according to the source for the
	// namespace.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// A link to the vulnerability according to the source for the namespace.
	Link string `protobuf:"bytes,4,opt,name=link" json:"link,omitempty"`
	// How dangerous the vulnerability is.
	Severity string `protobuf:"bytes,5,opt,name=severity" json:"severity,omitempty"`
	// Namespace agnostic metadata about the vulnerability.
	Metadata string `protobuf:"bytes,6,opt,name=metadata" json:"metadata,omitempty"`
	// The feature that fixes this vulnerability.
	// This field only exists when a vulnerability is a part of a Feature.
	FixedBy string `protobuf:"bytes,7,opt,name=fixed_by,json=fixedBy" json:"fixed_by,omitempty"`
	// The Features that are affected by the vulnerability.
	// This field only exists when a vulnerability is a part of a Notification.
	AffectedVersions []*Feature `protobuf:"bytes,8,rep,name=affected_versions,json=affectedVersions" json:"affected_versions,omitempty"`
}

func (m *Vulnerability) Reset()                    { *m = Vulnerability{} }
func (m *Vulnerability) String() string            { return proto.CompactTextString(m) }
func (*Vulnerability) ProtoMessage()               {}
func (*Vulnerability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Vulnerability) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Vulnerability) GetNamespaceName() string {
	if m != nil {
		return m.NamespaceName
	}
	return ""
}

func (m *Vulnerability) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Vulnerability) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

func (m *Vulnerability) GetSeverity() string {
	if m != nil {
		return m.Severity
	}
	return ""
}

func (m *Vulnerability) GetMetadata() string {
	if m != nil {
		return m.Metadata
	}
	return ""
}

func (m *Vulnerability) GetFixedBy() string {
	if m != nil {
		return m.FixedBy
	}
	return ""
}

func (m *Vulnerability) GetAffectedVersions() []*Feature {
	if m != nil {
		return m.AffectedVersions
	}
	return nil
}

type Detector struct {
	// The name of the detector.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The version of the detector.
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// The type of the detector.
	Dtype Detector_DType `protobuf:"varint,3,opt,name=dtype,enum=coreos.clair.Detector_DType" json:"dtype,omitempty"`
}

func (m *Detector) Reset()                    { *m = Detector{} }
func (m *Detector) String() string            { return proto.CompactTextString(m) }
func (*Detector) ProtoMessage()               {}
func (*Detector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Detector) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Detector) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Detector) GetDtype() Detector_DType {
	if m != nil {
		return m.Dtype
	}
	return Detector_DETECTOR_D_TYPE_INVALID
}

type Namespace struct {
	// The name of the namespace.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The detector used to detect the namespace. This only exists when present
	// in an Ancestry Feature.
	Detector *Detector `protobuf:"bytes,2,opt,name=detector" json:"detector,omitempty"`
}

func (m *Namespace) Reset()                    { *m = Namespace{} }
func (m *Namespace) String() string            { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()               {}
func (*Namespace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Namespace) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Namespace) GetDetector() *Detector {
	if m != nil {
		return m.Detector
	}
	return nil
}

type Feature struct {
	// The name of the feature.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The namespace in which the feature is detected.
	Namespace *Namespace `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	// The specific version of this feature.
	Version string `protobuf:"bytes,3,opt,name=version" json:"version,omitempty"`
	// The format used to parse version numbers for the feature.
	VersionFormat string `protobuf:"bytes,4,opt,name=version_format,json=versionFormat" json:"version_format,omitempty"`
	// The detector used to detect this feature. This only exists when present
	// in an Ancestry.
	Detector *Detector `protobuf:"bytes,5,opt,name=detector" json:"detector,omitempty"`
	// The list of vulnerabilities that affect the feature.
	Vulnerabilities []*Vulnerability `protobuf:"bytes,6,rep,name=vulnerabilities" json:"vulnerabilities,omitempty"`
	// The feature type indicates if the feature represents a source package or
	// binary package.
	FeatureType string `protobuf:"bytes,7,opt,name=feature_type,json=featureType" json:"feature_type,omitempty"`
}

func (m *Feature) Reset()                    { *m = Feature{} }
func (m *Feature) String() string            { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()               {}
func (*Feature) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Feature) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Feature) GetNamespace() *Namespace {
	if m != nil {
		return m.Namespace
	}
	return nil
}

func (m *Feature) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Feature) GetVersionFormat() string {
	if m != nil {
		return m.VersionFormat
	}
	return ""
}

func (m *Feature) GetDetector() *Detector {
	if m != nil {
		return m.Detector
	}
	return nil
}

func (m *Feature) GetVulnerabilities() []*Vulnerability {
	if m != nil {
		return m.Vulnerabilities
	}
	return nil
}

func (m *Feature) GetFeatureType() string {
	if m != nil {
		return m.FeatureType
	}
	return ""
}

type Layer struct {
	// The sha256 tarsum for the layer.
	Hash string `protobuf:"bytes,1,opt,name=hash" json:"hash,omitempty"`
}

func (m *Layer) Reset()                    { *m = Layer{} }
func (m *Layer) String() string            { return proto.CompactTextString(m) }
func (*Layer) ProtoMessage()               {}
func (*Layer) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Layer) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

type ClairStatus struct {
	// The implemented detectors in this Clair instance
	Detectors []*Detector `protobuf:"bytes,1,rep,name=detectors" json:"detectors,omitempty"`
	// The time at which the updater last ran.
	LastUpdateTime *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=last_update_time,json=lastUpdateTime" json:"last_update_time,omitempty"`
}

func (m *ClairStatus) Reset()                    { *m = ClairStatus{} }
func (m *ClairStatus) String() string            { return proto.CompactTextString(m) }
func (*ClairStatus) ProtoMessage()               {}
func (*ClairStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ClairStatus) GetDetectors() []*Detector {
	if m != nil {
		return m.Detectors
	}
	return nil
}

func (m *ClairStatus) GetLastUpdateTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

type GetAncestryRequest struct {
	// The name of the desired ancestry.
	AncestryName string `protobuf:"bytes,1,opt,name=ancestry_name,json=ancestryName" json:"ancestry_name,omitempty"`
}

func (m *GetAncestryRequest) Reset()                    { *m = GetAncestryRequest{} }
func (m *GetAncestryRequest) String() string            { return proto.CompactTextString(m) }
func (*GetAncestryRequest) ProtoMessage()               {}
func (*GetAncestryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetAncestryRequest) GetAncestryName() string {
	if m != nil {
		return m.AncestryName
	}
	return ""
}

type GetAncestryResponse struct {
	// The ancestry requested.
	Ancestry *GetAncestryResponse_Ancestry `protobuf:"bytes,1,opt,name=ancestry" json:"ancestry,omitempty"`
	// The status of Clair at the time of the request
	Status *ClairStatus `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *GetAncestryResponse) Reset()                    { *m = GetAncestryResponse{} }
func (m *GetAncestryResponse) String() string            { return proto.CompactTextString(m) }
func (*GetAncestryResponse) ProtoMessage()               {}
func (*GetAncestryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetAncestryResponse) GetAncestry() *GetAncestryResponse_Ancestry {
	if m != nil {
		return m.Ancestry
	}
	return nil
}

func (m *GetAncestryResponse) GetStatus() *ClairStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type GetAncestryResponse_AncestryLayer struct {
	// The layer's information.
	Layer *Layer `protobuf:"bytes,1,opt,name=layer" json:"layer,omitempty"`
	// The features detected in this layer.
	DetectedFeatures []*Feature `protobuf:"bytes,2,rep,name=detected_features,json=detectedFeatures" json:"detected_features,omitempty"`
}

func (m *GetAncestryResponse_AncestryLayer) Reset()         { *m = GetAncestryResponse_AncestryLayer{} }
func (m *GetAncestryResponse_AncestryLayer) String() string { return proto.CompactTextString(m) }
func (*GetAncestryResponse_AncestryLayer) ProtoMessage()    {}
func (*GetAncestryResponse_AncestryLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{7, 0}
}

func (m *GetAncestryResponse_AncestryLayer) GetLayer() *Layer {
	if m != nil {
		return m.Layer
	}
	return nil
}

func (m *GetAncestryResponse_AncestryLayer) GetDetectedFeatures() []*Feature {
	if m != nil {
		return m.DetectedFeatures
	}
	return nil
}

type GetAncestryResponse_Ancestry struct {
	// The name of the desired ancestry.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The list of layers along with detected features in each.
	Layers []*GetAncestryResponse_AncestryLayer `protobuf:"bytes,3,rep,name=layers" json:"layers,omitempty"`
}

func (m *GetAncestryResponse_Ancestry) Reset()                    { *m = GetAncestryResponse_Ancestry{} }
func (m *GetAncestryResponse_Ancestry) String() string            { return proto.CompactTextString(m) }
func (*GetAncestryResponse_Ancestry) ProtoMessage()               {}
func (*GetAncestryResponse_Ancestry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 1} }

func (m *GetAncestryResponse_Ancestry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetAncestryResponse_Ancestry) GetLayers() []*GetAncestryResponse_AncestryLayer {
	if m != nil {
		return m.Layers
	}
	return nil
}

type PostAncestryRequest struct {
	// The name of the ancestry being scanned.
	// If scanning OCI images, this should be the hash of the manifest.
	AncestryName string `protobuf:"bytes,1,opt,name=ancestry_name,json=ancestryName" json:"ancestry_name,omitempty"`
	// The format of the image being uploaded.
	Format string `protobuf:"bytes,2,opt,name=format" json:"format,omitempty"`
	// The layers to be scanned for this Ancestry, ordered in the way that i th
	// layer is the parent of i + 1 th layer.
	Layers []*PostAncestryRequest_PostLayer `protobuf:"bytes,3,rep,name=layers" json:"layers,omitempty"`
}

func (m *PostAncestryRequest) Reset()                    { *m = PostAncestryRequest{} }
func (m *PostAncestryRequest) String() string            { return proto.CompactTextString(m) }
func (*PostAncestryRequest) ProtoMessage()               {}
func (*PostAncestryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *PostAncestryRequest) GetAncestryName() string {
	if m != nil {
		return m.AncestryName
	}
	return ""
}

func (m *PostAncestryRequest) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *PostAncestryRequest) GetLayers() []*PostAncestryRequest_PostLayer {
	if m != nil {
		return m.Layers
	}
	return nil
}

type PostAncestryRequest_PostLayer struct {
	// The hash of the layer.
	Hash string `protobuf:"bytes,1,opt,name=hash" json:"hash,omitempty"`
	// The location of the layer (URL or file path).
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Any HTTP Headers that need to be used if requesting a layer over
	// HTTP(S).
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PostAncestryRequest_PostLayer) Reset()         { *m = PostAncestryRequest_PostLayer{} }
func (m *PostAncestryRequest_PostLayer) String() string { return proto.CompactTextString(m) }
func (*PostAncestryRequest_PostLayer) ProtoMessage()    {}
func (*PostAncestryRequest_PostLayer) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{8, 0}
}

func (m *PostAncestryRequest_PostLayer) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *PostAncestryRequest_PostLayer) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *PostAncestryRequest_PostLayer) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

type PostAncestryResponse struct {
	// The status of Clair at the time of the request.
	Status *ClairStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *PostAncestryResponse) Reset()                    { *m = PostAncestryResponse{} }
func (m *PostAncestryResponse) String() string            { return proto.CompactTextString(m) }
func (*PostAncestryResponse) ProtoMessage()               {}
func (*PostAncestryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *PostAncestryResponse) GetStatus() *ClairStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type GetNotificationRequest struct {
	// The current page of previous vulnerabilities for the ancestry.
	// This will be empty when it is the first page.
	OldVulnerabilityPage string `protobuf:"bytes,1,opt,name=old_vulnerability_page,json=oldVulnerabilityPage" json:"old_vulnerability_page,omitempty"`
	// The current page of vulnerabilities for the ancestry.
	// This will be empty when it is the first page.
	NewVulnerabilityPage string `protobuf:"bytes,2,opt,name=new_vulnerability_page,json=newVulnerabilityPage" json:"new_vulnerability_page,omitempty"`
	// The requested maximum number of results per page.
	Limit int32 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	// The name of the notification being requested.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (m *GetNotificationRequest) Reset()                    { *m = GetNotificationRequest{} }
func (m *GetNotificationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNotificationRequest) ProtoMessage()               {}
func (*GetNotificationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GetNotificationRequest) GetOldVulnerabilityPage() string {
	if m != nil {
		return m.OldVulnerabilityPage
	}
	return ""
}

func (m *GetNotificationRequest) GetNewVulnerabilityPage() string {
	if m != nil {
		return m.NewVulnerabilityPage
	}
	return ""
}

func (m *GetNotificationRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetNotificationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type GetNotificationResponse struct {
	// The notification as requested.
	Notification *GetNotificationResponse_Notification `protobuf:"bytes,1,opt,name=notification" json:"notification,omitempty"`
}

func (m *GetNotificationResponse) Reset()                    { *m = GetNotificationResponse{} }
func (m *GetNotificationResponse) String() string            { return proto.CompactTextString(m) }
func (*GetNotificationResponse) ProtoMessage()               {}
func (*GetNotificationResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GetNotificationResponse) GetNotification() *GetNotificationResponse_Notification {
	if m != nil {
		return m.Notification
	}
	return nil
}

type GetNotificationResponse_Notification struct {
	// The name of the requested notification.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The time at which the notification was created.
	Created string `protobuf:"bytes,2,opt,name=created" json:"created,omitempty"`
	// The time at which the notification was last sent out.
	Notified string `protobuf:"bytes,3,opt,name=notified" json:"notified,omitempty"`
	// The time at which a notification has been deleted.
	Deleted string `protobuf:"bytes,4,opt,name=deleted" json:"deleted,omitempty"`
	// The previous vulnerability and a paginated view of the ancestries it
	// affects.
	Old *PagedVulnerableAncestries `protobuf:"bytes,5,opt,name=old" json:"old,omitempty"`
	// The newly updated vulnerability and a paginated view of the
	// ancestries it affects.
	New *PagedVulnerableAncestries `protobuf:"bytes,6,opt,name=new" json:"new,omitempty"`
}

func (m *GetNotificationResponse_Notification) Reset()         { *m = GetNotificationResponse_Notification{} }
func (m *GetNotificationResponse_Notification) String() string { return proto.CompactTextString(m) }
func (*GetNotificationResponse_Notification) ProtoMessage()    {}
func (*GetNotificationResponse_Notification) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11, 0}
}

func (m *GetNotificationResponse_Notification) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetNotificationResponse_Notification) GetCreated() string {
	if m != nil {
		return m.Created
	}
	return ""
}

func (m *GetNotificationResponse_Notification) GetNotified() string {
	if m != nil {
		return m.Notified
	}
	return ""
}

func (m *GetNotificationResponse_Notification) GetDeleted() string {
	if m != nil {
		return m.Deleted
	}
	return ""
}

func (m *GetNotificationResponse_Notification) GetOld() *PagedVulnerableAncestries {
	if m != nil {
		return m.Old
	}
	return nil
}

func (m *GetNotificationResponse_Notification) GetNew() *PagedVulnerableAncestries {
	if m != nil {
		return m.New
	}
	return nil
}

type PagedVulnerableAncestries struct {
	// The identifier for the current page.
	CurrentPage string `protobuf:"bytes,1,opt,name=current_page,json=currentPage" json:"current_page,omitempty"`
	// The token used to request the next page.
	// This will be empty when there are no more pages.
	NextPage string `protobuf:"bytes,2,opt,name=next_page,json=nextPage" json:"next_page,omitempty"`
	// The requested maximum number of results per page.
	Limit int32 `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	// The vulnerability that affects a given set of ancestries.
	Vulnerability *Vulnerability `protobuf:"bytes,4,opt,name=vulnerability" json:"vulnerability,omitempty"`
	// The ancestries affected by a vulnerability.
	Ancestries []*PagedVulnerableAncestries_IndexedAncestryName `protobuf:"bytes,5,rep,name=ancestries" json:"ancestries,omitempty"`
}

func (m *PagedVulnerableAncestries) Reset()                    { *m = PagedVulnerableAncestries{} }
func (m *PagedVulnerableAncestries) String() string            { return proto.CompactTextString(m) }
func (*PagedVulnerableAncestries) ProtoMessage()               {}
func (*PagedVulnerableAncestries) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *PagedVulnerableAncestries) GetCurrentPage() string {
	if m != nil {
		return m.CurrentPage
	}
	return ""
}

func (m *PagedVulnerableAncestries) GetNextPage() string {
	if m != nil {
		return m.NextPage
	}
	return ""
}

func (m *PagedVulnerableAncestries) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *PagedVulnerableAncestries) GetVulnerability() *Vulnerability {
	if m != nil {
		return m.Vulnerability
	}
	return nil
}

func (m *PagedVulnerableAncestries) GetAncestries() []*PagedVulnerableAncestries_IndexedAncestryName {
	if m != nil {
		return m.Ancestries
	}
	return nil
}

type PagedVulnerableAncestries_IndexedAncestryName struct {
	// The index is an ever increasing number associated with the particular
	// ancestry. This is useful if you're processing notifications, and need
	// to keep track of the progress of paginating the results.
	Index int32 `protobuf:"varint,1,opt,name=index" json:"index,omitempty"`
	// The name of the ancestry.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *PagedVulnerableAncestries_IndexedAncestryName) Reset() {
	*m = PagedVulnerableAncestries_IndexedAncestryName{}
}
func (m *PagedVulnerableAncestries_IndexedAncestryName) String() string {
	return proto.CompactTextString(m)
}
func (*PagedVulnerableAncestries_IndexedAncestryName) ProtoMessage() {}
func (*PagedVulnerableAncestries_IndexedAncestryName) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{12, 0}
}

func (m *PagedVulnerableAncestries_IndexedAncestryName) GetIndex() int32 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *PagedVulnerableAncestries_IndexedAncestryName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type MarkNotificationAsReadRequest struct {
	// The name of the Notification that has been processed.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *MarkNotificationAsReadRequest) Reset()                    { *m = MarkNotificationAsReadRequest{} }
func (m *MarkNotificationAsReadRequest) String() string            { return proto.CompactTextString(m) }
func (*MarkNotificationAsReadRequest) ProtoMessage()               {}
func (*MarkNotificationAsReadRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *MarkNotificationAsReadRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type MarkNotificationAsReadResponse struct {
}

func (m *MarkNotificationAsReadResponse) Reset()                    { *m = MarkNotificationAsReadResponse{} }
func (m *MarkNotificationAsReadResponse) String() string            { return proto.CompactTextString(m) }
func (*MarkNotificationAsReadResponse) ProtoMessage()               {}
func (*MarkNotificationAsReadResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type GetStatusRequest struct {
}

func (m *GetStatusRequest) Reset()                    { *m = GetStatusRequest{} }
func (m *GetStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*GetStatusRequest) ProtoMessage()               {}
func (*GetStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type GetStatusResponse struct {
	// The status of the current Clair instance.
	Status *ClairStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *GetStatusResponse) Reset()                    { *m = GetStatusResponse{} }
func (m *GetStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*GetStatusResponse) ProtoMessage()               {}
func (*GetStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetStatusResponse) GetStatus() *ClairStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*Vulnerability)(nil), "coreos.clair.Vulnerability")
	proto.RegisterType((*Detector)(nil), "coreos.clair.Detector")
	proto.RegisterType((*Namespace)(nil), "coreos.clair.Namespace")
	proto.RegisterType((*Feature)(nil), "coreos.clair.Feature")
	proto.RegisterType((*Layer)(nil), "coreos.clair.Layer")
	proto.RegisterType((*ClairStatus)(nil), "coreos.clair.ClairStatus")
	proto.RegisterType((*GetAncestryRequest)(nil), "coreos.clair.GetAncestryRequest")
	proto.RegisterType((*GetAncestryResponse)(nil), "coreos.clair.GetAncestryResponse")
	proto.RegisterType((*GetAncestryResponse_AncestryLayer)(nil), "coreos.clair.GetAncestryResponse.AncestryLayer")
	proto.RegisterType((*GetAncestryResponse_Ancestry)(nil), "coreos.clair.GetAncestryResponse.Ancestry")
	proto.RegisterType((*PostAncestryRequest)(nil), "coreos.clair.PostAncestryRequest")
	proto.RegisterType((*PostAncestryRequest_PostLayer)(nil), "coreos.clair.PostAncestryRequest.PostLayer")
	proto.RegisterType((*PostAncestryResponse)(nil), "coreos.clair.PostAncestryResponse")
	proto.RegisterType((*GetNotificationRequest)(nil), "coreos.clair.GetNotificationRequest")
	proto.RegisterType((*GetNotificationResponse)(nil), "coreos.clair.GetNotificationResponse")
	proto.RegisterType((*GetNotificationResponse_Notification)(nil), "coreos.clair.GetNotificationResponse.Notification")
	proto.RegisterType((*PagedVulnerableAncestries)(nil), "coreos.clair.PagedVulnerableAncestries")
	proto.RegisterType((*PagedVulnerableAncestries_IndexedAncestryName)(nil), "coreos.clair.PagedVulnerableAncestries.IndexedAncestryName")
	proto.RegisterType((*MarkNotificationAsReadRequest)(nil), "coreos.clair.MarkNotificationAsReadRequest")
	proto.RegisterType((*MarkNotificationAsReadResponse)(nil), "coreos.clair.MarkNotificationAsReadResponse")
	proto.RegisterType((*GetStatusRequest)(nil), "coreos.clair.GetStatusRequest")
	proto.RegisterType((*GetStatusResponse)(nil), "coreos.clair.GetStatusResponse")
	proto.RegisterEnum("coreos.clair.Detector_DType", Detector_DType_name, Detector_DType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for AncestryService service

type AncestryServiceClient interface {
	// The RPC used to read the results of scanning for a particular ancestry.
	GetAncestry(ctx context.Context, in *GetAncestryRequest, opts ...grpc.CallOption) (*GetAncestryResponse, error)
	// The RPC used to create a new scan of an ancestry.
	PostAncestry(ctx context.Context, in *PostAncestryRequest, opts ...grpc.CallOption) (*PostAncestryResponse, error)
}

type ancestryServiceClient struct {
	cc *grpc.ClientConn
}

func NewAncestryServiceClient(cc *grpc.ClientConn) AncestryServiceClient {
	return &ancestryServiceClient{cc}
}

func (c *ancestryServiceClient) GetAncestry(ctx context.Context, in *GetAncestryRequest, opts ...grpc.CallOption) (*GetAncestryResponse, error) {
	out := new(GetAncestryResponse)
	err := grpc.Invoke(ctx, "/coreos.clair.AncestryService/GetAncestry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *ancestryServiceClient) PostAncestry(ctx context.Context, in *PostAncestryRequest, opts ...grpc.CallOption) (*PostAncestryResponse, error) {
	out := new(PostAncestryResponse)
	err := grpc.Invoke(ctx, "/coreos.clair.AncestryService/PostAncestry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for AncestryService service

type AncestryServiceServer interface {
	// The RPC used to read the results of scanning for a particular ancestry.
	GetAncestry(context.Context, *GetAncestryRequest) (*GetAncestryResponse, error)
	// The RPC used to create a new scan of an ancestry.
	PostAncestry(context.Context, *PostAncestryRequest) (*PostAncestryResponse, error)
}

func RegisterAncestryServiceServer(s *grpc.Server, srv AncestryServiceServer) {
	s.RegisterService(&_AncestryService_serviceDesc, srv)
}

func _AncestryService_GetAncestry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAncestryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AncestryServiceServer).GetAncestry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coreos.clair.AncestryService/GetAncestry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AncestryServiceServer).GetAncestry(ctx, req.(*GetAncestryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AncestryService_PostAncestry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PostAncestryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AncestryServiceServer).PostAncestry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coreos.clair.AncestryService/PostAncestry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AncestryServiceServer).PostAncestry(ctx, req.(*PostAncestryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AncestryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "coreos.clair.AncestryService",
	HandlerType: (*AncestryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAncestry",
			Handler:    _AncestryService_GetAncestry_Handler,
		},
		{
			MethodName: "PostAncestry",
			Handler:    _AncestryService_PostAncestry_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v3/clairpb/clair.proto",
}

// Client API for StatusService service

type StatusServiceClient interface {
	// The RPC used to show the internal state of current Clair instance.
	GetStatus(ctx context.Context, in *GetStatusRequest, opts ...grpc.CallOption) (*GetStatusResponse, error)
}

type statusServiceClient struct {
	cc *grpc.ClientConn
}

func NewStatusServiceClient(cc *grpc.ClientConn) StatusServiceClient {
	return &statusServiceClient{cc}
}

func (c *statusServiceClient) GetStatus(ctx context.Context, in *GetStatusRequest, opts ...grpc.CallOption) (*GetStatusResponse, error) {
	out := new(GetStatusResponse)
	err := grpc.Invoke(ctx, "/coreos.clair.StatusService/GetStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for StatusService service

type StatusServiceServer interface {
	// The RPC used to show the internal state of current Clair instance.
	GetStatus(context.Context, *GetStatusRequest) (*GetStatusResponse, error)
}

func RegisterStatusServiceServer(s *grpc.Server, srv StatusServiceServer) {
	s.RegisterService(&_StatusService_serviceDesc, srv)
}

func _StatusService_GetStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServiceServer).GetStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coreos.clair.StatusService/GetStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServiceServer).GetStatus(ctx, req.(*GetStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StatusService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "coreos.clair.StatusService",
	HandlerType: (*StatusServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetStatus",
			Handler:    _StatusService_GetStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v3/clairpb/clair.proto",
}

// Client API for NotificationService service

type NotificationServiceClient interface {
	// The RPC used to get a particularly Notification.
	GetNotification(ctx context.Context, in *GetNotificationRequest, opts ...grpc.CallOption) (*GetNotificationResponse, error)
	// The RPC used to mark a Notification as read after it has been processed.
	MarkNotificationAsRead(ctx context.Context, in *MarkNotificationAsReadRequest, opts ...grpc.CallOption) (*MarkNotificationAsReadResponse, error)
}

type notificationServiceClient struct {
	cc *grpc.ClientConn
}

func NewNotificationServiceClient(cc *grpc.ClientConn) NotificationServiceClient {
	return &notificationServiceClient{cc}
}

func (c *notificationServiceClient) GetNotification(ctx context.Context, in *GetNotificationRequest, opts ...grpc.CallOption) (*GetNotificationResponse, error) {
	out := new(GetNotificationResponse)
	err := grpc.Invoke(ctx, "/coreos.clair.NotificationService/GetNotification", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationServiceClient) MarkNotificationAsRead(ctx context.Context, in *MarkNotificationAsReadRequest, opts ...grpc.CallOption) (*MarkNotificationAsReadResponse, error) {
	out := new(MarkNotificationAsReadResponse)
	err := grpc.Invoke(ctx, "/coreos.clair.NotificationService/MarkNotificationAsRead", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for NotificationService service

type NotificationServiceServer interface {
	// The RPC used to get a particularly Notification.
	GetNotification(context.Context, *GetNotificationRequest) (*GetNotificationResponse, error)
	// The RPC used to mark a Notification as read after it has been processed.
	MarkNotificationAsRead(context.Context, *MarkNotificationAsReadRequest) (*MarkNotificationAsReadResponse, error)
}

func RegisterNotificationServiceServer(s *grpc.Server, srv NotificationServiceServer) {
	s.RegisterService(&_NotificationService_serviceDesc, srv)
}

func _NotificationService_GetNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationServiceServer).GetNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coreos.clair.NotificationService/GetNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationServiceServer).GetNotification(ctx, req.(*GetNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationService_MarkNotificationAsRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkNotificationAsReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationServiceServer).MarkNotificationAsRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/coreos.clair.NotificationService/MarkNotificationAsRead",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationServiceServer).MarkNotificationAsRead(ctx, req.(*MarkNotificationAsReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NotificationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "coreos.clair.NotificationService",
	HandlerType: (*NotificationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNotification",
			Handler:    _NotificationService_GetNotification_Handler,
		},
		{
			MethodName: "MarkNotificationAsRead",
			Handler:    _NotificationService_MarkNotificationAsRead_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v3/clairpb/clair.proto",
}

func init() { proto.RegisterFile("api/v3/clairpb/clair.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1345 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x4b, 0x6f, 0xdb, 0xc6,
	0x16, 0xbe, 0x94, 0x23, 0x4b, 0x3a, 0x92, 0x6c, 0x65, 0xec, 0xd8, 0x32, 0x9d, 0x87, 0xcd, 0x7b,
	0x83, 0x9b, 0x9b, 0x5b, 0x48, 0xa8, 0x92, 0x02, 0x49, 0xba, 0x28, 0x14, 0x5b, 0x76, 0x0d, 0x24,
	0xae, 0x41, 0x3b, 0x06, 0xda, 0xa2, 0x60, 0xc7, 0xe2, 0x91, 0x4d, 0x98, 0x22, 0x59, 0x72, 0x64,
	0x47, 0x08, 0xd2, 0x45, 0x77, 0xdd, 0xb6, 0x8b, 0xfe, 0x86, 0x6e, 0xba, 0xe9, 0x4f, 0xe8, 0xbe,
	0x8b, 0x76, 0xdb, 0xee, 0xba, 0xe8, 0x1f, 0xe8, 0xa2, 0xbb, 0x62, 0x1e, 0xa4, 0x49, 0x9b, 0x7e,
	0x24, 0x2b, 0xcd, 0x9c, 0x39, 0xcf, 0x6f, 0xbe, 0x39, 0x87, 0x02, 0x9d, 0x06, 0x4e, 0xfb, 0xe8,
	0x41, 0xbb, 0xef, 0x52, 0x27, 0x0c, 0xf6, 0xe4, 0x6f, 0x2b, 0x08, 0x7d, 0xe6, 0x93, 0x5a, 0xdf,
	0x0f, 0xd1, 0x8f, 0x5a, 0x42, 0xa6, 0xdf, 0xd9, 0xf7, 0xfd, 0x7d, 0x17, 0xdb, 0xe2, 0x6c, 0x6f,
	0x34, 0x68, 0x33, 0x67, 0x88, 0x11, 0xa3, 0xc3, 0x40, 0xaa, 0xeb, 0x37, 0x95, 0x02, 0xf7, 0x48,
	0x3d, 0xcf, 0x67, 0x94, 0x39, 0xbe, 0x17, 0xc9, 0x53, 0xe3, 0xbb, 0x02, 0xd4, 0x77, 0x47, 0xae,
	0x87, 0x21, 0xdd, 0x73, 0x5c, 0x87, 0x8d, 0x09, 0x81, 0x6b, 0x1e, 0x1d, 0x62, 0x53, 0x5b, 0xd2,
	0xee, 0x55, 0x4c, 0xb1, 0x26, 0x77, 0x61, 0x8a, 0xff, 0x46, 0x01, 0xed, 0xa3, 0x25, 0x4e, 0x0b,
	0xe2, 0xb4, 0x9e, 0x48, 0x37, 0xb9, 0xda, 0x12, 0x54, 0x6d, 0x8c, 0xfa, 0xa1, 0x13, 0xf0, 0x10,
	0xcd, 0x09, 0xa1, 0x93, 0x16, 0x71, 0xe7, 0xae, 0xe3, 0x1d, 0x36, 0xaf, 0x49, 0xe7, 0x7c, 0x4d,
	0x74, 0x28, 0x47, 0x78, 0x84, 0xa1, 0xc3, 0xc6, 0xcd, 0xa2, 0x90, 0x27, 0x7b, 0x7e, 0x36, 0x44,
	0x46, 0x6d, 0xca, 0x68, 0x73, 0x52, 0x9e, 0xc5, 0x7b, 0xb2, 0x00, 0xe5, 0x81, 0xf3, 0x12, 0x6d,
	0x6b, 0x6f, 0xdc, 0x2c, 0x89, 0xb3, 0x92, 0xd8, 0x3f, 0x1d, 0x93, 0xa7, 0x70, 0x9d, 0x0e, 0x06,
	0xd8, 0x67, 0x68, 0x5b, 0x47, 0x18, 0x46, 0xbc, 0xe0, 0x66, 0x79, 0x69, 0xe2, 0x5e, 0xb5, 0x73,
	0xa3, 0x95, 0x86, 0xaf, 0xb5, 0x86, 0x94, 0x8d, 0x42, 0x34, 0x1b, 0xb1, 0xfe, 0xae, 0x52, 0x37,
	0x7e, 0xd6, 0xa0, 0xbc, 0x8a, 0x0c, 0xfb, 0xcc, 0x0f, 0x73, 0x41, 0x69, 0x42, 0x49, 0xf9, 0x56,
	0x68, 0xc4, 0x5b, 0xd2, 0x81, 0xa2, 0xcd, 0xc6, 0x01, 0x0a, 0x04, 0xa6, 0x3a, 0x37, 0xb3, 0x21,
	0x63, 0xa7, 0xad, 0xd5, 0x9d, 0x71, 0x80, 0xa6, 0x54, 0x35, 0x3e, 0x87, 0xa2, 0xd8, 0x93, 0x45,
	0x98, 0x5f, 0xed, 0xed, 0xf4, 0x56, 0x76, 0x3e, 0x32, 0xad, 0x55, 0x6b, 0xe7, 0xe3, 0xad, 0x9e,
	0xb5, 0xb1, 0xb9, 0xdb, 0x7d, 0xb6, 0xb1, 0xda, 0xf8, 0x17, 0xb9, 0x05, 0x0b, 0xa7, 0x0f, 0x37,
	0xbb, 0xcf, 0x7b, 0xdb, 0x5b, 0xdd, 0x95, 0x5e, 0x43, 0xcb, 0xb3, 0x5d, 0xeb, 0x75, 0x77, 0x5e,
	0x98, 0xbd, 0x46, 0xc1, 0xd8, 0x86, 0xca, 0x66, 0x7c, 0x5d, 0xb9, 0x05, 0x75, 0xa0, 0x6c, 0xab,
	0xdc, 0x44, 0x45, 0xd5, 0xce, 0x5c, 0x7e, 0xe6, 0x66, 0xa2, 0x67, 0xfc, 0x58, 0x80, 0x92, 0xc2,
	0x30, 0xd7, 0xe7, 0x7b, 0x50, 0x49, 0x38, 0xa2, 0x9c, 0xce, 0x67, 0x9d, 0x26, 0x39, 0x99, 0x27,
	0x9a, 0x69, 0x6c, 0x27, 0xb2, 0xd8, 0xde, 0x85, 0x29, 0xb5, 0xb4, 0x06, 0x7e, 0x38, 0xa4, 0x4c,
	0x71, 0xa9, 0xae, 0xa4, 0x6b, 0x42, 0x98, 0xa9, 0xa5, 0x78, 0xb5, 0x5a, 0x48, 0x0f, 0xa6, 0x8f,
	0x52, 0x4f, 0xc1, 0xc1, 0xa8, 0x39, 0x29, 0x38, 0xb3, 0x98, 0x35, 0xcd, 0xbc, 0x17, 0xf3, 0xb4,
	0x0d, 0x59, 0x86, 0xda, 0x40, 0x22, 0x62, 0x09, 0x12, 0x48, 0x6e, 0x56, 0x95, 0x8c, 0xdf, 0xb1,
	0xb1, 0x08, 0xc5, 0x67, 0x74, 0x8c, 0x82, 0x57, 0x07, 0x34, 0x3a, 0x88, 0x21, 0xe3, 0x6b, 0xe3,
	0x6b, 0x0d, 0xaa, 0x2b, 0x3c, 0xd0, 0x36, 0xa3, 0x6c, 0x14, 0x91, 0x87, 0x50, 0x89, 0x53, 0x8c,
	0x9a, 0x9a, 0x48, 0xe8, 0xbc, 0x5a, 0x4e, 0x14, 0xc9, 0x2a, 0x34, 0x5c, 0x1a, 0x31, 0x6b, 0x14,
	0xd8, 0x94, 0xa1, 0xc5, 0xbb, 0x82, 0xc2, 0x5f, 0x6f, 0xc9, 0x8e, 0xd0, 0x8a, 0x5b, 0x46, 0x6b,
	0x27, 0x6e, 0x19, 0xe6, 0x14, 0xb7, 0x79, 0x21, 0x4c, 0xb8, 0xd0, 0x78, 0x0c, 0x64, 0x1d, 0x59,
	0xd7, 0xeb, 0x63, 0xc4, 0xc2, 0xb1, 0x89, 0x5f, 0x8c, 0x30, 0x62, 0xe4, 0xdf, 0x50, 0xa7, 0x4a,
	0x64, 0xa5, 0x6e, 0xbc, 0x16, 0x0b, 0xf9, 0x95, 0x1a, 0x7f, 0x17, 0x60, 0x26, 0x63, 0x1b, 0x05,
	0xbe, 0x17, 0x21, 0x59, 0x83, 0x72, 0xac, 0x27, 0xec, 0xaa, 0x9d, 0xfb, 0xd9, 0x6a, 0x72, 0x8c,
	0x5a, 0x89, 0x20, 0xb1, 0x25, 0xef, 0xc2, 0x64, 0x24, 0x00, 0x52, 0x65, 0x2d, 0x64, 0xbd, 0xa4,
	0x10, 0x34, 0x95, 0xa2, 0xfe, 0x25, 0xd4, 0x63, 0x47, 0x12, 0xfe, 0xff, 0x41, 0xd1, 0xe5, 0x0b,
	0x95, 0xc8, 0x4c, 0xd6, 0x85, 0xd0, 0x31, 0xa5, 0x06, 0x6f, 0x29, 0x12, 0x5c, 0xb4, 0x2d, 0x75,
	0x95, 0x3c, 0xf2, 0x45, 0x2d, 0x25, 0xd6, 0x57, 0x82, 0x48, 0xdf, 0x87, 0x72, 0x1c, 0x3f, 0xf7,
	0xb1, 0xac, 0xc3, 0xa4, 0x08, 0x16, 0x35, 0x27, 0x84, 0xe3, 0xf6, 0xd5, 0x81, 0x91, 0xb9, 0x2a,
	0x73, 0xe3, 0xf7, 0x02, 0xcc, 0x6c, 0xf9, 0xd1, 0x5b, 0x5d, 0x1c, 0x99, 0x83, 0x49, 0xf5, 0xb2,
	0x64, 0x5b, 0x53, 0x3b, 0xb2, 0x72, 0x2a, 0xbb, 0xff, 0x67, 0xb3, 0xcb, 0x89, 0x27, 0x64, 0x99,
	0xcc, 0xf4, 0x9f, 0x34, 0xa8, 0x24, 0xd2, 0x3c, 0xfa, 0x73, 0x59, 0x40, 0xd9, 0x81, 0x0a, 0x2e,
	0xd6, 0xc4, 0x84, 0xd2, 0x01, 0x52, 0xfb, 0x24, 0xf6, 0xa3, 0x37, 0x88, 0xdd, 0xfa, 0x50, 0x9a,
	0xf6, 0x3c, 0x7e, 0x1a, 0x3b, 0xd2, 0x9f, 0x40, 0x2d, 0x7d, 0x40, 0x1a, 0x30, 0x71, 0x88, 0x63,
	0x95, 0x0a, 0x5f, 0x92, 0x59, 0x28, 0x1e, 0x51, 0x77, 0x14, 0x0f, 0x3b, 0xb9, 0x79, 0x52, 0x78,
	0xa4, 0x19, 0x1b, 0x30, 0x9b, 0x0d, 0xa9, 0xb8, 0x7d, 0xc2, 0x49, 0xed, 0x8a, 0x9c, 0x34, 0x7e,
	0xd0, 0x60, 0x6e, 0x1d, 0xd9, 0xa6, 0xcf, 0x9c, 0x81, 0xd3, 0x17, 0xb3, 0x39, 0xbe, 0xad, 0x87,
	0x30, 0xe7, 0xbb, 0xb6, 0x95, 0xee, 0x2f, 0x63, 0x2b, 0xa0, 0xfb, 0xf1, 0xb5, 0xcd, 0xfa, 0xae,
	0x9d, 0xe9, 0x45, 0x5b, 0x74, 0x1f, 0xb9, 0x95, 0x87, 0xc7, 0x79, 0x56, 0xb2, 0x8c, 0x59, 0x0f,
	0x8f, 0xcf, 0x5a, 0xcd, 0x42, 0xd1, 0x75, 0x86, 0x0e, 0x13, 0xed, 0xb6, 0x68, 0xca, 0x4d, 0x42,
	0xd2, 0x6b, 0x27, 0x24, 0x35, 0x7e, 0x2b, 0xc0, 0xfc, 0x99, 0x84, 0x55, 0xfd, 0xbb, 0x50, 0xf3,
	0x52, 0x72, 0x85, 0x42, 0xe7, 0x0c, 0x8d, 0xf3, 0x8c, 0x5b, 0x19, 0x61, 0xc6, 0x8f, 0xfe, 0xa7,
	0x06, 0xb5, 0xf4, 0xf1, 0x79, 0xf3, 0xb8, 0x1f, 0x22, 0x65, 0x68, 0xc7, 0xf3, 0x58, 0x6d, 0xf9,
	0x57, 0x84, 0x74, 0x87, 0xb6, 0x1a, 0x27, 0xc9, 0x9e, 0x5b, 0xd9, 0xe8, 0x22, 0xb7, 0x92, 0x55,
	0xc6, 0x5b, 0xf2, 0x18, 0x26, 0x7c, 0xd7, 0x56, 0xd3, 0xe3, 0xbf, 0xa7, 0x08, 0x47, 0xf7, 0x31,
	0xc1, 0xde, 0x45, 0x45, 0x04, 0x07, 0x23, 0x93, 0xdb, 0x70, 0x53, 0x0f, 0x8f, 0xc5, 0x17, 0xcb,
	0x9b, 0x98, 0x7a, 0x78, 0x6c, 0xfc, 0x52, 0x80, 0x85, 0x73, 0x55, 0xf8, 0x6c, 0xe9, 0x8f, 0xc2,
	0x10, 0x3d, 0x96, 0x26, 0x42, 0x55, 0xc9, 0xc4, 0x4d, 0x2e, 0x42, 0xc5, 0xc3, 0x97, 0x2c, 0x7d,
	0xe5, 0x65, 0x2e, 0xb8, 0xe0, 0x9a, 0xbb, 0x50, 0xcf, 0xd0, 0x45, 0x20, 0x71, 0xc9, 0xd8, 0xcb,
	0x5a, 0x90, 0x4f, 0x01, 0x68, 0x92, 0x66, 0xb3, 0x28, 0x1e, 0xe9, 0xfb, 0x57, 0x2c, 0xbc, 0xb5,
	0xe1, 0xd9, 0xf8, 0x12, 0xed, 0x6e, 0xaa, 0x0b, 0x99, 0x29, 0x77, 0xfa, 0x07, 0x30, 0x93, 0xa3,
	0xc2, 0x8b, 0x71, 0xb8, 0x58, 0xa0, 0x50, 0x34, 0xe5, 0x26, 0xa1, 0x46, 0x21, 0xc5, 0xd9, 0x07,
	0x70, 0xeb, 0x39, 0x0d, 0x0f, 0xd3, 0x14, 0xea, 0x46, 0x26, 0x52, 0x3b, 0x7e, 0x6a, 0x39, 0x7c,
	0x32, 0x96, 0xe0, 0xf6, 0x79, 0x46, 0x92, 0xb1, 0x06, 0x81, 0xc6, 0x3a, 0x32, 0xf5, 0xa0, 0xa5,
	0x27, 0x63, 0x0d, 0xae, 0xa7, 0x64, 0x6f, 0xdd, 0x17, 0x3a, 0x7f, 0x69, 0x30, 0x1d, 0x57, 0xbb,
	0x8d, 0xe1, 0x91, 0xd3, 0x47, 0x32, 0x82, 0x6a, 0x6a, 0x06, 0x90, 0xa5, 0x0b, 0xc6, 0x83, 0x48,
	0x46, 0x5f, 0xbe, 0x74, 0x80, 0x18, 0xcb, 0x5f, 0xfd, 0xfa, 0xc7, 0xb7, 0x85, 0x45, 0xb2, 0xd0,
	0x8e, 0x87, 0x40, 0xfb, 0x55, 0x66, 0x46, 0xbc, 0x26, 0x87, 0x50, 0x4b, 0x77, 0x3b, 0xb2, 0x7c,
	0x69, 0xf3, 0xd5, 0x8d, 0x8b, 0x54, 0x54, 0xe4, 0x59, 0x11, 0x79, 0xca, 0xa8, 0x24, 0x91, 0x9f,
	0x68, 0xf7, 0x3b, 0x1e, 0xd4, 0x25, 0x12, 0x71, 0xd1, 0x9f, 0x41, 0x25, 0x01, 0x94, 0xdc, 0x3e,
	0x53, 0x50, 0x06, 0x7d, 0xfd, 0xce, 0xb9, 0xe7, 0x2a, 0xe8, 0xb4, 0x08, 0x5a, 0x21, 0xa5, 0xb6,
	0xc2, 0xf9, 0xfb, 0x02, 0xcc, 0xa4, 0xaf, 0x38, 0x0e, 0xfb, 0x1a, 0xa6, 0x4f, 0x35, 0x2a, 0xf2,
	0x9f, 0x4b, 0xfa, 0x98, 0x4c, 0xe1, 0xee, 0x95, 0xba, 0x9d, 0x71, 0x4b, 0x24, 0x32, 0x4f, 0x6e,
	0xb4, 0xd3, 0x9d, 0x2e, 0x6a, 0xbf, 0x92, 0x98, 0x7f, 0xa3, 0xc1, 0x5c, 0x3e, 0xfb, 0xc8, 0xa9,
	0xb9, 0x7b, 0x21, 0xb1, 0xf5, 0x77, 0xae, 0xa6, 0x9c, 0x4d, 0xea, 0x7e, 0x7e, 0x52, 0x4f, 0x6f,
	0xc3, 0x4c, 0xdf, 0x1f, 0x66, 0x3d, 0x06, 0x7b, 0x9f, 0x94, 0xd4, 0xbf, 0xd4, 0xbd, 0x49, 0xf1,
	0x45, 0xf9, 0xe0, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1b, 0x4b, 0xee, 0xfe, 0xbe, 0x0e, 0x00,
	0x00,
}
