/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import macromedia.abc.Decoder;
import macromedia.abc.DecoderException;
import macromedia.abc.MultiName;
import macromedia.abc.QName;
import macromedia.abc.Visitor;

public abstract class DefaultVisitor
implements Visitor {
    protected Decoder decoder;

    public DefaultVisitor(Decoder decoder) {
        this.decoder = decoder;
    }

    public abstract void beginABC();

    public abstract void endABC();

    public abstract void metadata(String var1, String[] var2, String[] var3);

    public abstract void beginClass(QName var1, int var2);

    public abstract void instanceInfo(QName var1, QName var2, MultiName[] var3);

    public abstract void beginIInit(int var1);

    public abstract void endIInit();

    public abstract void classInfo(QName var1);

    public abstract void beginCInit(int var1);

    public abstract void endCInit();

    public abstract void endClass(QName var1);

    public abstract void beginVar(QName var1, int var2, QName var3, Object var4);

    public abstract void endVar(QName var1);

    public abstract void beginConst(QName var1, int var2, QName var3, Object var4);

    public abstract void endConst(QName var1);

    public abstract void methodInfo(QName var1, QName[] var2, String var3, int var4, Object[] var5, String[] var6);

    public abstract void beginGetter(int var1, QName var2, int var3, int var4);

    public abstract void endGetter(QName var1);

    public abstract void beginSetter(int var1, QName var2, int var3, int var4);

    public abstract void endSetter(QName var1);

    public abstract void beginMethod(int var1, QName var2, int var3, int var4);

    public abstract void endMethod(QName var1);

    public abstract void beginFunction(int var1, QName var2, int var3);

    public abstract void endFunction(QName var1);

    public abstract void beginBody(int var1, int var2, long var3);

    public abstract void endBody();

    @Override
    public final void methodInfo(int returnTypeID, int[] paramTypeIDs, int nativeNameID, int flags, int[] valueIDs, int[] value_kinds, int[] param_names) throws DecoderException {
        int j;
        QName returnType = this.decoder.constantPool.getQName(returnTypeID);
        String nativeName = this.decoder.constantPool.getString(nativeNameID);
        QName[] params = null;
        Object[] values = null;
        String[] arg_names = null;
        if (paramTypeIDs != null) {
            params = new QName[paramTypeIDs.length];
            for (j = 0; j < params.length; ++j) {
                params[j] = this.decoder.constantPool.getQName(paramTypeIDs[j]);
            }
        }
        if (valueIDs != null) {
            values = new Object[valueIDs.length];
            for (j = 0; j < values.length; ++j) {
                values[j] = this.decoder.constantPool.get(valueIDs[j], value_kinds[j]);
            }
        }
        if (param_names != null) {
            arg_names = new String[param_names.length];
            for (j = 0; j < param_names.length; ++j) {
                arg_names[j] = this.decoder.constantPool.getString(param_names[j]);
            }
        }
        this.methodInfo(returnType, params, nativeName, flags, values, arg_names);
    }

    @Override
    public final void metadataInfo(int index, int nameID, int[] keyIDs, int[] valueIDs) throws DecoderException {
        int i;
        String name = this.decoder.constantPool.getString(nameID);
        String[] keys = null;
        String[] values = null;
        if (keyIDs != null) {
            keys = new String[keyIDs.length];
            for (i = 0; i < keyIDs.length; ++i) {
                keys[i] = this.decoder.constantPool.getString(keyIDs[i]);
            }
        }
        if (valueIDs != null) {
            values = new String[valueIDs.length];
            for (i = 0; i < valueIDs.length; ++i) {
                values[i] = this.decoder.constantPool.getString(valueIDs[i]);
            }
        }
        this.metadata(name, keys, values);
    }

    @Override
    public final void traitCount(int traitCount) {
    }

    @Override
    public final void slotTrait(int kind, int nameID, int slotID, int typeID, int valueID, int value_kind, int[] metadata) throws DecoderException {
        QName name = this.decoder.constantPool.getQName(nameID);
        QName type = this.decoder.constantPool.getQName(typeID);
        Object value = this.decoder.constantPool.get(valueID, value_kind);
        int tag = kind & 0xF;
        if (tag == 0) {
            this.beginVar(name, slotID, type, value);
        } else {
            this.beginConst(name, slotID, type, value);
        }
        if (metadata != null) {
            int length = metadata.length;
            for (int i = 0; i < length; ++i) {
                this.decoder.metadataInfo.decode(metadata[i], this);
            }
        }
        if (tag == 0) {
            this.endVar(name);
        } else {
            this.endConst(name);
        }
    }

    @Override
    public final void methodTrait(int kind, int nameID, int dispID, int methodInfoID, int[] metadata) throws DecoderException {
        QName name = this.decoder.constantPool.getQName(nameID);
        int tag = kind & 0xF;
        int attr = kind >> 4;
        if (tag == 2) {
            this.beginGetter(methodInfoID, name, dispID, attr);
        } else if (tag == 3) {
            this.beginSetter(methodInfoID, name, dispID, attr);
        } else {
            this.beginMethod(methodInfoID, name, dispID, attr);
        }
        this.decoder.methodInfo.decode(methodInfoID, this);
        if (metadata != null) {
            int length = metadata.length;
            for (int i = 0; i < length; ++i) {
                this.decoder.metadataInfo.decode(metadata[i], this);
            }
        }
        if (tag == 2) {
            this.endGetter(name);
        } else if (tag == 3) {
            this.endSetter(name);
        } else {
            this.endMethod(name);
        }
    }

    @Override
    public final void classTrait(int kind, int nameID, int slotID, int classIndex, int[] metadata) throws DecoderException {
        QName name = this.decoder.constantPool.getQName(nameID);
        this.beginClass(name, slotID);
        this.decoder.classInfo.decode(classIndex, this);
        if (metadata != null) {
            int length = metadata.length;
            for (int i = 0; i < length; ++i) {
                this.decoder.metadataInfo.decode(metadata[i], this);
            }
        }
        this.endClass(name);
    }

    @Override
    public final void functionTrait(int kind, int nameID, int slotID, int methodInfoID, int[] metadata) throws DecoderException {
        QName name = this.decoder.constantPool.getQName(nameID);
        this.beginFunction(methodInfoID, name, slotID);
        this.decoder.methodInfo.decode(methodInfoID, this);
        if (metadata != null) {
            int length = metadata.length;
            for (int i = 0; i < length; ++i) {
                this.decoder.metadataInfo.decode(metadata[i], this);
            }
        }
        this.endFunction(name);
    }

    @Override
    public final void startInstance(int nameID, int superNameID, boolean isDynamic, boolean isFinal, boolean isInteface, int[] interfaceIDs, int iinitID, int protectedNamespace) throws DecoderException {
        QName name = this.decoder.constantPool.getQName(nameID);
        QName superName = this.decoder.constantPool.getQName(superNameID);
        MultiName[] interfaces = null;
        if (interfaceIDs != null) {
            interfaces = new MultiName[interfaceIDs.length];
            for (int j = 0; j < interfaces.length; ++j) {
                interfaces[j] = this.decoder.constantPool.getMultiName(interfaceIDs[j]);
            }
        }
        this.instanceInfo(name, superName, interfaces);
        this.beginIInit(iinitID);
        this.decoder.methodInfo.decode(iinitID, this);
        this.endIInit();
    }

    @Override
    public final void endInstance() {
    }

    @Override
    public final void startClass(int nameID, int cinit) throws DecoderException {
        QName name = this.decoder.constantPool.getQName(nameID);
        this.classInfo(name);
        this.beginCInit(cinit);
        this.decoder.methodInfo.decode(cinit, this);
        this.endCInit();
    }

    @Override
    public final void endClass() {
    }

    @Override
    public final void startScript(int initID) {
        this.beginABC();
    }

    @Override
    public final void endScript() {
        this.endABC();
    }

    @Override
    public final void startMethodBody(int methodInfo, int maxStack, int maxRegs, int scopeDepth, int maxScope, int codeStart, long codeLength) throws DecoderException {
        this.beginBody(methodInfo, codeStart, codeLength);
    }

    @Override
    public final void endMethodBody() {
        this.endBody();
    }

    @Override
    public final void startOpcodes(int methodInfo) {
    }

    @Override
    public final void endOpcodes() {
    }

    @Override
    public final void exception(long start, long end, long target, int type, int name) {
    }

    @Override
    public final void startExceptions(int exceptionCount) {
    }

    @Override
    public final void endExceptions() {
    }
}

