/*
 * Copyright (C) 2002,2003 Mihai RUSU (dizzy@roedu.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#ifdef HAVE_SYSLOG_H
# include <syslog.h>
#endif
#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif
#include "version.h"
#include "mylog.h"

void myopenlog()
{
    openlog(UNIX2TCP_NAME, LOG_PID, 0);
}

void mylog(char * fmt, ...)
{
    va_list va;

    va_start(va, fmt);
    vsyslog(LOG_DAEMON | LOG_NOTICE, fmt, va);
    va_end(va);
}

void mycloselog()
{
    closelog();
}
