/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WindingOrder {
    LTR_TTB(false, false, false, false),
    TTB_LTR(false, false, true, false),
    RTL_TTB(false, true, false, false),
    TTB_RTL(false, true, true, false),
    LTR_BTT(true, false, false, false),
    BTT_LTR(true, false, true, false),
    RTL_BTT(true, true, false, false),
    BTT_RTL(true, true, true, false),
    LTR_TTB_BOUSTROPHEDON(false, false, false, true),
    TTB_LTR_BOUSTROPHEDON(false, false, true, true),
    RTL_TTB_BOUSTROPHEDON(false, true, false, true),
    TTB_RTL_BOUSTROPHEDON(false, true, true, true),
    LTR_BTT_BOUSTROPHEDON(true, false, false, true),
    BTT_LTR_BOUSTROPHEDON(true, false, true, true),
    RTL_BTT_BOUSTROPHEDON(true, true, false, true),
    BTT_RTL_BOUSTROPHEDON(true, true, true, true);

    protected final boolean bottomToTop;
    protected final boolean rightToLeft;
    protected final boolean vertical;
    protected final boolean boustrophedon;

    private WindingOrder(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.bottomToTop = bl;
        this.rightToLeft = bl2;
        this.vertical = bl3;
        this.boustrophedon = bl4;
    }

    public int[] getYX(int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5;
        if (this.vertical) {
            n5 = n3 / n % n2;
            n4 = n3 % n;
            if (this.boustrophedon && (n5 & 1) != 0) {
                n4 = n - 1 - n4;
            }
        } else {
            n4 = n3 / n2 % n;
            n5 = n3 % n2;
            if (this.boustrophedon && (n4 & 1) != 0) {
                n5 = n2 - 1 - n5;
            }
        }
        if (this.bottomToTop) {
            n4 = n - 1 - n4;
        }
        if (this.rightToLeft) {
            n5 = n2 - 1 - n5;
        }
        if (nArray == null) {
            return new int[]{n4, n5};
        }
        nArray[0] = n4;
        nArray[1] = n5;
        return nArray;
    }

    public int getIndex(int n, int n2, int n3, int n4) {
        n3 %= n;
        n4 %= n2;
        if (this.bottomToTop) {
            n3 = n - 1 - n3;
        }
        if (this.rightToLeft) {
            n4 = n2 - 1 - n4;
        }
        if (this.vertical) {
            if (this.boustrophedon && (n4 & 1) != 0) {
                n3 = n - 1 - n3;
            }
            return n4 * n + n3;
        }
        if (this.boustrophedon && (n3 & 1) != 0) {
            n4 = n2 - 1 - n4;
        }
        return n3 * n2 + n4;
    }

    public String toString() {
        String string = this.bottomToTop ? "BTT" : "TTB";
        String string2 = this.rightToLeft ? "RTL" : "LTR";
        String string3 = this.vertical ? string : string2;
        String string4 = this.vertical ? string2 : string;
        String string5 = string3 + ", " + string4;
        if (this.boustrophedon) {
            string5 = string5 + ", Alt";
        }
        return string5;
    }
}

