/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtility {
    public static String wrap(String string, boolean bl, String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        int n = 0;
        while (n + 1 < stringArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[n++]);
            stringBuffer.append("=\"");
            stringBuffer.append(XMLUtility.xmlEncode(stringArray[n++]));
            stringBuffer.append("\"");
        }
        if (n < stringArray.length) {
            stringBuffer.append(">");
            stringBuffer.append(XMLUtility.xmlEncode(stringArray[n]));
            if (bl) {
                stringBuffer.append("</");
                stringBuffer.append(string);
                stringBuffer.append(">");
            }
        } else {
            stringBuffer.append(bl ? "/>" : ">");
        }
        return stringBuffer.toString();
    }

    public static String xmlEncode(String string) {
        int n;
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            switch (n) {
                case 38: {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case 60: {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case 62: {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                default: {
                    if (n >= 32 && n < 127) {
                        stringBuffer.append((char)n);
                        continue block6;
                    }
                }
                case 34: 
                case 39: {
                    stringBuffer.append("&#" + n + ";");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String parseString(NamedNodeMap namedNodeMap, String string) {
        if (namedNodeMap == null) {
            return null;
        }
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        String string2 = node.getTextContent();
        if (string2 == null) {
            return null;
        }
        return string2.trim();
    }

    public static Integer parseInt(NamedNodeMap namedNodeMap, String string) {
        if (namedNodeMap == null) {
            return null;
        }
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        String string2 = node.getTextContent();
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double parseDouble(NamedNodeMap namedNodeMap, String string) {
        if (namedNodeMap == null) {
            return null;
        }
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        String string2 = node.getTextContent();
        if (string2 == null) {
            return null;
        }
        try {
            return Double.parseDouble(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<Node> getChildren(Node node) {
        NodeList nodeList;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2 == null || (string = node2.getNodeName()).equalsIgnoreCase("#text") || string.equalsIgnoreCase("#comment")) continue;
                arrayList.add(node2);
            }
        }
        return arrayList;
    }

    public static EntityResolver entityResolver(final String string, final String string2, final Class<?> clazz) {
        return new EntityResolver(){

            public InputSource resolveEntity(String string3, String string22) throws SAXException, IOException {
                if (string3.contains(string) || string22.contains(string2)) {
                    return new InputSource(clazz.getResourceAsStream(string2));
                }
                return null;
            }
        };
    }

    public static ErrorHandler errorHandler(final String string) {
        return new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                System.err.print("Warning: Failed to parse " + string + ": ");
                System.err.println("ERROR on " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.print("Warning: Failed to parse " + string + ": ");
                System.err.println("FATAL ERROR on " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
                System.err.print("Warning: Failed to parse " + string + ": ");
                System.err.println("WARNING on " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
            }
        };
    }
}

