/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.exporter;

import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportOptions;
import com.kreative.bitsnpicas.exporter.BDFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.CybikoBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.FNTBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.FONTXBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.FZXBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.GEOSBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.HMZKBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.HexBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.KbitsBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.NFNTBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.OTBBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.PSFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.PlaydateBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.RFontBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.RockboxBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.SBFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.SFontBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.TOSBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.TTFBitmapFontExporter;
import com.kreative.bitsnpicas.exporter.U8MBitmapFontExporter;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BitmapExportFormat {
    KBITS("Kbits (Kreative Bits'n'Picas 1.x)", ".kbits", "v1"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new KbitsBitmapFontExporter();
        }
    }
    ,
    TTF("TTF (TrueType)", ".ttf", "ttf"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            Dimension dimension = bitmapExportOptions.getPixelDimension();
            boolean bl = bitmapExportOptions.getExtendWinMetrics();
            return new TTFBitmapFontExporter(dimension.width, dimension.height, bl);
        }
    }
    ,
    OTB("OTB (OpenType Bitmap)", ".otb", "otb"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            boolean bl = bitmapExportOptions.getExtendWinMetrics();
            return new OTBBitmapFontExporter(bl);
        }
    }
    ,
    BDF("BDF (Bitmap Distribution Format)", ".bdf", "none"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new BDFBitmapFontExporter();
        }
    }
    ,
    PSF("PSF (PC Screen Font) (Uncompressed)", ".psf", "psf"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new PSFBitmapFontExporter(bitmapExportOptions.getPSFVersion(), bitmapExportOptions.getPSFLowEncoding(), bitmapExportOptions.getPSFHighEncoding(), bitmapExportOptions.getPSFUseLowEncoding(), bitmapExportOptions.getPSFUseHighEncoding(), bitmapExportOptions.getPSFUseAllGlyphs(), bitmapExportOptions.getPSFUnicodeTable(), false);
        }
    }
    ,
    PSFGZ("PSF (PC Screen Font) (Gzip Compressed)", ".psf.gz", "psf"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new PSFBitmapFontExporter(bitmapExportOptions.getPSFVersion(), bitmapExportOptions.getPSFLowEncoding(), bitmapExportOptions.getPSFHighEncoding(), bitmapExportOptions.getPSFUseLowEncoding(), bitmapExportOptions.getPSFUseHighEncoding(), bitmapExportOptions.getPSFUseAllGlyphs(), bitmapExportOptions.getPSFUnicodeTable(), true);
        }
    }
    ,
    SUIT("Mac OS Classic Font Suitcase (Resource Fork)", ".suit", "mac", "MacRoman", true){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new NFNTBitmapFontExporter(bitmapExportOptions.getIDGenerator(), bitmapExportOptions.getPointSizeGenerator(), bitmapExportOptions.getSelectedEncoding());
        }

        public void postProcess(File file) throws IOException {
            MacUtility.setTypeAndCreator(file, "FFIL", "DMOV");
        }
    }
    ,
    DFONT("Mac OS Classic Font Suitcase (Data Fork)", ".dfont", "mac", "MacRoman", false){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new NFNTBitmapFontExporter(bitmapExportOptions.getIDGenerator(), bitmapExportOptions.getPointSizeGenerator(), bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    SFONT("PNG (SDL SFont)", ".png", "color"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new SFontBitmapFontExporter(bitmapExportOptions.getSelectedColor());
        }
    }
    ,
    RFONT("PNG (Kreative RFont)", ".png", "color"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new RFontBitmapFontExporter(bitmapExportOptions.getSelectedColor());
        }
    }
    ,
    HEX("Hex (GNU Unifont)", ".hex", "none"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new HexBitmapFontExporter();
        }
    }
    ,
    CVT("GEOS Font in Convert Wrapper", ".cvt", "geos"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new GEOSBitmapFontExporter(bitmapExportOptions.getIDGenerator(), bitmapExportOptions.getPointSizeGenerator(), bitmapExportOptions.getGEOSMega(), bitmapExportOptions.getGEOSKerning(), bitmapExportOptions.getGEOSUTF8());
        }
    }
    ,
    FZX("FZX (ZX Spectrum)", ".fzx", "encoding", "FZX PUA"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new FZXBitmapFontExporter(bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    U8M("U8/M (UTF-8 for Microcomputers)", ".u8m", "u8m", "U8/M PETSCII"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new U8MBitmapFontExporter(bitmapExportOptions.getLoadAddress(), bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    FNT3("FNT (Windows 3.x)", ".fnt", "encoding", "CP1252"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new FNTBitmapFontExporter(3, bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    FNT2("FNT (Windows 2.x)", ".fnt", "encoding", "CP1252"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new FNTBitmapFontExporter(2, bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    FONTX("FONTX (DOS/V)", ".fnt", "fontx"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            if (bitmapExportOptions.getFONTXDoubleByte()) {
                String string = bitmapExportOptions.getFONTXDoubleByteEncoding();
                if (string == null || string.length() == 0) {
                    string = "CP943";
                }
                return new FONTXBitmapFontExporter(string);
            }
            GlyphList glyphList = bitmapExportOptions.getSelectedEncoding();
            if (glyphList == null) {
                glyphList = EncodingList.instance().getGlyphList("CP437");
            }
            return new FONTXBitmapFontExporter(glyphList);
        }
    }
    ,
    RB12("RB12 (Rockbox 2.3 or above)", ".fnt", "none"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new RockboxBitmapFontExporter(1380069682);
        }
    }
    ,
    RB11("RB11 (Rockbox 2.2 or below and iPodLinux)", ".fnt", "none"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new RockboxBitmapFontExporter(1380069681);
        }
    }
    ,
    CYBIKO("Cybiko", ".fnt", "encoding", "Cybiko"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new CybikoBitmapFontExporter(bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    PLAYDATE("Playdate", ".fnt", "playdate"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new PlaydateBitmapFontExporter(bitmapExportOptions.getPlaydateSeparate());
        }
    }
    ,
    HMZK("HMZK (Mi Band 2)", ".hmzk", "none"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new HMZKBitmapFontExporter();
        }
    }
    ,
    SBF("SBF (Sabriel Font)", ".sbf", "encoding", "Kreative SuperLatin"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new SBFBitmapFontExporter(bitmapExportOptions.getSelectedEncoding());
        }
    }
    ,
    TOS("TOS Character Set", ".ft", "none"){

        public BitmapFontExporter createExporter(BitmapExportOptions bitmapExportOptions) {
            return new TOSBitmapFontExporter();
        }
    };

    public final String name;
    public final String suffix;
    public final String cardName;
    public final String defaultEncodingName;
    public final boolean macResFork;

    private BitmapExportFormat(String string2, String string3, String string4) {
        this.name = string2;
        this.suffix = string3;
        this.cardName = string4;
        this.defaultEncodingName = null;
        this.macResFork = false;
    }

    private BitmapExportFormat(String string2, String string3, String string4, String string5) {
        this.name = string2;
        this.suffix = string3;
        this.cardName = string4;
        this.defaultEncodingName = string5;
        this.macResFork = false;
    }

    private BitmapExportFormat(String string2, String string3, String string4, String string5, boolean bl) {
        this.name = string2;
        this.suffix = string3;
        this.cardName = string4;
        this.defaultEncodingName = string5;
        this.macResFork = bl;
    }

    public abstract BitmapFontExporter createExporter(BitmapExportOptions var1);

    public void postProcess(File file) throws IOException {
    }

    public String toString() {
        return this.name;
    }
}

