/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;

public class DSFBitmapFontImporter
implements BitmapFontImporter {
    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(byArray), "UTF-8");
        BitmapFont bitmapFont = DSFBitmapFontImporter.importFont(scanner);
        scanner.close();
        if (bitmapFont == null) {
            return new BitmapFont[0];
        }
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        BitmapFont bitmapFont = DSFBitmapFontImporter.importFont(scanner);
        if (bitmapFont == null) {
            return new BitmapFont[0];
        }
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
        BitmapFont bitmapFont = DSFBitmapFontImporter.importFont(scanner);
        scanner.close();
        if (bitmapFont == null) {
            return new BitmapFont[0];
        }
        return new BitmapFont[]{bitmapFont};
    }

    private static BitmapFont importFont(Scanner scanner) {
        if (scanner.nextLine().equals("DosStartFont")) {
            String string = scanner.nextLine();
            String[] stringArray = scanner.nextLine().split("\\s*,\\s*");
            int n = Integer.parseInt(stringArray[0].trim());
            if (n == 0 || n == 1) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int[] nArray = new int[95];
                int[][] nArrayArray = new int[nArray.length][];
                boolean[][][] blArrayArray = new boolean[nArray.length][][];
                int n7 = 0;
                int n8 = 0;
                if (n == 1) {
                    n7 = Integer.parseInt(stringArray[1].trim());
                }
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    stringArray = scanner.nextLine().split("\\s*,\\s*");
                    nArray[n6] = Integer.parseInt(stringArray[1].trim());
                    if (n == 1) {
                        n5 = Integer.parseInt(stringArray[0].substring(0, 3));
                        n4 = Integer.parseInt(stringArray[0].substring(3, 6));
                        nArrayArray[n6] = new int[4];
                        nArrayArray[n6][0] = 0;
                        nArrayArray[n6][1] = n7;
                        nArrayArray[n6][2] = n5;
                        nArrayArray[n6][3] = n7 - n4;
                        blArrayArray[n6] = new boolean[n4][n5];
                        n3 = 6;
                        for (int i = 0; i < n4 && n3 < stringArray[0].length(); ++i) {
                            for (n2 = 0; n2 < n5 && n3 < stringArray[0].length(); ++n2) {
                                int n9 = stringArray[0].charAt(n3++);
                                blArrayArray[n6][i][n2] = n9 == 72 || n9 == 104;
                            }
                        }
                        n8 = Math.max(n8, n4 - n7);
                        continue;
                    }
                    if (n != 0) continue;
                    nArrayArray[n6] = DSFBitmapFontImporter.dsfBBox(stringArray[0]);
                    blArrayArray[n6] = DSFBitmapFontImporter.dsfBitmap(stringArray[0], nArrayArray[n6]);
                    n7 = Math.max(n7, nArrayArray[n6][1]);
                    n8 = Math.max(n8, -nArrayArray[n6][3]);
                }
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                for (Object object2 : nArrayArray) {
                    if (object2[0] < n6) {
                        n6 = object2[0];
                    }
                    if (object2[1] > n3) {
                        n3 = object2[1];
                    }
                    if (object2[2] > n4) {
                        n4 = object2[2];
                    }
                    if (object2[3] >= n5) continue;
                    n5 = object2[3];
                }
                Object object = new BitmapFont(n7, n8, n7, n8, 0, 0, 0);
                ((Font)object).setName(1, string);
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    Object object2;
                    boolean[][] blArray = blArrayArray[n2];
                    object2 = new byte[blArray.length][];
                    for (int i = 0; i < blArray.length; ++i) {
                        object2[i] = (int)new byte[blArray[i].length];
                        for (int j = 0; j < blArray[i].length; ++j) {
                            object2[i][j] = (byte)(blArray[i][j] ? -1 : 0);
                        }
                    }
                    BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph((byte[][])object2, nArrayArray[n2][0], nArray[n2], nArrayArray[n2][1]);
                    ((Font)object).putCharacter(n2 + 32, bitmapFontGlyph);
                }
                ((BitmapFont)object).setXHeight();
                ((BitmapFont)object).setCapHeight();
                return object;
            }
            return null;
        }
        return null;
    }

    private static int sgn(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    private static int[] dsfBBox(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        DSFTokenIterator dSFTokenIterator = new DSFTokenIterator(string);
        while (dSFTokenIterator.hasNext()) {
            int n7;
            int n8;
            int n9 = (Integer)dSFTokenIterator.next();
            int n10 = n9 & 0x3F;
            int n11 = n9 >>> 6;
            int n12 = (n10 & 0x10) != 0 ? n5 - n11 : (n8 = (n10 & 0x20) != 0 ? n5 + n11 : n5);
            int n13 = (n10 & 4) != 0 ? n6 + n11 : (n7 = (n10 & 8) != 0 ? n6 - n11 : n6);
            if (n8 < n) {
                n = n8;
            }
            if (n8 > n3) {
                n3 = n8;
            }
            if (n7 < n2) {
                n2 = n7;
            }
            if (n7 > n4) {
                n4 = n7;
            }
            if ((n10 & 1) == 0) continue;
            n5 = n8;
            n6 = n7;
        }
        return new int[]{n, n4 + 1, n3 + 1, n2};
    }

    private static boolean[][] dsfBitmap(String string, int[] nArray) {
        int n = nArray[1] - nArray[3];
        int n2 = nArray[2] - nArray[0];
        boolean[][] blArray = new boolean[n][n2];
        int n3 = -nArray[0];
        int n4 = nArray[1] - 1;
        DSFTokenIterator dSFTokenIterator = new DSFTokenIterator(string);
        while (dSFTokenIterator.hasNext()) {
            int n5;
            int n6;
            int n7 = (Integer)dSFTokenIterator.next();
            int n8 = n7 & 0x3F;
            int n9 = n7 >>> 6;
            int n10 = (n8 & 0x10) != 0 ? n3 - n9 : (n6 = (n8 & 0x20) != 0 ? n3 + n9 : n3);
            int n11 = (n8 & 4) != 0 ? n4 - n9 : (n5 = (n8 & 8) != 0 ? n4 + n9 : n4);
            if ((n8 & 2) != 0) {
                int n12 = DSFBitmapFontImporter.sgn(n6 - n3);
                int n13 = DSFBitmapFontImporter.sgn(n5 - n4);
                int n14 = n3;
                int n15 = n4;
                while (n9 >= 0) {
                    if (n14 >= 0 && n15 >= 0 && n14 < n2 && n15 < n) {
                        blArray[n15][n14] = true;
                    }
                    --n9;
                    n14 += n12;
                    n15 += n13;
                }
            }
            if ((n8 & 1) == 0) continue;
            n3 = n6;
            n4 = n5;
        }
        return blArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DSFTokenIterator
    implements Iterator<Integer> {
        private String str;
        private int strl;
        private int pos;

        public DSFTokenIterator(String string) {
            this.str = string + "xxx";
            this.strl = string.length();
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.strl;
        }

        @Override
        public Integer next() {
            int n = 3;
            char c = this.str.charAt(this.pos++);
            switch (c) {
                case 'N': 
                case 'n': {
                    n = 2;
                    c = this.str.charAt(this.pos++);
                    break;
                }
                case 'B': 
                case 'b': {
                    n = 1;
                    c = this.str.charAt(this.pos++);
                }
            }
            switch (c) {
                case 'U': 
                case 'u': {
                    n |= 4;
                    break;
                }
                case 'D': 
                case 'd': {
                    n |= 8;
                    break;
                }
                case 'L': 
                case 'l': {
                    n |= 0x10;
                    break;
                }
                case 'R': 
                case 'r': {
                    n |= 0x20;
                    break;
                }
                case 'E': 
                case 'e': {
                    n |= 0x24;
                    break;
                }
                case 'F': 
                case 'f': {
                    n |= 0x28;
                    break;
                }
                case 'G': 
                case 'g': {
                    n |= 0x18;
                    break;
                }
                case 'H': 
                case 'h': {
                    n |= 0x14;
                }
            }
            int n2 = 0;
            while (Character.isDigit(this.str.charAt(this.pos))) {
                n2 = n2 * 10 + Character.getNumericValue(this.str.charAt(this.pos++));
            }
            if (n2 == 0) {
                n2 = 1;
            }
            return n2 << 6 | n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

