/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

public class DerivedAgeCodec
extends PuaaCodec {
    private static final Comparator<PuaaSubtableEntry.Single> BY_AGE = new Comparator<PuaaSubtableEntry.Single>(){

        @Override
        public int compare(PuaaSubtableEntry.Single single, PuaaSubtableEntry.Single single2) {
            int n = PuaaUtility.naturalCompare(single.value, single2.value);
            if (n != 0) {
                return n;
            }
            if (single.firstCodePoint != single2.firstCodePoint) {
                return single.firstCodePoint - single2.firstCodePoint;
            }
            if (single.lastCodePoint != single2.lastCodePoint) {
                return single.lastCodePoint - single2.lastCodePoint;
            }
            return 0;
        }
    };

    public String getFileName() {
        return "DerivedAge.txt";
    }

    public String[] getPropertyNames() {
        return new String[]{"Age"};
    }

    public void compile(PuaaTable puaaTable, Scanner scanner) {
        Object object;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        while (scanner.hasNextLine()) {
            object = PuaaUtility.splitLine(scanner.nextLine());
            if (object == null || ((String[])object).length < 2) continue;
            try {
                int[] nArray = PuaaUtility.splitRange((String)object[0]);
                String string = ((String)object[1]).trim();
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    hashMap.put(i, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        object = puaaTable.getOrCreateSubtable("Age");
        ((ArrayList)object).addAll(PuaaUtility.createEntriesFromStringMap(hashMap));
    }

    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        PuaaSubtable puaaSubtable = puaaTable.getSubtable("Age");
        if (puaaSubtable == null || puaaSubtable.isEmpty()) {
            return;
        }
        List<PuaaSubtableEntry.Single> list = PuaaUtility.createRunsFromEntries(puaaSubtable);
        Collections.sort(list, BY_AGE);
        for (PuaaSubtableEntry.Single single : list) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PuaaUtility.joinRange(single));
            while (stringBuffer.length() < 14) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("; ");
            stringBuffer.append(single.value);
            printWriter.println(stringBuffer.toString());
        }
    }
}

