/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeDataCodec
extends PuaaCodec {
    @Override
    public String getFileName() {
        return "UnicodeData.txt";
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"Name", "General_Category", "Canonical_Combining_Class", "Bidi_Class", "Decomposition_Type", "Decomposition_Mapping", "Numeric_Type", "Numeric_Value", "Bidi_Mirrored", "Unicode_1_Name", "ISO_Comment", "Simple_Uppercase_Mapping", "Simple_Lowercase_Mapping", "Simple_Titlecase_Mapping"};
    }

    @Override
    public void compile(PuaaTable puaaTable, Scanner scanner) {
        ArrayList arrayList;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        HashMap<Integer, String> hashMap4 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap5 = new HashMap<Integer, String>();
        HashMap<Integer, int[]> hashMap6 = new HashMap<Integer, int[]>();
        HashMap<Integer, String> hashMap7 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap8 = new HashMap<Integer, String>();
        HashMap<Integer, Boolean> hashMap9 = new HashMap<Integer, Boolean>();
        HashMap<Integer, String> hashMap10 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap11 = new HashMap<Integer, String>();
        HashMap<Integer, Integer> hashMap12 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap13 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap14 = new HashMap<Integer, Integer>();
        while (scanner.hasNextLine()) {
            String[] stringArray;
            Integer n;
            Integer n2;
            String[] stringArray2 = PuaaUtility.splitLine(scanner.nextLine());
            if (stringArray2 == null || (n2 = UnicodeDataCodec.parseHex(stringArray2, 0)) == null) continue;
            String string = UnicodeDataCodec.parseString(stringArray2, 1);
            if (string != null) {
                hashMap.put(n2, string);
            }
            if ((string = UnicodeDataCodec.parseString(stringArray2, 2)) != null) {
                hashMap2.put(n2, string);
            }
            if ((n = UnicodeDataCodec.parseInt(stringArray2, 3)) != null) {
                hashMap3.put(n2, n);
            }
            if ((string = UnicodeDataCodec.parseString(stringArray2, 4)) != null) {
                hashMap4.put(n2, string);
            }
            if ((stringArray = UnicodeDataCodec.parseWords(stringArray2, 5)) != null) {
                arrayList = new ArrayList();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (String string2 : stringArray) {
                    try {
                        arrayList2.add(Integer.parseInt(string2, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        arrayList.add(string2);
                    }
                }
                if (!arrayList.isEmpty()) {
                    hashMap5.put(n2, UnicodeDataCodec.joinWords(arrayList));
                }
                if (!arrayList2.isEmpty()) {
                    hashMap6.put(n2, UnicodeDataCodec.toIntArray(arrayList2));
                }
            }
            if ((string = UnicodeDataCodec.parseString(stringArray2, 6)) != null) {
                hashMap7.put(n2, "Decimal");
                hashMap8.put(n2, string);
            } else {
                string = UnicodeDataCodec.parseString(stringArray2, 7);
                if (string != null) {
                    hashMap7.put(n2, "Digit");
                    hashMap8.put(n2, string);
                } else {
                    string = UnicodeDataCodec.parseString(stringArray2, 8);
                    if (string != null) {
                        hashMap7.put(n2, "Numeric");
                        hashMap8.put(n2, string);
                    }
                }
            }
            Boolean bl = UnicodeDataCodec.parseBoolean(stringArray2, 9);
            if (bl != null) {
                hashMap9.put(n2, bl);
            }
            if ((string = UnicodeDataCodec.parseString(stringArray2, 10)) != null) {
                hashMap10.put(n2, string);
            }
            if ((string = UnicodeDataCodec.parseString(stringArray2, 11)) != null) {
                hashMap11.put(n2, string);
            }
            if ((n = UnicodeDataCodec.parseHex(stringArray2, 12)) != null) {
                hashMap12.put(n2, n);
            }
            if ((n = UnicodeDataCodec.parseHex(stringArray2, 13)) != null) {
                hashMap13.put(n2, n);
            }
            if ((n = UnicodeDataCodec.parseHex(stringArray2, 14)) == null) continue;
            hashMap14.put(n2, n);
        }
        arrayList = puaaTable.getOrCreateSubtable("Name");
        arrayList.addAll(PuaaUtility.createEntriesFromNameMap(hashMap));
        arrayList = puaaTable.getOrCreateSubtable("General_Category");
        arrayList.addAll(PuaaUtility.createEntriesFromStringMap(hashMap2));
        arrayList = puaaTable.getOrCreateSubtable("Canonical_Combining_Class");
        arrayList.addAll(PuaaUtility.createEntriesFromDecimalMap(hashMap3));
        arrayList = puaaTable.getOrCreateSubtable("Bidi_Class");
        arrayList.addAll(PuaaUtility.createEntriesFromStringMap(hashMap4));
        arrayList = puaaTable.getOrCreateSubtable("Decomposition_Type");
        arrayList.addAll(PuaaUtility.createEntriesFromStringMap(hashMap5));
        arrayList = puaaTable.getOrCreateSubtable("Decomposition_Mapping");
        arrayList.addAll(PuaaUtility.createEntriesFromHexSequenceMap(hashMap6));
        arrayList = puaaTable.getOrCreateSubtable("Numeric_Type");
        arrayList.addAll(PuaaUtility.createEntriesFromStringMap(hashMap7));
        arrayList = puaaTable.getOrCreateSubtable("Numeric_Value");
        arrayList.addAll(PuaaUtility.createEntriesFromStringMap(hashMap8));
        arrayList = puaaTable.getOrCreateSubtable("Bidi_Mirrored");
        arrayList.addAll(PuaaUtility.createEntriesFromBooleanMap(hashMap9));
        arrayList = puaaTable.getOrCreateSubtable("Unicode_1_Name");
        arrayList.addAll(PuaaUtility.createEntriesFromNameMap(hashMap10));
        arrayList = puaaTable.getOrCreateSubtable("ISO_Comment");
        arrayList.addAll(PuaaUtility.createEntriesFromStringMap(hashMap11));
        arrayList = puaaTable.getOrCreateSubtable("Simple_Uppercase_Mapping");
        arrayList.addAll(PuaaUtility.createEntriesFromHexadecimalMap(hashMap12));
        arrayList = puaaTable.getOrCreateSubtable("Simple_Lowercase_Mapping");
        arrayList.addAll(PuaaUtility.createEntriesFromHexadecimalMap(hashMap13));
        arrayList = puaaTable.getOrCreateSubtable("Simple_Titlecase_Mapping");
        arrayList.addAll(PuaaUtility.createEntriesFromHexadecimalMap(hashMap14));
    }

    @Override
    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        PuaaSubtable puaaSubtable = puaaTable.getSubtable("Name");
        PuaaSubtable puaaSubtable2 = puaaTable.getSubtable("General_Category");
        PuaaSubtable puaaSubtable3 = puaaTable.getSubtable("Canonical_Combining_Class");
        PuaaSubtable puaaSubtable4 = puaaTable.getSubtable("Bidi_Class");
        PuaaSubtable puaaSubtable5 = puaaTable.getSubtable("Decomposition_Type");
        PuaaSubtable puaaSubtable6 = puaaTable.getSubtable("Decomposition_Mapping");
        PuaaSubtable puaaSubtable7 = puaaTable.getSubtable("Numeric_Type");
        PuaaSubtable puaaSubtable8 = puaaTable.getSubtable("Numeric_Value");
        PuaaSubtable puaaSubtable9 = puaaTable.getSubtable("Bidi_Mirrored");
        PuaaSubtable puaaSubtable10 = puaaTable.getSubtable("Unicode_1_Name");
        PuaaSubtable puaaSubtable11 = puaaTable.getSubtable("ISO_Comment");
        PuaaSubtable puaaSubtable12 = puaaTable.getSubtable("Simple_Uppercase_Mapping");
        PuaaSubtable puaaSubtable13 = puaaTable.getSubtable("Simple_Lowercase_Mapping");
        PuaaSubtable puaaSubtable14 = puaaTable.getSubtable("Simple_Titlecase_Mapping");
        TreeMap<Integer, String[]> treeMap = new TreeMap<Integer, String[]>();
        if (puaaSubtable != null) {
            for (String[] stringArray : puaaSubtable) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 1);
            }
        }
        if (puaaSubtable2 != null) {
            for (String[] stringArray : puaaSubtable2) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 2);
            }
        }
        if (puaaSubtable3 != null) {
            for (String[] stringArray : puaaSubtable3) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 3);
            }
        }
        if (puaaSubtable4 != null) {
            for (String[] stringArray : puaaSubtable4) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 4);
            }
        }
        if (puaaSubtable5 != null) {
            for (String[] stringArray : puaaSubtable5) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 5);
            }
        }
        if (puaaSubtable6 != null) {
            for (String[] stringArray : puaaSubtable6) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 5);
            }
        }
        if (puaaSubtable7 != null) {
            for (String[] stringArray : puaaSubtable7) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 8);
            }
        }
        if (puaaSubtable8 != null) {
            for (String[] stringArray : puaaSubtable8) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 8);
            }
        }
        if (puaaSubtable9 != null) {
            for (String[] stringArray : puaaSubtable9) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 9);
            }
        }
        if (puaaSubtable10 != null) {
            for (String[] stringArray : puaaSubtable10) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 10);
            }
        }
        if (puaaSubtable11 != null) {
            for (String[] stringArray : puaaSubtable11) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 11);
            }
        }
        if (puaaSubtable12 != null) {
            for (String[] stringArray : puaaSubtable12) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 12);
            }
        }
        if (puaaSubtable13 != null) {
            for (String[] stringArray : puaaSubtable13) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 13);
            }
        }
        if (puaaSubtable14 != null) {
            for (String[] stringArray : puaaSubtable14) {
                UnicodeDataCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 14);
            }
        }
        for (String[] stringArray : treeMap.values()) {
            printWriter.println(PuaaUtility.joinLine(stringArray, ";"));
        }
    }

    private static Integer parseInt(String[] stringArray, int n) {
        if (stringArray == null || n < 0 || n >= stringArray.length) {
            return null;
        }
        try {
            return Integer.parseInt(stringArray[n].trim(), 10);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static Integer parseHex(String[] stringArray, int n) {
        if (stringArray == null || n < 0 || n >= stringArray.length) {
            return null;
        }
        try {
            return Integer.parseInt(stringArray[n].trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String parseString(String[] stringArray, int n) {
        if (stringArray == null || n < 0 || n >= stringArray.length) {
            return null;
        }
        String string = stringArray[n].trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private static String[] parseWords(String[] stringArray, int n) {
        if (stringArray == null || n < 0 || n >= stringArray.length) {
            return null;
        }
        String string = stringArray[n].trim();
        if (string.length() == 0) {
            return null;
        }
        return string.split("\\s+");
    }

    private static Boolean parseBoolean(String[] stringArray, int n) {
        if (stringArray == null || n < 0 || n >= stringArray.length) {
            return null;
        }
        String string = stringArray[n].trim();
        if (string.length() == 0) {
            return null;
        }
        return string.equalsIgnoreCase("Y");
    }

    private static int[] toIntArray(Collection<Integer> collection) {
        Integer[] integerArray = collection.toArray(new Integer[collection.size()]);
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    private static String joinWords(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : list) {
            if (string == null || string.length() <= 0) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static void addLine(TreeMap<Integer, String[]> treeMap, PuaaSubtableEntry puaaSubtableEntry, int n) {
        for (int i = puaaSubtableEntry.firstCodePoint; i <= puaaSubtableEntry.lastCodePoint; ++i) {
            String[] stringArray;
            String string = puaaSubtableEntry.getPropertyValue(i);
            if (string == null || string.length() == 0) continue;
            if (treeMap.containsKey(i)) {
                stringArray = treeMap.get(i);
                if (stringArray[n] == null) {
                    stringArray[n] = string;
                    continue;
                }
                if (n == 8) {
                    if (stringArray[n].equals("Decimal")) {
                        stringArray[7] = stringArray[8] = string;
                        stringArray[6] = stringArray[8];
                    }
                    if (stringArray[n].equals("Digit")) {
                        stringArray[7] = stringArray[8] = string;
                    }
                    if (!stringArray[n].equals("Numeric")) continue;
                    stringArray[8] = string;
                    continue;
                }
                if (n == 5) {
                    int n2 = n;
                    stringArray[n2] = stringArray[n2] + " ";
                }
                int n3 = n;
                stringArray[n3] = stringArray[n3] + string;
                continue;
            }
            stringArray = new String[15];
            stringArray[0] = PuaaUtility.toHexString(i);
            stringArray[n] = string;
            treeMap.put(i, stringArray);
        }
    }
}

