/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.CmapSubtableEntry;
import com.kreative.bitsnpicas.truetype.CmapSubtableRandomEntry;
import com.kreative.bitsnpicas.truetype.CmapSubtableSequentialEntry;
import com.kreative.bitsnpicas.truetype.ListBasedCmapSubtable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmapSubtableFormat4
extends ListBasedCmapSubtable<CmapSubtableEntry> {
    public int languageID = 0;

    @Override
    public int format() {
        return 4;
    }

    @Override
    public int getGlyphIndex(int n) {
        for (CmapSubtableEntry cmapSubtableEntry : this) {
            if (!cmapSubtableEntry.contains(n)) continue;
            return cmapSubtableEntry.getGlyphIndex(n);
        }
        return 0;
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = this.size();
        for (n = 0x40000000; n > n2; n >>>= 1) {
        }
        int n3 = Integer.numberOfTrailingZeros(n);
        int n4 = (n2 << 1) - (n <<= 1);
        int n5 = 16 + n2 * 8;
        for (Object object : this) {
            if (!(object instanceof CmapSubtableRandomEntry)) continue;
            n5 += ((CmapSubtableRandomEntry)object).glyphIndex.length * 2;
        }
        dataOutputStream.writeShort(4);
        dataOutputStream.writeShort(n5);
        dataOutputStream.writeShort(this.languageID);
        dataOutputStream.writeShort(n2 * 2);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(n4);
        for (Object object : this) {
            dataOutputStream.writeShort(((CmapSubtableEntry)object).endCharCode);
        }
        dataOutputStream.writeShort(0);
        for (Object object : this) {
            dataOutputStream.writeShort(((CmapSubtableEntry)object).startCharCode);
        }
        for (Object object : this) {
            if (object instanceof CmapSubtableSequentialEntry) {
                dataOutputStream.writeShort(((CmapSubtableSequentialEntry)object).glyphIndex - ((CmapSubtableEntry)object).startCharCode);
                continue;
            }
            dataOutputStream.writeShort(0);
        }
        int n6 = this.size();
        for (CmapSubtableEntry cmapSubtableEntry : this) {
            if (cmapSubtableEntry instanceof CmapSubtableRandomEntry) {
                dataOutputStream.writeShort(n6 * 2);
                n6 += ((CmapSubtableRandomEntry)cmapSubtableEntry).glyphIndex.length;
            } else {
                dataOutputStream.writeShort(0);
            }
            --n6;
        }
        for (CmapSubtableEntry cmapSubtableEntry : this) {
            if (!(cmapSubtableEntry instanceof CmapSubtableRandomEntry)) continue;
            for (int n7 : ((CmapSubtableRandomEntry)cmapSubtableEntry).glyphIndex) {
                dataOutputStream.writeShort(n7);
            }
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        this.languageID = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort() / 2;
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = dataInputStream.readUnsignedShort();
        }
        dataInputStream.readUnsignedShort();
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = dataInputStream.readUnsignedShort();
        }
        int[] nArray3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray3[i] = dataInputStream.readUnsignedShort();
        }
        dataInputStream.mark(n);
        int[] nArray4 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray4[n2] = dataInputStream.readUnsignedShort();
        }
        this.clear();
        for (n2 = 0; n2 < n3; ++n2) {
            CmapSubtableEntry cmapSubtableEntry;
            if (nArray4[n2] == 0) {
                cmapSubtableEntry = new CmapSubtableSequentialEntry();
                cmapSubtableEntry.startCharCode = nArray2[n2];
                cmapSubtableEntry.endCharCode = nArray[n2];
                cmapSubtableEntry.glyphIndex = nArray2[n2] + nArray3[n2] & 0xFFFF;
                this.add(cmapSubtableEntry);
                continue;
            }
            cmapSubtableEntry = new CmapSubtableRandomEntry();
            ((CmapSubtableRandomEntry)cmapSubtableEntry).startCharCode = nArray2[n2];
            ((CmapSubtableRandomEntry)cmapSubtableEntry).endCharCode = nArray[n2];
            ((CmapSubtableRandomEntry)cmapSubtableEntry).glyphIndex = new int[((CmapSubtableRandomEntry)cmapSubtableEntry).endCharCode - ((CmapSubtableRandomEntry)cmapSubtableEntry).startCharCode + 1];
            dataInputStream.reset();
            dataInputStream.skipBytes(n2 + n2 + nArray4[n2]);
            for (int i = 0; i < ((CmapSubtableRandomEntry)cmapSubtableEntry).glyphIndex.length; ++i) {
                ((CmapSubtableRandomEntry)cmapSubtableEntry).glyphIndex[i] = dataInputStream.readUnsignedShort();
            }
            this.add(cmapSubtableEntry);
        }
    }
}

