/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.CmapTable;
import com.kreative.bitsnpicas.truetype.ColrTable;
import com.kreative.bitsnpicas.truetype.CpalTable;
import com.kreative.bitsnpicas.truetype.EbdtTable;
import com.kreative.bitsnpicas.truetype.EblcTable;
import com.kreative.bitsnpicas.truetype.GlyfTable;
import com.kreative.bitsnpicas.truetype.HeadTable;
import com.kreative.bitsnpicas.truetype.HheaTable;
import com.kreative.bitsnpicas.truetype.HmtxTable;
import com.kreative.bitsnpicas.truetype.LocaTable;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.NameTable;
import com.kreative.bitsnpicas.truetype.Os2Table;
import com.kreative.bitsnpicas.truetype.PostTable;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import com.kreative.bitsnpicas.truetype.SbitTableType;
import com.kreative.bitsnpicas.truetype.SbixTable;
import com.kreative.bitsnpicas.truetype.SvgTable;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import com.kreative.bitsnpicas.truetype.UnknownTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeFile
extends ArrayList<TrueTypeTable> {
    private static final long serialVersionUID = 1L;
    public static final int SCALER_TRUETYPE = 65536;
    public static final int SCALER_OPENTYPE = 0x4F54544F;
    public static final int SCALER_TRUETYPE_GX = 1953658213;
    public static final int SCALER_POSTSCRIPT_GX = 1954115633;
    public static final int SCALER_META = 2005826048;
    public boolean interpret = true;
    public int scaler = 65536;
    private static final Comparator<TrueTypeTableInfo> SORT_BY_ID = new Comparator<TrueTypeTableInfo>(){

        @Override
        public int compare(TrueTypeTableInfo trueTypeTableInfo, TrueTypeTableInfo trueTypeTableInfo2) {
            return trueTypeTableInfo.id - trueTypeTableInfo2.id;
        }
    };
    private static final Comparator<TrueTypeTableInfo> SORT_BY_LOCATION = new Comparator<TrueTypeTableInfo>(){

        @Override
        public int compare(TrueTypeTableInfo trueTypeTableInfo, TrueTypeTableInfo trueTypeTableInfo2) {
            return trueTypeTableInfo.location - trueTypeTableInfo2.location;
        }
    };

    private TrueTypeTable createTable(int n) {
        if (!this.interpret) {
            return new UnknownTable(n);
        }
        switch (n) {
            case 1128416340: {
                return new EbdtTable(SbitTableType.COLOR);
            }
            case 1128418371: {
                return new EblcTable(SbitTableType.COLOR);
            }
            case 1129270354: {
                return new ColrTable();
            }
            case 1129333068: {
                return new CpalTable();
            }
            case 0x45424454: {
                return new EbdtTable(SbitTableType.OPENTYPE);
            }
            case 1161972803: {
                return new EblcTable(SbitTableType.OPENTYPE);
            }
            case 1330851634: {
                return new Os2Table();
            }
            case 1347764545: {
                return new PuaaTable();
            }
            case 1398163232: {
                return new SvgTable();
            }
            case 1650745716: {
                return new EbdtTable(SbitTableType.TRUETYPE);
            }
            case 1651273571: {
                return new EblcTable(SbitTableType.TRUETYPE);
            }
            case 1668112752: {
                return new CmapTable();
            }
            case 1735162214: {
                return new GlyfTable();
            }
            case 1751474532: {
                return new HeadTable();
            }
            case 1751672161: {
                return new HheaTable();
            }
            case 1752003704: {
                return new HmtxTable();
            }
            case 1819239265: {
                return new LocaTable();
            }
            case 1835104368: {
                return new MaxpTable();
            }
            case 1851878757: {
                return new NameTable();
            }
            case 1886352244: {
                return new PostTable();
            }
            case 1935829368: {
                return new SbixTable();
            }
        }
        return new UnknownTable(n);
    }

    public TrueTypeTable getByTableName(String string) {
        if (string != null) {
            for (TrueTypeTable trueTypeTable : this) {
                if (!string.equals(trueTypeTable.tableName())) continue;
                return trueTypeTable;
            }
        }
        return null;
    }

    public TrueTypeTable getByTableId(int n) {
        for (TrueTypeTable trueTypeTable : this) {
            if (n != trueTypeTable.tableId()) continue;
            return trueTypeTable;
        }
        return null;
    }

    public boolean isOpenType() {
        for (TrueTypeTable trueTypeTable : this) {
            String string = trueTypeTable.tableName();
            if ("CFF ".equals(string)) {
                return true;
            }
            if (!"CFF2".equals(string)) continue;
            return true;
        }
        return false;
    }

    public byte[] compile() throws IOException {
        Object object;
        Object object222;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = this.size();
        for (n = 0x40000000; n > n2; n >>>= 1) {
        }
        int n3 = Integer.numberOfTrailingZeros(n);
        int n4 = (n2 << 4) - (n <<= 4);
        int n5 = 12 + (n2 << 4);
        int n6 = -1;
        dataOutputStream.writeInt(this.scaler);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(n4);
        HashMap hashMap = new HashMap();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (Object object222 : this) {
            int n7 = ((TrueTypeTable)object222).tableId();
            hashMap.put(n7, object222);
            object = new TrueTypeTableInfo();
            ((TrueTypeTableInfo)object).table = object222;
            ((TrueTypeTableInfo)object).id = n7;
            arrayList.add((int[])object);
        }
        int n8 = n5;
        for (TrueTypeTableInfo trueTypeTableInfo : arrayList) {
            object = trueTypeTableInfo.table.dependencyIds();
            TrueTypeTable[] trueTypeTableArray = new TrueTypeTable[((int[])object).length];
            for (int i = 0; i < ((int[])object).length; ++i) {
                if (!hashMap.containsKey(object[i])) {
                    throw TrueTypeFile.unresolvedDependency(trueTypeTableInfo.table);
                }
                trueTypeTableArray[i] = (TrueTypeTable)hashMap.get(object[i]);
            }
            TrueTypeTableInfo.access$302(trueTypeTableInfo, trueTypeTableInfo.table.compile(trueTypeTableArray));
            trueTypeTableInfo.length = trueTypeTableInfo.data.length;
            trueTypeTableInfo.location = n8;
            if (trueTypeTableInfo.id == 1751474532) {
                n6 = trueTypeTableInfo.location + 8;
                TrueTypeFile.putInt(trueTypeTableInfo.data, 8, 0);
            }
            trueTypeTableInfo.checksum = TrueTypeFile.chksum(trueTypeTableInfo.data);
            n8 += trueTypeTableInfo.length + 3 & 0xFFFFFFFC;
        }
        Collections.sort(arrayList, SORT_BY_ID);
        for (TrueTypeTableInfo trueTypeTableInfo : arrayList) {
            dataOutputStream.writeInt(trueTypeTableInfo.id);
            dataOutputStream.writeInt(trueTypeTableInfo.checksum);
            dataOutputStream.writeInt(trueTypeTableInfo.location);
            dataOutputStream.writeInt(trueTypeTableInfo.length);
        }
        Collections.sort(arrayList, SORT_BY_LOCATION);
        for (TrueTypeTableInfo trueTypeTableInfo : arrayList) {
            dataOutputStream.write(trueTypeTableInfo.data);
            int n9 = trueTypeTableInfo.length & 3;
            if (n9 <= 0) continue;
            while (n9 < 4) {
                dataOutputStream.writeByte(0);
                ++n9;
            }
        }
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        object222 = byteArrayOutputStream.toByteArray();
        if (n6 >= 0) {
            TrueTypeFile.putInt((byte[])object222, n6, -1313820742 - TrueTypeFile.chksum((byte[])object222));
        }
        return object222;
    }

    public void decompile(byte[] byArray) throws IOException {
        ArrayList<TrueTypeTableInfo> arrayList;
        DataInputStream dataInputStream;
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            int n;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            this.scaler = dataInputStream.readInt();
            int n2 = dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            arrayList = new ArrayList<TrueTypeTableInfo>();
            HashMap<Integer, TrueTypeTableInfo> hashMap = new HashMap<Integer, TrueTypeTableInfo>();
            for (int i = 0; i < n2; ++i) {
                TrueTypeTableInfo trueTypeTableInfo = new TrueTypeTableInfo();
                trueTypeTableInfo.id = dataInputStream.readInt();
                trueTypeTableInfo.checksum = dataInputStream.readInt();
                trueTypeTableInfo.location = dataInputStream.readInt();
                trueTypeTableInfo.length = dataInputStream.readInt();
                arrayList.add(trueTypeTableInfo);
                hashMap.put(trueTypeTableInfo.id, trueTypeTableInfo);
            }
            for (TrueTypeTableInfo trueTypeTableInfo : arrayList) {
                TrueTypeTableInfo.access$302(trueTypeTableInfo, new byte[trueTypeTableInfo.length]);
                dataInputStream.reset();
                dataInputStream.skipBytes(trueTypeTableInfo.location);
                dataInputStream.readFully(trueTypeTableInfo.data);
            }
            do {
                n = 0;
                int n3 = 0;
                for (TrueTypeTableInfo trueTypeTableInfo : arrayList) {
                    if (trueTypeTableInfo.table != null) continue;
                    TrueTypeTable trueTypeTable = this.createTable(trueTypeTableInfo.id);
                    int[] nArray = trueTypeTable.dependencyIds();
                    TrueTypeTable[] trueTypeTableArray = new TrueTypeTable[nArray.length];
                    boolean bl = true;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (hashMap.containsKey(nArray[i])) {
                            trueTypeTableArray[i] = ((TrueTypeTableInfo)hashMap.get(nArray[i])).table;
                            if (trueTypeTableArray[i] != null) continue;
                            bl = false;
                            continue;
                        }
                        throw TrueTypeFile.unresolvedDependency(trueTypeTable);
                    }
                    if (bl) {
                        trueTypeTable.decompile(trueTypeTableInfo.data, trueTypeTableArray);
                        trueTypeTableInfo.table = trueTypeTable;
                        ++n;
                        continue;
                    }
                    ++n3;
                }
                if (n3 == 0) break block8;
            } while (n != 0);
            throw new IllegalStateException("Circular dependency detected.");
        }
        this.clear();
        Collections.sort(arrayList, SORT_BY_LOCATION);
        for (TrueTypeTableInfo trueTypeTableInfo : arrayList) {
            this.add(trueTypeTableInfo.table);
        }
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    private static final int chksum(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = byArray.length & 0xFFFFFFFC;
        for (n = 0; n < n3; n += 4) {
            n2 += TrueTypeFile.getInt(byArray, n);
        }
        n = n3;
        int n4 = 24;
        while (n < byArray.length) {
            n2 += (byArray[n] & 0xFF) << n4;
            ++n;
            n4 -= 8;
        }
        return n2;
    }

    private static final int getInt(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 0;
    }

    private static final void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 0 & 0xFF);
    }

    private static final IllegalStateException unresolvedDependency(TrueTypeTable trueTypeTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unresolved dependency: ");
        stringBuffer.append(trueTypeTable.tableName());
        stringBuffer.append(" depends on");
        for (String string : trueTypeTable.dependencyNames()) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        stringBuffer.append(".");
        return new IllegalStateException(stringBuffer.toString());
    }

    private static final class TrueTypeTableInfo {
        private int id;
        private int checksum;
        private int location;
        private int length;
        private byte[] data;
        private TrueTypeTable table;

        private TrueTypeTableInfo() {
        }

        static /* synthetic */ byte[] access$302(TrueTypeTableInfo trueTypeTableInfo, byte[] byArray) {
            trueTypeTableInfo.data = byArray;
            return byArray;
        }
    }
}

