/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.fontmap;

import com.kreative.unicode.fontmap.FontMapEntry;
import com.kreative.unicode.fontmap.FontMapTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontMapPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final FontMapTableModel model;
    private final JTable table;
    private final JButton addButton;
    private final JButton removeButton;
    private final JButton upButton;
    private final JButton downButton;

    public FontMapPanel() {
        this(new FontMapTableModel());
    }

    public FontMapPanel(Collection<? extends FontMapEntry> collection) {
        this(new FontMapTableModel(collection));
    }

    private FontMapPanel(FontMapTableModel fontMapTableModel) {
        this.model = fontMapTableModel;
        this.table = new JTable(fontMapTableModel);
        this.addButton = new JButton("+");
        FontMapPanel.squareOff(this.addButton);
        this.removeButton = new JButton("\u2212");
        FontMapPanel.squareOff(this.removeButton);
        this.upButton = new JButton("\u2191");
        FontMapPanel.squareOff(this.upButton);
        this.downButton = new JButton("\u2193");
        FontMapPanel.squareOff(this.downButton);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.addButton);
        jPanel.add(this.removeButton);
        jPanel.add(this.upButton);
        jPanel.add(this.downButton);
        JScrollPane jScrollPane = new JScrollPane(this.table, 22, 32);
        JPanel jPanel2 = new JPanel(new BorderLayout(8, 8));
        jPanel2.add((Component)jPanel, "Last");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(jPanel2);
        this.addActionListeners();
    }

    private void addActionListeners() {
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FontMapPanel.this.table.getSelectedRow();
                n = n < 0 ? FontMapPanel.this.model.size() : n + 1;
                FontMapPanel.this.model.add(n, new FontMapEntry());
                FontMapPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FontMapPanel.this.table.getSelectedRow();
                if (n < 0) {
                    return;
                }
                FontMapPanel.this.model.remove(n);
                FontMapPanel.this.table.clearSelection();
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FontMapPanel.this.table.getSelectedRow();
                if (n <= 0) {
                    return;
                }
                FontMapEntry fontMapEntry = FontMapPanel.this.model.remove(n);
                FontMapPanel.this.model.add(--n, fontMapEntry);
                FontMapPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FontMapPanel.this.table.getSelectedRow();
                if (n < 0 || n >= FontMapPanel.this.model.size() - 1) {
                    return;
                }
                FontMapEntry fontMapEntry = FontMapPanel.this.model.remove(n);
                FontMapPanel.this.model.add(++n, fontMapEntry);
                FontMapPanel.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        });
    }

    public FontMapTableModel getFontMap() {
        return this.model;
    }

    private static void squareOff(JComponent jComponent) {
        int n = jComponent.getPreferredSize().height + 8;
        jComponent.setMinimumSize(new Dimension(n, n));
        jComponent.setPreferredSize(new Dimension(n, n));
        jComponent.setMaximumSize(new Dimension(n, n));
        jComponent.putClientProperty("JButton.buttonType", "bevel");
    }
}

