/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import com.kreative.unicode.ttflib.DfontResourceType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfontFile {
    private int dataOffset;
    private int mapOffset;
    private int attributes;
    private int typesOffset;
    private int namesOffset;
    private List<DfontResourceType> types;
    private Map<Integer, DfontResourceType> byType;
    private Map<String, DfontResourceType> byTypeString;

    public DfontFile(File file) throws IOException {
        this.read(file);
    }

    public DfontFile(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public DfontFile(byte[] byArray) throws IOException {
        this.read(byArray);
    }

    private void read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.read(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    private void read(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        this.read(byteArrayOutputStream.toByteArray());
    }

    private void read(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.readHead(dataInputStream);
        this.readBody(dataInputStream);
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    private void readHead(DataInputStream dataInputStream) throws IOException {
        this.dataOffset = dataInputStream.readInt();
        this.mapOffset = dataInputStream.readInt();
        dataInputStream.reset();
        dataInputStream.skipBytes(this.mapOffset + 22);
        this.attributes = dataInputStream.readShort();
        this.typesOffset = dataInputStream.readShort();
        this.namesOffset = dataInputStream.readShort();
    }

    private void readBody(DataInputStream dataInputStream) throws IOException {
        this.types = new ArrayList<DfontResourceType>();
        this.byType = new TreeMap<Integer, DfontResourceType>();
        this.byTypeString = new TreeMap<String, DfontResourceType>();
        dataInputStream.reset();
        dataInputStream.skipBytes(this.mapOffset + this.typesOffset);
        int n = dataInputStream.readShort() + 1 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            DfontResourceType dfontResourceType = new DfontResourceType();
            dfontResourceType.readHead(dataInputStream);
            this.types.add(dfontResourceType);
            this.byType.put(dfontResourceType.getType(), dfontResourceType);
            this.byTypeString.put(dfontResourceType.getTypeString(), dfontResourceType);
        }
        for (DfontResourceType dfontResourceType : this.types) {
            dfontResourceType.readBody(dataInputStream, this.dataOffset, this.mapOffset, this.typesOffset, this.namesOffset);
        }
        this.types = Collections.unmodifiableList(this.types);
        this.byType = Collections.unmodifiableMap(this.byType);
        this.byTypeString = Collections.unmodifiableMap(this.byTypeString);
    }

    public int getAttributes() {
        return this.attributes;
    }

    public List<DfontResourceType> getResourceTypes() {
        return this.types;
    }

    public Set<Integer> getResourceTypeIds() {
        return this.byType.keySet();
    }

    public Set<String> getResourceTypeStrings() {
        return this.byTypeString.keySet();
    }

    public DfontResourceType getResourceType(int n) {
        return this.byType.get(n);
    }

    public DfontResourceType getResourceType(String string) {
        return this.byTypeString.get(string);
    }
}

