// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief chi_c0 -> p pbar eta pi0
  class BESIII_2024_I2860910 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2024_I2860910);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      UnstableParticles ufs = UnstableParticles(Cuts::pid==10441);
      declare(ufs, "UFS");
      DecayedParticles chi(ufs);
      chi.addStable( PID::PI0);
      chi.addStable( PID::K0S);
      chi.addStable( PID::ETA);
      declare(chi, "chi");
      for(unsigned int ix=0;ix<4;++ix)
	book(_h[ix],1,1,ix+1);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      static const map<PdgId,unsigned int> & mode1 = { { 2212,1}, {-2212,1}, {111,1}, {221,1} };
      DecayedParticles chi = apply<DecayedParticles>(event, "chi");
      // loop over particles
      for(unsigned int ix=0;ix<chi.decaying().size();++ix) {
	if(!chi.modeMatches(ix,4,mode1)) continue;
	const Particle & pi0 = chi.decayProducts()[ix].at(  111)[0];
	const Particle & eta = chi.decayProducts()[ix].at(  221)[0];
	const Particle & pp  = chi.decayProducts()[ix].at( 2212)[0];
	const Particle & pb  = chi.decayProducts()[ix].at(-2212)[0];
	_h[0]->fill((pp .momentum()+pb .momentum()).mass());
	_h[1]->fill((eta.momentum()+pi0.momentum()).mass());
	_h[2]->fill((pp .momentum()+eta.momentum()).mass());
	_h[2]->fill((pb .momentum()+eta.momentum()).mass());
	_h[3]->fill((pp .momentum()+pi0.momentum()).mass());
	_h[3]->fill((pb .momentum()+pi0.momentum()).mass());
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      normalize(_h);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[4];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2024_I2860910);

}
