// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class CMD2_2003_I616446 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CMD2_2003_I616446);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");
      declare(UnstableParticles(), "UFS");
      book(_numOmegaPi, 1, 1, 1);
    }


    void findChildren(const Particle & p,map<long,int> & nRes, int &ncount) {
      for (const Particle &child : p.children()) {
	if(child.children().empty()) {
	  nRes[child.pid()]+=1;
	  ++ncount;
	}
	else
	  findChildren(child,nRes,ncount);
      }
    }

    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
	nCount[p.pid()] += 1;
	++ntotal;
      }
      // three particles (pi0 pi0 gamma)
      if(ntotal!=3) vetoEvent;
      const FinalState& ufs = apply<FinalState>(event, "UFS");
      for (const Particle& p : ufs.particles()) {
	if(p.children().empty()) continue;
	// find the omega
	if(p.pid()==223) {
	  map<long,int> nRes;
	  int ncount(0);
	  findChildren(p,nRes,ncount);
	  // only omega to pi0 gamma mode
	  if(ncount!=2) continue;
	  if(nRes[111]!=1 || nRes[22]!=1) continue;
	  // omega pi0
	  if(nCount[111]-nRes[111]==1)
	    _numOmegaPi->fill(round(sqrtS()/MeV));
	}
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_numOmegaPi, crossSection()/ sumOfWeights() /nanobarn);
    }

    /// @name Histograms
    /// @{
    BinnedHistoPtr<int> _numOmegaPi;
    /// @}

  };


  RIVET_DECLARE_PLUGIN(CMD2_2003_I616446);


}
