// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/ChargedFinalState.hh"

namespace Rivet {


  /// @brief Charged multiplicity
  class MARKI_1982_I169326 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(MARKI_1982_I169326);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(ChargedFinalState(), "FS");

      // Book histograms
      book(_nHadrons, 6, 1, 1);
      for (const string& en : _nHadrons.binning().edges<0>()) {
        const double eval = stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      _nHadrons->fill(_sqs, apply<ChargedFinalState>(event, "FS").particles().size());
    }


    /// Normalise histograms etc., after the run
    void finalize() {}
    /// @}


    /// @name Histograms
    /// @{
    BinnedProfilePtr<string> _nHadrons;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(MARKI_1982_I169326);


}
