#include <Python.h>
#include <stdexcept>
#include <ios>
#include "Rivet/Tools/Exceptions.hh"

namespace Rivet {

  PyObject* RivetExc_Error;
  PyObject* RivetExc_RangeError;
  PyObject* RivetExc_LogicError;
  PyObject* RivetExc_PidError;
  PyObject* RivetExc_InfoError;
  PyObject* RivetExc_BeamError;
  PyObject* RivetExc_SmearError;
  PyObject* RivetExc_WeightError;
  PyObject* RivetExc_UserError;
  PyObject* RivetExc_LookupError;
  PyObject* RivetExc_DataError;
  PyObject* RivetExc_IOError;
  PyObject* RivetExc_ReadError;
  PyObject* RivetExc_WriteError;

  void create_custom_exceptions() {
    // Master exception
    RivetExc_Error = PyErr_NewException("rivet.Error", NULL, NULL);

    // Inherited exceptions
    RivetExc_RangeError = PyErr_NewException("rivet.RangeError", RivetExc_Error, NULL);
    RivetExc_LogicError = PyErr_NewException("rivet.LogicError", RivetExc_Error, NULL);
    RivetExc_PidError = PyErr_NewException("rivet.PidError", RivetExc_Error, NULL);
    RivetExc_InfoError = PyErr_NewException("rivet.InfoError", RivetExc_Error, NULL);
    RivetExc_BeamError = PyErr_NewException("rivet.BeamError", RivetExc_Error, NULL);
    RivetExc_SmearError = PyErr_NewException("rivet.SmearError", RivetExc_Error, NULL);
    RivetExc_WeightError = PyErr_NewException("rivet.WeightError", RivetExc_Error, NULL);
    RivetExc_UserError = PyErr_NewException("rivet.UserError", RivetExc_Error, NULL);
    RivetExc_LookupError = PyErr_NewException("rivet.LookupError", RivetExc_Error, NULL);
    RivetExc_DataError = PyErr_NewException("rivet.DataError", RivetExc_Error, NULL);
    RivetExc_IOError = PyErr_NewException("rivet.IOError", RivetExc_Error, NULL);
    RivetExc_ReadError = PyErr_NewException("rivet.ReadError", RivetExc_IOError, NULL);
    RivetExc_WriteError = PyErr_NewException("rivet.WriteError", RivetExc_IOError, NULL);
  }

  void translate_rivet_error() {
    try {
      if (PyErr_Occurred())
        ; // let the latest Python exn pass through and ignore the current one
      else
        throw;
    } catch (const Rivet::RangeError& exn) {
      PyErr_SetString(RivetExc_RangeError, exn.what());
    } catch (const Rivet::LogicError& exn) {
      PyErr_SetString(RivetExc_LogicError, exn.what());
    } catch (const Rivet::PidError& exn) {
      PyErr_SetString(RivetExc_PidError, exn.what());
    } catch (const Rivet::InfoError& exn) {
      PyErr_SetString(RivetExc_InfoError, exn.what());
    } catch (const Rivet::BeamError& exn) {
      PyErr_SetString(RivetExc_BeamError, exn.what());
    } catch (const Rivet::SmearError& exn) {
      PyErr_SetString(RivetExc_SmearError, exn.what());
    } catch (const Rivet::WeightError& exn) {
      PyErr_SetString(RivetExc_WeightError, exn.what());
    } catch (const Rivet::UserError& exn) {
      PyErr_SetString(RivetExc_UserError, exn.what());
    } catch (const Rivet::LookupError& exn) {
      PyErr_SetString(RivetExc_LookupError, exn.what());
    } catch (const Rivet::DataError& exn) {
      PyErr_SetString(RivetExc_DataError, exn.what());
    } catch (const Rivet::ReadError& exn) {
      PyErr_SetString(RivetExc_ReadError, exn.what());
    } catch (const Rivet::WriteError& exn) {
      PyErr_SetString(RivetExc_WriteError, exn.what());
    } catch (const Rivet::IOError& exn) {
      PyErr_SetString(RivetExc_IOError, exn.what());
    } catch (const Rivet::Error& exn) {
      PyErr_SetString(RivetExc_Error, exn.what());
    } catch (...) {
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception");
    }
  }

}
