# Examples: add default fields to Beats indices

These examples show how to add the `index.query.default_field` setting to a [Metricbeat](#metricbeat) or [Filebeat](#filebeat) 6.6 index.

# Metricbeat

This example command adds the `index.query.default_field` setting to a Metricbeat 6.6 index:

```
PUT /metricbeat-6.6.2-2019.04.09/_settings
{
  "index": {
    "query": {
      "default_field": [
        "aerospike.namespace.name",
        "aerospike.namespace.node.host",
        "aerospike.namespace.node.name",
        "apache.status.hostname",
        "beat.hostname",
        "beat.name",
        "beat.timezone",
        "beat.version",
        "ceph.cluster_health.overall_status",
        "ceph.cluster_health.timechecks.round.status",
        "ceph.monitor_health.health",
        "ceph.monitor_health.name",
        "ceph.osd_df.device_class",
        "ceph.osd_df.name",
        "ceph.osd_tree.children",
        "ceph.osd_tree.device_class",
        "ceph.osd_tree.father",
        "ceph.osd_tree.name",
        "ceph.osd_tree.status",
        "ceph.osd_tree.type",
        "ceph.pool_disk.name",
        "couchbase.bucket.name",
        "couchbase.bucket.type",
        "couchbase.node.hostname",
        "docker.container.command",
        "docker.container.id",
        "docker.container.image",
        "docker.container.ip_addresses",
        "docker.container.name",
        "docker.container.status",
        "docker.healthcheck.event.output",
        "docker.healthcheck.status",
        "docker.image.id.current",
        "docker.image.id.parent",
        "docker.info.id",
        "docker.network.interface",
        "elasticsearch.ccr.follower.index",
        "elasticsearch.ccr.leader.index",
        "elasticsearch.cluster.id",
        "elasticsearch.cluster.name",
        "elasticsearch.cluster.pending_task.source",
        "elasticsearch.cluster.state.id",
        "elasticsearch.cluster.stats.status",
        "elasticsearch.index.name",
        "elasticsearch.index.recovery.source.host",
        "elasticsearch.index.recovery.source.id",
        "elasticsearch.index.recovery.source.name",
        "elasticsearch.index.recovery.stage",
        "elasticsearch.index.recovery.target.host",
        "elasticsearch.index.recovery.target.id",
        "elasticsearch.index.recovery.target.name",
        "elasticsearch.index.recovery.type",
        "elasticsearch.ml.job.id",
        "elasticsearch.ml.job.state",
        "elasticsearch.node.id",
        "elasticsearch.node.jvm.version",
        "elasticsearch.node.name",
        "elasticsearch.node.version",
        "elasticsearch.shard.relocating_node.name",
        "elasticsearch.shard.state",
        "error.message",
        "error.type",
        "etcd.leader.leader",
        "etcd.self.id",
        "etcd.self.leaderinfo.leader",
        "etcd.self.leaderinfo.starttime",
        "etcd.self.leaderinfo.uptime",
        "etcd.self.name",
        "etcd.self.starttime",
        "etcd.self.state",
        "event.dataset",
        "golang.expvar.cmdline",
        "golang.heap.cmdline",
        "graphite.server.example",
        "haproxy.stat.check.health.last",
        "haproxy.stat.check.status",
        "haproxy.stat.proxy.name",
        "haproxy.stat.service_name",
        "haproxy.stat.status",
        "host.architecture",
        "host.id",
        "host.ip",
        "host.mac",
        "host.name",
        "host.os.build",
        "host.os.family",
        "host.os.name",
        "host.os.platform",
        "host.os.version",
        "http.request.body",
        "http.request.method",
        "http.response.body",
        "http.response.code",
        "http.response.phrase",
        "kafka.broker.address",
        "kafka.consumergroup.broker.address",
        "kafka.consumergroup.client.host",
        "kafka.consumergroup.client.id",
        "kafka.consumergroup.client.member_id",
        "kafka.consumergroup.id",
        "kafka.consumergroup.meta",
        "kafka.consumergroup.topic",
        "kafka.partition.broker.address",
        "kafka.partition.topic.name",
        "kafka.partition.topic_broker_id",
        "kafka.partition.topic_id",
        "kafka.topic.name",
        "kibana.stats.host.name",
        "kibana.stats.index",
        "kibana.stats.name",
        "kibana.stats.status",
        "kibana.stats.transport_address",
        "kibana.stats.uuid",
        "kibana.stats.version",
        "kibana.status.name",
        "kibana.status.status.overall.state",
        "kibana.status.uuid",
        "kibana.status.version.number",
        "kubernetes.apiserver.request.client",
        "kubernetes.apiserver.request.resource",
        "kubernetes.apiserver.request.scope",
        "kubernetes.apiserver.request.subresource",
        "kubernetes.apiserver.request.verb",
        "kubernetes.container.id",
        "kubernetes.container.image",
        "kubernetes.container.name",
        "kubernetes.container.status.phase",
        "kubernetes.container.status.reason",
        "kubernetes.deployment.name",
        "kubernetes.event.involved_object.api_version",
        "kubernetes.event.involved_object.kind",
        "kubernetes.event.involved_object.name",
        "kubernetes.event.involved_object.resource_version",
        "kubernetes.event.involved_object.uid",
        "kubernetes.event.message",
        "kubernetes.event.metadata.name",
        "kubernetes.event.metadata.namespace",
        "kubernetes.event.metadata.resource_version",
        "kubernetes.event.metadata.self_link",
        "kubernetes.event.metadata.uid",
        "kubernetes.event.reason",
        "kubernetes.event.type",
        "kubernetes.namespace",
        "kubernetes.node.name",
        "kubernetes.node.status.ready",
        "kubernetes.pod.host_ip",
        "kubernetes.pod.ip",
        "kubernetes.pod.name",
        "kubernetes.pod.status.phase",
        "kubernetes.pod.status.ready",
        "kubernetes.pod.status.scheduled",
        "kubernetes.pod.uid",
        "kubernetes.replicaset.name",
        "kubernetes.statefulset.name",
        "kubernetes.system.container",
        "kubernetes.volume.name",
        "kvm.dommemstat.name",
        "kvm.dommemstat.stat.name",
        "logstash.node.host",
        "logstash.node.jvm.version",
        "logstash.node.version",
        "meta.cloud.availability_zone",
        "meta.cloud.instance_id",
        "meta.cloud.instance_name",
        "meta.cloud.machine_type",
        "meta.cloud.project_id",
        "meta.cloud.provider",
        "meta.cloud.region",
        "metricset.host",
        "metricset.module",
        "metricset.name",
        "metricset.namespace",
        "mongodb.collstats.collection",
        "mongodb.collstats.db",
        "mongodb.collstats.name",
        "mongodb.dbstats.db",
        "mongodb.metrics.replication.executor.network_interface",
        "mongodb.replstatus.members.primary.host",
        "mongodb.replstatus.members.primary.optime",
        "mongodb.replstatus.members.secondary.optimes",
        "mongodb.replstatus.set_name",
        "mongodb.status.process",
        "mongodb.status.storage_engine.name",
        "mongodb.status.version",
        "mysql.galera_status.cluster.status",
        "mysql.galera_status.connected",
        "mysql.galera_status.evs.evict",
        "mysql.galera_status.evs.state",
        "mysql.galera_status.local.state",
        "mysql.galera_status.ready",
        "nginx.stubstatus.hostname",
        "php_fpm.pool.name",
        "php_fpm.pool.process_manager",
        "php_fpm.process.request_method",
        "php_fpm.process.request_uri",
        "php_fpm.process.script",
        "php_fpm.process.state",
        "php_fpm.process.user",
        "postgresql.activity.application_name",
        "postgresql.activity.client.address",
        "postgresql.activity.client.hostname",
        "postgresql.activity.database.name",
        "postgresql.activity.query",
        "postgresql.activity.state",
        "postgresql.activity.user.name",
        "postgresql.database.name",
        "postgresql.statement.query.text",
        "rabbitmq.connection.host",
        "rabbitmq.connection.name",
        "rabbitmq.connection.node",
        "rabbitmq.connection.peer.host",
        "rabbitmq.connection.type",
        "rabbitmq.connection.user",
        "rabbitmq.connection.vhost",
        "rabbitmq.exchange.name",
        "rabbitmq.exchange.user",
        "rabbitmq.exchange.vhost",
        "rabbitmq.node.name",
        "rabbitmq.node.type",
        "rabbitmq.queue.name",
        "rabbitmq.queue.node",
        "rabbitmq.queue.state",
        "rabbitmq.queue.vhost",
        "redis.info.memory.allocator",
        "redis.info.memory.max.policy",
        "redis.info.persistence.aof.bgrewrite.last_status",
        "redis.info.persistence.aof.write.last_status",
        "redis.info.persistence.rdb.bgsave.last_status",
        "redis.info.replication.master.link_status",
        "redis.info.replication.role",
        "redis.info.server.arch_bits",
        "redis.info.server.build_id",
        "redis.info.server.config_file",
        "redis.info.server.gcc_version",
        "redis.info.server.git_dirty",
        "redis.info.server.git_sha1",
        "redis.info.server.mode",
        "redis.info.server.multiplexing_api",
        "redis.info.server.os",
        "redis.info.server.run_id",
        "redis.info.server.version",
        "redis.keyspace.id",
        "service.name",
        "system.diskio.name",
        "system.diskio.serial_number",
        "system.filesystem.device_name",
        "system.filesystem.mount_point",
        "system.filesystem.type",
        "system.network.name",
        "system.process.cgroup.blkio.id",
        "system.process.cgroup.blkio.path",
        "system.process.cgroup.cpu.id",
        "system.process.cgroup.cpu.path",
        "system.process.cgroup.cpuacct.id",
        "system.process.cgroup.cpuacct.path",
        "system.process.cgroup.id",
        "system.process.cgroup.memory.id",
        "system.process.cgroup.memory.path",
        "system.process.cgroup.path",
        "system.process.cmdline",
        "system.process.cwd",
        "system.process.name",
        "system.process.state",
        "system.process.username",
        "system.raid.activity_state",
        "system.raid.name",
        "system.socket.direction",
        "system.socket.family",
        "system.socket.local.ip",
        "system.socket.process.cmdline",
        "system.socket.process.command",
        "system.socket.process.exe",
        "system.socket.remote.etld_plus_one",
        "system.socket.remote.host",
        "system.socket.remote.host_error",
        "system.socket.remote.ip",
        "system.socket.user.name",
        "tags",
        "type",
        "uwsgi.status.worker.rss",
        "uwsgi.status.worker.status",
        "vsphere.datastore.fstype",
        "vsphere.datastore.name",
        "vsphere.host.name",
        "vsphere.host.network_names",
        "vsphere.virtualmachine.host",
        "vsphere.virtualmachine.name",
        "vsphere.virtualmachine.network_names",
        "windows.service.display_name",
        "windows.service.exit_code",
        "windows.service.id",
        "windows.service.name",
        "windows.service.start_type",
        "windows.service.state",
        "zookeeper.mntr.hostname",
        "zookeeper.mntr.server_state",
        "zookeeper.mntr.version",
        "fields.*"
      ]
    }
  }
}
```

# Filebeat

This example command adds the `index.query.default_field` setting to a Filebeat 6.6 index:

```
PUT /filebeat-6.6.2-2019.04.09/_settings
{
  "index": {
    "query": {
      "default_field": [
        "apache2.access.agent",
        "apache2.access.geoip.city_name",
        "apache2.access.geoip.continent_name",
        "apache2.access.geoip.country_iso_code",
        "apache2.access.geoip.region_iso_code",
        "apache2.access.geoip.region_name",
        "apache2.access.http_version",
        "apache2.access.method",
        "apache2.access.referrer",
        "apache2.access.remote_ip",
        "apache2.access.url",
        "apache2.access.user_agent.device",
        "apache2.access.user_agent.name",
        "apache2.access.user_agent.original",
        "apache2.access.user_agent.os",
        "apache2.access.user_agent.os_name",
        "apache2.access.user_agent.patch",
        "apache2.access.user_name",
        "apache2.error.client",
        "apache2.error.level",
        "apache2.error.message",
        "apache2.error.module",
        "auditd.log.a0",
        "auditd.log.acct",
        "auditd.log.geoip.city_name",
        "auditd.log.geoip.continent_name",
        "auditd.log.geoip.country_iso_code",
        "auditd.log.geoip.region_iso_code",
        "auditd.log.geoip.region_name",
        "auditd.log.item",
        "auditd.log.items",
        "auditd.log.new_auid",
        "auditd.log.new_ses",
        "auditd.log.old_auid",
        "auditd.log.old_ses",
        "auditd.log.pid",
        "auditd.log.ppid",
        "auditd.log.record_type",
        "auditd.log.res",
        "beat.hostname",
        "beat.name",
        "beat.timezone",
        "beat.version",
        "destination.geo.city_name",
        "destination.geo.continent_name",
        "destination.geo.country_iso_code",
        "destination.geo.region_iso_code",
        "destination.geo.region_name",
        "destination.ip",
        "docker.container.id",
        "docker.container.image",
        "docker.container.name",
        "elasticsearch.audit.action",
        "elasticsearch.audit.event_type",
        "elasticsearch.audit.layer",
        "elasticsearch.audit.origin_address",
        "elasticsearch.audit.origin_type",
        "elasticsearch.audit.principal",
        "elasticsearch.audit.realm",
        "elasticsearch.audit.request",
        "elasticsearch.audit.request_body",
        "elasticsearch.audit.uri",
        "elasticsearch.gc.phase.name",
        "elasticsearch.gc.tags",
        "elasticsearch.index.id",
        "elasticsearch.index.name",
        "elasticsearch.node.name",
        "elasticsearch.server.component",
        "elasticsearch.shard.id",
        "elasticsearch.slowlog.extra_source",
        "elasticsearch.slowlog.id",
        "elasticsearch.slowlog.logger",
        "elasticsearch.slowlog.routing",
        "elasticsearch.slowlog.search_type",
        "elasticsearch.slowlog.source_query",
        "elasticsearch.slowlog.stats",
        "elasticsearch.slowlog.took",
        "elasticsearch.slowlog.took_millis",
        "elasticsearch.slowlog.total_hits",
        "elasticsearch.slowlog.total_shards",
        "elasticsearch.slowlog.type",
        "elasticsearch.slowlog.types",
        "error.message",
        "error.type",
        "event.dataset",
        "event.type",
        "file.path",
        "fileset.module",
        "fileset.name",
        "haproxy.backend_name",
        "haproxy.bind_name",
        "haproxy.client.ip",
        "haproxy.destination.ip",
        "haproxy.error_message",
        "haproxy.frontend_name",
        "haproxy.geoip.city_name",
        "haproxy.geoip.continent_name",
        "haproxy.geoip.country_iso_code",
        "haproxy.geoip.region_iso_code",
        "haproxy.geoip.region_name",
        "haproxy.http.request.captured_cookie",
        "haproxy.http.request.captured_headers",
        "haproxy.http.request.raw_request_line",
        "haproxy.http.response.captured_cookie",
        "haproxy.http.response.captured_headers",
        "haproxy.mode",
        "haproxy.process_name",
        "haproxy.server_name",
        "haproxy.source",
        "haproxy.termination_state",
        "host.architecture",
        "host.id",
        "host.ip",
        "host.mac",
        "host.name",
        "host.os.build",
        "host.os.family",
        "host.os.name",
        "host.os.platform",
        "host.os.version",
        "http.request.method",
        "icinga.debug.facility",
        "icinga.debug.message",
        "icinga.debug.severity",
        "icinga.main.facility",
        "icinga.main.message",
        "icinga.main.severity",
        "icinga.startup.facility",
        "icinga.startup.message",
        "icinga.startup.severity",
        "iis.access.agent",
        "iis.access.cookie",
        "iis.access.geoip.city_name",
        "iis.access.geoip.continent_name",
        "iis.access.geoip.country_iso_code",
        "iis.access.geoip.region_iso_code",
        "iis.access.geoip.region_name",
        "iis.access.hostname",
        "iis.access.http_version",
        "iis.access.method",
        "iis.access.query_string",
        "iis.access.referrer",
        "iis.access.remote_ip",
        "iis.access.server_ip",
        "iis.access.server_name",
        "iis.access.site_name",
        "iis.access.url",
        "iis.access.user_agent.device",
        "iis.access.user_agent.name",
        "iis.access.user_agent.original",
        "iis.access.user_agent.os",
        "iis.access.user_agent.os_name",
        "iis.access.user_agent.patch",
        "iis.access.user_name",
        "iis.error.geoip.city_name",
        "iis.error.geoip.continent_name",
        "iis.error.geoip.country_iso_code",
        "iis.error.geoip.region_iso_code",
        "iis.error.geoip.region_name",
        "iis.error.http_version",
        "iis.error.method",
        "iis.error.queue_name",
        "iis.error.reason_phrase",
        "iis.error.remote_ip",
        "iis.error.server_ip",
        "iis.error.url",
        "input.type",
        "kafka.log.class",
        "kafka.log.component",
        "kafka.log.level",
        "kafka.log.message",
        "kafka.log.timestamp",
        "kafka.log.trace.class",
        "kafka.log.trace.full",
        "kafka.log.trace.message",
        "kibana.log.state",
        "kibana.log.tags",
        "kubernetes.container.image",
        "kubernetes.container.name",
        "kubernetes.namespace",
        "kubernetes.node.name",
        "kubernetes.pod.name",
        "kubernetes.pod.uid",
        "log.file.path",
        "log.flags",
        "log.level",
        "log.source.address",
        "logstash.log.level",
        "logstash.log.message",
        "logstash.log.module",
        "logstash.log.thread",
        "logstash.slowlog.event",
        "logstash.slowlog.level",
        "logstash.slowlog.message",
        "logstash.slowlog.module",
        "logstash.slowlog.plugin_name",
        "logstash.slowlog.plugin_params",
        "logstash.slowlog.plugin_type",
        "logstash.slowlog.thread",
        "message",
        "meta.cloud.availability_zone",
        "meta.cloud.instance_id",
        "meta.cloud.instance_name",
        "meta.cloud.machine_type",
        "meta.cloud.project_id",
        "meta.cloud.provider",
        "meta.cloud.region",
        "mongodb.log.component",
        "mongodb.log.context",
        "mongodb.log.message",
        "mongodb.log.severity",
        "mysql.error.level",
        "mysql.error.message",
        "mysql.error.timestamp",
        "mysql.slowlog.host",
        "mysql.slowlog.ip",
        "mysql.slowlog.query",
        "mysql.slowlog.user",
        "netflow.application_category_name",
        "netflow.application_description",
        "netflow.application_group_name",
        "netflow.application_name",
        "netflow.application_sub_category_name",
        "netflow.bgp_next_hop_ipv4_address",
        "netflow.bgp_next_hop_ipv6_address",
        "netflow.class_name",
        "netflow.collector_ipv4_address",
        "netflow.collector_ipv6_address",
        "netflow.destination_ipv4_address",
        "netflow.destination_ipv4_prefix",
        "netflow.destination_ipv6_address",
        "netflow.destination_ipv6_prefix",
        "netflow.destination_mac_address",
        "netflow.dot1q_customer_destination_mac_address",
        "netflow.dot1q_customer_source_mac_address",
        "netflow.encrypted_technology",
        "netflow.exporter.address",
        "netflow.exporter_ipv4_address",
        "netflow.exporter_ipv6_address",
        "netflow.http_content_type",
        "netflow.http_message_version",
        "netflow.http_reason_phrase",
        "netflow.http_request_host",
        "netflow.http_request_method",
        "netflow.http_request_target",
        "netflow.http_user_agent",
        "netflow.information_element_description",
        "netflow.information_element_name",
        "netflow.interface_description",
        "netflow.interface_name",
        "netflow.ip_next_hop_ipv4_address",
        "netflow.ip_next_hop_ipv6_address",
        "netflow.ipv4_router_sc",
        "netflow.metro_evc_id",
        "netflow.mib_context_name",
        "netflow.mib_module_name",
        "netflow.mib_object_description",
        "netflow.mib_object_name",
        "netflow.mib_object_syntax",
        "netflow.mib_object_valuei_pa_ddress",
        "netflow.mobile_imsi",
        "netflow.mobile_msisdn",
        "netflow.mpls_top_label_ipv4_address",
        "netflow.mpls_top_label_ipv6_address",
        "netflow.nat_pool_name",
        "netflow.observation_domain_name",
        "netflow.original_exporter_ipv4_address",
        "netflow.original_exporter_ipv6_address",
        "netflow.p2p_technology",
        "netflow.post_destination_mac_address",
        "netflow.post_nadt_estination_ipv4_address",
        "netflow.post_nadt_estination_ipv6_address",
        "netflow.post_nast_ource_ipv4_address",
        "netflow.post_nast_ource_ipv6_address",
        "netflow.post_source_mac_address",
        "netflow.pseudo_wire_destination_ipv4_address",
        "netflow.sampler_name",
        "netflow.selector_name",
        "netflow.source_ipv4_address",
        "netflow.source_ipv4_prefix",
        "netflow.source_ipv6_address",
        "netflow.source_ipv6_prefix",
        "netflow.source_mac_address",
        "netflow.sta_ipv4_address",
        "netflow.sta_mac_address",
        "netflow.tunnel_technology",
        "netflow.type",
        "netflow.user_name",
        "netflow.virtual_station_interface_name",
        "netflow.virtual_station_name",
        "netflow.vr_fname",
        "netflow.wlan_ssid",
        "netflow.wtp_mac_address",
        "nginx.access.agent",
        "nginx.access.geoip.city_name",
        "nginx.access.geoip.continent_name",
        "nginx.access.geoip.country_iso_code",
        "nginx.access.geoip.region_iso_code",
        "nginx.access.geoip.region_name",
        "nginx.access.http_version",
        "nginx.access.method",
        "nginx.access.referrer",
        "nginx.access.remote_ip",
        "nginx.access.url",
        "nginx.access.user_agent.device",
        "nginx.access.user_agent.name",
        "nginx.access.user_agent.original",
        "nginx.access.user_agent.os",
        "nginx.access.user_agent.os_name",
        "nginx.access.user_agent.patch",
        "nginx.access.user_name",
        "nginx.error.level",
        "nginx.error.message",
        "osquery.result.action",
        "osquery.result.calendar_time",
        "osquery.result.host_identifier",
        "osquery.result.name",
        "postgresql.log.database",
        "postgresql.log.level",
        "postgresql.log.message",
        "postgresql.log.query",
        "postgresql.log.timestamp",
        "postgresql.log.timezone",
        "postgresql.log.user",
        "process.program",
        "prospector.type",
        "read_timestamp",
        "redis.log.level",
        "redis.log.message",
        "redis.log.role",
        "redis.slowlog.args",
        "redis.slowlog.cmd",
        "redis.slowlog.key",
        "service.name",
        "source",
        "source_ecs.geo.city_name",
        "source_ecs.geo.continent_name",
        "source_ecs.geo.country_iso_code",
        "source_ecs.geo.region_iso_code",
        "source_ecs.geo.region_name",
        "source_ecs.ip",
        "stream",
        "suricata.eve.alert.action",
        "suricata.eve.alert.category",
        "suricata.eve.alert.signature",
        "suricata.eve.app_proto",
        "suricata.eve.app_proto_expected",
        "suricata.eve.app_proto_orig",
        "suricata.eve.app_proto_tc",
        "suricata.eve.app_proto_ts",
        "suricata.eve.dest_ip",
        "suricata.eve.dns.rcode",
        "suricata.eve.dns.rdata",
        "suricata.eve.dns.rrname",
        "suricata.eve.dns.rrtype",
        "suricata.eve.dns.type",
        "suricata.eve.email.status",
        "suricata.eve.event_type",
        "suricata.eve.fileinfo.filename",
        "suricata.eve.fileinfo.md5",
        "suricata.eve.fileinfo.sha1",
        "suricata.eve.fileinfo.sha256",
        "suricata.eve.fileinfo.state",
        "suricata.eve.flow.reason",
        "suricata.eve.flow.state",
        "suricata.eve.flow_id",
        "suricata.eve.http.hostname",
        "suricata.eve.http.http_content_type",
        "suricata.eve.http.http_method",
        "suricata.eve.http.http_refer",
        "suricata.eve.http.http_user_agent",
        "suricata.eve.http.protocol",
        "suricata.eve.http.redirect",
        "suricata.eve.http.url",
        "suricata.eve.in_iface",
        "suricata.eve.proto",
        "suricata.eve.smtp.helo",
        "suricata.eve.smtp.mail_from",
        "suricata.eve.smtp.rcpt_to",
        "suricata.eve.src_ip",
        "suricata.eve.ssh.client.proto_version",
        "suricata.eve.ssh.client.software_version",
        "suricata.eve.ssh.server.proto_version",
        "suricata.eve.ssh.server.software_version",
        "suricata.eve.tcp.state",
        "suricata.eve.tcp.tcp_flags",
        "suricata.eve.tcp.tcp_flags_tc",
        "suricata.eve.tcp.tcp_flags_ts",
        "suricata.eve.tls.fingerprint",
        "suricata.eve.tls.issuerdn",
        "suricata.eve.tls.serial",
        "suricata.eve.tls.sni",
        "suricata.eve.tls.subject",
        "suricata.eve.tls.version",
        "syslog.facility_label",
        "syslog.severity_label",
        "system.auth.groupadd.name",
        "system.auth.hostname",
        "system.auth.message",
        "system.auth.program",
        "system.auth.ssh.dropped_ip",
        "system.auth.ssh.event",
        "system.auth.ssh.geoip.city_name",
        "system.auth.ssh.geoip.continent_name",
        "system.auth.ssh.geoip.country_iso_code",
        "system.auth.ssh.geoip.region_iso_code",
        "system.auth.ssh.geoip.region_name",
        "system.auth.ssh.ip",
        "system.auth.ssh.method",
        "system.auth.ssh.signature",
        "system.auth.sudo.command",
        "system.auth.sudo.error",
        "system.auth.sudo.pwd",
        "system.auth.sudo.tty",
        "system.auth.sudo.user",
        "system.auth.timestamp",
        "system.auth.user",
        "system.auth.useradd.home",
        "system.auth.useradd.name",
        "system.auth.useradd.shell",
        "system.syslog.hostname",
        "system.syslog.message",
        "system.syslog.pid",
        "system.syslog.program",
        "system.syslog.timestamp",
        "tags",
        "traefik.access.agent",
        "traefik.access.backend_url",
        "traefik.access.frontend_name",
        "traefik.access.geoip.city_name",
        "traefik.access.geoip.continent_name",
        "traefik.access.geoip.country_iso_code",
        "traefik.access.geoip.region_iso_code",
        "traefik.access.geoip.region_name",
        "traefik.access.http_version",
        "traefik.access.method",
        "traefik.access.referrer",
        "traefik.access.remote_ip",
        "traefik.access.url",
        "traefik.access.user_agent.build",
        "traefik.access.user_agent.device",
        "traefik.access.user_agent.name",
        "traefik.access.user_agent.original",
        "traefik.access.user_agent.os",
        "traefik.access.user_agent.os_name",
        "traefik.access.user_agent.patch",
        "traefik.access.user_identifier",
        "traefik.access.user_name",
        "url.hostname",
        "user_agent.device",
        "user_agent.name",
        "user_agent.original",
        "user_agent.os.full_name",
        "user_agent.os.name",
        "user_agent.os.version",
        "user_agent.patch",
        "user_agent.version",
        "fields.*"
      ]
    }
  }
}
```