#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Transform::Proj4;

our @EXPORT_OK = qw( t_proj t_proj_adams_hemi t_proj_adams_ws1 t_proj_adams_ws2 t_proj_aea t_proj_aeqd t_proj_affine t_proj_airy t_proj_aitoff t_proj_alsk t_proj_apian t_proj_august t_proj_axisswap t_proj_bacon t_proj_bertin1953 t_proj_bipc t_proj_boggs t_proj_bonne t_proj_calcofi t_proj_cart t_proj_cass t_proj_cc t_proj_ccon t_proj_cea t_proj_chamb t_proj_col_urban t_proj_collg t_proj_comill t_proj_crast t_proj_defmodel t_proj_deformation t_proj_denoy t_proj_eck1 t_proj_eck2 t_proj_eck3 t_proj_eck4 t_proj_eck5 t_proj_eck6 t_proj_eqc t_proj_eqdc t_proj_eqearth t_proj_etmerc t_proj_euler t_proj_fahey t_proj_fouc t_proj_fouc_s t_proj_gall t_proj_geoc t_proj_geogoffset t_proj_geos t_proj_gins8 t_proj_gn_sinu t_proj_gnom t_proj_goode t_proj_gridshift t_proj_gs48 t_proj_gs50 t_proj_gstmerc t_proj_guyou t_proj_hammer t_proj_hatano t_proj_healpix t_proj_helmert t_proj_hgridshift t_proj_horner t_proj_igh t_proj_igh_o t_proj_imoll t_proj_imoll_o t_proj_imw_p t_proj_isea t_proj_kav5 t_proj_kav7 t_proj_krovak t_proj_labrd t_proj_laea t_proj_lagrng t_proj_larr t_proj_lask t_proj_latlon t_proj_lcc t_proj_lcca t_proj_leac t_proj_lee_os t_proj_lonlat t_proj_loxim t_proj_lsat t_proj_mbt_fps t_proj_mbt_s t_proj_mbtfpp t_proj_mbtfpq t_proj_mbtfps t_proj_merc t_proj_mil_os t_proj_mill t_proj_misrsom t_proj_mod_krovak t_proj_moll t_proj_molobadekas t_proj_molodensky t_proj_murd1 t_proj_murd2 t_proj_murd3 t_proj_natearth t_proj_natearth2 t_proj_nell t_proj_nell_h t_proj_nicol t_proj_noop t_proj_nsper t_proj_nzmg t_proj_ob_tran t_proj_ocea t_proj_oea t_proj_omerc t_proj_ortel t_proj_ortho t_proj_patterson t_proj_pconic t_proj_peirce_q t_proj_pipeline t_proj_poly t_proj_pop t_proj_push t_proj_putp1 t_proj_putp2 t_proj_putp3 t_proj_putp3p t_proj_putp4p t_proj_putp5 t_proj_putp5p t_proj_putp6 t_proj_putp6p t_proj_qsc t_proj_qua_aut t_proj_rhealpix t_proj_robin t_proj_rouss t_proj_rpoly t_proj_s2 t_proj_sch t_proj_set t_proj_sinu t_proj_som t_proj_somerc t_proj_stere t_proj_sterea t_proj_tcc t_proj_tcea t_proj_times t_proj_tinshift t_proj_tissot t_proj_tmerc t_proj_tobmerc t_proj_topocentric t_proj_tpeqd t_proj_tpers t_proj_unitconvert t_proj_ups t_proj_urm5 t_proj_urmfps t_proj_utm t_proj_vandg t_proj_vandg2 t_proj_vandg3 t_proj_vandg4 t_proj_vertoffset t_proj_vgridshift t_proj_vitk1 t_proj_wag1 t_proj_wag2 t_proj_wag3 t_proj_wag4 t_proj_wag5 t_proj_wag6 t_proj_wag7 t_proj_webmerc t_proj_weren t_proj_wink1 t_proj_wink2 t_proj_wintri t_proj_xyzgridshift );
our %EXPORT_TAGS = (Func=>\@EXPORT_OK);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;


   
   our @ISA = ( 'PDL::Exporter','DynaLoader','PDL::Transform' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Transform::Proj4 ;



BEGIN {
use PDL::LiteF;
use PDL::NiceSlice;
use PDL::Transform;
use Alien::proj;
if ($^O =~ /MSWin32/ and $Alien::proj::VERSION le '1.25') {
  $ENV{PATH} = join ';', (Alien::proj->bin_dirs, $ENV{PATH});
}


}



#line 210 "proj4.pd"

# PDL::Transform::Proj4
#
# Judd Taylor, USF IMaRS
# 4 Apr 2006

=head1 NAME

PDL::Transform::Proj4 - PDL::Transform interface to the Proj4 projection library

=head1 SYNOPSIS

 # Using the generalized proj interface:
 # Make an orthographic map of Earth
 use PDL::Transform::Cartography;
 use PDL::Transform::Proj4;
 use PDL::Graphics::Simple;
 $x = earth_coast();
 $x = graticule(10,2)->glue(1,$x);
 $t = t_proj( proj_params => "+proj=ortho +ellps=WGS84 +lon_0=-90 +lat_0=40" );
 $w = pgswin();
 $w->plot(with=>'polylines', $t->apply($x)->clean_lines);

 # Using the aliased functions:
 # Make an orthographic map of Earth
 use PDL::Transform::Cartography;
 use PDL::Transform::Proj4;
 use PDL::Graphics::Simple;
 $x = earth_coast();
 $x = graticule(10,2)->glue(1,$x);
 $t = t_proj_ortho( ellps => 'WGS84', lon_0 => -90, lat_0 => 40 )
 $w = pgswin();
 $w->plot(with=>'polylines', $t->apply($x)->clean_lines);

=head1 DESCRIPTION

Works like PDL::Transform::Cartography, but using the proj library in the background.

Please see the proj library docs at L<http://www.remotesensing.org/proj> for more information
on proj, and how to use the library.

=head1 GENERALIZED INTERFACE

The main object here is the PDL::Transform::Proj4 object, aliased to the t_proj() function.

This object accepts all of the standard options described below, but mainly is there to be called
with just the B<proj_params> option defined.

When options are used, they must be used with a '+' before them when placed in the proj_params string,
but that is not required otherwise. See the SYNOPSIS above.

=head2 ALIASED INTERFACE

Other than t_proj(), all of the other transforms below have been autogenerated, and may not work
properly. The main problem is determining the parameters a projection requires from the proj
library itself.

Due to the difficulties in doing this, there may be times when the proj docs specify a parameter
for a projection that won't work using the anon-hash type specification. In that case, just throw
that parameter in the proj_params string, and everything should work fine.

=head1 PARAMETERS AVAILABLE IN ALL PROJECTIONS

=head2 General Parameters

=head3 proj_params

This is a string containing the proj "plus style" parameters. This would be similar to what you
would put on the command line for the 'proj' tool. Like "+proj=ortho +ellps=WGS84 +lon_0=-90 +lat_0=40".

This parameter overrides the others below when it contains parameters that are also specified
explicitly.

=head3 proj

The proj projection code to use (like ortho...)

=head3 x_0

Cartesian X offset for the output of the transformation

=head3 y_0

Cartesian Y offset for the output of the transformation

=head3 lat_0

Central latitude for the projection.
NOTE: This may mean other things depending on the projection selected, read the proj docs!

=head3 lon_0

Central longitude for the projection.
NOTE: This may mean other things depending on the projection selected, read the proj docs!

=head3 units

Cartesian units used for the output of the projection.
NOTE: Like most of the options here, this is likely useless in the current implementation
of this library.

=head3 init

Specify a file:unit for proj to use for its runtime defaults. See the proj docs.

=head3 no_defs

Don't load any defaults. See the proj docs.

=head3 over

Normally, the transformation limits the output to between -180 and 180 degrees (or the
cartesian equivalent), but with this option that behavior is turned off.

=head3 geoc

Input values are geocentric coordinates.

=head2 Earth Figure Parameters

=head3 ellps

Ellipsoid datum to use. Ex: WGS72, WGS74.
See the proj docs and command line tool for list of possibilities ('proj -le').

=head3 R

Radius of the Earth.

=head3 R_A

Radius of a sphere with equivalent surface area of specified ellipse.

=head3 R_V

Radius of a sphere with equivalent volume of specified ellipse.

=head3 R_a

Arithmetic mean of the major and minor axis, Ra = (a + b)/2.

=head3 R_g

Geometric mean of the major and minor axis, Rg = (ab)1/2.

=head3 R_h

Harmonic mean of the major and minor axis, Rh = 2ab/(a + b).

=head3 R_lat_a=phi

Arithmetic mean of the principle radii at latitude phi.

=head3 R_lat_g=phi

Geometric mean of the principle radii at latitude phi.

=head3 b

Semiminor axis or polar radius

=head3 f

Flattening

=head3 rf

Reciprocal flattening, +rf=1/f

=head3 e

Eccentricity +e=e

=head3 es

Eccentricity squared +es=e2

=cut

sub new
{
    my $proto = shift;
    my $sub = "PDL::Transform::Proj4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $class = ref($proto) || $proto;
    my $self  = $class->SUPER::new( @_ );

    bless ($self, $class);

    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }

    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();

    $self->{name} = "Proj4";

    # Grab our options:

    # Used in the general sense:
    $self->{params}->{proj_params} = PDL::Transform::_opt( $o, ['proj_params','params'] );

    # Projection options available to all projections:
    $self->{general_params} = [ qw( proj x_0 y_0 lat_0 lon_0 units init ) ];
    foreach my $param ( @{ $self->{general_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }

    # Options that have no value (like "+over"):
    $self->{bool_params} = [ qw( no_defs over geoc ) ];
    foreach my $param ( @{ $self->{bool_params} } )
        { $self->{params}->{$param} = ( PDL::Transform::_opt( $o, [ $param ] ) ) ? 'ON' : undef; }

    # Options for the Earth figure: (ellipsoid, etc):
    $self->{earth_params} = [ qw( ellps R R_A R_V R_a R_g R_h R_lat_a R_lat_g b f rf e es ) ];
    foreach my $param ( @{ $self->{earth_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }

    # First process the old params that may already be in the string:
    # These override the specific params set above:
    if( defined( $self->{params}->{proj_params} ) )
    {
        $self->{orig_proj_params} = $self->{params}->{proj_params};

        my @params = split( /\s+/, $self->{orig_proj_params} );
        foreach my $param ( @params )
        {
            if( $param =~ /^\+(\S+)=(\S+)/ )
            {
                my ($name, $val) = ($1, $2);
                $self->{params}->{$name} = $val;
                #print STDERR "$sub: $name => $val\n";
            }
            elsif( $param =~ /^\+(\S+)/ )
            {   # Boolean option
                $self->{params}->{$1} = 'ON';
            }
        }
    }

    # Update the proj_string to current options:
    #
    $self->update_proj_string();

    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();

    ##############################
    # The meat -- just copy and paste from Transform.pm :)
    #    (and do some proj stuff here as well)

    # Forward transformation:
    $self->{func} = sub
    {
        my $in = shift;
        my $opt = shift;
        my $out = $in->new_or_inplace();
        # Always set the badflag to 1 here, to handle possible bad projection values:
        $out->badflag(1);
        $out->inplace(1);
        PDL::Transform::Proj4::fwd_transform( $out, $opt->{proj_params} );
    };

    # Inverse transformation:
    $self->{inv} = sub
    {
        my $in = shift;
        my $opt = shift;
        my $out = $in->new_or_inplace();
        # Always set the badflag to 1 here, to handle possible bad projection values:
        $out->badflag(1);
        $out->inplace(1);
        PDL::Transform::Proj4::inv_transform( $out, $opt->{proj_params} );
    };

    return $self;
} # End of new()...

sub update_proj_string
{
    my $self = shift;
    my $sub = "PDL::Transform::Proj4::update_proj_string()";

    # (Re)Generate the proj_params string from the options passed:
    #
    delete( $self->{params}->{proj_params} );
    my $proj_string = "";

    foreach my $param ( sort keys %{ $self->{params} } )
#line 503 "proj4.pd"
    {
        next unless defined( $self->{params}->{$param} );

        $proj_string .= ( $self->{params}->{$param} eq 'ON' )
                        ? "+$param " : " +$param=" . $self->{params}->{$param} . " ";
        #print STDERR "$sub: Adding \'$proj_string\'...\n";
    }

    #print STDERR "$sub: Final proj_params: \'$proj_string\'\n";

    $self->{params}->{proj_params} = $proj_string;
} # End of update_proj_string()...

sub proj_params
{
    my $self = shift;
    $self->update_proj_string();
    return $self->{params}->{proj_params};
} # End of proj_params()...

# Returns a string with information about what parameters proj will
# actually use, this includes defaults, and +init=file stuff. It's
# the same as running 'proj -v'. It uses the proj command line, so
# it might not work with all shells. I've tested it with bash.
sub get_proj_info
{
    my $params = shift;
    my @a = split(/\n/, `echo | proj -v $params`);
    pop(@a);
    return join("\n", @a);
}

sub t_proj
{
    PDL::Transform::Proj4->new( @_ );
} # End of t_proj()...

1;
#line 368 "Proj4.pm"


=head1 FUNCTIONS

=cut






=head2 fwd_transform

=for sig

  Signature: (lonlat(n=2); [o] xy(n); char* params)

=for ref

PROJ forward transformation $params is a string of the projection
transformation parameters.

Returns a pdl with x, y values at positions 0, 1. The units are dependent
on PROJ behavior. They will be PDL->null if an error has occurred.

=for bad

Ignores bad elements of $lat and $lon, and sets the corresponding elements
of $x and $y to BAD

=for bad

fwd_transform processes bad values.
It will set the bad-value flag of all output ndarrays if the flag is set for any of the input ndarrays.

=cut




*fwd_transform = \&PDL::fwd_transform;






=head2 inv_transform

=for sig

  Signature: (xy(n=2); [o] lonlat(n); char* params)

=for ref

PROJ inverse transformation $params is a string of the projection
transformation parameters.

Returns a pdl with lon, lat values at positions 0, 1. The units are
dependent on PROJ behavior. They will be PDL->null if an error has
occurred.

=for bad

Ignores bad elements of $lat and $lon, and sets the corresponding elements
of $x and $y to BAD

=for bad

inv_transform processes bad values.
It will set the bad-value flag of all output ndarrays if the flag is set for any of the input ndarrays.

=cut




*inv_transform = \&PDL::inv_transform;





#line 192 "proj4.pd"

=head2 proj_version

Returns a 3-element list with PROJ major, minor, patch version-numbers.
Not exported.

=cut

#line 201 "proj4.pd"
sub load_projection_information {+{
  'adams_hemi' => {
    'CATEGORIES' => [
      'Misc',
      'Sph',
      'No',
      'inv'
    ],
    'CODE' => 'adams_hemi',
    'INVERSE' => 1,
    'NAME' => 'Adams Hemisphere in a Square',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'adams_ws1' => {
    'CATEGORIES' => [
      'Misc',
      'Sph',
      'No',
      'inv'
    ],
    'CODE' => 'adams_ws1',
    'INVERSE' => 1,
    'NAME' => 'Adams World in a Square I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'adams_ws2' => {
    'CATEGORIES' => [
      'Misc',
      'Sph',
      'No',
      'inv'
    ],
    'CODE' => 'adams_ws2',
    'INVERSE' => 1,
    'NAME' => 'Adams World in a Square II',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'aea' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'aea',
    'INVERSE' => 1,
    'NAME' => 'Albers Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'aeqd' => {
    'CATEGORIES' => [
      'Azi',
      'Sph',
      'Ell'
    ],
    'CODE' => 'aeqd',
    'INVERSE' => 1,
    'NAME' => 'Azimuthal Equidistant',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_0',
        'guam'
      ]
    }
  },
  'affine' => {
    'CODE' => 'affine',
    'INVERSE' => 1,
    'NAME' => 'Affine transformation',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'airy' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'airy',
    'INVERSE' => 0,
    'NAME' => 'Airy',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'no_cut',
        'lat_b'
      ]
    }
  },
  'aitoff' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'aitoff',
    'INVERSE' => 1,
    'NAME' => 'Aitoff',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'alsk' => {
    'CATEGORIES' => [
      'Azi(mod)'
    ],
    'CODE' => 'alsk',
    'INVERSE' => 1,
    'NAME' => 'Modified Stereographic of Alaska',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'apian' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'apian',
    'INVERSE' => 0,
    'NAME' => 'Apian Globular I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'august' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'august',
    'INVERSE' => 0,
    'NAME' => 'August Epicycloidal',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'axisswap' => {
    'CODE' => 'axisswap',
    'INVERSE' => 1,
    'NAME' => 'Axis ordering',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'bacon' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'bacon',
    'INVERSE' => 0,
    'NAME' => 'Bacon Globular',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'bertin1953' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'bertin1953',
    'INVERSE' => 0,
    'NAME' => 'Bertin 1953',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'bipc' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'bipc',
    'INVERSE' => 1,
    'NAME' => 'Bipolar conic of western hemisphere',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'boggs' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'boggs',
    'INVERSE' => 0,
    'NAME' => 'Boggs Eumorphic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'bonne' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'bonne',
    'INVERSE' => 1,
    'NAME' => 'Bonne (Werner lat_1=90)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1'
      ]
    }
  },
  'calcofi' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'calcofi',
    'INVERSE' => 1,
    'NAME' => 'Cal Coop Ocean Fish Invest Lines/Stations',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'cart' => {
    'CODE' => 'cart',
    'INVERSE' => 1,
    'NAME' => 'Geodetic/cartesian conversions',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'cass' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'cass',
    'INVERSE' => 1,
    'NAME' => 'Cassini',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'cc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'cc',
    'INVERSE' => 1,
    'NAME' => 'Central Cylindrical',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'ccon' => {
    'CATEGORIES' => [
      'Central',
      'Conic',
      'Sph'
    ],
    'CODE' => 'ccon',
    'INVERSE' => 1,
    'NAME' => 'Central Conic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1'
      ]
    }
  },
  'cea' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'cea',
    'INVERSE' => 1,
    'NAME' => 'Equal Area Cylindrical',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts'
      ]
    }
  },
  'chamb' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'chamb',
    'INVERSE' => 0,
    'NAME' => 'Chamberlin Trimetric',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lon_1',
        'lat_2',
        'lon_2',
        'lat_3',
        'lon_3'
      ]
    }
  },
  'col_urban' => {
    'CATEGORIES' => [
      'Misc'
    ],
    'CODE' => 'col_urban',
    'INVERSE' => 1,
    'NAME' => 'Colombia Urban',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'h_0'
      ]
    }
  },
  'collg' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'collg',
    'INVERSE' => 1,
    'NAME' => 'Collignon',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'comill' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'comill',
    'INVERSE' => 1,
    'NAME' => 'Compact Miller',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'crast' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'crast',
    'INVERSE' => 1,
    'NAME' => 'Craster Parabolic (Putnins P4)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'defmodel' => {
    'CODE' => 'defmodel',
    'INVERSE' => 1,
    'NAME' => 'Deformation model',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'deformation' => {
    'CODE' => 'deformation',
    'INVERSE' => 1,
    'NAME' => 'Kinematic grid shift',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'denoy' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'denoy',
    'INVERSE' => 0,
    'NAME' => 'Denoyer Semi-Elliptical',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eck1' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'eck1',
    'INVERSE' => 1,
    'NAME' => 'Eckert I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eck2' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'eck2',
    'INVERSE' => 1,
    'NAME' => 'Eckert II',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eck3' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'eck3',
    'INVERSE' => 1,
    'NAME' => 'Eckert III',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eck4' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'eck4',
    'INVERSE' => 1,
    'NAME' => 'Eckert IV',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eck5' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'eck5',
    'INVERSE' => 1,
    'NAME' => 'Eckert V',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eck6' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'eck6',
    'INVERSE' => 1,
    'NAME' => 'Eckert VI',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'eqc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'eqc',
    'INVERSE' => 1,
    'NAME' => 'Equidistant Cylindrical (Plate Carree)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts',
        'lat_00'
      ]
    }
  },
  'eqdc' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'eqdc',
    'INVERSE' => 1,
    'NAME' => 'Equidistant Conic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'eqearth' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'eqearth',
    'INVERSE' => 1,
    'NAME' => 'Equal Earth',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'etmerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'etmerc',
    'INVERSE' => 1,
    'NAME' => 'Extended Transverse Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'euler' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'euler',
    'INVERSE' => 1,
    'NAME' => 'Euler',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'fahey' => {
    'CATEGORIES' => [
      'Pcyl',
      'Sph'
    ],
    'CODE' => 'fahey',
    'INVERSE' => 1,
    'NAME' => 'Fahey',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'fouc' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'fouc',
    'INVERSE' => 1,
    'NAME' => 'Foucaut',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'fouc_s' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'fouc_s',
    'INVERSE' => 1,
    'NAME' => 'Foucaut Sinusoidal',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'gall' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'gall',
    'INVERSE' => 1,
    'NAME' => 'Gall (Gall Stereographic)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'geoc' => {
    'CODE' => 'geoc',
    'INVERSE' => 1,
    'NAME' => 'Geocentric Latitude',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'geogoffset' => {
    'CODE' => 'geogoffset',
    'INVERSE' => 1,
    'NAME' => 'Geographic Offset',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'geos' => {
    'CATEGORIES' => [
      'Azi',
      'Sph',
      'Ell'
    ],
    'CODE' => 'geos',
    'INVERSE' => 1,
    'NAME' => 'Geostationary Satellite View',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'h'
      ]
    }
  },
  'gins8' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'gins8',
    'INVERSE' => 0,
    'NAME' => 'Ginsburg VIII (TsNIIGAiK)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'gn_sinu' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'gn_sinu',
    'INVERSE' => 1,
    'NAME' => 'General Sinusoidal Series',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'm',
        'n'
      ]
    }
  },
  'gnom' => {
    'CATEGORIES' => [
      'Azi',
      'Sph'
    ],
    'CODE' => 'gnom',
    'INVERSE' => 1,
    'NAME' => 'Gnomonic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'goode' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'goode',
    'INVERSE' => 1,
    'NAME' => 'Goode Homolosine',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'gridshift' => {
    'CODE' => 'gridshift',
    'INVERSE' => 1,
    'NAME' => 'Generic grid shift',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'gs48' => {
    'CATEGORIES' => [
      'Azi(mod)'
    ],
    'CODE' => 'gs48',
    'INVERSE' => 1,
    'NAME' => 'Modified Stereographic of 48 U.S.',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'gs50' => {
    'CATEGORIES' => [
      'Azi(mod)'
    ],
    'CODE' => 'gs50',
    'INVERSE' => 1,
    'NAME' => 'Modified Stereographic of 50 U.S.',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'gstmerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'gstmerc',
    'INVERSE' => 1,
    'NAME' => 'Gauss-Schreiber Transverse Mercator (aka Gauss-Laborde Reunion)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_0',
        'lon_0',
        'k_0'
      ]
    }
  },
  'guyou' => {
    'CATEGORIES' => [
      'Misc',
      'Sph',
      'No',
      'inv'
    ],
    'CODE' => 'guyou',
    'INVERSE' => 1,
    'NAME' => 'Guyou',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'hammer' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'hammer',
    'INVERSE' => 1,
    'NAME' => 'Hammer & Eckert-Greifendorff',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'W',
        'M'
      ]
    }
  },
  'hatano' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'hatano',
    'INVERSE' => 1,
    'NAME' => 'Hatano Asymmetrical Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'healpix' => {
    'CATEGORIES' => [
      'Sph',
      'Ell'
    ],
    'CODE' => 'healpix',
    'INVERSE' => 1,
    'NAME' => 'HEALPix',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'rot_xy'
      ]
    }
  },
  'helmert' => {
    'CODE' => 'helmert',
    'INVERSE' => 1,
    'NAME' => '3(6)-, 4(8)- and 7(14)-parameter Helmert shift',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'hgridshift' => {
    'CODE' => 'hgridshift',
    'INVERSE' => 1,
    'NAME' => 'Horizontal grid shift',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'horner' => {
    'CODE' => 'horner',
    'INVERSE' => 1,
    'NAME' => 'Horner polynomial evaluation',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'igh' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'igh',
    'INVERSE' => 1,
    'NAME' => 'Interrupted Goode Homolosine',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'igh_o' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'igh_o',
    'INVERSE' => 1,
    'NAME' => 'Interrupted Goode Homolosine Oceanic View',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'imoll' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'imoll',
    'INVERSE' => 1,
    'NAME' => 'Interrupted Mollweide',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'imoll_o' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'imoll_o',
    'INVERSE' => 1,
    'NAME' => 'Interrupted Mollweide Oceanic View',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'imw_p' => {
    'CATEGORIES' => [
      'Mod.',
      'Polyconic',
      'Ell'
    ],
    'CODE' => 'imw_p',
    'INVERSE' => 1,
    'NAME' => 'International Map of the World Polyconic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2',
        'lon_1'
      ]
    }
  },
  'isea' => {
    'CATEGORIES' => [
      'Sph'
    ],
    'CODE' => 'isea',
    'INVERSE' => 1,
    'NAME' => 'Icosahedral Snyder Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'kav5' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'kav5',
    'INVERSE' => 1,
    'NAME' => 'Kavrayskiy V',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'kav7' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'kav7',
    'INVERSE' => 1,
    'NAME' => 'Kavrayskiy VII',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'krovak' => {
    'CATEGORIES' => [
      'PCyl',
      'Ell'
    ],
    'CODE' => 'krovak',
    'INVERSE' => 1,
    'NAME' => 'Krovak',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'labrd' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'labrd',
    'INVERSE' => 1,
    'NAME' => 'Laborde',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_0'
      ]
    }
  },
  'laea' => {
    'CATEGORIES' => [
      'Azi',
      'Sph',
      'Ell'
    ],
    'CODE' => 'laea',
    'INVERSE' => 1,
    'NAME' => 'Lambert Azimuthal Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'lagrng' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'lagrng',
    'INVERSE' => 1,
    'NAME' => 'Lagrange',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'W'
      ]
    }
  },
  'larr' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'larr',
    'INVERSE' => 0,
    'NAME' => 'Larrivee',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'lask' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'lask',
    'INVERSE' => 0,
    'NAME' => 'Laskowski',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'latlon' => {
    'CATEGORIES' => [],
    'CODE' => 'latlon',
    'INVERSE' => 1,
    'NAME' => 'Lat/long (Geodetic alias)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'lcc' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'lcc',
    'INVERSE' => 1,
    'NAME' => 'Lambert Conformal Conic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2',
        'lat_0',
        'k_0'
      ]
    }
  },
  'lcca' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'lcca',
    'INVERSE' => 1,
    'NAME' => 'Lambert Conformal Conic Alternative',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_0'
      ]
    }
  },
  'leac' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'leac',
    'INVERSE' => 1,
    'NAME' => 'Lambert Equal Area Conic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'south'
      ]
    }
  },
  'lee_os' => {
    'CATEGORIES' => [
      'Azi(mod)'
    ],
    'CODE' => 'lee_os',
    'INVERSE' => 1,
    'NAME' => 'Lee Oblated Stereographic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'lonlat' => {
    'CATEGORIES' => [],
    'CODE' => 'lonlat',
    'INVERSE' => 1,
    'NAME' => 'Lat/long (Geodetic)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'loxim' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'loxim',
    'INVERSE' => 1,
    'NAME' => 'Loximuthal',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'lsat' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'lsat',
    'INVERSE' => 1,
    'NAME' => 'Space oblique for LANDSAT',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lsat',
        'path'
      ]
    }
  },
  'mbt_fps' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'mbt_fps',
    'INVERSE' => 1,
    'NAME' => 'McBryde-Thomas Flat-Pole Sine (No. 2)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'mbt_s' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'mbt_s',
    'INVERSE' => 1,
    'NAME' => 'McBryde-Thomas Flat-Polar Sine (No. 1)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'mbtfpp' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'mbtfpp',
    'INVERSE' => 1,
    'NAME' => 'McBride-Thomas Flat-Polar Parabolic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'mbtfpq' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'mbtfpq',
    'INVERSE' => 1,
    'NAME' => 'McBryde-Thomas Flat-Polar Quartic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'mbtfps' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'mbtfps',
    'INVERSE' => 1,
    'NAME' => 'McBryde-Thomas Flat-Polar Sinusoidal',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'merc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'merc',
    'INVERSE' => 1,
    'NAME' => 'Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts'
      ]
    }
  },
  'mil_os' => {
    'CATEGORIES' => [
      'Azi(mod)'
    ],
    'CODE' => 'mil_os',
    'INVERSE' => 1,
    'NAME' => 'Miller Oblated Stereographic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'mill' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'mill',
    'INVERSE' => 1,
    'NAME' => 'Miller Cylindrical',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'misrsom' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'misrsom',
    'INVERSE' => 1,
    'NAME' => 'Space oblique for MISR',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'path'
      ]
    }
  },
  'mod_krovak' => {
    'CATEGORIES' => [
      'PCyl',
      'Ell'
    ],
    'CODE' => 'mod_krovak',
    'INVERSE' => 1,
    'NAME' => 'Modified Krovak',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'moll' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'moll',
    'INVERSE' => 1,
    'NAME' => 'Mollweide',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'molobadekas' => {
    'CODE' => 'molobadekas',
    'INVERSE' => 1,
    'NAME' => 'Molodensky-Badekas transformation',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'molodensky' => {
    'CODE' => 'molodensky',
    'INVERSE' => 1,
    'NAME' => 'Molodensky transform',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'murd1' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'murd1',
    'INVERSE' => 1,
    'NAME' => 'Murdoch I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'murd2' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'murd2',
    'INVERSE' => 1,
    'NAME' => 'Murdoch II',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'murd3' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'murd3',
    'INVERSE' => 1,
    'NAME' => 'Murdoch III',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'natearth' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'natearth',
    'INVERSE' => 1,
    'NAME' => 'Natural Earth',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'natearth2' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'natearth2',
    'INVERSE' => 1,
    'NAME' => 'Natural Earth 2',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'nell' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'nell',
    'INVERSE' => 1,
    'NAME' => 'Nell',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'nell_h' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'nell_h',
    'INVERSE' => 1,
    'NAME' => 'Nell-Hammer',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'nicol' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'nicol',
    'INVERSE' => 0,
    'NAME' => 'Nicolosi Globular',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'noop' => {
    'CODE' => 'noop',
    'INVERSE' => 1,
    'NAME' => 'No operation',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'nsper' => {
    'CATEGORIES' => [
      'Azi',
      'Sph'
    ],
    'CODE' => 'nsper',
    'INVERSE' => 1,
    'NAME' => 'Near-sided perspective',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'h'
      ]
    }
  },
  'nzmg' => {
    'CATEGORIES' => [
      'fixed Earth'
    ],
    'CODE' => 'nzmg',
    'INVERSE' => 1,
    'NAME' => 'New Zealand Map Grid',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'ob_tran' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'ob_tran',
    'INVERSE' => 1,
    'NAME' => 'General Oblique Transformation',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'o_proj',
        'o_lat_p',
        'o_lon_p',
        'o_alpha',
        'o_lon_c',
        'o_lat_c',
        'o_lon_1',
        'o_lat_1',
        'o_lon_2',
        'o_lat_2'
      ]
    }
  },
  'ocea' => {
    'CATEGORIES' => [
      'Cyl',
      'Sphlonc=',
      'alpha='
    ],
    'CODE' => 'ocea',
    'INVERSE' => 1,
    'NAME' => 'Oblique Cylindrical Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2',
        'lon_1',
        'lon_2'
      ]
    }
  },
  'oea' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'oea',
    'INVERSE' => 1,
    'NAME' => 'Oblated Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'n',
        'm',
        'theta'
      ]
    }
  },
  'omerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell',
      'no_rot'
    ],
    'CODE' => 'omerc',
    'INVERSE' => 1,
    'NAME' => 'Oblique Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'alpha',
        'gamma',
        'no_off',
        'lonc',
        'lon_1',
        'lat_1',
        'lon_2',
        'lat_2'
      ]
    }
  },
  'ortel' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'ortel',
    'INVERSE' => 0,
    'NAME' => 'Ortelius Oval',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'ortho' => {
    'CATEGORIES' => [
      'Azi',
      'Sph',
      'Ell'
    ],
    'CODE' => 'ortho',
    'INVERSE' => 1,
    'NAME' => 'Orthographic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'patterson' => {
    'CATEGORIES' => [
      'Cyl'
    ],
    'CODE' => 'patterson',
    'INVERSE' => 1,
    'NAME' => 'Patterson Cylindrical',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'pconic' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'pconic',
    'INVERSE' => 1,
    'NAME' => 'Perspective Conic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'peirce_q' => {
    'CATEGORIES' => [
      'Misc',
      'Sph',
      'No',
      'inv'
    ],
    'CODE' => 'peirce_q',
    'INVERSE' => 1,
    'NAME' => 'Peirce Quincuncial',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'pipeline' => {
    'CODE' => 'pipeline',
    'INVERSE' => 1,
    'NAME' => 'Transformation pipeline manager',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'poly' => {
    'CATEGORIES' => [
      'Conic',
      'Sph',
      'Ell'
    ],
    'CODE' => 'poly',
    'INVERSE' => 1,
    'NAME' => 'Polyconic (American)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'pop' => {
    'CODE' => 'pop',
    'INVERSE' => 1,
    'NAME' => 'Retrieve coordinate value from pipeline stack',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'push' => {
    'CODE' => 'push',
    'INVERSE' => 1,
    'NAME' => 'Save coordinate value on pipeline stack',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp1' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp1',
    'INVERSE' => 1,
    'NAME' => 'Putnins P1',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp2' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp2',
    'INVERSE' => 1,
    'NAME' => 'Putnins P2',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp3' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp3',
    'INVERSE' => 1,
    'NAME' => 'Putnins P3',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp3p' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp3p',
    'INVERSE' => 1,
    'NAME' => 'Putnins P3\'',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp4p' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp4p',
    'INVERSE' => 1,
    'NAME' => 'Putnins P4\'',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp5' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp5',
    'INVERSE' => 1,
    'NAME' => 'Putnins P5',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp5p' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp5p',
    'INVERSE' => 1,
    'NAME' => 'Putnins P5\'',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp6' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp6',
    'INVERSE' => 1,
    'NAME' => 'Putnins P6',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'putp6p' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'putp6p',
    'INVERSE' => 1,
    'NAME' => 'Putnins P6\'',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'qsc' => {
    'CATEGORIES' => [
      'Azi',
      'Sph'
    ],
    'CODE' => 'qsc',
    'INVERSE' => 1,
    'NAME' => 'Quadrilateralized Spherical Cube',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'qua_aut' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'qua_aut',
    'INVERSE' => 1,
    'NAME' => 'Quartic Authalic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'rhealpix' => {
    'CATEGORIES' => [
      'Sph',
      'Ell'
    ],
    'CODE' => 'rhealpix',
    'INVERSE' => 1,
    'NAME' => 'rHEALPix',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'north_square',
        'south_square'
      ]
    }
  },
  'robin' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'robin',
    'INVERSE' => 1,
    'NAME' => 'Robinson',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'rouss' => {
    'CATEGORIES' => [
      'Azi',
      'Ell'
    ],
    'CODE' => 'rouss',
    'INVERSE' => 1,
    'NAME' => 'Roussilhe Stereographic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'rpoly' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'rpoly',
    'INVERSE' => 0,
    'NAME' => 'Rectangular Polyconic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts'
      ]
    }
  },
  's2' => {
    'CATEGORIES' => [
      'Misc',
      'Sph',
      'Ell'
    ],
    'CODE' => 's2',
    'INVERSE' => 1,
    'NAME' => 'S2',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'sch' => {
    'CATEGORIES' => [
      'Misc'
    ],
    'CODE' => 'sch',
    'INVERSE' => 1,
    'NAME' => 'Spherical Cross-track Height',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'plat_0',
        'plon_0',
        'phdg_0',
        'h_0'
      ]
    }
  },
  'set' => {
    'CODE' => 'set',
    'INVERSE' => 1,
    'NAME' => 'Set coordinate value',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'sinu' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'sinu',
    'INVERSE' => 1,
    'NAME' => 'Sinusoidal (Sanson-Flamsteed)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'som' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'som',
    'INVERSE' => 1,
    'NAME' => 'Space Oblique Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'inc_angle',
        'ps_rev',
        'asc_lon'
      ]
    }
  },
  'somerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Ell'
    ],
    'CODE' => 'somerc',
    'INVERSE' => 1,
    'NAME' => 'Swiss. Obl. Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'stere' => {
    'CATEGORIES' => [
      'Azi',
      'Sph',
      'Ell'
    ],
    'CODE' => 'stere',
    'INVERSE' => 1,
    'NAME' => 'Stereographic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts'
      ]
    }
  },
  'sterea' => {
    'CATEGORIES' => [
      'Azimuthal',
      'Sph',
      'Ell'
    ],
    'CODE' => 'sterea',
    'INVERSE' => 1,
    'NAME' => 'Oblique Stereographic Alternative',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'tcc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'tcc',
    'INVERSE' => 0,
    'NAME' => 'Transverse Central Cylindrical',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'tcea' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'tcea',
    'INVERSE' => 1,
    'NAME' => 'Transverse Cylindrical Equal Area',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'times' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'times',
    'INVERSE' => 1,
    'NAME' => 'Times',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'tinshift' => {
    'CODE' => 'tinshift',
    'INVERSE' => 1,
    'NAME' => 'Triangulation based transformation',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'tissot' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'tissot',
    'INVERSE' => 1,
    'NAME' => 'Tissot',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'tmerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph',
      'Ell'
    ],
    'CODE' => 'tmerc',
    'INVERSE' => 1,
    'NAME' => 'Transverse Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'approx'
      ]
    }
  },
  'tobmerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Sph'
    ],
    'CODE' => 'tobmerc',
    'INVERSE' => 1,
    'NAME' => 'Tobler-Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'topocentric' => {
    'CODE' => 'topocentric',
    'INVERSE' => 1,
    'NAME' => 'Geocentric/Topocentric conversion',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'tpeqd' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'tpeqd',
    'INVERSE' => 1,
    'NAME' => 'Two Point Equidistant',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lon_1',
        'lat_2',
        'lon_2'
      ]
    }
  },
  'tpers' => {
    'CATEGORIES' => [
      'Azi',
      'Sph'
    ],
    'CODE' => 'tpers',
    'INVERSE' => 1,
    'NAME' => 'Tilted perspective',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'tilt',
        'azi',
        'h'
      ]
    }
  },
  'unitconvert' => {
    'CODE' => 'unitconvert',
    'INVERSE' => 1,
    'NAME' => 'Unit conversion',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'ups' => {
    'CATEGORIES' => [
      'Azi',
      'Ell'
    ],
    'CODE' => 'ups',
    'INVERSE' => 1,
    'NAME' => 'Universal Polar Stereographic',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'south'
      ]
    }
  },
  'urm5' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'urm5',
    'INVERSE' => 0,
    'NAME' => 'Urmaev V',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'n',
        'q',
        'alpha'
      ]
    }
  },
  'urmfps' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'urmfps',
    'INVERSE' => 1,
    'NAME' => 'Urmaev Flat-Polar Sinusoidal',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'n'
      ]
    }
  },
  'utm' => {
    'CATEGORIES' => [
      'Cyl',
      'Ell'
    ],
    'CODE' => 'utm',
    'INVERSE' => 1,
    'NAME' => 'Universal Transverse Mercator (UTM)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'zone',
        'south',
        'approx'
      ]
    }
  },
  'vandg' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'vandg',
    'INVERSE' => 1,
    'NAME' => 'van der Grinten (I)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'vandg2' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'vandg2',
    'INVERSE' => 0,
    'NAME' => 'van der Grinten II',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'vandg3' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'vandg3',
    'INVERSE' => 0,
    'NAME' => 'van der Grinten III',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'vandg4' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'vandg4',
    'INVERSE' => 0,
    'NAME' => 'van der Grinten IV',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'vertoffset' => {
    'CATEGORIES' => [
      'Transfmation'
    ],
    'CODE' => 'vertoffset',
    'INVERSE' => 1,
    'NAME' => 'Vertical Offset and Slope',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_0',
        'lon_0',
        'dh',
        'slope_lat',
        'slope_lon'
      ]
    }
  },
  'vgridshift' => {
    'CODE' => 'vgridshift',
    'INVERSE' => 1,
    'NAME' => 'Vertical grid shift',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'vitk1' => {
    'CATEGORIES' => [
      'Conic',
      'Sph'
    ],
    'CODE' => 'vitk1',
    'INVERSE' => 1,
    'NAME' => 'Vitkovsky I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1',
        'lat_2'
      ]
    }
  },
  'wag1' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wag1',
    'INVERSE' => 1,
    'NAME' => 'Wagner I (Kavrayskiy VI)',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'wag2' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wag2',
    'INVERSE' => 1,
    'NAME' => 'Wagner II',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'wag3' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wag3',
    'INVERSE' => 1,
    'NAME' => 'Wagner III',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts'
      ]
    }
  },
  'wag4' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wag4',
    'INVERSE' => 1,
    'NAME' => 'Wagner IV',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'wag5' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wag5',
    'INVERSE' => 1,
    'NAME' => 'Wagner V',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'wag6' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wag6',
    'INVERSE' => 1,
    'NAME' => 'Wagner VI',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'wag7' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'wag7',
    'INVERSE' => 0,
    'NAME' => 'Wagner VII',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'webmerc' => {
    'CATEGORIES' => [
      'Cyl',
      'Ell'
    ],
    'CODE' => 'webmerc',
    'INVERSE' => 1,
    'NAME' => 'Web Mercator / Pseudo Mercator',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'weren' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'weren',
    'INVERSE' => 1,
    'NAME' => 'Werenskiold I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  },
  'wink1' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wink1',
    'INVERSE' => 1,
    'NAME' => 'Winkel I',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_ts'
      ]
    }
  },
  'wink2' => {
    'CATEGORIES' => [
      'PCyl',
      'Sph'
    ],
    'CODE' => 'wink2',
    'INVERSE' => 1,
    'NAME' => 'Winkel II',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1'
      ]
    }
  },
  'wintri' => {
    'CATEGORIES' => [
      'Misc',
      'Sph'
    ],
    'CODE' => 'wintri',
    'INVERSE' => 1,
    'NAME' => 'Winkel Tripel',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => [
        'lat_1'
      ]
    }
  },
  'xyzgridshift' => {
    'CODE' => 'xyzgridshift',
    'INVERSE' => 1,
    'NAME' => 'Geocentric grid shift',
    'PARAMS' => {
      'EARTH' => [
        'ellps',
        'b',
        'f',
        'rf',
        'e',
        'es',
        'R',
        'R_A',
        'R_V',
        'R_a',
        'R_g',
        'R_h',
        'R_lat_g'
      ],
      'GENERAL' => [
        'x_0',
        'y_0',
        'lon_0',
        'units',
        'init',
        'no_defs',
        'geoc',
        'over'
      ],
      'PROJ' => []
    }
  }
}
}

#line 547 "proj4.pd"

=head1 FUNCTIONS

=head2 t_proj

This is the main entry point for the generalized interface. See above on its usage.

=cut

#line 634 "proj4.pd"
=head2 t_proj_adams_hemi

Autogenerated transformation function for Proj4 projection code adams_hemi.

The full name for this projection is Adams Hemisphere in a Square.

=cut

sub t_proj_adams_hemi
    { 'PDL::Transform::Proj4::adams_hemi'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_adams_ws1

Autogenerated transformation function for Proj4 projection code adams_ws1.

The full name for this projection is Adams World in a Square I.

=cut

sub t_proj_adams_ws1
    { 'PDL::Transform::Proj4::adams_ws1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_adams_ws2

Autogenerated transformation function for Proj4 projection code adams_ws2.

The full name for this projection is Adams World in a Square II.

=cut

sub t_proj_adams_ws2
    { 'PDL::Transform::Proj4::adams_ws2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_aea

Autogenerated transformation function for Proj4 projection code aea.

The full name for this projection is Albers Equal Area.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_aea
    { 'PDL::Transform::Proj4::aea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_aeqd

Autogenerated transformation function for Proj4 projection code aeqd.

The full name for this projection is Azimuthal Equidistant.

Projection Parameters

=for options

=over 4

=item guam

=item lat_0

=back

=cut

sub t_proj_aeqd
    { 'PDL::Transform::Proj4::aeqd'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_affine

Autogenerated transformation function for Proj4 projection code affine.

The full name for this projection is Affine transformation.

=cut

sub t_proj_affine
    { 'PDL::Transform::Proj4::affine'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_airy

Autogenerated transformation function for Proj4 projection code airy.

The full name for this projection is Airy.

Projection Parameters

=for options

=over 4

=item lat_b

=item no_cut

=back

=cut

sub t_proj_airy
    { 'PDL::Transform::Proj4::airy'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_aitoff

Autogenerated transformation function for Proj4 projection code aitoff.

The full name for this projection is Aitoff.

=cut

sub t_proj_aitoff
    { 'PDL::Transform::Proj4::aitoff'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_alsk

Autogenerated transformation function for Proj4 projection code alsk.

The full name for this projection is Modified Stereographic of Alaska.

=cut

sub t_proj_alsk
    { 'PDL::Transform::Proj4::alsk'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_apian

Autogenerated transformation function for Proj4 projection code apian.

The full name for this projection is Apian Globular I.

=cut

sub t_proj_apian
    { 'PDL::Transform::Proj4::apian'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_august

Autogenerated transformation function for Proj4 projection code august.

The full name for this projection is August Epicycloidal.

=cut

sub t_proj_august
    { 'PDL::Transform::Proj4::august'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_axisswap

Autogenerated transformation function for Proj4 projection code axisswap.

The full name for this projection is Axis ordering.

=cut

sub t_proj_axisswap
    { 'PDL::Transform::Proj4::axisswap'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_bacon

Autogenerated transformation function for Proj4 projection code bacon.

The full name for this projection is Bacon Globular.

=cut

sub t_proj_bacon
    { 'PDL::Transform::Proj4::bacon'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_bertin1953

Autogenerated transformation function for Proj4 projection code bertin1953.

The full name for this projection is Bertin 1953.

=cut

sub t_proj_bertin1953
    { 'PDL::Transform::Proj4::bertin1953'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_bipc

Autogenerated transformation function for Proj4 projection code bipc.

The full name for this projection is Bipolar conic of western hemisphere.

=cut

sub t_proj_bipc
    { 'PDL::Transform::Proj4::bipc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_boggs

Autogenerated transformation function for Proj4 projection code boggs.

The full name for this projection is Boggs Eumorphic.

=cut

sub t_proj_boggs
    { 'PDL::Transform::Proj4::boggs'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_bonne

Autogenerated transformation function for Proj4 projection code bonne.

The full name for this projection is Bonne (Werner lat_1=90).

Projection Parameters

=for options

=over 4

=item lat_1

=back

=cut

sub t_proj_bonne
    { 'PDL::Transform::Proj4::bonne'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_calcofi

Autogenerated transformation function for Proj4 projection code calcofi.

The full name for this projection is Cal Coop Ocean Fish Invest Lines/Stations.

=cut

sub t_proj_calcofi
    { 'PDL::Transform::Proj4::calcofi'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_cart

Autogenerated transformation function for Proj4 projection code cart.

The full name for this projection is Geodetic/cartesian conversions.

=cut

sub t_proj_cart
    { 'PDL::Transform::Proj4::cart'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_cass

Autogenerated transformation function for Proj4 projection code cass.

The full name for this projection is Cassini.

=cut

sub t_proj_cass
    { 'PDL::Transform::Proj4::cass'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_cc

Autogenerated transformation function for Proj4 projection code cc.

The full name for this projection is Central Cylindrical.

=cut

sub t_proj_cc
    { 'PDL::Transform::Proj4::cc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_ccon

Autogenerated transformation function for Proj4 projection code ccon.

The full name for this projection is Central Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=back

=cut

sub t_proj_ccon
    { 'PDL::Transform::Proj4::ccon'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_cea

Autogenerated transformation function for Proj4 projection code cea.

The full name for this projection is Equal Area Cylindrical.

Projection Parameters

=for options

=over 4

=item lat_ts

=back

=cut

sub t_proj_cea
    { 'PDL::Transform::Proj4::cea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_chamb

Autogenerated transformation function for Proj4 projection code chamb.

The full name for this projection is Chamberlin Trimetric.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lat_3

=item lon_1

=item lon_2

=item lon_3

=back

=cut

sub t_proj_chamb
    { 'PDL::Transform::Proj4::chamb'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_col_urban

Autogenerated transformation function for Proj4 projection code col_urban.

The full name for this projection is Colombia Urban.

Projection Parameters

=for options

=over 4

=item h_0

=back

=cut

sub t_proj_col_urban
    { 'PDL::Transform::Proj4::col_urban'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_collg

Autogenerated transformation function for Proj4 projection code collg.

The full name for this projection is Collignon.

=cut

sub t_proj_collg
    { 'PDL::Transform::Proj4::collg'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_comill

Autogenerated transformation function for Proj4 projection code comill.

The full name for this projection is Compact Miller.

=cut

sub t_proj_comill
    { 'PDL::Transform::Proj4::comill'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_crast

Autogenerated transformation function for Proj4 projection code crast.

The full name for this projection is Craster Parabolic (Putnins P4).

=cut

sub t_proj_crast
    { 'PDL::Transform::Proj4::crast'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_defmodel

Autogenerated transformation function for Proj4 projection code defmodel.

The full name for this projection is Deformation model.

=cut

sub t_proj_defmodel
    { 'PDL::Transform::Proj4::defmodel'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_deformation

Autogenerated transformation function for Proj4 projection code deformation.

The full name for this projection is Kinematic grid shift.

=cut

sub t_proj_deformation
    { 'PDL::Transform::Proj4::deformation'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_denoy

Autogenerated transformation function for Proj4 projection code denoy.

The full name for this projection is Denoyer Semi-Elliptical.

=cut

sub t_proj_denoy
    { 'PDL::Transform::Proj4::denoy'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eck1

Autogenerated transformation function for Proj4 projection code eck1.

The full name for this projection is Eckert I.

=cut

sub t_proj_eck1
    { 'PDL::Transform::Proj4::eck1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eck2

Autogenerated transformation function for Proj4 projection code eck2.

The full name for this projection is Eckert II.

=cut

sub t_proj_eck2
    { 'PDL::Transform::Proj4::eck2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eck3

Autogenerated transformation function for Proj4 projection code eck3.

The full name for this projection is Eckert III.

=cut

sub t_proj_eck3
    { 'PDL::Transform::Proj4::eck3'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eck4

Autogenerated transformation function for Proj4 projection code eck4.

The full name for this projection is Eckert IV.

=cut

sub t_proj_eck4
    { 'PDL::Transform::Proj4::eck4'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eck5

Autogenerated transformation function for Proj4 projection code eck5.

The full name for this projection is Eckert V.

=cut

sub t_proj_eck5
    { 'PDL::Transform::Proj4::eck5'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eck6

Autogenerated transformation function for Proj4 projection code eck6.

The full name for this projection is Eckert VI.

=cut

sub t_proj_eck6
    { 'PDL::Transform::Proj4::eck6'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eqc

Autogenerated transformation function for Proj4 projection code eqc.

The full name for this projection is Equidistant Cylindrical (Plate Carree).

Projection Parameters

=for options

=over 4

=item lat_00

=item lat_ts

=back

=cut

sub t_proj_eqc
    { 'PDL::Transform::Proj4::eqc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eqdc

Autogenerated transformation function for Proj4 projection code eqdc.

The full name for this projection is Equidistant Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_eqdc
    { 'PDL::Transform::Proj4::eqdc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_eqearth

Autogenerated transformation function for Proj4 projection code eqearth.

The full name for this projection is Equal Earth.

=cut

sub t_proj_eqearth
    { 'PDL::Transform::Proj4::eqearth'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_etmerc

Autogenerated transformation function for Proj4 projection code etmerc.

The full name for this projection is Extended Transverse Mercator.

=cut

sub t_proj_etmerc
    { 'PDL::Transform::Proj4::etmerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_euler

Autogenerated transformation function for Proj4 projection code euler.

The full name for this projection is Euler.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_euler
    { 'PDL::Transform::Proj4::euler'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_fahey

Autogenerated transformation function for Proj4 projection code fahey.

The full name for this projection is Fahey.

=cut

sub t_proj_fahey
    { 'PDL::Transform::Proj4::fahey'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_fouc

Autogenerated transformation function for Proj4 projection code fouc.

The full name for this projection is Foucaut.

=cut

sub t_proj_fouc
    { 'PDL::Transform::Proj4::fouc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_fouc_s

Autogenerated transformation function for Proj4 projection code fouc_s.

The full name for this projection is Foucaut Sinusoidal.

=cut

sub t_proj_fouc_s
    { 'PDL::Transform::Proj4::fouc_s'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gall

Autogenerated transformation function for Proj4 projection code gall.

The full name for this projection is Gall (Gall Stereographic).

=cut

sub t_proj_gall
    { 'PDL::Transform::Proj4::gall'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_geoc

Autogenerated transformation function for Proj4 projection code geoc.

The full name for this projection is Geocentric Latitude.

=cut

sub t_proj_geoc
    { 'PDL::Transform::Proj4::geoc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_geogoffset

Autogenerated transformation function for Proj4 projection code geogoffset.

The full name for this projection is Geographic Offset.

=cut

sub t_proj_geogoffset
    { 'PDL::Transform::Proj4::geogoffset'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_geos

Autogenerated transformation function for Proj4 projection code geos.

The full name for this projection is Geostationary Satellite View.

Projection Parameters

=for options

=over 4

=item h

=back

=cut

sub t_proj_geos
    { 'PDL::Transform::Proj4::geos'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gins8

Autogenerated transformation function for Proj4 projection code gins8.

The full name for this projection is Ginsburg VIII (TsNIIGAiK).

=cut

sub t_proj_gins8
    { 'PDL::Transform::Proj4::gins8'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gn_sinu

Autogenerated transformation function for Proj4 projection code gn_sinu.

The full name for this projection is General Sinusoidal Series.

Projection Parameters

=for options

=over 4

=item m

=item n

=back

=cut

sub t_proj_gn_sinu
    { 'PDL::Transform::Proj4::gn_sinu'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gnom

Autogenerated transformation function for Proj4 projection code gnom.

The full name for this projection is Gnomonic.

=cut

sub t_proj_gnom
    { 'PDL::Transform::Proj4::gnom'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_goode

Autogenerated transformation function for Proj4 projection code goode.

The full name for this projection is Goode Homolosine.

=cut

sub t_proj_goode
    { 'PDL::Transform::Proj4::goode'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gridshift

Autogenerated transformation function for Proj4 projection code gridshift.

The full name for this projection is Generic grid shift.

=cut

sub t_proj_gridshift
    { 'PDL::Transform::Proj4::gridshift'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gs48

Autogenerated transformation function for Proj4 projection code gs48.

The full name for this projection is Modified Stereographic of 48 U.S..

=cut

sub t_proj_gs48
    { 'PDL::Transform::Proj4::gs48'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gs50

Autogenerated transformation function for Proj4 projection code gs50.

The full name for this projection is Modified Stereographic of 50 U.S..

=cut

sub t_proj_gs50
    { 'PDL::Transform::Proj4::gs50'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_gstmerc

Autogenerated transformation function for Proj4 projection code gstmerc.

The full name for this projection is Gauss-Schreiber Transverse Mercator (aka Gauss-Laborde Reunion).

Projection Parameters

=for options

=over 4

=item k_0

=item lat_0

=item lon_0

=back

=cut

sub t_proj_gstmerc
    { 'PDL::Transform::Proj4::gstmerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_guyou

Autogenerated transformation function for Proj4 projection code guyou.

The full name for this projection is Guyou.

=cut

sub t_proj_guyou
    { 'PDL::Transform::Proj4::guyou'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_hammer

Autogenerated transformation function for Proj4 projection code hammer.

The full name for this projection is Hammer & Eckert-Greifendorff.

Projection Parameters

=for options

=over 4

=item M

=item W

=back

=cut

sub t_proj_hammer
    { 'PDL::Transform::Proj4::hammer'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_hatano

Autogenerated transformation function for Proj4 projection code hatano.

The full name for this projection is Hatano Asymmetrical Equal Area.

=cut

sub t_proj_hatano
    { 'PDL::Transform::Proj4::hatano'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_healpix

Autogenerated transformation function for Proj4 projection code healpix.

The full name for this projection is HEALPix.

Projection Parameters

=for options

=over 4

=item rot_xy

=back

=cut

sub t_proj_healpix
    { 'PDL::Transform::Proj4::healpix'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_helmert

Autogenerated transformation function for Proj4 projection code helmert.

The full name for this projection is 3(6)-, 4(8)- and 7(14)-parameter Helmert shift.

=cut

sub t_proj_helmert
    { 'PDL::Transform::Proj4::helmert'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_hgridshift

Autogenerated transformation function for Proj4 projection code hgridshift.

The full name for this projection is Horizontal grid shift.

=cut

sub t_proj_hgridshift
    { 'PDL::Transform::Proj4::hgridshift'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_horner

Autogenerated transformation function for Proj4 projection code horner.

The full name for this projection is Horner polynomial evaluation.

=cut

sub t_proj_horner
    { 'PDL::Transform::Proj4::horner'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_igh

Autogenerated transformation function for Proj4 projection code igh.

The full name for this projection is Interrupted Goode Homolosine.

=cut

sub t_proj_igh
    { 'PDL::Transform::Proj4::igh'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_igh_o

Autogenerated transformation function for Proj4 projection code igh_o.

The full name for this projection is Interrupted Goode Homolosine Oceanic View.

=cut

sub t_proj_igh_o
    { 'PDL::Transform::Proj4::igh_o'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_imoll

Autogenerated transformation function for Proj4 projection code imoll.

The full name for this projection is Interrupted Mollweide.

=cut

sub t_proj_imoll
    { 'PDL::Transform::Proj4::imoll'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_imoll_o

Autogenerated transformation function for Proj4 projection code imoll_o.

The full name for this projection is Interrupted Mollweide Oceanic View.

=cut

sub t_proj_imoll_o
    { 'PDL::Transform::Proj4::imoll_o'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_imw_p

Autogenerated transformation function for Proj4 projection code imw_p.

The full name for this projection is International Map of the World Polyconic.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lon_1

=back

=cut

sub t_proj_imw_p
    { 'PDL::Transform::Proj4::imw_p'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_isea

Autogenerated transformation function for Proj4 projection code isea.

The full name for this projection is Icosahedral Snyder Equal Area.

=cut

sub t_proj_isea
    { 'PDL::Transform::Proj4::isea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_kav5

Autogenerated transformation function for Proj4 projection code kav5.

The full name for this projection is Kavrayskiy V.

=cut

sub t_proj_kav5
    { 'PDL::Transform::Proj4::kav5'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_kav7

Autogenerated transformation function for Proj4 projection code kav7.

The full name for this projection is Kavrayskiy VII.

=cut

sub t_proj_kav7
    { 'PDL::Transform::Proj4::kav7'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_krovak

Autogenerated transformation function for Proj4 projection code krovak.

The full name for this projection is Krovak.

=cut

sub t_proj_krovak
    { 'PDL::Transform::Proj4::krovak'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_labrd

Autogenerated transformation function for Proj4 projection code labrd.

The full name for this projection is Laborde.

Projection Parameters

=for options

=over 4

=item lat_0

=back

=cut

sub t_proj_labrd
    { 'PDL::Transform::Proj4::labrd'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_laea

Autogenerated transformation function for Proj4 projection code laea.

The full name for this projection is Lambert Azimuthal Equal Area.

=cut

sub t_proj_laea
    { 'PDL::Transform::Proj4::laea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lagrng

Autogenerated transformation function for Proj4 projection code lagrng.

The full name for this projection is Lagrange.

Projection Parameters

=for options

=over 4

=item W

=back

=cut

sub t_proj_lagrng
    { 'PDL::Transform::Proj4::lagrng'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_larr

Autogenerated transformation function for Proj4 projection code larr.

The full name for this projection is Larrivee.

=cut

sub t_proj_larr
    { 'PDL::Transform::Proj4::larr'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lask

Autogenerated transformation function for Proj4 projection code lask.

The full name for this projection is Laskowski.

=cut

sub t_proj_lask
    { 'PDL::Transform::Proj4::lask'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_latlon

Autogenerated transformation function for Proj4 projection code latlon.

The full name for this projection is Lat/long (Geodetic alias).

=cut

sub t_proj_latlon
    { 'PDL::Transform::Proj4::latlon'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lcc

Autogenerated transformation function for Proj4 projection code lcc.

The full name for this projection is Lambert Conformal Conic.

Projection Parameters

=for options

=over 4

=item k_0

=item lat_0

=item lat_1

=item lat_2

=back

=cut

sub t_proj_lcc
    { 'PDL::Transform::Proj4::lcc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lcca

Autogenerated transformation function for Proj4 projection code lcca.

The full name for this projection is Lambert Conformal Conic Alternative.

Projection Parameters

=for options

=over 4

=item lat_0

=back

=cut

sub t_proj_lcca
    { 'PDL::Transform::Proj4::lcca'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_leac

Autogenerated transformation function for Proj4 projection code leac.

The full name for this projection is Lambert Equal Area Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=item south

=back

=cut

sub t_proj_leac
    { 'PDL::Transform::Proj4::leac'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lee_os

Autogenerated transformation function for Proj4 projection code lee_os.

The full name for this projection is Lee Oblated Stereographic.

=cut

sub t_proj_lee_os
    { 'PDL::Transform::Proj4::lee_os'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lonlat

Autogenerated transformation function for Proj4 projection code lonlat.

The full name for this projection is Lat/long (Geodetic).

=cut

sub t_proj_lonlat
    { 'PDL::Transform::Proj4::lonlat'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_loxim

Autogenerated transformation function for Proj4 projection code loxim.

The full name for this projection is Loximuthal.

=cut

sub t_proj_loxim
    { 'PDL::Transform::Proj4::loxim'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_lsat

Autogenerated transformation function for Proj4 projection code lsat.

The full name for this projection is Space oblique for LANDSAT.

Projection Parameters

=for options

=over 4

=item lsat

=item path

=back

=cut

sub t_proj_lsat
    { 'PDL::Transform::Proj4::lsat'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mbt_fps

Autogenerated transformation function for Proj4 projection code mbt_fps.

The full name for this projection is McBryde-Thomas Flat-Pole Sine (No. 2).

=cut

sub t_proj_mbt_fps
    { 'PDL::Transform::Proj4::mbt_fps'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mbt_s

Autogenerated transformation function for Proj4 projection code mbt_s.

The full name for this projection is McBryde-Thomas Flat-Polar Sine (No. 1).

=cut

sub t_proj_mbt_s
    { 'PDL::Transform::Proj4::mbt_s'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mbtfpp

Autogenerated transformation function for Proj4 projection code mbtfpp.

The full name for this projection is McBride-Thomas Flat-Polar Parabolic.

=cut

sub t_proj_mbtfpp
    { 'PDL::Transform::Proj4::mbtfpp'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mbtfpq

Autogenerated transformation function for Proj4 projection code mbtfpq.

The full name for this projection is McBryde-Thomas Flat-Polar Quartic.

=cut

sub t_proj_mbtfpq
    { 'PDL::Transform::Proj4::mbtfpq'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mbtfps

Autogenerated transformation function for Proj4 projection code mbtfps.

The full name for this projection is McBryde-Thomas Flat-Polar Sinusoidal.

=cut

sub t_proj_mbtfps
    { 'PDL::Transform::Proj4::mbtfps'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_merc

Autogenerated transformation function for Proj4 projection code merc.

The full name for this projection is Mercator.

Projection Parameters

=for options

=over 4

=item lat_ts

=back

=cut

sub t_proj_merc
    { 'PDL::Transform::Proj4::merc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mil_os

Autogenerated transformation function for Proj4 projection code mil_os.

The full name for this projection is Miller Oblated Stereographic.

=cut

sub t_proj_mil_os
    { 'PDL::Transform::Proj4::mil_os'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mill

Autogenerated transformation function for Proj4 projection code mill.

The full name for this projection is Miller Cylindrical.

=cut

sub t_proj_mill
    { 'PDL::Transform::Proj4::mill'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_misrsom

Autogenerated transformation function for Proj4 projection code misrsom.

The full name for this projection is Space oblique for MISR.

Projection Parameters

=for options

=over 4

=item path

=back

=cut

sub t_proj_misrsom
    { 'PDL::Transform::Proj4::misrsom'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_mod_krovak

Autogenerated transformation function for Proj4 projection code mod_krovak.

The full name for this projection is Modified Krovak.

=cut

sub t_proj_mod_krovak
    { 'PDL::Transform::Proj4::mod_krovak'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_moll

Autogenerated transformation function for Proj4 projection code moll.

The full name for this projection is Mollweide.

=cut

sub t_proj_moll
    { 'PDL::Transform::Proj4::moll'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_molobadekas

Autogenerated transformation function for Proj4 projection code molobadekas.

The full name for this projection is Molodensky-Badekas transformation.

=cut

sub t_proj_molobadekas
    { 'PDL::Transform::Proj4::molobadekas'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_molodensky

Autogenerated transformation function for Proj4 projection code molodensky.

The full name for this projection is Molodensky transform.

=cut

sub t_proj_molodensky
    { 'PDL::Transform::Proj4::molodensky'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_murd1

Autogenerated transformation function for Proj4 projection code murd1.

The full name for this projection is Murdoch I.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_murd1
    { 'PDL::Transform::Proj4::murd1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_murd2

Autogenerated transformation function for Proj4 projection code murd2.

The full name for this projection is Murdoch II.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_murd2
    { 'PDL::Transform::Proj4::murd2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_murd3

Autogenerated transformation function for Proj4 projection code murd3.

The full name for this projection is Murdoch III.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_murd3
    { 'PDL::Transform::Proj4::murd3'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_natearth

Autogenerated transformation function for Proj4 projection code natearth.

The full name for this projection is Natural Earth.

=cut

sub t_proj_natearth
    { 'PDL::Transform::Proj4::natearth'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_natearth2

Autogenerated transformation function for Proj4 projection code natearth2.

The full name for this projection is Natural Earth 2.

=cut

sub t_proj_natearth2
    { 'PDL::Transform::Proj4::natearth2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_nell

Autogenerated transformation function for Proj4 projection code nell.

The full name for this projection is Nell.

=cut

sub t_proj_nell
    { 'PDL::Transform::Proj4::nell'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_nell_h

Autogenerated transformation function for Proj4 projection code nell_h.

The full name for this projection is Nell-Hammer.

=cut

sub t_proj_nell_h
    { 'PDL::Transform::Proj4::nell_h'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_nicol

Autogenerated transformation function for Proj4 projection code nicol.

The full name for this projection is Nicolosi Globular.

=cut

sub t_proj_nicol
    { 'PDL::Transform::Proj4::nicol'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_noop

Autogenerated transformation function for Proj4 projection code noop.

The full name for this projection is No operation.

=cut

sub t_proj_noop
    { 'PDL::Transform::Proj4::noop'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_nsper

Autogenerated transformation function for Proj4 projection code nsper.

The full name for this projection is Near-sided perspective.

Projection Parameters

=for options

=over 4

=item h

=back

=cut

sub t_proj_nsper
    { 'PDL::Transform::Proj4::nsper'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_nzmg

Autogenerated transformation function for Proj4 projection code nzmg.

The full name for this projection is New Zealand Map Grid.

=cut

sub t_proj_nzmg
    { 'PDL::Transform::Proj4::nzmg'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_ob_tran

Autogenerated transformation function for Proj4 projection code ob_tran.

The full name for this projection is General Oblique Transformation.

Projection Parameters

=for options

=over 4

=item o_alpha

=item o_lat_1

=item o_lat_2

=item o_lat_c

=item o_lat_p

=item o_lon_1

=item o_lon_2

=item o_lon_c

=item o_lon_p

=item o_proj

=back

=cut

sub t_proj_ob_tran
    { 'PDL::Transform::Proj4::ob_tran'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_ocea

Autogenerated transformation function for Proj4 projection code ocea.

The full name for this projection is Oblique Cylindrical Equal Area.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lon_1

=item lon_2

=back

=cut

sub t_proj_ocea
    { 'PDL::Transform::Proj4::ocea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_oea

Autogenerated transformation function for Proj4 projection code oea.

The full name for this projection is Oblated Equal Area.

Projection Parameters

=for options

=over 4

=item m

=item n

=item theta

=back

=cut

sub t_proj_oea
    { 'PDL::Transform::Proj4::oea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_omerc

Autogenerated transformation function for Proj4 projection code omerc.

The full name for this projection is Oblique Mercator.

Projection Parameters

=for options

=over 4

=item alpha

=item gamma

=item lat_1

=item lat_2

=item lon_1

=item lon_2

=item lonc

=item no_off

=back

=cut

sub t_proj_omerc
    { 'PDL::Transform::Proj4::omerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_ortel

Autogenerated transformation function for Proj4 projection code ortel.

The full name for this projection is Ortelius Oval.

=cut

sub t_proj_ortel
    { 'PDL::Transform::Proj4::ortel'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_ortho

Autogenerated transformation function for Proj4 projection code ortho.

The full name for this projection is Orthographic.

=cut

sub t_proj_ortho
    { 'PDL::Transform::Proj4::ortho'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_patterson

Autogenerated transformation function for Proj4 projection code patterson.

The full name for this projection is Patterson Cylindrical.

=cut

sub t_proj_patterson
    { 'PDL::Transform::Proj4::patterson'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_pconic

Autogenerated transformation function for Proj4 projection code pconic.

The full name for this projection is Perspective Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_pconic
    { 'PDL::Transform::Proj4::pconic'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_peirce_q

Autogenerated transformation function for Proj4 projection code peirce_q.

The full name for this projection is Peirce Quincuncial.

=cut

sub t_proj_peirce_q
    { 'PDL::Transform::Proj4::peirce_q'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_pipeline

Autogenerated transformation function for Proj4 projection code pipeline.

The full name for this projection is Transformation pipeline manager.

=cut

sub t_proj_pipeline
    { 'PDL::Transform::Proj4::pipeline'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_poly

Autogenerated transformation function for Proj4 projection code poly.

The full name for this projection is Polyconic (American).

=cut

sub t_proj_poly
    { 'PDL::Transform::Proj4::poly'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_pop

Autogenerated transformation function for Proj4 projection code pop.

The full name for this projection is Retrieve coordinate value from pipeline stack.

=cut

sub t_proj_pop
    { 'PDL::Transform::Proj4::pop'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_push

Autogenerated transformation function for Proj4 projection code push.

The full name for this projection is Save coordinate value on pipeline stack.

=cut

sub t_proj_push
    { 'PDL::Transform::Proj4::push'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp1

Autogenerated transformation function for Proj4 projection code putp1.

The full name for this projection is Putnins P1.

=cut

sub t_proj_putp1
    { 'PDL::Transform::Proj4::putp1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp2

Autogenerated transformation function for Proj4 projection code putp2.

The full name for this projection is Putnins P2.

=cut

sub t_proj_putp2
    { 'PDL::Transform::Proj4::putp2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp3

Autogenerated transformation function for Proj4 projection code putp3.

The full name for this projection is Putnins P3.

=cut

sub t_proj_putp3
    { 'PDL::Transform::Proj4::putp3'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp3p

Autogenerated transformation function for Proj4 projection code putp3p.

The full name for this projection is Putnins P3'.

=cut

sub t_proj_putp3p
    { 'PDL::Transform::Proj4::putp3p'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp4p

Autogenerated transformation function for Proj4 projection code putp4p.

The full name for this projection is Putnins P4'.

=cut

sub t_proj_putp4p
    { 'PDL::Transform::Proj4::putp4p'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp5

Autogenerated transformation function for Proj4 projection code putp5.

The full name for this projection is Putnins P5.

=cut

sub t_proj_putp5
    { 'PDL::Transform::Proj4::putp5'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp5p

Autogenerated transformation function for Proj4 projection code putp5p.

The full name for this projection is Putnins P5'.

=cut

sub t_proj_putp5p
    { 'PDL::Transform::Proj4::putp5p'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp6

Autogenerated transformation function for Proj4 projection code putp6.

The full name for this projection is Putnins P6.

=cut

sub t_proj_putp6
    { 'PDL::Transform::Proj4::putp6'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_putp6p

Autogenerated transformation function for Proj4 projection code putp6p.

The full name for this projection is Putnins P6'.

=cut

sub t_proj_putp6p
    { 'PDL::Transform::Proj4::putp6p'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_qsc

Autogenerated transformation function for Proj4 projection code qsc.

The full name for this projection is Quadrilateralized Spherical Cube.

=cut

sub t_proj_qsc
    { 'PDL::Transform::Proj4::qsc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_qua_aut

Autogenerated transformation function for Proj4 projection code qua_aut.

The full name for this projection is Quartic Authalic.

=cut

sub t_proj_qua_aut
    { 'PDL::Transform::Proj4::qua_aut'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_rhealpix

Autogenerated transformation function for Proj4 projection code rhealpix.

The full name for this projection is rHEALPix.

Projection Parameters

=for options

=over 4

=item north_square

=item south_square

=back

=cut

sub t_proj_rhealpix
    { 'PDL::Transform::Proj4::rhealpix'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_robin

Autogenerated transformation function for Proj4 projection code robin.

The full name for this projection is Robinson.

=cut

sub t_proj_robin
    { 'PDL::Transform::Proj4::robin'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_rouss

Autogenerated transformation function for Proj4 projection code rouss.

The full name for this projection is Roussilhe Stereographic.

=cut

sub t_proj_rouss
    { 'PDL::Transform::Proj4::rouss'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_rpoly

Autogenerated transformation function for Proj4 projection code rpoly.

The full name for this projection is Rectangular Polyconic.

Projection Parameters

=for options

=over 4

=item lat_ts

=back

=cut

sub t_proj_rpoly
    { 'PDL::Transform::Proj4::rpoly'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_s2

Autogenerated transformation function for Proj4 projection code s2.

The full name for this projection is S2.

=cut

sub t_proj_s2
    { 'PDL::Transform::Proj4::s2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_sch

Autogenerated transformation function for Proj4 projection code sch.

The full name for this projection is Spherical Cross-track Height.

Projection Parameters

=for options

=over 4

=item h_0

=item phdg_0

=item plat_0

=item plon_0

=back

=cut

sub t_proj_sch
    { 'PDL::Transform::Proj4::sch'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_set

Autogenerated transformation function for Proj4 projection code set.

The full name for this projection is Set coordinate value.

=cut

sub t_proj_set
    { 'PDL::Transform::Proj4::set'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_sinu

Autogenerated transformation function for Proj4 projection code sinu.

The full name for this projection is Sinusoidal (Sanson-Flamsteed).

=cut

sub t_proj_sinu
    { 'PDL::Transform::Proj4::sinu'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_som

Autogenerated transformation function for Proj4 projection code som.

The full name for this projection is Space Oblique Mercator.

Projection Parameters

=for options

=over 4

=item asc_lon

=item inc_angle

=item ps_rev

=back

=cut

sub t_proj_som
    { 'PDL::Transform::Proj4::som'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_somerc

Autogenerated transformation function for Proj4 projection code somerc.

The full name for this projection is Swiss. Obl. Mercator.

=cut

sub t_proj_somerc
    { 'PDL::Transform::Proj4::somerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_stere

Autogenerated transformation function for Proj4 projection code stere.

The full name for this projection is Stereographic.

Projection Parameters

=for options

=over 4

=item lat_ts

=back

=cut

sub t_proj_stere
    { 'PDL::Transform::Proj4::stere'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_sterea

Autogenerated transformation function for Proj4 projection code sterea.

The full name for this projection is Oblique Stereographic Alternative.

=cut

sub t_proj_sterea
    { 'PDL::Transform::Proj4::sterea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tcc

Autogenerated transformation function for Proj4 projection code tcc.

The full name for this projection is Transverse Central Cylindrical.

=cut

sub t_proj_tcc
    { 'PDL::Transform::Proj4::tcc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tcea

Autogenerated transformation function for Proj4 projection code tcea.

The full name for this projection is Transverse Cylindrical Equal Area.

=cut

sub t_proj_tcea
    { 'PDL::Transform::Proj4::tcea'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_times

Autogenerated transformation function for Proj4 projection code times.

The full name for this projection is Times.

=cut

sub t_proj_times
    { 'PDL::Transform::Proj4::times'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tinshift

Autogenerated transformation function for Proj4 projection code tinshift.

The full name for this projection is Triangulation based transformation.

=cut

sub t_proj_tinshift
    { 'PDL::Transform::Proj4::tinshift'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tissot

Autogenerated transformation function for Proj4 projection code tissot.

The full name for this projection is Tissot.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_tissot
    { 'PDL::Transform::Proj4::tissot'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tmerc

Autogenerated transformation function for Proj4 projection code tmerc.

The full name for this projection is Transverse Mercator.

Projection Parameters

=for options

=over 4

=item approx

=back

=cut

sub t_proj_tmerc
    { 'PDL::Transform::Proj4::tmerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tobmerc

Autogenerated transformation function for Proj4 projection code tobmerc.

The full name for this projection is Tobler-Mercator.

=cut

sub t_proj_tobmerc
    { 'PDL::Transform::Proj4::tobmerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_topocentric

Autogenerated transformation function for Proj4 projection code topocentric.

The full name for this projection is Geocentric/Topocentric conversion.

=cut

sub t_proj_topocentric
    { 'PDL::Transform::Proj4::topocentric'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tpeqd

Autogenerated transformation function for Proj4 projection code tpeqd.

The full name for this projection is Two Point Equidistant.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lon_1

=item lon_2

=back

=cut

sub t_proj_tpeqd
    { 'PDL::Transform::Proj4::tpeqd'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_tpers

Autogenerated transformation function for Proj4 projection code tpers.

The full name for this projection is Tilted perspective.

Projection Parameters

=for options

=over 4

=item azi

=item h

=item tilt

=back

=cut

sub t_proj_tpers
    { 'PDL::Transform::Proj4::tpers'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_unitconvert

Autogenerated transformation function for Proj4 projection code unitconvert.

The full name for this projection is Unit conversion.

=cut

sub t_proj_unitconvert
    { 'PDL::Transform::Proj4::unitconvert'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_ups

Autogenerated transformation function for Proj4 projection code ups.

The full name for this projection is Universal Polar Stereographic.

Projection Parameters

=for options

=over 4

=item south

=back

=cut

sub t_proj_ups
    { 'PDL::Transform::Proj4::ups'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_urm5

Autogenerated transformation function for Proj4 projection code urm5.

The full name for this projection is Urmaev V.

Projection Parameters

=for options

=over 4

=item alpha

=item n

=item q

=back

=cut

sub t_proj_urm5
    { 'PDL::Transform::Proj4::urm5'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_urmfps

Autogenerated transformation function for Proj4 projection code urmfps.

The full name for this projection is Urmaev Flat-Polar Sinusoidal.

Projection Parameters

=for options

=over 4

=item n

=back

=cut

sub t_proj_urmfps
    { 'PDL::Transform::Proj4::urmfps'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_utm

Autogenerated transformation function for Proj4 projection code utm.

The full name for this projection is Universal Transverse Mercator (UTM).

Projection Parameters

=for options

=over 4

=item approx

=item south

=item zone

=back

=cut

sub t_proj_utm
    { 'PDL::Transform::Proj4::utm'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vandg

Autogenerated transformation function for Proj4 projection code vandg.

The full name for this projection is van der Grinten (I).

=cut

sub t_proj_vandg
    { 'PDL::Transform::Proj4::vandg'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vandg2

Autogenerated transformation function for Proj4 projection code vandg2.

The full name for this projection is van der Grinten II.

=cut

sub t_proj_vandg2
    { 'PDL::Transform::Proj4::vandg2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vandg3

Autogenerated transformation function for Proj4 projection code vandg3.

The full name for this projection is van der Grinten III.

=cut

sub t_proj_vandg3
    { 'PDL::Transform::Proj4::vandg3'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vandg4

Autogenerated transformation function for Proj4 projection code vandg4.

The full name for this projection is van der Grinten IV.

=cut

sub t_proj_vandg4
    { 'PDL::Transform::Proj4::vandg4'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vertoffset

Autogenerated transformation function for Proj4 projection code vertoffset.

The full name for this projection is Vertical Offset and Slope.

Projection Parameters

=for options

=over 4

=item dh

=item lat_0

=item lon_0

=item slope_lat

=item slope_lon

=back

=cut

sub t_proj_vertoffset
    { 'PDL::Transform::Proj4::vertoffset'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vgridshift

Autogenerated transformation function for Proj4 projection code vgridshift.

The full name for this projection is Vertical grid shift.

=cut

sub t_proj_vgridshift
    { 'PDL::Transform::Proj4::vgridshift'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_vitk1

Autogenerated transformation function for Proj4 projection code vitk1.

The full name for this projection is Vitkovsky I.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back

=cut

sub t_proj_vitk1
    { 'PDL::Transform::Proj4::vitk1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag1

Autogenerated transformation function for Proj4 projection code wag1.

The full name for this projection is Wagner I (Kavrayskiy VI).

=cut

sub t_proj_wag1
    { 'PDL::Transform::Proj4::wag1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag2

Autogenerated transformation function for Proj4 projection code wag2.

The full name for this projection is Wagner II.

=cut

sub t_proj_wag2
    { 'PDL::Transform::Proj4::wag2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag3

Autogenerated transformation function for Proj4 projection code wag3.

The full name for this projection is Wagner III.

Projection Parameters

=for options

=over 4

=item lat_ts

=back

=cut

sub t_proj_wag3
    { 'PDL::Transform::Proj4::wag3'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag4

Autogenerated transformation function for Proj4 projection code wag4.

The full name for this projection is Wagner IV.

=cut

sub t_proj_wag4
    { 'PDL::Transform::Proj4::wag4'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag5

Autogenerated transformation function for Proj4 projection code wag5.

The full name for this projection is Wagner V.

=cut

sub t_proj_wag5
    { 'PDL::Transform::Proj4::wag5'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag6

Autogenerated transformation function for Proj4 projection code wag6.

The full name for this projection is Wagner VI.

=cut

sub t_proj_wag6
    { 'PDL::Transform::Proj4::wag6'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wag7

Autogenerated transformation function for Proj4 projection code wag7.

The full name for this projection is Wagner VII.

=cut

sub t_proj_wag7
    { 'PDL::Transform::Proj4::wag7'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_webmerc

Autogenerated transformation function for Proj4 projection code webmerc.

The full name for this projection is Web Mercator / Pseudo Mercator.

=cut

sub t_proj_webmerc
    { 'PDL::Transform::Proj4::webmerc'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_weren

Autogenerated transformation function for Proj4 projection code weren.

The full name for this projection is Werenskiold I.

=cut

sub t_proj_weren
    { 'PDL::Transform::Proj4::weren'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wink1

Autogenerated transformation function for Proj4 projection code wink1.

The full name for this projection is Winkel I.

Projection Parameters

=for options

=over 4

=item lat_ts

=back

=cut

sub t_proj_wink1
    { 'PDL::Transform::Proj4::wink1'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wink2

Autogenerated transformation function for Proj4 projection code wink2.

The full name for this projection is Winkel II.

Projection Parameters

=for options

=over 4

=item lat_1

=back

=cut

sub t_proj_wink2
    { 'PDL::Transform::Proj4::wink2'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_wintri

Autogenerated transformation function for Proj4 projection code wintri.

The full name for this projection is Winkel Tripel.

Projection Parameters

=for options

=over 4

=item lat_1

=back

=cut

sub t_proj_wintri
    { 'PDL::Transform::Proj4::wintri'->new( @_ ); }
#line 634 "proj4.pd"

=head2 t_proj_xyzgridshift

Autogenerated transformation function for Proj4 projection code xyzgridshift.

The full name for this projection is Geocentric grid shift.

=cut

sub t_proj_xyzgridshift
    { 'PDL::Transform::Proj4::xyzgridshift'->new( @_ ); }
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    adams_hemi
#
package # hide from PAUSE
  PDL::Transform::Proj4::adams_hemi;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::adams_hemi::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Adams Hemisphere in a Square";
    $self->{proj_code} = "adams_hemi";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::adams_hemi::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    adams_ws1
#
package # hide from PAUSE
  PDL::Transform::Proj4::adams_ws1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::adams_ws1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Adams World in a Square I";
    $self->{proj_code} = "adams_ws1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::adams_ws1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    adams_ws2
#
package # hide from PAUSE
  PDL::Transform::Proj4::adams_ws2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::adams_ws2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Adams World in a Square II";
    $self->{proj_code} = "adams_ws2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::adams_ws2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    aea
#
package # hide from PAUSE
  PDL::Transform::Proj4::aea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::aea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Albers Equal Area";
    $self->{proj_code} = "aea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::aea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    aeqd
#
package # hide from PAUSE
  PDL::Transform::Proj4::aeqd;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::aeqd::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Azimuthal Equidistant";
    $self->{proj_code} = "aeqd";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 guam ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::aeqd::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    affine
#
package # hide from PAUSE
  PDL::Transform::Proj4::affine;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::affine::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Affine transformation";
    $self->{proj_code} = "affine";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::affine::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    airy
#
package # hide from PAUSE
  PDL::Transform::Proj4::airy;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::airy::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Airy";
    $self->{proj_code} = "airy";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( no_cut lat_b ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::airy::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    aitoff
#
package # hide from PAUSE
  PDL::Transform::Proj4::aitoff;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::aitoff::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Aitoff";
    $self->{proj_code} = "aitoff";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::aitoff::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    alsk
#
package # hide from PAUSE
  PDL::Transform::Proj4::alsk;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::alsk::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Modified Stereographic of Alaska";
    $self->{proj_code} = "alsk";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::alsk::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    apian
#
package # hide from PAUSE
  PDL::Transform::Proj4::apian;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::apian::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Apian Globular I";
    $self->{proj_code} = "apian";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::apian::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    august
#
package # hide from PAUSE
  PDL::Transform::Proj4::august;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::august::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "August Epicycloidal";
    $self->{proj_code} = "august";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::august::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    axisswap
#
package # hide from PAUSE
  PDL::Transform::Proj4::axisswap;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::axisswap::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Axis ordering";
    $self->{proj_code} = "axisswap";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::axisswap::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    bacon
#
package # hide from PAUSE
  PDL::Transform::Proj4::bacon;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bacon::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Bacon Globular";
    $self->{proj_code} = "bacon";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::bacon::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    bertin1953
#
package # hide from PAUSE
  PDL::Transform::Proj4::bertin1953;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bertin1953::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Bertin 1953";
    $self->{proj_code} = "bertin1953";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::bertin1953::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    bipc
#
package # hide from PAUSE
  PDL::Transform::Proj4::bipc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bipc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Bipolar conic of western hemisphere";
    $self->{proj_code} = "bipc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::bipc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    boggs
#
package # hide from PAUSE
  PDL::Transform::Proj4::boggs;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::boggs::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Boggs Eumorphic";
    $self->{proj_code} = "boggs";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::boggs::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    bonne
#
package # hide from PAUSE
  PDL::Transform::Proj4::bonne;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bonne::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Bonne (Werner lat_1=90)";
    $self->{proj_code} = "bonne";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::bonne::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    calcofi
#
package # hide from PAUSE
  PDL::Transform::Proj4::calcofi;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::calcofi::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Cal Coop Ocean Fish Invest Lines/Stations";
    $self->{proj_code} = "calcofi";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::calcofi::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    cart
#
package # hide from PAUSE
  PDL::Transform::Proj4::cart;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cart::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Geodetic/cartesian conversions";
    $self->{proj_code} = "cart";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::cart::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    cass
#
package # hide from PAUSE
  PDL::Transform::Proj4::cass;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cass::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Cassini";
    $self->{proj_code} = "cass";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::cass::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    cc
#
package # hide from PAUSE
  PDL::Transform::Proj4::cc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Central Cylindrical";
    $self->{proj_code} = "cc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::cc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    ccon
#
package # hide from PAUSE
  PDL::Transform::Proj4::ccon;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ccon::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Central Conic";
    $self->{proj_code} = "ccon";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::ccon::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    cea
#
package # hide from PAUSE
  PDL::Transform::Proj4::cea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Equal Area Cylindrical";
    $self->{proj_code} = "cea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::cea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    chamb
#
package # hide from PAUSE
  PDL::Transform::Proj4::chamb;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::chamb::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Chamberlin Trimetric";
    $self->{proj_code} = "chamb";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lon_1 lat_2 lon_2 lat_3 lon_3 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::chamb::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    col_urban
#
package # hide from PAUSE
  PDL::Transform::Proj4::col_urban;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::col_urban::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Colombia Urban";
    $self->{proj_code} = "col_urban";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( h_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::col_urban::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    collg
#
package # hide from PAUSE
  PDL::Transform::Proj4::collg;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::collg::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Collignon";
    $self->{proj_code} = "collg";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::collg::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    comill
#
package # hide from PAUSE
  PDL::Transform::Proj4::comill;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::comill::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Compact Miller";
    $self->{proj_code} = "comill";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::comill::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    crast
#
package # hide from PAUSE
  PDL::Transform::Proj4::crast;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::crast::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Craster Parabolic (Putnins P4)";
    $self->{proj_code} = "crast";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::crast::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    defmodel
#
package # hide from PAUSE
  PDL::Transform::Proj4::defmodel;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::defmodel::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Deformation model";
    $self->{proj_code} = "defmodel";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::defmodel::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    deformation
#
package # hide from PAUSE
  PDL::Transform::Proj4::deformation;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::deformation::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Kinematic grid shift";
    $self->{proj_code} = "deformation";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::deformation::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    denoy
#
package # hide from PAUSE
  PDL::Transform::Proj4::denoy;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::denoy::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Denoyer Semi-Elliptical";
    $self->{proj_code} = "denoy";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::denoy::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eck1
#
package # hide from PAUSE
  PDL::Transform::Proj4::eck1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Eckert I";
    $self->{proj_code} = "eck1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eck1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eck2
#
package # hide from PAUSE
  PDL::Transform::Proj4::eck2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Eckert II";
    $self->{proj_code} = "eck2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eck2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eck3
#
package # hide from PAUSE
  PDL::Transform::Proj4::eck3;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Eckert III";
    $self->{proj_code} = "eck3";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eck3::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eck4
#
package # hide from PAUSE
  PDL::Transform::Proj4::eck4;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Eckert IV";
    $self->{proj_code} = "eck4";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eck4::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eck5
#
package # hide from PAUSE
  PDL::Transform::Proj4::eck5;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Eckert V";
    $self->{proj_code} = "eck5";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eck5::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eck6
#
package # hide from PAUSE
  PDL::Transform::Proj4::eck6;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck6::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Eckert VI";
    $self->{proj_code} = "eck6";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eck6::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eqc
#
package # hide from PAUSE
  PDL::Transform::Proj4::eqc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eqc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Equidistant Cylindrical (Plate Carree)";
    $self->{proj_code} = "eqc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts lat_00 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eqc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eqdc
#
package # hide from PAUSE
  PDL::Transform::Proj4::eqdc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eqdc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Equidistant Conic";
    $self->{proj_code} = "eqdc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eqdc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    eqearth
#
package # hide from PAUSE
  PDL::Transform::Proj4::eqearth;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eqearth::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Equal Earth";
    $self->{proj_code} = "eqearth";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::eqearth::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    etmerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::etmerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::etmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Extended Transverse Mercator";
    $self->{proj_code} = "etmerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::etmerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    euler
#
package # hide from PAUSE
  PDL::Transform::Proj4::euler;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::euler::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Euler";
    $self->{proj_code} = "euler";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::euler::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    fahey
#
package # hide from PAUSE
  PDL::Transform::Proj4::fahey;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::fahey::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Fahey";
    $self->{proj_code} = "fahey";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::fahey::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    fouc
#
package # hide from PAUSE
  PDL::Transform::Proj4::fouc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::fouc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Foucaut";
    $self->{proj_code} = "fouc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::fouc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    fouc_s
#
package # hide from PAUSE
  PDL::Transform::Proj4::fouc_s;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::fouc_s::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Foucaut Sinusoidal";
    $self->{proj_code} = "fouc_s";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::fouc_s::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gall
#
package # hide from PAUSE
  PDL::Transform::Proj4::gall;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gall::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Gall (Gall Stereographic)";
    $self->{proj_code} = "gall";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gall::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    geoc
#
package # hide from PAUSE
  PDL::Transform::Proj4::geoc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::geoc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Geocentric Latitude";
    $self->{proj_code} = "geoc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::geoc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    geogoffset
#
package # hide from PAUSE
  PDL::Transform::Proj4::geogoffset;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::geogoffset::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Geographic Offset";
    $self->{proj_code} = "geogoffset";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::geogoffset::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    geos
#
package # hide from PAUSE
  PDL::Transform::Proj4::geos;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::geos::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Geostationary Satellite View";
    $self->{proj_code} = "geos";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( h ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::geos::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gins8
#
package # hide from PAUSE
  PDL::Transform::Proj4::gins8;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gins8::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Ginsburg VIII (TsNIIGAiK)";
    $self->{proj_code} = "gins8";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gins8::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gn_sinu
#
package # hide from PAUSE
  PDL::Transform::Proj4::gn_sinu;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gn_sinu::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "General Sinusoidal Series";
    $self->{proj_code} = "gn_sinu";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( m n ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gn_sinu::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gnom
#
package # hide from PAUSE
  PDL::Transform::Proj4::gnom;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gnom::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Gnomonic";
    $self->{proj_code} = "gnom";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gnom::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    goode
#
package # hide from PAUSE
  PDL::Transform::Proj4::goode;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::goode::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Goode Homolosine";
    $self->{proj_code} = "goode";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::goode::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gridshift
#
package # hide from PAUSE
  PDL::Transform::Proj4::gridshift;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gridshift::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Generic grid shift";
    $self->{proj_code} = "gridshift";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gridshift::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gs48
#
package # hide from PAUSE
  PDL::Transform::Proj4::gs48;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gs48::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Modified Stereographic of 48 U.S.";
    $self->{proj_code} = "gs48";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gs48::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gs50
#
package # hide from PAUSE
  PDL::Transform::Proj4::gs50;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gs50::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Modified Stereographic of 50 U.S.";
    $self->{proj_code} = "gs50";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gs50::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    gstmerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::gstmerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gstmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Gauss-Schreiber Transverse Mercator (aka Gauss-Laborde Reunion)";
    $self->{proj_code} = "gstmerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 lon_0 k_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::gstmerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    guyou
#
package # hide from PAUSE
  PDL::Transform::Proj4::guyou;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::guyou::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Guyou";
    $self->{proj_code} = "guyou";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::guyou::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    hammer
#
package # hide from PAUSE
  PDL::Transform::Proj4::hammer;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::hammer::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Hammer & Eckert-Greifendorff";
    $self->{proj_code} = "hammer";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( W M ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::hammer::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    hatano
#
package # hide from PAUSE
  PDL::Transform::Proj4::hatano;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::hatano::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Hatano Asymmetrical Equal Area";
    $self->{proj_code} = "hatano";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::hatano::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    healpix
#
package # hide from PAUSE
  PDL::Transform::Proj4::healpix;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::healpix::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "HEALPix";
    $self->{proj_code} = "healpix";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( rot_xy ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::healpix::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    helmert
#
package # hide from PAUSE
  PDL::Transform::Proj4::helmert;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::helmert::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "3(6)-, 4(8)- and 7(14)-parameter Helmert shift";
    $self->{proj_code} = "helmert";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::helmert::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    hgridshift
#
package # hide from PAUSE
  PDL::Transform::Proj4::hgridshift;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::hgridshift::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Horizontal grid shift";
    $self->{proj_code} = "hgridshift";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::hgridshift::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    horner
#
package # hide from PAUSE
  PDL::Transform::Proj4::horner;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::horner::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Horner polynomial evaluation";
    $self->{proj_code} = "horner";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::horner::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    igh
#
package # hide from PAUSE
  PDL::Transform::Proj4::igh;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::igh::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Interrupted Goode Homolosine";
    $self->{proj_code} = "igh";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::igh::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    igh_o
#
package # hide from PAUSE
  PDL::Transform::Proj4::igh_o;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::igh_o::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Interrupted Goode Homolosine Oceanic View";
    $self->{proj_code} = "igh_o";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::igh_o::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    imoll
#
package # hide from PAUSE
  PDL::Transform::Proj4::imoll;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::imoll::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Interrupted Mollweide";
    $self->{proj_code} = "imoll";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::imoll::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    imoll_o
#
package # hide from PAUSE
  PDL::Transform::Proj4::imoll_o;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::imoll_o::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Interrupted Mollweide Oceanic View";
    $self->{proj_code} = "imoll_o";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::imoll_o::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    imw_p
#
package # hide from PAUSE
  PDL::Transform::Proj4::imw_p;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::imw_p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "International Map of the World Polyconic";
    $self->{proj_code} = "imw_p";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 lon_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::imw_p::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    isea
#
package # hide from PAUSE
  PDL::Transform::Proj4::isea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::isea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Icosahedral Snyder Equal Area";
    $self->{proj_code} = "isea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::isea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    kav5
#
package # hide from PAUSE
  PDL::Transform::Proj4::kav5;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::kav5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Kavrayskiy V";
    $self->{proj_code} = "kav5";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::kav5::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    kav7
#
package # hide from PAUSE
  PDL::Transform::Proj4::kav7;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::kav7::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Kavrayskiy VII";
    $self->{proj_code} = "kav7";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::kav7::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    krovak
#
package # hide from PAUSE
  PDL::Transform::Proj4::krovak;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::krovak::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Krovak";
    $self->{proj_code} = "krovak";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::krovak::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    labrd
#
package # hide from PAUSE
  PDL::Transform::Proj4::labrd;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::labrd::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Laborde";
    $self->{proj_code} = "labrd";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::labrd::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    laea
#
package # hide from PAUSE
  PDL::Transform::Proj4::laea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::laea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lambert Azimuthal Equal Area";
    $self->{proj_code} = "laea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::laea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lagrng
#
package # hide from PAUSE
  PDL::Transform::Proj4::lagrng;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lagrng::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lagrange";
    $self->{proj_code} = "lagrng";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( W ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lagrng::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    larr
#
package # hide from PAUSE
  PDL::Transform::Proj4::larr;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::larr::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Larrivee";
    $self->{proj_code} = "larr";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::larr::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lask
#
package # hide from PAUSE
  PDL::Transform::Proj4::lask;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lask::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Laskowski";
    $self->{proj_code} = "lask";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lask::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    latlon
#
package # hide from PAUSE
  PDL::Transform::Proj4::latlon;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::latlon::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lat/long (Geodetic alias)";
    $self->{proj_code} = "latlon";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::latlon::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lcc
#
package # hide from PAUSE
  PDL::Transform::Proj4::lcc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lcc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lambert Conformal Conic";
    $self->{proj_code} = "lcc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 lat_0 k_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lcc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lcca
#
package # hide from PAUSE
  PDL::Transform::Proj4::lcca;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lcca::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lambert Conformal Conic Alternative";
    $self->{proj_code} = "lcca";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lcca::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    leac
#
package # hide from PAUSE
  PDL::Transform::Proj4::leac;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::leac::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lambert Equal Area Conic";
    $self->{proj_code} = "leac";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 south ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::leac::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lee_os
#
package # hide from PAUSE
  PDL::Transform::Proj4::lee_os;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lee_os::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lee Oblated Stereographic";
    $self->{proj_code} = "lee_os";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lee_os::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lonlat
#
package # hide from PAUSE
  PDL::Transform::Proj4::lonlat;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lonlat::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Lat/long (Geodetic)";
    $self->{proj_code} = "lonlat";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lonlat::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    loxim
#
package # hide from PAUSE
  PDL::Transform::Proj4::loxim;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::loxim::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Loximuthal";
    $self->{proj_code} = "loxim";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::loxim::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    lsat
#
package # hide from PAUSE
  PDL::Transform::Proj4::lsat;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lsat::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Space oblique for LANDSAT";
    $self->{proj_code} = "lsat";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lsat path ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::lsat::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mbt_fps
#
package # hide from PAUSE
  PDL::Transform::Proj4::mbt_fps;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbt_fps::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "McBryde-Thomas Flat-Pole Sine (No. 2)";
    $self->{proj_code} = "mbt_fps";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mbt_fps::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mbt_s
#
package # hide from PAUSE
  PDL::Transform::Proj4::mbt_s;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbt_s::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "McBryde-Thomas Flat-Polar Sine (No. 1)";
    $self->{proj_code} = "mbt_s";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mbt_s::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mbtfpp
#
package # hide from PAUSE
  PDL::Transform::Proj4::mbtfpp;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbtfpp::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "McBride-Thomas Flat-Polar Parabolic";
    $self->{proj_code} = "mbtfpp";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mbtfpp::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mbtfpq
#
package # hide from PAUSE
  PDL::Transform::Proj4::mbtfpq;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbtfpq::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "McBryde-Thomas Flat-Polar Quartic";
    $self->{proj_code} = "mbtfpq";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mbtfpq::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mbtfps
#
package # hide from PAUSE
  PDL::Transform::Proj4::mbtfps;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbtfps::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "McBryde-Thomas Flat-Polar Sinusoidal";
    $self->{proj_code} = "mbtfps";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mbtfps::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    merc
#
package # hide from PAUSE
  PDL::Transform::Proj4::merc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::merc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Mercator";
    $self->{proj_code} = "merc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::merc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mil_os
#
package # hide from PAUSE
  PDL::Transform::Proj4::mil_os;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mil_os::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Miller Oblated Stereographic";
    $self->{proj_code} = "mil_os";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mil_os::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mill
#
package # hide from PAUSE
  PDL::Transform::Proj4::mill;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mill::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Miller Cylindrical";
    $self->{proj_code} = "mill";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mill::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    misrsom
#
package # hide from PAUSE
  PDL::Transform::Proj4::misrsom;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::misrsom::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Space oblique for MISR";
    $self->{proj_code} = "misrsom";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( path ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::misrsom::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    mod_krovak
#
package # hide from PAUSE
  PDL::Transform::Proj4::mod_krovak;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mod_krovak::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Modified Krovak";
    $self->{proj_code} = "mod_krovak";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::mod_krovak::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    moll
#
package # hide from PAUSE
  PDL::Transform::Proj4::moll;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::moll::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Mollweide";
    $self->{proj_code} = "moll";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::moll::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    molobadekas
#
package # hide from PAUSE
  PDL::Transform::Proj4::molobadekas;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::molobadekas::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Molodensky-Badekas transformation";
    $self->{proj_code} = "molobadekas";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::molobadekas::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    molodensky
#
package # hide from PAUSE
  PDL::Transform::Proj4::molodensky;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::molodensky::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Molodensky transform";
    $self->{proj_code} = "molodensky";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::molodensky::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    murd1
#
package # hide from PAUSE
  PDL::Transform::Proj4::murd1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::murd1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Murdoch I";
    $self->{proj_code} = "murd1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::murd1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    murd2
#
package # hide from PAUSE
  PDL::Transform::Proj4::murd2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::murd2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Murdoch II";
    $self->{proj_code} = "murd2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::murd2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    murd3
#
package # hide from PAUSE
  PDL::Transform::Proj4::murd3;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::murd3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Murdoch III";
    $self->{proj_code} = "murd3";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::murd3::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    natearth
#
package # hide from PAUSE
  PDL::Transform::Proj4::natearth;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::natearth::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Natural Earth";
    $self->{proj_code} = "natearth";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::natearth::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    natearth2
#
package # hide from PAUSE
  PDL::Transform::Proj4::natearth2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::natearth2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Natural Earth 2";
    $self->{proj_code} = "natearth2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::natearth2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    nell
#
package # hide from PAUSE
  PDL::Transform::Proj4::nell;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nell::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Nell";
    $self->{proj_code} = "nell";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::nell::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    nell_h
#
package # hide from PAUSE
  PDL::Transform::Proj4::nell_h;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nell_h::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Nell-Hammer";
    $self->{proj_code} = "nell_h";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::nell_h::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    nicol
#
package # hide from PAUSE
  PDL::Transform::Proj4::nicol;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nicol::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Nicolosi Globular";
    $self->{proj_code} = "nicol";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::nicol::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    noop
#
package # hide from PAUSE
  PDL::Transform::Proj4::noop;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::noop::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "No operation";
    $self->{proj_code} = "noop";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::noop::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    nsper
#
package # hide from PAUSE
  PDL::Transform::Proj4::nsper;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nsper::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Near-sided perspective";
    $self->{proj_code} = "nsper";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( h ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::nsper::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    nzmg
#
package # hide from PAUSE
  PDL::Transform::Proj4::nzmg;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nzmg::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "New Zealand Map Grid";
    $self->{proj_code} = "nzmg";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::nzmg::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    ob_tran
#
package # hide from PAUSE
  PDL::Transform::Proj4::ob_tran;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ob_tran::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "General Oblique Transformation";
    $self->{proj_code} = "ob_tran";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( o_proj o_lat_p o_lon_p o_alpha o_lon_c o_lat_c o_lon_1 o_lat_1 o_lon_2 o_lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::ob_tran::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    ocea
#
package # hide from PAUSE
  PDL::Transform::Proj4::ocea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ocea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Oblique Cylindrical Equal Area";
    $self->{proj_code} = "ocea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 lon_1 lon_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::ocea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    oea
#
package # hide from PAUSE
  PDL::Transform::Proj4::oea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::oea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Oblated Equal Area";
    $self->{proj_code} = "oea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( n m theta ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::oea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    omerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::omerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::omerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Oblique Mercator";
    $self->{proj_code} = "omerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( alpha gamma no_off lonc lon_1 lat_1 lon_2 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::omerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    ortel
#
package # hide from PAUSE
  PDL::Transform::Proj4::ortel;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ortel::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Ortelius Oval";
    $self->{proj_code} = "ortel";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::ortel::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    ortho
#
package # hide from PAUSE
  PDL::Transform::Proj4::ortho;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ortho::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Orthographic";
    $self->{proj_code} = "ortho";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::ortho::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    patterson
#
package # hide from PAUSE
  PDL::Transform::Proj4::patterson;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::patterson::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Patterson Cylindrical";
    $self->{proj_code} = "patterson";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::patterson::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    pconic
#
package # hide from PAUSE
  PDL::Transform::Proj4::pconic;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::pconic::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Perspective Conic";
    $self->{proj_code} = "pconic";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::pconic::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    peirce_q
#
package # hide from PAUSE
  PDL::Transform::Proj4::peirce_q;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::peirce_q::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Peirce Quincuncial";
    $self->{proj_code} = "peirce_q";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::peirce_q::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    pipeline
#
package # hide from PAUSE
  PDL::Transform::Proj4::pipeline;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::pipeline::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Transformation pipeline manager";
    $self->{proj_code} = "pipeline";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::pipeline::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    poly
#
package # hide from PAUSE
  PDL::Transform::Proj4::poly;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::poly::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Polyconic (American)";
    $self->{proj_code} = "poly";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::poly::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    pop
#
package # hide from PAUSE
  PDL::Transform::Proj4::pop;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::pop::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Retrieve coordinate value from pipeline stack";
    $self->{proj_code} = "pop";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::pop::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    push
#
package # hide from PAUSE
  PDL::Transform::Proj4::push;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::push::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Save coordinate value on pipeline stack";
    $self->{proj_code} = "push";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::push::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp1
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P1";
    $self->{proj_code} = "putp1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp2
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P2";
    $self->{proj_code} = "putp2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp3
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp3;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P3";
    $self->{proj_code} = "putp3";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp3::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp3p
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp3p;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp3p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P3'";
    $self->{proj_code} = "putp3p";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp3p::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp4p
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp4p;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp4p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P4'";
    $self->{proj_code} = "putp4p";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp4p::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp5
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp5;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P5";
    $self->{proj_code} = "putp5";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp5::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp5p
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp5p;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp5p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P5'";
    $self->{proj_code} = "putp5p";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp5p::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp6
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp6;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp6::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P6";
    $self->{proj_code} = "putp6";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp6::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    putp6p
#
package # hide from PAUSE
  PDL::Transform::Proj4::putp6p;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp6p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Putnins P6'";
    $self->{proj_code} = "putp6p";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::putp6p::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    qsc
#
package # hide from PAUSE
  PDL::Transform::Proj4::qsc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::qsc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Quadrilateralized Spherical Cube";
    $self->{proj_code} = "qsc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::qsc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    qua_aut
#
package # hide from PAUSE
  PDL::Transform::Proj4::qua_aut;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::qua_aut::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Quartic Authalic";
    $self->{proj_code} = "qua_aut";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::qua_aut::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    rhealpix
#
package # hide from PAUSE
  PDL::Transform::Proj4::rhealpix;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::rhealpix::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "rHEALPix";
    $self->{proj_code} = "rhealpix";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( north_square south_square ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::rhealpix::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    robin
#
package # hide from PAUSE
  PDL::Transform::Proj4::robin;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::robin::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Robinson";
    $self->{proj_code} = "robin";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::robin::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    rouss
#
package # hide from PAUSE
  PDL::Transform::Proj4::rouss;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::rouss::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Roussilhe Stereographic";
    $self->{proj_code} = "rouss";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::rouss::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    rpoly
#
package # hide from PAUSE
  PDL::Transform::Proj4::rpoly;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::rpoly::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Rectangular Polyconic";
    $self->{proj_code} = "rpoly";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::rpoly::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    s2
#
package # hide from PAUSE
  PDL::Transform::Proj4::s2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::s2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "S2";
    $self->{proj_code} = "s2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::s2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    sch
#
package # hide from PAUSE
  PDL::Transform::Proj4::sch;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::sch::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Spherical Cross-track Height";
    $self->{proj_code} = "sch";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( plat_0 plon_0 phdg_0 h_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::sch::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    set
#
package # hide from PAUSE
  PDL::Transform::Proj4::set;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::set::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Set coordinate value";
    $self->{proj_code} = "set";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::set::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    sinu
#
package # hide from PAUSE
  PDL::Transform::Proj4::sinu;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::sinu::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Sinusoidal (Sanson-Flamsteed)";
    $self->{proj_code} = "sinu";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::sinu::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    som
#
package # hide from PAUSE
  PDL::Transform::Proj4::som;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::som::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Space Oblique Mercator";
    $self->{proj_code} = "som";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( inc_angle ps_rev asc_lon ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::som::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    somerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::somerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::somerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Swiss. Obl. Mercator";
    $self->{proj_code} = "somerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::somerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    stere
#
package # hide from PAUSE
  PDL::Transform::Proj4::stere;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::stere::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Stereographic";
    $self->{proj_code} = "stere";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::stere::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    sterea
#
package # hide from PAUSE
  PDL::Transform::Proj4::sterea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::sterea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Oblique Stereographic Alternative";
    $self->{proj_code} = "sterea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::sterea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tcc
#
package # hide from PAUSE
  PDL::Transform::Proj4::tcc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tcc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Transverse Central Cylindrical";
    $self->{proj_code} = "tcc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tcc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tcea
#
package # hide from PAUSE
  PDL::Transform::Proj4::tcea;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tcea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Transverse Cylindrical Equal Area";
    $self->{proj_code} = "tcea";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tcea::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    times
#
package # hide from PAUSE
  PDL::Transform::Proj4::times;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::times::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Times";
    $self->{proj_code} = "times";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::times::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tinshift
#
package # hide from PAUSE
  PDL::Transform::Proj4::tinshift;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tinshift::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Triangulation based transformation";
    $self->{proj_code} = "tinshift";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tinshift::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tissot
#
package # hide from PAUSE
  PDL::Transform::Proj4::tissot;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tissot::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Tissot";
    $self->{proj_code} = "tissot";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tissot::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tmerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::tmerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Transverse Mercator";
    $self->{proj_code} = "tmerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( approx ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tmerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tobmerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::tobmerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tobmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Tobler-Mercator";
    $self->{proj_code} = "tobmerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tobmerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    topocentric
#
package # hide from PAUSE
  PDL::Transform::Proj4::topocentric;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::topocentric::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Geocentric/Topocentric conversion";
    $self->{proj_code} = "topocentric";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::topocentric::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tpeqd
#
package # hide from PAUSE
  PDL::Transform::Proj4::tpeqd;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tpeqd::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Two Point Equidistant";
    $self->{proj_code} = "tpeqd";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lon_1 lat_2 lon_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tpeqd::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    tpers
#
package # hide from PAUSE
  PDL::Transform::Proj4::tpers;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tpers::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Tilted perspective";
    $self->{proj_code} = "tpers";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( tilt azi h ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::tpers::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    unitconvert
#
package # hide from PAUSE
  PDL::Transform::Proj4::unitconvert;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::unitconvert::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Unit conversion";
    $self->{proj_code} = "unitconvert";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::unitconvert::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    ups
#
package # hide from PAUSE
  PDL::Transform::Proj4::ups;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ups::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Universal Polar Stereographic";
    $self->{proj_code} = "ups";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( south ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::ups::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    urm5
#
package # hide from PAUSE
  PDL::Transform::Proj4::urm5;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::urm5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Urmaev V";
    $self->{proj_code} = "urm5";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( n q alpha ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::urm5::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    urmfps
#
package # hide from PAUSE
  PDL::Transform::Proj4::urmfps;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::urmfps::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Urmaev Flat-Polar Sinusoidal";
    $self->{proj_code} = "urmfps";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( n ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::urmfps::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    utm
#
package # hide from PAUSE
  PDL::Transform::Proj4::utm;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::utm::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Universal Transverse Mercator (UTM)";
    $self->{proj_code} = "utm";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( zone south approx ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::utm::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vandg
#
package # hide from PAUSE
  PDL::Transform::Proj4::vandg;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "van der Grinten (I)";
    $self->{proj_code} = "vandg";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vandg::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vandg2
#
package # hide from PAUSE
  PDL::Transform::Proj4::vandg2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "van der Grinten II";
    $self->{proj_code} = "vandg2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vandg2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vandg3
#
package # hide from PAUSE
  PDL::Transform::Proj4::vandg3;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "van der Grinten III";
    $self->{proj_code} = "vandg3";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vandg3::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vandg4
#
package # hide from PAUSE
  PDL::Transform::Proj4::vandg4;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "van der Grinten IV";
    $self->{proj_code} = "vandg4";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vandg4::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vertoffset
#
package # hide from PAUSE
  PDL::Transform::Proj4::vertoffset;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vertoffset::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Vertical Offset and Slope";
    $self->{proj_code} = "vertoffset";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 lon_0 dh slope_lat slope_lon ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vertoffset::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vgridshift
#
package # hide from PAUSE
  PDL::Transform::Proj4::vgridshift;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vgridshift::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Vertical grid shift";
    $self->{proj_code} = "vgridshift";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vgridshift::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    vitk1
#
package # hide from PAUSE
  PDL::Transform::Proj4::vitk1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vitk1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Vitkovsky I";
    $self->{proj_code} = "vitk1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::vitk1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag1
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner I (Kavrayskiy VI)";
    $self->{proj_code} = "wag1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag2
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner II";
    $self->{proj_code} = "wag2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag3
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag3;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner III";
    $self->{proj_code} = "wag3";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag3::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag4
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag4;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner IV";
    $self->{proj_code} = "wag4";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag4::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag5
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag5;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner V";
    $self->{proj_code} = "wag5";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag5::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag6
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag6;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag6::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner VI";
    $self->{proj_code} = "wag6";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag6::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wag7
#
package # hide from PAUSE
  PDL::Transform::Proj4::wag7;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag7::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Wagner VII";
    $self->{proj_code} = "wag7";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wag7::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    webmerc
#
package # hide from PAUSE
  PDL::Transform::Proj4::webmerc;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::webmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Web Mercator / Pseudo Mercator";
    $self->{proj_code} = "webmerc";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::webmerc::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    weren
#
package # hide from PAUSE
  PDL::Transform::Proj4::weren;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::weren::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Werenskiold I";
    $self->{proj_code} = "weren";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::weren::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wink1
#
package # hide from PAUSE
  PDL::Transform::Proj4::wink1;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wink1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Winkel I";
    $self->{proj_code} = "wink1";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wink1::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wink2
#
package # hide from PAUSE
  PDL::Transform::Proj4::wink2;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wink2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Winkel II";
    $self->{proj_code} = "wink2";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wink2::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    wintri
#
package # hide from PAUSE
  PDL::Transform::Proj4::wintri;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wintri::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Winkel Tripel";
    $self->{proj_code} = "wintri";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::wintri::new()...

1;
#line 570 "proj4.pd"

# Autogenerated code for the Proj4 projection code:
#    xyzgridshift
#
package # hide from PAUSE
  PDL::Transform::Proj4::xyzgridshift;
use strict;
use warnings;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::xyzgridshift::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    my $o = $_[0];
    unless( (ref $o) )
        { $o = {@_}; }
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
    $self->{name} = "Geocentric grid shift";
    $self->{proj_code} = "xyzgridshift";
    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    $self->update_proj_string();
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
    return $self;
} # End of PDL::Transform::xyzgridshift::new()...

1;
#line 657 "proj4.pd"


=head1 AUTHOR

Judd Taylor, Orbital Systems, Ltd.
judd dot t at orbitalsystems dot com

=cut
#line 18088 "Proj4.pm"

# Exit with OK status

1;
