/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.text.lookup.InetAddressStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InetAddressStringLookupLocalHostTest {
    @Test
    public void testAddress() throws UnknownHostException {
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)InetAddressStringLookup.LOCAL_HOST.lookup("address"));
    }

    @Test
    public void testBadKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> InetAddressStringLookup.LOCAL_HOST.lookup("FOO"));
    }

    @Test
    public void testCanonicalName() throws UnknownHostException {
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)InetAddressStringLookup.LOCAL_HOST.lookup("canonical-name"));
    }

    @Test
    public void testName() throws UnknownHostException {
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)InetAddressStringLookup.LOCAL_HOST.lookup("name"));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)InetAddressStringLookup.LOCAL_HOST.lookup(null));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)InetAddressStringLookup.LOCAL_HOST.toString().isEmpty());
    }
}

