package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFilteringAlgorithm invokes the airec.CreateFilteringAlgorithm API synchronously
func (client *Client) CreateFilteringAlgorithm(request *CreateFilteringAlgorithmRequest) (response *CreateFilteringAlgorithmResponse, err error) {
	response = CreateCreateFilteringAlgorithmResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFilteringAlgorithmWithChan invokes the airec.CreateFilteringAlgorithm API asynchronously
func (client *Client) CreateFilteringAlgorithmWithChan(request *CreateFilteringAlgorithmRequest) (<-chan *CreateFilteringAlgorithmResponse, <-chan error) {
	responseChan := make(chan *CreateFilteringAlgorithmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFilteringAlgorithm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFilteringAlgorithmWithCallback invokes the airec.CreateFilteringAlgorithm API asynchronously
func (client *Client) CreateFilteringAlgorithmWithCallback(request *CreateFilteringAlgorithmRequest, callback func(response *CreateFilteringAlgorithmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFilteringAlgorithmResponse
		var err error
		defer close(result)
		response, err = client.CreateFilteringAlgorithm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFilteringAlgorithmRequest is the request struct for api CreateFilteringAlgorithm
type CreateFilteringAlgorithmRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	DryRun     string `position:"Query" name:"dryRun"`
}

// CreateFilteringAlgorithmResponse is the response struct for api CreateFilteringAlgorithm
type CreateFilteringAlgorithmResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"requestId" xml:"requestId"`
	Result    ResultInCreateFilteringAlgorithm `json:"result" xml:"result"`
}

// CreateCreateFilteringAlgorithmRequest creates a request to invoke CreateFilteringAlgorithm API
func CreateCreateFilteringAlgorithmRequest() (request *CreateFilteringAlgorithmRequest) {
	request = &CreateFilteringAlgorithmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "CreateFilteringAlgorithm", "/v2/openapi/instances/[instanceId]/filtering-algorithms", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFilteringAlgorithmResponse creates a response to parse from CreateFilteringAlgorithm response
func CreateCreateFilteringAlgorithmResponse() (response *CreateFilteringAlgorithmResponse) {
	response = &CreateFilteringAlgorithmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
