package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptMergeRequest invokes the codeup.AcceptMergeRequest API synchronously
func (client *Client) AcceptMergeRequest(request *AcceptMergeRequestRequest) (response *AcceptMergeRequestResponse, err error) {
	response = CreateAcceptMergeRequestResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptMergeRequestWithChan invokes the codeup.AcceptMergeRequest API asynchronously
func (client *Client) AcceptMergeRequestWithChan(request *AcceptMergeRequestRequest) (<-chan *AcceptMergeRequestResponse, <-chan error) {
	responseChan := make(chan *AcceptMergeRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptMergeRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptMergeRequestWithCallback invokes the codeup.AcceptMergeRequest API asynchronously
func (client *Client) AcceptMergeRequestWithCallback(request *AcceptMergeRequestRequest, callback func(response *AcceptMergeRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptMergeRequestResponse
		var err error
		defer close(result)
		response, err = client.AcceptMergeRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptMergeRequestRequest is the request struct for api AcceptMergeRequest
type AcceptMergeRequestRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	MergeRequestId requests.Integer `position:"Path" name:"MergeRequestId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// AcceptMergeRequestResponse is the response struct for api AcceptMergeRequest
type AcceptMergeRequestResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateAcceptMergeRequestRequest creates a request to invoke AcceptMergeRequest API
func CreateAcceptMergeRequestRequest() (request *AcceptMergeRequestRequest) {
	request = &AcceptMergeRequestRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "AcceptMergeRequest", "/api/v3/projects/[ProjectId]/merge_request/[MergeRequestId]/accept", "", "")
	request.Method = requests.PUT
	return
}

// CreateAcceptMergeRequestResponse creates a response to parse from AcceptMergeRequest response
func CreateAcceptMergeRequestResponse() (response *AcceptMergeRequestResponse) {
	response = &AcceptMergeRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
