package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHotKeys invokes the das.DescribeHotKeys API synchronously
func (client *Client) DescribeHotKeys(request *DescribeHotKeysRequest) (response *DescribeHotKeysResponse, err error) {
	response = CreateDescribeHotKeysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHotKeysWithChan invokes the das.DescribeHotKeys API asynchronously
func (client *Client) DescribeHotKeysWithChan(request *DescribeHotKeysRequest) (<-chan *DescribeHotKeysResponse, <-chan error) {
	responseChan := make(chan *DescribeHotKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHotKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHotKeysWithCallback invokes the das.DescribeHotKeys API asynchronously
func (client *Client) DescribeHotKeysWithCallback(request *DescribeHotKeysRequest, callback func(response *DescribeHotKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHotKeysResponse
		var err error
		defer close(result)
		response, err = client.DescribeHotKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHotKeysRequest is the request struct for api DescribeHotKeys
type DescribeHotKeysRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	NodeId     string `position:"Query" name:"NodeId"`
}

// DescribeHotKeysResponse is the response struct for api DescribeHotKeys
type DescribeHotKeysResponse struct {
	*responses.BaseResponse
	Message   string                `json:"Message" xml:"Message"`
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Code      string                `json:"Code" xml:"Code"`
	Success   string                `json:"Success" xml:"Success"`
	Data      DataInDescribeHotKeys `json:"Data" xml:"Data"`
}

// CreateDescribeHotKeysRequest creates a request to invoke DescribeHotKeys API
func CreateDescribeHotKeysRequest() (request *DescribeHotKeysRequest) {
	request = &DescribeHotKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeHotKeys", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeHotKeysResponse creates a response to parse from DescribeHotKeys response
func CreateDescribeHotKeysResponse() (response *DescribeHotKeysResponse) {
	response = &DescribeHotKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
