package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssBuckets invokes the sgw.DescribeOssBuckets API synchronously
func (client *Client) DescribeOssBuckets(request *DescribeOssBucketsRequest) (response *DescribeOssBucketsResponse, err error) {
	response = CreateDescribeOssBucketsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssBucketsWithChan invokes the sgw.DescribeOssBuckets API asynchronously
func (client *Client) DescribeOssBucketsWithChan(request *DescribeOssBucketsRequest) (<-chan *DescribeOssBucketsResponse, <-chan error) {
	responseChan := make(chan *DescribeOssBucketsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssBuckets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssBucketsWithCallback invokes the sgw.DescribeOssBuckets API asynchronously
func (client *Client) DescribeOssBucketsWithCallback(request *DescribeOssBucketsRequest, callback func(response *DescribeOssBucketsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssBucketsResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssBuckets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssBucketsRequest is the request struct for api DescribeOssBuckets
type DescribeOssBucketsRequest struct {
	*requests.RpcRequest
	BucketEndpoint string `position:"Query" name:"BucketEndpoint"`
	SecurityToken  string `position:"Query" name:"SecurityToken"`
}

// DescribeOssBucketsResponse is the response struct for api DescribeOssBuckets
type DescribeOssBucketsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Success   bool    `json:"Success" xml:"Success"`
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	Buckets   Buckets `json:"Buckets" xml:"Buckets"`
}

// CreateDescribeOssBucketsRequest creates a request to invoke DescribeOssBuckets API
func CreateDescribeOssBucketsRequest() (request *DescribeOssBucketsRequest) {
	request = &DescribeOssBucketsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeOssBuckets", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOssBucketsResponse creates a response to parse from DescribeOssBuckets response
func CreateDescribeOssBucketsResponse() (response *DescribeOssBucketsResponse) {
	response = &DescribeOssBucketsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
