package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HoldCall invokes the ccc.HoldCall API synchronously
func (client *Client) HoldCall(request *HoldCallRequest) (response *HoldCallResponse, err error) {
	response = CreateHoldCallResponse()
	err = client.DoAction(request, response)
	return
}

// HoldCallWithChan invokes the ccc.HoldCall API asynchronously
func (client *Client) HoldCallWithChan(request *HoldCallRequest) (<-chan *HoldCallResponse, <-chan error) {
	responseChan := make(chan *HoldCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HoldCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HoldCallWithCallback invokes the ccc.HoldCall API asynchronously
func (client *Client) HoldCallWithCallback(request *HoldCallRequest, callback func(response *HoldCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HoldCallResponse
		var err error
		defer close(result)
		response, err = client.HoldCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HoldCallRequest is the request struct for api HoldCall
type HoldCallRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	DeviceId   string `position:"Query" name:"DeviceId"`
	JobId      string `position:"Query" name:"JobId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Music      string `position:"Query" name:"Music"`
	ChannelId  string `position:"Query" name:"ChannelId"`
}

// HoldCallResponse is the response struct for api HoldCall
type HoldCallResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateHoldCallRequest creates a request to invoke HoldCall API
func CreateHoldCallRequest() (request *HoldCallRequest) {
	request = &HoldCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "HoldCall", "", "")
	request.Method = requests.POST
	return
}

// CreateHoldCallResponse creates a response to parse from HoldCall response
func CreateHoldCallResponse() (response *HoldCallResponse) {
	response = &HoldCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
