package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSkillLevelsOfUser invokes the ccc.ListSkillLevelsOfUser API synchronously
func (client *Client) ListSkillLevelsOfUser(request *ListSkillLevelsOfUserRequest) (response *ListSkillLevelsOfUserResponse, err error) {
	response = CreateListSkillLevelsOfUserResponse()
	err = client.DoAction(request, response)
	return
}

// ListSkillLevelsOfUserWithChan invokes the ccc.ListSkillLevelsOfUser API asynchronously
func (client *Client) ListSkillLevelsOfUserWithChan(request *ListSkillLevelsOfUserRequest) (<-chan *ListSkillLevelsOfUserResponse, <-chan error) {
	responseChan := make(chan *ListSkillLevelsOfUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSkillLevelsOfUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSkillLevelsOfUserWithCallback invokes the ccc.ListSkillLevelsOfUser API asynchronously
func (client *Client) ListSkillLevelsOfUserWithCallback(request *ListSkillLevelsOfUserRequest, callback func(response *ListSkillLevelsOfUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSkillLevelsOfUserResponse
		var err error
		defer close(result)
		response, err = client.ListSkillLevelsOfUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSkillLevelsOfUserRequest is the request struct for api ListSkillLevelsOfUser
type ListSkillLevelsOfUserRequest struct {
	*requests.RpcRequest
	UserId        string           `position:"Query" name:"UserId"`
	IsMember      requests.Boolean `position:"Query" name:"IsMember"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SearchPattern string           `position:"Query" name:"SearchPattern"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListSkillLevelsOfUserResponse is the response struct for api ListSkillLevelsOfUser
type ListSkillLevelsOfUserResponse struct {
	*responses.BaseResponse
	Code           string                      `json:"Code" xml:"Code"`
	HttpStatusCode int                         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                      `json:"Message" xml:"Message"`
	RequestId      string                      `json:"RequestId" xml:"RequestId"`
	Data           DataInListSkillLevelsOfUser `json:"Data" xml:"Data"`
}

// CreateListSkillLevelsOfUserRequest creates a request to invoke ListSkillLevelsOfUser API
func CreateListSkillLevelsOfUserRequest() (request *ListSkillLevelsOfUserRequest) {
	request = &ListSkillLevelsOfUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListSkillLevelsOfUser", "", "")
	request.Method = requests.POST
	return
}

// CreateListSkillLevelsOfUserResponse creates a response to parse from ListSkillLevelsOfUser response
func CreateListSkillLevelsOfUserResponse() (response *ListSkillLevelsOfUserResponse) {
	response = &ListSkillLevelsOfUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
