package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelJob invokes the mts.CancelJob API synchronously
func (client *Client) CancelJob(request *CancelJobRequest) (response *CancelJobResponse, err error) {
	response = CreateCancelJobResponse()
	err = client.DoAction(request, response)
	return
}

// CancelJobWithChan invokes the mts.CancelJob API asynchronously
func (client *Client) CancelJobWithChan(request *CancelJobRequest) (<-chan *CancelJobResponse, <-chan error) {
	responseChan := make(chan *CancelJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelJobWithCallback invokes the mts.CancelJob API asynchronously
func (client *Client) CancelJobWithCallback(request *CancelJobRequest, callback func(response *CancelJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelJobResponse
		var err error
		defer close(result)
		response, err = client.CancelJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelJobRequest is the request struct for api CancelJob
type CancelJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobId                string           `position:"Query" name:"JobId"`
}

// CancelJobResponse is the response struct for api CancelJob
type CancelJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateCancelJobRequest creates a request to invoke CancelJob API
func CreateCancelJobRequest() (request *CancelJobRequest) {
	request = &CancelJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "CancelJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelJobResponse creates a response to parse from CancelJob response
func CreateCancelJobResponse() (response *CancelJobResponse) {
	response = &CancelJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
