/*
  Build : gcc -o beep beep.c
  Call  : beep [freq] [duration] 
    e.g.  beep 444 333
*/ 

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <linux/kd.h>
#include <unistd.h>
#include <string.h>

int beep(int freq, int duration)
{
   int fd = open("/dev/console", O_WRONLY);
   if (fd==-1) {
     perror("/dev/console");
     return 1;
   }
   char szBuf[64]; 
   snprintf(szBuf,sizeof(szBuf),"\033[10;%d]\033[11;%d]\07\033[10]\033[11]",freq,duration);
   write(fd,szBuf,strlen(szBuf));
   usleep(duration*1000);
   return 0;
}

int main(int argc, char *argv[])
{
    if (argc != 3) { printf("bad\n");return -1;}
    return  beep(atoi(argv[1]),atoi(argv[2]));
}
