/**
 *  beep plugin for the Video Disk Recorder 
 *
 *  menu.c  -  setup menu class
 *
 *  (c) 2004 - 2008 Andreas Brachold <vdr07 AT deltab de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */

#include "menu.h"

cSetupMenuNotifyBeep::cSetupMenuNotifyBeep()
{
  static const char allowed[] = { "abcdefghijklmnopqrstuvwxyz0123456789-_/" };

  newNotifyBeepSetup = NotifyBeepSetup;

  Add(new cMenuEditBoolItem( tr("Setup.Beep$Plugin active"),           &newNotifyBeepSetup.active, trVDR("no"), trVDR("yes")));
  Add(new cMenuEditIntItem ( tr("Setup.Beep$Audio frequency [Hz]"),    &newNotifyBeepSetup.freq, NotifyBeepSetup.freq_min,NotifyBeepSetup.freq_max));
  Add(new cMenuEditIntItem ( tr("Setup.Beep$Audio duration [ms]"),     &newNotifyBeepSetup.duration, NotifyBeepSetup.duration_min,NotifyBeepSetup.duration_max));
  Add(new cMenuEditStrItem ( tr("Setup.Beep$Output console"), 		   newNotifyBeepSetup.console, sizeof(newNotifyBeepSetup.console), allowed));
  Add(new cMenuEditBoolItem( tr("Setup.Beep$Beep before shutdown"),    &newNotifyBeepSetup.onshutdown, trVDR("no"), trVDR("yes")));
  Add(new cMenuEditBoolItem( tr("Setup.Beep$Beep after cutting process"), &newNotifyBeepSetup.oneditprocess, trVDR("no"), trVDR("yes")));
  Add(new cMenuEditBoolItem( tr("Setup.Beep$Beep on any message"),        &newNotifyBeepSetup.onanymessage, trVDR("no"), trVDR("yes")));
}

void cSetupMenuNotifyBeep::Store()
{
  NotifyBeepSetup = newNotifyBeepSetup;
  SetupStore("active",        NotifyBeepSetup.active);
  SetupStore("freq",          NotifyBeepSetup.freq);
  SetupStore("duration",      NotifyBeepSetup.duration);
  SetupStore("console",       NotifyBeepSetup.console);
  SetupStore("onshutdown",    NotifyBeepSetup.onshutdown);
  SetupStore("oneditprocess", NotifyBeepSetup.oneditprocess);
  SetupStore("onanymessage",  NotifyBeepSetup.onanymessage);
}
