  TITLE 'str-001-srst.asm: Test SRST Instruction'
*
*Testcase str-001-srst
*  Test cases for variations on the SRST (Search String) instruction.
*
***********************************************************************
*
*                        str-001-srst.asm
*
* Created and placed into public domain 2018-12-27 by Bob Polmanter.
* Remove runtest *Compare dependency on 2022-03-08 by Fish
*
* The SRSTT instruction is tested against the definition in the
* z/ArchitecturePrinciples of Operation, SA22-7832.
*
* Test data is assembled into this program, and some test data is
* generated by this program. The program itself verifies the resulting
* status of registers and condition codes via simple CLC comparison.
*
***********************************************************************
*
* Tests performed with SRST (Search String):
*
* 1.  R0 bits 32-55 non-zero gives PIC06
* 2.  Search char found; no operands cross page boundary
* 3.  Search char not found; no operands cross page boundary
* 4.  Search char found; operands 1&2 are equal (1 byte search)
* 5.  Search char not found; operands 1&2 are equal (1 byte search)
* 6.  Search char found; Operand 1 crosses page boundary
* 7.  Search char not found; Operand 1 crosses page boundary
* 8.  Search char found; large multi-page search
* 9.  Search char not found; large multi-page search
*
*
* NOTE - the nature of the string instructions is such that this test
*        case will only validate properly for the string instruction
*        improvement modifications committed in December 2018.  The
*        computation of the CPU determined number of bytes is an
*        unpredictable number on real hardware (at least above the
*        minimum value) and the method used in Hercules prior to
*        instruction improvements calculated it differently than the
*        improved method.  As a result, the operand registers will
*        likely contain different values when compared by the test
*        script due to the different CPU number of bytes
*        determined.  None of the methods are wrong, and failing
*        results in the test script are not necessarily wrong.
*        But this program and the resulting test script comparisons
*        were written for the method used by the improved string
*        instructions (CLST, MVST, SRST).
*
*
***********************************************************************
*
*
SRST001  START 0
STRTLABL EQU   *
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
*
*
         USING *,R15
*
* Selected z/Arch low core layout
*
         ORG   STRTLABL+X'8C'      Program check interrution code
PGMINTC  DS    F
*
PGMOPSW  EQU   STRTLABL+X'150'     z/Arch Program check old PSW
*
         ORG   STRTLABL+X'1A0'     z/Arch Restart PSW
         DC    X'0000000180000000',A(0,START)
*
         ORG   STRTLABL+X'1D0'     z/Arch Program check new PSW
PGMNPSW  DC    X'0000000180000000',A(0,PROGCHK)
*
* Program check routine.  We are looking for a single specification
* exeception.  Any other program check is not expected to occur and
* results in a hard wait.
*
         ORG   STRTLABL+X'200'
PROGCHK  DS    0H               Program check occured...
         CLI   DIDTHIS,X'00'    First/only time here?
         BNE   FAIL             No?! Then something is wrong!
         CLI   PGMINTC+3,X'06'  Specification Exception?
         BNE   FAIL             No?! Then something is wrong!
         MVI   DIDTHIS,X'FF'    Remember we did this once already
         B     CONTINUE         Continue, as this is expected (once!)
FAIL     LPSWE FAILPSW          Unexpected PIC, disabled wait
DIDTHIS  DC    X'00'            X'FF' == we already did this
         EJECT
***********************************************************************
*
*  Main program.
*
START    DS    0H
*
**********
* PREP   * Prepare a multi-page frame area
**********
*
         LM    R2,R5,AREA              -> large area and length
         MVCL  R2,R4                   Pad it full of X'AA'
*
**********
* TEST 1 * Ensure any non-zero bits in R0 bits 32-55 gives PIC 06
**********
*
         LA    R0,X'400'               Set invalid termination char
         LM    R5,R7,TEST1             Get string area ptrs
         SRST  R7,R6                   Attempt a SRST, should get PIC 6
*
CONTINUE EQU   *
         CLI   DIDTHIS,X'FF'           Did PIC 06 happen?
         BNE   FAIL                    No?! Then something is wrong!
         MVC   PGMNPSW,FAILPSW         All other p checks should halt
*
**********
* TEST 2 * Search char found; no operands cross page boundary
**********
*
         LM    R5,R7,TEST2             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT2           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 3 * Search char not found; no operands cross page boundary
**********
*
         LM    R5,R7,TEST3             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT3           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 4 * Search char found; operands contain equal addresses
**********
*
         LM    R5,R7,TEST4             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT4           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 5 * Search char not found; operands contain equal addresses
**********
*
         LM    R5,R7,TEST5             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT5           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 6 * Search char found; Operand 1 crosses page boundary
**********
*
         LM    R5,R7,TEST6             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT6           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 7 * Search char not found; Operand 1 crosses page boundary
**********
*
         LM    R5,R7,TEST7             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT7           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 8 * Search char found; large multi-page search
**********
*
         LM    R5,R7,TEST8             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT8           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**********
* TEST 9 * Search char not found; large multi-page search
**********
*
         LM    R5,R7,TEST9             Get string area ptrs
         MVI   0(R5),C'$'              Set search char
         BAS   R9,SEARCH               search the string
         STM   R6,R8,RESULT9           Save test result regs
         MVI   0(R5),X'AA'             Reset the search char
*
**       Verify results...
*
         CLC   GRESLT2,RESULT2        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT3,RESULT3        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT4,RESULT4        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT5,RESULT5        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT6,RESULT6        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT7,RESULT7        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT8,RESULT8        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
         CLC   GRESLT9,RESULT9        Expected results?
         BNE   FAIL                   No?! Then something is wrong!
*
         LPSWE GOODPSW                 EOJ, load disabled wait PSW
*
*-- SRST routine used by tests
*
SEARCH   EQU   *
         LA    R0,C'$'                 Load search character
         SR    R8,R8                   Init SRST counter
*
INVOKE   EQU   *
         SRST  R7,R6                   Look for search char
         LA    R8,1(,R8)               Count executions of SRST
         BC    8,BADCC                 CC=0 SHOULD NEVER HAPPEN
         BC    1,INVOKE                Restart the search
         IPM   R8                      Put final CC in high R8
         BR    R9                      Return
*
BADCC    LPSWE BADCCPSW                Stop on invalid CC
*
         DS    0D             Ensure correct alignment for psw
GOODPSW  DC    X'0002000000000000',A(0,0) Normal end - disabled wait
FAILPSW  DC    X'0002000000000000',XL4'00',X'0000DEAD' Abnormal end
BADCCPSW DC    X'0002000000000000',XL4'00',X'000BADCC' Abnormal end
*
*
GRESLT2  DC    XL12'000025000000253210000001'
GRESLT3  DC    XL12'000025000000258020000001'
GRESLT4  DC    XL12'000025000000250020000001'
GRESLT5  DC    XL12'000025000000250020000001'
GRESLT6  DC    XL12'000030800000310010000002'
GRESLT7  DC    XL12'000030800000330020000002'
GRESLT8  DC    XL12'0000B0000000BF801000000A'
GRESLT9  DC    XL12'0000B0000000BFFF2000000A'
*
*
*
         ORG   STRTLABL+X'700'
*
AREA     DC    X'00002000'             -> start of multi-page area
AREALEN  DC    A(4096*16)              Size of multi=page area
ZERO     DC    A(0)
PAD      DC    X'AA000000'             MVCL pad char
*
TEST1    DS    0F                      Test should fail PIC06
         DC    X'00002532'             -> where to place search char
         DC    X'00002500'             -> where to start search
         DC    X'00002580'             -> end of search area
*
TEST2    DS    0F                      Op 1 doesnt cross page
         DC    X'00002532'             -> where to place search char
         DC    X'00002500'             -> where to start search
         DC    X'00002580'             -> end of search area
*
TEST3    DS    0F                      Op 1 doesnt cross page
         DC    X'00001000'             -> search char outside of area
         DC    X'00002500'             -> where to start search
         DC    X'00002580'             -> end of search area
*
TEST4    DS    0F                      Op 1&2 are equal, search ok
         DC    X'00002500'             -> where to place search char
         DC    X'00002500'             -> where to start search
         DC    X'00002500'             -> end of search area
*
TEST5    DS    0F                      Op 1&2 are equal, search fails
         DC    X'00001000'             -> search char outside of area
         DC    X'00002500'             -> where to start search
         DC    X'00002500'             -> end of search area
*
TEST6    DS    0F                      Op 1 crosses page; search ok
         DC    X'00003100'             -> where to place search char
         DC    X'00002F80'             -> where to start search
         DC    X'00003300'             -> end of search area
*
TEST7    DS    0F                      Op 1 crosses page, search fails
         DC    X'00001000'             -> search char outside of area
         DC    X'00002F80'             -> where to start search
         DC    X'00003300'             -> end of search area
*
TEST8    DS    0F                      large multi-page; search ok
         DC    X'0000BF80'             -> where to place search char
         DC    X'00002100'             -> where to start search
         DC    X'0000BFFF'             -> end of search area
*
TEST9    DS    0F                      large multi-page, search fails
         DC    X'00001000'             -> search char outside of area
         DC    X'00002100'             -> where to start search
         DC    X'0000BFFF'             -> end of search area
*
*
*  Locations for results
*
* Result fields are kept on 16-byte boundaries to more easily
* track their assembled offsets for use in the .tst script.
*
*                              offset
         ORG   STRTLABL+X'800'   8xx
RESULT2  DS    4F                 00   Register results test 2
RESULT3  DS    4F                 10   Register results test 3
RESULT4  DS    4F                 20   Register results test 4
RESULT5  DS    4F                 30   Register results test 5
RESULT6  DS    4F                 40   Register results test 6
RESULT7  DS    4F                 50   Register results test 7
RESULT8  DS    4F                 60   Register results test 8
RESULT9  DS    4F                 70   Register results test 9
*
         END
