package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CertificatePublicKeyVerify invokes the kms.CertificatePublicKeyVerify API synchronously
func (client *Client) CertificatePublicKeyVerify(request *CertificatePublicKeyVerifyRequest) (response *CertificatePublicKeyVerifyResponse, err error) {
	response = CreateCertificatePublicKeyVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// CertificatePublicKeyVerifyWithChan invokes the kms.CertificatePublicKeyVerify API asynchronously
func (client *Client) CertificatePublicKeyVerifyWithChan(request *CertificatePublicKeyVerifyRequest) (<-chan *CertificatePublicKeyVerifyResponse, <-chan error) {
	responseChan := make(chan *CertificatePublicKeyVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CertificatePublicKeyVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CertificatePublicKeyVerifyWithCallback invokes the kms.CertificatePublicKeyVerify API asynchronously
func (client *Client) CertificatePublicKeyVerifyWithCallback(request *CertificatePublicKeyVerifyRequest, callback func(response *CertificatePublicKeyVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CertificatePublicKeyVerifyResponse
		var err error
		defer close(result)
		response, err = client.CertificatePublicKeyVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CertificatePublicKeyVerifyRequest is the request struct for api CertificatePublicKeyVerify
type CertificatePublicKeyVerifyRequest struct {
	*requests.RpcRequest
	MessageType    string `position:"Query" name:"MessageType"`
	CertificateId  string `position:"Query" name:"CertificateId"`
	Message        string `position:"Query" name:"Message"`
	SignatureValue string `position:"Query" name:"SignatureValue"`
	Algorithm      string `position:"Query" name:"Algorithm"`
}

// CertificatePublicKeyVerifyResponse is the response struct for api CertificatePublicKeyVerify
type CertificatePublicKeyVerifyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	CertificateId  string `json:"CertificateId" xml:"CertificateId"`
	SignatureValid bool   `json:"SignatureValid" xml:"SignatureValid"`
}

// CreateCertificatePublicKeyVerifyRequest creates a request to invoke CertificatePublicKeyVerify API
func CreateCertificatePublicKeyVerifyRequest() (request *CertificatePublicKeyVerifyRequest) {
	request = &CertificatePublicKeyVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "CertificatePublicKeyVerify", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCertificatePublicKeyVerifyResponse creates a response to parse from CertificatePublicKeyVerify response
func CreateCertificatePublicKeyVerifyResponse() (response *CertificatePublicKeyVerifyResponse) {
	response = &CertificatePublicKeyVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
